// CAS: "1.0.0"
// This software uses the following Open Source software:
// - a simplified (and thus modified) version of stringencoding
//	* Licensed under Apache License 2.0 and Unlicense (can be found here: http://www.apache.org/licenses/, http://unlicense.org/)
//	* Source: https://github.com/inexorabletash/text-encoding
// - requestAnimationFrame polyfill by Erik Möller. fixes from Paul Irish and Tino Zijdel
//	* MIT license
//	* Source: https://gist.github.com/paulirish/1579671
// - a simplified (and thus modified) version of the Microsoft Research JavaScript Cryptography Library (msrCrypto) 
//	* Licensed under Apache License 2.0 (can be found here: http://www.apache.org/licenses/LICENSE-2.0)
//	* Source: https://github.com/microsoft/MSR-JavaScript-Cryptovar q,na,oa;
(function(){function a(ca){var da=0;this.get=function(){return da>=ca.length?-1:Number(ca[da])};this.offset=function(ea){da+=ea;if(0>da)throw Error("Seeking past start of the buffer");if(da>ca.length)throw Error("Seeking past EOF");}}function b(ca){var da=0;this.get=function(){return da>=ca.length?-1:ca[da]};this.offset=function(ea){da+=ea;if(0>da)throw Error("Seeking past start of the buffer");if(da>ca.length)throw Error("Seeking past EOF");}}function c(ca){var da=0;this.h=function(ea){var ba=-1,
Aa;for(Aa=0;Aa<arguments.length;++Aa)ba=Number(arguments[Aa]),ca[da++]=ba;return ba}}function d(ca){var da=0,ea=function(){for(var ba=[],Aa=0,qb=ca.length;Aa<ca.length;){var Ia=ca.charCodeAt(Aa);if(55296<=Ia&&57343>=Ia)if(56320<=Ia&&57343>=Ia)ba.push(65533);else if(Aa===qb-1)ba.push(65533);else{var xa=ca.charCodeAt(Aa+1);56320<=xa&&57343>=xa?(Ia&=1023,xa&=1023,Aa+=1,ba.push(65536+(Ia<<10)+xa)):ba.push(65533)}else ba.push(Ia);Aa+=1}return ba}();this.offset=function(ba){da+=ba;if(0>da)throw Error("Seeking past start of the buffer");
if(da>ea.length)throw Error("Seeking past EOF");};this.get=function(){return da>=ea.length?-1:ea[da]}}function e(){var ca="";this.l=function(){return ca};this.h=function(da){65535>=da?ca+=String.fromCharCode(da):(da-=65536,ca+=String.fromCharCode(55296+(da>>10&1023)),ca+=String.fromCharCode(56320+(da&1023)))}}function f(ca,da){if(ca)throw Error("EncodingError");return da||65533}function g(){throw Error("EncodingError");}function k(ca){ca=String(ca).trim().toLowerCase();if(Object.prototype.hasOwnProperty.call(va,
ca))return va[ca];throw Error("EncodingError: Unknown encoding: "+ca);}function l(ca){var da=ca.fatal,ea=0,ba=0,Aa=0,qb=0;this.decode=function(Ia){var xa=Ia.get();if(-1===xa)return 0!==ba?f(da):-1;Ia.offset(1);if(0===ba){if(0<=xa&&127>=xa)return xa;if(194<=xa&&223>=xa)ba=1,qb=128,ea=xa-192;else if(224<=xa&&239>=xa)ba=2,qb=2048,ea=xa-224;else if(240<=xa&&244>=xa)ba=3,qb=65536,ea=xa-240;else return f(da);ea*=Math.pow(64,ba);return null}if(!(128<=xa&&191>=xa))return qb=Aa=ba=ea=0,Ia.offset(-1),f(da);
Aa+=1;ea+=(xa-128)*Math.pow(64,ba-Aa);if(Aa!==ba)return null;Ia=ea;xa=qb;qb=Aa=ba=ea=0;return xa<=Ia&&1114111>=Ia&&!(55296<=Ia&&57343>=Ia)?Ia:f(da)}}function E(){this.encode=function(ca,da){var ea=da.get();if(-1===ea)return-1;da.offset(1);if(55296<=ea&&57343>=ea)return g(ea);if(0<=ea&&127>=ea)return ca.h(ea);if(128<=ea&&2047>=ea){var ba=1;var Aa=192}else 2048<=ea&&65535>=ea?(ba=2,Aa=224):65536<=ea&&1114111>=ea&&(ba=3,Aa=240);for(da=ca.h(Math.floor(ea/Math.pow(64,ba))+Aa);0<ba;)da=ca.h(128+Math.floor(ea/
Math.pow(64,ba-1))%64),--ba;return da}}function u(ca,da){var ea=da.fatal;this.decode=function(ba){var Aa=ba.get();if(-1===Aa)return-1;ba.offset(1);if(0<=Aa&&127>=Aa)return Aa;ba=ca[Aa-128];return null===ba?f(ea):ba}}function ka(ca){this.encode=function(da,ea){var ba=ea.get();if(-1===ba)return-1;ea.offset(1);if(0<=ba&&127>=ba)return da.h(ba);ea=ca.indexOf(ba);ea=-1===ea?null:ea;null===ea&&g(ba);return da.h(ea+128)}}var ja={},va={};[{encodings:[{labels:"csisolatin2 iso-8859-2 iso-ir-101 iso8859-2 iso_8859-2 l2 latin2".split(" "),
name:"iso-8859-2"},{labels:"csisolatin3 iso-8859-3 iso_8859-3 iso-ir-109 l3 latin3".split(" "),name:"iso-8859-3"},{labels:"csisolatin4 iso-8859-4 iso_8859-4 iso-ir-110 l4 latin4".split(" "),name:"iso-8859-4"},{labels:["csisolatincyrillic","cyrillic","iso-8859-5","iso_8859-5","iso-ir-144"],name:"iso-8859-5"},{labels:"arabic csisolatinarabic ecma-114 iso-8859-6 iso_8859-6 iso-ir-127".split(" "),name:"iso-8859-6"},{labels:"csisolatingreek ecma-118 elot_928 greek greek8 iso-8859-7 iso_8859-7 iso-ir-126".split(" "),
name:"iso-8859-7"},{labels:"csisolatinhebrew hebrew iso-8859-8 iso-8859-8-i iso-ir-138 iso_8859-8 visual".split(" "),name:"iso-8859-8"},{labels:"csisolatin6 iso-8859-10 iso-ir-157 iso8859-10 l6 latin6".split(" "),name:"iso-8859-10"},{labels:["iso-8859-13"],name:"iso-8859-13"},{labels:["iso-8859-14","iso8859-14"],name:"iso-8859-14"},{labels:["iso-8859-15","iso_8859-15"],name:"iso-8859-15"},{labels:["iso-8859-16"],name:"iso-8859-16"},{labels:"ascii ansi_x3.4-1968 csisolatin1 iso-8859-1 iso8859-1 iso_8859-1 l1 latin1 us-ascii windows-1252".split(" "),
name:"windows-1252"},{labels:["unicode-1-1-utf-8","utf-8","utf8"],name:"utf-8"}],heading:"Legacy single-byte encodings"}].forEach(function(ca){ca.encodings.forEach(function(da){ja[da.name]=da;da.labels.forEach(function(ea){va[ea]=da})})});var Xa={"iso-8859-2":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,728,321,164,317,346,167,168,352,350,356,377,173,381,379,176,261,731,322,180,318,347,711,184,353,351,357,
378,733,382,380,340,193,194,258,196,313,262,199,268,201,280,203,282,205,206,270,272,323,327,211,212,336,214,215,344,366,218,368,220,221,354,223,341,225,226,259,228,314,263,231,269,233,281,235,283,237,238,271,273,324,328,243,244,337,246,247,345,367,250,369,252,253,355,729],"iso-8859-3":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,294,728,163,164,null,292,167,168,304,350,286,308,173,null,379,176,295,178,179,180,
181,293,183,184,305,351,287,309,189,null,380,192,193,194,null,196,266,264,199,200,201,202,203,204,205,206,207,null,209,210,211,212,288,214,215,284,217,218,219,220,364,348,223,224,225,226,null,228,267,265,231,232,233,234,235,236,237,238,239,null,241,242,243,244,289,246,247,285,249,250,251,252,365,349,729],"iso-8859-4":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,312,342,164,296,315,167,168,352,274,290,358,173,
381,175,176,261,731,343,180,297,316,711,184,353,275,291,359,330,382,331,256,193,194,195,196,197,198,302,268,201,280,203,278,205,206,298,272,325,332,310,212,213,214,215,216,370,218,219,220,360,362,223,257,225,226,227,228,229,230,303,269,233,281,235,279,237,238,299,273,326,333,311,244,245,246,247,248,371,250,251,252,361,363,729],"iso-8859-5":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,1025,1026,1027,1028,1029,1030,
1031,1032,1033,1034,1035,1036,173,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,8470,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,167,1118,1119],"iso-8859-6":[128,129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,null,null,null,164,null,null,null,null,null,null,null,1548,173,null,null,null,null,null,null,null,null,null,null,null,null,null,1563,null,null,null,1567,null,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,null,null,null,null,null,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,null,
null,null,null,null,null,null,null,null,null,null,null,null],"iso-8859-7":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,8216,8217,163,8364,8367,166,167,168,169,890,171,172,173,null,8213,176,177,178,179,900,901,902,183,904,905,906,187,908,189,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,null,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,
953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,null],"iso-8859-8":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,null,162,163,164,165,166,167,168,169,215,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,247,187,188,189,190,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,8215,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,null,null,8206,8207,null],"iso-8859-10":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,274,290,298,296,310,167,315,272,352,358,381,173,362,330,176,261,275,291,299,297,311,183,316,273,353,359,382,8213,363,331,256,193,194,195,196,197,198,302,268,201,280,
203,278,205,206,207,208,325,332,211,212,213,214,360,216,370,218,219,220,221,222,223,257,225,226,227,228,229,230,303,269,233,281,235,279,237,238,239,240,326,333,243,244,245,246,361,248,371,250,251,252,253,254,312],"iso-8859-13":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,8221,162,163,164,8222,166,167,216,169,342,171,172,173,174,198,176,177,178,179,8220,181,182,183,248,185,343,187,188,189,190,230,260,302,256,262,
196,197,280,274,268,201,377,278,290,310,298,315,352,323,325,211,332,213,214,215,370,321,346,362,220,379,381,223,261,303,257,263,228,229,281,275,269,233,378,279,291,311,299,316,353,324,326,243,333,245,246,247,371,322,347,363,252,380,382,8217],"iso-8859-14":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,7682,7683,163,266,267,7690,167,7808,169,7810,7691,7922,173,174,376,7710,7711,288,289,7744,7745,182,7766,7809,7767,
7811,7776,7923,7812,7813,7777,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,372,209,210,211,212,213,214,7786,216,217,218,219,220,221,374,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,373,241,242,243,244,245,246,7787,248,249,250,251,252,253,375,255],"iso-8859-15":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,8364,165,352,167,353,169,170,171,172,173,174,175,176,
177,178,179,381,181,182,183,382,185,186,187,338,339,376,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255],"iso-8859-16":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,261,321,8364,8222,352,167,353,169,
536,171,377,173,378,379,176,177,268,322,381,8221,182,183,382,269,537,187,338,339,376,380,192,193,194,258,196,262,198,199,200,201,202,203,204,205,206,207,272,323,210,211,212,336,214,346,368,217,218,219,220,280,538,223,224,225,226,259,228,263,230,231,232,233,234,235,236,237,238,239,273,324,242,243,244,337,246,347,369,249,250,251,252,281,539,255],"windows-1252":[8364,129,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,141,381,143,144,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,157,382,
376,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255]};ja["utf-8"].eC=function(ca){return new E(ca)};ja["utf-8"].dC=function(ca){return new l(ca)};(function(){"iso-8859-2 iso-8859-3 iso-8859-4 iso-8859-5 iso-8859-6 iso-8859-7 iso-8859-8 iso-8859-10 iso-8859-13 iso-8859-14 iso-8859-15 iso-8859-16 windows-1252".split(" ").forEach(function(ca){var da=
ja[ca],ea=Xa[ca];da.dC=function(ba){return new u(ea,ba)};da.eC=function(ba){return new ka(ea,ba)}})})();oa=function(ca){ca=ca?String(ca):"utf-8";var da=Object(da);this.Ek=k(ca);this.qt=!1;this.Ji=null;this.Ms={fatal:!!da.fatal};Object.defineProperty&&Object.defineProperty(this,"encoding",{get:function(){return this.Ek.name}});return this};oa.prototype={encode:function(ca,da){ca=ca?String(ca):"";da=Object(da);this.qt||(this.Ji=this.Ek.eC(this.Ms));this.qt=!!da.stream;da=[];var ea=new c(da);for(ca=
new d(ca);-1!==ca.get();)this.Ji.encode(ea,ca);if(!this.qt){do var ba=this.Ji.encode(ea,ca);while(-1!==ba);this.Ji=null}return new Uint8Array(da)}};na=function(ca){ca=ca?String(ca):"utf-8";var da=Object(da);this.Ek=k(ca);this.Ms={fatal:!!da.fatal};this.Cb=this.Ek.dC(this.Ms);Object.defineProperty&&Object.defineProperty(this,"encoding",{get:function(){return this.Ek.name}});return this};na.prototype={decode:function(ca){if(ca&&!("buffer"in ca&&"byteOffset"in ca&&"byteLength"in ca))throw new TypeError("Expected ArrayBufferView");
ca=new Uint8Array(ca.buffer,ca.byteOffset,ca.byteLength);return this.Rx(new a(ca))},mO:function(ca){if(!ca)throw new TypeError("Expected array of bytes");return this.Rx(new b(ca))},Rx:function(ca){for(var da=new e,ea;-1!==ca.get();)ea=this.Cb.decode(ca),null!==ea&&-1!==ea&&da.h(ea);return da.l()}}})();
(function(a,b){void 0!==window.Promise&&("function"===typeof define&&define.UT?define([],function(){return a.msrCrypto=b(a)}):"object"===typeof exports?module.exports=b(a):a.msrCrypto=b(a))})(this,function(a){a=a||{};return function(){function b(h,p,A){function R(){if(!A||!A.Yd)throw Error("missing hash function");}var F=c(h);if(!p)throw Error("padding mode");var t=null,m=null;switch(p){case "RSAES-PKCS1-V1_5":h=bc.AU(h);break;case "RSASSA-PKCS1-V1_5":R();h=bc.BU(h,A);break;case "RSA-OAEP":R();h=
bc.cQ(h,A);break;case "RSA-PSS":R();h=bc.DU(h,A);break;case "raw":h={Hp:function(r){return r},Zp:function(r){return r}};break;default:throw Error("invalid mode");}h&&(t=h.Hp||h.sign,m=h.Zp||h.verify);return{encrypt:function(r,y){r=null!==t?t(r,y):r.slice();return F.encrypt(r)},decrypt:function(r,y){r=F.decrypt(r);if(null!==m){r=m(r,y);if(!1===r.valid)throw Error("OperationError");r=r.data}else r=r.slice(0);return r},WS:function(r,y,C){return F.decrypt(t(r,y,C))},wT:function(r,y,C){r=F.encrypt(r);
return m(r,y,C)},Pl:function(r){genRsaKeyFromRandom(r)},mode:p}}function c(h){function p(r){r=la.OB(r);R.iQ(r,0,m);return r}function A(r,y,C){y=la.Kh(y);C=la.tF(C);r=C.fO(r);return C.TP(r,y).$a}var R=ba,F=h.hasOwnProperty("n")&&h.hasOwnProperty("d"),t=h.hasOwnProperty("p")&&h.hasOwnProperty("q"),m=h.n.length;return{encrypt:function(r){return p(A(r,h.e,h.n,!0))},decrypt:function(r){if(t){var y=la.Kh,C=h.q,M=h.dp,B=h.dq,v=h.qi,G=y(h.p);C=y(C);var H=Array(G.length+C.length),O=Array(G.length+1),U=Array(C.length+
1);r=y(r);var ia=la.fi,Z=new ia(h.$t?void 0:G,h.$t);ia=new ia(h.au?void 0:C,h.au);Z.reduce(r,H);Z.Mj(H,y(M),O);ia.reduce(r,H);ia.Mj(H,y(B),U);M=la.Xc(O,U,H);0!==M&&la.Xc(U,O,H);la.XC(H,y(v),G,r);0!==M&&la.Xc(G,r,r);la.multiply(r,C,H);la.add(U,H,O);return p(O)}if(F)return y=A(r,h.d,h.n),p(y);throw Error("missing private key");}}}function d(h){function p(X,x){for(var n=Math.floor(x.length/16),z,w=0;w<n;w++){z=x.slice(16*w,16*w+16);var K;z=r.cf(O,z);var S=X;var W=r.xc(16),T=S.slice(0);for(S=0;128>S;S++){var L=
-(z[Math.floor(S/8)]>>7-S%8&1)&255;for(K=0;16>K;K++)W[K]^=T[K]&L;L=-(T[15]&1)&255;K=T;for(var P=K.length-1;0<P;P--)K[P]=(K[P-1]&1)<<7|K[P]>>>1;K[0]>>>=1;T[0]^=225&L}O=W}U=x.slice(16*n);return O}function A(){var X=16*Math.ceil(ma/16)-ma,x=t(8*M.length),n=t(8*ma);X=U.concat(r.xc(X)).concat(x).concat(n);return p(H,X)}function R(X){for(var x=256,n=1;4>=n;n++)x=(x>>>8)+X[X.length-n],X[X.length-n]=x&255;return X}function F(X,x){var n=Math.ceil(x.length/16),z=[];Z!==X&&(Z=X.slice());for(var w=0;w<n;w++){X=
x.slice(16*w,16*w+16);var K=h.encrypt(Z.slice());z=z.concat(r.cf(X,K));Z=R(Z)}return z}function t(X){return[0,0,0,0,X>>>24&255,X>>>16&255,X>>>8&255,X&255]}function m(){ma=0;y=[];ia=[];O=r.xc(16);U=[];Z=C=M=null}var r=ba,y=[],C,M,B,v,G,H=h.encrypt(r.xc(16)),O=r.xc(16),U=[],ia=[],Z,ma=0;return{xd:function(X,x,n){M=x||[];B=isNaN(n)?128:n;if(0!==B%8)throw Error("DataError");C=X;12===C.length?v=C.concat([0,0,0,1]):(v=p(H,C.concat(r.xc(16*Math.ceil(C.length/16)-C.length+8)).concat(t(8*C.length))),O=r.xc(16));
G=R(v.slice());p(H,M.concat(r.xc(16*Math.ceil(M.length/16)-M.length)))},encrypt:function(X){ma=X.length;X=F(G,X);p(H,X);var x=A();x=F(v,x).slice(0,B/8);m();return X.slice().concat(x)},decrypt:function(X,x){ma=X.length;var n=F(G,X);p(H,X);X=A();X=F(v,X).slice(0,B/8);m();return r.Jl(X,x)?n:null},Lu:function(X){y=y.concat(X);X=y.slice(0,16*Math.floor(y.length/16));ma+=X.length;y=y.slice(X.length);X=F(Z||G,X);ia=ia.concat(X);p(H,X)},Jp:function(X){y=y.concat(X);X=y.slice(0,16*Math.floor((y.length-B/8)/
16));ma+=X.length;y=y.slice(X.length);var x=F(Z||G,X);ia=ia.concat(x);p(H,X)},lp:function(){var X=F(Z,y);ia=ia.concat(X);ma+=y.length;X=A();X=F(v,X).slice(0,B/8);X=ia.slice().concat(X);m();return X},kp:function(){var X=Math.floor(B/8),x=y.slice(-X);y=y.slice(0,y.length-X);X=F(Z,y);ia=ia.concat(X);ma+=y.length;X=A();X=F(v,X).slice(0,B/8);var n=ia.slice();m();return r.Jl(X,x)?n:null}}}function e(h){function p(C){var M=[],B,v;for(B=0;B<C.length;B+=1){var G=C[B];for(v=0;v<G.length;v+=1)M.push(G[v])}return M}
function A(C){var M=[];m=m.concat(C);C=Math.floor(m.length/F);for(var B=0;B<C;B++)M.push(m.slice(B*F,(B+1)*F));m=m.slice(C*F);return M}function R(C){for(var M=[],B,v=0;v<C.length;v++)B=ba.cf(y,C[v]),M.push(h.encrypt(B)),y=M[v];return M}var F=h.blockSize/8,t=Bd.kQ(F),m=[],r=[],y;return{xd:function(C){if(C.length!==F)throw Error("Invalid iv size");y=C.slice()},encrypt:function(C){C=R(A(C));r=r.concat(p(C));return this.lp()},Lu:function(C){return p(R(A(C)))},lp:function(){var C=1===m.length?[[m[0]]]:
[m];t.Hp(C);C=r.concat(p(R(C)));m=[];r=[];y=null;return C},decrypt:function(C){this.Jp(C);return this.kp()},Jp:function(C){C=A(C);for(var M=[],B,v=0;v<C.length;v+=1)B=C[v].slice(0,C[v].length),B=h.decrypt(B),M.push(ba.cf(y,B)),y=C[v];r=r.concat(p(M))},kp:function(){var C=r;t.Zp(C);m=[];r=[];y=null;return C}}}function f(h,p){function A(H,O){for(var U=Array(H),ia=0;ia<H.length;ia++)U[ia]=H[ia]^O[ia];return U}function R(H,O){var U=H.slice();for(H=H.length;H<O;H++)U.push(0);return U}function F(H){y?p.process(H):
(y=v.concat(H),p.process(y))}function t(){var H=p.finish();return p.Yd(G.concat(H))}var m={384:128,512:128}[p.name.replace(/SHA-/,"")]||64,r=h.length===m?h:h.length>m?R(p.Yd(h),m):R(h,m),y;var C=Array(m);var M=Array(m);for(var B=0;B<m;B++)C[B]=54,M[B]=92;var v=A(r,C);var G=A(r,M);return{wB:function(H){F(H);H=t();r=p=h=null;return H},process:function(H){F(H);return null},finish:function(){var H=t();r=p=h=null;return H}}}function g(h,p,A,R,F,t,m){function r(H){for(var O=Math.floor(H.length/F),U=0;U<
O;U++)t(H,U,M,R,B);G+=O;return H.slice(O*F)}function y(){var H=v,O=F-H.length%F;O<=F/8&&(O+=F);var U=C.xc(O);U[0]=128;for(var ia=8*(H.length+G*F),Z=1;8>=Z;Z++)U[O-Z]=ia%256,ia=Math.floor(ia/256);if(0!==r(H.concat(U)).length)throw Error("buffer.length !== 0");H=[];for(O=0;O<M.length;O++)H=H.concat(C.LC(M[O]));H.length=m/8;v=[];M=A.slice();G=0;return H}var C=ba,M=A.slice(),B=Array(F),v=[],G=0;return{name:h,Yd:function(H){v=r(H);return y()},process:function(H){v=v.concat(H);v.length>=F&&(v=r(v))},finish:y,
fU:p,tu:m,maxMessageSize:4294967295}}function k(){function h(x){var n,z=null;if(!arguments.length||"number"===typeof arguments[0])for(z=Array(x),n=0;n<x;n+=1)z[n]=0;else if("object"===typeof arguments[0])for(z=Array(x.length),n=0;n<x.length;n+=1)z[n]=x[n];return z}function p(x,n,z,w,K){for(;0<K--;)z[w+K]=x[n+K]}function A(x){var n,z=0;for(n=0;n<x.length;n+=1)z|=x[n];return!z}function R(x){for(var n=Math.floor((x.length+3-1)/3),z=Array(n),w=z[0]=0,K=0,S=0,W=x.length-1;0<=W;W--)w+=ia[S++]*(x[W]&255),
16777216===ia[S]&&(S=0,z[K++]=w,w=0);for(0!==w&&(z[K]=w);null==z[--n];)z[n]=0;return z}function F(x,n){"undefined"===typeof n&&(n=1>=x?1:Math.ceil(Math.log(x)/Math.LN2/24));for(var z=[];0<x;)z.push(x%16777216),x=Math.floor(x/16777216);for(;z.length<n;)z.push(0);return z}function t(x){for(var n=x.length-1;0<=n;n--)if(void 0!==x[n]&&0!==x[n])return n;return 0===x[0]?-1:0}function m(x,n){var z=0,w;for(w=0;w<Math.max(x.length,n.length);w++){var K=~~x[w]-~~n[w];z=K+(z&-!K)}return z}function r(x,n,z){var w=
t(x);x.length=n||w+1;if(z)for(;++w<x.length;)x[w]=0;0>=x.length&&(x[0]=0,x.length=1);return x}function y(x,n,z,w){if(void 0===z)z=1;else if(24<=z||0>z)throw Error("bit count must be smaller than DIGIT_BITS and positive in shiftLeft");void 0===w&&(w=x.length);var K=24-z;n[w]=x[w-1]>>>24-z||n[w];for(--w;0<w;w--)n[w]=(x[w]<<z|x[w-1]>>>K)&16777215;n[0]=x[0]<<z&16777215}function C(x,n,z){var w=x,K=n;n.length<x.length&&(w=n,K=x);x=w.length;n=0;var S;for(S=0;S<x;S+=1)n+=w[S]+K[S],z[S]=n&16777215,n>>=24;
for(S=x;S<K.length;S+=1)n+=K[S],z[S]=n&16777215,n>>=24;z.length=K.length;0!==n&&(z[S]=n&16777215);return n}function M(x,n,z){var w=n.length;if(x.length<n.length&&(w=t(n)+1,x.length<w))throw Error("Subtrahend is longer than minuend, not supported.");var K,S=0;for(K=0;K<w;K+=1)S+=x[K]-n[K],z[K]=S&16777215,S>>=24;for(;K<x.length;)S+=x[K],z[K++]=S&16777215,S>>=24;return S}function B(x,n,z){n="number"===typeof n?[n]:n;var w,K,S,W=x.length,T=n.length;for(w=0;w<W+T;w+=1)z[w]=0;for(var L=S=w=0;w<T;){for(S=
Math.min(S+31,T);w<S;w++){var P=n[w];for(K=0;K<W;K++)z[w+K]+=x[K]*P}P=0;for(K=L;K<w+W;K++){P=z[K]+P;var aa=P&16777215;z[K]=aa;P=(P-aa)*U}z[K]=P;L+=31}z.length=W+T;return z}function v(x,n,z,w,K,S){var W=t(x)+1,T=t(n)+1;if(W<T)p(x,0,w,0,x.length),w.length=x.length,r(w),z[0]=0,z.length=1;else{if(0===T||1===T&&0===n[T-1])throw Error("Division by zero.");if(1===T){var L=n[0];var P=0;for(n=W-1;0<=n;n--)P=16777216*P+x[n],z[n]=P/L&16777215,P=P-z[n]*L&16777215;z.length=W;r(z);w[0]=P;w.length=1}else{var aa=
0;for(P=0;24>P;P++)aa=Math.max(aa,-(n[T-1]>>>P&1)&P);aa=23-aa;K=K||[];K.length=T;y(n,K,aa,T);S=S||[];S.length=W;y(x,S,aa,W);S[W]=S[W]||0;z.length=W-T+1;w.length=T;for(n=W-T;0<=n;n--){x=Math.floor((16777216*S[n+T]+S[n+T-1])/K[T-1]);for(P=16777216*S[n+T]+S[n+T-1]-x*K[T-1];;){if(16777216<=x||x*K[T-2]>16777216*P+S[n+T-2])if(--x,P+=K[T-1],16777216>P)continue;break}for(W=L=0;W<T;W++)P=x*K[W],L=S[W+n]-L-(P&16777215),S[W+n]=L&16777215,L=Math.floor(P/16777216)-Math.floor(L/16777216);L=S[n+T]-L;S[n+T]=L&16777215;
z[n]=x&16777215;if(0>L){--z[n];for(W=L=0;W<T;W++)L=S[W+n]+K[W]+L,S[W+n]=L&16777215,L>>=24;S[n+T]=S[n+T]+L&16777215}}for(W=0;W<T;W++)w[W]=(S[W]>>>aa|S[W+1]<<24-aa)&16777215;r(z);r(w)}}}function G(x,n,z,w,K){if(A(x))return p(n,0,K,0,n.length),K.length=n.length,0;if(A(n))return p(x,0,K,0,x.length),K.length=x.length,0;if(0>m(x,n)){var S=x.slice(0);p(n,0,K,0,n.length);K.length=n.length}else S=n.slice(0),p(x,0,K,0,x.length),K.length=x.length;r(K);r(S);x=Array(K.length);n=Array(K.length);var W=Array(K.length),
T=void 0!==w;if(T){var L=Array(K.length);L[0]=1;L.length=1;w[0]=0;w.length=1}var P=Array(K.length),aa=void 0!==z;if(aa){var ua=Array(K.length);ua[0]=0;ua.length=1;z[0]=1;z.length=1}for(var La=-1,Ya=z,Pa=w,sa=K,fa;!A(S);)v(K,S,x,n,P,W),aa&&(B(x,ua,P),C(P,z,P),r(P),fa=z,z=ua,ua=P,P=fa),T&&(B(x,L,W),C(W,w,W),r(W),fa=w,w=L,L=W,W=fa),fa=K,K=S,S=n,n=fa,La++;aa&&(p(z,0,Ya,0,z.length),Ya.length=z.length);T&&(p(w,0,Pa,0,w.length),Pa.length=w.length);p(K,0,sa,0,K.length);sa.length=K.length;return La}function H(x,
n,z,w){w=w||[];if(0===m(n,ma))w[0]=1;else if(0===m(n,X))p(x,0,w,0,x.length),w.length=x.length;else{var K=new O(z);r(x,K.yd,!0);K.Mj(x,n,w);w.length=z.length}return w}function O(x,n){function z(fa,ha,pa,ya){ya=ya||this;for(var Ea=ya.Dp,wa=Ea.length,Fa=ya.Cu,rb=ya.Bu,Za,Ca,jb,eb=0,xb,mc=0,mb=h(wa+2);eb<wa;){for(mc=Math.min(wa,mc+16);eb<mc;){Za=~~ha[eb];Ca=mb[0]+fa[0]*Za;jb=(Ca&16777215)*Fa&16777215;mb[1]+=(rb*jb+Ca)*U|0;Ca=1;for(xb=0;Ca<wa;xb=Ca,Ca+=1)mb[xb]=mb[Ca]+Ea[Ca]*jb+fa[Ca]*Za;mb[xb]=mb[Ca];
mb[Ca]=0;eb++}for(Ca=Za=0;Ca<wa;Ca++)Za=mb[Ca]+Za,jb=Za&16777215,mb[Ca]=jb,Za=(Za-jb)*U;mb[Ca]=Za}for(eb=0;eb<wa;eb+=1)pa[eb]=mb[eb];pa.length=wa;fa=+(0<la.Of(mb,Ea));la.Xc(pa,Ea,ya.rv);w(fa,pa,ya.rv)}function w(fa,ha,pa){fa=-fa;for(var ya=~fa,Ea=0;Ea<ha.length;Ea++)ha[Ea]=ha[Ea]&ya|pa[Ea]&fa}function K(fa){for(var ha=fa.length,pa=fa[0],ya=1,Ea=2,wa=3,Fa=wa&pa,rb=2;24>=rb;rb+=1)Ea<Fa&&(ya+=Ea),Ea<<=1,wa=wa<<1|1,Fa=pa*ya&wa;pa={Dp:fa,Cu:(~ya&16777215)+1,Bu:pa,qv:h(2*ha+1),rv:h(2*ha+1)};ya=h(2*fa.length);
ya[ya.length]=1;pa.Fp=[];v(ya,fa,pa.Fp,[]);ya=h(2*ha+1);Fa=h(ha+1);Ea=h(2*ha+1);wa=h(2*ha+1);Fa[ha]=1;v(Fa,fa,ya,Fa,Ea,wa);pa.Kp=r(Fa,ha,!0);Fa=h(2*ha+1);Fa[2*ha]=1;v(Fa,fa,ya,Fa,Ea,wa);pa.Nu=r(Fa,ha,!0);pa.Mu=h(ha);z(Fa,Fa,pa.Mu,pa);return pa}n=n||K(x);var S=n.Dp;x=n.Fp;var W=n.Bu,T=S.length,L=h(T+1).slice(0,T);L[0]=1;var P=n.Cu,aa=n.Kp,ua=n.Nu,La=n.Mu,Ya=h(2*T+1),Pa=h(2*T+1),sa=Array(4);sa[0]=aa;sa[1]=Array(T);sa[2]=Array(T);sa[3]=Array(T);return{Dp:S,Bu:W,Cu:P,Fp:x,Nu:ua,yd:T,Kp:aa,Mu:La,fD:L,
qv:Ya,rv:Pa,bU:function(fa){if(fa.length<this.yd){fa.length=this.yd;for(var ha=0;ha<this.yd;ha++)fa[ha]=isNaN(fa[ha])?0:fa[ha]}var pa=h(fa.length);this.Nj(fa,this.Nu,pa);for(ha=0;ha<this.yd;ha+=1)fa[ha]=pa[ha]},cU:function(fa){this.Nj(fa,this.fD,this.qv);for(var ha=0;ha<this.yd;ha+=1)fa[ha]=this.qv[ha]},Nj:z,Mj:function(fa,ha,pa,ya){ya=!!ya;var Ea=2;var wa=24*ha.length;var Fa=3*Math.ceil(wa/2)+5;do{Ea++;var rb=Fa;Fa=Math.pow(2,Ea)+Math.ceil(wa/Ea)*(Ea+1)+1}while(Fa<rb);--Ea;rb=ha.length;Fa=0;var Za=
0,Ca,jb=Array(Math.ceil(24*rb/Ea));var eb=0;for(jb[0]=0;Fa<rb;Fa++)for(wa=0,Ca=ha[Fa];24>wa;wa++,Ca>>>=1)eb===Ea&&(eb=jb[++Za]=0),jb[Za]+=(Ca&1)<<eb++;rb=jb.reverse();Fa=this.Kp.slice(0);wa=Math.pow(2,Ea);sa.length=wa;sa[0]=this.Kp;for(ha=1;ha<wa;ha++)sa[ha]=[],B(sa[ha-1],fa,sa[ha]),this.reduce(sa[ha]);fa=[];for(ha=0;ha<rb.length;ha++){for(wa=0;wa<Ea;wa++)this.Nj(Fa,Fa,Fa);eb=rb[ha];if(ya)fa=sa[eb];else{var xb;wa=sa;Za=fa;for(Ca=0;Ca<wa[0].length;Ca++)Za[Ca]=0;for(xb=0;xb<wa.length;xb++){jb=wa[xb];
var mc=-(eb===xb);for(Ca=0;Ca<jb.length;Ca++)Za[Ca]|=jb[Ca]&mc}}this.Nj(Fa,fa,Fa)}this.Nj(Fa,this.fD,pa);return pa},reduce:function(fa,ha){var pa=this.Dp.length,ya=[];ha=ha||fa;var Ea=fa.slice(pa-1);var wa=[];B(Ea,this.Fp,wa);Ea=wa.slice(pa+1);fa=fa.slice(0,pa+1);wa=[];B(Ea,S,wa);wa=wa.slice(0,pa+1);fa[pa+1]=m(fa,wa)>>>31;for(pa=0;pa<ha.length;pa++)ha[pa]=0;M(fa,wa,ha);pa=+(0<m(ha,S));la.Xc(ha,S,ya);w(pa,ha,ya);r(ha)},Eg:n}}for(var U=1/16777216,ia=[1,256],Z=2;3>=Z;Z++)ia[Z]=256*ia[Z-1];var ma=[0],
X=[1];return{lq:24,ET:3,CT:16777215,DE:16777216,DT:16777215,PT:ma,DF:X,XP:r,Kh:R,IU:function(x,n){x=x.replace(/^\s+|\s+$/g,"");var z=[0],w=[0];n=n||10;for(var K=0;K<x.length;K+=1){var S=parseInt(x[K],n);if(isNaN(S))throw Error("Failed to convert string to integer in radix "+n.toString());B(z,n,w);C(w,[S],z);r(z)}return z},gU:function(x,n){n=n||10;if(16777216<=n)throw Error("DIGIT_BASE is smaller than RADIX; cannot convert.");var z=x.length,w=[],K=[],S=[],W=[],T=[],L=[],P,aa="",ua="0";for(T[0]=n;Math.floor(16777216/
T[0])>=n;)T[0]*=n,ua=ua.concat("0");for(P=0;P<z;P+=1)L[P]=x[P];do{x=!0;for(P=0;P<L.length;P+=1)if(0!==L[P]){x=!1;break}if(x)break;v(L,T,w,K,S,W);r(w,L.length,!0);P=K[0].toString(n);aa=ua.substring(0,ua.length-P.length)+P+aa;P=L;L=w;w=P}while(1);for(;0!==aa.length&&"0"===aa[0];)aa=aa.substring(1,aa.length);0===aa.length&&(aa="0");return aa},sU:F,OB:function(x,n,z){var w,K,S=[0];"undefined"===typeof n&&(n=!0);for(w=0;w<x.length;w+=1){var W=x[w];for(K=0;3>K;K+=1)S[3*w+K]=W&255,W=Math.floor(W/256)}S.reverse();
void 0===z&&(z=1);if(n)for(;S.length>z&&0===S[0];)S.shift();return S},RC:A,uU:function(x){return 0===(x[0]&1)},WD:function(x,n,z,w){if(void 0===z)z=1;else if(24<=z||0>z)throw Error("Invalid bit count for shiftRight");void 0===w&&(w=x.length);--w;for(var K=24-z,S=0;S<w;S++)n[S]=(x[S+1]<<K|x[S]>>>z)&16777215;n[w]=x[w]>>>z},shiftLeft:y,Of:m,WT:function(x){for(var n=0,z=0;n<x.length;){if(0===z)for(var w=7;0<=w&&0===z;){var K=1<<w;(x[n]&K)===K&&(z=w+1);w--}else z+=8;n+=1}return z},iU:function(x,n,z){x=
x.slice();for(var w=[],K=Math.pow(2,n),S=Math.pow(2,n-1),W=0;W<z;W++)w[W]=x[0]%K-S,x[0]-=w[W],la.WD(x,x,n-1);w[W]=x[0];return w},tF:function(x){function n(L,P){return{$a:L,Du:P,ip:function(aa){return 0===m(this.$a,aa.$a)&&this.Du.ip(this.Du,aa.Du)}}}x=R(x);var z=x.length,w=F(0,z),K=F(1,z),S=h(z),W=h(z),T=new O(x);return{Mg:x,Lj:z,YC:T,eU:function(L){L=F(L,this.Lj);return n(L,this)},fO:function(L){L=R(L);if(0<=la.Of(L,this.Mg))throw Error("The number provided is not an element of this group");r(L,
this.Lj,!0);return n(L,this)},dU:function(L){la.XP(L,this.Lj,!0);return n(L,this)},ip:function(L){return 0===m(this.Mg,L.Mg)},add:function(L,P,aa){var ua=this.Lj;aa=aa.$a;la.add(L.$a,P.$a,aa);P=(m(aa,this.Mg)>>>31)-1&16777215;var La=0;for(L=0;L<ua;L+=1)La=aa[L]-(this.Mg[L]&P)+La,aa[L]=La&16777215,La>>=24;aa.length=ua},Xc:function(L,P,aa){var ua=this.Lj,La=aa.$a;P=la.Xc(L.$a,P.$a,aa.$a);if(-1===P)for(L=P=0;L<ua;L+=1)P+=La[L]+this.Mg[L],La[L]=P&16777215,P>>=24},multiply:function(L,P,aa){return la.XC(L.$a,
P.$a,this.Mg,aa.$a,S,W)},inverse:function(L,P){la.Eu(L.$a,this.Mg,P.$a)},TP:function(L,P,aa){aa=aa||n([],this);if(0===m(P,w))aa.$a=F(1,this.Lj);else if(0===m(P,K)){for(P=0;P<L.$a.length;P++)aa.$a[P]=L.$a[P];aa.$a.length=L.$a.length}else this.YC.Mj(L.$a,P,aa.$a),aa.$a.length=this.YC.yd;return aa}}},add:C,Xc:M,multiply:B,hU:v,reduce:function(x,n,z,w,K){v(x,n,[],z,w,K);return z},Eu:function(x,n,z,w){var K=Array(n.length),S=Array(n.length);x=G(x,n,Array(n.length),K,S);z=z||[];0!==m(S,X)?(z[0]=NaN,z.length=
1):(1===(x&1)?M(n,K,z):(p(K,0,z,0,K.length),z.length=K.length),w?r(z,n.length,!0):r(z));return z},xU:function(x,n,z){var w=[];z=z||[];M(n,[2],w);H(x,w,n,z);r(z);return z},Mj:H,XC:function(x,n,z,w,K,S){var W=[];B(x,n,W);v(W,z,W,w,K,S);return w},fi:O,FO:function(x,n,z){var w=x,K=n;0<m(x,n)&&(w=n,K=x);G(w,K,void 0,void 0,z);return r(z)},FU:function(x,n){for(var z=x.length===n.length,w=0;w<Math.min(x.length,n.length);w+=1)x[w]!==n[w]&&(z=!1);return z},JU:function(x){return x.reverse()},aU:function(x){for(var n=
h(8*x.length),z=0,w=x.length-1;0<=w;){for(var K=0;8>K;){var S=1<<K;S=(x[w]&S)===S?1:0;var W=8*(x.length-w-1)+K;1===S&&(z=W+1);n[W]=S;K+=1}w--}return n.slice(0,z)}}}function l(){function h(v){var G;for(G=v.length-1;0<=G&&(v[G]+=1,256<=v[G]&&(v[G]=0),!v[G]);--G);}function p(){m=ba.xc(32);r=ba.xc(16);y=32;C=48;M=1}function A(v,G){G=G||[0];if(G.length>C)throw Error("Incorrect entropy or additionalEntropy length");G=G.concat(ba.xc(C-G.length));v=v.concat(ba.xc((C-v.length%C)%C));for(var H=0;H<v.length;H+=
C){var O=ba.cf(v.slice(H,H+C),G);R(O)}M=1}function R(v){for(var G=[],H=new Fb.Cg(m);G.length<C;){h(r);var O=H.encrypt(r.slice(0,16));G=G.concat(O)}G=ba.cf(G,v);m=G.slice(0,y);r=G.slice(y)}function F(v,G){if(65536<=v)throw Error("too much random requested");if(M>B)throw Error("Reseeding is required");if(G&&0<G.length){for(;G.length<C;)G=G.concat(ba.xc(C-G.length));R(G)}else G=ba.xc(C);for(var H=[],O=new Fb.Cg(m);H.length<v;){h(r);var U=O.encrypt(r.slice(0,r.length));H=H.concat(U)}H=H.slice(0,v);R(G);
M+=1;return H}if(!(this instanceof l))throw Error("create MsrcryptoPrng object with new keyword");var t=!1,m,r,y,C,M=1,B=Math.pow(2,48);p();return{fm:A,ze:function(v,G){if(!t)throw Error("can't get randomness before initialization");return F(v,G)},oU:function(v,G){if(!t)throw Error("can't get randomness before initialization");for(var H=[],O;H.length<v;){O=F(v,G);for(var U=0;U<O.length;U+=1)0!==O[U]&&H.push(O[U])}return H.slice(0,v)},xd:function(v,G){if(v.length<C)throw Error("Initial entropy length too short");
p();A(v,G);t=!0}}}function E(h){function p(){var M="Cookie RedirectUri ETag x-ms-client-antiforgery-id x-ms-client-request-id x-ms-client-session-id SubscriptionPool".split(" "),B,v=[];for(B=0;48>B;B+=1)v[B]=Math.floor(256*Math.random());if((B=r.crypto||r.msCrypto)&&"function"===typeof B.getRandomValues&&h.Uint8Array){var G=new h.Uint8Array(48);B.getRandomValues(G);v=v.concat(Array.prototype.slice.call(G));m=!0}if("undefined"!==typeof XMLHttpRequest)for(G=new XMLHttpRequest,B=0;B<M.length;B+=1)try{var H=
G.getResponseHeader(M[B]);H&&(v=v.concat(ba.Wj(H)))}catch(O){}!m&&y&&(v=v.concat(R.splice(0,R.length)),C.YD());t?F.fm(v):F.xd(v);t=!0}function A(M){for(var B=0;B<M.length;++B)R.push(M[B]);128<=R.length&&C.dT()}var R=[],F=new l,t=!1,m=!1,r=h,y=h&&h.addEventListener||"undefined"!==typeof document&&document.attachEvent,C=function(){return{YD:function(){if(!this.Tt){if(h.addEventListener)h.addEventListener("mousemove",this.Bm,!0),h.addEventListener("load",this.ym,!0);else if(document.attachEvent)document.attachEvent("onmousemove",
this.Bm),document.attachEvent("onload",this.ym);else throw Error("Can't attach events for entropy collection");this.Tt=1}},dT:function(){this.Tt&&(h.removeEventListener?(h.removeEventListener("mousemove",this.Bm,1),h.removeEventListener("load",this.ym,1)):h.detachEvent&&(h.detachEvent("onmousemove",this.Bm),h.detachEvent("onload",this.ym)),this.Tt=0)},Bm:function(M){var B=(new Date).valueOf(),v=M.x||M.clientX||M.offsetX||0;M=M.y||M.clientY||M.offsetY||0;A([B&255,B>>8&255,B>>16&255,B>>24&255,v&255,
v>>8&255,M&255,M>>8&255])},ym:function(){var M=(new Date).valueOf();A([M&255,M>>8&255,M>>16&255,M>>24&255])}}}();return{xd:function(){p();if(!m&&y)try{C.YD()}catch(M){}},fm:function(M){F.fm(M)},read:function(M){if(!t)throw Error("Entropy pool is not initialized.");M=F.ze(M);p();return M}}}var u={register:function(h,p,A){u[h]||(u[h]={});h=u[h];h[p]||(h[p]=A)},UB:function(h,p){return u[h]?u[h][p]?!0:!1:!1}},ka=self.location.href,ja="undefined"!==typeof Worker,va="function"===typeof importScripts&&self instanceof
WorkerGlobalScope,Xa=!1,ca="undefined"!==typeof ArrayBuffer;try{Object.defineProperty({},"oncomplete",{})}catch(h){}var da=!1,ea={},ba=function(){function h(t){for(t=t.replace(/-/g,"+").replace(/_/g,"/");0!==t.length%4;)t+="=";var m=[],r;t=t.replace(/[^A-Za-z0-9\+\/=]/g,"");for(r=0;r<t.length;r+=4){var y="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(r));var C="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(r+1));var M="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(r+
2));var B="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(r+3));y=y<<2|C>>4;C=(C&15)<<4|M>>2;var v=(M&3)<<6|B;m.push(y);64!==M&&m.push(C);64!==B&&m.push(v)}return m}function p(t){return Object.prototype.toString.call(t).slice(8,-1)}function A(t){return[t>>>24&255,t>>>16&255,t>>>8&255,t&255]}function R(t){if(!t)return[];if(t.pop)return t;"ArrayBuffer"===p(t)?t=new Uint8Array(t):1<t.BYTES_PER_ELEMENT&&(t=new Uint8Array(t.buffer));if(1===t.length)return[t[0]];if(65536>
t.length)return Array.apply(null,t);for(var m=Array(t.length),r=0;r<t.length;r++)m[r]=t[r];return m}function F(t){return"number"===typeof t&&isFinite(t)&&Math.floor(t)===t}return{Vt:function(t){"console"in self&&"log"in console&&console.log(t)},fe:function(t,m){var r=p(t);if("Array"!==r&&"Uint8Array"!==r&&"ArrayBuffer"!==r)throw Error("invalid input");r="";t=R(t);void 0===m&&(m=!1);var y;for(y=0;y<t.length;y+=3){var C=t[y];var M=t[y+1];var B=t[y+2];var v=C>>2;C=(C&3)<<4|M>>4;var G=(M&15)<<2|B>>6;
var H=B&63;isNaN(M)?G=H=64:isNaN(B)&&(H=64);r=r+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(v)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(C)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(G)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(H)}return m?r.replace(/\+/g,"-").replace(/\//g,"_").replace(/=/g,""):r},Ol:h,ZT:function(t,m,r){if(!t)throw Error(r);if(m&&p(t)!==m)throw Error(r);
return!0},pu:p,bytesToHexString:function(t,m){var r="";"undefined"===typeof m&&(m=!1);for(var y=0;y<t.length;y++){m&&0===y%4&&0!==y&&(r+="-");var C=t[y].toString(16).toUpperCase();1===C.length&&(r+="0");r+=C}return r},nB:function(t,m){m=m||0;return t[m]<<24|t[m+1]<<16|t[m+2]<<8|t[m+3]},Wj:function(t){for(var m=[],r=0,y=0;r<t.length;r++){var C=t.charCodeAt(r);128>C?m[y++]=C:2048>C?(m[y++]=C>>>6|192,m[y++]=C&63|128):55296>C||57343<C?(m[y++]=C>>>12|224,m[y++]=C>>>6&63|128,m[y++]=C&63|128):(C=1024*(C-
55296)+(t.charCodeAt(++r)-56320)+65536,m[y++]=C>>>18|240,m[y++]=C>>>12&63|128,m[y++]=C>>>6&63|128,m[y++]=C&63|128)}return m},oB:function(t){var m="",r;t=R(t);for(var y=0;y<t.length;){var C=t[y++];128>C?r=C:r=224>C?(C<<6)+t[y++]-12416:240>C?(C<<12)+(t[y++]<<6)+t[y++]-925824:(C<<18)+(t[y++]<<12)+(t[y++]<<6)+t[y++]-63447168;m=65535<r?m+String.fromCharCode(Math.floor((r-65536)/1024)+55296,(r-65536)%1024+56320):m+String.fromCharCode(r)}return m},Yp:function(t,m,r){t=h(t);var y=[],C;if(isNaN(m))return t;
for(C=0;C<t.length;C+=m)y.push(t.slice(C,C+m));if(r)for(C=0;C<y.length;C++)y[C]=(y[C][0]<<24)+(y[C][1]<<16)+(y[C][2]<<8)+y[C][3];return y},pU:function(t){t=t.replace(/\-/g,"");for(var m=[];2<=t.length;)m.push(parseInt(t.substring(0,2),16)),t=t.substring(2,t.length);return m},LC:A,rU:function(t){for(var m=[],r=0;r<t.length;r++)m=m.concat(A(t[r]));return m},yc:R,Jl:function(t,m){var r=!0;t.length!==m.length&&(r=!1);for(var y=0;y<t.length;y++)t[y]!==m[y]&&(r=!1);return r},clone:function(t){var m={},
r;for(r in t)t.hasOwnProperty(r)&&(m[r]=t[r]);return m},cf:function(t,m,r){var y=Math.min(t.length,m.length);r=r||Array(y);for(var C=0;C<y;C+=1)r[C]=t[C]^m[C];return r},padEnd:function(t,m,r){for(;t.length<r;)t.push(m);return t},iQ:function(t,m,r){for(;t.length<r;)t.unshift(m);return t},xc:function(t,m){isNaN(m)&&(m=0);for(var r=Array(t),y=0;y<t;y+=1)r[y]=m;return r},MU:function(t){if("Array"!==p(t))return!1;for(var m,r=0;r<t.length;r++)if(m=t[r],isNaN(m)||0>m||255<m)return!1;return!0},error:function(t,
m){m=Error(m);m.name=t;throw m;},tU:function(t){if(!(t instanceof Array))return!1;for(var m=0;m<t.length;m++){var r=t[m];if(!F(r)||255<r||0>r)return!1}return!0},isInteger:F}}(),Aa=function(){function h(m,r){var y=t[m[0]&31],C=m[1],M=0,B=!!(m[0]&32);if(C&128)for(C=M=0;M<(m[1]&127);M++)C=(C<<8)+m[2+M];var v=2+M;if(void 0===y||C>m.length)return null;var G=B?[]:{};G.type=y;G.Jg=v;G.data=m.slice(0,C+v);if(B||r)for("BIT STRING"===G.type&&0===m[v]&&M++,m=m.slice(v,G.data.length);0<m.length;){r=h(m);if(null===
r)break;G.push(r);m=m.slice(r.data.length)}return G}function p(m){if(m.hasOwnProperty("INTEGER")){m=m.Ad;ba.isInteger(m)&&(m=R(m));m[0]&128&&m.unshift(0);var r=[2].concat(A(m),m);return r}if(m.hasOwnProperty("OCTET STRING"))return m=m["OCTET STRING"],m instanceof Array||(m=p(m)),r=[4].concat(A(m),m);if(m.hasOwnProperty("BIT STRING"))return m=m["BIT STRING"],m instanceof Array||(m=p(m)),m.unshift(0),r=[3].concat(A(m),m);if(m.hasOwnProperty("NULL"))return[5,0];if(m.hasOwnProperty("OBJECT IDENTIFIER")){r=
m["OBJECT IDENTIFIER"].split(".");for(var y=[parseInt(40*r[0]+parseInt(r[1]))],C=2;C<r.length;C++){m=parseInt(r[C]);for(var M=[];0<m;)M.push(m&127|128),m>>>=7;M[0]&=127;y=y.concat(M.reverse())}m=y;return r=[6].concat(A(m),m)}if(m.hasOwnProperty("SEQUENCE")){r=m.pi;m=[];for(M=0;M<r.length;M++)m=m.concat(p(r[M]));return r=[48].concat(A(m),m)}if(m.hasOwnProperty("APPLICATION")){r=m.gE;y=isNaN(parseInt(r[0]))?32:0;C=m.tag;m=y?[]:m.gE;if(y)for(M=0;M<r.length;M++)m=m.concat(p(r[M]));return r=[160|y|C].concat(A(m),
m)}throw Error("unsupported asn.1 type");}function A(m){m=m.length;if(127>=m)return[m];m=R(m);m.unshift(m.length|128);return m}function R(m){var r=[];if(0===m)return[0];for(;0<m;)r.unshift(m&255),m>>>=8;return r}function F(m,r){var y=Array(r+1).join(" ")+m.type+" ("+m.length+") "+bytesToHexString(m.data).substring(0,16)+"\n";if(!m.children)return y;for(var C=0;C<m.children.length;C++)y+=F(m.children[C],r+4)+"";return y}var t={0:"CUSTOM",1:"BOOLEAN",2:"INTEGER",3:"BIT STRING",4:"OCTET STRING",5:"NULL",
6:"OBJECT IDENTIFIER",16:"SEQUENCE",17:"SET",19:"PRINTABLE STRING",23:"UTCTime"};return{parse:h,encode:p,toString:function(m){return F(m,0)}}}(),qb=function(){function h(p){Xa&&va&&self.postMessage(p);return p}return{TC:function(p){var A=p.data.operationType,R=u[A][p.data.algorithm.name],F=p.data;if(!u.UB(A,p.data.algorithm.name))throw Error("unregistered algorithm.");return F.Ma?h({type:F.Ma,result:R(F)}):h(R(F))},WQ:h}}();va&&(self.onmessage=function(h){if(!Xa&&h.data.Ku)return nb.xd(h.data.Ku),
Xa=!0,qb.WQ({IC:!0});!0===Xa&&qb.TC(h)});var Ia=function(){function h(F){F=F.algorithm.name.slice(0,3).toUpperCase();return"RSA"===F?"RSA":"ECD"===F?"EC":"oct"}function p(F){return F.hash.name.substring(F.hash.name.indexOf("-")+1)}var A=ba,R={HMAC:function(F){return"HS"+p(F)},"AES-CBC":function(F){return"A"+F.length.toString()+"CBC"},"AES-GCM":function(F){return"A"+F.length.toString()+"GCM"},"AES-KW":function(F){return"A"+F.length.toString()+"KW"},"RSAES-PKCS1-V1_5":function(){return"RSA1_5"},"RSASSA-PKCS1-V1_5":function(F){return"RS"+
p(F)},"RSA-OAEP":function(F){return"SHA-1"===F.hash.name.toUpperCase()?"RSA-OAEP":"RSA-OAEP-"+p(F)},"RSA-PSS":function(F){return"PS"+p(F)},ECDSA:function(F){return"EC-"+F.namedCurve.substring(F.namedCurve.indexOf("-")+1)}};return{IP:function(F,t){var m={};m.kty=h(F);m.extractable=F.extractable;if(t.pop)m.k=A.fe(t,!0);else for(var r in t)t[r].pop&&(m[r]=A.fe(t[r],!0));F.algorithm.namedCurve&&(m.crv=F.algorithm.namedCurve);F=JSON.stringify(m,null,"\t");t=[];for(m=0;m<F.length;m++)t[m]=F.charCodeAt(m);
0===t[t.length-1]&&t.pop();return t},Cp:function(F,t){var m={};m.kty=h(F);m.ext=F.extractable;R[F.algorithm.name.toUpperCase()]&&(m.alg=R[F.algorithm.name.toUpperCase()](F.algorithm));m.key_ops=F.usages;if(t.pop)m.k=A.fe(t,!0);else for(var r in t)t[r].pop&&"key_ops"!==r&&(m[r]=A.fe(t[r],!0));F.algorithm.namedCurve&&(m.crv=F.algorithm.namedCurve);return m},Yl:function(F,t,m){F=JSON.parse(JSON.stringify(F));for(t=0;t<m.length;t+=1){var r=F[m[t]];r&&(F[m[t]]=A.Ol(r))}return F}}}(),xa=function(){function h(m,
r,y,C,M){var B,v=y[0],G=y[1],H=y[2],O=y[3],U=y[4];for(B=0;16>B;B++)M[B]=p.nB(m,64*r+4*B);for(B=16;80>B;B++)m=M[B-3]^M[B-8]^M[B-14]^M[B-16],M[B]=m<<1|m>>>31;for(B=0;80>B;B++)m=v<<5|v>>>27,m+=60<=B?G^H^O:40<=B?G&H^G&O^H&O:20<=B?G^H^O:G&H^~G&O,m+=U+C[B]+M[B],U=O,O=H,H=G<<30|G>>>2,G=v,v=m;y[0]+=v&4294967295;y[1]+=G&4294967295;y[2]+=H&4294967295;y[3]+=O&4294967295;y[4]+=U&4294967295;return y}var p=ba,A=p.Yp,R=A("Z0UjAe/Nq4mYutz+EDJUdsPS4fA=",4,1),F=A("WoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroY8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdY",
4,1),t=A("MCEwCQYFKw4DAhoFAAQU");return{jm:function(){return g("SHA-1",t,R,F,64,h,160)}}}();"undefined"!==typeof u&&(xa.Yb={},xa.lU=function(h){return xa.Yb[h]||(xa.Yb[h]=xa.jm())},xa.deleteInstance=function(h){xa.Yb[h]=null;delete xa.Yb[h]},xa.hash=function(h){if("process"===h.Ma)xa.jm.process(h.buffer);else return"finish"===h.Ma?xa.jm.finish():xa.jm().Yd(h.buffer)},u.register("digest","SHA-1",xa.hash));ea["SHA-1"]=xa.jm;var Da=function(){function h(y,C,M,B,v){var G,H=M[0],O=M[1],U=M[2],ia=M[3],
Z=M[4],ma=M[5],X=M[6],x=M[7];for(G=0;16>G;G++)v[G]=p.nB(y,64*C+4*G);for(G=16;64>G;G++)y=v[G-15],C=v[G-2],v[G]=((C>>>17|C<<15)^(C>>>19|C<<13)^C>>>10)+v[G-7]+((y>>>7|y<<25)^(y>>>18|y<<14)^y>>>3)+v[G-16],v[G]&=4294967295;for(G=0;64>G;G++)y=x+((Z>>>6|Z<<26)^(Z>>>11|Z<<21)^(Z>>>25|Z<<7))+(Z&ma^~Z&X)+B[G]+v[G],ia+=y,y+=((H>>>2|H<<30)^(H>>>13|H<<19)^(H>>>22|H<<10))+(H&(O^U)^O&U),x=X,X=ma,ma=Z,Z=ia,ia=U,U=O,O=H,H=y;M[0]=M[0]+H>>>0;M[1]=M[1]+O>>>0;M[2]=M[2]+U>>>0;M[3]=M[3]+ia>>>0;M[4]=M[4]+Z>>>0;M[5]=M[5]+
ma>>>0;M[6]=M[6]+X>>>0;M[7]=M[7]+x>>>0;return M}var p=ba,A=p.Yp;var R=A("wQWe2DZ81QcwcN0X9w5ZOf/ACzFoWBURZPmPp776T6Q",4,1);var F=A("agnmZ7tnroU8bvNypU/1OlEOUn+bBWiMH4PZq1vgzRk",4,1);var t=A("QoovmHE3RJG1wPvP6bXbpTlWwltZ8RHxkj+CpKscXtXYB6qYEoNbASQxhb5VDH3Dcr5ddIDesf6b3AanwZvxdOSbacHvvkeGD8GdxiQMocwt6SxvSnSEqlywqdx2+YjamD5RUqgxxm2wAyfIv1l/x8bgC/PVp5FHBspjURQpKWcntwqFLhshOE0sbfxTOA0TZQpzVHZqCruBwskuknIshaK/6KGoGmZLwkuLcMdsUaPRkugZ1pkGJPQONYUQaqBwGaTBFh43bAgnSHdMNLC8tTkcDLNO2KpKW5zKT2gub/N0j4LueKVjb4TIeBSMxwIIkL7/+qRQbOu++aP3xnF48g",
4,1);var m=A("MC0wDQYJYIZIAWUDBAIEBQAEHA");var r=A("MDEwDQYJYIZIAWUDBAIBBQAEIA");return{nv:function(){return g("SHA-224",m,R,t,64,h,224)},ov:function(){return g("SHA-256",r,F,t,64,h,256)}}}();"undefined"!==typeof u&&(Da.JC=Da.JC||Da.nv(),Da.KC=Da.KC||Da.ov(),Da.Yb={},Da.hC=function(h){return Da.Yb[h]||(Da.Yb[h]=Da.nv())},Da.iC=function(h){return Da.Yb[h]||(Da.Yb[h]=Da.ov())},Da.deleteInstance=function(h){Da.Yb[h]=null;delete Da.Yb[h]},Da.dP=function(h){if("process"===h.Ma)return Da.iC(h.Ic).process(h.buffer),
null;if("finish"===h.Ma){var p=Da.iC(h.Ic).finish();Da.deleteInstance(h.Ic);return p}if("abort"===h.Ma)Da.deleteInstance(h.Ic);else return Da.KC.Yd(h.buffer)},Da.cP=function(h){if("process"===h.Ma)Da.hC(h.Ic).process(h.buffer);else if("finish"===h.Ma&&Da.hC(h.Ic).finish(),"abort"===h.Ma)msrcryptoSha224.deleteInstance(h.Ic);else return Da.JC.Yd(h.buffer)},u.register("digest","SHA-224",Da.cP),u.register("digest","SHA-256",Da.dP));ea["SHA-224"]=Da.nv;ea["SHA-256"]=Da.ov;var Oa=function(){function h(M,
B,v,G,H){B=B+G|0;H[0]=M+v+(B>>>0<G>>>0)|0;H[1]=B}function p(M,B,v,G,H){var O,U=[],ia=[],Z=[],ma=v[0],X=v[1],x=v[2],n=v[3],z=v[4],w=v[5],K=v[6],S=v[7],W=v[8],T=v[9],L=v[10],P=v[11],aa=v[12],ua=v[13],La=v[14],Ya=v[15];for(O=0;32>O;O++){var Pa=128*B+4*O;H[O]=M.slice(Pa,Pa+4);H[O]=H[O][0]<<24|H[O][1]<<16|H[O][2]<<8|H[O][3]}for(O=32;160>O;O+=2){var sa=H[O-30];var fa=H[O-29];M=(sa>>>1|fa<<31)^(sa>>>8|fa<<24)^sa>>>7;B=(fa>>>1|sa<<31)^(fa>>>8|sa<<24)^(fa>>>7|sa<<25);sa=H[O-4];fa=H[O-3];Pa=(sa>>>19|fa<<13)^
(fa>>>29|sa<<3)^sa>>>6;sa=(fa>>>19|sa<<13)^(sa>>>29|fa<<3)^(fa>>>6|sa<<26);h(Pa,sa,H[O-14],H[O-13],U);h(M,B,U[0],U[1],U);h(H[O-32],H[O-31],U[0],U[1],U);H[O]=U[0];H[O+1]=U[1]}for(O=0;160>O;O+=2)M=(W>>>14|T<<18)^(W>>>18|T<<14)^(T>>>9|W<<23),B=(T>>>14|W<<18)^(T>>>18|W<<14)^(W>>>9|T<<23),Pa=W&L^aa&~W,sa=T&P^ua&~T,h(La,Ya,M,B,U),h(Pa,sa,G[O],G[O+1],ia),h(U[0],U[1],H[O],H[O+1],Z),h(ia[0],ia[1],Z[0],Z[1],Z),h(Z[0],Z[1],K,S,U),K=U[0],S=U[1],B=(X>>>28|ma<<4)^(ma>>>2|X<<30)^(ma>>>7|X<<25),M=(ma>>>28|X<<4)^
(X>>>2|ma<<30)^(X>>>7|ma<<25),sa=X&(n^w)^n&w,Pa=ma&(x^z)^x&z,h(Z[0],Z[1],M,B,U),M=U[0],B=U[1],h(Pa,sa,M,B,U),M=U[0],B=U[1],La=aa,Ya=ua,aa=L,ua=P,L=W,P=T,W=K,T=S,K=z,S=w,z=x,w=n,x=ma,n=X,ma=M,X=B;h(v[0],v[1],ma,X,U);v[0]=U[0];v[1]=U[1];h(v[2],v[3],x,n,U);v[2]=U[0];v[3]=U[1];h(v[4],v[5],z,w,U);v[4]=U[0];v[5]=U[1];h(v[6],v[7],K,S,U);v[6]=U[0];v[7]=U[1];h(v[8],v[9],W,T,U);v[8]=U[0];v[9]=U[1];h(v[10],v[11],L,P,U);v[10]=U[0];v[11]=U[1];h(v[12],v[13],aa,ua,U);v[12]=U[0];v[13]=U[1];h(v[14],v[15],La,Ya,U);
v[14]=U[0];v[15]=U[1];return v}var A=ba.Yp;var R=A("y7udXcEFnthimikqNnzVB5FZAVowcN0XFS/s2PcOWTlnMyZn/8ALMY60SodoWBUR2wwuDWT5j6dHtUgdvvpPpA==",4,1);var F=A("agnmZ/O8yQi7Z66FhMqnOzxu83L+lPgrpU/1Ol8dNvFRDlJ/reaC0ZsFaIwrPmwfH4PZq/tBvWtb4M0ZE34heQ",4,1);var t=A("QoovmNcoriJxN0SRI+9lzbXA+8/sTTsv6bXbpYGJ27w5VsJb80i1OFnxEfG2BdAZkj+CpK8ZT5urHF7V2m2BGNgHqpijAwJCEoNbAUVwb74kMYW+TuSyjFUMfcPV/7Ticr5ddPJ7iW+A3rH+OxaWsZvcBqclxxI1wZvxdM9pJpTkm2nBnvFK0u++R4Y4TyXjD8GdxouM1bUkDKHMd6ycZS3pLG9ZKwJ1SnSEqm6m5INcsKncvUH71Hb5iNqDEVO1mD5RUu5m36uoMcZtLbQyELADJ8iY+yE/v1l/x77vDuTG4AvzPaiPwtWnkUeTCqclBspjUeADgm8UKSlnCg5ucCe3CoVG0i/8LhshOFwmySZNLG38WsQq7VM4DROdlbPfZQpzVIuvY952agq7PHeyqIHCyS5H7a7mknIshRSCNTuiv+ihTPEDZKgaZku8QjABwkuLcND4l5HHbFGjBlS+MNGS6BnW71IY1pkGJFVlqRD0DjWFV3EgKhBqoHAyu9G4GaTBFrjS0MgeN2wIUUGrUydId0zfjuuZNLC8teGbSKg5HAyzxclaY07YqkrjQYrLW5zKT3dj43NoLm/z1rK4o3SPgu5d77L8eKVjb0MXL2CEyHgUofCrcozHAggaZDnskL7/+iNjHiikUGzr3oK96b75o/eyxnkVxnF48uNyUyvKJz7O6iZhnNGGuMchwMIH6tp91s3g6x71fU9/7m7ReAbwZ6pyF2+6CmN9xaLImKYRP5gEvvkNrhtxCzUTHEcbKNt39SMEfYQyyqt7QMckkzyevgoVyb68Qx1nxJwQDUxMxdS+yz5Ctll/KZz8ZX4qX8tvqzrW+uxsRBmMSkdYFw==",
4,1);var m=A("MEEwDQYJYIZIAWUDBAICBQAEMA");var r=A("MFEwDQYJYIZIAWUDBAIDBQAEQA");var y=A("MC0wDQYJYIZIAWUDBAIFBQAEHA");var C=A("MDEwDQYJYIZIAWUDBAIGBQAEIA");return{km:function(){return g("SHA-384",m,R,t,128,p,384)},lm:function(){return g("SHA-512",r,F,t,128,p,512)},GU:function(){return g("SHA-512.224",y,F,t,128,p,224)},HU:function(){return g("SHA-512.256",C,F,t,128,p,256)}}}();"undefined"!==typeof u&&(Oa.Yb={},Oa.mU=function(h){return Oa.Yb[h]||(Oa.Yb[h]=Oa.km())},Oa.nU=function(h){return Oa.Yb[h]||
(Oa.Yb[h]=Oa.lm())},Oa.deleteInstance=function(h){Oa.Yb[h]=null;delete Oa.Yb[h]},Oa.eP=function(h){if("process"===h.Ma)Oa.km.process(h.buffer);else return"finish"===h.Ma?Oa.km.finish():Oa.km().Yd(h.buffer)},Oa.fP=function(h){if("process"===h.Ma)Oa.lm.process(h.buffer);else return"finish"===h.Ma?Oa.lm.finish():Oa.lm().Yd(h.buffer)},u.register("digest","SHA-384",Oa.eP),u.register("digest","SHA-512",Oa.fP));ea["SHA-384"]=Oa.km;ea["SHA-512"]=Oa.lm;var la=la||k();if("undefined"!==typeof u){var kb={};f.XS=
function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.Ic;kb[A]||(kb[A]=f(h.keyData,p));if("process"===h.Ma)return kb[A].process(h.buffer),null;if("finish"===h.Ma)return h=kb[A].finish(),kb[A]=null,h;h=kb[A].wB(h.buffer);kb[A]=null;return h};f.vT=function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.Ic;kb[A]||(kb[A]=f(h.keyData,p));if("process"===h.Ma)return kb[A].process(h.buffer),null;if("finish"===h.Ma)return p=kb[A].finish(),p=ba.Jl(p,h.XD),kb[A]=null,p;
p=kb[A].wB(h.buffer);p=ba.Jl(p,h.XD);kb[A]=null;return p};f.generateKey=function(h){var p={"SHA-1":64,"SHA-224":64,"SHA-256":64,"SHA-384":128,"SHA-512":128},A=h.algorithm.length;void 0===A&&(A=p[h.algorithm.hash.name.toUpperCase()]);return{type:"keyGeneration",keyData:nb.ze(A),keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:"secret"}}};f.importKey=function(h){if("jwk"===h.format){var p=Ia.Yl(h.keyData,h.algorithm,["k"]);p.alg=p.alg.replace("HS","SHA-")}else if("raw"===
h.format)p={k:ba.yc(h.keyData)};else throw Error("unsupported import format");return{type:"keyImport",keyData:p.k,keyHandle:{algorithm:{name:"HMAC",hash:{name:h.algorithm.hash.name}},extractable:h.extractable||p.extractable,usages:h.usages,type:"secret"}}};f.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.Cp(h.keyHandle,h.keyData)};if("raw"===h.format)return{type:"keyExport",keyHandle:h.keyData};throw Error("unsupported export format");};u.register("importKey","HMAC",
f.importKey);u.register("exportKey","HMAC",f.exportKey);u.register("generateKey","HMAC",f.generateKey);u.register("sign","HMAC",f.XS);u.register("verify","HMAC",f.vT)}var Fb=function(){var h,p,A,R,F,t,m,r,y,C;return{Cg:function(M){function B(n,z){return[n[4*z],n[4*z+1],n[4*z+2],n[4*z+3]]}function v(n){for(var z=0;z<n.length;z+=1)n[z]=y[n[z]]}function G(n){for(var z=0;z<n.length;z+=1)n[z]=r[n[z]]}function H(n,z,w){for(var K=0;K<n.length;K+=1)n[K]^=z[K+w]}function O(n,z){return[n[0]^z[0],n[1]^z[1],
n[2]^z[2],n[3]^z[3]]}function U(n){var z=n[13];n[13]=n[9];n[9]=n[5];n[5]=n[1];n[1]=z;z=n[10];n[10]=n[2];n[2]=z;z=n[14];n[14]=n[6];n[6]=z;z=n[3];n[3]=n[7];n[7]=n[11];n[11]=n[15];n[15]=z}function ia(n){var z=n[1];n[1]=n[5];n[5]=n[9];n[9]=n[13];n[13]=z;z=n[2];n[2]=n[10];n[10]=z;z=n[6];n[6]=n[14];n[14]=z;z=n[15];n[15]=n[11];n[11]=n[7];n[7]=n[3];n[3]=z}h||(h=ba.Yp("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",
256,!1),p=h[0],A=h[1],R=h[2],F=h[3],t=h[4],m=h[5],r=h[6],y=h[7],C=h[8]);var Z=8*M.length;switch(Z){case 128:case 192:case 256:break;default:throw Error("Unsupported keyLength");}var ma=Z/32;var X=ma+6;var x=function(n){for(var z=[],w=0;w<4*ma;)z.push(n[w++]);for(w=ma;w<4*(X+1);){n=B(z,w-1);if(0===w%ma){var K=[C[w/ma],0,0,0],S=n,W=S[0];S[0]=S[1];S[1]=S[2];S[2]=S[3];S[3]=W;G(n);n=O(n,K)}else 6<ma&&4===w%ma&&G(n);K=O(B(z,w-ma),n);n=z;S=w;n[4*S]=K[0];n[4*S+1]=K[1];n[4*S+2]=K[2];n[4*S+3]=K[3];w+=1}return z}(M);
return{encrypt:function(n){var z;H(n,x,0);for(z=1;z<=X-1;z+=1){G(n);ia(n);var w=n,K=w[0],S=w[1],W=w[2],T=w[3],L=w[4],P=w[5],aa=w[6],ua=w[7],La=w[8],Ya=w[9],Pa=w[10],sa=w[11],fa=w[12],ha=w[13],pa=w[14],ya=w[15];w[0]=p[K]^A[S]^W^T;w[1]=K^p[S]^A[W]^T;w[2]=K^S^p[W]^A[T];w[3]=A[K]^S^W^p[T];w[4]=p[L]^A[P]^aa^ua;w[5]=L^p[P]^A[aa]^ua;w[6]=L^P^p[aa]^A[ua];w[7]=A[L]^P^aa^p[ua];w[8]=p[La]^A[Ya]^Pa^sa;w[9]=La^p[Ya]^A[Pa]^sa;w[10]=La^Ya^p[Pa]^A[sa];w[11]=A[La]^Ya^Pa^p[sa];w[12]=p[fa]^A[ha]^pa^ya;w[13]=fa^p[ha]^
A[pa]^ya;w[14]=fa^ha^p[pa]^A[ya];w[15]=A[fa]^ha^pa^p[ya];H(n,x,16*z)}G(n);ia(n);H(n,x,16*X);return n},decrypt:function(n){var z;H(n,x,16*X);for(z=X-1;1<=z;--z){U(n);v(n);H(n,x,16*z);var w=n,K=w[0],S=w[1],W=w[2],T=w[3],L=w[4],P=w[5],aa=w[6],ua=w[7],La=w[8],Ya=w[9],Pa=w[10],sa=w[11],fa=w[12],ha=w[13],pa=w[14],ya=w[15];w[0]=R[K]^t[S]^F[W]^m[T];w[1]=m[K]^R[S]^t[W]^F[T];w[2]=F[K]^m[S]^R[W]^t[T];w[3]=t[K]^F[S]^m[W]^R[T];w[4]=R[L]^t[P]^F[aa]^m[ua];w[5]=m[L]^R[P]^t[aa]^F[ua];w[6]=F[L]^m[P]^R[aa]^t[ua];w[7]=
t[L]^F[P]^m[aa]^R[ua];w[8]=R[La]^t[Ya]^F[Pa]^m[sa];w[9]=m[La]^R[Ya]^t[Pa]^F[sa];w[10]=F[La]^m[Ya]^R[Pa]^t[sa];w[11]=t[La]^F[Ya]^m[Pa]^R[sa];w[12]=R[fa]^t[ha]^F[pa]^m[ya];w[13]=m[fa]^R[ha]^t[pa]^F[ya];w[14]=F[fa]^m[ha]^R[pa]^t[ya];w[15]=t[fa]^F[ha]^m[pa]^R[ya]}U(n);v(n);H(n,x,0);return n},clear:function(){},vU:Z,blockSize:128}}}}(),Bd=Bd||{};Bd.kQ=function(h){return{Hp:function(p){var A=p[0<=p.length-1?p.length-1:0],R=A.length;if(R===h){A=[];for(R=0;R<h;R+=1)A.push(h);p.push(A)}else for(p=h-R&255;A.length!==
h;)A.push(p)},Zp:function(p){var A=!0;0!==p.length%h&&(A=!1);for(var R=p.slice(-h),F=R[R.length-1],t=0;t<h;t++){var m=R[t]===F;A=(h-t<=F?m:!0)&&A}p.length-=A?F:0;return A}}};if("undefined"!==typeof u){var fb={};e.bq=function(h){var p=h.Ic;fb[p]||(fb[p]=e(Fb.Cg(h.keyData)),fb[p].xd(h.algorithm.iv));if("process"===h.Ma)return fb[p].Lu(h.buffer);if("finish"===h.Ma)return h=fb[p].lp(),fb[p]=null,h;h=fb[p].encrypt(h.buffer);fb[p]=null;return h};e.aq=function(h){var p=h.Ic;fb[p]||(fb[p]=e(Fb.Cg(h.keyData)),
fb[p].xd(h.algorithm.iv));if("process"===h.Ma)fb[p].Jp(h.buffer);else{if("finish"===h.Ma)return h=fb[p].kp(),fb[p]=null,h;h=fb[p].decrypt(h.buffer);fb[p]=null;return h}};e.generateKey=function(h){if(0!==h.algorithm.length%8)throw Error();return{type:"keyGeneration",keyData:nb.ze(Math.floor(h.algorithm.length/8)),keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:"secret"}}};e.importKey=function(h){var p=8*h.keyData.length;if("jwk"===h.format)p=Ia.Yl(h.keyData,h.algorithm,
["k"]);else if("raw"===h.format){if(128!==p&&192!==p&&256!==p)throw Error("invalid key length (should be 128, 192, or 256 bits)");p={k:ba.yc(h.keyData)}}else throw Error("unsupported import format");h.algorithm.length=8*p.k.length;return{keyData:p.k,keyHandle:{algorithm:h.algorithm,extractable:h.extractable||p.extractable,usages:h.usages,type:"secret"},type:"keyImport"}};e.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.Cp(h.keyHandle,h.keyData)};if("raw"===h.format)return{type:"keyExport",
keyHandle:h.keyData};throw Error("unsupported export format");};u.register("importKey","AES-CBC",e.importKey);u.register("exportKey","AES-CBC",e.exportKey);u.register("generateKey","AES-CBC",e.generateKey);u.register("encrypt","AES-CBC",e.bq);u.register("decrypt","AES-CBC",e.aq)}if("undefined"!==typeof u){var gb={};d.encrypt=function(h){var p=h.Ic;gb[p]||(gb[p]=d(Fb.Cg(h.keyData)),gb[p].xd(h.algorithm.iv,h.algorithm.additionalData,h.algorithm.tagLength));if("process"===h.Ma)gb[p].Lu(h.buffer);else{if("finish"===
h.Ma)return h=gb[p].lp(),gb[p]=null,h;h=gb[p].encrypt(h.buffer);gb[p]=null;return h}};d.decrypt=function(h){var p=h.Ic;gb[p]||(gb[p]=d(Fb.Cg(h.keyData)),gb[p].xd(h.algorithm.iv,h.algorithm.additionalData,h.algorithm.tagLength));if("process"===h.Ma)gb[p].Jp(h.buffer);else{if("finish"===h.Ma){h=gb[p].kp();gb[p]=null;if(null===h)throw Error("OperationError");return h}var A=h.algorithm.tagLength?Math.floor(h.algorithm.tagLength/8):16;h=gb[p].decrypt(h.buffer.slice(0,h.buffer.length-A),h.buffer.slice(-A));
gb[p]=null;if(null===h)throw Error("OperationError");return h}};d.generateKey=function(h){if(0!==h.algorithm.length%8)throw Error();return{type:"keyGeneration",keyData:nb.ze(Math.floor(h.algorithm.length/8)),keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:"secret"}}};d.importKey=function(h){var p=8*h.keyData.length;if("jwk"===h.format)p=Ia.Yl(h.keyData,h.algorithm,["k"]);else if("raw"===h.format){if(128!==p&&192!==p&&256!==p)throw Error("invalid key length (should be 128, 192, or 256 bits)");
p={k:ba.yc(h.keyData)}}else throw Error("unsupported import format");return{type:"keyImport",keyData:p.k,keyHandle:{algorithm:h.algorithm,extractable:h.extractable||p.extractable,usages:h.usages,type:"secret"}}};d.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.Cp(h.keyHandle,h.keyData)};if("raw"===h.format)return{type:"keyExport",keyHandle:h.keyData};throw Error("unsupported export format");};u.register("importKey","AES-GCM",d.importKey);u.register("exportKey","AES-GCM",
d.exportKey);u.register("generateKey","AES-GCM",d.generateKey);u.register("encrypt","AES-GCM",d.encrypt);u.register("decrypt","AES-GCM",d.decrypt)}var nb=new l,Vg=function(){function h(R){R=nb.ze(Math.ceil(R/8));R[0]|=128;R[R.length-1]|=1;return la.Kh(R)}var p=[],A=[];return{ZB:function(R){R=h(R);var F=0,t=[],m,r;var y=R.length-1;var C=la.DE,M=R[y];if(0===p.length){var B=Array(16385);var v=[];var G=Math.sqrt(16384)|0;for(m=3;m<=G;m+=2)for(r=m*m;16384>=r;r+=2*m)B[r]=0;for(m=3;16384>=m;m+=2)0!==B[m]&&
v.push(m);p=v}r=p.length;A=Array(r);for(B=0;B<r;B++){v=y;m=p[B];M<m?(G=M,v--):G=0;for(;0<=v;)G=G*C+R[v--],G-=(G/m|0)*m;A[B]=G}for(;;){a:{C=A.length;for(y=0;y<C;y++)if(0===(A[y]+F)%p[y]){y=!1;break a}y=!0}if(y){la.add(R,[F],t);a:{B=t;y=[];la.Xc(B,[1],y);m=y;if(la.RC(m))C=0;else{for(v=0;0===m[v];v++);M=0;for(C=2;0===m[v]%C;C*=2,M++);C=v*la.lq+M}M=[];la.WD(y,M,C);G=B;if(la.RC(G))v=0;else{for(r=G.length-1;0===G[r];r--);m=la.lq-1;for(v=1<<m;0<m&&0===(G[r]&v);v>>>=1,m--);v=r*la.lq+m}B=la.fi(B);for(m=1;6>=
m;m++){r=!1;do var H=h(v);while(0<=la.Of(H,y));G=[];B.Mj(H,M,G,!0);if(0!==la.Of(G,[1])&&0!==la.Of(G,y)){for(H=1;H<C;H++){B.Nj(G,G,G);if(0===la.Of(G,y)){r=!0;break}if(0===la.Of(G,[1])){y=!1;break a}}if(!1===r){y=!1;break a}}}y=!0}if(!0===y)return t}F+=2}}}}(),Mc={Ep:function(h,p,A){var R=[],F,t=A.tu/8;for(F=0;F<=Math.floor(p/t);F+=1){var m=[F>>>24&255,F>>>16&255,F>>>8&255,F&255];m=A.Yd(h.concat(m));R=R.concat(m)}return R.slice(0,p)},YT:function(h,p){if(h.length>(p.maxMessageSize||4294967295))throw Error("message too long");
}},bc=bc||{};bc.cQ=function(h,p){var A=ba,R=nb,F=h.n.length;if(null===p)throw Error("must supply hashFunction");return{Hp:function(t,m){if(t.length>F-p.tu/8*2-2)throw Error("Message too long.");null==m&&(m=[]);m=p.Yd(m);var r=A.xc(F-t.length-2*m.length-2);r=m.concat(r,[1],t);t=R.ze(m.length);var y=Mc.Ep(t,F-m.length-1,p);r=A.cf(r,y);m=Mc.Ep(r,m.length,p);m=A.cf(t,m);return t=[0].concat(m,r).slice()},Zp:function(t,m){var r=m;m=0;var y=0===t[0];void 0===r&&(r=[]);r=p.Yd(r);var C=t.slice(1,r.length+
1);t=t.slice(r.length+1);var M=Mc.Ep(t,r.length,p);C=A.cf(C,M);C=Mc.Ep(C,F-r.length-1,p);t=A.cf(t,C);C=t.slice(0,r.length);y=y&&A.Jl(r,C);for(t=t.slice(r.length);!t[m++];);return{valid:y,data:t.slice(m)}}}};"undefined"!==typeof u&&(b.sign=function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.algorithm.saltLength,R=h.algorithm.salt;return b(h.keyData,h.algorithm.name,p).WS(h.buffer,A,R)},b.verify=function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.algorithm.saltLength;
return b(h.keyData,h.algorithm.name,p).wT(h.XD,h.buffer,A)},b.bq=function(h){switch(h.algorithm.name){case "RSAES-PKCS1-V1_5":var p=b(h.keyData,h.algorithm.name);h=p.encrypt(h.buffer);break;case "RSA-OAEP":p=h.keyHandle.algorithm.hash.name;if(!p)throw Error("unsupported hash algorithm");p=ea[p.toUpperCase()]();p=b(h.keyData,h.algorithm.name,p);h=p.encrypt(h.buffer);break;default:throw Error("unsupported algorithm");}return h},b.aq=function(h){switch(h.algorithm.name){case "RSAES-PKCS1-V1_5":var p=
b(h.keyData,h.algorithm.name);h=p.decrypt(h.buffer);break;case "RSA-OAEP":p=h.keyHandle.algorithm.hash.name;if(!p)throw Error("unsupported hash algorithm");p=ea[p.toUpperCase()]();p=b(h.keyData,h.algorithm.name,p);h=p.decrypt(h.buffer);break;default:throw Error("unsupported algorithm");}return h},b.importKey=function(h){if("jwk"===h.format){var p=Ia.Yl(h.keyData,h.algorithm,"n e d p q dp dq qi".split(" "));p.d&&(p.$t=(new la.fi(la.Kh(p.p))).Eg,p.au=(new la.fi(la.Kh(p.q))).Eg)}else if("spki"===h.format){var A=
Aa.parse(h.keyData);if(null==A)throw Error("invalid key data.");A=A[1];A=Aa.parse(A.data.slice(A.Jg+1),!0);if(null==A)throw Error("invalid key data.");p=A[0];A=A[1];if("INTEGER"!==p.type||"INTEGER"!==A.type)throw Error("invalid key data.");p=p.data.slice(p.Jg);A=A.data.slice(A.Jg);0===p[0]&&p[1]&128&&(p=p.slice(1));0===A[0]&&A[1]&128&&(A=A.slice(1));p={n:p,e:A}}else if("pkcs8"===h.format){A=Aa.parse(h.keyData);if(null==A)throw Error("invalid key data.");A=A[2];A=Aa.parse(A.data.slice(A.Jg),!0);if(null==
A)throw Error("invalid key data.");var R="n e d p q dp dq qi".split(" ");p={};for(var F=1;F<A.length;F++){var t=A[F];t=t.data.slice(t.Jg);0===t[0]&&t[1]&128&&(t=t.slice(1));p[R[F-1]]=t}}else throw Error("unsupported key import format.");return{type:"keyImport",keyData:p,keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:p.d||p.dq?"private":"public"}}},b.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.Cp(h.keyHandle,h.keyData)};if("spki"===
h.format)return h=Aa.encode({pi:[{pi:[{"OBJECT IDENTIFIER":"1.2.840.113549.1.1.1"},{zF:1}]},{"BIT STRING":{pi:[{Ad:h.keyData.n},{Ad:h.keyData.e}]}}]}),{type:"keyExport",keyHandle:h};if("pkcs8"===h.format)return h=Aa.encode({pi:[{Ad:0},{pi:[{"OBJECT IDENTIFIER":"1.2.840.113549.1.1.1"},{zF:1}]},{"OCTET STRING":{pi:[{Ad:0},{Ad:h.keyData.n},{Ad:h.keyData.e},{Ad:h.keyData.d},{Ad:h.keyData.p},{Ad:h.keyData.q},{Ad:h.keyData.dp},{Ad:h.keyData.dq},{Ad:h.keyData.qi}]}}]}),{type:"keyExport",keyHandle:h};throw Error(h.format+
" not implemented");},b.genRsaKeyFromRandom=function(h,p){p=p?la.Kh(p):[65537];do{var A=Vg.ZB(h/2),R=Vg.ZB(h/2);if(0<la.Of(R,A)){var F=A;A=R;R=F}F=[];la.multiply(A,R,F);var t=[];la.Xc(A,[1],t);var m=[];la.Xc(R,[1],m);var r=[];la.multiply(t,m,r);var y=[];la.FO(p,r,y);y=0===la.Of(y,la.DF)}while(!y);h=[];la.Eu(p,r,h);r=[];la.reduce(h,t,r);t=[];la.reduce(h,m,t);m=[];la.Eu(R,A,m);y=la.OB;return{privateKey:{n:y(F),e:y(p),d:y(h),p:y(A),q:y(R),dp:y(r),dq:y(t),qi:y(m)},publicKey:{n:y(F),e:y(p)}}},b.Pl=function(h){if("undefined"===
typeof h.algorithm.modulusLength)throw Error("missing modulusLength");var p=la.Kh;switch(h.algorithm.modulusLength){case 1024:case 2048:case 4096:var A=b.genRsaKeyFromRandom(h.algorithm.modulusLength,h.algorithm.publicExponent);break;default:throw Error("invalid modulusLength");}var R=A.privateKey;R.$t=(new la.fi(p(R.p))).Eg;R.au=(new la.fi(p(R.q))).Eg;p=h.algorithm.name;"RSASSA-PKCS1-V1_5"===p||"RSA-PSS"===p?(p=["verify"],R=["sign"]):(p=["encrypt"],R=["decrypt"]);return{type:"keyGeneration",Rf:{publicKey:{keyData:A.publicKey,
keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:p,type:"public"}},privateKey:{keyData:A.privateKey,keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:R,type:"private"}}}}},u.register("sign","RSASSA-PKCS1-V1_5",b.sign),u.register("sign","RSA-PSS",b.sign),u.register("verify","RSASSA-PKCS1-V1_5",b.verify),u.register("verify","RSA-PSS",b.verify),u.register("encrypt","RSAES-PKCS1-V1_5",b.bq),u.register("decrypt","RSAES-PKCS1-V1_5",b.aq),u.register("encrypt","RSA-OAEP",
b.bq),u.register("decrypt","RSA-OAEP",b.aq),u.register("importKey","RSA-OAEP",b.importKey),u.register("importKey","RSAES-PKCS1-V1_5",b.importKey),u.register("importKey","RSASSA-PKCS1-V1_5",b.importKey),u.register("importKey","RSA-PSS",b.importKey),u.register("exportKey","RSA-OAEP",b.exportKey),u.register("exportKey","RSAES-PKCS1-V1_5",b.exportKey),u.register("exportKey","RSASSA-PKCS1-V1_5",b.exportKey),u.register("exportKey","RSA-PSS",b.exportKey),u.register("generateKey","RSA-OAEP",b.Pl),u.register("generateKey",
"RSAES-PKCS1-V1_5",b.Pl),u.register("generateKey","RSASSA-PKCS1-V1_5",b.Pl),u.register("generateKey","RSA-PSS",b.Pl));var Gb=function(){return{deriveBits:function(h){var p=ea[h.algorithm.hash.name.toUpperCase()](),A=h.algorithm,R=Qa.yc(A.RT).concat(Qa.yc(A.yU),Qa.yc(A.zU),Qa.yc(A.EU)||[],Qa.yc(A.CU)||[]);A=Math.ceil(h.length/p.tu);var F=1;R=h.keyData.concat(R);for(var t=[],m=0;m<A;m++){var r=Qa.LC(F++).concat(R);r=p.Yd(r);t=t.concat(r)}return t.slice(0,h.length/8)}}}();"undefined"!==typeof u&&(Gb.importKey=
function(h){if("raw"===h.format)var p=ba.yc(h.keyData);else throw Error("unsupported import format");if(!1!==h.extractable)throw Error("only extractable=false is supported.");return{type:"keyImport",keyData:p,keyHandle:{algorithm:{name:"CONCAT"},extractable:!1,usages:h.usages,type:"secret"}}},u.register("deriveBits","CONCAT",Gb.deriveBits),u.register("importKey","CONCAT",Gb.importKey));var Qa=ba;var Nc=function(){function h(B){return{process:function(v){return B.process(v)},finish:function(){return B.finish()},
abort:function(){return B.abort()}}}function p(){var B;return{postMessage:function(v){try{v.Ic=this.id,B=qb.TC({data:v})}catch(G){this.onerror({data:G,type:"error"});return}this.onmessage({data:B})},onmessage:null,onerror:null,terminate:function(){}}}function A(B){var v,G;var H=new Promise(function(O,U){v=O;G=U});return{dispatchEvent:function(O){"error"===O.type?G&&(O.data&&(O.data.stack="Error")&&(O.data.code=0),G.apply(H,[O.data||O])):"process"===O.data.type?B(O.data.result,!0):"finish"===O.data.type?
B(O.data.result,!0):(this.result=B(O.data),v.apply(H,[this.result]))},promise:H,result:null}}function R(){return A(function(B){switch(B.type){case "keyGeneration":case "keyImport":case "keyDerive":if(B.Rf)return r.add(B.Rf.publicKey.keyHandle,B.Rf.publicKey.keyData),r.add(B.Rf.privateKey.keyHandle,B.Rf.privateKey.keyData),{publicKey:B.Rf.publicKey.keyHandle,privateKey:B.Rf.privateKey.keyHandle};r.add(B.keyHandle,B.keyData);return B.keyHandle;case "keyExport":return B.keyHandle;case "keyPairGeneration":var v=
B.Rf.privateKey;B=B.Rf.publicKey;r.add(B.keyHandle,B.keyData);r.add(v.keyHandle,v.keyData);return{publicKey:B.keyHandle,privateKey:v.keyHandle};default:throw Error("Unknown key operation");}})}function F(B){var v=[],G=A(function(H,O){var U;if(U=H)U=ca&&H.pop?(new Uint8Array(H)).buffer:H;H=U;if(O)v.resolve(H);else return H});G.stream=B.algorithm.stream;v.add=function(H){var O,U,ia=new Promise(function(Z,ma){O=Z;U=ma});ia.label=H;v.push({resolve:O,reject:U,promise:ia});return ia};v.resolve=function(H){var O=
v.shift();O.resolve.apply(O.promise,[H])};G.process=function(H){B.Ma="process";B.buffer=Qa.yc(H);y.zB(this,Qa.clone(B));return v.add("process")};G.finish=function(){B.Ma="finish";B.buffer=[];y.zB(this,Qa.clone(B));return v.add("finish")};G.abort=function(){y.wN(this)};G.algorithm=B.algorithm||null;G.key=B.keyHandle||null;return G}function t(B){B=r.PP(B);if(!B)throw Error("key not found");return B}function m(B,v,G){var H=B,O={operationType:H},U;"importKey"!==H||"raw"!==v[0]&&"spki"!==v[0]&&"pkcs8"!==
v[0]||(H="importKeyRaw");"importKey"===H&&"jwk"===v[0]&&(H="importKeyJwk");H=M[H];for(U=0;U<H.length;U+=1){var ia=C[H[U]];var Z=v[U];if(null==Z){if(ia.required)throw Error(ia.name);}else{Z.subarray&&(Z=Qa.yc(Z));"ArrayBuffer"===Qa.pu(Z)&&(Z=Qa.yc(Z));if(ba.pu(Z)!==ia.type)throw Error(ia.name);"algorithm"===ia.name&&(Z.name=Z.name.toUpperCase(),Z.iv&&(Z.iv=Qa.yc(Z.iv)),Z.publicExponent&&(Z.publicExponent=Qa.yc(Z.publicExponent)),Z.salt&&(Z.salt=Qa.yc(Z.salt)),Z.additionalData&&(Z.additionalData=Qa.yc(Z.additionalData)),
Z.hash&&!Z.hash.name&&"String"===Qa.pu(Z.hash)&&(Z.hash={name:Z.hash}));O.hasOwnProperty(ia.name)?O[ia.name+"1"]=Z:O[ia.name]=Z}}if(!u.UB(B,O.algorithm.name))throw Error("unsupported algorithm");O.keyHandle&&(O.keyData=t(O.keyHandle));O.zu&&(O.HP=t(O.zu));O.algorithm&&O.algorithm.public&&(O.QT=t(O.algorithm.public));v=G?R(O):F(O);(G||O.buffer||"deriveBits"===B||"wrapKey"===B)&&y.XQ(v,O);return v.stream?Promise.resolve(h(v)):v.promise}var r=[];r.add=function(B,v){r.push({keyHandle:B,keyData:v})};r.remove=
function(B){for(var v=0;v<r.length;v+=1)if(r[v].keyHandle===B){r=r.splice(v,1);break}};r.PP=function(B){for(var v=0;v<r.length;v+=1)if(r[v].keyHandle===B)return r[v].keyData;return null};var y=function(){function B(){K.shift()()}function v(T){K.push(T);S(B,0)}function G(T){for(var L=0;L<x.length;L++)if(x[L]===T){T.terminate();x.splice(L,1);break}}function H(T){for(var L=0;L<x.length;L++)if(x[L].Vc===T)return x[L];return null}function O(T,L){n.push({Vc:T,data:L,id:z++})}function U(T){T.Xo=!1;if(da)if(0<
n.length){T=n.shift();var L;ma(T.Vc,T.data);if("process"===T.data.Ma){for(L=0;L<n.length;L++)T.Vc===n[L].Vc&&ma(n[L].Vc,n[L].data);for(L=n.length-1;0<=L;L--)T.Vc===n[L].Vc&&n.splice(L,1)}}else{for(var P=L=0;P<x.length;P++)x[P].Xo||(L+=1);2<L&&G(T)}}function ia(T){if("pending"===W)throw Error("Creating new worker while workerstatus=pending");if("ready"===W)try{var L=new Worker(ka);L.postMessage({Ku:nb.ze(48)});L.yu=!0}catch(P){da=!1,W="failed",L.terminate(),L=p(),L.yu=!1}else L=p(),L.yu=!1;L.Vc=T;
L.id=w++;L.Xo=!1;L.onmessage=function(P){if(!0!==P.data.IC){var aa=L.Vc;P.target||(P.target={data:L.data});for(var ua=0;ua<n.length;ua++)if(n[ua].Vc===L.Vc){P=n[ua];n.splice(ua,1);X(L,P.data);return}P.data.hasOwnProperty("type")&&"process"===P.data.type||U(L);aa.dispatchEvent(P)}};L.onerror=function(P){var aa=L.Vc;U(L);aa.dispatchEvent(P)};x.push(L);return L}function Z(T,L){if("pending"===W)O(T,L);else{a:{var P=!da;for(var aa=x.length-1;0<=aa;--aa)x[aa].yu===P&&(x[aa].terminate(),x.splice(aa,1));
for(P=0;P<x.length;P++)if(!x[P].Xo){P=x[P];break a}P=null}if(da&&null===P&&12<=x.length)O(T,L);else{null===P&&(P=ia(T));if(null===P)throw O(T,L),Error("could not create new worker");P.Vc=T;P.Xo=!0;L.Ic=P.id;X(P,L)}}}function ma(T,L){var P=H(T);P?X(P,L):Z(T,L)}function X(T,L){L.Ic=T.id;da?T.postMessage(L):v(function(P){return function(){return T.postMessage(P)}}(L))}var x=[],n=[],z=0,w=0,K=[],S="undefined"===typeof setImmediate?setTimeout:setImmediate,W=ja?"available":"unavailable";return{XQ:Z,zB:ma,
wN:function(T){(T=H(T))&&G(T)},$p:function(T){function L(aa){var ua=!(!aa.data||!0!==aa.data.IC);P.removeEventListener("message",L,!1);P.removeEventListener("error",L,!1);P.terminate();W=ua?"ready":"failed";da=ua;Qa.Vt("web worker initialization "+(ua?"succeeded. Now using web workers.":"failed. running synchronously."+(aa.message||"")));0<n.length&&(aa=n.shift(),Z(aa.Vc,aa.data))}if("unavailable"===W)Qa.Vt("web workers not available in this browser.");else if(!0!==T||"ready"!==W)if(!1!==T||"available"!==
W)if(!1===T&&"ready"===W)da=!1,W="available",Qa.Vt("web workers disabled.");else if("pending"!==W){W="pending";var P=new Worker(ka);P.addEventListener("message",L,!1);P.addEventListener("error",L,!1);P.postMessage({Ku:nb.ze(48)})}}}}(),C=[{name:"algorithm",type:"Object",required:!0},{name:"keyHandle",type:"Object",required:!0},{name:"buffer",type:"Array",required:!1},{name:"signature",type:"Array",required:!0},{name:"format",type:"String",required:!0},{name:"keyData",type:"Object",required:!0},{name:"extractable",
type:"Boolean",required:!1},{name:"usages",type:"Array",required:!1},{name:"derivedKeyType",type:"Object",required:!0},{name:"length",type:"Number",required:!1},{name:"extractable",type:"Boolean",required:!0},{name:"usages",type:"Array",required:!0},{name:"keyData",type:"Array",required:!0}],M={encrypt:[0,1,2],decrypt:[0,1,2],sign:[0,1,2],verify:[0,1,3,2],digest:[0,2],generateKey:[0,6,7],importKeyRaw:[4,12,0,10,11],importKeyJwk:[4,5,0,10,11],exportKey:[0,4,1,6,7],deriveKey:[0,1,8,6,7],deriveBits:[0,
1,9],wrapKey:[1,1,0],unwrapKey:[2,0,1,6,7]};return{pQ:{encrypt:function(B,v,G){return m("encrypt",arguments,0)},decrypt:function(B,v,G){return m("decrypt",arguments,0)},sign:function(B,v,G){return m("sign",arguments,0)},verify:function(B,v,G,H){return m("verify",arguments,0)},digest:function(B,v){return m("digest",arguments,0)},generateKey:function(B,v,G){return m("generateKey",arguments,1)},deriveKey:function(B,v,G,H,O){var U=this.deriveBits,ia=this.importKey;return new Promise(function(Z,ma){switch(G.name.toUpperCase()){case "AES-CBC":case "AES-GCM":var X=
G.length;break;case "HMAC":X=G.length||{"SHA-1":512,"SHA-224":512,"SHA-256":512,"SHA-384":1024,"SHA-512":1024}[G.hash.name.toUpperCase()];break;default:ma(Error("No Supported"));return}U(B,v,X).then(function(x){return ia("raw",x,G,H,O)}).then(function(x){Z(x)})["catch"](function(x){ma(x)})})},deriveBits:function(B,v,G){return m("deriveBits",arguments,0)},importKey:function(B,v,G,H,O){return m("importKey",arguments,1)},exportKey:function(B,v){return m("exportKey",[v.algorithm,B,v],1)},wrapKey:function(B,
v,G,H){var O=this.encrypt,U=this.exportKey;return new Promise(function(ia,Z){if(!1===v.extractable||0>G.usages.indexOf("wrapKey")||G.algorithm.name.toUpperCase()!==H.name)Z(Error("InvalidAccessError"));else U(B,v).then(function(ma){console.log(Qa.fe(ma));return O(H,G,"jwk"===B?Qa.Wj(JSON.stringify(ma,null,0)):ma)}).then(function(ma){ia(ma)})["catch"](function(ma){Z(ma)})})},unwrapKey:function(B,v,G,H,O,U,ia){var Z=this.decrypt,ma=this.importKey;return new Promise(function(X,x){if(0>G.usages.indexOf("unwrapKey")||
G.algorithm.name.toUpperCase()!==H.name)x(Error("InvalidAccessError"));else Z(H,G,v).then(function(n){return ma(B,"jwk"===B?JSON.parse(Qa.oB(n)):n,O,U,ia)}).then(function(n){X(n)})["catch"](function(n){x(n)})})}},mP:{$p:y.$p}}}();Gb=function(){var h=ba;return{wrapKey:function(p){var A=b(p.HP,p.zu.algorithm.name,ea["SHA-1"])(),R=Ia.IP(p.keyHandle,p.keyData);p=h.fe(JSON.stringify({alg:p.zu.algorithm.name.toUpperCase(),enc:"A128GCM"}),!0);var F=nb.ze(32);A=A.encrypt(F);A=h.fe(A,!0);var t=nb.ze(12),m=
h.fe(t,!0),r=p.concat(".",A,".",m);F=d(Fb.Cg(F));F.xd(t,h.Wj(r),128);F=F.encrypt(R);t=F.slice(-16);R=h.fe(t,!0);F=h.fe(F.slice(0,F.length-t.length),!0);return h.Wj(JSON.stringify({am:[{Jg:p,QB:A,lP:R}],HC:m,VN:F}))},unwrapKey:function(p){var A=h.Ol,R=JSON.parse(String.fromCharCode.apply(null,p.buffer));h.Ol(R.am[0].Jg);var F=A(R.am[0].QB),t=A(R.am[0].lP),m=A(R.HC);A=A(R.VN);var r=ea["SHA-1"]();F=b(p.keyData,p.keyHandle.algorithm.name,r).decrypt(F);R=R.am[0].Jg.concat(".",R.am[0].QB,".",R.HC);F=d(Fb.Cg(F));
F.xd(m,h.Wj(R),128);t=F.decrypt(A,t);t=Ia.Yl(t,p.algorithm,["k"]);return{type:"keyImport",keyData:t.k,keyHandle:{algorithm:{name:p.algorithm.name},extractable:p.extractable||t.extractable,usages:p.usages,type:"secret"}}}}}();"undefined"!==typeof u&&(u.register("wrapKey","AES-GCM",Gb.wrapKey),u.register("unwrapKey","AES-CBC",Gb.unwrapKey));Gb={subtle:Nc?Nc.pQ:null,getRandomValues:function(h){var p,A=nb.ze(h.length);for(p=0;p<h.length;p+=1)h[p]=A[p];return h},qU:function(h){var p=Object.prototype.toString.call(h);
if("[object Array]"!==p&&"[object Uint8Array]"!==p)throw Error("entropyData must be a Array or Uint8Array");cc&&cc.fm(h);nb.fm(cc.read(48))},fe:function(h,p){return ba.fe(h,p)},Ol:function(h){return ba.Ol(h)},KU:function(h){return ba.Wj(h)},XT:function(h){return ba.oB(h)},VT:Aa,url:ka,version:"1.6.6",$p:function(h){return Nc?Nc.mP.$p(h):null}};var cc=cc||new E(a);cc.xd();var $g=cc.read(48);nb.xd($g);return Gb}()});
function qa(){Promise.all=function(a){function b(e,f){return function(g){c[e]=g;d+=1;d===a.length&&f(c)}}var c=[],d=0;return new Promise(function(e,f){function g(l){f(l)}var k;for(k=0;k<a.length;k+=1)a[k].then?(a[k].then(b(k,e)),a[k]["catch"](g)):Promise.resolve(a[k]).then(b(k,e))})};Promise.race=function(a){function b(d){return function(e){c||(c=!0,d(e))}}var c=!1;return new Promise(function(d,e){for(var f=0;f<a.length;f+=1)a[f].then(b(d),b(e))})};Promise.reject=function(a){return new Promise(function(b,
c){c(a)})};Promise.resolve=function(a){return new Promise(function(b){b(a)})};return Promise}"undefined"===typeof Promise&&void 0!==window.Promise&&(this.Promise=qa());
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(d){var e=(new Date).getTime(),f=Math.max(0,16-(e-a)),g=window.setTimeout(function(){d(e+f)},f);a=e+f;return g});window.cancelAnimationFrame||(window.cancelAnimationFrame=
function(d){clearTimeout(d)})})();var ra;ra={yq:1,Wg:2,GT:3,IT:4,HT:5,hw:5};var ta;ta=function(a){this.g=a};ta.prototype={CB:function(a){var b=this;return function(c,d,e,f,g,k){c=b.OH(e,b.g.A.ma,c,d,f,a,g);return k?c:b.g.ud(c)}},OH:function(a,b,c,d,e,f,g){var k,l=1;f=new za(f);for(var E;k=e.pop();)E=new za(k.id),E.vq(l),f.iw(E),l+=this.fH(k.WC);a=new Ba(a,b,c,d);a.ce(f);(g instanceof Ga||g instanceof Ha)&&a.Qb(g);return a},fH:function(a){var b=0;do++b,a>>>=1;while(0!==a);return b}};var D;D=function(){};
D.lk=function(){return D.JA};D.EE=function(){return D.fI};D.mi=function(a){var b=new I(a.offsetX,a.offsetY);null!==a.currentTarget&&(b=J.RP(a.currentTarget,b));return b};D.yy=function(a){var b=new I(a.offsetLeft,a.offsetTop);a.offsetParent&&(a=D.yy(a.offsetParent),b.X+=a.X,b.Y+=a.Y);return b};D.OA=!1;D.Cq=function(a){var b=this.zG(a);null!==b&&(a=D.yy(a.target),b.X-=a.X,b.Y-=a.Y);return b};
D.zG=function(a){return a.pageX&&a.target?new I(a.pageX,a.pageY):(D.OA||(D.OA=!0,N.error("Evaluation of Touch events not supported because the browser uses an unexpected interface")),null)};D.pK=navigator.userAgent.match(/OS 6(_\d)+ like Mac OS X/i);D.hP=function(){return D.pK};D.XE=function(){var a=void 0!==window.TouchEvent&&"ontouchstart"in window&&"ontouchend"in document;return void 0!==window.PointerEvent&&void 0!==navigator.maxTouchPoints&&0<navigator.maxTouchPoints||a};
D.WE=function(a){return J.Cm(a.RuntimeVersion,16)};D.UE=function(a,b){return J.Cm(a.RuntimeVersion,18)&&2147527629!=b.ci};D.SE=function(a){return J.Cm(a.RuntimeVersion,18,10)};D.cw=function(){return void 0!==document.scrollingElement};D.TE=function(){return void 0!==window.atob&&(void 0!==window.crypto&&void 0!==window.crypto.subtle||void 0!==window.msrCrypto&&void 0!==window.msrCrypto.subtle)};
D.Py=function(a,b){a.style.cssText+="outline: none; -webkit-tap-highlight-color: rgba(0,0,0,0);  -webkit-user-select: none;";b&&(a.style.cssText+="display:block;");a.addEventListener("MSHoldVisual",function(c){c.preventDefault()})};D.df=function(){return window.devicePixelRatio?window.devicePixelRatio:1};D.sq=function(){return void 0!==window.visualViewport};D.sF=function(a,b){D.Py(a,2E3);D.Py(b,1E3)};D.Yz=function(a){if(void 0!==a&&null!==a&&!(0<=a.indexOf("%")))return parseFloat(a)};
D.$z=function(a){if(void 0===a)return null;a=a.split(/[\s,]/);return 4>a.length?null:new Ja(parseFloat(a[2]),parseFloat(a[3]))};D.TM=function(a){var b=new XMLHttpRequest;b.open("GET",a.src,!1);b.send();return b.responseXML&&b.responseXML.documentElement?b.responseXML&&b.responseXML.documentElement:null};
D.YG=function(a,b){var c=new XMLHttpRequest;c.open("GET",a.src);c.onreadystatechange=function(){4===c.readyState&&(200===c.status?c.responseXML&&c.responseXML.documentElement?b(c.responseXML.documentElement):b(null):b(null))};c.send()};
D.cM=function(a){try{if(0<=a.src.toLowerCase().indexOf(".svg")){N.h("Derivation of SVG size for '"+a.src+"' failed. Parsing manually");var b=D.TM(a);if(null!==b){var c=D.Yz(b.getAttribute("width"));var d=D.Yz(b.getAttribute("height"));if(c&&d)return new Ja(c,d);var e=D.$z(b.getAttribute("viewBox"));if(null!==e)return e}}}catch(f){N.error("Exception during manual parsing of SVG size.")}return null};
D.$v=function(a){if(a.naturalWidth&&a.naturalHeight)return new Ja(a.naturalWidth,a.naturalHeight);if(a.width&&a.height)return new Ja(a.width,a.height);a=D.cM(a);return null!==a?a:new Ja(0,0)};D.Gq=function(){return D.gM};D.mJ="undefined"!==typeof InstallTrigger;D.vF=function(a,b,c){return!D.mJ&&!c.WorkaroundForceSVGEmptySizeWorkaround||c.WorkaroundDisableSVGEmptySizeWorkaround?!1:J.Rq(b)&&void 0!==a.naturalWidth&&0===a.naturalWidth&&void 0!==a.naturalHeight&&0===a.naturalHeight};
D.HE=function(a,b,c){try{D.YG(a,function(d){if(null===d)c("DoZeroWidthHeightWorkaround: svg xml not available");else{var e=D.$z(d.getAttribute("viewBox"));null===e?c("DoZeroWidthHeightWorkaround: no view box available"):(d.setAttribute("width",e.L),d.setAttribute("height",e.aa),d=(new XMLSerializer).serializeToString(d),b("data:image/svg+xml;base64,"+btoa(d)))}})}catch(d){c(d.toString())}};
D.Tb=function(){return"onpointerdown"in window&&"PointerEvent"in window&&!Ka.QE("CFG_WorkaroundDisablePointerEvents",!1)};D.Zv=function(){var a=Ka.RE("CFG_WorkaroundFileTransferTimeout");return null!==a?a:D.Gq()?400:0};D.gM=-1!==navigator.userAgent.indexOf("Safari")&&0>navigator.userAgent.indexOf("Chrome");var Ma="undefined"===typeof ArrayBuffer||"undefined"===typeof Uint8Array||"undefined"===typeof Int8Array,Na,Ra;Ma||(Na=new ArrayBuffer(4),Ra=new Int8Array(Na,1,2),Ma=2!==Ra.byteLength);D.JA=Ma;
D.fI=function(){if(D.JA)return!1;var a="undefined"!==typeof DataView,b;if(/opera [56789]|opera\/[56789]/i.test(navigator.userAgent)||/MSIE (\d+\.\d+);/.test(navigator.userAgent))return!1;try{if(a){var c=new ArrayBuffer(8);var d=new Int8Array(c);for(b=0;8>b;++b)d[b]=b;var e=new DataView(c);if(a="function"===typeof e.getFloat64&&"function"===typeof e.getFloat32&&"function"===typeof e.getInt32&&"function"===typeof e.getUint32&&"function"===typeof e.getInt16&&"function"===typeof e.getUint16&&"function"===
typeof e.getInt8&&"function"===typeof e.getInt8)e.getFloat64(0),e.getFloat32(0),e.getInt32(0),e.getUint32(0),e.getInt16(0),e.getUint16(0),e.getInt8(0),e.getInt8(0)}}catch(f){return!1}return a}();D.Bb=function(a,b){return void 0!==a.includes?a.includes(b):0<=a.indexOf(b)};D.hG=function(a,b){return void 0!==a.startsWith?a.startsWith(b):0===a.lastIndexOf(b,0)};
D.Xv=function(){try{var a=void 0!==navigator.languages?navigator.languages.length?navigator.languages[0]:navigator.language:navigator.language;var b=a.split("-");b.length&&(a=b[0]);return a}catch(c){return""}};D.ei=function(){return window.WindowZoomFactor?1E-4<=Math.abs(parseFloat(window.WindowZoomFactor)-1):!1};D.hk=function(a){var b=D.qq();b&&a.hm(1/b);return a};D.qq=function(){return parseFloat(window.WindowZoomFactor)};var Configuration;
Configuration=function(){this.PlcAddress="0101";this.UseLocalHost=!0;this.CommBufferSize=5E4;this.ErrorReconnectTime=1E4;this.Application="Application";this.UpdateRate=200;this.BestFitForDialogs=this.BestFit=!1;this.StartVisu="Visualization";this.StartVisuDefaultEncodingBase64="";this.XhrSendTimeout=0;this.LoginVisuDefLang=this.LoginVisuNamespace=this.LoginVisuErrorTexts=this.LoginVisuTexts=this.LoginVisu="";this.PollingRegistrationInterval=100;this.TimeMeasurements="";this.LogLevel="INFO";this.MaxUnusedImageAge=
2E4;this.MaxUndrawnImageAge=1E4;this.NumCachedImages=15;this.ChangeWindowTitle=!0;this.TooltipFont="";this.DefaultKeyActions=!0;this.KeysForWebVisu="Backspace,Tab";this.ANSIStringEncoding="iso-8859-1";this.CommitEditcontrolOnClickOut=!0;this.HandleTouchEvents=!1;this.FuzzyTransparencyColorEvaluation=!0;this.TouchHandlingActive=this.Benchmarking=this.HasKeyboard=this.LoadImagesById=!1;this.ClientName="";this.ScaleTypeIsotropic=this.IecSupportsCommonMiterLimit=this.SemiTransparencyActive=!1;this.GesturesFlickPanThresholdPxPerSecond=
1E3;this.GesturesPanFlickTimeThresholdMs=40;this.GesturesPanClickThresholdDistSquare=10;this.PostDataInHeader=0;this.Qq=this.AutoFontReductionActive=!1;this.ProgrammingSystemModeWaitingText="The online visualization is waiting for a connection. Please start the application.";this.ProgrammingSystemModeErrorText="Some sort of error occurred during the Visualisation.";this.ConnectionInfoValidTimeMsForLeaveAfterError=1E3;this.WorkaroundDisableMouseUpDownAfterActiveTouch=!0;this.WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch=
500;this.WorkaroundForceSVGEmptySizeWorkaround=this.WorkaroundDisableSVGEmptySizeWorkaround=this.WorkaroundDisableSVGAspectRatioWorkaround=this.WorkaroundDisableResizeHandling=!1;this.ContentSecurityPolicyIncludeTrustedOrigins=this.RuntimeVersion=this.CasFactoryName="";this.DefaultConfigurationOnError=!1;this.MaxResizePixel=30;this.FillBackground=!1;this.Oq=5E3;this.WebSocketsDisabled=this.UseBrowserLanguage=this.ContextMenuDisabled=this.TouchContextMenuEnabled=this.DebugHTML5=this.DebugOnlyInputReactionExplCoord=
this.DebugOnlyInputReactionOnUp=this.DebugOnlyDiagnosisDisplay=this.DebugOnlyPrintTouchRectangles=this.DebugOnlyPrintGestures=this.DebugOnlyPrintRawTouches=this.DebugOnlyPrintPaintCommands=!1;this.Kw=500;this.Lw=1E4;this.Mw=!1};
Configuration.prototype={validate:function(){if("string"!==typeof this.PlcAddress)throw Error("Plc address must be of type string");if("boolean"!==typeof this.UseLocalHost)throw Error("UseLocalHost must be of type boolean");if("number"!==typeof this.CommBufferSize)throw Error("CommBufferSize must be of type number");if("number"!==typeof this.ErrorReconnectTime)throw Error("ErrorReconnectTime must be of type number");if("string"!==typeof this.Application)throw Error("Application must be of type string");
if("number"!==typeof this.UpdateRate)throw Error("UpdateRate must be of type number");if("number"!==typeof this.MaxResizePixel)throw Error("MaxResizePixel must be of type number");void 0!==this.LoginMaxResizePixel&&30===this.MaxResizePixel&&(this.MaxResizePixel=this.LoginMaxResizePixel);if("boolean"!==typeof this.BestFit)throw Error("BestFit must be of type boolean");if("boolean"!==typeof this.BestFitForDialogs)throw Error("BestFitForDialogs must be of type boolean");if("string"!==typeof this.StartVisu)throw Error("StartVisu must be of type string");
if("string"!==typeof this.LoginVisu)throw Error("LoginVisu must be of type string");if("string"!==typeof this.LoginVisuTexts)throw Error("LoginVisuTexts must be of type string");if("string"!==typeof this.LoginVisuErrorTexts)throw Error("LoginVisuErrorTexts must be of type string");if("string"!==typeof this.LoginVisuNamespace)throw Error("LoginVisuNamespace must be of type string");if("string"!==typeof this.LoginVisuDefLang)throw Error("LoginVisuDefLang must be of type string");if("number"!==typeof this.PollingRegistrationInterval)throw Error("PollingRegistrationInterval must be of type number");
if("string"!==typeof this.TimeMeasurements)throw Error("TimeMeasurements must be of type string");if("string"!==typeof this.TooltipFont)throw Error("TooltipFont must be of type string");if("boolean"!==typeof this.DefaultKeyActions)throw Error("DefaultKeyActions must be of type boolean");if("string"!==typeof this.ANSIStringEncoding)throw Error("ANSIStringEncoding must be of type string");if("boolean"!==typeof this.FuzzyTransparencyColorEvaluation)throw Error("FuzzyTransparencyColorEvaluation must be of type boolean");
if("boolean"!==typeof this.LoadImagesById)throw Error("LoadImagesById must be of type boolean");if("boolean"!==typeof this.Benchmarking)throw Error("Benchmarking must be of type boolean");if("boolean"!==typeof this.TouchHandlingActive)throw Error("TouchHandlingActive must be of type boolean");if("boolean"!==typeof this.HasKeyboard)throw Error("HasKeyboard must be of type boolean");if("boolean"!==typeof this.SemiTransparencyActive)throw Error("SemiTransparencyActive must be of type boolean");if("boolean"!==
typeof this.ScaleTypeIsotropic)throw Error("ScaleTypeIsotropic must be of type boolean");if("number"!==typeof this.GesturesFlickPanThresholdPxPerSecond||0>this.GesturesFlickPanThresholdPxPerSecond)throw Error("GesturesFlickPanThresholdPxPerSecond must be of type nonnegative number");if("number"!==typeof this.GesturesPanFlickTimeThresholdMs||0>this.GesturesPanFlickTimeThresholdMs)throw Error("GesturesPanFlickTimeThresholdMs must be of type nonnegative number");if("number"!==typeof this.GesturesPanClickThresholdDistSquare||
0>this.GesturesPanClickThresholdDistSquare)throw Error("GesturesPanClickThresholdDistSquare must be of type nonnegative number");if("number"!==typeof this.PostDataInHeader||0>this.PostDataInHeader||2<this.PostDataInHeader)throw Error("PostDataInHeader must be a number in the range 0..2");if("boolean"!==typeof this.AutoFontReductionActive)throw Error("AutoFontReductionActive must be of type boolean");if("boolean"!==typeof this.Qq)throw Error("UseUTF8Encoding must be of type boolean");if("string"!==
typeof this.ProgrammingSystemModeWaitingText)throw Error("ProgrammingSystemModeWaitingText must be of type string");if("string"!==typeof this.ProgrammingSystemModeErrorText)throw Error("ProgrammingSystemModeErrorText must be of type string");if("number"!==typeof this.ConnectionInfoValidTimeMsForLeaveAfterError)throw Error("ConnectionInfoValidTimeMsForLeaveAfterError must be of type number");if("boolean"!==typeof this.FillBackground)throw Error("FillBackground must be of type boolean");if("boolean"!==
typeof this.DebugOnlyPrintPaintCommands)throw Error("DebugOnlyPrintPaintCommands must be of type boolean");if("boolean"!==typeof this.DebugOnlyPrintRawTouches)throw Error("DebugOnlyPrintRawTouches must be of type boolean");if("boolean"!==typeof this.DebugOnlyPrintGestures)throw Error("DebugOnlyPrintGestures must be of type boolean");if("boolean"!==typeof this.DebugOnlyPrintTouchRectangles)throw Error("DebugOnlyPrintTouchRectangles must be of type boolean");if("boolean"!==typeof this.DebugOnlyDiagnosisDisplay)throw Error("DebugOnlyDiagnosisDisplay must be of type boolean");
if("boolean"!==typeof this.DebugOnlyInputReactionOnUp)throw Error("DebugOnlyInputReactionOnUp must be of type boolean");if("boolean"!==typeof this.DebugOnlyInputReactionExplCoord)throw Error("DebugOnlyInputReactionExplCoord must be of type boolean");if("boolean"!==typeof this.WorkaroundDisableMouseUpDownAfterActiveTouch)throw Error("WorkaroundDisableMouseUpDownAfterActiveTouch must be of type boolean");if("boolean"!==typeof this.WorkaroundDisableResizeHandling)throw Error("WorkaroundDisableResizeHandling must be of type boolean");
if("number"!==typeof this.WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch||0>this.WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch)throw Error("WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch must be of type nonnegative number");if("string"!==typeof this.CasFactoryName)throw Error("CasFactoryName must be of type string");if("string"!==typeof this.RuntimeVersion)throw Error("RuntimeVersion must be of type string");if("string"!==typeof this.ContentSecurityPolicyIncludeTrustedOrigins)throw Error("ContentSecurityPolicyIncludeTrustedOrigins must be of type string");
if("number"!==typeof this.Oq)throw Error("TouchSanityInterval must be of type number");if("boolean"!==typeof this.ContextMenuDisabled)throw Error("ContextMenuDisabled must be of type boolean");if("boolean"!==typeof this.TouchContextMenuEnabled)throw Error("TouchContextMenuEnabled must be of type boolean");if("boolean"!==typeof this.WebSocketsDisabled)throw Error("WebSocketsDisabled must be of type boolean");if("number"!==typeof this.Kw)throw Error("WebSocketConnectTimeout must be of type number");
if("number"!==typeof this.Lw)throw Error("WebSocketKeepAliveInterval must be of type number");if("boolean"!==typeof this.Mw)throw Error("WebSocketsFallbackDisabled must be of type boolean");this.Hg()},uC:function(){try{return new Sa(this.TooltipFont)}catch(a){return this.TooltipFont=""}},Hg:function(){return new na(this.ANSIStringEncoding)},wd:function(){return new oa(this.ANSIStringEncoding)}};var Ta;
Ta=function(a,b,c,d,e){this.CommBufferSize=a;this.Ia=b;this.ff=c;this.wq=d;this.ci=Ua.xa;this.ma=Ua.l;this.Aq="";this.dG=e;this.iq=!1;this.Jc=""};Ta.prototype={AR:function(a){this.Jc=a}};var Va;Va=function(){};Va.qm="";Va.wF="";Va.mq="2";Va.eq="3";Va.HF="4";Va.uG="5";Va.cG="6";var Wa;Wa=function(){};Wa.h="NOSP";Wa.xa="---";Wa.l=1E3;Wa.J=1100;var $a;$a=function(){};$a.ProgrammingSystemModeErrorText="Some sort of error occurred during the Visualisation.";$a.ProgrammingSystemModeWaitingText="The online visualization is waiting for a connection. Please start the application.";
$a.h=1;$a.Sb=$a.h;$a.l=$a.h+1;$a.xa=$a.h+2;$a.J=$a.h+3;$a.ab=$a.h+4;$a.Yc=$a.h+5;var ab;ab=function(a,b,c,d,e,f,g,k,l){this.Tr=a;this.mb=d%360;this.sH=e;this.tH=f;this.Qr=g;(0===this.Qr||2===this.Qr)&&180<this.mb?(this.mb-=180,this.bn=k?c:l,this.xk=b):(this.bn=b,this.xk=k?c:l)};
ab.prototype={QO:function(a,b){if(0===b.C()||0===b.B())return"#ffffff";switch(this.Qr){case 0:return this.hx(a,b,!1);case 1:return this.gH(a,b);case 2:return this.hx(a,b,!0);default:return"#ffffff"}},hx:function(a,b,c){var d=b.Ql();var e=90<this.mb?Q.rm(180-this.mb):Q.rm(this.mb);var f=d.X-Math.max(b.B(),b.C())*Math.cos(e);var g=d.Y-Math.max(b.B(),b.C())*Math.sin(e);if(this.uz(d.X,d.Y,f,g,b.u,b.v,b.u,b.da)){d=e;e=b.C()/2*Math.tan(d);e=b.B()/2-e;d=Math.PI/2-d;d=e*Math.cos(d);f=d*d/e;g=e-f;var k=Math.sqrt(Math.max(0,
g*f));e=b.u-k;d=b.v+g;f=b.Z+k;g=b.da-g}else this.uz(d.X,d.Y,f,g,b.u,b.v,b.Z,b.v)?(d=e,e=b.B()/2/Math.tan(d),e=b.C()/2-e,d=Math.PI/2-d,d=Math.cos(d)*e,f=d*d/e,k=Math.sqrt(Math.max(0,(e-f)*f)),e=b.u+f,d=b.v-k,f=b.Z-f,g=b.da+k):(e=b.u,d=b.v,f=b.Z,g=b.da);90<this.mb&&(e=b.Z-(e-b.u),f=b.Z-(f-b.u));a=a.createLinearGradient(e,d,f,g);a.addColorStop(0,this.bn);c?(a.addColorStop(.45,this.xk),a.addColorStop(.55,this.xk),a.addColorStop(1,this.bn)):a.addColorStop(1,this.xk);return a},gH:function(a,b){var c=new I(b.u+
b.C()*this.sH,b.v+b.B()*this.tH);b=this.IJ(b,c);a=a.createRadialGradient(c.X,c.Y,0,c.X,c.Y,b);a.addColorStop(0,this.bn);a.addColorStop(1,this.xk);return a},uz:function(a,b,c,d,e,f,g,k){var l=(k-f)*(c-a)-(g-e)*(d-b);g=(g-e)*(b-f)-(k-f)*(a-e);a=(c-a)*(b-f)-(d-b)*(a-e);if(0===l)return g===a;b=g/l;l=a/l;return 0<=b&&1>=b&&0<=l&&1>=l},IJ:function(a,b){var c=[];c[0]=this.jn(new I(a.u,a.v),b);c[1]=this.jn(new I(a.Z,a.v),b);c[2]=this.jn(new I(a.Z,a.da),b);c[3]=this.jn(new I(a.u,a.da),b);for(a=b=0;4>a;++a)b=
Math.max(b,c[a]);return Math.sqrt(b)},jn:function(a,b){return(a.X-b.X)*(a.X-b.X)+(a.Y-b.Y)*(a.Y-b.Y)}};var bb;bb=function(a){this.g=a;this.bs()};
bb.prototype={bs:function(){var a=this;window.document.addEventListener("keydown",function(b){a.dL(b)},!1);window.document.addEventListener("keypress",function(b){a.eL(b)},!1);window.document.addEventListener("keyup",function(b){a.fL(b)},!1)},eL:function(a){if(a.repeat)a.preventDefault();else{var b=this.g.A;a=this.Gn(a);null!==b&&null!==a&&this.g.ud(Ba.ab(b.ma,a))}},dL:function(a){if(a.repeat)a.preventDefault();else{var b=this.By(a),c=this.g.A;this.Qz("onKeyDown",b)||(this.kx(a),null!==c&&null!==
b&&void 0!==b.key&&this.g.ud(Ba.J(128,c.ma,b.key,b.flags)))}},fL:function(a){var b=this.By(a),c=this.g.A;this.Qz("onKeyUp",b)||(this.kx(a),null!==c&&null!==b&&void 0!==b.key&&this.g.ud(Ba.J(256,c.ma,b.key,b.flags)))},Qz:function(a,b){return this.g.Rc&&window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess[a]&&window.ProgrammingSystemAccess[a](b.key,b.flags)?!0:!1},By:function(a){var b=a.keyCode,c=0;if(16<=b&&18>=b)return null;a.shiftKey&&(c|=1);a.altKey&&(c|=2);a.ctrlKey&&(c|=4);return{key:b,
flags:c}},Gn:function(a){var b=0;a.charCode?b=a.charCode:a.which&&(b=a.which);if(0===b||void 0!==a.altKey&&!0===a.altKey&&48<=b&&57>=b)return null;if(void 0!==a.ctrlKey&&a.ctrlKey||void 0!==a.altKey&&a.altKey)if(void 0===a.ctrlKey||!a.ctrlKey||void 0===a.altKey||!a.altKey)return null;return String.fromCharCode(b)},GL:function(a){var b;if(void 0===this.g.getConfiguration().KeysForWebVisu||""===this.g.getConfiguration().KeysForWebVisu)return!1;var c=this.g.getConfiguration().KeysForWebVisu.split(",");
for(b=0;b<c.length;b++)if(c[b]==a.key)return!0;return!1},kx:function(a){J.J(this.g)||null===this.g.getConfiguration()||this.g.getConfiguration().DefaultKeyActions&&!this.GL(a)||a.preventDefault&&a.preventDefault()}};var cb;cb=function(a){this.g=a;this.Ln=!1;this.Zr=0;this.JK=[];this.h()};
cb.prototype={JD:function(a){this.Ln=a},ZR:function(a){this.Zr=a},TS:function(a){this.Pr().style.touchAction=a?"none":"auto"},h:function(){var a=this;if(D.Tb()){var b=!this.g.la;N.h("Mouse-Handling using PointerEvents");this.me("pointerup",function(c){a.il(c)},b);this.me("pointerdown",function(c){a.mo(c)},b);this.me("pointermove",function(c){a.hl(c)},b);this.me("pointerout",function(c){a.mL(c)},b)}else N.h("Mouse-Handling using MouseEvents"),this.me("mouseup",function(c){a.lo(c)},!1),this.me("mousedown",
function(c){a.jo(c)},!1),this.me("mousemove",function(c){a.ko(c)},!1),this.me("mouseout",function(c){a.iL(c)},!1),this.me("touchstart",function(c){a.ug(c)},!0),this.me("touchmove",function(c){a.ug(c)},!0),this.me("touchend",function(c){a.ug(c)},!0)},Pr:function(){return this.g.la?this.g.bb():this.g.V().Gg().canvas},me:function(a,b,c){this.Pr().addEventListener(a,b,c,{passive:!1});this.JK.push({type:a,callback:b,LU:c})},rn:function(a,b){if(null!==this.g.A){var c=D.mi(a);this.g.la&&(a=J.$j(a.target,
this.Pr()),c=c.offset(a));b=Ba.h(b,this.g.A.ma,c);this.g.ud(b)}},Sn:function(a){var b=this.g.getConfiguration();null===b||"touch"!==a.pointerType||b.TouchHandlingActive||("pointerup"===a.type?this.g.Le.hp():"pointerout"===a.type?(this.g.Le.fp(),this.g.Le.hp()):"pointerdown"===a.type&&this.g.Le.fp());return null!==b&&b.TouchHandlingActive?"touch"!==a.pointerType:a.isPrimary},mo:function(a){!J.J(this.g)&&this.Sn(a)&&(a.preventDefault(),this.Wi(a))},il:function(a){!J.J(this.g)&&this.Sn(a)&&(a.preventDefault(),
this.Xi(a))},hl:function(a){!J.J(this.g)&&this.Sn(a)&&(a.preventDefault(),this.Gy(a))},mL:function(a){!J.J(this.g)&&this.Sn(a)&&(a.preventDefault(),this.Hy(a))},Xi:function(a){J.Pq(a)&&(this.g.ub.aD(a),this.rn(a,db.h))},Wi:function(a){J.Pq(a)&&(this.g.le.ap(a),this.g.ub.$C(a),this.rn(a,db.J))},Gy:function(a){this.Ln||this.rn(a,db.l)},Hy:function(a){null!==a.relatedTarget&&void 0!==a.relatedTarget&&"string"===typeof a.relatedTarget.nodeName&&"html"!==a.relatedTarget.nodeName.toLowerCase()||this.rn(a,
4096)},lo:function(a){J.J(this.g)||(J.l()<this.Zr?N.h("Dropping mouse up due to required delay!"):this.Xi(a))},jo:function(a){J.J(this.g)||(J.l()<this.Zr?N.h("Dropping mouse down due to required delay!"):this.Wi(a))},ko:function(a){J.J(this.g)||this.Gy(a)},iL:function(a){J.J(this.g)||this.Hy(a)},ug:function(a){if(!J.J(this.g)&&null!==this.g.getConfiguration()&&this.g.getConfiguration().HandleTouchEvents&&!this.g.getConfiguration().TouchHandlingActive){var b=null;switch(a.type){case "touchstart":var c=
db.J;this.Ln=!0;break;case "touchmove":c=db.l;break;case "touchend":c=db.h;this.Ln=!1;break;default:return}a.touches&&1<=a.touches.length?b=D.Cq(a.touches[0]):a.changedTouches&&1<=a.changedTouches.length&&(b=D.Cq(a.changedTouches[0]));null!==b&&(null!==this.g.A&&(c===db.J?this.g.ub.kT(b,a):c==db.h&&this.g.ub.jT(b,a),c=Ba.h(c,this.g.A.ma,b),this.g.ud(c)),a.preventDefault())}}};var hb;hb=function(a,b,c){this.jh=a;this.eI=b;this.qr=c;this.Rz=Ga.F(1E3)};
hb.prototype={SP:function(){return this.eI-this.Rz.size()},Zd:function(){return this.Rz},finish:function(){this.qr=0},Kg:function(){return 0===this.qr}};var ib;ib=function(a){this.Tn=0!==(a&65536);this.Tz=0!==(a&131072);this.Uz=0!==(a&262144);this.Vz=0!==(a&524288);this.Sz=0!==(a&1048576);this.Yy=0!==(a&2097152);this.Zy=0!==(a&4194304);this.Tn=this.Tn||this.Yy||this.Zy;this.wK=!(this.Tz||this.Uz||this.Vz||this.Sz)};
ib.prototype={vu:function(){return this.left()||this.right()||this.sv()},QC:function(){return this.top()||this.bottom()||this.tv()},PC:function(){return this.left()||this.top()},OC:function(){return this.right()||this.bottom()},Uc:function(){return this.wK},left:function(){return this.Tz},right:function(){return this.Uz},top:function(){return this.Vz},bottom:function(){return this.Sz},mm:function(){return this.Uc()&&this.Tn},tv:function(){return this.Uc()&&this.Zy},sv:function(){return this.Uc()&&
this.Yy}};var lb;lb=function(a,b){this.g=a;this.Bi=b};lb.prototype={dR:function(){var a=this.g.La();D.UE(this.g.getConfiguration(),this.Bi)||this.sM(a);this.pM(a)},sb:function(){},O:function(){},pM:function(a){var b=this.g.ib(this.Bi);b.rO();a.tb(b.kb(),this,!0)},sM:function(a){var b=this.g.ib(this.Bi);b.yv(this.Bi.ma);a.tb(b.kb(),this,!0)}};var ob;
ob=function(a,b,c,d,e){this.g=a;this.Ai=null;b=this.h(b);e?c=b:(this.te=new pb,c=this.h(c));if(b.width!==c.width||b.height!==c.height)throw Error("Expected two canvasses of the same size");D.sF(b,c);this.Oa=this.Lk(b);this.Ub=this.Lk(c);this.rN=Ka.bk(this.g.Ag,"WorkaroundDisableDPRBasedZoom",!1);this.qN=Ka.bk(this.g.Ag,"WorkaroundAnisoAddWidthPixel",!1);this.pN=Ka.bk(this.g.Ag,"WorkaroundAnisoAddHeightPixel",!1);d&&(this.su()||this.l(),this.iu(1));this.Cn=new sb;this.xr=D.df();this.Dn=new tb(this.Ub);
this.$f=new tb(this.Oa);this.zi=new ub;this.Zs=this.$s=null;this.Eh=!1;this.kg=new vb;this.Qk=new wb(this.g);this.Jo=new yb(this);this.ut=new zb(this);this.mr=!1;this.rI=new Ab(a);this.lh=0;this.mj=this.Co=1;this.rl=null;this.Nn=!1};
ob.prototype={Qf:function(){return new Bb(0,0,this.Oa.canvas.width,this.Oa.canvas.height)},Rl:function(){return null!==this.Ai?this.Ai:this.Ub},Gg:function(){return this.g.la?this.Oa:this.Ub},be:function(){return 0!==this.lh},NC:function(){return 2===this.lh},QR:function(){this.lh=0},OR:function(){this.lh=1},PR:function(){this.lh=2},GS:function(a){this.Co=a},HS:function(a){this.mj=a},FS:function(a){this.rl=a},ri:function(a){return new Bb(this.Hm(a.u),this.Im(a.v),this.Hm(a.Z),this.Im(a.da))},bG:function(a){var b;
for(b=0;b<a.length;++b)a[b].X=this.Hm(a[b].X),a[b].Y=this.Im(a[b].Y);return a},Hm:function(a){a*=this.Co;2==this.lh&&null!==this.rl&&(a+=this.rl.u);return Math.round(a)},Im:function(a){a*=this.mj;2==this.lh&&null!==this.rl&&(a+=this.rl.v);return Math.round(a)},clear:function(a){"undefined"===typeof a&&(a="#ffffff");this.g.hd&&this.g.hd.Ru();this.g.an&&this.g.an.Ru();this.Ub.clearRect(0,0,this.Ub.canvas.width,this.Ub.canvas.height);this.Oa.fillStyle=a;this.Oa.fillRect(0,0,this.Oa.canvas.width,this.Oa.canvas.height)},
Aj:function(){var a=J.cq(this.Oa.canvas);return new I(a.u,a.v)},getContext:function(){if(null!==this.Ai)return this.Ai;if(this.g.la){var a=this.g.ba().wa();var b=this.Eh?null!==a?a.V():this.Oa:null!==a?a.V():this.Ub;a=this.getState();this.zi.Uc()?a.Yh(b):b=a.Da;return b}a=null;b=this.te.Jt();-1!==b&&(a=this.te.Np(b));return this.Eh?null!==a?a.Oa:this.Oa:null!==a?a.fn:this.Ub},Yh:function(a){this.Ai=a.getContext("2d");this.$f=new tb(this.Ai)},St:function(){if(this.g.la){var a=this.g.ba().wa();if(null!==
a){a.St();return}}a=this.getContext();a.clearRect(0,0,a.canvas.width,a.canvas.height)},getState:function(){if(this.g.la)return this.zi.before()&&this.$s?this.$s:this.zi.after()&&this.Zs?this.Zs:this.$f;var a=null;var b=this.te.Jt();-1!==b&&(a=this.te.Np(b));return this.Eh?null!==a?a.$f:this.$f:null!==a?a.$G:this.Dn},rD:function(){this.Eh=!0;this.g.la&&(this.$f.Yh(this.Oa),this.$f.apply())},OQ:function(){this.Eh=!1;this.g.la&&(this.Dn.Yh(this.Ub),this.Dn.apply())},uB:function(){this.mr=!0},jp:function(a,
b,c){this.g.ub.$S(ra.yq);this.Cn.clear();this.Ub.save();this.Dn.Yh(this.Ub);this.$f.Yh(this.Oa);var d=this.NL(a,c);c=!1;var e=this;this.Nn=!1;for(a=0;a<d.length;++a)d[a]instanceof Cb&&!d[a].DC(this.Qk,this.kg)&&(c=!0),d[a]instanceof Db&&!this.g.la&&d[a].i(this);this.pH()?(c?(N.l("Waiting for image(s) to load"),this.Qk.KN(function(){N.l("Loading image(s) finished so continue with drawing");e.Nn=!0;e.Wx(d,b)})):(this.Nn=!0,this.Wx(d,b)),null!==this.g.ra&&this.g.ra.g.N.Zi&&this.yI()):b()},aQ:function(){this.xr=
D.df();(new Eb).cB("DevicePixelRatioChanged","true")},su:function(){return(new Eb).zC("DevicePixelRatioChanged")},l:function(){var a=D.df();(new Eb).cB("OriginalDevicePixelRatio",a)},VO:function(){var a=new Eb;return parseFloat(a.vp("OriginalDevicePixelRatio"))},br:function(a){this.Oa.canvas.width=this.Ub.canvas.width=a.L;this.Oa.canvas.height=this.Ub.canvas.height=a.aa;var b=this.g.bb();null!==b&&(b.style.height=a.aa+"px",b.style.width=a.L+"px",this.g.Rc||(b.style.overflow="hidden"))},Sx:function(){return new Ja(document.documentElement.clientWidth,
document.documentElement.clientHeight)},HJ:function(a,b,c){return 0<a.L-b.L?a.L-b.L:0<c.L-b.L?c.L-b.L:0},NJ:function(a,b,c){return 0<a.aa-b.aa?a.aa-b.aa:0<c.aa-b.aa?c.aa-b.aa:0},JG:function(a,b){var c=!1;var d=new Ja(window.innerWidth,window.innerHeight);var e=this.HJ(a,b,d);a=this.NJ(a,b,d);if(D.sq()){var f=window.visualViewport;b.L=Math.floor(f.width);b.aa=Math.floor(f.height)}0<e&&(b.L=D.sq()?Math.floor(f.width)+e:b.L-.5+e,this.qN&&(b.L+=1),c=!0);0<a&&(b.aa=D.sq()?Math.floor(f.height)+a:b.aa-.5+
a,this.pN&&(b.aa+=1),c=!0);return c},iu:function(a){this.rN?a=1:this.su()&&(a=this.WI());try{var b=this.Sx();this.br(b.scale(a));var c=this.Sx();(this.JG(b,c)||c.L>b.L||c.aa>b.aa)&&this.br(c.scale(a))}catch(d){N.warn("Exception during resizing canvasses: "+d),this.br((new Ja(window.innerWidth,window.innerHeight)).scale(a))}},TR:function(a,b,c){c?(this.zi.wS(),this.$s=this.DA(a,"cdsClip_before_canvas",b)):(this.zi.vS(),this.Zs=this.DA(a,"cdsClip_after_canvas",b))},DA:function(a,b,c){a=J.xa(a.P(),b);
if(null===a)return null;a=this.Lk(a);a=new tb(a);a.FT=c;a.yS();return a},tD:function(){this.zi.SQ()},Wx:function(a,b){this.mr&&(this.g.tB(),this.mr=!1);var c,d=this;if(this.g.Kb.nq){for(c=0;c<a.length;++c){var e=a[c];this.$I(e)}for(c=0;c<a.length;++c)e=a[c];this.Ub.restore()}else if(this.g.la){for(c=0;c<a.length;++c)a[c]instanceof Hb&&a[c].i(this);this.Cn.iB(this.Ub);for(c=0;c<a.length;++c)e=a[c],e instanceof Hb||a[c].i(this);this.Ub.restore()}else{var f=[];for(c=0;c<a.length;++c)e=a[c],e instanceof
Hb?e.i(this):e instanceof Ib&&f.push(e);this.Cn.iB(this.Ub);for(c=0;c<a.length;++c)e=a[c],e instanceof Hb||e instanceof Ib||e instanceof Db||a[c].i(this);this.Ub.restore();for(c=0;c<f.length;++c)f[c].i(this)}this.rI.xj();this.g.Il(function(){d.ZI()});this.YI();this.g.ub.zO(0===a.length,ra.yq);b()},ZI:function(){var a=this.g.PO();0!==a.length&&setTimeout(function(){window.requestAnimationFrame(function(){a.forEach(function(b){b()})})})},YI:function(){var a=this.g.LO();0!==a.length&&window.requestAnimationFrame(function(){a.forEach(function(b){b()})})},
$I:function(a){(a instanceof Jb||a instanceof Kb||a instanceof Lb||a instanceof Mb)&&a.i(this)},pH:function(){return null===this.g.ra||this.g.ra.g.N.Zi||!this.g.ra.g.N.zp()},NL:function(a,b){var c=[],d;if(0<a.jh){var e=Nb.F(a.Zd().Zd(),this.g.A.Ia,this.g.getConfiguration().Hg());e=new Ob(e);for(d=0;d<a.jh;++d)if(e.ga()<e.size()-4){var f=e.ga(),g=e.getUint32(),k=e.getUint32();var l=Pb.pE(k,e,g,this);if(void 0!==b&&null!==b)if(k=b(l),void 0!==k&&null!==k)for(l=0;l<k.length;l++)c.push(k[l]);else c.push(l);
else c.push(l);e.seek(f+g)}}else c=[];return c},h:function(a){var b=window.document.getElementById(a);if(null===b)throw Error("Canvas "+a+" does not exist");return b},Lk:function(a){a=a.getContext("2d");if(null===a)throw Error("Creating graphics context failed");return a},yI:function(){var a,b=this.g.ra;if(null!==b)for(a=0;a<b.ya.T.length;++a){var c=b.ya.wc(a);if(null!==c.info().Tu(0)){var d=b.Rd;if(null!==d){var e=this.Gg();e.save();d.Ip(this,c);e.restore()}}}},WI:function(){return(new Eb).zC("OriginalDevicePixelRatio")?
D.df()/this.VO():D.df()}};var Qb;Qb=function(a,b,c){this.$i=!1;this.fn=a;this.Oa=b;this.$G=new tb(this.fn);this.$f=new tb(this.Oa);this.nj=c};Qb.prototype={bS:function(a){this.$i=a},size:function(){return this.nj}};var tb;tb=function(a){this.Ui=null;this.wn="#ffffff";this.Jy=!1;this.ao="#000000";this.Yi=!1;this.Ue=.5;this.MA="#000000";this.Oe="12px Arial";this.Qi=12;a.font=this.Oe;this.Da=a;this.My=this.Ly=-1;this.Ws=new I(0,0);this.Rs=new I(0,0)};
tb.prototype={yS:function(){this.Yh(this.Da)},Yh:function(a){null!==a&&void 0!==a&&(this.Da=a,this.apply(),this.Yw())},bv:function(a,b){this.wn=a;this.Jy=b;this.Da.fillStyle=this.wn},ev:function(a,b,c,d,e,f){this.Ue=a;this.ao=b;this.Bf=c;this.jf=d;this.kf=e;this.Wf=f;this.Da.strokeStyle=this.ao;this.Da.lineWidth=Math.max(1,this.Ue);this.Da.lineCap=this.jf;this.Da.lineJoin=this.kf;this.Da.miterLimit=this.Wf;"function"===typeof this.Da.setLineDash?(this.Yi=!1,this.Yw()):this.Yi=5===this.Bf},ES:function(a,
b){if("number"!==typeof a)throw new TypeError("Expected numeric value");if("number"!==typeof b)throw new TypeError("Expected numeric value");this.Ly=a;this.My=b},VD:function(a,b,c){this.Oe=a;this.Qi=b;this.MA=c},apply:function(){this.Da.fillStyle!==this.wn&&(this.Da.fillStyle=this.wn);this.Da.strokeStyle!==this.ao&&(this.Da.strokeStyle=this.ao);this.Da.lineWidth!==this.Ue&&(this.Da.lineWidth=this.Ue);this.Da.lineCap!==this.jf&&(this.Da.lineCap=this.jf);this.Da.lineJoin!==this.kf&&(this.Da.lineJoin=
this.kf);this.Da.miterLimit!==this.Wf&&(this.Da.miterLimit=this.Wf)},Dj:function(){return this.Oe},uu:function(){return null===this.Ui?this.Jy:this.Ui.Tr},Ig:function(){return null!==this.Ui},WR:function(a){this.Ui=a},gm:function(){this.Ui=null;this.apply()},Vo:function(a){this.Da.fillStyle=this.Ui.QO(this.Da,a)},HD:function(a){this.Qi=a},Ug:function(a){this.Oe=a},Yw:function(){"function"===typeof this.Da.setLineDash&&(0===this.Bf&&this.Da.setLineDash([]),1===this.Bf&&this.Da.setLineDash([8,3]),2===
this.Bf&&this.Da.setLineDash([3,3]),3===this.Bf&&this.Da.setLineDash([8,3,3,3]),4===this.Bf&&this.Da.setLineDash([8,3,3,3,3,3]),5===this.Bf&&(this.Yi=!0,this.Da.setLineDash([0,0])))}};var pb;pb=function(){this.tl=[];this.nk=[]};pb.prototype={Np:function(a){return this.tl.length>a?this.tl[a]:null},CN:function(a,b){this.tl[a]=b},NQ:function(a){this.tl.length>a&&(this.tl[a]=null)},Jt:function(){return 0<this.nk.length?this.nk[this.nk.length-1]:-1},qQ:function(a){this.nk.push(a)},mQ:function(){return this.nk.pop()}};
var Rb;Rb=function(a,b,c,d,e,f){try{this.h(a,b,c,d,e,f)}catch(g){throw Error("Could not initialize the tooltip style. Error: "+g);}};Rb.prototype={h:function(a,b,c,d,e,f){this.Font=new Sa(b+"px "+a);this.Vv=Q.cb(c);this.Yj=d;this.Bv=Q.cb(e);this.Tv=Q.cb(f)}};var Sb;Sb=function(){};Sb.h="4.9.1.0";Sb.l=Sb.h;var Webvisu;
Webvisu=function(a,b,c,d,e,f){"undefined"===typeof f&&(f=!1);this.Ag=Ka.$F();this.kK();N.info("Webvisualization starting");N.info("Version: "+Sb.l);this.CH();this.Lm=this.pn=this.yg=this.Le=this.Pe=this.N=this.ra=this.qc=null;this.la=d;this.hi=!1;this.lc=null;void 0!==e&&e?(this.ob=new Configuration,this.Rc=this.hi=this.ob.SemiTransparencyActive=!0):this.nK(a,b,c,d,f)};window.Webvisu=Webvisu;
Webvisu.prototype={ba:function(){return this.hd.isActive()?this.hd:this.an},openDialog:function(a,b){this.hd.zN(a,b)},uc:function(){return this.vJ},bb:function(){return this.Ac},YN:function(a){this.hd.IQ(a)},ZS:function(a){this.hd.rQ(a)},xO:function(){return this.hd.nQ()},BD:function(a){this.ty=a},fS:function(a){this.fz=a},nK:function(a,b,c,d,e){this.Kr=[];this.zr=[];this.Ac=J.bb();this.le=new Tb(this);this.Bo();this.Lo=new Ub;this.ac=new Vb(this);this.hb=new ob(this,a,b,c,d);this.bs();this.qx=new ta(this);
new bb(this);this.ho=new cb(this);this.Li=new Wb(this);this.vJ=new Xb;this.an=Yb.zE(this.qx.CB(Zb.yG));this.hd=Yb.rE(this.qx.CB(Zb.CE));this.ic=new $b(this);this.ub=new ac(this);this.lK(this.hb.Gg().canvas.id);this.rq=new $a;this.Kb=new dc;this.Ni=new ec(this);this.ny=new fc(this);a=this.KO();this.oj=null;this.Db=new gc(new Configuration);this.Rc||e||(0<a?this.vl("Loading Webvisualization (delayed)"):this.vl("Loading Webvisualization"));this.qn=null;this.ty=!0;this.fz="";this.qb=-1;this.bx=new hc;
0<a&&null!==this.oj?this.D(new ic(this),a):(this.fd=new ic(this),this.my())},my:function(){var a=this.fd;null!==this.qn&&(null!==this.yb&&this.yb.push(this.qn),this.qn=null);this.fd=null;try{a.i()}catch(b){this.error("Unexpected Exception: "+b)}},Bo:function(){this.yb=this.ob=this.j=this.A=null;this.cA=!1;null!==this.ra&&(this.ra.rb(),this.ra=null);this.le.wu()&&this.le.close();null!==this.qc&&this.qc.detach();WebvisuExtensionMgr.nO()},bs:function(){var a=this;window.addEventListener("unload",function(b){a.gL(b)},
!1)},lK:function(a){window.WebvisuAutotestInst=new WebvisuAutotest(this,a);window.WebvisuAutotest_raiseMouse=window.WebvisuAutotestInst.raiseMouse;window.WebvisuAutotest_raiseKey=window.WebvisuAutotestInst.raiseKey;window.WebvisuExtensionMgr=WebvisuExtensionMgr;WebvisuExtensionMgr.rS(this.la);window.WebvisuExtensionMgr_register=window.WebvisuExtensionMgr.register;window.WebvisuExtensionMgr_openControlRelative=window.WebvisuExtensionMgr.openControlRelative;window.WebvisuInst=this},Il:function(a){this.zr.push(a)},
LO:function(){var a=this.zr;this.zr=[];return a},Po:function(a){this.Kr.push(a)},PO:function(){var a=this.Kr;this.Kr=[];return a},kK:function(){var a=Ka.zm(this.Ag,"CFG_LogLevel");"TRACE"===a?N.J(jc.Mq):"DEBUG"===a?N.J(jc.kq):N.J(jc.vm)},vl:function(a,b){var c=0,d=!1;null!==this.oj&&this.tB();"boolean"===typeof b&&(d=b);if(d||!this.UO()){""!==this.sC()&&(c=5E3);b=this.Rc;if("The maximum number of visualization clients is already connected. Please try again later."===a||"Not enough memory in the PLC to create the client."===
a)b=!0;this.oj=new kc(a,this.hb,b,c)}},tB:function(){null!==this.oj&&this.oj.close();this.oj=null},La:function(){null!==this.lc&&this.lc.je instanceof lc||(this.lc=new nc(this));return this.lc},ep:function(){this.lc=null},ib:function(a){a=void 0!==a?a:this.A;var b=null;"utf-8"===this.getConfiguration().ANSIStringEncoding&&(b=this.getConfiguration().wd());return null===a?new oc(!0,Ua.xa,5E4,b):new oc(a.Ia,a.ci,a.CommBufferSize,b)},setConfiguration:function(a){this.hi||("TRACE"===a.LogLevel?N.J(jc.Mq):
"DEBUG"===a.LogLevel?N.J(jc.kq):"INFO"===a.LogLevel?N.J(jc.vm):"WARNING"===a.LogLevel?N.J(jc.Jw):"ERROR"===a.LogLevel?N.J(jc.Rv):"FATAL"===a.LogLevel?N.J(jc.LE):N.warn("Unexpected loglevel: "+a.LogLevel),this.ob=a,this.Db=new gc(a),this.Le=new pc(this),this.ob.TouchHandlingActive&&(this.yg=new qc,this.Pe=new rc(this.getConfiguration()),this.ra=new sc(this,new tc(this)),this.N=new uc),this.ho.TS(this.ob.HandleTouchEvents||this.ob.TouchHandlingActive),(this.ob.BestFit||this.ob.HandleTouchEvents||this.ob.TouchHandlingActive)&&
!this.ob.WorkaroundDisableResizeHandling&&(null===this.qc&&(this.qc=new vc(this)),this.qc.KS(this.ob.HandleTouchEvents||this.ob.TouchHandlingActive),this.qc.Ll()),this.la&&this.ob.BestFit&&(this.bb().style.overflow="hidden"),this.Rc&&(this.rq.ProgrammingSystemModeErrorText=a.ProgrammingSystemModeErrorText,this.rq.ProgrammingSystemModeWaitingText=a.ProgrammingSystemModeWaitingText,this.vl(this.ob.ProgrammingSystemModeWaitingText)))},ef:function(){null!==this.qc&&this.qc.ef()},getConfiguration:function(){return this.ob},
SD:function(a){!window.btoa&&a&&(N.warn("POST data in header should be done but is not supported by the browser"),a=!1);this.cA=a},yR:function(a){this.A=a},Tj:function(a){null===a?this.j=null:this.j=a},sC:function(){var a=location.hash;var b="";""!==a&&(b=a.split("CKT=").pop().split("#")[0]);return b},UO:function(){var a=location.search;return""!==a&&D.Bb(a,Wa.h)?!0:!1},KO:function(){var a=location.search;var b=0;""!==a&&(a=a.split("CFG_DelayedStart=").pop().split("?")[0],b=parseInt(a,10));return b},
ou:function(){var a=location.search;var b="";""!==a&&(b=a.split("CFG_Lang=").pop().split("?")[0],b=b.split("&")[0]);return b},jC:function(){var a=location.search;return""!==a&&D.Bb(a,"BRLG")?!0:!1},kC:function(){var a=location.search;return""!==a&&D.Bb(a,"RLLG")?!0:!1},pD:function(){var a=location.href;if(!D.Bb(a,Wa.h)){var b=D.Bb(a,"?")?"&":"?";a+=b+Wa.h}location.assign(a)},oD:function(a,b,c){var d=location.href,e,f="";if(D.Bb(d,"CFG_Lang")){for(b=e=d.indexOf("CFG_Lang");"&"!==d.charAt(e)&&e<d.length;)e++;
b=d.substring(b,e);""!==a&&(f="CFG_Lang="+a);d=d.replace(b,f);D.Bb(d,Wa.h)||""===a||(d+="&"+Wa.h)}else""!==a&&(f=D.Bb(d,"?")?"&":"?",d+=f+"CFG_Lang="+a,b&&(d+="&BRLG"),D.Bb(d,Wa.h)||(d+="&"+Wa.h));c&&(f="&BRLG",D.Bb(d,f)&&(d=d.replace(f,"")));D.Bb(d,"RLLG")||(d+="&RLLG");location.assign(d)},Ap:function(){return this.fd instanceof wc},D:function(a,b){if(null!==this.fd&&void 0!==this.fd){var c="function"===typeof this.fd.className?this.fd.className():"unknown",d="function"===typeof a.className?a.className():
"unknown";N.warn("WebVisu.setFollowUpState called while former state not yet processed! Src: "+c+" Dest: "+d)}this.fd=a;0>=b&&(b=0);this.kt(b)},JR:function(a){this.qn=a},zM:function(a){this.fd=a},V:function(){return this.hb},error:function(a,b){if(!this.hi){this.Rc||N.error(a);var c=null!==this.ob?this.ob.ErrorReconnectTime:1E4;N.info("Will restart in "+c+"ms");null!==this.A&&(this.pn=new xc(this.A,this.ob));this.Bo();this.ZL();if(this.Rc){var d=this.rq.ProgrammingSystemModeErrorText;window.ProgrammingSystemAccess&&
window.ProgrammingSystemAccess.errorOccurred(d,a)}else d="An error happened; will automatically restart";if("The maximum number of visualization clients is already connected. Please try again later."===a||"Not enough memory in the PLC to create the client."===a)d=a;this.vl(d,b);this.D(new yc(this),c)}},OP:function(){this.Wp("The webvisualization license expired.","License Expired")},Wp:function(a,b){this.hi||(N.warn(a+" Webvisualization is stopped"),this.vl(b),this.Bo(),this.zM(new yc(this)))},IR:function(a){this.yb=
a},kt:function(a){var b=this;this.qb=window.setTimeout(function(){b.my()},a)},ud:function(a){null!==this.yb&&(this.yb.push(a),null!==this.fd&&this.fd.Yo()&&(clearTimeout(this.qb),this.kt(0)))},VE:function(){return""!==this.getConfiguration().LoginVisu.toLowerCase()},gL:function(){if(!this.Rc){var a=this.A;null===a&&null!==this.pn&&this.pn.cT()&&(a=this.pn.Bi);null!==a&&a.ma!==Ua.l&&a.ci!==Ua.xa&&(new lb(this,a)).dR()}},ZL:function(){var a=this.hb.Rl(),b;for(b=0;20>b;++b)a.restore()},CH:function(){Ka.bk(this.Ag,
"ProgrammingSystemMode",!1)?(this.Rc=!0,Ka.bk(this.Ag,"ProgrammingSystemModeCefSharp",!1)&&CefSharp.BindObjectAsync("ProgrammingSystemAccess")):this.Rc=!1},changeUpdateRate:function(a){null!==this.ob&&(a<this.ob.UpdateRate&&null!==this.fd&&(clearTimeout(this.qb),this.kt(0)),this.ob.UpdateRate=a)}};var WebvisuAutotest;WebvisuAutotest=function(a,b){this.g=a;this.rH=b;this.us=this.ts=0;this.yk=null;this.cr=!1};
WebvisuAutotest.prototype={raiseMouse:function(a,b,c){var d=window.document.elementFromPoint(b,c);this.ts=b;this.us=c;var e={bubbles:!0,cancelable:"mousemove"!==a,view:window,detail:0,screenX:b,screenY:c,clientX:b,clientY:c,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:d};if(D.Tb()){a=this.cE(a);var f={};this.EC(f,e,d);f.pointerType="mouse";f=new PointerEvent(a,f)}else f=window.document.createEvent("MouseEvents"),f.initMouseEvent(a,e.bubbles,e.cancelable,e.view,e.detail,e.screenX,
e.screenY,e.clientX,e.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,e.button,d);this.LB(f,b,c,d);!J.J(this.g)||"mouseup"!==a&&"pointerup"!==a||(a=new MouseEvent("click"),d.dispatchEvent(a))},raiseTouch:function(a,b,c,d){var e=window.document.elementFromPoint(b,c);this.cr=!0;var f=new I(b,c);c=f.clone();b=this.cE(a);this.g.la&&("pointerdown"===b?this.yk=e:"pointermove"!==b&&"pointerup"!==b||null===this.yk||!window.document.body.contains(this.yk)||(e=this.yk),c=J.dk(e),c=f.Sf(c));a={bubbles:!0,cancelable:"touchmove"!==
a,view:window,detail:0,screenX:f.X,screenY:f.Y,clientX:f.X,clientY:f.Y,pointerId:d,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:e};d={};this.EC(d,a,e);d.pointerId=a.pointerId;d.pointerType="touch";a=new PointerEvent(b,d);this.LB(a,c.X,c.Y,e);this.g.la&&"pointerup"===b&&(this.yk=null);this.cr=!1},EC:function(a,b,c){a.isPrimary=!0;a.bubbles=b.bubbles;a.cancelable=b.cancelable;a.view=b.view;a.detail=b.detail;a.screenX=b.screenX;a.clientX=b.clientX;a.screenY=b.screenY;a.clientY=
b.clientY;a.ctrlKey=b.ctrlKey;a.altKey=b.altKey;a.shiftKey=b.shiftKey;a.metaKey=b.metaKey;a.button=b.button;a.relatedTarget=c},LB:function(a,b,c,d){Object.defineProperty(a,"layerX",{value:b});Object.defineProperty(a,"layerY",{value:c});this.g.la&&this.cr&&(Object.defineProperty(a,"offsetX",{value:b}),Object.defineProperty(a,"offsetY",{value:c}));a.button=1;a.which=1;d.dispatchEvent(a)},cE:function(a){switch(a){case "touchmove":case "mousemove":return"pointermove";case "touchup":case "mouseup":return"pointerup";
case "touchdown":case "mousedown":return"pointerdown"}},raiseKey:function(a,b,c,d,e){var f=this.g.le.Xb();null===f&&J.J(this.g)&&(f=window.document.elementFromPoint(this.ts,this.us));if(J.J(this.g)&&9===b&&"keydown"===a){var g=f.tabIndex,k=c?-1:1,l=this;document.querySelectorAll("input, button").forEach(function(E){if(E.tabIndex===g+k){var u=E.getBoundingClientRect();l.ts=u.x+u.width/2;l.us=u.y+u.height/2;E.focus()}})}else null!==f?this.ks(b)?this.kA(f,a,b,c,d,e,!0):this.JL(f,b,a,c):this.kA(window.document.getElementById(this.rH),
a,b,c,d,e,!1)},ks:function(a){return 13===a||27===a||37===a||38===a||39===a||40===a},JL:function(a,b,c,d){if("keypress"===c){c=a.selectionStart;var e=a.selectionEnd;b=String.fromCharCode(b);d||(b=b.toLowerCase());void 0===a.value&&(a.value="");a.value=a.value.substr(0,c)+b+a.value.substr(e);c===e&&this.xJ(a);this.vM(a,c+1)}},vM:function(a,b){a.setSelectionRange?(a.focus(),a.setSelectionRange(b,b)):a.createTextRange&&(a=a.createTextRange(),a.collapse(!0),a.moveEnd("character",b),a.moveStart("character",
b),a.select())},xJ:function(a){var b=0;if(document.selection)a.focus(),b=document.selection.createRange(),b.moveStart("character",-a.value.length),b=b.text.length;else if(a.selectionStart||"0"===a.selectionStart)b=a.selectionStart;return b},EK:function(a,b){return b||this.ks(a)?a:String.fromCharCode(a).toLowerCase().charCodeAt(0)&255},kA:function(a,b,c,d,e,f,g){var k,l,E=c;"keypress"===b&&(E=this.EK(c,d));if(void 0!==window.document.createEventObject)c=document.createEvent("Events"),c.initEvent(b,
!0,!0),c.which=E,c.keyCode=E,c.shiftKey=d,c.ctrlKey=f,c.altKey=e,c.metaKey=!1;else{var u=l=k=E;c=window.document.createEvent("KeyboardEvent");void 0===c.initKeyboardEvent?c.initKeyEvent(b,!0,!0,null,f,e,d,!1,k,l,u,a):c.initKeyboardEvent(b,!0,!0,null,f,e,d,!1,k,l,u,a);delete c.keyCode;Object.defineProperty(c,"keyCode",{value:E});delete c.charCode;Object.defineProperty(c,"charCode",{value:0});delete c.shiftKey;Object.defineProperty(c,"shiftKey",{value:d});delete c.ctrlKey;Object.defineProperty(c,"ctrlKey",
{value:f});delete c.altKey;Object.defineProperty(c,"altKey",{value:e});delete c.metaKey;Object.defineProperty(c,"metaKey",{value:!1});delete c.which;d=E;if("keypress"===b&&this.ks(E)&&13!==E||g)d=0;Object.defineProperty(c,"which",{value:d});delete c.target;Object.defineProperty(c,"target",{value:a})}a.dispatchEvent(c)}};var WebvisuExtensionMgr;
(function(){var a=function(){this.Er=[];this.vi={}};a.prototype={register:function(b){if(null===b)throw Error("null value not expected");if("function"!==typeof b.instantiateIf)throw Error("function instantiateIf of extensionFactory expected");this.Er.push(b)},rS:function(b){this.la=b},openControlRelative:function(b,c,d,e,f,g){if(null===b)throw Error("null value not expected");if("number"!==typeof c)throw new TypeError("Expected numeric value");if("number"!==typeof d)throw new TypeError("Expected numeric value");
if("number"!==typeof e)throw new TypeError("Expected numeric value");if("number"!==typeof f)throw new TypeError("Expected numeric value");if(null===g)throw Error("null value not expected");c=new Bb(c,d,c+e,d+f);d=J.cq(g);c=c.Pb(d.u,d.v);this.la?g.appendChild(b):(J.ab(b,c),b.style.zIndex=300,g.parentNode.appendChild(b));g.Sv=b},lT:function(b){var c;for(c=0;c<this.Er.length;++c){var d=this.Er[c].instantiateIf(b);if(null!==d&&void 0!==d){if(this.lN(d))return d;break}}return null},nO:function(){var b;
for(b=0;b<this.vi.length;++b)this.vi[b]&&this.du(b);this.vi=[]},dO:function(b,c,d,e){b.create(d.u,d.v,d.C(),d.B(),e);this.vi[c]=b},du:function(b){var c=this.In(b);null!==c&&(c.destroy(),delete this.vi[b])},cO:function(b,c){b=this.In(b);null!==b&&b.setVisibility(c)},bO:function(b,c){b=this.In(b);null!==b&&b.move(c.u,c.v,c.C(),c.B())},aO:function(b,c,d){b=this.In(b);return null===b?null:b.invoke(c,d)},In:function(b){var c=this.vi[b];return c?c:(N.warn("Not existing extension with id "+b+" accessed; ignored"),
null)},lN:function(b){return this.uk(b,"create")&&this.uk(b,"setVisibility")&&this.uk(b,"move")&&this.uk(b,"invoke")&&this.uk(b,"destroy")?!0:!1},uk:function(b,c){return"function"!==typeof b[c]?(N.warn("Extension object is missing an implementation of '"+c+"'"),!1):!0}};WebvisuExtensionMgr=new a})();var Ga;Ga=function(a){void 0===a&&(a=10);this.oa=new ArrayBuffer(a);this.Gd=new Uint8Array(this.oa);this.fb=0};Ga.F=function(a){return D.lk()?new Ha:new Ga(a)};
Ga.prototype={$L:function(){this.rA(this.VK(this.oa.byteLength))},rA:function(a){var b=this.Gd;this.oa=new ArrayBuffer(a);this.Gd=new Uint8Array(this.oa);for(a=0;a<this.fb;++a)this.Gd[a]=b[a]},VK:function(a){return 500>a?2*a:Math.floor(1.3*a)},Eo:function(a,b){this.Gd[a]=b},sD:function(a){a>this.oa.byteLength&&this.rA(a)},Ro:function(a){this.fb>=this.oa.byteLength&&this.$L();var b=this.fb;this.fb++;this.Eo(b,a)},Uo:function(a,b,c){var d=new Uint8Array(a);this.sD(this.size()+c);if(200<c&&0===b%4&&
0===this.fb%4&&!D.Gq()){var e=Math.floor(c/4);var f=Math.floor(this.fb/4);a=new Uint32Array(a,4*Math.floor(b/4),e);var g=new Uint32Array(this.oa,4*f,e),k=c-4*e;for(f=0;f<e;++f)g[f]=a[f];for(f=0;f<k;++f)this.Gd[this.fb+f+4*e]=d[b+f+4*e]}else if(d.slice)this.Gd.set(d.slice(b,b+c),this.fb);else for(f=0;f<c;++f)this.Gd[this.fb+f]=d[b+f];this.fb+=c},Zu:function(a,b){this.Eo(a,b)},aC:function(a){return this.Gd[a]},size:function(){return this.fb},Zd:function(){var a=new ArrayBuffer(this.fb),b=new Uint8Array(this.oa),
c=new Uint8Array(a);if(b.slice)c.set(b.slice(0,this.fb),0);else{var d;for(d=0;d<this.fb;++d)c[d]=b[d]}return a}};var Ha;
(function(){function a(b){return String.fromCharCode((b>>4)+65)+String.fromCharCode((b&15)+65)}Ha=function(){this.oa="";this.fb=0};Ha.prototype={Eo:function(b,c){var d=null,e=null;0<b&&(d=this.oa.substr(0,2*b));b<this.fb-1&&(e=this.oa.substr(2*b+2,this.oa.length-2*b-2));b="";null!==d&&(b=d);b=b.concat(a(c));null!==e&&(b=b.concat(e));this.oa=b},sD:function(){},Ro:function(b){this.oa=this.oa.concat(a(b));this.fb++},IN:function(b){var c="",d;for(d=0;d<b.length;++d)c=c.concat(a(b.charCodeAt(d)));this.oa=
this.oa.concat(c);this.fb+=c.length/2},Uo:function(b,c,d){this.oa=this.oa.concat(b.substr(2*c,2*d));this.fb+=d},Zu:function(b,c){this.Eo(b,c)},aC:function(b){return this.oa.charCodeAt(2*b)-65<<4|this.oa.charCodeAt(2*b+1)-65},size:function(){return this.fb},Zd:function(){return this.oa}}})();var Nb;
(function(){function a(g,k,l){return function(){if(0===this.s%l&&(1===l||this.ia))try{return(new g[k+"Array"](this.oa,this.s,1))[0]}catch(E){}return null}}function b(g,k,l){return function(){var E=this["getOptimized"+k]();null===E&&(E=this["_get"+k]());this.s+=l;return E}}function c(g,k,l){Nb.prototype["getOptimized"+k]=a(this,k,l);Nb.prototype["get"+k]=b(this,k,l)}Nb=function(g,k,l,E,u){if(!(g instanceof ArrayBuffer))throw new TypeError("BinaryReader requires an ArrayBuffer");if(void 0===k)throw Error("Byteorder must be explicitly assigned");
void 0===l&&(l=(new Configuration).Hg());void 0===E&&(E=0);void 0===u&&(u=g.byteLength);if(!(l instanceof na))throw new TypeError("BinaryReader requires a WebVisuTextDecoder");if(0>E)throw Error("Invalid start offset");if(0===u||E+u>g.byteLength)throw Error("Valid data range exceeded");this.ia=k;this.ag=u;this.oa=g;this.s=E;this.Gd=new Uint8Array(this.oa);this.se=l;this.M=new zc(this,this.ia)};Nb.F=function(g,k,l,E,u){return D.EE()?new Ac(g,k,l,E,u):D.lk()?new Bc(g,k,l,E,u):new Nb(g,k,l,E,u)};Nb.prototype=
{Ij:function(){return this.ia},Vj:function(){return this.se},Uj:function(g){this.se=new na(g)},ha:function(g,k){var l=g*(k?2:1);if(0>g||this.s+l>this.oa.byteLength)throw Error("INDEX_SIZE_ERR: DOM Exception 1");g=this.M.lD(this.oa,this.s,g,l,k,this.se);this.s+=l;return g},$e:function(g){return this.M.$e(g)},Bj:function(){return String.fromCharCode(this.getUint8())},Pf:function(){return this.s>=this.ag},ga:function(){return this.s},seek:function(g){this.s=g},size:function(){return this.ag},l:function(){return this.M.HB()},
h:function(){return this.M.GB()},xa:function(){return this.M.JB()},Uf:function(){return this.M.cu()},J:function(){return this.M.IB()},Yc:function(){return this.M.bu()},Sb:function(){return this.M.KB()},ab:function(){return this.M.$d()},Vf:function(){return this.M.ae()},Fa:function(g){return this.Gd[g]},getUint8:function(){var g=this.Fa(this.s);this.s++;return g},zj:function(){return this.oa}};var d={Int8:1,Int16:2,Int32:4,Uint16:2,Uint32:4,Float32:4,Float64:8},e;for(e in d)if(d.hasOwnProperty(e)){c(this,
e,d[e]);var f="_getFloat64";Nb.prototype[f]=Nb.prototype.l;f="_getFloat32";Nb.prototype[f]=Nb.prototype.h;f="_getInt64";Nb.prototype[f]=Nb.prototype.ab;f="_getUint64";Nb.prototype[f]=Nb.prototype.Vf;f="_getInt32";Nb.prototype[f]=Nb.prototype.xa;f="_getUint32";Nb.prototype[f]=Nb.prototype.Uf;f="_getInt16";Nb.prototype[f]=Nb.prototype.J;f="_getUint16";Nb.prototype[f]=Nb.prototype.Yc;f="_getInt8";Nb.prototype[f]=Nb.prototype.Sb}})();var Ob;Ob=function(a){this.M=a};
Ob.prototype={Ij:function(){return this.M.Ij()},Vj:function(){return this.M.Vj()},Uj:function(a){this.M.Uj(a)},ha:function(a,b){return this.M.ha(a,b)},$e:function(a){return this.M.$e(a)},Bj:function(){return this.M.Bj()},Pf:function(){return this.M.Pf()},ga:function(){return this.M.ga()},seek:function(a){this.M.seek(a)},size:function(){return this.M.size()},getFloat64:function(){this.Dd(8);return this.M.getFloat64()},getFloat32:function(){this.Dd(4);return this.M.getFloat32()},getInt32:function(){this.Dd(4);
return this.M.getInt32()},getUint32:function(){this.Dd(4);return this.M.getUint32()},getInt16:function(){this.Dd(2);return this.M.getInt16()},getUint16:function(){this.Dd(2);return this.M.getUint16()},ae:function(){this.Dd(8);return this.M.ae()},$d:function(){this.Dd(8);return this.M.$d()},getInt8:function(){return this.M.getInt8()},getUint8:function(){return this.M.getUint8()},Fa:function(a){return this.M.Fa(a)},zj:function(){return this.M.zj()},Dd:function(a){if(8===a||4===a||2===a){var b=this.M.ga();
0!==b%a&&this.M.seek(b+a-b%a)}}};var Ac;
Ac=function(a,b,c,d,e){if(!(a instanceof ArrayBuffer))throw new TypeError("BinaryReader_DataView requires an ArrayBuffer");if(void 0===b)throw Error("Byteorder must be explicitly assigned");void 0===c&&(c=(new Configuration).Hg());void 0===d&&(d=0);void 0===e&&(e=a.byteLength);if(!(c instanceof na))throw new TypeError("BinaryReader_DataView requires a WebVisuTextDecoder");if(0>d)throw Error("Invalid start offset");if(0===e||d+e>a.byteLength)throw Error("Valid data range exceeded");this.ia=b;this.Sd=
new DataView(a,0,e+d);this.ag=e;this.oa=a;this.s=d;this.se=c;this.M=new zc(this,this.ia)};
Ac.prototype={Ij:function(){return this.ia},Vj:function(){return this.se},Uj:function(a){this.se=new na(a)},ha:function(a,b){var c=a*(b?2:1);if(0>a||2*(this.s+c)>this.oa.length)throw Error("INDEX_SIZE_ERR: DOM Exception 1");a=this.M.lD(this.oa,this.s,a,c,b,this.se);this.s+=c;return a},$e:function(a){return this.M.$e(a)},Bj:function(){return String.fromCharCode(this.getUint8())},Pf:function(){return this.s>=this.ag},ga:function(){return this.s},seek:function(a){this.s=a},size:function(){return this.ag},
getFloat64:function(){var a=this.Sd.getFloat64(this.s,this.ia);this.s+=8;return a},getFloat32:function(){var a=this.Sd.getFloat32(this.s,this.ia);this.s+=4;return a},$d:function(){if("function"===typeof this.Sd.$d){var a=this.Sd.$d(this.s,this.ia);this.s+=8}else a=this.M.$d();return a},ae:function(){if("function"===typeof this.Sd.ae){var a=this.Sd.ae(this.s,this.ia);this.s+=8}else a=this.M.ae();return a},getInt32:function(){var a=this.Sd.getInt32(this.s,this.ia);this.s+=4;return a},getUint32:function(){var a=
this.Sd.getUint32(this.s,this.ia);this.s+=4;return a},getInt16:function(){var a=this.Sd.getInt16(this.s,this.ia);this.s+=2;return a},getUint16:function(){var a=this.Sd.getUint16(this.s,this.ia);this.s+=2;return a},getInt8:function(){var a=this.Sd.getInt8(this.s);this.s++;return a},getUint8:function(){var a=this.Fa(this.s);this.s++;return a},Fa:function(a){return this.Sd.getUint8(a)},zj:function(){return this.oa}};var Bc;
Bc=function(a,b,c,d,e){if("string"!==typeof a)throw new TypeError("BinaryReader_StringBased expects a string");if(void 0===b)throw Error("Byteorder must be explicitly assigned");void 0===c&&(c=(new Configuration).Hg());void 0===d&&(d=0);void 0===e&&(e=a.length/2);if(!(c instanceof na))throw new TypeError("BinaryReader requires a WebVisuTextDecoder");if(0>d)throw Error("Invalid start offset");if(0===e||d+e>a.length/2)throw Error("Valid data range exceeded");this.ia=b;this.ag=e;this.oa=a;this.s=d;this.se=
c;this.M=new zc(this,b)};
Bc.prototype={Ij:function(){return this.ia},Vj:function(){return this.se},Uj:function(a){this.se=new na(a)},ha:function(a,b){var c=a*(b?2:1);if(0>a||2*(this.s+c)>this.oa.length)throw Error("INDEX_SIZE_ERR: DOM Exception 1");var d=Array(a);if(b){if(this.ia)for(b=0;b<a;++b){var e=2*b+this.s;d[b]=(this.Fa(e+1)<<8)+this.Fa(e)}else for(b=0;b<a;++b)e=2*b+this.s,d[b]=this.Fa(e+1)+(this.Fa(e)<<8);a=String.fromCharCode.apply(null,d)}else{for(b=this.s;b<this.s+a;++b)d[b-this.s]=this.Fa(b);a=this.se.mO(d)}this.s+=
c;return a},$e:function(a){return this.M.$e(a)},Bj:function(){return String.fromCharCode(this.getUint8())},Pf:function(){return this.s>=this.ag},ga:function(){return this.s},seek:function(a){this.s=a},size:function(){return this.ag},getFloat64:function(){var a=this.M.HB();this.s+=8;return a},getFloat32:function(){var a=this.M.GB();this.s+=4;return a},$d:function(){return this.M.$d()},ae:function(){return this.M.ae()},getInt32:function(){var a=this.M.JB();this.s+=4;return a},getUint32:function(){var a=
this.M.cu();this.s+=4;return a},getInt16:function(){var a=this.M.IB();this.s+=2;return a},getUint16:function(){var a=this.M.bu();this.s+=2;return a},getInt8:function(){var a=this.M.KB();this.s++;return a},getUint8:function(){var a=this.Fa(this.s);this.s++;return a},Fa:function(a){return this.oa.charCodeAt(2*a)-65<<4|this.oa.charCodeAt(2*a+1)-65},zj:function(){return this.oa}};var zc;zc=function(a,b){this.va=a;this.ia=b};
zc.prototype={$e:function(a){var b=this.va.ga(),c=0;if(a)for(;0!==this.va.getUint16();)c++;else for(;0!==this.va.getUint8();)c++;this.va.seek(b);b=this.va.ha(c,a);a?this.va.getUint16():this.va.getUint8();return b},HB:function(){var a=this.va.ga(),b=this.va.Fa(this.Vb(a,0,8)),c=this.va.Fa(this.Vb(a,1,8)),d=this.va.Fa(this.Vb(a,2,8)),e=this.va.Fa(this.Vb(a,3,8)),f=this.va.Fa(this.Vb(a,4,8)),g=this.va.Fa(this.Vb(a,5,8)),k=this.va.Fa(this.Vb(a,6,8)),l=this.va.Fa(this.Vb(a,7,8));a=1-2*(b>>7);b=((b<<1&
255)<<3|c>>4)-(Math.pow(2,10)-1);c=(c&15)*Math.pow(2,48)+d*Math.pow(2,40)+e*Math.pow(2,32)+f*Math.pow(2,24)+g*Math.pow(2,16)+k*Math.pow(2,8)+l;return 1024===b?0!==c?NaN:Infinity*a:-1023===b?a*c*Math.pow(2,-1074):a*(1+c*Math.pow(2,-52))*Math.pow(2,b)},GB:function(){var a=this.va.ga(),b=this.va.Fa(this.Vb(a,0,4)),c=this.va.Fa(this.Vb(a,1,4)),d=this.va.Fa(this.Vb(a,2,4)),e=this.va.Fa(this.Vb(a,3,4));a=1-2*(b>>7);b=(b<<1&255|c>>7)-127;c=(c&127)<<16|d<<8|e;return 128===b?0!==c?NaN:Infinity*a:-127===b?
a*c*Math.pow(2,-149):a*(1+c*Math.pow(2,-23))*Math.pow(2,b)},JB:function(){var a=this.cu();return a>Math.pow(2,31)-1?a-Math.pow(2,32):a},cu:function(){var a=this.va.ga(),b=this.va.Fa(this.Vb(a,0,4)),c=this.va.Fa(this.Vb(a,1,4)),d=this.va.Fa(this.Vb(a,2,4));a=this.va.Fa(this.Vb(a,3,4));return b*Math.pow(2,24)+(c<<16)+(d<<8)+a},IB:function(){var a=this.bu();return a>Math.pow(2,15)-1?a-Math.pow(2,16):a},bu:function(){var a=this.va.ga(),b=this.va.Fa(this.Vb(a,0,2));a=this.va.Fa(this.Vb(a,1,2));return(b<<
8)+a},KB:function(){var a=this.va.Fa(this.va.ga());return a>Math.pow(2,7)-1?a-Math.pow(2,8):a},lD:function(a,b,c,d,e,f){var g=null;if(e){if(this.ia&&0===b%2)try{g=new Int16Array(a,b,c)}catch(k){}if(null===g)if(g=new Int16Array(Array(c)),b=new Uint8Array(a,b,d),this.ia)for(a=0;a<c;++a)g[a]=(b[2*a+1]<<8)+b[2*a];else for(a=0;a<c;++a)g[a]=b[2*a+1]+(b[2*a]<<8);b=[];for(a=0;a<c;++a)b[a]=g[a];return String.fromCharCode.apply(null,b)}g=new Int8Array(a,b,c);return f.decode(g)},ae:function(){var a=this.va.getUint32(),
b=this.va.getUint32();return this.ia?a+b*Math.pow(2,32):a*Math.pow(2,32)+b},$d:function(){var a=this.va.ga(),b=this.va.getUint32(),c=this.va.getUint32();if(this.ia){var d=b;b=c}else d=c;if(0===(b&2147483648))return this.va.seek(a),this.ae();a=(~d>>>0)+1;d=~b;4294967296<=a&&(a-=4294967296,d+=1);return-1*(a+Math.pow(2,32)*d)},Vb:function(a,b,c){return a+(this.ia?c-b-1:b)}};var Cc;
Cc=function(a,b,c){if(!(a instanceof Ga))throw new TypeError("BinaryWriter expects a BinaryBuffer");if(void 0===b)throw Error("Byteorder must be explicitly assigned");this.kh=a;this.ia=b;this.kd=-1;this.rt=c};Cc.F=function(a,b,c){null===c|void 0===c&&(c=(new Configuration).wd());return D.lk()?new Dc(a,b,c):new Cc(a,b,c)};
Cc.prototype={RM:function(a){var b=a.length/2,c;if(1!==b&&2!==b&&4!==b)throw Error("Unexpected size for swapping");for(c=0;c<b;++c){var d=a[c];a[c]=a[a.length-c-1];a[a.length-c-1]=d}},eh:function(a,b,c){var d=new ArrayBuffer(c);b=new b(d);d=new Uint8Array(d);b[0]=a;this.Zq(d,c)},Zq:function(a,b){var c;1<b&&!this.ia&&this.RM(a,b);for(c=0;c<b;++c)this.Ww(a[c])},Ww:function(a){-1!==this.kd?(this.kh.Zu(this.kd,a),this.kd++):this.kh.Ro(a)},seek:function(a){this.kd=a},ga:function(){return-1!==this.kd?this.kd:
this.kh.size()},So:function(a){var b=[204,221],c;for(c=0;c<a;++c)this.Ua(b[c%2])},Ua:function(a){this.Ww(a)},gB:function(a){this.eh(a,Int8Array,1)},Nb:function(a){this.eh(a,Uint16Array,2)},Gc:function(a){this.eh(a,Int16Array,2)},K:function(a){this.eh(a,Uint32Array,4)},Vd:function(a){this.eh(a,Int32Array,4)},To:function(a){this.eh(a,Float32Array,4)},Mt:function(a){this.eh(a,Float64Array,8)},hB:function(a){var b=new ArrayBuffer(8);var c=new Uint8Array(b);b=new Uint32Array(b);b[0]=a&4294967295;b[1]=
a/4294967296;this.Zq(c,8)},fB:function(a){var b=new ArrayBuffer(8);var c=new Uint8Array(b);b=new Uint32Array(b);0<a&&(b[0]=a&4294967295|0,b[1]=a/4294967296|0);if(0>a){var d=~(-a&4294967295|0)+1|0;b[0]=d;b[1]=~(-a/4294967296|0)+!d|0}this.Zq(c,8)},Dg:function(a){this.pk(a,!1)},jc:function(a){this.pk(a,!0)},jb:function(a,b){return new Ec(a,b,this.rt)},pk:function(a,b){for(var c,d=a.data(),e=0;e<a.length();++e)c=d[e],a.unicode()?this.Nb(c):this.Ua(c);b&&(a.unicode()?this.Nb(0):this.Ua(0))}};var Dc;
Dc=function(a,b,c){if(!(a instanceof Ha))throw new TypeError("BinaryWriter expects a BinaryBuffer_StringBased");if(void 0===b)throw Error("Byteorder must be explicitly assigned");this.kh=a;this.ia=b;this.kd=-1;this.rt=c};
Dc.prototype={Ed:function(a){if(-1!==this.kd)for(var b=0;b<a.length;++b)this.kh.Zu(this.kd,a.charCodeAt(b)&255),this.kd++;else this.kh.IN(a)},seek:function(a){this.kd=a},ga:function(){return-1!==this.kd?this.kd:this.kh.size()},So:function(a){var b=[204,221],c;for(c=0;c<a;++c)this.Ua(b[c%2])},Ua:function(a){this.Ed(this.Ne(a,8,!1))},gB:function(a){this.Ed(this.Ne(a,8,!0))},Nb:function(a){this.Ed(this.Ne(a,16,!1))},Gc:function(a){this.Ed(this.Ne(a,16,!0))},K:function(a){this.Ed(this.Ne(a,32,!1))},Vd:function(a){this.Ed(this.Ne(a,
32,!0))},hB:function(a){var b=a/4294967296;this.Ed(this.Ne(a&4294967295,32,!1));this.Ed(this.Ne(b,32,!1))},fB:function(a){if(0<a){var b=a&4294967295|0;var c=a/4294967296|0}0>a&&(b=c=~(-a&4294967295|0)+1|0,c=~(-a/4294967296|0)+!c|0);this.Ed(this.Ne(b,32,!1));this.Ed(this.Ne(c,32,!1))},To:function(a){this.Ed(this.iy(a,23,8))},Mt:function(a){this.Ed(this.iy(a,52,11))},Dg:function(a){this.pk(a,!1)},jc:function(a){this.pk(a,!0)},jb:function(a,b){return new Ec(a,b,this.rt)},pk:function(a,b){for(var c,d=
a.data(),e=0;e<a.length();++e)c=d[e],a.unicode()?this.Nb(c):this.Ua(c);b&&(a.unicode()?this.Nb(0):this.Ua(0))},iy:function(a,b,c){var d=Math.pow(2,c-1)-1,e=-d+1,f=e-b,g=parseFloat(a),k=isNaN(g)||-Infinity===g||Infinity===g?g:0,l=0,E=2*d+1+b+3,u=Array(E),ka=0>(g=0!==k?0:g),ja=Math.floor(g=Math.abs(g)),va=g-ja,Xa;for(a=E;a;u[--a]=0);for(a=d+2;ja&&a;u[--a]=ja%2,ja=Math.floor(ja/2));for(a=d+1;0<va&&a;(u[++a]=(1<=(va*=2))-0)&&--va);for(a=-1;++a<E&&!u[a];);if(u[(g=b-1+(a=(l=d+1-a)>=e&&l<=d?a+1:d+1-(l=e-
1)))+1]){if(!(Xa=u[g]))for(va=g+2;!Xa&&va<E;Xa=u[va++]);for(va=g+1;Xa&&0<=--va;(u[va]=!u[va]-0)&&(Xa=0));}for(a=0>a-2?-1:a-3;++a<E&&!u[a];);(l=d+1-a)>=e&&l<=d?++a:l<e&&(l!==d+1-E&&l<f&&this.warn("encodeFloat::float underflow"),a=d+1-(l=e-1));if(ja||0!==k)this.warn(ja?"encodeFloat::float overflow":"encodeFloat::"+k),l=d+1,a=d+2,-Infinity===k?ka=1:isNaN(k)&&(u[a]=1);g=Math.abs(l+d);va=c+1;for(c="";--va;c=g%2+c,g=g>>=1);va=g=0;a=(c=(ka?"1":"0")+c+u.slice(a,a+b).join("")).length;for(b=[];a;va=(va+1)%
8)g+=(1<<va)*c.charAt(--a),7===va&&(b[b.length]=String.fromCharCode(g),g=0);b[b.length]=g?String.fromCharCode(g):"";return(this.ia?b:b.reverse()).join("")},Ne:function(a,b,c){var d=[],e=Math.pow(2,b);if(c){if(c=-Math.pow(2,b-1),a>-c-1||a<c)this.ZA("encodeInt::overflow"),a=0}else if(a>e||0>a)this.ZA("encodeInt::overflow"),a=0;for(0>a&&(a+=e);a;a=Math.floor(a/256))d[d.length]=String.fromCharCode(a%256);for(b=-(-b>>3)-d.length;b;b--)d[d.length]=String.fromCharCode(0);return(this.ia?d:d.reverse()).join("")},
ZA:function(a){throw Error(a);}};var Fc;Fc=function(a,b,c){this.M=Nb.F(a,b,c,void 0,void 0)};Fc.prototype={Fj:function(){var a=0,b=0;do{var c=this.M.getUint8();a|=(c&127)<<b;b+=7}while(0!==(c&128));return a}};var Gc;Gc=function(a,b,c){this.mf=Cc.F(a,b,c)};
Gc.prototype={I:function(a,b){var c;b=void 0!==b?b:this.mC(a);if(0===b)throw Error("Expected value for MBui greater then zero");var d=a;for(c=0;c<b-1;c++)this.mf.Ua(d&127|128),d>>=7;this.mf.Ua(d&127);if(0!==d>>7)throw Error("Value "+a+" cannot be written as an MBUI with "+b+" bytes");},mC:function(a){var b=0;do a>>=7,b++;while(0<a);return b}};var Hc;Hc=function(a){16<=a&&(a=0);this.wi=a};
Hc.prototype={GD:function(a){16<=a&&(a=0);this.wi=a},Uc:function(){return 0===this.wi},right:function(){return 0!==(this.wi&1)},left:function(){return 0!==(this.wi&2)},top:function(){return 0!==(this.wi&4)},bottom:function(){return 0!==(this.wi&8)}};var Yb;Yb=function(){};
Yb.xE=function(a,b,c,d,e,f,g,k){var l=window.document.createElement("div");l.id="cdsClientObject";l.style.position="absolute";if(b)return new Ic(l,new Jc,k,a);if(c)return new Kc(l,new Jc,k,a);var E=c=b=null;e&&(c=new Lc(g));d&&(b=this.sr());return f?(e&&(E=window.document.createElement("div"),E.id="cdsTouchScrollable",E.style.position="absolute",E.style.cssText+="outline: none; -webkit-tap-highlight-color: transparent;"),new Oc(l,new Jc,k,b,c,new Pc,E,a)):new Qc(l,new Jc,k,b,c,a)};
Yb.qE=function(a,b,c,d){var e=window.document.createElement("div");a=a?window.document.createElement("div"):null;var f=this.sr(),g=new Lc(!1);e.id="cdsDialog";e.style.position="absolute";e.style.overflow="hidden";e.style.zIndex=Va.mq;a&&(a.id="cdsModal",a.style.top="0",a.style.left="0",a.style.width="100%",a.style.height="100%",b&&(a.style.backgroundColor="rgb(0,0,0)",a.style.backgroundColor="rgba(0,0,0,0.4)"),a.style.zIndex=Va.mq,a.style.position="fixed");return new Rc(e,new Jc,f,g,a,b,c,d)};
Yb.zE=function(a){var b=new Lc(!1);b.de(J.bb());b.Tg(a);return b};Yb.rE=function(a){var b=new Sc;b.de(J.bb());b.Tg(a);return b};Yb.Pv=function(a,b,c){var d=this.sr(a?Va.cG:Va.wF),e;a&&(d.canvas.id="cdsSelectionCanvas",d.canvas.style.pointerEvents="none");b?e=this.PH():e=null;return new Tc(d,e,c)};
Yb.PH=function(){var a=window.document.createElement("div");a.id="cdsClip";a.style.overflow="hidden";a.style.position="absolute";a.style.top="0 px";a.style.left="0 px";a.style.width="-1 px";a.style.height="-1 px";a.style.touchAction="none";a.style.zIndex=Va.qm;return a};
Yb.sr=function(a){var b=window.document.createElement("canvas").getContext("2d");b.canvas.id="cdsCanvas";b.canvas.style.position="absolute";b.canvas.style.width="100%";b.canvas.style.height="100%";b.canvas.style.zIndex=void 0!==a?a:Va.qm;return b};Yb.vE=function(a,b){return new Uc(a,b)};var Jc;Jc=function(){this.We=null};Jc.prototype={GD:function(a){this.We=a},MC:function(){return 0!==(this.We&1)},EO:function(){return 0!==(this.We&2)}};var Uc;Uc=function(a,b){this.ya=[];this.ra=null;this.g=b;this.jv(a)};
Uc.prototype={rb:function(a){var b=this.g.ra;null!==this.ya&&null!==b&&b.Su(a);null!==this.ra&&this.ra.rb()},handleEvent:function(a,b){return null!==this.ra?this.ra.handleEvent(a,b):!1},Hl:function(){null!==this.ra&&this.ra.Hl()},initialize:function(a,b,c){this.ra=new sc(a,new Vc(a,c,b));a=a.ra;null!==a&&(this.ra.g.N.ID(a.g.N.Xr),this.ra.g.N.Sp(a.g.N.Zi));this.jv(this.ya)},jv:function(a){this.ya=a;if(null!==this.ra){this.ra.sB();for(a=0;a<this.ya.length;++a)this.ra.Qo(this.ya[a]);this.ra.Eb instanceof
Vc&&(a=this.ra.Eb.cp(),null!==a&&void 0!==a&&a instanceof Pc&&a.eE(this))}},tT:function(a,b,c,d){var e=this.ra.ya.T.length,f,g=this.g.ra,k=null;for(f=0;f<e;++f){var l=this.ra.ya.wc(f);k=l.ca;var E=l.info().scroll().Va();var u=l.info().zoom().Va();E.$h(new I(c,d));E.Zh(new I(a,b));u.gv(1);u.fv(1);l.$(Wc.si)||l.vj(Wc.si)}e=g.ya.T.length;for(f=0;f<e;++f)l=g.ya.wc(f),null!==k&&l.ca===k&&(E=l.info().scroll().Va(),u=l.info().zoom().Va(),E.$h(new I(c,d)),E.Zh(new I(a,b)),u.gv(1),u.fv(1),l.$(Wc.si)||l.vj(Wc.si))}};
var Xc;Xc=function(){};Xc.Vg=function(a,b){var c=new Yc;c.promiseId=a;c.error=b;return c};Xc.wE=function(a,b){var c=new MethodCallMessage;c.methodName=a;c.params=b;return c};Xc.oE=function(a,b,c){var d=new CheckSimpleValueResultMessage;d.promiseId=a;d.result=b;d.value=c;return d};Xc.nE=function(a,b,c,d,e,f,g){var k=new CheckComplexValueResultMessage;k.promiseId=a;k.result=b;k.value=c;k.indexCount=d;k.index0=e;k.index1=f;k.index2=g;return k};
Xc.yE=function(a,b){var c=new ResizeMessage;c.width=a;c.height=b;return c};Xc.uE=function(a,b,c){var d=new GetTypeDescResultMessage;d.promiseId=a;d.result=b;d.typeDesc=c;return d};Xc.sE=function(a,b,c,d){var e=new GetAdditionalFileNameResultMessage;e.promiseId=a;e.result=b;e.originalAdditionalFileName=c;e.resultingAdditionalFileName=d;return e};Xc.tE=function(a,b,c,d){var e=new GetImagePoolFileNameResultMessage;e.promiseId=a;e.result=b;e.imageId=c;e.resultingFileName=d;return e};
Xc.BE=function(a,b,c){var d=new SetSimpleValueResultMessage;d.promiseId=a;d.result=b;d.value=c;return d};Xc.AE=function(a,b,c,d,e,f,g){var k=new SetComplexValueResultMessage;k.promiseId=a;k.result=b;k.value=c;k.indexCount=d;k.index0=e;k.index1=f;k.index2=g;return k};var ub;ub=function(){this.nd=0};ub.gi=0;ub.u=1;ub.Z=2;ub.v=3;ub.da=4;
ub.prototype={UR:function(a){this.nd=ub.gi;null!==a&&void 0!==a&&(a.left()?this.nd=ub.u:a.right()?this.nd=ub.Z:a.top()?this.nd=ub.v:a.bottom()&&(this.nd=ub.da))},wS:function(){this.nd=ub.u},vS:function(){this.nd=ub.Z},SQ:function(){this.nd=0},Uc:function(){return this.nd===ub.gi},left:function(){return this.nd===ub.u},right:function(){return this.nd===ub.Z},top:function(){return this.nd===ub.v},bottom:function(){return this.nd===ub.da},before:function(){return this.left()||this.top()},after:function(){return this.right()||
this.bottom()}};var Pc;Pc=function(){this.El=null;this.Zn=this.Yn=this.sf=this.rf=this.$k=this.Zk=this.cl=this.bl=0};
Pc.prototype={initialize:function(a){this.El=a},update:function(a,b,c,d,e,f){this.bl=a;this.cl=b;this.Zk=c;this.$k=d;this.rf=e;this.sf=f;this.El(this.rf,this.sf)},eE:function(a){null!==a&&a.tT(this.rf-this.bl,this.sf-this.cl,this.rf-this.Zk,this.sf-this.$k)},vD:function(){return this.Zk-this.bl},wD:function(){return this.$k-this.cl},Th:function(a,b){this.WJ(b.info().scroll())},Ip:function(){},Pt:function(){},WJ:function(a){var b=this.Zn-a.eb.Y;this.rf+=this.Yn-a.eb.X;this.sf+=b;this.Yn=a.eb.X;this.Zn=
a.eb.Y;this.El(this.rf,this.sf)},Wu:function(){this.Zn=this.Yn=0},Kj:function(a){this.Zn=this.Yn=0;return a.info().scroll().Ei.Pb(a.info().scroll().eb)}};var Ub;Ub=function(){this.tA=J.bb();this.pj=this.No=this.Mo=this.ve=null};
Ub.prototype={gQ:function(a,b,c,d){this.ve=this.bI(a,b,c,d);this.tA.appendChild(this.ve)},vB:function(){null!==this.ve&&this.tA.removeChild(this.ve);this.ve=null},ON:function(a,b,c){this.ve.innerHTML!=a&&(this.ve.innerHTML=a,this.vH(b,c))},SS:function(a){this.pj=a},vH:function(a,b,c){this.Mo+a.L>b&&(this.Mo=b-a.L,this.ve.style.left=this.Mo+"px");this.No+a.aa>c&&(this.No=c-a.aa,this.ve.style.top=this.No+"px")},bI:function(a,b,c,d){var e=document.createElement("div");e.id="cdsTooltip";e.style.msUserSelect=
"none";e.style.WebkitUserSelect="none";e.style.MozUserSelect="none";e.style.userSelect="none";e.style.position="absolute";e.style.left=a+"px";e.style.top=b+"px";this.Mo=a;this.No=b;e.innerHTML=c;e.style.borderStyle="solid";e.style.font=d;e.style.color=this.pj.Vv;e.style.borderColor=this.pj.Bv;e.style.borderWidth=this.pj.Yj+"px";e.style.padding="2px 3px 2px 3px";e.style.backgroundColor=this.pj.Tv;e.style.zIndex=Va.uG;return e}};var Zc;
Zc=function(a,b,c,d){this.U=null;this.mh=this.mb=this.Ih=this.Hh=this.Ud=this.Td=this.qa=this.ka=this.td=this.sd=0;this.Si="solid";this.Ri="";this.oc=null;this.Pp=this.Op=1;this.Qa=new ib(0);this.dc=a;c?(this.S=window.document.createElement("div"),this.S.id="cdsClip",this.S.style.overflow="hidden",this.S.style.position="relative",this.dc.appendChild(this.S)):this.S=this.dc;this.fa=b;this.ng=null;this.ta="";this.vr=Va.qm;this.Wb=d};
Zc.prototype={initialize:function(){},rB:function(){},rb:function(){this.U&&this.P().parentNode===this.U?this.U.removeChild(this.P()):N.warn("Error when removing a client object. This node doesn't have a parent:"+this.P().id)},update:function(a,b,c,d,e,f,g,k,l,E,u){this.sd=a;this.td=b;this.ka=c;this.qa=d;this.Td=e;this.Ud=f;this.Hh=g;this.Ih=k;this.mb=l;this.fa.GD(E);this.eN(a,b,c,d,e,f,g,k,l,u)},Mx:function(){},Nx:function(a){var b=window.document.createElement("div");b.style.overflow="hidden";b.style.position=
"absolute";b.style.margin="";b.style.padding="";b.id=a;b.style.left="0px";b.style.top="0px";b.style.width=this.ka+"px";b.style.height=this.qa+"px";a=J.WP(a+"_canvas",this.ka,this.qa);b.appendChild(a);return b},zS:function(a){a?this.CS():this.AS()},VS:function(a,b){this.Op=a;this.Pp=b},P:function(){return this.dc},eN:function(a,b,c,d,e,f,g,k,l,E){var u=this;e=void 0===this.Fl;void 0!==this.Fl&&this.Fl!==this.fa.MC()?window.WebvisuInst.Il(function(){u.Fi(a,b,c,d,g,k,l,E)}):(this.Fl=!this.fa.MC())?(null!==
this.ng&&(this.P().removeEventListener("transitionend",this.ng,!1),this.ng=null),e?(window.WebvisuInst.Il(function(){u.Fi(a,b,c,d,g,k,l,E,100)}),window.WebvisuInst.Po(function(){u.hj()})):(this.hj(),window.WebvisuInst.Po(function(){u.Fi(a,b,c,d,g,k,l,E,100)}))):(e||""===E?window.WebvisuInst.Po(function(){u.hj()}):(this.ng=function(){u.hj()},this.P().addEventListener("transitionend",this.ng,!1)),window.WebvisuInst.Il(function(){u.Fi(a,b,c,d,g,k,l,E,0)}))},Fi:function(a,b,c,d,e,f,g,k,l){c=this.P();
d=this.S;g=1/this.Op;var E=1/this.Pp;this.Ze()&&this.Mx();c.style.left=a+"px";c.style.top=b+"px";c.style.width=this.ig()+"px";c.style.height=this.hg()+"px";d.style.width=this.ig()+"px";d.style.height=this.hg()+"px";0<this.mh&&(d.style.border=this.mh+"px "+this.Si+" "+this.Ri);c.style.transformOrigin=e+.5+"px "+(f+.5)+"px";c.style.transform="";0!==this.mb&&(c.style.transform=1!==(this.Op||this.Pp)?c.style.transform+("scale("+this.Op+","+this.Pp+") rotate("+this.mb+"deg) scale("+g+","+E+")"):c.style.transform+
(" rotate("+this.mb+"deg)"));void 0!==l&&(c.style.opacity=l);c.style.zIndex=this.fa.EO()?Va.eq:this.vr;delete c.tabIndex;c.style.transition=k},V:function(){return null},Lh:function(){},BS:function(a,b,c){this.U=a;void 0===c?b.appendChild(this.P()):b.insertBefore(this.P(),b.children[c])},de:function(a,b){this.U=a;void 0===b?this.U.appendChild(this.P()):this.U.insertBefore(this.P(),this.U.children[b])},wa:function(){return this},Uh:function(){return-1},Tg:function(a){this.oc=a},YO:function(){var a=
J.$j(this.S,J.bb());return new Bb(a.X,a.Y,a.X+this.ka,a.Y+this.qa)},wc:function(){return new Bb(this.sd,this.td,this.sd+this.ig(),this.td+this.hg())},getParent:function(){return this.U},Og:function(a){this.dc.id+="_"+a;this.ta+="_"+a;this.S!==this.dc&&(this.S.id+="_"+a)},Ng:function(){void 0!==this.Wb&&null!==this.Wb&&this.Wb.ny.GE(this)},hj:function(){this.P().style.display=this.Fl?"":"none";this.ng&&(this.P().removeEventListener("transitionend",this.ng,!1),this.ng=null)},SR:function(a){this.Qa=
a},Ze:function(){return!1},ig:function(){return Math.max(0,this.ka-2*this.mh)},hg:function(){return Math.max(0,this.qa-2*this.mh)},dv:function(){},Jj:function(){return!1},xC:function(){return!1},Bp:function(){return!1}};var Qc;Qc=function(a,b,c,d,e,f){Zc.call(this,a,b,c,f);this.hb=d;this.ua=e;this.cs();this.nn=this.Rk=this.Kd=null;this.bj=[];this.zh=[];this.wg=null;this.lg=-1;this.tk=!1;this.ld=null;this.kj=!1;this.Pn=this.ua&&this.ua.th?!0:!1;this.Ie=[];this.cd=[];this.ax=this.Vm=0};
Qc.prototype=Object.create(Zc.prototype);q=Qc.prototype;q.constructor=Qc;q.initialize=function(){!this.Pn&&this.Qa.Uc()&&this.FG(this.S);this.kj&&this.GG()};q.QD=function(a){this.kj=a};q.AD=function(a){this.tk=a};q.Ze=function(){return this.Qa.mm()};q.hj=function(){this.xi(this.hb,this.wf(),this.vf());Zc.prototype.hj.call(this)};q.Lh=function(a){this.ua&&this.ua.Lh(a);this.hb.clearRect(a.u,a.v,a.C(),a.B())};q.Ng=function(){this.Wb.Li.JQ(this);this.ua&&this.ua.Ng();Zc.prototype.Ng.call(this)};
q.rb=function(){this.Xs();this.ua&&this.ua.Qu();this.ld&&this.ld.rb(this);this.Xl()&&this.$D();Zc.prototype.rb.call(this)};q.rB=function(){for(var a in this.zh)this.S.removeChild(this.zh[a].P());this.lg=-1;this.zh=[]};q.WN=function(){var a,b=!1,c=this.S;for(d in this.Ie)c.removeChild(this.Ie[d].P());for(a in this.cd)c.removeChild(this.cd[a]),b=!0;this.Ie=[];this.cd=[];this.lg=-1;if(0===c.childElementCount){b&&null!==this.Kd&&c.appendChild(this.Kd);var d=this.V();c.appendChild(d.canvas)}};
q.V=function(){var a=this.Mr();if(a){var b=a.Ja;this.xi(b,-1===b.width?this.ig():b.width,-1===b.height?this.hg():b.height);a.Ry&&b.setTransform(1,0,0,1,this.Td,this.Ud)}else b=this.hb,this.xi(b,this.wf(),this.vf()),b.setTransform(1,0,0,1,this.Td,this.Ud);return b};
q.St=function(){var a;(a=this.Mr())?(a=a.Ja,this.xi(a,-1===a.width?this.ig():a.width,-1===a.height?this.hg():a.height),a.clearRect(0,0,a.canvas.width,a.canvas.height)):(a=this.hb,this.xi(a,this.wf(),this.vf()),a.clearRect(-this.Td,-this.Ud,a.canvas.width,a.canvas.height))};q.wa=function(){if(this.ua){var a=this.ua.wa();if(null!==a)return a}this.xi(this.hb,this.wf(),this.vf());return this};q.ba=function(){return this.ua};q.$l=function(a){this.ua.$l(a)};q.Uh=function(){return this.ua?this.ua.Uh():Zc.prototype.Uh.call(this)};
q.xN=function(a,b){this.Ze()&&(this.ua.Qa=this.Qa);this.ua.$A(a,b)};q.HQ=function(){this.ua&&(-1===this.ua.Ta&&this.Ze()&&(this.Ya.style.left="0px",this.Ya.style.top="0px",this.UQ()),this.ua.Qu())};q.Tg=function(a){Zc.prototype.Tg.call(this,a);this.ua&&this.ua.Tg(this.oc)};q.RR=function(a,b,c){this.mh=a;this.Si=b;this.Ri=c};q.update=function(a,b,c,d,e,f,g,k,l,E,u){this.UA();Zc.prototype.update.call(this,a,b,c,d,e,f,g,k,l,E,u)};
q.$R=function(a,b){var c=this,d=b.wc(),e=!1,f,g=this.ax;c.Xl()&&this.ax++;this.Pn&&null!==this.Kd&&this.Kd.src===a.src||(a.onerror=function(){c.Xl()||(c.Kd&&c.S.removeChild(c.Kd),c.Kd=null,c.Rk=null)},a.onload=function(){b.An&&b.Gk&&(a.width=Math.round(b.tn*a.width),a.height=Math.round(b.un*a.height),e=!0,f=new Ja(a.width,a.height),d=J.Bq(d,f,b));if(b.Rm&&!e)a.width=d.C(),a.height=d.B();else if(b.ls&&!e){if(d.C()/a.width<d.B()/a.height){var k=Math.round(d.C()*a.height/a.width);var l=d.C()}else k=
d.B(),l=Math.round(d.B()*a.width/a.height);a.width=l;a.height=k;l=new Bb(d.u,d.v,d.u+l,d.v+k);d=J.lB(l,d,b)}c.Xl()?c.CG(a,g):c.EG(a);c.Rk=d.zc().clone();c.UA()})};q.EG=function(a){this.Kd?this.S.replaceChild(a,this.Kd):this.S.insertBefore(a,this.hb.canvas);this.Kd=a};q.CG=function(a,b){for(var c in this.cd)if(a.src==this.cd[c].src)return;b%=2;void 0===this.cd[b]&&(this.S.appendChild(a),this.cd[b]=a)};q.cS=function(a,b){null!==this.ld&&this.ld.rb();this.ld=b;this.ld.initialize(a,this.S,this.rc)};
q.qD=function(){null!==this.wg&&(this.P().removeChild(this.wg.P()),this.wg=null)};q.DN=function(a){null!==this.wg&&this.qD();this.wg=a;this.wg.Xu();this.P().appendChild(this.wg.P())};q.aB=function(a,b){32767===a?this.DN(b):b.Ry?this.Qy(b,a,this.Ie):this.Qy(b,a,this.zh)};
q.Qy=function(a,b,c){var d;if(void 0===c[b])if(a.Xu(),a.XR(this.ta,b),c[b]=a,b===c.length-1){var e=this.hb.nextSibling;if(1<c.length)for(d in c)b>d&&(e=c[d].P().nextSibling);null===e||void 0===e?this.S.append(a.P()):this.S.insertBefore(a.P(),e)}else for(d in c){if(b<d){this.S.insertBefore(a.P(),c[d].P());break}}else a=c[b].Ja,a.save(),a.setTransform(1,0,0,1,0,0),a.clearRect(0,0,a.canvas.width,a.canvas.height),a.restore(),c[b].Xu()};
q.Iy=function(a,b){void 0!==this.Ie[a]?this.Ie[a].Ja.canvas.hidden=b:void 0!==this.cd[a]&&(this.cd[a].hidden=b)};q.sT=function(a,b,c,d,e,f,g,k,l,E,u){var ka=this.Mr();null!==ka&&(g=new Hc(g),ka.pT(a,b,c,d,e,f,g,k,l,E,u))};q.ZD=function(a){this.lg=a};q.yO=function(){this.lg=-1};q.UA=function(){if(null!==this.Rk){null!==this.Kd&&this.Zx(this.Kd);for(var a in this.cd)null!==this.cd[a]&&this.Zx(this.cd[a])}};
q.Zx=function(a){var b=this.Rk.Y+this.Ud,c=this.Rk.X+this.Td;0!==b&&(a.style.top=b+"px");0!==c&&(a.style.left=c+"px")};q.FG=function(a){var b=this,c=D.Tb();this.od(a,c?"pointerdown":"mousedown",function(d){b.jo(d)});this.od(a,c?"pointermove":"mousemove",function(d){b.ko(d)});this.od(a,c?"pointerup":"mouseup",function(d){b.lo(d)});!c&&window.ontouchstart&&(this.od(a,"touchstart",function(d){b.jo(d)}),this.od(a,"touchmove",function(d){b.ko(d)}),this.od(a,"touchend",function(d){b.lo(d)}))};
q.GG=function(){var a=this.Wb.hd,b=null,c=null;this instanceof Rc?(c=this,b=this.hb.canvas):a===this.Wb.ba()&&(c=a.IO(),b=this.S);null!==c&&null!==b&&(D.Tb()?(b.addEventListener("pointerup",function(d){c.Gp(d)},!1),b.addEventListener("pointerdown",function(d){c.Gp(d)},!1),b.addEventListener("pointermove",function(d){c.Gp(d)},!1),b.addEventListener("pointerout",function(d){c.Gp(d)},!1)):(b.addEventListener("mousedown",function(d){c.Oj(d)},!1),b.addEventListener("mousemove",function(d){c.Oj(d)},!1),
b.addEventListener("mouseup",function(d){c.Oj(d)},!1),b.addEventListener("mouseout",function(d){c.Oj(d)},!1),b.addEventListener("touchstart",function(d){c.Hu(d)},!1),b.addEventListener("touchmove",function(d){c.Hu(d)},!1),b.addEventListener("touchend",function(d){c.Hu(d)},!1)))};q.Cj=function(a){var b=new I(0,0),c=this.XI(a,b),d=this.$M(a),e=J.Dq(this.oc);a=new $c(a,c,d,e);a.uS(b);return a};q.Ea=function(){return J.Dq(this.oc)};q.$M=function(a){return J.Dm(a)};
q.gl=function(a,b,c){D.ei()&&(a=D.hk(a),c=D.hk(c));c=this.jy(c);this.oc(a.tc(),0,b,[],c)};q.Uk=function(a,b){if(J.Sq(a.xb)||J.ck(a.xb)&&"touch"===a.xb.pointerType)if(null!==this.ld&&this.ld.handleEvent(a,b)||null!==this.Wb.ra&&this.Wb.ra.handleEvent(a,b))return!0;return J.Sq(a.xb)};q.jo=function(a){this.Wb.ub.$C(a);this.UI(a);var b=this.Cj(a);this.Uk(b,db.J)||(a.stopPropagation(),this.uK(a)&&void 0!==this.Wb&&this.Wb.le.wu()&&this.Wb.le.ap(a),this.gl(b.lj,db.J,b.Od))};
q.XI=function(a,b){var c=new I(a.offsetX,a.offsetY);var d=a.target;var e=this.S,f=!1;d===document&&(c=new I(a.pageX,a.pageY));b.X=c.X;b.Y=c.Y;a.target!==this.S&&(a=this.iJ(),null!==a&&null!==a.rc&&null===this.ld&&(d=a.hb.canvas,e=a.S,f=!0),d=J.vC(e,d),D.ei()&&d.hm(D.qq()),c.X+=d.X,c.Y+=d.Y,f||(b.X+=d.X,b.Y+=d.Y));c=this.Kz(c);this.Kz(b);return c};
q.iJ=function(){var a;if(null===this.U)return null;for(a=J.xm(this.Wb.ba(),this.U.id);null!==a&&(void 0===a.rc||null===a.rc||0===a.rc.vD()&&0===a.rc.wD());)a=J.xm(this.Wb.ba(),a.U.id);return a};q.uK=function(a){return 1===a.which};q.aK=function(){return this.tk||null!==this.ld};q.ko=function(a){var b=this.Cj(a);this.Uk(b,db.l)||(a.stopPropagation(),this.gl(b.lj,db.l,b.Od))};q.lo=function(a){this.Wb.ub.aD(a);var b=this.Cj(a);this.Uk(b,db.h)||(a.stopPropagation(),this.gl(b.lj,db.h,b.Od))};q.jy=function(a){return J.pB(a)};
q.Xs=function(){for(var a=0;a<this.bj.length;++a)this.bj[a].wO.removeEventListener(this.bj[a].TB,this.bj[a].callback,!1);this.bj=[]};q.UI=function(a){if(this.aK()){var b=this;this.Wb.Li.Qt(a,b,function(c){b.bL(c)},function(c){b.cL(c)})}};q.bL=function(a){var b=this.Cj(a);a.stopPropagation();this.Uk(b,db.l)||this.gl(b.lj,db.l,b.Od)};q.cL=function(a){var b=this.Cj(a);a.stopPropagation();this.Uk(b,db.h)||this.gl(b.lj,db.h,b.Od)};
q.od=function(a,b,c){this.bj.push({wO:a,TB:b,callback:c});a.addEventListener(b,c,!1)};q.Kz=function(a){a.X=a.X-this.Td;a.Y=a.Y-this.Ud;return a};q.Mr=function(){return-1!==this.lg?32767===this.lg?this.wg:0<this.Ie.length?this.Ie[this.lg]:this.zh[this.lg]:null};q.xi=function(a,b,c){a.canvas.width!==b&&(a.canvas.width=b);a.canvas.height!==c&&(a.canvas.height=c)};
q.cs=function(){this.S.appendChild(this.hb.canvas);this.ua&&(this.ua.de(this.S),"cdsDialog"!==this.P().id&&(this.P().id=this.ua.th?"cdsClientObjectBackgroundContainer":"cdsClientObjectContainer"))};q.wf=function(){return this.ig()};q.vf=function(){return this.hg()};q.Og=function(a){Zc.prototype.Og.call(this,a);this.hb.canvas.id+="_"+a};q.ED=function(a){null===a&&null!==this.nn&&(this.S.removeChild(this.nn),this.S.focus());null===this.nn&&null!==a&&this.S.appendChild(a);this.nn=a};
q.dv=function(a){this.Pn=a};q.Jj=function(){return this.Pn};q.xC=function(){return this.ua instanceof Lc&&this.ua.th};q.jQ=function(a){a%=2;this.Iy(1-a,!0);this.Iy(a,!1)};q.YS=function(){var a=this.S;0===this.Ie.length&&0===this.cd.length&&J.It(a);this.Wb.bx.aT(this,function(b,c){b.jQ(c)},this.Vm)};q.$D=function(){this.Wb.bx.eT(this);this.Xl()||this.WN()};q.rR=function(a){this.ZD(a);if(void 0===this.Ie[a]){var b=Yb.Pv(!1,!1,!0);this.aB(a,b)}};
q.qR=function(a){a!=this.Vm&&(this.Vm=a,this.$D(),0<a&&this.YS())};q.Xl=function(){return 0<this.Vm};var Ic;Ic=function(a,b,c,d){Zc.call(this,a,b,c,d);this.g=d;this.Oy();this.Ii=this.Jd=null;this.ta="";this.ic=null;this.Ez=new ad};Ic.prototype=Object.create(Zc.prototype);q=Ic.prototype;q.constructor=Ic;q.Oy=function(){this.P().id="cdsClientObjectNative"};
q.hS=function(a,b){if(b instanceof bd){this.Jd=b;this.ic=a;var c=cd.h();this.Ii=b.jO(c,a.getConfiguration().ContentSecurityPolicyIncludeTrustedOrigins,this.ka,this.qa,this.g);this.ic.register(c,this)}else this.Jd=b,a=b.jU(),a.style.width="100%",a.style.height="100%",a.style.position="absolute",this.Ii=a;this.Ii.id="cdsNativeElem"+this.ta;this.S.appendChild(this.Ii);this.wv()};q.rb=function(){window.WebvisuInst.ic.unregister(this);Zc.prototype.rb.call(this)};q.FQ=function(a,b){this.Ez.Pu(a,b)};
q.pp=function(a){return this.Ez.nu(a)};q.tM=function(a,b,c){this.oc(a,b,536,[],c)};q.iR=function(a,b,c,d,e){var f=Ga.F(12);a=Cc.F(f,a.A.Ia,a.Db.Ji);a.Vd(c);a.Vd(d);a.Ua(e);this.oc(b,0,539,[],f)};q.oM=function(a,b,c){this.oc(a,b,540,[],c)};q.MS=function(a,b){this.ka=a;this.qa=b;this.wv()};
q.gR=function(a,b,c){var d=new I(b,c);if(0>b||0>c||b>this.ka||c>this.qa)throw Error("Illegal argument!");"mousedown"===a?this.oc(d.tc(),0,db.J,[],void 0):"mousemove"===a?this.oc(d.tc(),0,db.l,[],void 0):"mouseup"===a&&this.oc(d.tc(),0,db.h,[],void 0)};q.MN=function(a,b){if(this.Jd instanceof bd)this.ic.Wc(this,Xc.wE(a,b));else{a=a.split(".");var c=this.Jd;if(null!==c){for(var d=0;d<a.length-1;++d)c=c[a[d]]();c[a[a.length-1]].apply(c,b)}}};
q.update=function(a,b,c,d,e,f,g,k,l,E,u){Zc.prototype.update.call(this,a,b,c,d,e,f,g,k,l,E,u);this.wv()};q.wv=function(){this.Jd instanceof bd&&(this.Ii.setAttribute("style",J.h("border:0; width:{0}px; height:{1}px;",this.ka,this.qa)),this.ic.Wc(this,Xc.yE(this.ka,this.qa)))};var Kc;Kc=function(a,b,c,d){Zc.call(this,a,b,c,d);this.Ds=-1};Kc.prototype=Object.create(Zc.prototype);Kc.prototype.constructor=Kc;Kc.prototype.Oy=function(){this.P().id="cdsClientObjectOldNative"};
Kc.prototype.rb=function(){-1!==this.Ds&&WebvisuExtensionMgr.du(this.Ds);Zc.prototype.rb.call(this)};Kc.prototype.MD=function(a){this.Ds=a};var Oc;Oc=function(a,b,c,d,e,f,g,k){this.rc=f;this.Ya=g;this.st=!1;this.Nd=new dd;Qc.call(this,a,b,c,d,e,k)};Oc.prototype=Object.create(Qc.prototype);q=Oc.prototype;q.constructor=Oc;q.initialize=function(){Qc.prototype.initialize.call(this);var a=this;this.rc.initialize(function(b,c){a.El(b,c)})};q.kv=function(a,b,c,d,e,f){this.rc.update(a,b,c,d,e,f);this.rc.eE(this.ld)};
q.JN=function(){var a=this.Qa;a.sv()?this.kv(this.Nd.Dc.X,0,this.Nd.Cc.X,0,0,0):a.tv()&&this.kv(0,this.Nd.Dc.Y,0,this.Nd.Cc.Y,0,0)};q.DS=function(){this.Qa.sv()?(this.Nd.$h(new I(.3*-this.ka,0)),this.Nd.Zh(new I(.3*this.ka,0)),this.yp()&&this.Nd.$h(new I(-this.ka,0)),this.xp()&&this.Nd.Zh(new I(this.ka,0))):this.Qa.tv()&&(this.Nd.$h(new I(0,.3*-this.qa)),this.Nd.Zh(new I(0,.3*this.qa)),this.yp()&&this.Nd.$h(new I(0,-this.qa)),this.xp()&&this.Nd.Zh(new I(0,this.qa)))};q.CS=function(){this.Ts=!0};
q.AS=function(){this.Ss=!0};q.UQ=function(){this.Ss=this.Ts=!1};q.bE=function(){this.st=!0};q.dE=function(){this.st=!1};q.Bp=function(){return this.st};q.yp=function(){return void 0===this.Ts?!1:this.Ts};q.xp=function(){return void 0===this.Ss?!1:this.Ss};q.Th=function(a,b){this.Bp()||this.rc.Th(a,b)};q.Wu=function(){this.rc.Wu()};q.Kj=function(a){this.rc.Kj(a)};
q.Fi=function(a,b,c,d,e,f,g,k,l){this.Ya&&(this.Ya.style.width=this.wf()+"px",this.Ya.style.height=this.vf()+"px");Qc.prototype.Fi.call(this,a,b,c,d,e,f,g,k,l)};q.gN=function(a,b){this.Bp()||null===this.Ya||(this.Ya.style.left=a+"px",this.Ya.style.top=b+"px")};q.Og=function(a){Qc.prototype.Og.call(this,a);null!==this.Ya&&(this.Ya.id+="_"+a)};q.El=function(a,b){this.gN(-a,-b);for(var c in this.zh){var d=this.zh[c].Ja;d&&(d.bR&&(d.canvas.style.left=d.x-a+"px"),d.cR&&(d.canvas.style.top=d.y-b+"px"))}};
q.cs=function(){this.Ya?(this.Ya.appendChild(this.hb.canvas),this.S.appendChild(this.Ya),this.ua&&(this.ua.de(this.Ya),this.P().id="cdsClientObjectContainer")):Qc.prototype.cs.call(this)};q.wf=function(){return this.Ze()?this.ig():this.Ya?Math.max(0,this.ig()+this.rc.vD()):Qc.prototype.wf.call(this)};q.vf=function(){return this.Ze()?this.hg():this.Ya?Math.max(0,this.hg()+this.rc.wD()):Qc.prototype.vf.call(this)};
q.Mx=function(){var a=J.xa(this.Ya,"cdsClip_before");var b=J.xa(this.Ya,"cdsClip_after");var c=this.Qa;if(null===a){a=this.Nx("cdsClip_before");var d=!0}if(null===b){b=this.Nx("cdsClip_after");var e=!0}c.vu()?(!0===d&&(a.style.left=-this.ka+"px"),b.style.left=this.ka+"px"):c.QC()&&(!0===d&&(a.style.top=-this.qa+"px"),b.style.top=this.qa+"px");!0===d&&this.Ya.appendChild(a);!0===e&&this.Ya.appendChild(b)};var Rc;
Rc=function(a,b,c,d,e,f,g,k){Qc.call(this,a,b,!1,c,d,g);this.Za=null;this.io=this.zn=this.jl=!1;this.s=null;this.QA=!1;this.Aa=e;this.yi=null;this.vr=Va.mq;this.Gt=f;this.g=g;this.dl=!1;this.Bs=null;this.ur="";this.Ac=null;this.ro=this.bA=this.so=this.aA=0;k&&this.AD(k)};Rc.prototype=Object.create(Qc.prototype);q=Rc.prototype;q.constructor=Rc;
q.initialize=function(a,b,c,d,e,f,g){Qc.prototype.initialize.call(this);this.jl=b;this.io=c;this.zn=d;this.Za=a;this.yi=e;this.s=f;this.P().style.transform="scale(0)";this.P().style.opacity=0;this.Aa&&(this.Aa.style.opacity=0,this.PL());g&&(this.vr=Va.HF)};q.rb=function(){this.Aa&&(this.cN(),this.U===this.Aa.parentNode&&this.U.removeChild(this.Aa));Qc.prototype.rb.call(this)};
q.update=function(a,b,c,d,e,f,g,k,l,E,u,ka){""===u&&(this.QA=!0);if(this.zn)Qc.prototype.update.call(this,0,0,c,d,e,f,0,0,l,E,u);else{g=c/2;k=d/2;var ja=c,va=d;null!==this.yi&&null!==this.yi.canvas&&(ja=this.yi.canvas.width-c,va=this.yi.canvas.height-d);this.Za instanceof Bb&&(this.jl?(a=this.Za.Ql().X-c/2,b=this.Za.Ql().Y-d/2,a=Math.min(Math.max(0,ja),Math.max(0,a)),b=Math.min(Math.max(0,va),Math.max(0,b))):this.io&&(this.s.$P&&this.s.ZP?(g=this.Za.zc().Y,k=this.yi.canvas.height-this.Za.Xd().Y,this.s.dD||
this.s.cD)?this.s.dD?this.s.cD||(b=this.Za.Xd().Y,a=this.hr(c)):(b=this.Za.zc().Y-d,a=this.hr(c)):this.s.Lt||this.s.eB?this.s.Lt&&(a=this.hr(c),b=this.Za.Xd().Y,d>k&&g>k&&(b=this.Za.zc().Y-d)):(a=this.Za.zc().X,b=this.Za.Xd().Y,d>k&&g>k&&(b=this.Za.zc().Y-d)):(a=this.Za.Xd().X,b=this.Za.Xd().Y,a>ja&&(a=this.Za.zc().X-c),b>va&&(b=this.Za.zc().Y-d),a=Math.min(Math.max(0,ja),Math.max(0,a)),b=Math.min(Math.max(0,va),Math.max(0,b)))),g=this.Za.Ql().X-a,k=this.Za.Ql().Y-b);Qc.prototype.update.call(this,
a,b,c,d,e,f,g,k,l,E,u);this.P().style.opacity=1;this.Aa&&(this.Aa.style.transition=u,this.Gt&&(this.Aa.style.backgroundColor=ka),this.Aa.style.opacity=1)}};q.hr=function(a){return this.s.eB?this.Za.zc().X:this.s.Lt?this.Za.Xd().X-a:this.Za.zc().X+(this.Za.Xd().X-this.Za.zc().X)/2-a/2};q.de=function(a){this.Aa&&a.appendChild(this.Aa);Qc.prototype.de.call(this,a)};
q.close=function(a){if(this.QA)this.RB(a);else{var b=this;this.od(this.P(),"transitionend",function(){b.RB(a)})}this.Aa&&(this.Aa.style.opacity=0);this.P().style.transform="scale(0)";this.P().style.opacity=0};q.RB=function(a){this.Aa&&this.U===this.Aa.parentNode&&this.U.removeChild(this.Aa);a()};
q.PL=function(){var a=this,b=D.Tb();this.od(this.Aa,b?"pointerdown":"mousedown",function(c){a.Id(c)});this.od(this.Aa,b?"pointermove":"mousemove",function(c){a.Id(c)});this.od(this.Aa,b?"pointerup":"mouseup",function(c){a.Id(c)});!b&&window.ontouchstart&&(this.od(this.Aa,"touchstart",function(c){a.Id(c)}),this.od(this.Aa,"touchmove",function(c){a.Id(c)}),this.od(this.Aa,"touchend",function(c){a.Id(c)}))};
q.cN=function(){var a=this,b=D.Tb();this.Aa.removeEventListener(b?"pointerdown":"mousedown",function(c){a.Id(c)});this.Aa.removeEventListener(b?"pointermove":"mousemove",function(c){a.Id(c)});this.Aa.removeEventListener(b?"pointerup":"mouseup",function(c){a.Id(c)});!b&&window.ontouchstart&&(this.Aa.removeEventListener("touchstart",function(c){a.Id(c)}),this.Aa.removeEventListener("touchmove",function(c){a.Id(c)}),this.Aa.removeEventListener("touchend",function(c){a.Id(c)}))};
q.Id=function(a){this.Aa&&a.target===this.Aa&&a.stopPropagation()};q.Oj=function(a){var b=J.Dm(a);this.Ks(a,b,!1)};q.Gp=function(a){var b=J.Dm(a);this.Ks(a,b,!1)};q.Hu=function(a){if(null!==a.touches&&1<=a.touches.length){var b=J.Dm(a.touches[0]);this.Ks(a,b,!0)}};
q.Ks=function(a,b,c){switch(a.type){case "mouseout":case "pointerout":this.dl?(a.preventDefault(),this.gx(a,b)):this.sA();break;case "mousedown":case "pointerdown":case "touchstart":a.preventDefault();this.jL(b,c);var d=this;this.g.Li.Qt(a,d,function(e){d.Oj(e)},function(e){d.Oj(e)});break;case "mousemove":case "pointermove":case "touchmove":a.preventDefault();this.Js(a,b,c);break;case "mouseup":case "pointerup":case "touchend":a.preventDefault(),this.kL(a,c)}};
q.jL=function(a,b){b||(this.ur=this.S.style.cursor,this.S.style.cursor="move");this.Ac=J.bb().getBoundingClientRect();this.Ac.x=0;this.Ac.y=0;this.aA=this.Ac.x+2;this.so=this.Ac.x+this.Ac.width-2;this.bA=this.Ac.y+2;this.ro=this.Ac.y+this.Ac.height-2;b=new I(parseInt(this.P().offsetLeft,10),parseInt(this.P().offsetTop,10));this.ft(a);this.Bs=new I(b.X-a.X,b.Y-a.Y);this.dl=!0};q.Js=function(a,b,c){this.dl?this.gx(a,b):c||this.sA()};q.kL=function(a,b){this.dl&&(this.Gz(b),this.zA(a))};
q.gx=function(a,b){this.ft(b);b.X<=this.aA||b.X>=this.so||b.Y<=this.bA||b.Y>=this.ro?(this.Gz(this),this.zA(a)):(a=b.X+this.Bs.X,b=b.Y+this.Bs.Y,a<=this.Ac.x&&(a=this.Ac.x),a+this.ka>=this.so&&(a=this.so-this.ka),b<=this.Ac.y&&(b=this.Ac.y),b+this.qa>=this.ro&&(b=this.ro-this.qa),this.P().style.top=b+"px",this.P().style.left=a+"px")};q.Gz=function(a){a||(this.S.style.cursor=""!==this.ur?this.ur:"default");this.dl=!1};
q.zA=function(a){if(null!==this.g.A){var b=new I(parseInt(this.P().style.left,10),parseInt(this.P().style.top,10));a=this.Cj(a).Od;this.ft(a);a=this.jy(a);this.oc(b.tc(),0,537,[],a)}};q.sA=function(){"move"===this.S.style.cursor&&(this.S.style.cursor="default")};q.ft=function(a){D.ei()&&D.hk(a)};var Tc;Tc=function(a,b,c){this.Ja=a;this.dg=b;(this.Vi=null!==b)&&this.dg.appendChild(this.Ja.canvas);this.Ry=c};
Tc.prototype={P:function(){return this.Vi?this.dg:this.Ja.canvas},XR:function(a,b){this.Ja.canvas.id="cdsCanvas"+a+"_Layer_"+b.toString();this.Vi&&(this.dg.id="cdsClip"+a+"_Layer_"+b.toString())},pT:function(a,b,c,d,e,f,g,k,l,E,u){g.Uc()?(this.Ja.x=a,this.Ja.y=b,this.Ja.canvas.style.left=a+"px",this.Ja.canvas.style.top=b+"px"):this.MG(g);this.Ja.width=c;this.Ja.height=d;this.Ja.bR=e;this.Ja.cR=f;this.Ja.canvas.style.width=-1===this.Ja.width?"100%":c+"px";this.Ja.canvas.style.height=-1===this.Ja.height?
"100%":d+"px";this.Vi&&(this.dg.$T=u,this.dg.style.left=k+"px",this.dg.style.top=l+"px",this.dg.style.width=E+"px",this.dg.style.height=u+"px")},MG:function(a){a.right()&&(this.Ja.canvas.style.right="0px");a.left()&&(this.Ja.canvas.style.left="0px");a.top()&&(this.Ja.canvas.style.top="0px");a.bottom()&&(this.Ja.canvas.style.bottom="0px")},Xu:function(){this.Ja.x=0;this.Ja.y=0;this.Ja.width=-1;this.Ja.height=-1}};var Lc;
Lc=function(a){this.U=null;this.sa=[];this.bc={};this.Ta=-1;this.oc=null;this.Nf=-1;this.th=a;this.Dr=this.gj=null;this.Ns=!1;this.vg=new ed;this.Qa=new ib(0);this.wr=null};
Lc.prototype={$A:function(a,b){32767===a?(b.P().id="cdsDemoMode",b.P().style.zIndex=Va.eq,b.de(J.bb()),this.wr=b):-1===this.Ta?(b.Jj()||b.xC()?(b.Og(a),this.av(b,1),b.dv(!0),this.Ns=!0):(b.ua instanceof Lc?null===this.gj&&(this.gj=a):this.Ns&&!this.th?this.av(b,a+1):this.av(b,a),b.dv(this.th),b.Og(a)),b.Tg(this.Jx(a)),this.CA(a,b)):(b.Og(this.Ta),this.Qe(this.Ta).xN(a,b))},av:function(a,b){if(this.Qa.mm()&&!a.Qa.Uc()){var c=this.qC(a.Qa);a.BS(this.U,c,b)}else a.de(this.U,b)},Qu:function(){if(-1===
this.Ta)this.Vx(),this.Qa.mm()&&this.U&&this.vg.clear(this.U),this.Ns=!1;else{var a=this.Qe(this.Ta);void 0!==a&&a.HQ()}},Ru:function(){this.Vx();this.Ta=-1},Lh:function(a){for(var b=0;b<this.sa.length;++b)this.sa[b]&&this.sa[b].Lh(a)},em:function(){for(var a=0;a<this.sa.length;++a)this.sa[a]&&this.sa[a].ua&&this.sa[a].ua.em();for(var b in this.bc)this.bc[b]&&this.bc[b].rb();this.bc={}},Ng:function(){for(var a=0;a<this.sa.length;++a)this.sa[a]&&this.sa[a].Ng();for(var b in this.bc)this.bc[b]&&this.bc[b].Ng()},
Vx:function(){this.Ng();for(var a=0;a<this.sa.length;++a)this.sa[a]&&this.sa[a].rb();for(var b in this.bc)this.bc[b]&&this.bc[b].rb();this.kr()},wa:function(){return-1!==this.Ta?this.Qe(this.Ta).wa():null},$l:function(a){-1===this.Ta?this.Ta=a:this.Qe(this.Ta).$l(a)},Uh:function(){var a;if(-1===this.Ta)return-1;var b=this.wa();(a=b.Ze())&&(b=b.ba())&&b.vg.Vu();b=this.Qe(this.Ta).Uh();-1===b&&(this.Ta===this.gj&&(this.PG(),this.gj=null),a&&this.vg.Vu(),b=this.Ta,this.Ta=-1);return b},Tg:function(a){this.oc=
a},de:function(a){this.U=a;for(var b=0;b<this.sa.length;++b)this.sa[b]&&this.sa[b].de(a);for(var c in this.bc)this.bc[c]&&this.bc[c].de(a)},PG:function(){this.vg.wC()&&null!==this.gj&&this.QG()||this.sa.forEach(function(a){a&&(a.U=this.U,this.U.appendChild(a.P()))}.bind(this))},QG:function(){var a=this.vg.pC(this.gj);if(null===a)return!1;var b=this.qC(a.Qa);a.U=this.U;null===b?this.U.appendChild(a.P()):b.appendChild(a.P());return!0},isActive:function(){return-1!==this.Ta},mv:function(a){this.Nf=a},
KR:function(a){this.Dr=a},kr:function(){this.sa=[];this.bc={};this.wr=null},qC:function(a){return this.Qa.mm()&&this.Qa.Uc()&&a?a.PC()?J.xa(this.U,"cdsClip_before"):a.OC()?J.xa(this.U,"cdsClip_after"):null:null},Qe:function(a){if(32767===a)return this.wr;if(this.vg.wC()){var b=this.vg.pC(a);if(null!==b)return b}return this.bc.hasOwnProperty(a)?this.bc[a]:this.sa[a-1]},CA:function(a,b){b.Qa.Uc()?b.Jj()?this.bc[a]=b:this.sa[a-1]=b:this.vg.xS(a,b)},Ey:function(){return null===this.Dr?this.sa.length:
this.Dr},Jx:function(a){var b=this;return function(c,d,e,f,g,k){var l=b.Qe(a);l&&!l.Jj()&&f.push({id:a,WC:b.Ey()});-1!==b.Nf&&f.push({id:b.Nf,WC:15});c=b.oc(c,d,e,f,g,k);if(k)return c}}};var Sc;Sc=function(){Lc.call(this,!1);this.sa={};this.co=0};Sc.prototype=Object.create(Lc.prototype);q=Sc.prototype;q.constructor=Sc;q.zN=function(a,b){b.de(this.U);b.Tg(this.Jx(a));b.Og(a);this.sa[String(a)]=b;this.co=Math.max(this.co,a)};q.IQ=function(a){var b=this,c=this.Qe(a);this.iI(a);c.Ng();c.close(function(){b.$K(c)})};
q.rQ=function(a){this.Ta=a};q.nQ=function(){var a=this.Ta;this.Ta=-1;return a};q.Ru=function(){this.rJ();this.kr();this.Ta=-1};q.em=function(){for(var a in this.sa)this.sa[a]&&this.sa[a].ua&&this.sa[a].ua.em()};q.Lh=function(a){for(var b in this.sa)this.sa[b]&&this.sa[b].Lh(a)};q.IO=function(){return-1!==this.Ta?this.Qe(this.Ta):null};q.kr=function(){this.sa={}};
q.iI=function(a){delete this.sa[String(a)];this.Ta===a&&(this.Ta=-1);this.co=Object.keys(this.sa).map(Number).reduce(function(b,c){return Math.max(b,c)},0)};q.$K=function(a){a.rb()};q.rJ=function(){var a=Rc.prototype.rb,b=[],c;for(c in this.sa)this.sa[c]&&a.apply(this.sa[c],b)};q.Qe=function(a){return this.sa[String(a)]};q.CA=function(a,b){this.sa[String(a)]=b};q.Ey=function(){return this.co};var ed;ed=function(){this.cg=[];this.bg=[];this.mk=new ub};
ed.prototype={empty:function(){return 0===this.cg.length&&0===this.bg.length},Vu:function(){this.mk=new ub},wC:function(){return!this.mk.Uc()},clear:function(a){var b=J.xa(a,"cdsClip_before");var c=J.xa(a,"cdsClip_after");b&&(J.It(b,"cdsClip_before_canvas"),b=J.xa(a,"cdsClip_before_canvas"),b=b.getContext("2d"),b.clearRect(0,0,b.canvas.width,b.canvas.height));c&&(J.It(c,"cdsClip_after_canvas"),b=J.xa(a,"cdsClip_after_canvas"),b=b.getContext("2d"),b.clearRect(0,0,b.canvas.width,b.canvas.height));this.cg=
[];this.bg=[];this.Vu()},pC:function(a){return this.mk.before()&&0<this.cg.length?this.cg.hasOwnProperty(a)?this.cg[a]:this.cg[a-1]:this.mk.after()&&0<this.bg.length?this.bg.hasOwnProperty(a)?this.bg[a]:this.bg[a-1]:null},xS:function(a,b){var c=b.Qa;this.mk.UR(b.Qa);c.PC()?b.Jj()?this.cg[a]=b:this.cg[a-1]=b:c.OC()&&(b.Jj()?this.bg[a]=b:this.bg[a-1]=b)}};var fd;fd=function(a,b,c,d){this.kc=a;this.EF=b;this.FF=c;this.GF=d};var gd;gd=function(a,b){this.kc=a;this.ff=b};var hd;
hd=function(a,b,c,d){this.kc=a;this.ff=b;this.Jc=c;this.Error=d};var id,jd,nc;nc=function(a){this.Ka=new XMLHttpRequest;this.g=a;this.je=null};
nc.prototype={tb:function(a,b,c,d){this.g.getConfiguration()?(this.Fg(),this.je.send(a,b,c,d)):this.g.error("Error while creating a connection to the webserver: No configuration found")},bP:function(){var a=this.g.getConfiguration();return("WebSocket"in window||"MozWebSocket"in window)&&2===window.WebSocket.CLOSING&&J.Cm(a.RuntimeVersion,22)},Fg:function(a){a="undefined"!==typeof a?a:!1;if(null===this.je){var b=this.g.getConfiguration();if(b.CasFactoryName)this.je=new id;else return this.bP()&&!b.WebSocketsDisabled&&
a?this.je=new lc(this.g):this.je=new jd(this.g,this.Ka),this.je}else return this.je},Au:function(a,b){this.vb=b;this.Ka.open("GET",a,!0);var c=this;this.Ka.onreadystatechange=function(){c.eQ(a)};this.Ka.send()},eQ:function(a){4===this.Ka.readyState&&(200===this.Ka.status||"OK"===this.Ka.status?this.vb.Nl(this.Ka.responseText):this.vb.O("Loading file '"+a+"' failed: "+this.Ka.status,$a.Sb))},Kl:function(a){this.Fg();null!==this.je&&this.je instanceof id&&this.je.Kl(a)}};
id=function(){var a=this;window.CODESYS.CAS.resultListener=function(b){a.vb.sb(b)}};id.prototype={send:function(a,b){this.vb=b;window.CODESYS.CAS.sendMessage(a)},Kl:function(a){window.CODESYS.CAS.sendCloseBeacon(a)}};jd=function(a,b){this.g=a;this.Ka=b};
jd.prototype={send:function(a,b,c,d){void 0===c&&(c=!1);void 0===d&&(d=!1);this.vb=b;b="WebVisuV3.bin";var e=this;d=this.qM(d,a);D.hP()&&(b+="?"+J.l());c&&"function"==typeof navigator.sendBeacon?navigator.sendBeacon(b,new Uint8Array(a)):(this.Ka.open("POST",b,!c),c||D.lk()||(this.Ka.responseType="arraybuffer"),this.Ka.setRequestHeader("Content-Type","application/octet-stream"),d&&this.Ka.setRequestHeader("3S-Repl-Content",J.SC(a)),c||(this.Ka.onreadystatechange=function(){e.fQ()}),0<this.g.getConfiguration().XhrSendTimeout&&
(this.Ka.timeout=this.g.getConfiguration().XhrSendTimeout,this.Ka.ontimeout=function(){e.vb.O("Sending service timeout",$a.Yc)}),d?this.Ka.send():this.Ka.send(a))},fQ:function(){if(4===this.Ka.readyState)if(200===this.Ka.status||"OK"===this.Ka.status){this.Ka.onreadystatechange=null;if(D.lk()){var a=this.Ka.responseText;""===a&&(a=null)}else a=this.Ka.response,a instanceof ArrayBuffer&&0===a.byteLength&&(a=null);try{null!==a||this.aJ()?this.vb.sb(a):this.vb.O("Sending service failed, server not available?",
$a.l)}catch(b){this.vb.O("Unexpected exception while evaluating comm result"+b,$a.xa)}}else 4E3===this.Ka.status?this.g.OP():0===this.Ka.status?this.vb.O("Sending service aborted",$a.J):this.vb.O("Sending service failed, status: "+this.Ka.status,$a.ab)},aJ:function(){return"function"!==typeof this.vb.yj?!1:this.vb.yj()},qM:function(a,b){return window.btoa?(a||this.g.cA)&&b instanceof ArrayBuffer&&70>b.byteLength?!0:!1:!1}};var Ua;Ua=function(){};Ua.xa=43981;Ua.l=0;Ua.Sb=1;Ua.Yc=129;Ua.h=0;Ua.J=0;
Ua.ab=1;var kd;kd=function(a,b,c){this.ht=a;this.it=b;this.AA=c;this.re=0};kd.read=function(a){var b=a.getUint16(),c;if(52565!==b)throw Error("Unsupported protocol: "+b);this.Nk=a.getUint16();if(12>this.Nk)throw Error("Unsupported length of header: "+this.Nk);this.ht=a.getUint16();this.it=a.getUint16();this.AA=a.getUint32();this.re=a.getUint32();b=this.Nk-12;16<=this.Nk&&(a.getUint16(),b-=2);for(c=0;c<b;++c)a.getUint8();return this};
kd.prototype={write:function(a,b){a.Nb(52565);a.Nb(16);a.Nb(this.ht);a.Nb(this.it);a.K(this.AA);a.K(b);a.Nb(0);a.Nb(0)}};var ld;ld=function(a,b,c){this.Bh=new Fc(a,b,c);this.R=this.Bh.M};
ld.prototype={kD:function(){try{if("|"!==this.R.Bj())return"Unexpected format of service: 1";var a=this.NA(),b=!1;if(4>a.length)return"Unexpected format of service: 2";5<=a.length&&(b="true"===a[4]);return new Ta(parseInt(a[0],10),0===parseInt(a[1],10),parseInt(a[2],10),"true"!==a[3],b)}catch(c){return"Exception during readOpenConnectionResult: "+c}},AQ:function(){var a=this.NA(),b;for(b=0;b<a.length;++b)if(0===a[b].indexOf("IPv4:"))return a[b].substr(5);return""},NA:function(){for(var a=[],b="";!this.R.Pf();){var c=
this.R.Bj();"|"===c?(a.push(b),b=""):b+=c}return a},Jb:function(a,b){for(a=this.R.ga()+a;this.R.ga()<a;){var c=this.Bh.Fj(),d=this.Bh.Fj();c=b[c];var e=this.R.ga();"function"===typeof c&&c(this,d);c=this.R.ga()-e;c<d&&this.EM(d-c)}},wQ:function(a){return a?this.LL():this.ML()},ML:function(){try{var a=this.Pd(1,2),b=0,c=0,d=0,e=Ua.J;this.Jb(a.re,{130:function(f,g){f.Jb(g,{32:function(k){b=k.R.getUint16()},33:function(k){c=k.R.getUint32()}})},34:function(f){e=f.R.getUint32()},65407:function(f){d=f.R.getUint16()}});
return new hd(b,c,e,d)}catch(f){return"Exception during readOldDeviceSessionResult: "+f}},LL:function(){try{var a=this.Pd(1,10),b=0,c=0,d=Ua.J;this.Jb(a.re,{33:function(e){b=e.R.getUint32()},70:function(e){d=e.R.getUint32()},65407:function(e){c=e.R.getUint16()}});770===c&&(d=Ua.ab);return new hd(0,b,d,c)}catch(e){return"Exception during readNewDeviceSessionResult: "+e}},uQ:function(a,b){return 2===a?this.yQ():this.zQ(b?65315:35)},yQ:function(){try{var a=this.Pd(1,2),b=0,c=0,d=null,e=null,f=null;this.Jb(a.re,
{65410:function(g,k){g.Jb(k,{32:function(l){c=l.R.getUint16()}})},130:function(g,k){g.Jb(k,{32:function(l){b=l.R.getUint16()}})},39:function(g){d=g.R.$e(!1)},38:function(g,k){var l=Ga.F(k);l.Uo(g.R.zj(),g.R.ga(),k);e=l.Zd()},65315:function(g){f=g.R.getUint32()}});return new fd(0!==b?b:c,f,d,e)}catch(g){return"Exception during readNewDeviceCryptResult: "+g}},zQ:function(a){try{var b=this.Pd(1,2),c=0,d=0,e=0,f={65410:function(g,k){g.Jb(k,{32:function(l){d=l.R.getUint16()}})},130:function(g,k){g.Jb(k,
{32:function(l){c=l.R.getUint16()}})}};f[a]=function(g){e=g.R.getUint32()};this.Jb(b.re,f);return new fd(0!==c?c:d,e,null,null)}catch(g){return"Exception during readOldDeviceCryptResult: "+g}},vQ:function(){try{var a=this.Pd(1,2),b=0,c=0,d=0;this.Jb(a.re,{65410:function(e,f){e.Jb(f,{32:function(g){c=g.R.getUint16()},33:function(g){d=g.R.getUint32()}})},130:function(e,f){e.Jb(f,{32:function(g){b=g.R.getUint16()},33:function(g){d=g.R.getUint32()}})}});return new gd(0!==b?b:c,d)}catch(e){return"Exception during readOldDeviceLoginResult: "+
e}},CQ:function(){try{for(this.Pd(4,1);!this.R.Pf();){var a=this.Bh.Fj();this.Bh.Fj();if(1===a){var b=this.R.getUint32();return 2952790016>b?b:4294967290===b?"Visualization is not allowed":4294967292===b?"No more memory on the plc":4294967293===b?"Connection to invalid application":4294967289===b?"Too many clients are registering at the same time":"Unknown error"}return 65410===a?"no rights":65407===a?"Visu not supported by the plc":"Unknown tag ID"}return"Unexpected format of service: 4"}catch(c){return"Exception during readVisuRegisterClientResult: "+
c}},BQ:function(){try{for(this.Pd(4,3);!this.R.Pf();){var a=this.Bh.Fj();this.Bh.Fj();if(65407===a)return"Visu not supported by the plc";var b=this.R.getUint32();return 0===b||1===b?b:2===b?"Client registration failed":3===b?"Client registration failed due to an invalid external id":4===b?"The maximum number of visualization clients is already connected. Please try again later.":5===b?"Not enough memory in the PLC to create the client.":"Unknown error"}return"Unexpected format of service: 5"}catch(c){return"Exception during readVisuIsRegisteredClientResult: "+
c}},DQ:function(){try{return this.Pd(4,2),0}catch(a){return"Exception during readVisuRemoveClientResult: "+a}},Ou:function(a){var b=0===a.direction?5:2,c=132;a.status.Zb===md.J&&(b=Ua.Sb,c=Ua.Yc);try{var d=this.Pd(8,b);b={};b[c]=function(e,f){e.Jb(f,{2:function(g){a.li.oT=g.R.getUint32();a.li.Be=g.R.getUint32()},3:function(g){a.Xp=g.R.getUint32()},8:function(g){a.status.result=g.R.getUint16()}})};b[34]=function(e){e.R.getUint32()};b[65410]=function(e,f){e.Jb(f,{32:function(g){a.status.result=g.R.getUint16()}})};
this.Jb(d.re,b)}catch(e){return"Exception during readtFileAndSessionInfoResult: "+e}},jD:function(a){var b=0===a.direction?7:4,c=0;try{var d=this.Pd(8,b),e=0===a.direction?a.li.Be:a.di.Be,f={};0===a.direction?(f[6]=function(g){c=g.R.getUint32()},f[7]=function(g,k){a.status.we=!0;f[5](g,k)},f[5]=function(g,k){null===a.buffer&&(a.buffer=Ga.F(e));if(a.status.zd+c<=e&&c<=k){for(k=0;k<c;)a.buffer.Ro(g.R.getUint8()),k++;a.status.zd+=c;a.status.result=Ua.h}else a.status.zd=4294967295}):f[5]=function(g){g=
g.R.getUint16();g===Ua.h?(a.status.result=Ua.h,a.status.zd+=a.status.ai,a.status.ai=0,a.status.we=a.status.zd>=e):a.status.result=g};this.Jb(d.re,f)}catch(g){return"Exception during readtFileAndSessionInfoResult: "+g}},xQ:function(a){var b=0===a.direction?a.li.Be:a.di.Be;b=a.status.result===Ua.h&&a.status.zd===b&&a.status.we?8:9;try{var c=this.Pd(8,b);this.Jb(c.re,{7:function(d){d.R.getUint16();a.status.we=!0}})}catch(d){return"Exception during readFinishFileTransferResult: "+d}},Qj:function(a){try{var b=
this.Pd(4,4),c=0,d=a;this.Jb(b.re,{132:function(e,f){e.Jb(f,{2:function(g){g.R.getUint32();var k=g.R.getUint32(),l=g.R.getUint32();g=g.R.getUint32();d=new hb(k,l,g)},4:function(){d.finish()},1:function(g){c=g.R.getUint32()},3:function(g,k){d.Zd().Uo(g.R.zj(),g.R.ga(),Math.min(k,d.SP()))}})}});return 0!==c?65535===c?"Client id not present or no longer valid":c.toString():null===d?"Unexpected format of service: 6":d}catch(e){return"Exception during readVisuGetPaintDataResult: "+e}},EM:function(a){this.R.seek(this.R.ga()+
a)},Pd:function(a,b){var c=kd.read(this.R),d=4+c.Nk+c.re;if(this.R.size()<d)throw Error("Actual packet size "+this.R.size()+" smaller than expected "+d);if(c.ht!==(128|a)||c.it!==b)throw Error("Unexpected format of service: 3");return c}};var oc;
(function(){var a=!1;oc=function(b,c,d,e){this.ia=b;this.qI=c;this.oa=Ga.F(50);this.LH=d;this.ea=new Gc(this.oa,b,e);this.G=this.ea.mf};oc.prototype={bT:function(b){a=b},kb:function(){return this.oa.Zd()},Iu:function(b,c,d){var e=this.G.jb("|",!1);b=this.G.jb(b,!1);c=this.G.jb(c.toString(),!1);d=this.G.jb(d.toString(),!1);this.Tm(1);this.G.Dg(e);this.G.Dg(b);this.G.Dg(e);this.G.Dg(c);this.G.Dg(e);this.G.Dg(d);this.G.Dg(e)},VQ:function(){this.Tm(3)},vO:function(){this.Tm(100)},Oo:function(b,c,d){d=
c.jb(d,!1);var e=d.length()+1,f=this.jg(e,4,2);b.I(e+f,3);c.jc(d);this.Xf(c,f,0)},eO:function(b){var c=Ga.F(500),d=new Gc(c,this.ia),e=d.mf;d.I(64);d.I(4,3);e.K(2882382797);d.I(65);this.Oo(d,e,"WebVisualization");d.I(67);this.Oo(d,e,b);d.I(68);this.Oo(d,e,Sb.h);d.I(69);this.Oo(d,e,Sb.h);return c},cI:function(b,c){var d=Ga.F(500),e=new Gc(d,this.ia),f=e.mf,g=new Uint8Array(c);e.I(16);var k=b.byteLength;var l=this.jg(k,4,2);e.I(k+l,3);for(k=0;k<b.length;++k)f.Ua(b[k]);this.Xf(f,l,0);e.I(17);k=c.byteLength;
e.I(k,3);for(k=0;k<g.length;++k)f.Ua(g[k]);return d},sO:function(b){var c=this.Sc(1,10);b=this.eO(b.A.Aq);var d=Ua.ab;this.ea.I(131);this.$q(b,this.ea,this.G);this.ea.I(70);D.TE()&&(d|=2);this.ea.I(4,3);this.G.K(d);this.Lc(c)},$q:function(b,c,d){var e=2>=c.mC(b.size())?2:6;c.I(b.size(),e);this.Sm(d,b)},pO:function(b){var c=this.Sc(1,2);this.Xw(b,1);this.Lc(c)},Xw:function(b,c){this.ea.I(34);this.ea.I(4,3);this.G.K(b);this.ea.I(37);this.ea.I(4,3);this.G.K(c)},qO:function(b,c){var d=this.Sc(1,2);b=
this.cI(b,c);this.Xw(2,2);this.ea.I(129);this.$q(b,this.ea,this.G);this.Lc(d)},eu:function(b,c,d,e){if(void 0===b||null===b)b="";void 0===c&&(c=null);void 0===d&&(d=0);void 0===e&&(e=Ua.J);var f=this.Sc(1,2),g=null,k=null,l=new oa("utf-8");this.ea.I(34);this.ea.I(4,3);this.G.K(e);0!==d&&(this.ea.I(35),this.ea.I(4,3),this.G.K(d));null!==c&&(k=l.encode(c));b=l.encode(b);b=this.CJ(b);null!==k&&0!==d&&e===Ua.ab&&(g=this.BJ(k,d));this.ea.I(129);this.ea.I(b.size()+(null!==g?g.size():0),2);this.Sm(this.G,
b);null!==g&&this.Sm(this.G,g);this.Lc(f)},rO:function(){var b=this.Sc(1,3);this.G.K(0);this.Lc(b)},AT:function(b,c,d,e){var f=this.Sc(4,1);b=this.G.jb(b,!1);var g=b.length()+4+1,k=this.jg(g,4,0),l=0,E=0,u=524288,ka=this.G.jb(c,!1),ja=this.G.jb(d,!1);c&&0<c.length&&l++;d&&0<d.length&&l++;0<l&&(E=8+84*l,g+=E);e&&(u=2097152);this.ea.I(1);this.ea.I(g+k,3);this.G.jc(b);this.Xf(this.G,k,0);this.G.K(u);0<l&&(this.G.K(E),this.G.K(l),c&&0<c.length&&(this.G.Nb(1),this.G.jc(ka),this.G.So(82-ka.length()-1)),
d&&0<d.length&&(this.G.Nb(2),this.G.jc(ja),this.G.So(82-ja.length()-1)));this.Lc(f)},yT:function(b){var c=this.Sc(4,3);this.ea.I(3);this.ea.I(4,3);this.G.K(b);this.Lc(c)},Xj:function(b){this.YA(b,4,132)},xT:function(b){var c=this.Sc(4,4);this.ea.I(132);this.ea.I(8,2);this.ea.I(4);this.ea.I(4,3);this.G.K(b);this.Lc(c)},zT:function(b){this.YA(b,6,134)},yv:function(b){var c=this.Sc(4,2);this.ea.I(2);this.ea.I(4,3);this.G.K(b);this.Lc(c)},gO:function(b){var c=this.Sc(8,Ua.Sb);b=this.G.jb(b.Vh,!1);var d=
b.length()+1,e=this.jg(d,4,2);this.ea.I(1);this.ea.I(d+e);this.G.jc(b);this.Xf(this.G,e,0);this.ea.I(2);this.ea.I(8,3);this.G.K(0);this.G.K(0);this.Lc(c)},EB:function(b){var c=this.Sc(8,0===b.direction?5:2),d=this.G.jb(b.Vh,!1),e=d.length()+1,f=this.jg(e,4,2);this.ea.I(1);this.ea.I(e+f);this.G.jc(d);this.Xf(this.G,f,0);0===b.direction?(this.ea.I(2),this.ea.I(8,3),this.G.K(0),this.G.K(0)):(this.ea.I(2),this.ea.I(8,3),b.di.Be=b.buffer.size(),this.G.K(0),this.G.K(b.di.Be));this.Lc(c)},DB:function(b){var c=
this.Sc(8,0===b.direction?7:4);if(1===b.direction){var d=b.di.Be;var e;var f=this.wJ();if(20<f)f-=20;else return 1;f>d-b.status.zd&&(f=d-b.status.zd);d=this.jg(f,4,0);this.ea.I(6);this.ea.I(4,3);this.G.K(f);b.status.ai=f;this.ea.I(5);this.ea.I(4+f+d,3);this.G.K(b.Xp);for(e=0;e<f;e++)this.G.Ua(b.buffer.getUint8());this.Xf(this.G,d,0)}else this.ea.I(5),this.ea.I(4,3),this.G.K(b.Xp),this.G.K(Ua.h);this.Lc(c)},hO:function(b){var c=0===b.direction?b.li.Be:b.di.Be;c=this.Sc(8,b.status.result===Ua.h&&b.status.zd===
c&&b.status.we?8:9);this.ea.I(7);this.ea.I(4,3);this.G.K(b.Xp);this.Lc(c)},YA:function(b,c,d){c=this.Sc(4,c);b=this.OJ(b);this.ea.I(d);this.$q(b,this.ea,this.G);this.Lc(c)},Lc:function(b){var c=this.G.ga()-b.fG;this.tN(b.YE,c)},Sc:function(b,c){b=new kd(b,c,this.qI);this.Tm(2);this.G.So(20);return{YE:b,fG:this.G.ga()}},CJ:function(b){var c=Ga.F(10+b.byteLength),d=new Gc(c,this.ia),e=d.mf,f=b.byteLength+1,g=this.jg(f,4,2);d.I(16);d.I(f+g);for(d=0;d<b.byteLength;++d)e.Ua(b[d]);e.Ua(0);this.Xf(e,g,0);
return c},BJ:function(b,c){b=this.AJ(b,c);c=Ga.F(10+b.length);var d=new Gc(c,this.ia),e=d.mf;d.I(17);d.I(b.length,3);for(d=0;d<b.length;++d)e.Ua(b[d]);return c},AJ:function(b,c){var d="Qcw@e46A6!R.gssltR4dg=_l)B^nQSo^",e="",f=[],g=0,k=0,l=b.byteLength+1,E=[c&255,0,0,0];for(c=0;c<d.length;c+=4)e=e.concat(String.fromCharCode(d.charCodeAt(c+2)+3)),e=e.concat(String.fromCharCode(d.charCodeAt(c+1)+2)),e=e.concat(String.fromCharCode(d.charCodeAt(c+3)+4)),e=e.concat(String.fromCharCode(d.charCodeAt(c)+1));
d=e;32>l&&(l=32);0!==l%4&&(l+=4-l%4);for(c=0;c<l;++c){e=d.charCodeAt(g);var u=0;c<b.byteLength&&(u=b[c]);f[c]=(u^e+E[k])&255;g++;g===d.length&&(g=0);k++;4===k&&(k=0)}return f},wJ:function(){return this.LH-this.G.ga()},OJ:function(b){var c=Ga.F(100),d=new Gc(c,this.ia),e=d.mf,f=b.Uw,g=b.Ea();d.I(1);d.I(16,3);e.K(b.ge);e.K(b.IF);e.K(b.JF);e.K(b.lE);(null!==f||null!==g&&!a)&&this.sN(d,f,a?null:g);null!==b.ki&&(d.I(3),d.I(8,3),e.Nb(b.ki.u),e.Nb(b.ki.v),e.Nb(b.ki.Z),e.Nb(b.ki.da));null!==g&&a&&(d.I(5),
d.I(8,3),e.K(g.Ib),e.K(g.ec));return c},sN:function(b,c,d){b.I(2);var e=0,f=b.mf;null!==d&&(e=8);null!==c&&(e+=c.size());var g=this.jg(e,4,0);b.I(e+g,3);null!==d&&(f.K(d.Ib),f.K(d.ec));null!==c&&this.Sm(f,c);this.Xf(f,g,0)},Sm:function(b,c){var d=c.size(),e;for(e=0;e<d;++e)b.Ua(c.aC(e))},jg:function(b,c,d){for(var e=0;0!==(b+d)%c;)b++,e++;return e},Xf:function(b,c,d){for(var e=0;e<c;++e)b.Ua(d)},Tm:function(b){this.G.Ua(b);this.G.Ua(0);this.G.Nb(0)},tN:function(b,c){this.G.seek(4);b.write(this.G,
c)}}})();var lc;lc=function(a){this.g=a;this.eo=[];this.Un=!0;this.rs=0;this.uN=this.l();this.Tc=null;this.pf=this.g.getConfiguration();this.Vn=!0;this.hs=this.aj=!1;this.h()};
lc.prototype={l:function(){var a;var b=-1!==location.protocol.indexOf("https")?"wss":"ws";""===location.port?a="ws"===b?80:443:a=location.port;return b+"://"+location.hostname+":"+a.toString()+"/WebVisuV3.bin"},h:function(){var a=this;this.Vn=!1;this.Tc=new WebSocket(this.uN);this.Tc.onerror=function(){a.aj&&(a.hs=!0);a.Vn=!0;a.aj=!1;a.Tc.onclose=function(){}};this.Tc.onclose=function(){a.aj&&(a.hs=!0);N.l("WebSocket connection has been closed");a.aj=!1;a.Vn=!0};this.Tc.onmessage=function(b){return a.TJ(b)};
this.Tc.onopen=function(){a.aj=!0}},isConnected:function(){return this.aj},disconnect:function(){"undefined"!==typeof this.Tc&&(this.Tc.close(1E3),this.g.ep())},SA:function(a){0===a.byteLength?this.vb.sb(null):this.vb.sb(a)},xA:function(a){"undefined"!==typeof this.Tc&&(this.Tc.readyState!==WebSocket.OPEN?N.warn("Connection is not open !!! -> can't send data"):(this.Tc.send(a),this.rs=J.l()))},GP:function(){J.l()-this.rs>this.pf.Lw&&(this.Un=!0,N.info("Keep Alive refresh"))},hR:function(){for(var a=
0,b=this.eo;a<b.length;a++)this.xA(b[a]);this.eo.splice(0,this.eo.length)},send:function(a,b){"undefined"!==typeof this.Tc&&(this.vb=b,this.Tc.readyState===WebSocket.OPEN?this.xA(a):this.Tc.readyState===WebSocket.CONNECTING&&this.eo.push(a))},TJ:function(a){var b=this;b.rs=J.l();"undefined"!==typeof this.vb&&(a.data instanceof Blob?a.data.arrayBuffer().then(function(c){b.SA(c)}):a.data instanceof ArrayBuffer?b.SA(a.data):"string"===typeof a.data&&"U"===a.data&&(this.Un=!0))},EP:function(){this.GP();
return this.Un?(this.Un=!1,!0):!1}};var Zb;Zb=function(){};Zb.yG=0;Zb.CE=1;var Wb;Wb=function(a){this.l=D.Tb();this.gb=[];this.g=a;var b=this;this.h(this.l?"pointermove":"mousemove",function(c){b.Js(c)});this.h(this.l?"pointerup":"mouseup",function(c){b.J(c)});this.h(this.l?"pointercancel":"mousecancel",function(c){b.Ch(c)});this.jd=[]};
Wb.prototype={JQ:function(a){var b=[],c,d=this;for(c=0;c<this.jd.length;++c)this.jd[c].target===a&&b.push(c);if(0!==b.length){var e=J.dk(a.S);var f=J.Dq(a.oc);a=function(k){k.stopPropagation()};var g=function(k){d.nI(k,db.h,e,f)};for(c=0;c<b.length;++c)this.jd[c].target=null,this.jd[c].Fu=a,this.jd[c].uv=g,this.jd[c].Ot=void 0}},nI:function(a,b,c,d){a.stopPropagation();var e=new I(a.pageX,a.pageY),f=new I(a.pageX,a.pageY);e.Xc(c);a=new $c(a,e,f,d);if(null!==this.g.ra&&this.g.ra.handleEvent(a,b))return!0;
b=Ba.h(b,this.g.A.ma,e);b.ce(d);D.ei()&&(f=D.hk(f));d=J.pB(f);b.Qb(d);this.g.ud(b)},Xs:function(a){for(var b=a.length-1;0<=b;--b)this.jd.splice(a[b],1)},h:function(a,b){this.gb.push({TB:a,callback:b});document.addEventListener(a,b,!0)},Js:function(a){var b=this.Fn(J.Uf(a));null!==b&&b.Fu&&b.Fu(a)},J:function(a){var b=J.Uf(a),c=this.Fn(b);null!==c&&(this.Mp(b),c.uv&&c.uv(a))},Ch:function(a){var b=J.Uf(a),c=this.Fn(b);null!==c&&(this.Mp(b),c.Ot&&c.Ot(a))},Fn:function(a){for(var b=0;b<this.jd.length;++b)if(this.jd[b].SB===
a)return this.jd[b];return null},Mp:function(a){for(var b=[],c=0;c<this.jd.length;++c)this.jd[c].SB===a&&b.push(c);this.Xs(b)},Qt:function(a,b,c,d,e){var f=J.Uf(a);if(null!==this.Fn(f))throw Error("This event is already registered.");if(J.ck(a)&&a.target.releasePointerCapture)try{a.target.releasePointerCapture(f)}catch(g){}this.jd.push({SB:f,target:b,Fu:c,uv:d,Ot:e})}};var db;db=function(){};db.J=2;db.h=4;db.l=16;db.ab=521;db.xa=529;var Ba;
Ba=function(a,b,c,d){void 0===c&&(c=0);void 0===d&&(d=0);this.ge=a;this.lE=b;this.IF=c;this.JF=d;this.ki=this.Uw=null;this.ll=!1;this.Gb=null};Ba.h=function(a,b,c){D.ei()&&(c=D.hk(c));return Ba.l(a,b,c)};Ba.J=function(a,b,c,d){return new Ba(a,b,c,d)};Ba.ab=function(a,b){return new Ba(257,a,b.charCodeAt(0))};Ba.xa=function(a,b,c,d,e,f,g,k){var l=Ga.F(12),E=Cc.F(l,!0);b=(b?c?d?7:5:d?3:1:0)|(k?32:0)|(g?16:0);a=new Ba(516,a,b,0);E.Gc(0);E.Gc(0);E.Gc(e.C()-1);E.Gc(e.B()-1);E.To(f);a.Qb(l);return a};
Ba.Sb=function(a,b,c){return Ba.l(a,b,c)};Ba.l=function(a,b,c){return new Ba(a,b,c.tc())};Ba.prototype={OD:function(a){this.ki=new Bb(Math.max(0,a.u),Math.max(0,a.Z),Math.max(0,a.v),Math.max(0,a.da))},Qb:function(a){this.Uw=a},LS:function(){this.ll=!0},ce:function(a){this.Gb=a},Ea:function(){return this.Gb}};var nd;nd=function(){var a;void 0===a&&(a=100);this.on=[];this.uj=this.pl=0;this.Yk=a;this.En=!1;this.mz=0};
nd.prototype={push:function(a){2097152!==a.ge&&(this.mz=J.l());if(this.rK(a))return!0;if(this.En)return"undefined"!==typeof N&&N.warn(J.h("Eventqueue full, dropped event with tag {0}",a.ge)),!1;this.on[this.uj%this.Yk]=a;this.uj=(this.uj+1)%this.Yk;this.uj===this.pl&&(this.En=!0);return!0},empty:function(){return!this.En&&this.pl===this.uj},pop:function(){if(this.empty())return null;this.En=!1;var a=this.pl;this.pl=(this.pl+1)%this.Yk;return this.on[a]},rK:function(a){if(!this.empty()&&(a.ge===db.l||
2053===a.ge||2055===a.ge||516===a.ge||this.Sy(a.ge))){var b=(this.uj+this.Yk-1)%this.Yk,c=this.on[b];if(c.ge===a.ge&&(!this.Sy(a.ge)||this.dK(a,c)))return this.on[b]=a,!0}return!1},Sy:function(a){return 539===a},dK:function(a,b){return a.Ea()===b.Ea()?!0:null===a.Ea()||null===b.Ea()?!1:a.Ea().KE(b.Ea())}};var wb;wb=function(a){this.xg={};this.g=a;this.ws=null};
wb.prototype={Ej:function(a,b,c){void 0===c&&(c=null);var d=this.YK(a,c);var e=this.xg[d];if(void 0!==e)return e;e=new od(this.g,a,c,b);return this.xg[d]=e},KN:function(a){var b=[];this.vy(function(c){c.Lg()||(b.push(c),c.LN(function(){b.splice(b.indexOf(c),1);0===b.length&&setTimeout(a,0)}))})},QN:function(){var a=J.l(),b=[],c=this.g.getConfiguration(),d;if(-1!==c.NumCachedImages)if(0===c.NumCachedImages)this.xg={};else{this.vy(function(f,g){var k=f.IK;f=f.Oz?c.MaxUnusedImageAge:c.MaxUndrawnImageAge;
0!==k&&k<a-f&&b.push({path:g,time:k})});var e=Math.min(J.hQ(this.xg)-c.NumCachedImages,b.length);if(0<e)for(b.sort(function(f,g){return f.time-g.time}),d=0;d<e;++d)delete this.xg[b[d].path]}},LQ:function(a){delete this.xg[a]},VC:function(){null===this.ws&&(this.ws=this.g.getConfiguration().LoadImagesById);return this.ws},vy:function(a){var b;for(b in this.xg){var c=this.xg[b];a(c,b)}},YK:function(a,b){return null===b?a:a+":"+b}};var od;
od=function(a,b,c,d){this.g=a;this.Oz=!1;this.zg=c;this.qh=J.Fq(b);this.SL=3;this.ot(d,null);this.At();this.Sk=this.po=this.rj=null};
od.prototype={hK:function(){try{D.vF(this.Se,this.qh,this.g.getConfiguration())?this.nJ():(null===this.zg||this.Wy()||this.bN(),this.Ym(2))}catch(a){this.g.error("Unexpected exception during load image callback: "+a)}},Wy:function(){return J.Rq(this.qh)},bN:function(){try{var a=window.document.createElement("canvas"),b=a.getContext("2d"),c,d=parseInt(this.zg.substr(1,2),16),e=parseInt(this.zg.substr(3,2),16),f=parseInt(this.zg.substr(5,2),16),g=this.yJ(),k=this.rp();a.width=k.L;a.height=k.aa;b.drawImage(this.Se,
0,0);var l=b.getImageData(0,0,a.width,a.height);for(c=0;c<l.data.length;c+=4)g(l.data[c],l.data[c+1],l.data[c+2],d,e,f)&&(l.data[c+3]=0,l.data[c]=0,l.data[c+1]=0,l.data[c+2]=0);b.putImageData(l,0,0);this.rj=a;this.Se=null}catch(E){this.rj=this.zg=null,N.warn("Exception during making image "+this.qh+" transparent. Is this an SVG? As a workaround it will be rendered ignoring the transparency color")}},MK:function(a){try{if(N.warn("Loading image "+this.qh+" failed: "+a.type),0<=this.SL--){var b=this;
window.setTimeout(function(){N.info("Triing to load the image "+b.qh+" again");b.ot(!0,null)},50);this.Ym(4)}else this.Ym(3)}catch(c){this.g.error("Unexpected exception during handling of load image problems: "+c)}},qp:function(){this.At();this.Oz=!0;2!==this.fa&&N.warn("Access to not (yet) loaded image");return null!==this.rj?this.rj:this.Se},rp:function(){null===this.Sk&&(null!==this.Se?this.Sk=D.$v(this.Se):null!==this.rj&&(this.Sk=D.$v(this.rj)));return this.Sk},TQ:function(){this.Sk=null},LN:function(a){this.po=
a},Lg:function(){return 2===this.fa||3===this.fa},loaded:function(){return 2===this.fa},Ym:function(a){this.At();this.fa=a;null!==this.po&&this.Lg()&&(this.po(),this.po=null)},At:function(){this.IK=J.l()},ot:function(a,b){this.Se=new Image;var c=this;b=null===b?this.qh:b;this.Se.onload=function(){c.hK()};this.Se.onerror=function(d){c.MK(d)};this.fa=1;this.Se.src=this.dH(b,a)},dH:function(a,b){b&&(a+="?"+J.l());this.Wy()&&!this.g.getConfiguration().WorkaroundDisableSVGAspectRatioWorkaround&&(a+="#svgView(preserveAspectRatio(none))");
return a},yJ:function(){return this.g.getConfiguration().FuzzyTransparencyColorEvaluation?function(a,b,c,d,e,f){return 2>Math.abs(a-d)&&2>Math.abs(b-e)&&2>Math.abs(c-f)}:function(a,b,c,d,e,f){return a===d&&b===e&&c===f}},nJ:function(){N.l("Workaround for image "+this.qh+" without width/height activated");var a=this;D.HE(this.Se,function(b){a.ot(!1,b)},function(b){N.warn("Retrieving workaround image failed so going on as formerly, reason: "+b);a.Ym(3)})}};var vb;
vb=function(){this.Df={};this.lf=null;this.Em="<Project>"};
vb.prototype={Qh:function(a){a=a.toLowerCase().split(".");var b=[],c;for(c=0;c<a.length;++c)b[c]=J.bi(a[c]);if(1>b.length)return null;a=b[b.length-1];if(1===b.length)return this.jj(this.yn(a));c=b[b.length-2];if(2===b.length){var d=this.gJ(c);if(null!==d)return this.jj(this.Gr(a,d));d=this.Ir(c);return null!==d?(c=this.xn(a,d),null===c&&(c=this.yn(a)),this.jj(c)):this.jj(this.yn(a))}b=b.slice(0,b.length-2).join(".");d=this.Ir(b);if(null!==d&&(d=this.Hr(c,d),null!==d))return this.jj(this.Gr(a,d));
d=this.Ir(b+"."+c);return null!==d?(c=this.xn(a,d),null===c&&(c=this.yn(a)),this.jj(c)):this.Qh(c+"."+a)},mR:function(a){this.lf=a},jj:function(a){return null!==a?a.path:null},Ir:function(a){var b=this.sy(a);null===b&&(b=this.hJ(a));return b},sy:function(a){a=this.Df[a];return void 0!==a?a:null},hJ:function(a){if(null!==this.lf){a=a.toLowerCase();var b,c=null;for(b=0;b<this.lf.length;++b)if(this.lf[b].Gu===a){c=this.lf[b].hD;break}if(null!==c)for(b=0;b<this.lf.length;++b)if(this.lf[b].Gu!==a&&this.lf[b].hD===
c){var d=this.sy(this.lf[b].Gu);if(null!==d)return d}}return null},yn:function(a){var b=this.Df[this.Em],c;if(void 0!==b&&(b=this.xn(a,b),null!==b))return b;for(c in this.Df)if(c!==this.Em&&(b=this.xn(a,this.Df[c]),null!==b))return b;return null},xn:function(a,b){var c;for(c in b.Pj){var d=this.Gr(a,b.Pj[c]);if(null!==d)return d}return null},Gr:function(a,b){a=b.entries[a];return void 0===a?null:a},gJ:function(a){var b=this.Df[this.Em],c;if(void 0!==b&&(b=this.Hr(a,b),null!==b))return b;for(c in this.Df)if(b=
this.Hr(a,this.Df[c]),null!==b)return b;return null},Hr:function(a,b){a=b.Pj[a];return void 0!==a?a:null},fill:function(a){a=a.replace(/\r\n/g,"\n").split("\n");var b;for(b=0;b<a.length;++b){var c=a[b].split(";");if(!(4>c.length)){var d=this.XK(J.bi(c[1]));var e=J.bi(c[0]).toLowerCase();var f=J.bi(c[2]).toLowerCase();var g=J.bi(c[3]);c=this.Df[d];if(void 0===c){c={Pj:{}};var k=this.Lx(e);k.entries[f]=this.rr(f,g);c.Pj[e]=k;this.Df[d]=c}else k=c.Pj[e],void 0===k?(k=this.Lx(e),k.entries[f]=this.rr(f,
g),c.Pj[e]=k):k.entries[f]=this.rr(f,g)}}},XK:function(a){return null===a||""===a?this.Em:a.toLowerCase()},Lx:function(a){return{name:a,entries:{}}},rr:function(a,b){return{id:a,path:b}}};var Db;Db=function(){};Db.prototype={i:function(a){if(a.g.la){var b=a.g.ba().wa();if(null!==b&&!(b instanceof Ic)&&(b=b.ld,null!==b&&void 0!==b)){b.Hl();return}}a=a.g.ra;null!==a&&a.Hl()}};var pd;pd=function(a,b){this.m=Q.Ce(b)};pd.prototype={i:function(a){a.St();a.g.ub.cm(this.m)}};var qd;
qd=function(a,b){this.m=Q.Ce(b)};qd.prototype={i:function(a){a.getContext().clearRect(this.m.u,this.m.v,this.m.C(),this.m.B());a.g.ub.cm(this.m)}};var rd;rd=function(a,b){this.m=Q.Ce(b)};rd.prototype={i:function(a){a=a.getContext();a.save();a.beginPath();a.rect(this.m.u,this.m.v,this.m.C()+1,this.m.B()+1);a.clip()}};var sd;sd=function(){};sd.prototype={i:function(a){(a=a.g.Lo)&&a.vB()}};var td;
td=function(a,b,c,d){this.m=Q.ni(b,!1);this.uo=0!==b.getInt8();this._type=b.getInt8();switch(this._type){case 2:case 4:this.ln=b.getUint32();this.mn=b.getUint32();this.Gi=b.getUint32();break;case 1:case 3:this.Bx=b.getInt16(),this.ln=b.getUint32()}d.be()&&(this.m=d.ri(this.m))};
td.prototype={i:function(a){var b=a.getContext(),c=this.m.u,d=this.m.v,e=this.m.C(),f=this.m.B(),g=b.lineWidth;b.save();this.Do=a.g.getConfiguration().SemiTransparencyActive;a.getState().Ig()?a.getState().Vo(this.m):b.fillStyle=!0===this.Do?Q.cb(this.ln):Q.lb(this.ln);b.lineWidth=1;c+=.5;d+=.5;switch(this._type){case 2:case 4:this.vL(b,c,d,e,f);break;case 1:case 3:this.uL(b,c,d,e,f)}b.lineWidth=g;a.getState().Ig()&&a.getState().gm();b.restore()},wc:function(){return this.m},SO:function(){return!0===
this.Do?Q.cb(this.mn):Q.lb(this.mn)},JO:function(){return!0===this.Do?Q.cb(this.Gi):Q.lb(this.Gi)},vL:function(a,b,c,d,e){if(!0===this.Do){var f=this.uo?Q.cb(this.Gi):"#000000";var g=Q.cb(this.mn);var k=Q.cb(this.Gi)}else f=this.uo?Q.lb(this.Gi):"#000000",g=Q.lb(this.mn),k=Q.lb(this.Gi);this.uo?(a.strokeStyle=f,a.strokeRect(b,c,d,e),a.fillRect(b,c,d,e)):(a.fillRect(b,c,d,e),a.strokeStyle=g,a.beginPath(),a.moveTo(b,c),a.lineTo(b+d,c),a.moveTo(b,c),a.lineTo(b,c+e),a.stroke(),a.closePath(),a.strokeStyle=
f,a.beginPath(),a.moveTo(b,c+e),a.lineTo(b+d,c+e),a.lineTo(b+d,c),a.stroke(),a.closePath(),a.strokeStyle=k,a.beginPath(),a.moveTo(b+1,c+e-1),a.lineTo(b+d-2,c+e-1),a.moveTo(b+d-1,c+1),a.lineTo(b+d-1,c+e-1),a.stroke(),a.closePath())},uL:function(a,b,c,d,e){var f=new ud(this.ln,this.Bx);if(this.uo)a.strokeStyle=Q.lb(f.cC(0)),a.strokeRect(b,c,d,e),a.fillRect(b,c,d,e);else{a.strokeStyle="#000000";a.fillRect(b,c,d,e);a.strokeRect(b,c,d,e);var g;for(g=0;g<this.Bx;++g)a.beginPath(),a.moveTo(b+g,c+e-g),a.lineTo(b+
g,c+g),a.lineTo(b+d-g,c+g),a.strokeStyle=Q.lb(f.HO(g)),a.stroke(),a.beginPath(),a.moveTo(b+d-g,c+1+g),a.lineTo(b+d-g,c+e-g),a.lineTo(b+1+g,c+e-g),a.strokeStyle=Q.lb(f.cC(g)),a.stroke()}}};var Cb;
Cb=function(a,b,c,d){a=b.ga();var e=b.getUint16();var f=b.ha(e,!1);e=b.getUint16();e=b.ha(e,!1);""!==f&&(e=f+"."+e);this.xf=e;this.m=Q.ni(b,!0);this.m.normalize();d.be()&&(this.m=d.ri(this.m));f=b.getUint32();this.ls=0!==(f&1);this.Rm=0!==(f&2);this.An=0!==(f&4);this.DM=0!==(f&8);this.tx=0!==(f&16);this.qj=0!==(f&32);this.Rr=0!==(f&128);this.et=0!==(f&256);this.Dt=0!==(f&1024);this.gr=0!==(f&2048);this.Dh=0!==(f&4096);this.Gk=!1;this.mA=this.m;this.zg=Q.lb(b.getUint32());c>=b.ga()-a+16&&(this.Gk=
!0,this.tn=b.getFloat32(),this.un=b.getFloat32(),d.be()&&(this.tn=d.Co,this.un=d.mj));this.Ha=null};
Cb.prototype={i:function(a){a=a.getContext();var b=Q.uF(this.m),c=this.m.clone(),d=this;this.BM(a,c,b);null!==this.Ha&&(this.Ha.loaded()?this.Ck(a,this.Ha.qp(),function(){return d.Ha.rp()},c,!1):this.DI(a,this.m));this.DM&&(c=Q.xq(a),a.strokeRect(this.m.u+c,this.m.v+c,this.m.C(),this.m.B()));this.EH(a,b)},aS:function(a){this.xf=a},DC:function(a,b){var c;this.Dh&&null!==(c=b.Qh(this.xf))&&a.LQ(c);if(null===this.Ha){if(a.VC())return b="ImageByImagePoolId?id="+this.xf,this.Ha=this.qj?a.Ej(b,this.Dh,
this.zg):a.Ej(b,this.Dh),this.Ha.Lg();c=b.Qh(this.xf);if(null!==c)return this.Ha=this.qj?a.Ej(c,this.Dh,this.zg):a.Ej(c,this.Dh),this.Ha.Lg();-1===this.xf.indexOf("VisuUserManagement.__VisualizationStyle.")&&N.warn("Imagepoolentry for "+this.xf+" not found");return!0}return this.Ha.Lg()},Nv:function(){var a=this,b=this.m.clone();null!==this.Ha&&(this.Ck(null,this.Ha.qp(),function(){return a.Ha.rp()},b,!0),this.Ha.TQ());return this.mA},Ck:function(a,b,c,d,e){if(this.An&&this.Gk){var f=c();f=new Ja(Math.round(this.tn*
f.L),Math.round(this.un*f.aa));d=J.Bq(d,f,this);this.An=!1;this.Rm=!0}if(this.Rm)e||a.drawImage(b,d.u,d.v,d.C(),d.B());else if(this.ls){f=c();d.C()/f.L<d.B()/f.aa?(c=Math.round(d.C()*f.aa/f.L),f=d.C()):(c=d.B(),f=Math.round(d.B()*f.L/f.aa));var g=new Bb(d.u,d.v,d.u+f,d.v+c);d=J.lB(g,d,this);e||a.drawImage(b,d.u,d.v,f,c)}else e||a.drawImage(b,d.u,d.v);this.mA=d},BM:function(a,b,c){c&&(a.save(),b.Bd.Wo(a,b));this.tx&&(a.save(),a.beginPath(),a.rect(b.u,b.v,b.C()+1,b.B()+1),a.clip())},EH:function(a,b){this.tx&&
a.restore();b&&a.restore()},DI:function(a,b){b=b.FC(-3);a.save();a.fillStyle="#eeeeee";a.strokeStyle="#ff0000";a.lineWidth=3;a.fillRect(b.u,b.v,b.C(),b.B());a.beginPath();a.moveTo(b.u,b.v);a.lineTo(b.Z,b.da);a.moveTo(b.Z,b.v);a.lineTo(b.u,b.da);a.closePath();a.stroke();a.restore()}};var vd;vd=function(a,b,c,d){this.m=Q.ni(b,!0);this.FA=Q.rm(b.getInt16());this.SM=Q.rm(b.getInt16());this.cJ=1===b.getInt16();d.be()&&(this.m=d.ri(this.m))};
vd.prototype={i:function(a){var b=a.getContext(),c=this.m.C(),d=this.m.B(),e=!a.getState().uu(),f=!a.getState().Yi,g=Math.min(c,d)/2;0>=c||0>=d||(b.save(),this.SG(b),a.getState().Ig()&&a.getState().Vo(this.KJ(g)),b.beginPath(),b.arc(0,0,g,this.FA,this.FA+this.SM,!1),this.cJ&&(b.lineTo(0,0),b.closePath(),e&&b.fill()),b.restore(),f&&b.stroke(),a.getState().Ig()&&a.getState().gm())},KJ:function(a){return new Bb(-a,-a,a,a)},SG:function(a){var b=this.m.C(),c=this.m.B();null!==this.m.Bd?this.m.Bd.Wo(a,
this.m):a.translate(this.m.u+.5,this.m.v+.5);a.translate(b/2,c/2);b>c?a.scale(b/c,1):a.scale(1,c/b)}};var wd;wd=function(a,b){this.ja=Q.lw(b)};wd.prototype={i:function(a){a=a.getContext();var b;for(b=0;b<this.ja.length;++b)a.fillRect(this.ja[b].X,this.ja[b].Y,1,1)}};var xd;xd=function(a,b,c,d){this._type=b.getUint16();2===a?this.ja=Q.lw(b):59===a&&(this.ja=Q.WF(b));d.be()&&(this.ja=d.bG(this.ja))};
xd.prototype={i:function(a){var b=a.getContext(),c=!a.getState().uu(),d=!a.getState().Yi;if(!(2>this.ja.length)){a.getState().Ig()&&a.getState().Vo(this.QM());d&&this.FL(b);switch(this._type){case 0:this.EI(b,c,d);break;case 1:d&&this.FI(b);break;case 2:d&&this.zI(b)}a.getState().Ig()&&a.getState().gm()}},FL:function(a){a=Q.xq(a);var b;if(0!==a)for(b=0;b<this.ja.length;++b)this.ja[b].X+=a,this.ja[b].Y+=a},EI:function(a,b,c){a.beginPath();a.moveTo(this.ja[0].X,this.ja[0].Y);for(var d=1;d<this.ja.length;++d)a.lineTo(this.ja[d].X,
this.ja[d].Y);a.closePath();b&&a.fill();c&&a.stroke()},FI:function(a){var b;a.beginPath();a.moveTo(this.ja[0].X,this.ja[0].Y);for(b=1;b<this.ja.length;++b)a.lineTo(this.ja[b].X,this.ja[b].Y);a.stroke()},zI:function(a){a.beginPath();a.moveTo(this.ja[0].X,this.ja[0].Y);for(var b=1;b+3<=this.ja.length;)a.bezierCurveTo(this.ja[b].X,this.ja[b].Y,this.ja[b+1].X,this.ja[b+1].Y,this.ja[b+2].X,this.ja[b+2].Y),b+=3;for(;b<this.ja.length;++b)a.lineTo(this.ja[b].X,this.ja[b].Y);a.stroke()},QM:function(){var a=
1E9,b=-1E9,c=1E9,d=-1E9,e;for(e=0;e<this.ja.length;++e)this.ja[e].X<a&&(a=this.ja[e].X),this.ja[e].Y<c&&(c=this.ja[e].Y),this.ja[e].X>b&&(b=this.ja[e].X),this.ja[e].Y>d&&(d=this.ja[e].Y);return new Bb(a,c,b,d)}};var yd;yd=function(a,b,c,d){this._type=b.getUint16();switch(a){case 1:this.m=Q.ni(b,!0);break;case 45:this.m=Q.Ce(b);break;case 60:this.m=Q.PF(b);break;case 61:this.m=Q.OF(b)}d.be()&&(this.m=d.ri(this.m));this.Ok=!1;this.kN=new zd(this._type,this.m)};
yd.prototype={i:function(a){this.Ok||(this.kN.xj(a),a.g.ub.TN())},wc:function(){return this.m},cv:function(a){this.Ok=a}};var Ad;Ad=function(a,b){this._type=b.getUint16();a=b.getUint16();var c=b.getUint16();this.nj=new Ja(a,c);a=b.getUint16();c=b.getUint16();this.mt=new Ja(a,c);b=b.getUint32();this.hN=0!==(b&1);this.iN=0!==(b&2);this.Ct=0!==(b&4)};
Ad.prototype={i:function(a){var b=a.getState().Ws;var c=new I(b.X+this.mt.L,b.Y+this.mt.aa);if(this.Ct){var d=a.getState().Rs;var e=c.X;c.X=d.X+this.mt.L;d=e-c.X}else d=this.nj.L;c=new Bb(c.X,c.Y,c.X+d,c.Y+this.nj.aa);(new zd(this._type,c)).xj(a);this.hN&&(b.X+=this.nj.L);this.iN&&(b.Y+=this.nj.aa)}};var zd;zd=function(a,b){this._type=a;this.m=b.YP()};
zd.prototype={AI:function(a,b,c,d,e,f,g){a.beginPath();if("function"===typeof a.ellipse){var k=d/2;e/=2;a.ellipse(b+k,c+e,k,e,0,0,2*Math.PI)}else{k=d/2*.5522848;var l=e/2*.5522848,E=b+d,u=c+e;d=b+d/2;e=c+e/2;a.moveTo(b,e);a.bezierCurveTo(b,e-l,d-k,c,d,c);a.bezierCurveTo(d+k,c,E,e-l,E,e);a.bezierCurveTo(E,e+l,d+k,u,d,u);a.bezierCurveTo(d-k,u,b,e+l,b,e);a.closePath()}f&&a.fill();g&&a.stroke()},GI:function(a,b,c,d,e,f,g){f&&a.fillRect(b,c,d,e);g&&a.strokeRect(b,c,d,e)},CI:function(a,b,c,d,e){a.beginPath();
a.moveTo(b,c+e);a.lineTo(b+d,c);a.stroke()},xj:function(a){this.Eg=a.getContext();this.Qg=a;this.x=this.m.u;this.y=this.m.v;this.w=this.m.C();this.Hc=this.m.B();this.radiusX=a.getState().Ly;this.radiusY=a.getState().My;this.fill=!a.getState().uu();this.stroke=!a.getState().Yi;this.gD=this.m.Bd;0>this.w||0>this.Hc||(this.Qg.getState().Ig()&&this.Qg.getState().Vo(this.m),this.tI())},tI:function(){var a=this.Eg,b=this.x,c=this.y,d=this.w,e=this.Hc,f=this.radiusX,g=this.radiusY,k=this.fill,l=this.stroke,
E=this.gD;null!==E&&(a.save(),this.m.Bd.Wo(a,this.m));if(this.stroke&&null===this.gD){var u=Q.xq(a);b+=u;c+=u}switch(this._type){case 0:this.GI(a,b,c,d,e,k,l);break;case 1:Q.IE(a,b,c,d,e,k,l,f,g);break;case 2:this.AI(a,b,c,d,e,k,l);break;case 3:l&&this.CI(a,b,c,d,e);break;case 4:l&&(a.beginPath(),a.moveTo(b,c),a.lineTo(b+d,c+e),a.stroke())}null!==E&&a.restore();this.Qg.getState().Ig()&&this.Qg.getState().gm()}};var Cd;
Cd=function(a,b,c,d){if(3===a||11===a)var e=Q.jw(b);else if(46===a||47===a)e=Q.RF(b);c=b.getUint32();this.fc=this.bK(c);this.Mb=this.mN(c);this.$w=0!==(c&16);this.hH=0!==(c&32);this.RL=0!==(c&64);this.iM=0!==(c&1024);this.Ct=0!==(c&2048);this.Io=0!==(c&256);this.Al=0!==(c&512);this.m=Q.Lv(e,0!==(c&128));d.be()&&(this.m=d.ri(this.m));d=b.getUint16();this.na=b.ha(d,11===a||47===a);this.ej=Q.uq(this.na);this.tt=Q.fw(this.na);this.Lf=this.na;this.Ok=!1};
Cd.prototype={i:function(a){if(!this.Ok){this.Qg=a;this.Eg=a.getContext();this.state=a.getState();if(this.RL){var b=this.state.Ws;if(this.Ct){b=this.state.Rs;var c=b.X;b=b.Y}else c=b.X,b=b.Y;a.be()&&(c=a.Hm(c),b=a.Im(b));this.m=new Bb(c,b,c+this.m.C(),b+this.m.B())}this.uI()}},Rb:function(a){this.na=a;this.ej=Q.uq(this.na);this.tt=Q.fw(this.na);this.Lf=this.na},wc:function(){return this.m},mu:function(){switch(this.fc){case 1:return"LEFT";case 2:return"RIGHT";default:return"HCENTER"}},ru:function(){switch(this.Mb){case 1:return"TOP";
case 2:return"BOTTOM";default:return"VCENTER"}},cv:function(a){this.Ok=a},uI:function(){var a=this.Eg,b=this.state,c=this.Qg;a.save();null!==this.m.Bd&&this.m.Bd.Wo(a,this.m);a.beginPath();a.rect(this.m.u-.5,this.m.v-.5,this.m.C()+1,this.m.B()+1);a.clip();a.fillStyle=b.MA;a.font=b.Dj();var d=!1;var e=b.Qi;var f=a.font;!c.g.hi&&(this.KG(a,c),!0===c.g.getConfiguration().AutoFontReductionActive&&this.Al||!1===c.g.getConfiguration().AutoFontReductionActive&&(this.Io||this.Al))&&(d=this.WL(a,c));!1===
d&&(this.ej?this.Ys(a,c):this.pA(a));if(this.hH){d=b.Ws;var g=b.Rs;d.X=this.m.u;d.Y=this.m.v;this.iM&&(g.X=d.X+1,g.Y=d.Y);d.X=this.m.u+this.VM(a)}c.g.hi||!0!==c.g.getConfiguration().AutoFontReductionActive||!1!==this.Al||(b.HD(e),b.Ug(f));a.restore()},KG:function(a,b){var c=b.getState(),d,e;if(!0===b.g.getConfiguration().AutoFontReductionActive&&!this.Al){var f=a.font;var g=c.Qi;var k=this.m.C()+1;var l=this.m.B()+1;for(d=!0;(k>this.m.C()||l>this.m.B())&&1<g;){d||(--g,c.HD(g),c.Ug(J.FP(f,g)),a.font=
c.Dj());this.Lf=this.na;this.Io&&(this.qA(a,b,!0,this.Lf,!0),this.ej=Q.uq(this.Lf));if(this.ej)if(l=Q.Jm(this.Lf),k=0,0<l.length){for(e=0;e<l.length;++e)d=a.measureText(l[e]).width,k<d&&(k=d);l=J.Sb(b)*l.length}else k=a.measureText(this.Lf).width,l=J.Sb(b);else k=a.measureText(this.Lf).width,l=J.Sb(b);d=!1}this.na=this.Lf}},pA:function(a){this.tt?this.UL(a):this.kn(a,this.na,this.Xq(a))},Ys:function(a,b){var c=Q.Jm(this.na),d=this,e;if(0<c.length){var f=J.Sb(b);var g=f*c.length;g-=J.sQ(b);this.IG(a,
g);b=this.NG(a,g);var k=function(E){d.kn(a,E.text,l)};for(e=0;e<c.length;++e){if(this.tt){g=Q.Kq(a,c[e]);var l=this.Vw(a,g);l.Y=b.Y;this.dz(g,l,k)}else this.kn(a,c[e],b);b.Y+=f}}},WL:function(a,b){var c;this.Io?c=this.qA(a,b,!1,this.na,!1):this.Al&&(c=this.VL(a,b));return c},qA:function(a,b,c,d,e){var f=!1;var g=this.m.Z-this.m.u;this.vt(a,d)>g&&(f=!0,d=this.oN(a,d,g,e),!1===c?(this.na=d,this.Ys(a,b)):this.Lf=d);return f},oN:function(a,b,c,d){var e=!1,f="",g=!1,k=1;do{if(1===b.length)break;for(;this.vt(a,
b.slice(0,k))<c;)if(k++,k===b.length){e=!0;break}1===k&&k++;if(!e){g=!1;for(var l=k-1;0<l;l--)if(this.DK(b.charAt(l))){f+=[b.slice(0,l),"\n"].join("");b=b.slice(l+1);g=!0;break}g||(d?e=!0:(f+=[b.slice(0,k-1),"\n"].join(""),b=b.slice(k-1)));k=1}}while(!e);return!g&&d?this.na:[f,b].join("")},DK:function(a){return(new RegExp(/^\s$/)).test(a.charAt(0))},VL:function(a,b){this.$w=!0;this.ej?this.Ys(a,b):this.pA(a,b);return!0},UL:function(a){var b=Q.Kq(a,this.na),c=this.Vw(a,b),d=this;this.dz(b,c,function(e){d.kn(a,
e.text,c)})},dz:function(a,b,c){var d;if(2===this.fc)for(d=a.length-1;0<=d;--d)c(a[d]),b.X-=a[d].Av*Q.ti;else for(d=0;d<a.length;++d)c(a[d]),b.X+=a[d].Av*Q.ti},kn:function(a,b,c){this.$w&&(b=this.oJ(a,b));a.fillText(b,c.X,c.Y)},oJ:function(a,b){if(Q.Xg(a,b,!1)<=this.m.C())return b;for(var c,d=0,e=b.length-1,f,g;1<e-d;){f=Math.floor((d+e)/2);c=b.substr(0,f)+"...";g=Q.Xg(a,c,!1)-this.m.C();if(0===g)return c;0>g?(d=f,g=!1):(e=f,g=!0)}return!0===g?0<f?c.substr(0,f-1)+"...":"":c},NG:function(a,b){var c=
this.Xq(a);a.textBaseline="top";3===this.Mb?c=new I(c.X,this.m.v+this.m.B()/2-b/2):2===this.Mb&&(c=new I(c.X,c.Y-b));return c},IG:function(a,b){this.Io&&3===this.Mb&&this.m.B()<b&&(this.Mb=1)},Xq:function(a){if(1===this.fc){var b=this.m.u+1;a.textAlign="left"}else 3===this.fc?(b=this.m.u+this.m.C()/2,a.textAlign="center"):(b=this.m.Z-1,a.textAlign="right");if(1===this.Mb){var c=this.m.v+2;a.textBaseline="top"}else 3===this.Mb?(c=this.m.v+this.m.B()/2,a.textBaseline="middle"):(c=this.m.da-1,a.textBaseline=
"bottom");return new I(b,c)},Vw:function(a,b){a=this.Xq(a);var c,d=0;if(3===this.fc){for(c=0;c<b.length;++c)d+=b[c].Av*Q.ti;a.X=this.m.u+(this.m.C()-d+Q.ti)/2}return a},bK:function(a){var b=1;0!==(a&1)?b=3:0!==(a&2)&&(b=2);return b},mN:function(a){var b=1;0!==(a&4)?b=3:0!==(a&8)&&(b=2);return b},VM:function(a){return this.vt(a,this.na)},vt:function(a,b){if(this.ej){var c=0;b=Q.Jm(b);var d;for(d=0;d<b.length;++d)c=Math.max(c,Q.Xg(a,b[d],!0));return c}return Q.Xg(a,b,!0)}};var Ib;
(function(){var a=null;Ib=function(b,c){var d=c.getUint16();this.na=c.ha(d,15===b);this.s=Q.oi(c);this.Iz=1===(c.getUint32()&1)};Ib.prototype={i:function(b){var c=b.getContext(),d=b.g.Lo,e=Q.Jm(this.na);b.g.getConfiguration().uC();var f=d.pj;var g=this.MJ(b,f);var k=this.iH(c,g,e);var l=k.size;var E=new Ja(2*f.Yj+6,2*f.Yj+4);var u=this.jH(b.Qf(),l,E,b);b.g.la?(this.na=this.na.replace(/(?:\r\n|\r|\n)/g,"<br>"),this.Iz?d.gQ(u.u,u.v,this.na,g.oq):d.ON(this.na,l,document.getElementById("background").width,
document.getElementById("background").height)):(c.save(),this.BI(c,f,u,g,E,e,k.lineHeight),this.Iz&&(a=new Bb(0,0,0,0)),null!==a&&u.ip(a)||this.rM(b.g,u),a=u,c.restore())},rM:function(b,c){var d=new Ba(513,b.A.ma,0,0),e=Ga.F(8),f=Cc.F(e,!0);f.Gc(Math.floor(c.u));f.Gc(Math.floor(c.v));f.Gc(Math.ceil(c.Z));f.Gc(Math.ceil(c.da));d.Qb(e);b.yb.push(d)},iH:function(b,c,d){var e=new Ja(0,0),f=b.font,g,k=0;b.font=c.oq;for(g=0;g<d.length;++g){0===g&&(k=J.Vf(c.NE)+2);var l=Q.Xg(b,d[g],!1);e.L=Math.max(e.L,
l);e.aa+=k}e.aa=Math.ceil(e.aa);e.L=Math.ceil(e.L);b.font=f;return{size:e,lineHeight:k}},jH:function(b,c,d,e){var f;if(e.g.la){var g=document.getElementById("background").height;var k=document.getElementById("background").width;e=e.g.ba().wa().S;e=J.$j(e,J.bb());k<20+c.L+e.X+this.s.X?f=e.X+this.s.X-20-d.L-c.L:f=e.X+this.s.X+20;g=g<20+c.aa+e.Y+this.s.Y?e.Y+this.s.Y-c.aa+20+d.L:e.Y+this.s.Y+20}else this.s.X+20+d.L+c.L>=b.C()?f=this.s.X-20-d.L-c.L:f=this.s.X+20,this.s.Y+20+c.aa>=b.B()?g=this.s.Y-20-
c.aa:g=this.s.Y+20;0>f&&(f=c.L<b.C()?(b.C()-c.L)/2:0);0>g&&(g=c.aa<b.B()?(b.B()-c.aa)/2:0);return new Bb(f,g,f+c.L+d.L,g+d.aa+c.aa)},BI:function(b,c,d,e,f,g,k){var l=c.Yj/2;b.fillStyle=c.Tv;b.fillRect(d.u,d.v,d.C(),d.B());b.lineWidth=c.Yj;b.strokeStyle=c.Bv;l=new Bb(d.u+l,d.v+l,d.Z-l,d.da-l);b.strokeRect(l.u,l.v,l.C(),l.B());b.font=e.oq;b.textBaseline="top";b.textAlign="left";b.fillStyle=c.Vv;c=new I(d.u+f.L/2,d.v+f.aa/2);for(d=0;d<g.length;++d)b.fillText(g[d],c.X,c.Y),c=new I(c.X,c.Y+k)},MJ:function(b,
c){b=b.g.getConfiguration().uC();return""===b||void 0===b||null===b?c.Font:b}}})();var Dd;Dd=function(){};Dd.prototype={i:function(){}};var Ed;Ed=function(a,b){a=b.getUint16();this.IH=0===a||2===a};Ed.prototype={i:function(a){this.IH&&a.g.le.close();a.g.le.RQ()}};var Fd;Fd=function(a,b,c){var d=b.ga();this.JH=b.getUint16();a=b.getUint16();this.zx=b.ha(a,!1);c>=b.ga()-d+10?(a=b.getUint16(),this.Ax=b.ha(a,!1)):this.Ax=""};
Fd.prototype={i:function(){switch(this.JH){case 0:N.warn("The functionality start process is not possible in the webvisualization.");break;case 1:case 2:case 3:N.warn("The functionality printing is not possible in the webvisualization.");break;case 4:this.TK()}},TK:function(){"replace"===this.Ax?window.location.href=this.zx:window.open(this.zx)}};var Gd;Gd=function(a,b){this.Ak=b.getUint8();this.Ak=0===this.Ak?2:3;this.vn=new Hd(b)};
Gd.prototype={i:function(a){var b=new Id(0,this.Ak,this.vn.sh,null,this.vn);a.g.Tj(b)}};var Jd;Jd=function(a,b,c,d){a=d.g.j;c=0;this.Mc=b.getUint32();d=b.getUint16();this.Et=b.ha(d,!1);d=b.getUint32();null===a.buffer&&(a.buffer=Ga.F(d));for(;c<d;)a.buffer.Ro(b.getUint8()),c++;a.status.zd+=d;0!==(this.Mc&1)&&(a.status.Wd?(a.status.Wd=!1,a.status.xe=!0):a.status.we=!0);0===d&&(a.status.we=!0)};Jd.prototype={i:function(){}};var Kd;
Kd=function(a,b){this.XL=b.getUint16();this.Ak=b.getUint8();a=b.getUint16();this.Ps=b.ha(a,!1);a=b.getUint16();0<a?this.Et=b.ha(a,!1):this.Et="";this.vn=new Hd(b)};Kd.prototype={i:function(a){var b=new Id(this.XL,this.Ak,this.Ps,this.Et,this.vn);a.g.Tj(b)}};var Ld;Ld=function(a,b){this.m=Q.ni(b,!1)};Ld.prototype={i:function(){},wc:function(){return this.m}};var Md;
Md=function(a,b,c,d){this.Uq=b.getUint16();a=b.getUint16();this.Ps=b.ha(a,!1);a=b.getUint16();this.sh=b.ha(a,!1);this.Hk=b.getUint16();this.Ik=[];for(c=0;c<this.Hk;++c)a=b.getUint16(),this.Ik[c]=b.ha(a,!1);this.pb=b.getUint32();this.ds=b.getUint8();b=new Nd(!1,this.Uq,this.Ps,this.sh,this.Hk,this.Ik,this.pb,this.ds);d.g.Ni.mw(b)};Md.prototype={i:function(){}};var Od;
Od=function(a,b,c,d){this.Uq=b.getUint16();a=b.getUint16();this.sh=b.ha(a,!1);this.Hk=b.getUint16();this.Ik=[];for(c=0;c<this.Hk;++c)a=b.getUint16(),this.Ik[c]=b.ha(a,!1);this.pb=b.getUint32();this.ds=b.getUint8();b=new Nd(!0,this.Uq,"",this.sh,this.Hk,this.Ik,this.pb,this.ds);d.g.Ni.mw(b)};Od.prototype={i:function(){}};var Hb;Hb=function(a,b,c){a=b.ga();this.m=Q.Ce(b);this.lr=!0;c>=b.ga()-a+12&&(this.lr=0===(b.getUint32()&1))};
Hb.prototype={i:function(a){a.Cn.Kt(this.m);this.lr&&(a.Gg().clearRect(this.m.u,this.m.v,this.m.C(),this.m.B()),J.LP(a,this.m));a.g.ub.cm(this.m)}};var Pd;
Pd=function(a,b){var c;this.ay=b.getUint32();this.MI=b.getUint32();a=b.getUint16();this.Dz=b.ha(a,!1);a=b.getUint32();var d=b.getUint16();this.Ld=[];this.Xz=!1;try{for(c=0;c<d;++c){var e=b.getUint32();var f=b.getUint32();this.Ld.push(this.yo(b,e,f))}}catch(g){if(g instanceof TypeError)N.error("Invalid argumenttype for calling '"+this.Dz+"'; call will not be executed"),this.Xz=!0;else throw g;}2===(a&2)?(this.ul=b.getUint32(),this.dt=b.getUint32()):this.dt=this.ul=null};
Pd.prototype={i:function(a){if(!this.Xz){var b=WebvisuExtensionMgr.aO(this.ay,this.Dz,this.Ld);null!==b&&void 0!==b&&null!==this.dt&&null!==this.ul&&this.SI(b,a.g)}},yo:function(a,b,c){var d=new Qd;a=d.BB(a,c);return d.mD(b,a)},SI:function(a,b){var c=Ga.F(this.dt),d=Cc.F(c,b.A.Ia,b.getConfiguration().wd()),e=new Ba(515,b.A.ma,this.ay,this.MI);try{this.TI(a,d),e.Qb(c)}catch(f){N.error("Failed to encode return value: "+a.toString()+". Result ignored")}b.ud(e)},TI:function(a,b){switch(this.ul){case 0:case 1:b.Ua(a?
1:0);break;case 2:case 10:b.Ua(a);break;case 6:b.gB(a);break;case 3:case 11:b.Nb(a);break;case 7:b.Gc(a);break;case 8:b.Vd(a);break;case 9:throw new TypeError("Type LINT not supported");case 4:case 12:b.K(a);break;case 5:case 13:throw new TypeError("Type LWORD/ULINT not supported");case 14:b.To(a);break;case 15:b.Mt(a);break;case 16:case 17:a=b.jb(a,17===this.ul);b.jc(a);break;case 18:case 19:case 20:case 21:b.K(a);break;default:throw new TypeError("TypeCode + "+this.ul.toString()+" not supported");
}}};var Rd;Rd=function(a,b){this.ke=b.getUint32();a=b.getUint16();this.Gx=b.ha(a,!1);this.ne=Q.Ce(b)};
Rd.prototype={i:function(a){var b=WebvisuExtensionMgr.lT(this.Gx);if(null===b)N.warn("No native control named '"+this.Gx+"' found");else{if(a.g.la){var c=a.g.ba().wa();var d=c.S;"function"===typeof c.MD&&c.MD(this.ke);this.ne=new Bb(0,0,this.ne.Z,this.ne.da,this.ne.Bd)}else d=a.Rl().canvas;WebvisuExtensionMgr.dO(b,this.ke,this.ne,d);a.g.la&&(void 0!==d.Sv?(a=d.Sv,a.style.position="absolute",a.style.width="100%",a.style.height="100%"):2==d.childNodes.length&&(a=d.childNodes[1],a.style.position="absolute",
a.style.width="100%",a.style.height="100%"))}}};var Sd;Sd=function(a,b){this.ke=b.getUint32();this.ne=Q.Ce(b)};Sd.prototype={i:function(){WebvisuExtensionMgr.bO(this.ke,this.ne)}};var Td;Td=function(a,b){this.ke=b.getUint32();a=b.getUint32();this.CM=1===(a&1);this.mI=4===(a&4)};Td.prototype={i:function(){this.mI?WebvisuExtensionMgr.du(this.ke):WebvisuExtensionMgr.cO(this.ke,this.CM)}};var Ud;
Ud=function(a,b){var c;b.getUint16();b.getUint16();this.pa=Q.Ce(b);var d=b.getUint32();this.uh=0!==(d&1);this.hh=0!==(d&2);this.Oc=b.getUint16();var e=b.getUint16();this.Pc=b.ha(e,!1);this.Qm=b.getUint16();var f=b.getUint16();e=Ga.F(f);d=Cc.F(e,!0);for(c=0;c<f;++c)d.Ua(b.getUint8());this.rk=this.Md=!1;25===a&&(d=b.getUint16(),this.Md=0!==(d&1),this.rk=2===(d&2));a=f;0<a?(this.rk&&(a/=2),b=Nb.F(e.Zd(),b.Ij(),b.Vj()),this.On=b.ha(a,this.rk)):this.On=""};
Ud.prototype={i:function(a){null!==a.g.qc&&a.g.qc.Hq();var b=window.document.createElement("input"),c=window.document.createElement("form"),d=this.ih(),e=a.Aj();b.value=this.On;b.id="editcontrol-input";d=d.Pb(e.X,e.Y);J.ab(b,d);b.style.zIndex=300;b.style.textAlign=0!==(this.Qm&1)?"center":0!==(this.Qm&2)?"right":"left";b.style.fontFamily=this.Pc;b.style.fontSize=this.Oc+"px";this.uh&&(b.style.fontStyle="italic");this.hh&&(b.style.fontWeight="bold");this.Md?(d=window.document.createElement("input"),
d.type="text",d.autocomplete="username",d.style.display="none",b.type="password",b.autocomplete="current-password",c.id="editcontrol-inputform",c.appendChild(d),c.appendChild(b),a.g.le.open(c,this.rk,a)):a.g.le.open(b,this.rk,a);b.select()},ih:function(){var a=this.pa.u+3,b=this.pa.Z-9,c,d=J.Vf(this.Oc);0!==(this.Qm&8)?c=this.pa.da-d-9:c=0!==(this.Qm&4)?this.pa.v+(this.pa.B()-d)/2:this.pa.v+1;return new Bb(a,c,b,c+d)}};var Pb;
(function(){var a=null,b=null;Pb=function(){};Pb.pE=function(c,d,e,f){null===a&&(a=[Dd,yd,xd,Cd,Vd,Wd,Xd,Hb,rd,Yd,Ud,Cd,Ed,Dd,Ib,Ib,sd,Fd,Zd,Cb,$d,ae,ae,td,be,Ud,Rd,Pd,Sd,Td,ce,Ad,de,ee,ee,fe,vd,ge,Dd,Dd,Dd,Db,he,ie,wd,yd,Cd,Cd,ce,je,ke,le,le,me,ne,oe,pe,qe,re,xd,yd,yd,Dd,Dd,Dd,Dd,se,Kd,Gd,Jd,Dd,te,ue,ve,we,xe,ye,ze,Ae,Be,Ce,De,Ee,Fe,Dd,Ge,He,Ie,Je,Ke,Le,Me,Ne,qd,Oe,Dd,Pe,Dd,Qe,Re,Se,Te,Ue,Ve,We,pd,Xe,Ye,Ze,$e,af,bf,cf,df,Md,Od,Ld,ef,ff,Dd,gf,hf,jf,kf,lf]);null===b&&(b=[Kb,Lb,Jb,Mb]);return c<a.length?
new a[c](c,d,e,f):8192<=c&&9215>=c&&c-8192<b.length?new b[c-8192](c,d,e,f):new Dd(c,d,e,f)}})();var Q;
(function(){var a="0123456789ABCDEF".split("");var b=function(d){return a[d>>4&15]+a[d&15]};var c=function(d){return d&255};Q=function(){};Q.ti=50;Q.Mv=0;Q.om=1;Q.Zj=2;Q.nm=3;Q.oi=function(d){var e=d.getInt16();d=d.getInt16();return new I(e,d)};Q.Eq=function(d){var e=d.getFloat32();d=d.getFloat32();return new I(e,d)};Q.Rw=function(d,e){var f=[],g;for(g=0;4>g;++g)f[g]=e(d);return f};Q.jw=function(d){return Q.Rw(d,Q.oi)};Q.QF=function(d){return Q.Rw(d,Q.Eq)};Q.RF=function(d){var e=[];e[0]=Q.oi(d);e[2]=
Q.oi(d);e[1]=new I(e[2].X,e[0].Y);e[3]=new I(e[0].X,e[2].Y);return e};Q.KF=function(d){return d[1].Y!==d[0].Y||d[2].X!==d[1].X||d[3].Y<d[0].Y||d[2].X<d[1].X};Q.Lv=function(d,e){if(e&&Q.KF(d)){e=Math.sqrt((d[0].X-d[1].X)*(d[0].X-d[1].X)+(d[0].Y-d[1].Y)*(d[0].Y-d[1].Y));var f=Math.sqrt((d[0].X-d[3].X)*(d[0].X-d[3].X)+(d[0].Y-d[3].Y)*(d[0].Y-d[3].Y));return new Bb(0,0,e,f,mf.h((d[1].X-d[0].X)/e,(d[1].Y-d[0].Y)/e,(d[3].X-d[0].X)/f,(d[3].Y-d[0].Y)/f,d[0].X,d[0].Y))}return new Bb(d[0].X,d[0].Y,d[2].X,d[2].Y)};
Q.Qw=function(d,e,f){d=f(d);return Q.Lv(d,e)};Q.ni=function(d,e){return Q.Qw(d,e,Q.jw)};Q.PF=function(d){return Q.Qw(d,!0,Q.QF)};Q.Pw=function(d,e){var f=e(d);d=e(d);return new Bb(f.X,f.Y,d.X,d.Y)};Q.Ce=function(d){return Q.Pw(d,Q.oi)};Q.OF=function(d){return Q.Pw(d,Q.Eq)};Q.Sw=function(d,e){var f=d.getUint16(),g;var k=Array(f);for(g=0;g<f;++g)k[g]=e(d);return k};Q.lw=function(d){return Q.Sw(d,Q.oi)};Q.WF=function(d){return Q.Sw(d,Q.Eq)};Q.bw=function(d){var e=[];0!==(d&1)&&e.push("italic");0!==(d&
2)&&e.push("bold");0!==(d&16)&&e.push("lighter");0!==(d&32)&&e.push("500");0!==(d&64)&&e.push("900");return e.join(" ")};Q.kw=function(d,e){return Q.TF(d,e.g.getConfiguration().SemiTransparencyActive,e.be(),e.mj)};Q.TF=function(d,e,f,g){var k=!0===e?Q.cb(d.getUint32()):Q.lb(d.getUint32());e=Q.bw(d.getUint32());var l=d.getUint16();var E=d.getUint16();d=d.ha(E,!1);f&&(f=l*g,1.01<g&&(f*=.95),l=Math.round(f));return new nf(e+" "+l+'px "'+d+'"',d,l,e,k)};Q.UF=function(d,e){return Q.VF(d,e.g.getConfiguration().SemiTransparencyActive,
e.be(),e.mj)};Q.VF=function(d,e,f,g){var k;var l=!0===e?Q.cb(d.getUint32()):Q.lb(d.getUint32());e=Q.bw(d.getUint32());var E=d.getUint16();var u=d.getUint16();var ka=[];for(k=0;k<u;k++){var ja=d.getUint16();ka.push(d.ha(ja,!1))}f&&(d=E*g,1.01<g&&(d*=.95),E=Math.round(d));g=J.bQ(ka);return new nf(e+" "+E+"px "+g,g,E,e,l)};Q.rm=function(d){return Math.PI*d/180};Q.lb=function(d){return"#"+b(d>>16)+b(d>>8)+b(d)};Q.cb=function(d){var e=d>>24&255;if(255===e)return"#"+b(d>>16)+b(d>>8)+b(d);e/=255;return"rgba("+
c(d>>16)+", "+c(d>>8)+", "+c(d)+", "+e+")"};Q.xq=function(d){return 1===d.lineWidth%2?.5:0};Q.uq=function(d){return 0<=d.indexOf("\n")||0<=d.indexOf("\r")};Q.Xh=function(d,e,f){return e>d.length-1?d:d.substr(0,e)+f+d.substr(e+1)};Q.LF=function(d){var e,f;var g=d.length;var k=e=0;for(f=Q.Mv;e<g;)switch(f){case Q.Mv:switch(d[e]){case "\n":f=Q.Zj;break;case "\r":f=Q.nm;break;default:f=Q.om}break;case Q.om:switch(d[e]){case "\n":f=Q.Zj;k!==e&&(d=Q.Xh(d,k,d[e]));k++;break;case "\r":f=Q.nm;break;default:k!==
e&&(d=Q.Xh(d,k,d[e])),k++}e++;break;case Q.Zj:switch(d[e]){case "\n":k!==e&&(d=Q.Xh(d,k,d[e]));k++;break;case "\r":f=Q.nm;break;default:f=Q.om,k!==e&&(d=Q.Xh(d,k,d[e])),k++}e++;break;case Q.nm:d=Q.Xh(d,k,"\n");k++;switch(d[e]){case "\n":f=Q.Zj;break;case "\r":d=Q.Xh(d,k,"\n");k++;f=Q.Zj;break;default:k!==e&&(d=Q.Xh(d,k,d[e])),k++,f=Q.om}e++}return d.substring(0,k)};Q.Jm=function(d){return Q.LF(d).split("\n")};Q.fw=function(d){return 0<=d.indexOf("\t")};Q.eG=function(d){return d.split("\t")};Q.Xg=
function(d,e,f){if(f){d=Q.Kq(d,e);for(e=f=0;e<d.length;++e)f+=d[e].BT;return f}return d.measureText(e).width};Q.yF=function(d,e,f,g){var k=d.getContext(),l=Q.Xg(k,e,!0);if(void 0!==f&&void 0!==g&&l>f&&0!==(g&256)){var E=1,u=0,ka=0,ja=0,va=-1;for(g=0;g<e.length;++g){l=e.charAt(g);var Xa=e.charAt(g+1);"\r"===l&&"\n"===Xa?(++E,ka=Math.max(u,ka),u=0):(Xa=k.measureText(l).width,u+Xa<=f||0>=va?(u+=Xa," "===l&&(ja=u,va=g)):(++E,ka=Math.max(u,ja),u=u-ja+Xa))}ka=Math.max(u,ka);return new I(ka,E*J.Sb(d))}return new I(l,
J.Sb(d))};Q.Kq=function(d,e){e=Q.eG(e);var f=[],g;for(g=0;g<e.length;++g){var k=d.measureText(e[g]).width;var l=Math.max(1,Math.ceil(k/Q.ti));g<e.length-1&&(k=l*Q.ti);f.push({text:e[g],Av:l,BT:k})}return f};Q.uF=function(d){return null!==d.Bd};Q.IE=function(d,e,f,g,k,l,E,u,ka){var ja;0>u||0>ka?ja=Math.max(1,Math.min(g,k)/8):ja=u;d.beginPath();d.moveTo(e+ja,f);d.lineTo(e+g-ja,f);d.quadraticCurveTo(e+g,f,e+g,f+ja);d.lineTo(e+g,f+k-ja+.5);d.quadraticCurveTo(e+g,f+k,e+g-ja,f+k);d.lineTo(e+ja+.5,f+k);
d.quadraticCurveTo(e,f+k,e,f+k-ja+.5);d.lineTo(e,f+ja);d.quadraticCurveTo(e,f,e+ja+.5,f);d.closePath();l&&d.fill();E&&d.stroke()}})();var lf;lf=function(a,b,c,d){a=b.getUint32();!0===d.g.getConfiguration().SemiTransparencyActive?this.nb=Q.cb(a):this.nb=Q.lb(a)};lf.prototype={i:function(){J.bb().style.backgroundColor=this.nb}};var Qe;Qe=function(a,b){this.NK=b.getUint16();this.OK=b.getUint16();a=b.getUint16();this.na=b.ha(a,!1)};
Qe.prototype={i:function(){var a=J.h("Message ID: {0}   Message description: {1}",this.OK,this.na);switch(this.NK){case 0:break;case 1:N.info(a);break;case 2:N.warn(a);break;case 4:case 8:N.error(a);break;case 16:N.l(a);break;default:N.h("Unknown log level")}}};var Xe;Xe=function(a,b){this.RK=1===b.getUint16()?"copy":"source-over"};Xe.prototype={i:function(a){a.getContext().globalCompositeOperation=this.RK}};var se;
se=function(a,b){this.KA=b.getUint16();this.Bg=b.getUint32();this.qw=8;this.KA===this.qw&&this.Bg&&b.Uj("utf-8")};
se.prototype={i:function(a){switch(this.KA){case 1:a=a.g.yg;null!==a&&a.NS(this.Bg/100);break;case 2:a=a.g.yg;null!==a&&a.FR(this.Bg/100);break;case 3:a=a.g.yg;null!==a&&a.JS(!!this.Bg);break;case 4:a.g.getConfiguration().AutoFontReductionActive=!0;break;case 6:oc.prototype.bT(0!==this.Bg);break;case 7:a.g.getConfiguration().XhrSendTimeout=this.Bg;break;case this.qw:a.g.getConfiguration().Qq=!!this.Bg,this.Bg&&(a.g.getConfiguration().ANSIStringEncoding="utf-8")}}};var be;
be=function(a,b){switch(b.getUint16()){case 0:this.mc="pointer";break;case 1:this.mc="default";break;case 2:this.mc="pointer";break;case 3:this.mc="wait";break;case 4:this.mc="text";break;case 5:this.mc="crosshair";break;case 6:this.mc="help";break;case 7:this.mc="col-resize";break;case 8:this.mc="row-resize";break;case 9:this.mc="nw-resize";break;case 10:this.mc="ne-resize";break;case 11:this.mc="w-resize";break;case 12:this.mc="s-resize";break;case 13:this.mc="pointer";break;default:this.mc="default"}};
be.prototype={i:function(a){a.g.la?(a=a.g.ba().wa(),null!==a&&(a=a.S,null!==a&&(a.style.cursor=this.mc))):a.Rl().canvas.style.cursor=this.mc}};var Vd;Vd=function(a,b,c,d){a=b.getUint32();b=b.getUint32();this.Tr=1===(a&1);!0===d.g.getConfiguration().SemiTransparencyActive?this.nb=Q.cb(b):this.nb=Q.lb(b)};Vd.prototype={i:function(a){a.getState().bv(this.nb,this.Tr)},mp:function(){return this.nb}};var Xd;Xd=function(a,b,c,d){this.rd=Q.kw(b,d)};
Xd.prototype={i:function(a){a.getState().VD(this.rd.Font,this.rd.Size,this.rd.Color)},Nh:function(){return this.rd.Name},Oh:function(){return this.rd.Size},Mh:function(){return this.rd.Color}};var ef;ef=function(a,b,c,d){this.rd=Q.UF(b,d)};ef.prototype={i:function(a){a.getState().VD(this.rd.Font,this.rd.Size,this.rd.Color)},Nh:function(){return this.rd.Name},Oh:function(){return this.rd.Size},Mh:function(){return this.rd.Color}};var ce;
ce=function(a,b,c,d){c=1===b.getUint32();var e=b.getUint32(),f=b.getUint32();if(30===a){var g=b.getUint32();var k=b.getUint32()/100;var l=b.getUint32()/100;var E=b.getUint32();var u=0===b.getUint32();b.getUint32();b=b.getUint32()}else g=b.getUint16(),k=b.getUint8()/100,l=b.getUint8()/100,E=b.getUint8(),u=!0,b=0;!0===d.g.getConfiguration().SemiTransparencyActive?(e=Q.cb(e),f=Q.cb(f),30===a&&(b=Q.cb(b))):(e=Q.lb(e),f=Q.lb(f),30===a&&(b=Q.lb(b)));this.QJ=new ab(c,e,f,g,k,l,E,u,b)};ce.prototype={i:function(a){a.getState().WR(this.QJ)}};
var he;he=function(a,b,c,d){this.pb=b.getUint32();d.g.getConfiguration().SemiTransparencyActive=2===(this.pb&2);d.g.getConfiguration().IecSupportsCommonMiterLimit=8===(this.pb&8)};he.prototype={i:function(a){a=a.g.ra;null!==a&&(a.g.N.ID(1===(this.pb&1)),a.Sp(0!==(this.pb&4)))}};var Oe;
Oe=function(a,b,c){a=b.ga();var d=b.getUint16();var e=b.ha(d,!1);d=b.getUint16();d=b.ha(d,!1);""!==e&&(d=e+"."+d);this.xf=d;this.m=Q.ni(b,!0);this.m.normalize();e=b.getUint32();this.ls=0!==(e&1);this.Rm=0!==(e&2);this.An=0!==(e&4);this.Rr=0!==(e&128);this.et=0!==(e&256);this.Dt=0!==(e&1024);this.gr=0!==(e&2048);this.Dh=0!==(e&4096);this.Gk=!1;c>=b.ga()-a+16&&(this.Gk=!0,this.tn=b.getFloat32(),this.un=b.getFloat32());this.Ha=null};
Oe.prototype={i:function(a){var b=a.g.ba().wa(),c=this;this.Qg=a;window.WebvisuInst.Il(function(){var d=c.ZH(c.Qg);b.$R(d,c)})},wc:function(){return this.m.clone()},ZH:function(a){var b=new Image;var c=a.kg.Qh(this.xf);null===c?b.src="#":b.src=c;c=b.src;this.Dh&&(b.src+="?"+J.l());J.Rq(c)&&(D.Gq()?this.yN():a.g.getConfiguration().WorkaroundDisableSVGAspectRatioWorkaround||(b.src+="#svgView(preserveAspectRatio(none))"));b.style.position="absolute";b.style.msUserSelect="none";b.style.WebkitUserSelect=
"none";b.style.MozUserSelect="none";b.style.userSelect="none";return b},yN:function(){N.warn("Anisotropic scaling of Svg images in Safari is not supported because of known bugs in WebKit. The default (isotropic) scaling is used instead.")}};var je;
je=function(a,b,c,d){var e;a=b.getUint16();var f=[];for(c=0;c<a;++c){var g=b.getUint16();f[c]=b.ha(g,!1)}this.cc=[];a=b.getUint16();for(c=0;c<a;++c){var k=[];g=b.getUint16();for(e=0;e<g;++e)k[e]=f[b.getUint16()];this.cc.push({Gu:k.join(".").toLowerCase(),hD:b.getUint16()})}d.kg.mR(this.cc)};je.prototype={i:function(){}};var Wd;
Wd=function(a,b,c,d){var e=b.ga(),f=b.getUint32(),g=b.getUint32();a=b.getUint16();var k=["butt","square","round"],l=["miter","bevel","round"];this.Bf=f;!0===d.g.getConfiguration().SemiTransparencyActive?this.nb=Q.cb(g):this.nb=Q.lb(g);this.ka=a;c>=b.ga()-e+11?(c=b.getUint16(),this.jf=k[0],0!==(c&0)&&(this.jf=k[0]),0!==(c&1)&&(this.jf=k[1]),0!==(c&2)&&(this.jf=k[2]),c=b.getUint16(),this.kf=l[0],0!==(c&0)&&(this.kf=l[0]),0!==(c&1)&&(this.kf=l[1]),0!==(c&2)&&(this.kf=l[2]),b=b.getUint16(),d.g.getConfiguration().IecSupportsCommonMiterLimit?
this.Wf=b/2:this.Wf=1===b?1.7*a:2*b):(this.jf=k[0],this.kf=l[0],d.g.getConfiguration().IecSupportsCommonMiterLimit?this.Wf=1.5:this.Wf=1.7*a)};Wd.prototype={i:function(a){a.getState().ev(this.ka,this.nb,this.Bf,this.jf,this.kf,this.Wf)},C:function(){return this.ka},mp:function(){return this.nb}};var ie;
ie=function(a,b,c){this.ya=[];var d=null;a=b.ga();for(var e,f;b.ga()-a<c-8;)e=b.getUint32(),e&2147483648?(f=b.getUint32(),d=Q.Ce(b),--d.da,--d.Z,d=new of(f,d,e&2147483647),this.ya.push(d)):null!==d&&(f=e&65535,e=(e&2147483647)>>16,f=b.ga()+f,this.OL(b,d,e),b.seek(f))};
ie.prototype={i:function(a){var b=a.g.ra;if(a.g.la){var c=a.g.ba().wa();if(null!==c&&!(c instanceof Ic)){var d=c.ld;null!==d?d.jv(this.ya):c.cS(a.g,Yb.vE(this.ya,a.g));b.Su(c);for(d=0;d<this.ya.length;++d)this.ya[d].xR(c),b.Qo(this.ya[d],!0)}else if(null!==b)for(b.Su(null),d=0;d<this.ya.length;++d)b.Qo(this.ya[d],!1)}else if(null!==b)for(b.sB(),d=0;d<this.ya.length;++d)b.Qo(this.ya[d],!1);a.g.getConfiguration().DebugOnlyPrintTouchRectangles&&this.KI()},OL:function(a,b,c){switch(c){case 3:b.info().scroll().Va().$h(new I(a.getInt32(),
a.getInt32()));b.info().scroll().Va().Zh(new I(a.getInt32(),a.getInt32()));b.vj(Wc.si);break;case 4:b.info().zoom().Va().gv(a.getFloat32());b.info().zoom().Va().fv(a.getFloat32());b.vj(Wc.Nw);break;case 5:b.info().zR(new Bb(a.getUint16(),a.getUint16(),a.getUint16(),a.getUint16()));break;case 6:c=a.getUint16();var d=a.getUint16(),e=!!a.getUint8(),f=!!a.getUint8();a=new I(a.getUint16(),a.getUint16());b.info().TD(c,new pf(d,e,f,a))}},KI:function(){var a;for(a=0;a<this.ya.length;++a){var b=this.ya[a];
N.l(J.h("TouchRect ({0}): {1} (Flags: {2})",b.id(),J.YQ(b.za),b.flags()));b.$(Wc.si)&&N.l(J.h("  ScrollLimits {0} -> {1}",J.Yc(b.info().scroll().Va().Dc),J.Yc(b.info().scroll().Va().Cc)));b.$(Wc.Nw)&&N.l(J.h("  Zoomlimits: {0} -> {1}",b.info().zoom().Va().Dc,b.info().zoom().Va().Cc))}}};var Zd;Zd=function(a,b){this.aH=1===b.getUint16()};Zd.prototype={i:function(a){this.aH?a.rD():a.OQ()}};var ve;ve=function(a,b){this.AC=b.getInt16();this.BC=b.getInt16()};
ve.prototype={i:function(a){a.getState().ES(this.AC,this.BC)}};var ff;ff=function(a,b){a=b.getUint16();this.Oe=b.ha(a,!1);this.Jk=b.getUint32();this.Kk=b.getUint16();this.cH=b.getUint32();this.sk=b.getUint32();this.Pi=b.getUint32()};ff.prototype={i:function(a){var b=a.g.Lo;a=new Rb(this.Oe,this.Kk,this.Jk,this.sk,this.cH,this.Pi);null!==b&&b.SS(a)}};var ge;ge=function(a,b){a=b.getUint16();this.na=b.ha(a,!1)};
ge.prototype={i:function(a){a.g.getConfiguration().ChangeWindowTitle&&(window.document.title=this.na);a.g.Rc&&window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess.setVisualizationName(this.na)}};var Yd;Yd=function(a,b){this.m=Q.Ce(b)};Yd.prototype={i:function(a){a.getContext().restore();a.getState().apply()}};var jf;jf=function(a,b){this.hc=b.getUint32()};jf.prototype={i:function(a){a.g.la&&(a=a.g.ba().wa(),a instanceof Qc&&a.qR(this.hc))}};var kf;kf=function(a,b){this.eK=b.getUint16()};
kf.prototype={i:function(a){a.g.la&&(a=a.g.ba().wa(),a instanceof Qc&&a.rR(this.eK))}};var Te;Te=function(a,b){a=b.getInt16();this.Kn=J.CC(b,a)};Te.prototype={i:function(a){var b=this.Kn.length-1,c=a.g.ba();for(a=0;a<=b;++a)c.Uh()}};var ze;ze=function(a,b){this.ta=b.getInt16()};ze.prototype={i:function(a){a.g.ba().Uh()}};var we;
we=function(a,b){this.ta=b.getInt16();a=b.getUint32();this.$J=0!==(a&1);this.qK=0!==(a&2);this.YJ=0!==(a&4);this.ZJ=0!==(a&16);this.ZM=0!==(a&8);this.bH=0!==(a&32);this.HH=0===(a&64);this.tk=0===(a&128);this.kj=0!==(a&1024);this.Qa=new ib(a);this.Tn=this.Qa.mm()};
we.prototype={i:function(a){this.YL(a);var b=Yb.xE(a.g,this.YJ,this.ZJ,this.$J,this.qK,this.ZM,this.bH,this.HH);b.SR(this.Qa);a.g.ba().$A(this.ta,b);b instanceof Qc&&(b.AD(this.tk),b.QD(this.kj));b.initialize()},YL:function(a){this.Qa.Uc()||a.tD()}};var Ee;Ee=function(a,b){this.Bc=b.getInt16()};Ee.prototype={i:function(a){a.g.ba().wa().yO()}};var Be;Be=function(a,b,c){this.Bc=b.getInt16();this.Vi=2<c?0!==(b.getUint32()&1):!1};
Be.prototype={i:function(a){var b=Yb.Pv(32767===this.Bc,this.Vi,!1);a.g.ba().wa().aB(this.Bc,b)}};var Re;Re=function(a,b){this.Bc=b.getInt16()};Re.prototype={i:function(a){a=a.g.ba().wa();32767===this.Bc&&a.qD()}};var De;De=function(a,b){this.Bc=b.getInt16()};De.prototype={i:function(a){a.g.ba().wa().ZD(this.Bc)}};var Ce;
Ce=function(a,b,c){a=b.ga();this.sd=b.getInt16();this.td=b.getInt16();this.ka=b.getInt16();this.qa=b.getInt16();this.mM=0!==b.getUint8();this.nM=0!==b.getUint8();this.OG=b.getUint8();c>=b.ga()-a+9?(this.wx=b.getInt16(),this.xx=b.getInt16(),this.vx=b.getInt16(),this.ux=b.getInt16()):(this.xx=this.wx=0,this.ux=this.vx=-1)};Ce.prototype={i:function(a){a.g.ba().wa().sT(this.sd,this.td,this.ka,this.qa,this.mM,this.nM,this.OG,this.wx,this.xx,this.vx,this.ux)}};var Ue;Ue=function(a,b){this.qf=b.getInt16()};
Ue.prototype={i:function(a){var b=a.g.ba().wa();(null!==b?b.ba():a.g.ba()).KR(this.qf)}};var Pe;Pe=function(a,b){this.Nf=b.getUint8()};Pe.prototype={i:function(a){var b=a.g.ba().wa();(null!==b?b.ba():a.g.ba()).mv(this.Nf)}};var Ve;Ve=function(a,b){this.jM=b.getFloat32();this.kM=b.getFloat32()};Ve.prototype={i:function(a){a.g.ba().wa().VS(this.jM,this.kM)}};var Ge;
Ge=function(a,b){this.mh=b.getInt16();a=b.getInt16();switch(a){case 0:case 5:this.Si="solid";break;case 1:this.Si="dashed";break;case 2:case 3:case 4:this.Si="dotted"}this.sK=5===a;this.Ri=b.getUint32()};Ge.prototype={i:function(a){var b=this.sK?Q.cb(this.Ri&16777215):!0===a.g.getConfiguration().SemiTransparencyActive?Q.cb(this.Ri):Q.lb(this.Ri);a.g.ba().wa().RR(this.mh,this.Si,b)}};var Fe;
Fe=function(a,b){this.bl=b.getInt32();this.cl=b.getInt32();this.Zk=b.getInt32();this.$k=b.getInt32();this.rf=b.getInt32();this.sf=b.getInt32()};Fe.prototype={i:function(a){a.g.ba().wa().kv(this.bl,this.cl,this.Zk,this.$k,this.rf,this.sf)}};var Ae;Ae=function(){};Ae.prototype={i:function(a){a.g.ba().Qu();var b=a.getContext(),c=a.g.ba().wa();b.save();b.setTransform(1,0,0,1,0,0);b.clearRect(0,0,b.canvas.width,b.canvas.height);b.restore();null!==c&&c.rB();a.g.ub.cm(this.m)}};var Se;
Se=function(a,b){a=b.getInt16();this.Kn=J.CC(b,a)};Se.prototype={i:function(a){var b,c=this.Kn.length-1;for(b=0;b<=c;b++)a.g.ba().$l(this.Kn[b])}};var ye;ye=function(a,b){this.ta=b.getInt16()};ye.prototype={i:function(a){a.g.ba().$l(this.ta)}};var xe;xe=function(a,b){this.sd=b.getInt16();this.td=b.getInt16();this.ka=b.getInt16();this.qa=b.getInt16();this.Td=b.getInt16();this.Ud=b.getInt16();this.Hh=b.getInt16();this.Ih=b.getInt16();this.mb=b.getInt16();this.qd=b.getInt16();this.We=b.getUint32()};
xe.prototype={i:function(a){this.qd||(this.qd=0);var b=a.g.ba().wa(),c="",d=this;0<this.qd&&(c="all "+this.qd+"ms ease");if(b.ua instanceof Lc&&b.ua.th)if(this.td=this.sd=0,this.qa=this.ka=1,this.We=this.mb=this.Ih=this.Hh=this.Ud=this.Td=0,J.Lq(b.U)){var e=document.getElementById("background");null!==e&&(this.ka=e.width,this.qa=e.height)}else e=J.xm(a.g.ba(),b.U.id),null!==e?(this.ka=e.wf(),this.qa=e.vf()):N.h("Could not find parent node. Size will be 0");0!==(this.We&4)?a.g.Po(function(){d.Yx(b,
c)}):this.Yx(b,c)},Yx:function(a,b){a.update(this.sd,this.td,this.ka,this.qa,this.Td,this.Ud,this.Hh,this.Ih,this.mb,this.We,b)}};var We;We=function(a,b){this.sd=b.getInt16();this.td=b.getInt16();this.ka=b.getInt16();this.qa=b.getInt16();this.Td=b.getInt16();this.Ud=b.getInt16();this.Hh=b.getFloat32();this.Ih=b.getFloat32();this.mb=b.getInt16();this.qd=b.getInt16();this.We=b.getUint32()};
We.prototype={i:function(a){this.qd||(this.qd=0);var b=a.g.ba().wa(),c="";0<this.qd&&(c="all "+this.qd+"ms ease");b.ua instanceof Lc&&b.ua.th&&(this.td=this.sd=0,this.qa=this.ka=1,this.We=this.mb=this.Ih=this.Hh=this.Ud=this.Td=0,J.Lq(b.U)?(a=document.getElementById("background"),null!==a&&(this.ka=a.width,this.qa=a.height)):(a=J.xm(a.g.ba(),b.U.id),null!==a?(this.ka=a.wf(),this.qa=a.vf()):N.h("Could not find parent node. Size will be 0")));b.update(this.sd,this.td,this.ka,this.qa,this.Td,this.Ud,
this.Hh,this.Ih,this.mb,this.We,c)}};var Ke;Ke=function(a,b){this.ta=b.getInt16();this.Nf=b.getInt16()};Ke.prototype={i:function(a){a.g.la&&a.g.Lo.vB();a.g.YN(this.ta);a.g.hd.mv(this.Nf)},Sl:function(){return this.ta}};var Ne;Ne=function(a,b){this.ta=b.getInt16()};Ne.prototype={i:function(a){a.g.xO()}};var Je;
Je=function(a,b){this.ta=b.getInt16();this.Nf=b.getInt16();a=b.getUint32();this.Aa=0!==(a&1);this.jl=0!==(a&2);this.io=0!==(a&4);this.s={cD:0!==(a&16),ZP:0!==(a&32),$P:0!==(a&128),dD:0!==(a&64),ST:0!==(a&512),eB:0!==(a&1024),Lt:0!==(a&2048),TT:0!==(a&256)};this.zn=0!==(a&8);this.Gt=0!==(a&4096);this.uH=0!==(a&8192);this.KH=0!==(a&16384);this.xK=0!==(a&32768);this.kj=0!==(a&65536)};
Je.prototype={i:function(a){a.g.hd.mv(this.Nf);var b=Yb.qE(this.Aa,this.Gt,a.g,this.KH),c=a.g.ba().wa();c=c?c.YO():null;this.uH&&(c=J.bb().getBoundingClientRect(),this.jl=!0,c=new Bb(c.x,c.y,c.x+c.width,c.y+c.height));b.QD(this.kj);b.initialize(c,this.jl,this.io,this.zn,a.Oa,this.s,this.xK);a.g.openDialog(this.ta,b)}};var Me;Me=function(a,b){this.ta=b.getInt16()};Me.prototype={i:function(a){a.g.ZS(this.ta)},Sl:function(){return this.ta}};var Le;
Le=function(a,b){this.sd=b.getInt16();this.td=b.getInt16();this.ka=b.getInt16();this.qa=b.getInt16();this.qd=b.getInt16();a=b.getUint32();this.nb=Q.cb(a)};Le.prototype={i:function(a){a=a.g.ba().wa();var b="";0<this.qd&&(b="transform "+this.qd+"ms ease, opacity "+this.qd+"ms ease");a.update(this.sd,this.td,this.ka,this.qa,0,0,0,0,0,null,b,this.nb)}};var Hd;
Hd=function(a){this.sh="";this.Pk=0;this.Tq=[];this.Mc=0;if(null!==a){var b=a.getUint16(),c;a.ha(b,!1);b=a.getUint16();this.sh=a.ha(b,!1);this.Pk=a.getUint16();for(c=0;c<this.Pk;++c)b=a.getUint16(),this.Tq[c]=a.ha(b,!1);this.Mc=a.getUint32();a.getUint32()}};var qf;qf=function(){this.Be=this.oT=0};var fc;fc=function(a){this.g=a;this.pc=[]};
fc.prototype={F:function(a,b){var c=this.Hn(a);0<=c&&this.Ux(c);a=new rf(this.g,a,b);this.pc.push(a);return a},GE:function(a){a instanceof Zc&&this.Ux(this.DJ(a.dc.id))},Ux:function(a){0<=a&&(null!==this.pc[a].nc&&null!==this.pc[a].P()&&this.pc[a].nc.removeChild(this.pc[a].P()),this.pc.splice(a,1))},Hn:function(a){for(var b=0;b<this.pc.length;b++)if(this.pc[b].Sl()===a)return b;return-1},DJ:function(a){for(var b=0;b<this.pc.length;b++)if(this.pc[b].sx===a)return b;return-1},className:function(){return"FileTransferButtonsStorage"}};
var Id;Id=function(a,b,c,d,e){this.zv=a;this.direction=b;this.Vh=c;this.iD=d;this.Kc=e;this.Xp=0;this.li=new qf;this.di=new qf;this.status=new md;this.Ob=this.buffer=null;this.yD=J.l();this.bD=!1};var Nd;Nd=function(a,b,c,d,e,f,g,k){this.stream=a;this.dw=b;this.lQ=c;this.GC=d;this.WB=e;this.filters=f;this.flags=g;this.kP=k};var ec;ec=function(a){this.g=a;this.Xn=-1;this.pc=[]};
ec.prototype={mw:function(a){this.Xn=a.dw;var b=this.Hn(this.Xn);0>b?this.pc.push(a):this.pc[b]=a},aw:function(a){a=this.Hn(a);return 0>a?null:this.pc[a]},ZF:function(){this.Xn=-1},Hn:function(a){for(var b=0;b<this.pc.length;b++)if(this.pc[b].dw===a)return b;return-1}};var md;md=function(){this.Xe=!0;this.we=this.xe=this.Wd=!1;this.ai=this.zd=this.result=0;this.Zb=md.xa};md.xa=1;md.J=2;md.Sb=3;md.l=4;md.ab=19;md.h=20;var hf;hf=function(a,b){this.tK=0!==b.getUint8();b.getUint8();b.getUint8()};
hf.prototype={i:function(a){a.g.la&&(a.tD(),a=a.g.ba().wa(),this.tK&&(a.DS(),a.dE()))}};var gf;gf=function(a,b){this.sJ=b.getInt16();this.Uy=0!==b.getUint8()};gf.prototype={i:function(a){if(a.g.la){var b=a.g.ba().wa();a.TR(b,this.sJ,this.Uy);b.Ze()&&(b.bE(),b.zS(this.Uy))}}};var Ie,sf;sf={nG:0,MT:1,tw:2,aG:3,ME:4,COLOR:5};
Ie=function(a,b,c,d){var e;c=a=0;var f=d.g.ic.zb,g=new Qd;this.Qd=d;this.ke=b.getUint32();d=b.getUint16();this.Ld=[];for(var k=0;k<d;++k){var l=b.getUint32();var E=b.getInt8();if(E===sf.aG){var u=e=b.getUint8();b.Dd(g.GO(u))}else if(E===sf.ME||E===sf.COLOR)u=e=b.getUint16(),b.Dd(8);else if(E===sf.tw){e=u=this.lA(b);b.Dd(8);a=b.getInt32();c=b.getInt32();var ka=new tf(a,c)}else E===sf.nG&&(e=u=this.lA(b),b.Dd(8));E===sf.tw?a<=c?(l=this.yo(b,e,l,u,f,ka),ka.setData(l),this.Ld.push(ka)):this.Ld.push(0):
this.Ld.push(this.yo(b,e,l,u,f,ka));this.Ld.push(e);this.Ld.push(u)}};Ie.prototype={i:function(a){var b=a.g.ic.TO(this.ke);a=a.g.ba().wa();3!==this.Ld.length&&5!==this.Ld.length||a.FQ(b,this.Ld[1]);a.MN(b,this.Ld)},yo:function(a,b,c,d,e,f){var g=new Qd;a=g.BB(a,c);return g.wp(b,a,this.Qd,d,e,f)},lA:function(a){var b=a.getUint8();var c=a.getUint8()<<8;b|=c;c=a.getUint8()<<16;return b|c}};var uf;uf=function(a,b){this.ca=b;this.ph=null;this.fK=a;this.Ty=!1;this.ir=[]};
uf.prototype={YR:function(a){this.ph=a;this.Ty=!0},fC:function(){return null===this.ph?null:this.ph.contentWindow},fT:function(a){this.ir.push(a)},kR:function(a){this.ir.forEach(function(b){a(b)});this.ir=[]}};var Ye;Ye=function(a,b){var c;a=b.getUint16();this.Cf={};for(c=0;c<a;c++){var d=b.getUint16();d=b.ha(d,!1);var e=b.getUint32();this.Cf[d]=e}};Ye.prototype={i:function(a){a=a.g.ic;for(var b in this.Cf)this.Cf.hasOwnProperty(b)&&a.EQ(b,this.Cf[b])}};var vf;vf=function(){this.el={}};
vf.prototype={Yt:function(a){return"EmbeddedBrowser"===a?window[a+"ElementFactory"].createElement():void 0!==this.el[a]?this.el[a]:null},fill:function(a,b){this.el={};try{var c=JSON.parse(a)}catch(k){throw new TypeError("Expected json containing a array.");}if(!(c instanceof Array))throw new TypeError("Expected json containing a array.");var d;for(d=0;d<c.length;d++){a=c[d];if(!(a instanceof Object))throw new TypeError("Expected entry to be an object.");if("string"!==typeof a.name)throw new TypeError("Expected name to be a string.");
if("string"!==typeof a.wrapper)throw new TypeError("Expected wrapper to be a string.");if(!(a.js instanceof Array))throw new TypeError("Expected js to be an Array.");if(!(a.css instanceof Array))throw new TypeError("Expected css to be an Array.");if(!J.Am(a.additionalFiles))throw new TypeError("Expected additionalFiles to be an Object.");var e=this.tC(a.js);var f=this.tC(a.css);var g=this.XO(a.additionalFiles);if(void 0!==this.el[a.name])throw new TypeError(J.h("There is already a native element named {0}.",
a.name));this.el[a.name]=new bd(a.wrapper,e,f,g,b)}},XO:function(a){var b={},c;for(c in a){if("string"!==typeof c)throw new TypeError("Only strings are expected in the object.");if("string"!==typeof a[c])throw new TypeError("Only strings are expected in the object.");b[c]=a[c]}return b},tC:function(a){var b=[],c;for(c=0;c<a.length;c++){var d=a[c];if("string"!==typeof d)throw new TypeError("Only strings are expected in the array.");b.push(d)}return b}};var He;He=function(a,b){this.ke=b.getUint32()};
He.prototype={i:function(a){var b=a.g.ic,c=b.NO(this.ke),d=b.Yt(c);null!==d?(a=a.g.ba().wa(),a.hS(b,d)):N.warn("The HTML5 element '"+c+"' can not be used because it hasn't been downloaded. View Messages in the Development system for more details.")}};var $b;$b=function(a){this.gy=new vf;this.Br=new ad;this.al=new ad;this.zb=new wf;this.Dk=[];this.g=a;var b=this;window.addEventListener("message",function(c){b.h(c)})};
$b.prototype={Yt:function(a){return this.gy.Yt(a)},getConfiguration:function(){return this.g.getConfiguration()},EQ:function(a,b){this.Br.Pu(a,b)},GQ:function(a,b){this.al.Pu(a,b)},NO:function(a){return this.Br.nC(a)},TO:function(a){return this.al.nC(a)},gC:function(a){return this.al.nu(a)},h:function(a){if(null!==a&&void 0!==a&&J.Am(a))if("null"!==a.origin)N.h("Unhandled message: Wrong origin. "+a.origin);else if(null!==a.data&&void 0!==a.data&&J.Am(a.data)){var b=this.MO(a.data);if(null===b)N.h("Unhandled message: Unable to determine element for postMessage.");
else{a=a.data;var c=a.promiseId;if(null!==a.data&&void 0!==a.data&&J.Am(a.data))if(null!==c&&"number"!==typeof c)N.warn("Promise Id is not of type number.");else if(this.bz(a)||b.ca.Qa.Uc())try{this.Ul(a,c,b)}catch(d){N.warn("Error at handling the followig message: \n\r"+JSON.stringify(a.data,null,4)),N.warn(d.stack),this.Wc(b.ca,Xc.Vg(c,d))}else N.h("Messages from preview visualizations are not supported.");else N.h("Invalid message: Wrong data.")}}else N.h("Invalid message: Wrong data.");else N.h("Invalid message.")},
Ul:function(a,b,c){var d=this;var e=J.FB(a.data.param);N.info(J.h("Message from element {0}: {1}",null!==c.ph?c.ph.id:c.ca.dc.id,JSON.stringify(a.type)));this.bz(a)&&this.gP(c.ca);"SetValue"===a.type?xf.xa(this,c.ca,b,a.data,e):"CheckValue"===a.type?xf.l(this,c.ca,b,a.data,e):"SendMouseEvent"===a.type?"string"===typeof a.data.type&&"number"===typeof a.data.xPos&&"number"===typeof a.data.yPos&&c.ca.gR(a.data.type,a.data.xPos,a.data.yPos):"GetTypeDesc"===a.type?"number"===typeof a.data.typeId&&(a=this.zb.Ae(a.data.typeId),
this.Wc(c.ca,Xc.uE(b,void 0!==a&&0!==a,a))):"SetScrollRange"===a.type?"string"===typeof a.data.methodName&&"number"===typeof a.data.startIndex&&"number"===typeof a.data.endIndex&&"number"===typeof a.data.scrollDimension&&(b=this.al.nu(a.data.methodName),e=c.ca,e.iR(this.g,b,a.data.startIndex,a.data.endIndex,a.data.scrollDimension)):"CheckComplexValue"===a.type?xf.h(this,c.ca,b,a.data,e):"SetComplexValue"===a.type?xf.J(this,c.ca,b,a.data,e):"GetAdditionalFileName"===a.type?yf.Ul(c.ca.Jd,b,a.data,function(f){d.Wc(c.ca,
f)}):"GetImagePoolFileName"===a.type?zf.Ul(this.g.V().kg,b,a.data,function(f){d.Wc(c.ca,f)}):"GetImageByFilename"===a.type?Af.J(c.ca.Jd,b,a.data,function(f){d.Wc(c.ca,f)}):"GetImageById"===a.type?Af.l(c.ca.Jd,this.g.V().kg,b,a.data,function(f){d.Wc(c.ca,f)}):"GetTextFile"===a.type?Af.xa(c.ca.Jd,b,a.data,function(f){d.Wc(c.ca,f)}):"GetBinaryFile"===a.type?Af.h(c.ca.Jd,b,a.data,function(f){d.Wc(c.ca,f)}):"SetResizeValues"===a.type?d.UJ(c.ca,c.ph,b,a.data):"SetForegroundState"===a.type&&d.SJ(c.ca,c.ph,
b,a.data)},unregister:function(a){if(a.Jd instanceof bd){var b=this.op(a);null!==b?this.Dk.splice(this.Dk.indexOf(b),1):N.warn("No element data found for "+a.dc.id)}},op:function(a){if(!(a instanceof Ic))return null;var b=this.Dk.find(function(c){return c.ca===a});return void 0===b?null:b},MO:function(a){if(void 0===a||null===a||"string"!==typeof a.identification)return null;var b=this.Dk.find(function(c){return c.fK===a.identification});return void 0===b?null:b},gP:function(a){var b=a.Ii,c=this,
d=this.op(a);d.YR(b);d.kR(function(e){c.xD(d.fC(),e)})},fill:function(a){this.gy.fill(a,this.g.getConfiguration().DebugHTML5);this.Br=new ad;this.al=new ad},xD:function(a,b){this.lR(a,{type:b.type(),data:b})},Wc:function(a,b){a=this.op(a);a.Ty?this.xD(a.fC(),b):a.fT(b)},lR:function(a,b){a.postMessage(b,"*")},register:function(a,b){b.Jd instanceof bd&&(null!==this.op(b)&&this.unregister(b),this.Dk.push(new uf(a,b)))},Zo:function(a,b){return(new Bf(this.zb)).SN(a,b)},bp:function(a,b){var c=new Bf(this.zb);
return Number(c.dB(a,b))},fR:function(a,b,c,d,e,f,g,k){var l=d,E=16,u=new Qd;var ka=u.Gj(c,this.zb);c=u.getType(c,this.zb);4<ka||c===Cf.ui||c===Cf.Yg?(l=1,E+=ka):c===Cf.Nq&&(l=this.wy(d));ka=Ga.F(E);E=Cc.F(ka,this.g.A.Ia,this.g.getConfiguration().wd());E.Vd(e);E.Vd(f);E.Vd(g);E.Vd(k);this.$o(E,c,d);a.oM(b,l,ka)},jR:function(a,b,c,d){var e=d,f=null,g=new Qd;var k=g.Gj(c,this.zb);c=g.getType(c,this.zb);if(4<k||c===Cf.ui||c===Cf.Yg){f=Ga.F(k);var l=Cc.F(f,this.g.A.Ia,this.g.getConfiguration().wd());
e=1}else c===Cf.Nq&&(e=this.wy(d));this.$o(l,c,d);a.tM(b,e,f)},UN:function(a,b){var c=new Qd;var d=c.Gj(a,this.zb);a=c.getType(a,this.zb);if(4<d||a===Cf.ui||a===Cf.Yg)var e=Cc.F(Ga.F(d),this.g.A.Ia,this.g.getConfiguration().wd());this.$o(e,a,b)},PN:function(a,b,c,d,e,f){var g=16,k=new Qd;var l=k.Gj(a,this.zb);a=k.getType(a,this.zb);if(4<l||a===Cf.ui||a===Cf.Yg)g+=l;l=Cc.F(Ga.F(g),this.g.A.Ia,this.g.getConfiguration().wd());l.Vd(c);l.Vd(d);l.Vd(e);l.Vd(f);this.$o(l,a,b)},$o:function(a,b,c){switch(b){case Cf.ww:a.fB(c);
break;case Cf.Dw:case Cf.Aw:a.hB(c);break;case Cf.xw:a.Mt(c);break;case Cf.ui:case Cf.Yg:b=a.jb(c,b===Cf.Yg),a.jc(b)}},wy:function(a){var b=Ga.F(4),c=this.g.A.Ia;Cc.F(b,c).To(a);return Nb.F(b.Zd(),c).getUint32()},bz:function(a){return"WebvisuSupportLoaded"===a.type},UJ:function(a,b,c,d){if("object"===typeof d&&"number"===typeof d.width&&"number"===typeof d.height)b=a.S,b.style.width=d.width.toString()+"px",b.style.height=d.height.toString()+"px",b.parentNode.style.width=b.style.width,b.parentNode.style.height=
b.style.height,a.MS(d.width,d.height);else throw new TypeError("Message is not in the correct format.");},SJ:function(a,b,c,d){if("object"===typeof d&&"boolean"===typeof d.foregroundState)a.S.parentNode.style.zIndex=d.foregroundState?Va.eq:Va.qm;else throw new TypeError("Message is not in the correct format.");}};var Ze;Ze=function(a,b){var c;a=b.getUint16();this.Cf={};for(c=0;c<a;c++){var d=b.getUint16();d=b.ha(d,!1);var e=b.getUint32();this.Cf[d]=e}};
Ze.prototype={i:function(a){a=a.g.ic;for(var b in this.Cf)this.Cf.hasOwnProperty(b)&&a.GQ(b,this.Cf[b])}};var ad;ad=function(){this.Cs={};this.Ny={}};ad.prototype={Pu:function(a,b){void 0===this.Cs[a]&&(this.Cs[a]=b,this.Ny[b]=a)},nu:function(a){return this.Cs[a]},nC:function(a){return this.Ny[a]}};var Bf,Cf,Df,Ef;Bf=function(a){this.yt=a};
Bf.prototype={SN:function(a,b){var c=J.FB(b);try{if("string"===typeof b){if(a===Cf.ui||a===Cf.Yg)return this.ox(b,81);var d=this.yt.Ae(a);if(d instanceof Ff)return this.ox(b,d.getSize())}c&&(b=this.dB(a,b));var e="number"===typeof b;if("bigint"===typeof b||e){if(e&&isNaN(b))return!1;d=this.yt.Ae(a);return d instanceof Gf?b>=d.LowerBorder&&b<=d.UpperBorder?!0:!1:this.az(b,a)?!0:this.CK(b,a)?!0:!1}}catch(f){return!1}},ox:function(a,b){return null===a||void 0===a||a.length>b-1?!1:!0},az:function(a,b){switch(b){case Cf.jG:case Cf.iG:return this.pP(a);
case Cf.kG:case Cf.sG:return this.DP(a);case Cf.tG:case Cf.rG:return this.BP(a);case Cf.mG:case Cf.qG:case Cf.Bw:case Cf.rw:case Cf.sw:case Cf.Cw:return this.AP(a);case Cf.Aw:case Cf.Dw:case Cf.yw:case Cf.uw:case Cf.vw:case Cf.zw:return this.CP(a);case Cf.pG:return this.yP(a);case Cf.oG:return this.rP(a);case Cf.lG:return this.qP(a);case Cf.ww:return this.tP(a);case Cf.Nq:return this.wP(a);case Cf.xw:return this.uP(a);default:return!1}},CK:function(a,b){return(b=this.yt.Ae(b))&&b instanceof Hf?this.az(a,
b.vd()):!1},pP:function(a){return 0===a||1===a},DP:function(a){return a>=Df.rF&&a<=Df.qF},BP:function(a){return a>=Df.nF&&a<=Df.mF},AP:function(a){return a>=Df.lF&&a<=Df.kF},CP:function(a){var b=BigInt(Ef.pF),c=BigInt(Ef.oF);var d=a;"bigint"!==typeof a&&(d=BigInt(a));return d>=b&&d<=c},yP:function(a){return a>=Df.jF&&a<=Df.iF},rP:function(a){return a>=Df.bF&&a<=Df.aF},qP:function(a){return a>=Df.$E&&a<=Df.ZE},tP:function(a){var b=BigInt(Ef.dF),c=BigInt(Ef.cF);var d=a;"bigint"!==typeof a&&(d=BigInt(a));
return d>=b&&d<=c},wP:function(a){return a>=Df.hF&&a<=Df.gF},uP:function(a){return a>=Df.fF&&a<=Df.eF},dB:function(a,b){switch(a){case Cf.Bw:case Cf.Cw:return Number(b.valueOf());case Cf.rw:case Cf.sw:return this.EN(b.valueOf());case Cf.yw:case Cf.uw:case Cf.vw:case Cf.zw:return this.FN(BigInt(b.valueOf()))}return b},EN:function(a){return Math.floor(Number(a)/1E3)},FN:function(a){return BigInt(a)*BigInt(1E6)}};
Cf={jG:0,iG:1,kG:2,tG:3,mG:4,Aw:5,pG:6,oG:7,lG:8,ww:9,sG:10,rG:11,qG:12,Dw:13,Nq:14,xw:15,ui:16,Yg:17,Bw:18,rw:19,sw:20,Cw:21,yw:37,uw:46,vw:47,zw:48};Df={rF:0,qF:255,nF:0,mF:65535,lF:0,kF:4294967295,jF:-128,iF:127,bF:-32768,aF:32767,$E:-2147483648,ZE:2147483647,hF:-3.402823466E38,gF:3.402823466E38,fF:-1.7976931348623157E308,eF:1.7976931348623157E308};Ef={pF:"0",oF:"0xffffffffffffffff",dF:"-9223372036854775808",cF:"9223372036854775807"};var bd;
bd=function(a,b,c,d,e){this.Mi=a;this.Wn=b;this.tr=c;this.HG=d;this.hn=e;void 0===this.hn&&(this.hn=!1);this.hn||this.Wn.push("webvisu-support.js")};
bd.prototype={Zt:function(a,b,c,d,e){b='</head><body><script nonce="'+(b+'">window["CdsInfo"] = {"TargetOrigin": "')+(window.location.origin+'", "Identification": "'+c+'"};');return b+='window["CdsInfo"]["Wrapper"] = new '+a+"("+d+", "+e+");\x3c/script></body></html>"},jO:function(a,b,c,d,e){var f=document.createElement("iframe"),g=cd.h();b=this.NH(g,b);f.setAttribute("src","about:blank");f.setAttribute("seamless","");f.setAttribute("sandbox","allow-scripts");f.setAttribute("style",J.h("border:0; width:{0}px; height:{1}px;",
c,d));f.setAttribute("csp",b);if(!this.hn)return this.iO(g,a,b,f,c,d,e);var k="<!DOCTYPE html>"+J.h('<html><style nonce="{0}">* { margin:0px;}</style><head>',g);k+=J.h('<meta http-equiv="Content-Security-Policy" content="{0}">',b);k+=J.h('<script language="javascript" src="webvisu-support.js" nonce="{0}">\x3c/script>',g);0!==this.Wn.length&&this.Wn.forEach(function(l){k+=J.h('<script language="javascript" src="{0}" nonce="{1}">\x3c/script>',l,g)});0!==this.tr.length&&this.tr.forEach(function(l){k+=
J.h('<link rel="stylesheet" href="{0}" nonce="{1}">',l,g)});k+=this.Zt(this.Mi,g,a,c,d);f.srcdoc=k;return f},iO:function(a,b,c,d,e,f,g){var k=this;var l="<!DOCTYPE html><html><head>";l+=J.h('<style nonce="{0}">* { margin:0px;}</style>',a);l+=J.h('<meta http-equiv="Content-Security-Policy" content="{0}">',c);if(void 0!==g.Wm){if(void 0!==g.Wm[this.Mi])return l+=g.Wm[this.Mi],l=l.replaceAll("Wg3uwOo94xmWPpB",a),l+=this.Zt(this.Mi,a,b,e,f),d.srcdoc=l,d}else g.Wm={};c=k.Wn.map(function(E){return k.CO(E,
a,k)});c=k.tr.map(function(E){return k.BO(E,a,k)}).concat(c);Promise.all(c).then(function(E){var u=E.pop();l+=u;E.forEach(function(ka){l+=ka});g.Wm[k.Mi]=l.replaceAll(a,"Wg3uwOo94xmWPpB");l+=k.Zt(k.Mi,a,b,e,f);d.srcdoc=l;return d}).catch(function(E){console.warn("Error when loading the additional files. Details:"+E)});return d},CO:function(a,b,c){return new Promise(function(d,e){c.ju(a,"text").then(function(f){d('<script language="javascript" nonce="'+b+'">'+f+"\x3c/script>")},function(f){e(f)})})},
BO:function(a,b,c){return new Promise(function(d,e){c.ju(a,"text").then(function(f){f=J.h('<style nonce="'+b+'"> '+f+" </style>",f,b);d(f)},function(f){e(f)})})},ju:function(a,b){return new Promise(function(c,d){var e=new XMLHttpRequest;e.responseType=b;e.open("GET",a);e.onload=function(){4===e.readyState&&200===e.status?c(e.response):(console.error(e.statusText),d({QQ:a,status:e.status,statusText:e.statusText}))};e.onerror=function(){console.error(e.statusText);d({QQ:a,status:e.status,statusText:e.statusText})};
e.send()})},h:function(a){if("string"!==typeof a)return null;a=a.toLowerCase();a=this.HG[a];return null===a||void 0===a||"string"!==typeof a?null:a},NH:function(a,b){a=J.h("'nonce-{0}' 'unsafe-inline' {1}",a,b);var c=J.h("'self' blob: {0} {1} data:",window.location.origin,b);b=J.h("'unsafe-inline' 'self' {0} data:",b);return J.h("default-src {0}; object-src 'none'; script-src {0}; img-src {1}; style-src {2}; style-src-elem {2}; base-uri 'none';",a,c,b)}};var yf;yf=function(){};
yf.Ul=function(a,b,c,d){if("number"===typeof b&&"string"===typeof c.originalAdditionalFileName&&null!==a&&void 0!==a)c=c.originalAdditionalFileName,a=a.h(c),d(Xc.sE(b,null!==a,c,a));else throw new TypeError("Message is not in the correct format.");};var Af;Af=function(){};Af.J=function(a,b,c,d){var e=a.h(c.filename);null===e?d(Xc.Vg(b,"handleGetImageMessage Error: Could not resolve requested filename: "+c.filename)):this.en(a,b,"GetImageMessageResult","blob",e,d)};
Af.l=function(a,b,c,d,e){"string"===typeof d.imagePoolId&&(b=b.Qh(d.imagePoolId),null===b?e(Xc.Vg(c,"handleGetImageByIdMessage Error: Could not resolve requested filename: "+d.imagePoolId)):this.en(a,c,"GetImageByIdMessageResult","blob",b,e))};Af.xa=function(a,b,c,d){var e=a.h(c.filename);null===e?d(Xc.Vg(b,"handleGetTextFileMessage Error: Could not resolve requested filename: "+c.filename)):this.en(a,b,"GetTextFileMessageResult","",e,d)};
Af.h=function(a,b,c,d){var e=a.h(c.filename);null===e?d(Xc.Vg(b,"handleGetBinaryFileMessage Error: Could not resolve requested filename: "+c.filename)):this.en(a,b,"GetBinaryFileMessageResult","blob",e,d)};Af.bJ=function(a,b,c){if(void 0===c||""===c)c="text";return a.ju(b,c)};
Af.en=function(a,b,c,d,e,f){"string"!==typeof e&&f(Xc.Vg(b,"Message is not in the correct format. Expected "+e+" to be of type string. Is: "+typeof e));this.bJ(a,e,d).then(function(g){f(new CommonAdditionalFileResultMessage(b,!0,c,e,g))},function(g){f(Xc.Vg(b,g))})};var zf;zf=function(){};zf.Ul=function(a,b,c,d){if("number"===typeof b&&"string"===typeof c.imageId)c=c.imageId,a=a.Qh(c),d(Xc.tE(b,""!==a,c,a));else throw new TypeError("Message is not in the correct format.");};var xf;xf=function(){};
xf.tp=function(a){return"boolean"===typeof a?a?1:0:a};xf.xa=function(a,b,c,d,e){var f;if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var g=a.gC(d.methodName);var k=b.pp(d.methodName);var l=this.tp(d.param);if(f=a.Zo(k,l)){e&&(l=a.bp(k,l));try{a.jR(b,g,k,l)}catch(E){f=!1}}a.Wc(b,Xc.BE(c,f,d.param))};
xf.l=function(a,b,c,d,e){var f;if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var g=b.pp(d.methodName);var k=this.tp(d.param);if(f=a.Zo(g,k)){e&&(k=a.bp(g,k));try{a.UN(g,k)}catch(l){f=!1}}a.Wc(b,Xc.oE(c,f,d.param))};
xf.J=function(a,b,c,d,e){if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.index0||"number"!==typeof d.index1||"number"!==typeof d.index2||"number"!==typeof d.indexCount||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var f=a.zb;var g=a.gC(d.methodName);var k=f.Ae(b.pp(d.methodName));var l=this.tp(d.param);if(k instanceof If||k instanceof Jf){var E=
k.vd(f,d.indexCount,d.index0,d.index1,d.index2);k=a.Zo(E,l)}else k=!1;if(k){e&&(l=a.bp(E,l));try{a.fR(b,g,E,l,d.index0,d.index1,d.index2,d.indexCount)}catch(u){k=!1}}a.Wc(b,Xc.AE(c,k,d.param,d.indexCount,d.index0,d.index1,d.index2))};
xf.h=function(a,b,c,d,e){if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.indexCount||"number"!==typeof d.index0||"number"!==typeof d.index1||"number"!==typeof d.index2||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var f=a.zb;var g=f.Ae(b.pp(d.methodName));var k=this.tp(d.param);if(g instanceof If||g instanceof Jf){var l=g.vd(f,d.indexCount,d.index0,
d.index1,d.index2);g=a.Zo(l,k)}else g=!1;if(g){e&&(k=a.bp(l,k));try{a.PN(l,k,d.index0,d.index1,d.index2,d.indexCount)}catch(E){g=!1}}a.Wc(b,Xc.nE(c,g,d.param,d.indexCount,d.index0,d.index1,d.index2))};var CheckComplexValueResultMessage;CheckComplexValueResultMessage=function(){this.index2=this.index1=this.index0=this.indexCount=this.value=this.result=this.promiseId=null};CheckComplexValueResultMessage.prototype={type:function(){return"CheckComplexValueResult"}};var CheckSimpleValueResultMessage;
CheckSimpleValueResultMessage=function(){this.value=this.result=this.promiseId=null};CheckSimpleValueResultMessage.prototype={type:function(){return"CheckSimpleValueResult"}};var CommonAdditionalFileResultMessage;CommonAdditionalFileResultMessage=function(a,b,c,d,e){this.promiseId=a;this.result=b;this._type=c;this.requestFilename=d;this.responseContent=e};CommonAdditionalFileResultMessage.prototype={type:function(){return this._type?this._type:"CommonAdditionalFileResult"}};var Yc;
Yc=function(){this.error=this.promiseId=null};Yc.prototype={type:function(){return"ErrorMessage"}};var GetAdditionalFileNameResultMessage;GetAdditionalFileNameResultMessage=function(){this.resultingAdditionalFileName=this.originalAdditionalFileName=this.result=this.promiseId=null};GetAdditionalFileNameResultMessage.prototype={type:function(){return"GetAdditionalFileNameResult"}};var GetImagePoolFileNameResultMessage;
GetImagePoolFileNameResultMessage=function(){this.resultingFileName=this.imageId=this.result=this.promiseId=null};GetImagePoolFileNameResultMessage.prototype={type:function(){return"GetImagePoolFileNameResult"}};var GetTypeDescResultMessage;GetTypeDescResultMessage=function(){this.typeDesc=this.result=this.promiseId=null};GetTypeDescResultMessage.prototype={type:function(){return"GetTypeDescResult"}};var MethodCallMessage;MethodCallMessage=function(){this.params=this.methodName=null};
MethodCallMessage.prototype={type:function(){return"MethodCall"}};var ResizeMessage;ResizeMessage=function(){this.height=this.width=null};ResizeMessage.prototype={type:function(){return"Resize"}};var SetComplexValueResultMessage;SetComplexValueResultMessage=function(){this.index2=this.index1=this.index0=this.indexCount=this.value=this.result=this.promiseId=null};SetComplexValueResultMessage.prototype={type:function(){return"SetComplexValueResult"}};var SetSimpleValueResultMessage;
SetSimpleValueResultMessage=function(){this.value=this.result=this.promiseId=null};SetSimpleValueResultMessage.prototype={type:function(){return"SetSimpleValueResult"}};var Kf;Kf=function(a,b){this.MinRange=a;this.MaxRange=b};Kf.prototype={};var tf;tf=function(a,b){this.Data=0;this.StartIndex=a;this.EndIndex=b;this.ScrollDimension=0};tf.prototype={setData:function(a){this.Data=a}};var wf;wf=function(){this.Wr={}};wf.prototype={dm:function(a,b){void 0===this.Wr[b]&&(this.Wr[b]=a)},Ae:function(a){return this.Wr[a]}};
var df;df=function(a,b,c,d){a=d.g.ic;this.id=b.getUint32();this.size=b.getUint32();this.type=b.getUint32();b=new Ff(this.size,this.type);a.zb.dm(b,this.id)};df.prototype={i:function(){}};var af;af=function(a,b,c,d){a=d.g.ic;this.id=b.getUint32();this.size=b.getUint32();this.mT=b.getUint32();c=b.getUint16();this._dimensions=[];for(var e=0;e<c;++e){d=b.getUint32();var f=b.getUint32();this._dimensions.push(new Kf(d,f))}b=new If(this.size,this.mT,this._dimensions);a.zb.dm(b,this.id)};af.prototype={i:function(){}};
var $e;$e=function(a,b,c,d){a=d.g.ic;d=new Qd;this.id=b.getUint32();this.mB=b.getUint32();c=b.getUint16();this._enumValues={};for(var e=0;e<c;++e){var f=b.getUint16();var g=b.ha(f,!1);f=b.ae();this._enumValues[g]=f}b=new Hf(this.mB,d.Gj(this.mB,a.zb),this._enumValues);a.zb.dm(b,this.id)};$e.prototype={i:function(){}};var bf;
bf=function(a,b,c,d){a=d.g.ic;this.id=b.getUint32();this.size=b.getUint32();c=b.getUint32();this.Cx=[];for(var e=0;e<c;++e){d=b.getUint32();var f=b.getUint32();this.Cx.push(new Lf(d,f))}b=new Jf(this.size,this.Cx);a.zb.dm(b,this.id)};bf.prototype={i:function(){}};var cf;cf=function(a,b,c,d){a=d.g.ic;this.id=b.getUint32();this.type=b.getUint32();this.QP=b.$d();this.uT=b.$d();b=new Gf(this.type,this.QP,this.uT);a.zb.dm(b,this.id)};cf.prototype={i:function(){}};var Lf;
Lf=function(a,b){this.TypeId=a;this.Offset=b};Lf.prototype={};var Qd;Qd=function(){};
Qd.prototype={zP:function(a){return 0<=a&&48>=a},getType:function(a,b){if(this.zP(a))return a;var c=b.Ae(a);if(c instanceof If)return this.getType(c.vd(),b);if(c instanceof Ff)return this.getType(c.getType(),b);if(c instanceof Hf)return this.getType(c.vd(),b);throw new TypeError("Cannot determine type for "+a.toString());},GO:function(a){switch(a){case 4:case 8:case 12:case 14:case 18:case 21:case 19:case 20:return 4;case 5:case 13:case 9:case 15:return 8}return 0},BB:function(a,b){var c=Ga.F(b),
d=Cc.F(c,!0),e;for(e=0;e<b;++e)d.Ua(a.getUint8());a=Nb.F(c.Zd(),a.Ij(),a.Vj());return new Ob(a)},wp:function(a,b,c,d,e,f){var g=e.Ae(d);void 0===g&&(g=e.Ae(a));if(g instanceof If||g instanceof Jf)return g.AB(b,c,e,f);if(998===d)return Q.kw(b,c);if(997===d)return a=b.getUint32(),Q.cb(a);g instanceof Hf?a=g.vd():g instanceof Ff?a=g.getType():g instanceof Gf&&(a=g.getType());return this.mD(a,b)},mD:function(a,b){switch(a){case 0:case 1:return 0!==b.getUint8();case 2:case 10:return b.getUint8();case 6:return b.getInt8();
case 3:case 11:return b.getUint16();case 7:return b.getInt16();case 8:return b.getInt32();case 9:return b.$d();case 4:case 12:return b.getUint32();case 5:case 13:return b.ae();case 14:return b.getFloat32();case 15:return b.getFloat64();case 16:case 17:return b.$e(17===a);case 18:return b.getUint32();case 19:case 20:case 21:return b=b.getUint32(),this.MH(b,a);case 26:case 28:return b;default:throw new TypeError("TypeCode + "+a.toString()+" not supported");}},Gj:function(a,b){switch(a){case 0:case 1:case 2:case 10:case 6:return 1;
case 3:case 11:case 7:return 2;case 8:return 4;case 9:return 8;case 4:case 12:return 4;case 5:case 13:return 8;case 14:return 4;case 15:return 8;case 16:return 81;case 17:return 162;case 18:case 19:case 20:case 21:return 4;default:b=b.Ae(a);if(b instanceof If||b instanceof Jf||b instanceof Ff||b instanceof Hf)return b.getSize();throw new TypeError("TypeCode + "+a.toString()+" cannot determine type size");}},vd:function(a,b,c,d,e){if(1E3<=a){var f=b.Ae(a);if(f instanceof If||f instanceof Jf)return f.vd(b,
c,d,e,0);if(f instanceof Ff)return a;if(f instanceof Hf)return f.vd();throw new TypeError("SystemTypeClass: wrong base type id");}return a},MH:function(a,b){a=21===b?new Date(a):new Date(1E3*a);if(19===b)a.setHours(0,0,0,0);else if(21===b)return b=new Date(0),b.setHours(a.getHours()),b.setMinutes(a.getMinutes()),b.setSeconds(a.getSeconds()),b.setMilliseconds(a.getMilliseconds()),b;return a}};var If;If=function(a,b,c){this.Size=a;this.BaseTypeId=b;this.Dimensions=c};
If.prototype={getSize:function(){return this.Size},vd:function(a,b,c,d,e){if(1<=this.Dimensions.length)return(new Qd).vd(this.BaseTypeId,a,b-1,d,e);throw new TypeError("TypeDescArray with no dimensions");},AB:function(a,b,c,d){if(1<=this.Dimensions.length){var e=this.Dimensions[0],f=[],g=0,k=new Qd,l=a.ga();var E=k.Gj(this.BaseTypeId,c);var u=e.MinRange;e=e.MaxRange;void 0!==d&&d instanceof tf&&(u=d.StartIndex,e=d.EndIndex);for(d=u;d<=e;d++)if(2<=this.Dimensions.length){var ka=this.Dimensions[1],
ja=[];for(u=ka.MinRange;u<=ka.MaxRange;u++)a.seek(l+g*E),ja.push(k.wp(this.BaseTypeId,a,b,this.BaseTypeId,c)),g++;f.push(ja)}else a.seek(l+g*E),f.push(k.wp(this.BaseTypeId,a,b,this.BaseTypeId,c)),g++;return f}throw new TypeError("TypeDescArray with no dimensions");}};var Hf;Hf=function(a,b,c){this.BaseTypeId=a;this.iE=b;this.EnumValues=c};Hf.prototype={getSize:function(){return this.iE},vd:function(){return this.BaseTypeId}};var nf;
nf=function(a,b,c,d,e){this.Font=a;this.Name=b;this.Size=c;this.Style=d;this.Color=e};nf.prototype={Dj:function(){return this.Font},getSize:function(){return this.Size},mp:function(){return this.Color}};var Ff;Ff=function(a,b){this.Size=a;this.TypeId=b};Ff.prototype={getSize:function(){return this.Size},getType:function(){return this.TypeId}};var Jf;Jf=function(a,b){this.Size=a;this.Components=b};
Jf.prototype={getSize:function(){return this.Size},vd:function(a,b,c,d,e){if(0<this.Components.length&&0<b)return(new Qd).vd(this.Components[c].TypeId,a,b-1,d,e);throw new TypeError("TypeDescStruct with no components");},AB:function(a,b,c,d){if(0<this.Components.length){var e=[],f=new Qd,g=a.ga();var k=0;var l=this.Components.length-1;void 0!==d&&d instanceof tf&&(k=d.StartIndex,l=d.EndIndex);for(d=k;d<=l;d++)a.seek(g+this.Components[d].Offset),e.push(f.wp(this.Components[d].TypeId,a,b,this.Components[d],
c));return e}throw new TypeError("TypeDescStruct with no components");}};var Gf;Gf=function(a,b,c){this.TypeId=a;this.LowerBorder=b;this.UpperBorder=c};Gf.prototype={getType:function(){return this.TypeId}};var $d;$d=function(){};$d.prototype={i:function(){N.warn("The functionality ExecuteClientProgram is not possible in the webvisualization.")}};var ae;ae=function(){};ae.prototype={i:function(){N.warn("The functionality OpenFileDialog is not possible in the webvisualization.")}};var Mf;
Mf=function(a,b){this.pa=a;this.dr=this.er=-1;this.Fr=!1;this.py=this.oy=1;b.be()&&(this.pa=b.ri(this.pa));this.Ha=null};
Mf.prototype={i:function(a){var b=new Bb(0,0,document.documentElement.clientWidth,document.documentElement.clientHeight);var c=new zd(0,b);var d=!0===a.g.getConfiguration().SemiTransparencyActive?Q.cb(this.dr):Q.lb(this.dr);a.getState().ev(1,d,0,"","",0);a.getState().bv(d,!1);c.xj(a);c=new zd(0,this.pa);d=!0===a.g.getConfiguration().SemiTransparencyActive?Q.cb(this.er):Q.lb(this.er);a.getState().ev(1,d,0,"","",0);a.getState().bv(d,!1);c.xj(a);null!==this.Ha&&this.Ha.loaded()&&(a.NC()&&this.Fr?this.Ck(a,
this.Ha,b):this.Ck(a,this.Ha,this.pa))},oR:function(a){this.er=a},nR:function(a){this.dr=a},pR:function(a){this.Ha=a},LR:function(a){this.Fr=a},MR:function(a){this.oy=a},NR:function(a){this.py=a},Ck:function(a,b,c){if(a.be()){var d=b.rp();if(a.NC()&&this.Fr){var e=this.oy;var f=this.py}else e=a.Co,f=a.mj;d=new Ja(Math.round(e*d.L),Math.round(f*d.aa));c=J.Bq(c,d,this);a.getContext().drawImage(b.qp(),c.u,c.v,c.C(),c.B())}else a.getContext().drawImage(b.qp(),c.u,c.v)}};var Nf;
Nf=function(a,b,c){this.pa=a;this.fr=this.qj=!0;this.o=window.document.createElement("button");this.Ab=null!==c&&void 0!==c?c:b.Oa.canvas.parentNode;this.vo=0;this.sk=1;this.nf=this.Je="#000000";this.Lb=-1;this.ta="";this.Vs=!1};
Nf.prototype={i:function(a){a=a.Aj();var b=null,c=this;b=this.pa.Pb(a.X,a.Y);J.ab(this.o,b);this.Vs&&(this.o.style.position="relative",this.o.style.left="0px",this.o.style.top="0px");this.qj&&(this.o.style.background="transparent",this.o.style.color="transparent");this.fr?(this.o.style.borderRadius=J.h("{0}px",this.vo),this.o.style.borderWidth=J.h("{0}px",this.sk),this.o.style.borderColor=this.Je===this.nf?this.Je:J.h("{0} {0} {0} {0}",this.Je,this.Je,this.nf,this.nf)):this.o.style.border="none";
this.o.tabIndex=this.Lb;this.o.addEventListener("keydown",function(d){c.Fx(d)});this.Ab.appendChild(this.o)},Fx:function(a){if(32===a.keyCode||13===a.keyCode){var b=null;a.stopPropagation();D.Tb()?b=new PointerEvent("pointerup"):b=new MouseEvent("mouseup");this.o.dispatchEvent(b)}},Xb:function(){return this.o},ee:function(a){this.pa=a},setRadius:function(a){this.vo=a},vR:function(a){this.sk=a},uR:function(a){this.Je=a},tR:function(a){this.nf=a},bf:function(a){this.Lb=a},sR:function(a){this.fr=a},
Nt:function(a){this.ta=a;this.o.id=this.ta},Sl:function(){return this.ta},remove:function(){if(null!==this.o){var a=this;this.o.removeEventListener("keydown",function(b){a.Fx(b)});this.o.parentElement===this.Ab&&this.Ab.removeChild(this.o)}},yC:function(){return null!==this.o?null!==this.o.parentElement:!1}};var Of;
Of=function(a,b){this.pa=a;this.fr=this.qj=!0;this.o=window.document.createElement("div");this.Ab=b.Oa.canvas.parentNode;this.vo=0;this.sk=1;this.nf=this.Je="#000000";this.Lb=-1;this.ta="";this.Vs=!1;this.ve="";this.hy=!0};
Of.prototype={i:function(a){a=a.Aj();var b=null,c=this;b=this.pa.Pb(a.X,a.Y);J.ab(this.o,b);this.Vs&&(this.o.style.position="relative",this.o.style.left="0px",this.o.style.top="0px");this.qj&&(this.o.style.background="transparent",this.o.style.color="transparent");this.o.style.border="none";this.o.tabIndex=this.Lb;this.Hd=document.createElement("input");this.Hd.type="checkbox";this.Hd.style.opacity="1";this.Hd.style.width="90%";this.Hd.style.height="90%";this.Hd.style.left="-5px";this.Hd.style.top=
"-2px";this.Hd.style.position="absolute";this.Hd.style.cursor="pointer";this.zf=document.createElement("div");this.zf.style.width="100%";this.zf.style.height="100%";this.zf.style.backgroundSize="contain";this.zf.style.backgroundRepeat="no-repeat";this.zf.style.borderRadius="4px";this.zf.style.cursor="pointer";this.hy?this.Hd.addEventListener("change",function(){c.Ex()}):(this.zf.style.opacity="0.4",this.zf.title=this.ve);this.o.appendChild(this.Hd);this.o.appendChild(this.zf);this.Ab.appendChild(this.o)},
Ex:function(){var a=new CustomEvent("checkboxChanged",{detail:{checked:this.Hd.checked}});this.o.dispatchEvent(a)},Xb:function(){return this.o},ee:function(a){this.pa=a},setRadius:function(a){this.vo=a},bf:function(a){this.Lb=a},Nt:function(a){this.ta=a;this.o.id=this.ta},Sl:function(){return this.ta},remove:function(){if(null!==this.o){var a=this;this.hy&&this.Hd.removeEventListener("change",function(){a.Ex()});this.o.parentElement===this.Ab&&this.Ab.removeChild(this.o)}},yC:function(){return null!==
this.o?null!==this.o.parentElement:!1}};var rf;rf=function(a,b,c){this.g=a;this.ta=b;this.m=c;this.ah=this.yr=this.nc=this.dc=null;this.Lb=Wa.J;this.sx="";this.Ky=1;this.Is=!1;this.wt=this.qb=-1;this.fl=null};
rf.prototype={i:function(a){if(null===this.ah){var b=a.g.ba().wa();if(null!==b&&(this.m=b.wc(),0===this.Ky?this.nc=b.getParent():(this.nc=b.P(),this.yr=b.S,this.m=new Bb(0,0,this.m.C(),this.m.B())),this.sx=b.dc.id,null!==this.nc)){var c=window.document.createElement("div");c.id="FTButtonElement_"+this.ta;0===this.Ky&&J.Lq(this.nc)&&(this.nc=b.P(),this.nc=window.document.body);this.nc.appendChild(c);this.dc=c}this.Me()}null!==this.ah&&this.ah.i(a)},P:function(){return this.dc},Sl:function(){return this.ta},
Me:function(){this.QH();var a=document.getElementById("FTButton_"+this.ta);if(null===a||void 0===a)this.TH(this.ta),this.SH(this.ta,this.m)},SH:function(a,b){var c=this;this.ah=this.ml(a,b);this.ah.Xb().addEventListener(D.Tb()?"pointerup":"mouseup",function(d){c.As(d,a)},!1);this.ah.Xb().addEventListener(D.Tb()?"pointerdown":"mousedown",function(d){c.As(d,a)},!1);this.ah.Xb().addEventListener(D.Tb()?"pointermove":"mousemove",function(d){c.As(d,a)},!1)},TH:function(a){var b=this;var c=window.document.createElement("input");
c.id="FTButtonFile_"+a;c.type="file";c.style.display="none";c.addEventListener("change",function(d){b.ZK(d,a)},!1);this.dc.appendChild(c)},QH:function(){if(null===this.dc){var a="FTButtonElement_"+this.ta;var b=document.getElementById(a);if(null===b||void 0===b)b=window.document.createElement("div"),b.id=a,a=window.document.body,null!==a&&void 0!==a&&(a.appendChild(b),this.nc=a);this.dc=b}},As:function(a,b){var c=1;var d=this.g.Ni.aw(b);null!==d&&(c=d.kP,1!==c&&2!==c&&6!==c&&(c=1));d=this.TA(a.type);
if("pointerup"===d){if(this.dN(a),1===c||6===c)this.Mz(b),this.g.Li.Mp(-123)}else"pointerdown"===d?(this.xI(a),2===c&&(this.Mz(b),this.g.Li.Mp(-123))):"pointermove"===d&&this.SK(a,b)},Mz:function(a){var b=document.getElementById("FTButtonFile_"+a),c=null,d=null,e=this;d=d=null;null!==b&&void 0!==b&&(c=this.g.Ni.aw(a),d=this.g.j,null!==c&&null===d&&(this.Is=!1,this.wt=0,this.zo(),this.fl=function(){e.aL()},window.addEventListener("focus",this.fl,!1),d=new Hd(null),d.sh=c.GC,d.Pk=c.WB,d.Tq=c.filters,
d.Mc=c.flags,d=c.stream?new Id(0,3,c.GC,"",d):new Id(a,1,c.lQ,"",d),d.bD=!0,d.status.Xe=!1,this.g.Tj(d),b.accept=Pf.h(c.WB,c.filters),b.click()))},ZK:function(a){this.Is=!0;Pf.l(a,this.g);this.zo()},aL:function(){var a=this;this.qb=window.setInterval(function(){a.qJ()},250)},qJ:function(){if(this.Is)this.zo();else if(this.wt++,3<this.wt){this.zo();var a=this.g.j;null!==a&&(a.status.Zb=md.l,N.info("File Transfer cancelled"))}},zo:function(){null!==this.fl&&(window.removeEventListener("focus",this.fl,
!1),this.fl=null);clearInterval(this.qb)},xI:function(a){this.Lr(a,"mousedown")},dN:function(a){this.Lr(a,"mouseup")},SK:function(a,b){this.Lr(a,"mousemove");this.xM(b)},Lr:function(a,b){a.preventDefault();a.stopPropagation();var c=null===this.yr?this.g.bb():this.yr;null!==c&&void 0!==c&&this.IL(b,c,a.pageX,a.pageY)},xM:function(a){a=document.getElementById("FTButton_"+a);null!==a&&void 0!==a&&(a.style.cursor="pointer")},ml:function(a,b){b=new Nf(b,this.g.V(),this.dc);b.Nt("FTButton_"+a);b.sR(!1);
b.bf(this.Lb++);return b},IL:function(a,b,c,d){var e={bubbles:!0,cancelable:"mousemove"!==a,view:window,detail:0,screenX:c,screenY:d,clientX:c,clientY:d,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:b};if(D.Tb()){a=this.TA(a);var f={};this.iK(f,e,b);f.pointerType="mouse";a=new PointerEvent(a,f)}else a=new MouseEvent(a,e);this.gI(a,c,d,b)},iK:function(a,b,c){a.isPrimary=!0;a.bubbles=b.bubbles;a.cancelable=b.cancelable;a.view=b.view;a.detail=b.detail;a.screenX=b.screenX;a.clientX=
b.clientX;a.screenY=b.screenY;a.clientY=b.clientY;a.ctrlKey=b.ctrlKey;a.altKey=b.altKey;a.shiftKey=b.shiftKey;a.metaKey=b.metaKey;a.button=b.button;a.relatedTarget=c;a.pointerId=-123},gI:function(a,b,c,d){Object.defineProperty(a,"layerX",{value:b});Object.defineProperty(a,"layerY",{value:c});a.button=1;a.which=1;d.dispatchEvent(a)},TA:function(a){switch(a){case "touchmove":case "mousemove":return"pointermove";case "touchup":case "mouseup":return"pointerup";case "touchdown":case "mousedown":return"pointerdown";
default:return a}}};var Qf;Qf=function(a,b,c){this.pa=a;this.Oc=12;this.On="";this.fc="HCENTER";this.Mb="VCENTER";this.Pc="";this.hh=this.uh=!1;this.Md=b;this.o=window.document.createElement("input");this.Ab=c.Oa.canvas.parentNode;this.oh=this.mg=null;this.Lb=-1;this.Os="";this.Zf="#FFFFFF";this.nb="#000000"};
Qf.prototype={i:function(a){var b=this.ih();a=a.Aj();b=b.Pb(a.X,a.Y);J.ab(this.o,b);this.o.style.zIndex=300;this.o.style.textAlign="HCENTER"===this.fc?"center":"RIGHT"===this.fc?"right":"left";this.o.style.fontFamily=this.Pc;this.o.style.fontSize=this.Oc+"px";this.uh&&(this.o.style.fontStyle="italic");this.hh&&(this.o.style.fontWeight="bold");this.Md?(b=document.getElementsByTagName("input"),0===b.length?(this.oh=window.document.createElement("input"),this.oh.type="text",this.oh.autocomplete="username",
this.oh.style.display="none",b=this.oh):b=b[0],this.mg=window.document.createElement("form"),this.o.type="password",this.o.autocomplete="current-password",this.mg.appendChild(b),this.mg.appendChild(this.o),this.Ab.appendChild(this.mg)):(this.o.autocomplete="username",this.Ab.appendChild(this.o));""!==this.Os&&(this.o.placeholder=this.Os);this.o.style.border="none";this.o.style.backgroundColor=this.Zf;this.o.style.color=this.nb;this.o.tabIndex=this.Lb},Xb:function(){return this.o},Ug:function(a,b){this.Pc=
a;this.Oc=b},im:function(a,b){this.fc=a;this.Mb=b},ee:function(a){this.pa=a},bf:function(a){this.Lb=a},tS:function(a){this.Os=a},Rj:function(a){this.Zf=a},setColor:function(a){this.nb=a},remove:function(){null!==this.mg?(null!==this.oh&&this.mg.removeChild(this.oh),null!==this.o&&this.mg.removeChild(this.o),this.Ab.removeChild(this.mg)):null!==this.o&&this.o.parentElement===this.Ab&&this.Ab.removeChild(this.o)},ih:function(){var a=this.pa.u+3,b=this.pa.Z-9,c,d=J.Vf(this.Oc);"BOTTOM"===this.Mb?c=this.pa.da-
d-9:c="VCENTER"===this.Mb?this.pa.v+(this.pa.B()-d)/2:this.pa.v+1;return new Bb(a,c,b,c+d)}};var Rf;Rf=function(a){this.m=a;this.lr=!0};Rf.prototype=Object.create(Hb.prototype);Rf.prototype.constructor=Rf;var Sf;Sf=function(a,b){this.pa=a;this.Oc=12;this.On="";this.fc="HCENTER";this.Mb="VCENTER";this.Pc="";this.hh=this.uh=!1;this.o=window.document.createElement("select");this.Ab=b.Oa.canvas.parentNode;this.Lb=-1;this.Zf="#FFFFFF";this.nb="#000000";this.cz=[];this.wA=""};
Sf.prototype={i:function(a){var b=this.ih(),c=this;a=a.Aj();b=b.Pb(a.X,a.Y);J.ab(this.o,b);this.o.style.zIndex=300;this.o.style.textAlign="HCENTER"===this.fc?"center":"RIGHT"===this.fc?"right":"left";this.o.style.fontFamily=this.Pc;this.o.style.fontSize=this.Oc+"px";this.uh&&(this.o.style.fontStyle="italic");this.hh&&(this.o.style.fontWeight="bold");this.cz.forEach(function(d){var e=window.document.createElement("option");e.value=d;e.text=d;e.selected=c.wA.toUpperCase()===d.toUpperCase()?!0:!1;c.o.appendChild(e)});
this.Ab.appendChild(this.o);this.o.style.border="none";this.o.style.backgroundColor=this.Zf;this.o.style.color=this.nb;this.o.tabIndex=this.Lb},Xb:function(){return this.o},Ug:function(a,b){this.Pc=a;this.Oc=b},im:function(a,b){this.fc=a;this.Mb=b},ee:function(a){this.pa=a},bf:function(a){this.Lb=a},Rj:function(a){this.Zf=a},setColor:function(a){this.nb=a},eS:function(a){this.cz=a},UD:function(a){this.wA=a},remove:function(){null!==this.o&&this.o.parentElement===this.Ab&&this.Ab.removeChild(this.o)},
ih:function(){var a=this.pa.u+3,b=this.pa.Z-9,c,d=J.Vf(this.Oc);"BOTTOM"===this.Mb?c=this.pa.da-d-9:c="VCENTER"===this.Mb?this.pa.v+(this.pa.B()-d)/2:this.pa.v+1;return new Bb(a,c,b,c+d)}};var Tf;Tf=function(a,b){this.pa=a;this.Oc=12;this.fc="HCENTER";this.Mb="VCENTER";this.Pc="";this.hh=this.uh=!1;this.o=window.document.createElement("div");this.dh=null;this.Ab=b.Oa.canvas.parentNode;this.Lb=-1;this.Zf="#FFFFFF";this.nb="#000000";this.Bt=this.na="";this.Hz=!0};
Tf.prototype={i:function(a){var b=this.ih();a=a.Aj();b=b.Pb(a.X,a.Y);J.ab(this.o,b);this.o.style.zIndex=300;this.o.style.textAlign="HCENTER"===this.fc?"center":"RIGHT"===this.fc?"right":"left";this.o.style.fontFamily=this.Pc;this.o.style.fontSize=this.Oc+"px";this.uh&&(this.o.style.fontStyle="italic");this.hh&&(this.o.style.fontWeight="bold");""!==this.Bt?(this.dh=window.document.createElement("a"),this.dh.innerText=this.na,this.dh.href=this.Bt,this.Hz&&(this.dh.target="_blank"),this.o.appendChild(this.dh)):
this.o.innerText=this.na;this.Ab.appendChild(this.o);this.o.style.backgroundColor=this.Zf;this.o.style.color=this.nb;this.o.tabIndex=this.Lb},Xb:function(){return this.o},US:function(a,b){this.Bt=a;this.Hz=b},Ug:function(a,b){this.Pc=a;this.Oc=b},im:function(a,b){this.fc=a;this.Mb=b},ee:function(a){this.pa=a},bf:function(a){this.Lb=a},Rj:function(a){this.Zf=a},setColor:function(a){this.nb=a},Rb:function(a){this.na=a},remove:function(){null!==this.o&&(null!==this.dh.href&&this.o.removeChild(this.dh),
this.Ab.removeChild(this.o))},ih:function(){var a=this.pa.u+3,b=this.pa.Z-9,c,d=J.Vf(this.Oc);"BOTTOM"===this.Mb?c=this.pa.da-d-9:c="VCENTER"===this.Mb?this.pa.v+(this.pa.B()-d)/2:this.pa.v+1;return new Bb(a,c,b,c+d)}};var Uf;Uf=function(a,b,c){this.xz=a.map(function(d){return d.toLowerCase()});this.yz=b.map(function(d){return d.toLowerCase()});this.qf=c};
Uf.prototype={ZO:function(a){a=a.toLowerCase();if(0===this.qf)return null;var b=this.xz.indexOf(a);if(-1!==b)return this.yz[b];b=this.yz.indexOf(a);return-1!==b?this.xz[b]:null}};var Kb;Kb=function(a,b){a=b.getUint16();this.Vk=b.ha(a,!1);this.If=b.getUint16()};Kb.prototype={i:function(a){a=a.g.Kb;null!==a&&(a.dS(this.Vk),a.RD(this.If))}};var Jb;Jb=function(a,b){this.UK=b.getUint32()};Jb.prototype={i:function(a){a.g.Kb.FD(this.UK)}};var Mb;Mb=function(a,b){this.vz=[];this.wz=[];this.If=this.Vr=0;this.KL(b)};
Mb.prototype={i:function(a){a=a.g.Kb;null!==a&&(a.PS(new Uf(this.vz,this.wz,this.Vr)),a.RD(this.If))},KL:function(a){var b;this.Vr=a.getUint16();for(b=0;b<this.Vr;b++){var c=a.getUint16();this.vz.push(a.ha(c,!1));c=a.getUint16();this.wz.push(a.ha(c,!1))}this.If=a.getUint16()}};var Lb;Lb=function(a,b){a=b.getUint16();this.Ko=b.ha(a,!1)};Lb.prototype={i:function(a){a=a.g.Kb;null!==a&&a.RS(this.Ko)}};var ne;
ne=function(a,b){this.Bc=b.getUint16();this.ka=b.getUint16();this.qa=b.getUint16();this.pb=b.getUint32();this.fE=1};ne.prototype={i:function(a){var b=null,c=J.wm(this.ka-1,this.qa-1).getContext("2d");c.fillStyle="white";c.fillRect(0,0,this.ka-1,this.qa-1);this.pb&this.fE&&(b=J.wm(this.ka-1,this.qa-1).getContext("2d"),b.fillStyle="white",b.fillRect(0,0,this.ka-1,this.qa-1));a.te.CN(this.Bc,new Qb(c,b,new Ja(this.ka,this.qa)))}};var oe;oe=function(a,b){this.Bc=b.getUint16()};
oe.prototype={i:function(a){a.te.NQ(this.Bc);a.g.ra.ya.oP(this.Bc)}};var re;re=function(a,b){this.YM=b.getUint32();this.cK=b.getUint16();this.Jn=b.getUint16();this.xs=!!b.getUint8();this.ys=!!b.getUint8();this.Gs=new I(b.getUint16(),b.getUint16())};re.prototype={i:function(a){var b=new pf(this.Jn,this.xs,this.ys,this.Gs);a.g.ra.ya.WO(this.YM).info().TD(this.cK,b)}};var pe;pe=function(a,b){this.Bc=b.getUint16()};pe.prototype={i:function(a){a.te.qQ(this.Bc)}};var qe;qe=function(a,b){this.Bc=b.getUint16()};
qe.prototype={i:function(a){var b=a.te.Np(a.te.Jt());!b.$i&&a.Eh&&b.fn.drawImage(b.Oa.canvas,0,0);b.$i||a.Eh||b.bS(!0);a.te.mQ()}};var me;me=function(){};me.prototype={i:function(a){var b=a.g.yb,c=a.ut,d;var e=Ga.F(2*c.count());var f=Cc.F(e,a.g.A.Ia);for(d=0;d<c.count();++d)f.Gc(c.vp(d));a=new Ba(519,a.g.A.ma,0,0);a.Qb(e);b.push(a)}};var fe;fe=function(){};
fe.prototype={i:function(a){var b=a.g.yb,c=a.Jo,d;var e=Ga.F(4*c.count());var f=Cc.F(e,a.g.A.Ia);for(d=0;d<c.count();++d)f.Gc(c.C(d)),f.Gc(c.B(d));a=new Ba(518,a.g.A.ma,0,0);a.Qb(e);b.push(a)}};var le;le=function(a,b){var c=b.getUint16();this.na=b.ha(c,52===a)};le.prototype={i:function(a){a.getContext().font=a.getState().Dj();a.ut.BN(this.na)}};var ee;ee=function(a,b){var c=b.getUint16();this.na=b.ha(c,34===a)};ee.prototype={i:function(a){a.getContext().font=a.getState().Dj();a.Jo.bB(this.na)}};var ke;
ke=function(a,b){b.getUint32();b.getUint32()};ke.prototype={i:function(a){a.ut.clear()}};var de;de=function(a,b){b.getUint32();b.getUint32()};de.prototype={i:function(a){a.Jo.clear()}};var Vf;Vf=function(a,b){this.UM=b.getUint32();this.ZG=b.getInt16();b.getInt16()};Vf.prototype={i:function(a){a.getContext().font=a.getState().Dj();a.Jo.bB(this.na,this.ZG,this.UM)}};var te;te=function(a,b,c){var d=b.getUint16();this.na=b.ha(d,!1);Vf.call(this,a,b,c)};te.prototype=Object.create(Vf.prototype);
te.prototype.constructor=te;var ue;ue=function(a,b,c){var d=b.getUint16();this.na=b.ha(d,!0);Vf.call(this,a,b,c)};ue.prototype=Object.create(Vf.prototype);ue.prototype.constructor=ue;var dc;dc=function(){this.Ew="";this.sm=Ua.l;this.Pm="";this.Gm=this.nq=!1;this.tq=Ua.l;this.pw=J.l();this.Vk="";this.If=0;this.zl=null};
dc.prototype={dS:function(a){this.Vk=a},RD:function(a){this.If=a},PS:function(a){this.zl=a},RS:function(a){this.Ew=a},FD:function(a){this.sm=a},xP:function(){return""!==this.Vk&&0!==this.If||null!==this.zl&&0!==this.zl.qf?!0:!1},gT:function(a){a?null===this.zl?this.Pm=location.protocol+"//"+this.Vk+":"+this.If:(a=this.zl.ZO(location.hostname),this.Pm=null!==a?location.protocol+"//"+a+":"+this.If:""):this.Pm=""}};var Wf;Wf=function(a,b){this.g=a;this.Nc=b};
Wf.prototype={i:function(){var a=this.g.La(),b=this.g.getConfiguration(),c=this.g.ib();c.Iu(b.PlcAddress,b.CommBufferSize,b.UseLocalHost);a.tb(c.kb(),this)},sb:function(a){a=(new ld(a,!0,this.g.Db.Cb)).kD();a instanceof Ta?(this.g.A.wq=a.wq,this.g.D(this.Nc,0)):this.g.error("Checking for demo mode failed (1): "+a)},Yo:function(){return!1},O:function(a){this.g.error("Checking for demo mode failed (2): "+a)},className:function(){return"CheckDemoModeState"}};var Xf;
Xf=function(a){this.g=a;this.zs=!0;this.xl=this.Ht=0};
Xf.prototype={i:function(){var a=this.g.La(),b=this.g.ib();b.vO();this.xl=J.l();a.tb(b.kb(),this,!1,!this.zs)},yj:function(){return!0},sb:function(){var a=J.l()-this.xl;this.zs?(this.Ht=a,this.zs=!1,this.g.D(this,0)):(N.h(J.h("Deriving post method difference: {0}ms data in body, {1}ms without",this.Ht,a)),a<this.Ht-20&&(N.l("POST requests will be sent with the data in header because this seems faster"),this.g.SD(!0)),this.g.D(new Yf(this.g),0))},O:function(){this.g.error("deriving the best post method failed")},
className:function(){return"DerivingPostMethodState"}};var Zf;Zf=function(a,b,c,d,e,f,g){void 0===g&&(g=null);this.g=a;this.Gh=b;this.Md=c;this.Pa=f;this.yl=e;this.rL=g;this.Xa=d;this.XA=new oa("utf-8");this.LA=!1};
Zf.prototype={i:function(){var a=this.g.La(),b=this.g.ib();N.l("DeviceLoginState, executing step: "+this.yl+", cryptType: "+this.Pa.Jc);2===this.Pa.Jc?0===this.yl?b.pO(this.Pa.Jc):b.qO(this.Gh,this.Md):0===this.yl?b.eu("","",0,this.Pa.Jc):b.eu(this.Gh,this.Md,this.rL.EF,this.Pa.Jc);a.tb(b.kb(),this)},QS:function(){this.LA=!0},sb:function(a){0===this.yl?this.aM(a):this.bM(a)},aM:function(a){var b=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).uQ(this.Pa.Jc,this.Xa);if(b instanceof fd)if(2===this.Pa.Jc){var c=
this;cd.J(b.FF).then(function(d){var e=b.GF,f=c.XA.encode(c.Md),g=Math.min(f.byteLength,60),k=new ArrayBuffer(60),l=new Uint8Array(k);f=new Uint8Array(f);var E=new Uint8Array(e);var u=Math.min(e.byteLength,60);for(e=0;60>e;e++)l[e]=0;for(e=0;e<g;e++)l[e]=f[e];for(e=0;e<u;e++)l[e]^=E[e];cd.l(d,k).then(function(ka){var ja=c.Gh;60<ja.length&&(ja=ja.substr(0,60));ja=c.XA.encode(ja);c.g.D(new Zf(c.g,ja,ka,c.Xa,1,c.Pa,b),0)},function(ka){c.O("DeviceLogin failed with the following error: "+ka)})},function(d){c.O("DeviceLogin failed with the following error: "+
d)})}else this.g.D(new Zf(this.g,this.Gh,this.Md,this.Xa,1,this.Pa,b),0);else this.O("DeviceLogin failed with the following error: "+b)},bM:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).vQ();var b=!1;a instanceof gd?(a.kc===Ua.h?b=!0:63===a.kc&&D.SE(this.g.getConfiguration())&&(b=!0),b?(this.Xa||(N.l("Successfully Logged in! DeviceSessionId: "+a.ff),this.g.A.ci=a.ff),this.g.A.iq=!1,63===a.kc&&(N.l("Successfully Logged with 'Change Password' set"),this.g.A.iq=!0),this.g.D(new $f(this.g),0)):25===
a.kc||63===a.kc?(25===a.kc?N.l("DeviceLogin failed with the following error: NO_ACCESS_RIGHTS"):N.l("DeviceLogin failed with the following error: ERR_CHANGE_PASSWORD"),this.Pa.Error=a.kc,this.Xa?(this.LA&&(this.Pa.Error=0),this.g.Bo(),this.g.Lm=this.Pa,this.g.D(new ic(this.g),0)):this.g.D(new wc(this.g,this.Pa,this.Xa,!1),0)):this.O("DeviceLogin failed with the following error: "+a.kc)):this.O("DeviceLogin failed with the following error: "+a.kc)},O:function(a){this.g.ac.Wh(!1);this.g.error("Login to the plc device failed: "+
a)},className:function(){return"DeviceLoginState Step: "+this.yl+" CryptType: "+this.Pa.Jc}};var Yf;Yf=function(a,b,c){void 0===b&&(b=D.WE(a.getConfiguration()));void 0===c&&(c=!1);this.g=a;this.dM=c;this.Xa=b;this.pg=null};
Yf.prototype={i:function(){var a=this.g.La(),b=this.g.ib();if(this.Xa){if(this.HL()){this.g.D(new wc(this.g,this.g.Lm,this.Xa,!0),0);this.g.Lm=null;return}b.sO(this.g)}else b.eu();a.tb(b.kb(),this)},ND:function(a){this.pg=a},sb:function(a){null!==a||this.dM?(a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).wQ(this.Xa),a instanceof hd?(this.g.A.AR(a.Jc),this.Xa?a.kc===Ua.h?(this.uA(a.ff),a.Error===Ua.h||18===a.Error?this.g.kC()||null!==this.pg?(a.Error=0,null===this.pg?this.pg=new wc(this.g,a,this.Xa,!1):this.pg instanceof
Zf&&(this.pg.Pa=a),this.g.D(this.pg,0),N.l("DeviceLoginState, Skipped")):(a=new Zf(this.g,"","",this.Xa,0,a),a.QS(),this.g.D(a,0)):this.O("DeviceSessionCreate failed with the following error: "+a.kc+" "+a.Error)):this.O("DeviceSessionCreate failed with the following error: "+a.kc):a.kc===Ua.h&&a.Jc===Ua.J?(this.uA(a.ff),this.g.D(new $f(this.g),0)):(N.l("Login failed. Probably credentials necessary; result: "+a.kc),this.g.D(new wc(this.g,a,this.Xa,!1),0))):this.O("DeviceSessionCreate failed with the following error: "+
a)):this.g.D(new Yf(this.g,!1,!0),0)},HL:function(){return!(this.pg instanceof Zf)&&this.g.kC()||null!==this.g.Lm},uA:function(a){N.l("Successfully Logged in! DeviceSessionId: "+a);this.g.A.ci=a},yj:function(){return this.Xa},O:function(a){this.g.error("Login to the plc device failed: "+a)},className:function(){return"DeviceSessionState NewServices: "+this.Xa}};var yc;yc=function(a){this.g=a};yc.prototype={i:function(){N.info("Trying to reconnect after error");this.g.D(new ic(this.g),0)},className:function(){return"ErrorState"}};
var wc;
(function(){var a=[["LoginVisuErr1","Authentication failed, try again"],["LoginVisuErr2","Change password at first login is not supported"],["LoginVisuErr3","Error during authentication"],["LoginVisuErr4","Maximum number of clients reached"],["LoginVisuErr5","Not enough memory in the PLC for new client"]];wc=function(b,c,d,e){void 0===e&&(e=!1);this.g=b;this.Pa=c;this.Xa=d;this.cj=this.dj=this.bo="";this.qe=null;this.oe=this.pe=this.fa=0;this.Hf=null;this.Kk=12;this.Pc="Arial";this.sg=this.Ff=this.Gf=
null;this.rg=[];this.Fs=this.qg=this.bh=this.Ef=null;this.tg=[];this.jr=this.Hs=!1;this.ie=this.Fd=4294967295;this.Dl=this.Oi=!1;this.gh="";this.Jr=!1;this.Ha=null;this.HA=0;this.md=!1;this.Ho="";this.yh=new Bb(0,0,0,0);this.wo=this.nl=0;this.Ue=1;this.Je="#909090";this.nf="#000000";this.Pi="#FFFFFF";this.Jk="#000000";this.Lb=Wa.l;this.VA=0;this.He=[];this.wk=0;this.$r=this.Pz=!1;this.Xk=this.Ah=this.hA=this.jz=null;this.pd=new ag(this.g);this.nx=0;this.Mn=e;""!==this.g.getConfiguration().LoginVisu.toLowerCase()&&
(this.Hb=this.g.ou(),""===this.Hb&&(this.Hb=this.g.getConfiguration().LoginVisuDefLang,""===this.Hb&&(this.Hb=D.Xv(),this.g.oD(this.Hb,!0,!1))))};wc.prototype={i:function(){switch(this.fa){case 0:this.KM();break;case 1:this.NM();break;case 2:this.JJ();break;case 3:this.PM();break;case 4:this.EJ();break;case 5:this.MM();break;case 6:this.OM();break;case 7:this.JM();break;case 8:this.LM();break;case 9:this.HM();break;case 10:this.IM();break;default:this.oo()}},sb:function(){},O:function(b,c){"number"===
typeof c&&c==$a.l&&(this.$m(),this.g.Wp(b,"Server connection lost."))},className:function(){return"QueryCredentialsState"},Up:function(b){this.Ho=b},qS:function(b){this.Gf=b},oS:function(b){this.Ff=b},nS:function(b){this.sg=b},Qp:function(b){this.He[this.wk]=b},vc:function(){return this.He[this.wk]},Yu:function(b){this.Hs=b},wR:function(b){this.jr=b},kS:function(b){this.Ef=b},lS:function(b){this.qg=b},jS:function(b){this.bh=b},pS:function(b,c){this.tg.push([b,c])},oC:function(b){var c;for(c=0;c<this.tg.length;c++)if(this.tg[c][0]===
b)return this.tg[c][1];return null},mS:function(b,c){null===this.sp(b)&&this.rg.push([b,c])},sp:function(b){var c;for(c=0;c<this.rg.length;c++)if(this.rg[c][0]===b)return this.rg[c][1];return null},Nh:function(){return this.Pc},Oh:function(){return this.Kk},Mh:function(){return this.Jk},Tl:function(){return this.Lb++},$O:function(){return this.VA++},OO:function(b,c){var d="";switch(b){case 25:b="LoginVisuErr1";break;case 63:b="LoginVisuErr2";break;case 248:b="LoginVisuErr4";break;case 247:b="LoginVisuErr5";
break;default:b="LoginVisuErr3"}var e=this.Xk;null===e&&(e=this.Ah);""!==c&&null!==e&&(c=e.OE(c,b),null!==c&&(d=c));if(""===d)for(c=0;c<a.length;c++)a[c][0]===b&&(d=a[c][1]);return d},Pg:function(b){this.He.push(b)},oQ:function(){this.He.pop()},Rh:function(b){return 0===this.yh.C()&&0===this.yh.B()?b:this.yh},rC:function(b,c){var d=this.nl;if(0>this.nl||0>this.wo)d=Math.max(1,Math.min(b,c)/8);return d},pm:function(b){this.g.oD(b,!1,!0)},nH:function(b,c){this.g.Ow&&(this.g.Ow=!1,this.g.ac.Wh(!1));
c=new bg(c);c.SF(b);this.qe=c.qe;null!==this.qe&&(this.pe=c.pe,this.oe=c.oe,this.ie=c.ie,this.Fd=c.Fd,this.gh=c.gh,this.Oi=c.Oi,this.Dl=c.Dl,N.h("Login page '"+this.bo+"' is availabe"));this.md=!0;this.g.D(this,0)},oH:function(b){this.Ah=new cg(this.g.getConfiguration().Hg());this.Ah.ew(b);this.Ah.rh&&(N.h("Localized texts file '"+this.dj+"' is availabe"),b=this.Ah.Qc,null!==b?N.h("Languages found: "+b.length):N.h("Languages found: 0"));this.md=!0;this.g.D(this,0)},mH:function(b){this.Xk=new cg(this.g.getConfiguration().Hg());
this.Xk.ew(b);this.Xk.rh&&(N.h("Localized Error texts file '"+this.cj+"' is availabe"),b=this.Xk.Qc,null!==b?N.h("Languages found: "+b.length):N.h("Languages found: 0"));this.md=!0;this.g.D(this,0)},kH:function(){this.$r?this.g.V().Nn?this.Pz?this.fa=8:(this.Pz=!0,this.Ao(!0),this.fa=7):(this.Ao(!0),this.fa=7):this.fa=8;this.g.D(this,0)},KM:function(){var b=this;this.bo=this.g.getConfiguration().LoginVisu.toLowerCase();this.fa=1;""===this.bo?(this.md=!0,this.g.D(this,0)):(this.md=!1,this.Or(function(c){b.nH(c,
b.g.A.Ia)},this.bo))},NM:function(){this.md&&(this.fa=2,this.g.D(this,0))},JJ:function(){var b=this;this.dj=this.g.getConfiguration().LoginVisuTexts.toLowerCase();this.fa=3;""===this.dj?(this.md=!0,this.g.D(this,0)):(this.md=!1,this.Or(function(c){b.oH(c)},this.dj))},PM:function(){this.md&&(this.fa=4,this.g.D(this,0))},EJ:function(){var b=this;this.cj=this.g.getConfiguration().LoginVisuErrorTexts.toLowerCase();this.fa=5;if(""===this.cj)this.md=!0;else if(this.cj.toUpperCase()===this.dj.toUpperCase())this.cj=
this.dj,this.md=!0;else{this.md=!1;this.Or(function(c){b.mH(c)},this.cj);return}this.g.D(this,0)},MM:function(){this.md&&(this.fa=6,this.HA=J.l(),this.g.D(this,0))},OM:function(){this.fa=7;0<this.gh.length&&!this.gK(this.gh)&&(this.fa=6,5E3<J.l()-this.HA&&(this.Ha=null,this.fa=7));this.g.D(this,0)},JM:function(){var b=this;if(null!==this.qe){if(null===this.Hf){var c=this.g.qc;null!==c&&c.detach();this.Hf=function(){b.Wq()};window.addEventListener("resize",this.Hf,!1)}this.Ao(!1);this.g.V().uB();this.g.V().rD();
this.g.V().jp(this.qe,function(){b.kH()},function(d){return b.Xm(d,!1)});this.pd.ef()}else this.oo()},LM:function(){this.yH();this.Hs&&(this.fa=10);this.jr&&(this.fa=9);this.g.D(this,0)},yH:function(){if(5E3<J.l()-this.nx){var b=this.g.La(),c=this.g.getConfiguration(),d=this.g.ib();this.nx=J.l();null!==c&&(d.Iu(c.PlcAddress,c.CommBufferSize,c.UseLocalHost),b.tb(d.kb(),this))}},HM:function(){var b=this.g.qc;null!==this.Hf&&(window.removeEventListener("resize",this.Hf,!1),this.Hf=null,null!==b&&b.Ll());
this.$m();this.g.Wp("The user did not provide credentials.","No credentials")},IM:function(){var b="",c="",d=this.g.qc;null!==this.Hf&&(window.removeEventListener("resize",this.Hf,!1),this.Hf=null,null!==d&&d.Ll());null!==this.Gf&&(b=this.Gf.Xb().value);null!==this.Ff&&(c=this.Ff.Xb().value);d=this.g.ac.bC();null!==d[0]?(b=d[0],c=d[1]):this.g.ac.Sh()&&(this.g.ac.$Q(b,c),this.g.Ow=!0);this.$m();this.g.fS(this.Hb);this.g.BD(!1);this.g.V().QR();this.Mn?(d=new Yf(this.g,this.Xa,!1),d.ND(new Zf(this.g,
b,c,this.Xa,0,new hd(0,0,0,0))),this.g.D(d,0)):(this.Pa.Error=0,this.g.D(new Zf(this.g,b,c,this.Xa,0,this.Pa),0))},Xm:function(b,c){var d=!1;this.wk=this.He.length=0;if(this.Jr){this.$r=this.Jr=!1;this.g.V().g.getConfiguration().SemiTransparencyActive=this.Dl;this.g.V().getState().gm();var e=new Bb(0,0,this.pe,this.oe);var f=new Mf(e,this.g.V());var g=this.Fd;this.g.getConfiguration().ScaleTypeIsotropic&&(!1===this.Oi?g=this.ie:(e=new Bb(0,0,document.documentElement.clientWidth,document.documentElement.clientHeight),
f.MR(e.C()/this.pe),f.NR(e.B()/this.oe)));f.nR(g);f.oR(this.Fd);f.pR(this.Ha);f.LR(this.Oi);this.Pg(new Rf(new Bb(0,0,1E4,1E4)));this.Pg(f);this.Pg(b);this.wk=2}else this.Pg(b),this.wk=0;b instanceof Cd?(d=new dg(this.g,this.Pa,this),d.JE(b,c)):b instanceof td?(this.yh=b.wc(),this.Ue=1,this.Je=b.SO(),this.nf=b.JO(),this.nl=this.wo=-1):b instanceof yd?(this.Fs=b,this.yh=b.wc(),0===b._type&&(this.nl=this.wo=-1)):b instanceof Xd?(this.Kk=b.Oh(),this.Pc=b.Nh(),this.Jk=b.Mh()):b instanceof ef?(this.Kk=
b.Oh(),this.Pc=b.Nh(),this.Jk=b.Mh()):b instanceof ve?(this.nl=b.AC,this.wo=b.BC):b instanceof Wd?(this.Ue=b.C(),this.Je=this.nf=b.mp()):b instanceof Vd?this.Pi=b.mp():b instanceof Cb&&(e=this.g.getConfiguration().LoginVisuNamespace,c=b.xf,"__VisualizationStyle.CheckboxUnchecked"===c&&(d=!0),""!==e&&2>=c.split(".").length&&(e+=".",D.Bb(c,e)||b.aS(e+c)),d?(this.yh=b.Nv(),this.oQ()):(b.DC(this.g.V().Qk,this.g.V().kg),this.yh=b.Nv(),this.$r=!0));this.hA=this.jz;this.jz=b;return this.He},$m:function(){null!==
this.Gf&&(this.Gf.remove(),this.Gf=null);null!==this.Ff&&(this.Ff.remove(),this.Ff=null);null!==this.sg&&(this.sg.remove(),this.sg=null);null!==this.Ef&&(this.Ef.remove(),this.Ef=null);null!==this.qg&&(this.qg.remove(),this.qg=null);null!==this.bh&&(this.bh.remove(),this.bh=null);var b;for(b=0;b<this.tg.length;b++)null!==this.tg[b][1]&&this.tg[b][1].remove();this.tg=[];for(b=0;b<this.rg.length;b++)null!==this.rg[b][1]&&this.rg[b][1].remove();this.rg=[];this.jr=this.Hs=!1},Ao:function(b){this.Jr=!0;
this.Lb=Wa.l;this.VA=0;b&&this.$m();this.eH()},Or:function(b,c){var d=new XMLHttpRequest;d.open("GET",c,!0);d.responseType="arraybuffer";d.timeout=5E3;d.onreadystatechange=function(){d.readyState===XMLHttpRequest.DONE&&(200===d.status?b(d.response):b(null))};d.send()},eH:function(){this.g.V().iu(1);if(this.g.getConfiguration().BestFit){var b=this.g.V().Qf();if(!1===this.g.getConfiguration().ScaleTypeIsotropic){var c=b.C()/this.pe;b=b.B()/this.oe;this.g.V().OR()}else{var d=new Bb(0,0,0,0);var e=b.C()+
1;var f=b.B()+1;b=e/2;c=f/2;var g=this.pe/this.oe;g<e/f?(e=f*this.pe/this.oe,d.v=0,d.u=b-e/2):(f=e*this.oe/this.pe,d.v=c-f/2,d.u=0);d.Z=d.u+e;d.da=d.v+f;c=d.C()/this.pe;b=d.B()/this.oe;c<=b?b=c:c=b;this.g.V().FS(d);this.g.V().PR()}this.g.V().GS(c);this.g.V().HS(b)}},Wq:function(){var b=this;setTimeout(function(){b.Ls()},50)},Ls:function(){if(null!==this.Ef&&this.Ef.yC()){if(this.pd.Qv()){var b=this;this.Ao(!0);this.g.V().jp(this.qe,function(){},function(c){return b.Xm(c,!0)})}this.pd.ef()}},gK:function(b){var c=
this.g.V().Qk;var d=this.g.V().kg;if(null===this.Ha){if(c.VC())return this.Ha=c.Ej("ImageByImagePoolId?id="+b,!1),this.Ha.Lg();d=d.Qh(b);if(null!==d)return this.Ha=c.Ej(d,!1),this.Ha.Lg();N.warn("Imagepoolentry for "+b+" not found");return!0}return this.Ha.Lg()},oo:function(){(new eg(this.g,this.Pa,this.Xa,this.Mn)).FE()}}})();var fg;fg=function(a){this.g=a;this.Cr=""};
fg.prototype={i:function(){var a=this,b;for(b=document.getElementById("cas-script");null!==b;)b.parentNode.removeChild(b),b=document.getElementById("cas-script");b=document.createElement("script");b.id="cas-script";b.onload=function(){a.Nl()};b.onerror=function(c){a.O(c)};window.onerror=function(c){a.O(c)};b.src=this.g.getConfiguration().CasFactoryName;document.head.appendChild(b)},Nl:function(){""===this.Cr&&this.Fc()},O:function(a){this.Cr="Loading the automation server helper script failed for the following reason: "+
a+".";this.g.error(this.Cr)},Fc:function(){this.g.D(new gg(this.g),0)},className:function(){return"RetrievingAutomationServerScriptState"}};var ic,hg;hg=function(){};hg.Na=function(a){return Ka.Na(a)};hg.J=function(a){a=parseInt(a,10);if(0===a||1===a||2===a)return a;N.info("Unexpected value at the URL configured; only 0..2 are allowed so falling back to default value");return 0};hg.h=function(a){return parseInt(a,10)};
hg.l=[{Ba:"HandleTouchEvents",Ga:"CFG_HandleTouchEvents",type:"boolean",Ca:hg.Na},{Ba:"TouchHandlingActive",Ga:"CFG_TouchHandlingActive",type:"boolean",Ca:hg.Na},{Ba:"BestFit",Ga:"CFG_BestFit",type:"boolean",Ca:hg.Na},{Ba:"BestFitForDialogs",Ga:"CFG_BestFitForDialogs",type:"boolean",Ca:hg.Na},{Ba:"LogLevel",Ga:"CFG_LogLevel",type:"string",Ca:null},{Ba:"Benchmarking",Ga:"CFG_Benchmarking",type:"boolean",Ca:hg.Na},{Ba:"WorkaroundDisableMouseUpDownAfterActiveTouch",Ga:"CFG_WorkaroundDisableMouseUpDownAfterActiveTouch",
type:"boolean",Ca:hg.Na},{Ba:"WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch",Ga:"CFG_WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch",type:"number",Ca:hg.h},{Ba:"WorkaroundDisableResizeHandling",Ga:"CFG_WorkaroundDisableResizeHandling",type:"boolean",Ca:hg.Na},{Ba:"WorkaroundDisableSVGAspectRatioWorkaround",Ga:"CFG_WorkaroundDisableSVGAspectRatioWorkaroundg",type:"boolean",Ca:hg.Na},{Ba:"WorkaroundDisableSVGEmptySizeWorkaround",Ga:"CFG_WorkaroundDisableSVGEmptySizeWorkaround",type:"boolean",
Ca:hg.Na},{Ba:"WorkaroundForceSVGEmptySizeWorkaround",Ga:"CFG_WorkaroundForceSVGEmptySizeWorkaround",type:"boolean",Ca:hg.Na},{Ba:"PostDataInHeader",Ga:"CFG_PostDataInHeader",type:"number",Ca:hg.J},{Ba:"DebugOnlyPrintPaintCommands",Ga:"CFG_DebugOnlyPrintPaintCommands",type:"boolean",Ca:hg.Na},{Ba:"DebugHTML5",Ga:"CFG_DebugHTML5",type:"boolean",Ca:hg.Na},{Ba:"DebugOnlyPrintRawTouches",Ga:"CFG_DebugOnlyPrintRawTouches",type:"boolean",Ca:hg.Na},{Ba:"DebugOnlyPrintGestures",Ga:"CFG_DebugOnlyPrintGestures",
type:"boolean",Ca:hg.Na},{Ba:"DebugOnlyPrintTouchRectangles",Ga:"CFG_DebugOnlyPrintTouchRectangles",type:"boolean",Ca:hg.Na},{Ba:"DebugOnlyDiagnosisDisplay",Ga:"CFG_DebugOnlyDiagnosisDisplay",type:"boolean",Ca:hg.Na},{Ba:"DebugOnlyInputReactionOnUp",Ga:"CFG_DebugOnlyInputReactionOnUp",type:"boolean",Ca:hg.Na},{Ba:"DebugOnlyInputReactionExplCoord",Ga:"CFG_DebugOnlyInputReactionExplCoord",type:"boolean",Ca:hg.Na},{Ba:"DefaultConfigurationOnError",Ga:"CFG_DefaultConfigurationOnError",type:"boolean",
Ca:hg.Na},{Ba:"KeysForWebVisu",Ga:"CFG_KeysForWebVisu",type:"string",Ca:null},{Ba:"MaxResizePixel",Ga:"CFG_MaxResizePixel",type:"number",Ca:hg.h},{Ba:"TouchContextMenuEnabled",Ga:"CFG_TouchContextMenuEnabled",type:"boolean",Ca:hg.Na},{Ba:"ContextMenuDisabled",Ga:"CFG_ContextMenuDisabled",type:"boolean",Ca:hg.Na},{Ba:"WebSocketsDisabled",Ga:"CFG_WebSocketsDisabled",type:"boolean",Ca:hg.Na},{Ba:"WebSocketConnectTimeout",Ga:"CFG_WebSocketConnectTimeout",type:"number",Ca:hg.h},{Ba:"WebSocketKeepAliveInterval",
Ga:"CFG_WebSocketKeepAliveInterval",type:"number",Ca:hg.h},{Ba:"WebSocketsFallbackDisabled",Ga:"CFG_WebSocketsFallbackDisabled",type:"boolean",Ca:hg.Na},{Ba:"ClientName",Ga:"ClientName",type:"string",Ca:null}];ic=function(a){this.g=a};
ic.prototype={i:function(){var a=this.g.La();var b=window.document.URL;b=b.substr(0,b.lastIndexOf("."));a.Au(b+".cfg.json",this)},Nl:function(a){try{var b=this.AL(a);this.oI(b);this.Zz(b);this.g.setConfiguration(b);this.II(b);this.Fc()}catch(c){this.O(c)}},oI:function(a){if(a.TouchHandlingActive){var b=D.XE();b||(a.TouchHandlingActive=b,N.info("No multitouch support detected, therefore disabling multitouch for this client."))}},Zz:function(a){var b;for(b=0;b<hg.l.length;++b){var c=hg.l[b];var d=Ka.zm(this.g.Ag,
c.Ga);null!==d&&(d=null!==c.Ca?c.Ca(d):d,a[c.Ba]=d,N.info("Overridden Config Entry: "+c.Ba+" = "+d))}},AL:function(a){try{var b=JSON.parse(a),c=new Configuration,d;for(d in b)void 0!==d&&(c[d]=b[d]);c.validate();return c}catch(e){return this.og(e),new Configuration}},O:function(a){var b=this.g.getConfiguration();null===b&&(b=new Configuration,this.Zz(b));b.DefaultConfigurationOnError?(this.og(a),this.g.setConfiguration(new Configuration),this.Fc()):this.g.error(a)},Fc:function(){this.g.getConfiguration().CasFactoryName?
this.g.D(new fg(this.g),0):this.g.D(new gg(this.g),0)},og:function(a){N.error("Loading the configuration failed for the following reason: "+a+". A default config will be used instead.")},className:function(){return"RetrievingConfigurationState"},II:function(a){N.l("Configuration:");for(var b in a)a.hasOwnProperty(b)&&N.l(J.h(" - {0}: {1}",b,a[b]));a.Benchmarking&&N.info("Benchmarking active")}};var ig;ig=function(a){this.g=a};
ig.prototype={i:function(){var a=this.g.La(),b=this.g.ib();b.VQ();a.tb(b.kb(),this)},yj:function(){return!0},sb:function(a){null!==a&&(a=(new ld(a,!0,this.g.Db.Cb)).AQ(),""!==a&&(this.g.A.Aq=a));this.g.D(this.jI(),0)},jI:function(){if(this.g.A.dG){if(0===this.g.getConfiguration().PostDataInHeader)return new Xf(this.g);1===this.g.getConfiguration().PostDataInHeader&&(N.info("POST-Data in header active by override"),this.g.SD(!0))}1===this.g.getConfiguration().PostDataInHeader&&N.warn("POST-Data in header active by override but not supported by Webserver");
return new Yf(this.g)},O:function(a){this.g.error("Retrieving IP Info failed: "+a)},className:function(){return"RetrievingMyIpState"}};var jg;jg=function(a){this.g=a};
jg.prototype={i:function(){var a=this.g.La(),b=this.g.getConfiguration(),c=this.g.ib();c.Iu(b.PlcAddress,b.CommBufferSize,b.UseLocalHost);a.tb(c.kb(),this)},yj:function(){return!0},sb:function(a){null===a?this.g.D(this,this.g.getConfiguration().PollingRegistrationInterval):(a=(new ld(a,!0,this.g.Db.Cb)).kD(),a instanceof Ta?(N.l("Successfully connected! SessionId: "+a.ff+" IntelByteOrder: "+a.Ia),this.g.yR(a),this.g.Rc?this.g.D(new $f(this.g),0):this.g.D(new ig(this.g),0)):this.g.error("Connection failed: "+
a))},O:function(a){this.g.error("Starting to connect failed: "+a)},className:function(){return"StartConnectState"}};var kg;kg=function(a){this.g=a};
kg.prototype={i:function(){var a=this.g.La(),b=this.g.getConfiguration();a.Au(J.Fq((b.Application+".nativeelements.json").toLowerCase()),this)},Nl:function(a){try{this.g.ic.fill(a)}catch(b){this.og(b)}this.Fc()},O:function(a){this.og(a);this.Fc()},Fc:function(){this.g.D(new jg(this.g),0)},og:function(a){N.error("Loading the native element list failed for the following reason: "+a+". Native elements will not work at all.")},className:function(){return"UpdateNativeElementsState"}};var gg;
gg=function(a){this.g=a};gg.prototype={i:function(){var a=this.g.La(),b=this.g.getConfiguration();a.Au(J.Fq((b.Application+".imagepoolcollection.csv").toLowerCase()),this)},Nl:function(a){try{this.g.V().kg.fill(a)}catch(b){this.og(b)}this.Fc()},O:function(a){this.og(a);this.Fc()},Fc:function(){this.g.D(new kg(this.g),0)},og:function(a){N.error("Loading the imagepool failed for the following reason: "+a+". Images will not work at all.")},className:function(){return"UploadImagePoolState"}};var Pf;
Pf=function(a,b){this.g=a;this.Nc=b;this.j=this.g.j};
Pf.prototype={i:function(){if(null===this.j)this.g.D(this.Nc,0);else{if(3===this.j.direction){var a=J.l();if(a-this.j.yD<this.g.getConfiguration().UpdateRate){this.g.D(this.Nc,0);return}}if(this.j.status.Zb===md.l){var b=db.ab;3===this.j.direction&&(b=db.xa);b=new Ba(b,this.g.A.ma,0,1);this.g.Tj(null);this.g.D(this.Nc,0);this.g.yb.push(b)}else if(this.j.status.Zb===md.h)3!==this.j.direction&&(b=this.XH(this.j)),this.g.Tj(null),this.g.D(this.Nc,0),3!==this.j.direction&&this.g.yb.push(b);else if(1!==
this.j.direction&&0!==this.j.direction||this.j.status.result===Ua.h&&!this.j.status.we||this.j.status.Zb===md.ab){if(1===this.j.direction||3===this.j.direction){if(this.j.status.Xe){this.j.status.Xe=!1;this.oo(this.j);this.g.D(this.Nc,0);return}if(1===this.j.direction){if(this.j.status.Zb!==md.Sb&&(this.j.status.Wd||this.j.status.xe)){b=this.g.La();a=this.g.ib();this.j.status.Wd?(0<(this.j.Kc.Mc&4)&&this.PD(this.j),0<(this.j.Kc.Mc&8)?(a.gO(this.j),this.j.status.Zb=md.J):a.EB(this.j)):this.j.status.xe&&
a.DB(this.j);b.tb(a.kb(),this);return}}else if(this.j.status.Wd||this.j.status.xe){null!==this.j.Ob&&(window.document.body.removeChild(this.j.Ob),this.j.Ob=null);this.j.status.Wd?(this.PD(this.j),b=this.WH(this.j),this.j.status.Wd=!1,this.j.status.xe=!0,this.g.yb.push(b),b=new Ba(532,this.g.A.ma,this.j.buffer.size(),0)):b=this.VH(this.j);this.g.D(this.Nc,0);this.g.yb.push(b);this.j.yD=J.l();return}}else if(0===this.j.direction){if(this.j.status.Xe||this.j.status.xe){b=this.g.La();a=this.g.ib();this.j.status.Xe?
a.EB(this.j):this.j.status.xe&&a.DB(this.j);b.tb(a.kb(),this);return}}else if(2===this.j.direction){if(this.j.status.Xe){this.j.status.Xe=!1;b=this.UH(this.j);this.g.D(this.Nc,0);this.g.yb.push(b);return}if(this.j.status.we&&this.j.status.Zb!==md.h){b=D.Zv();this.g.D(this.Nc,b);this.uD(this.j);return}}this.g.D(this.Nc,0)}else b=this.g.La(),a=this.g.ib(),a.hO(this.j),b.tb(a.kb(),this),this.j.status.we=!0,this.j.status.Zb=md.ab,this.j.status.result!==Ua.h&&(this.j.status.Zb=md.h)}},sb:function(a){var b=
!1;null!==a||0!==this.j.direction&&1!==this.j.direction?(a=new ld(a,this.g.A.Ia,this.g.Db.Cb),this.j.status.we&&this.j.status.Zb!==md.h?(b=D.Zv(),a.xQ(this.j),this.g.D(this.Nc,b),this.uD(this.j)):(0===this.j.direction?this.j.status.Xe?(this.j.status.Xe=!1,a.Ou(this.j),this.j.status.result===Ua.h&&(this.j.status.xe=b=!0)):this.j.status.xe&&a.jD(this.j):this.j.status.Zb===md.J?(this.j.status.Xe=!1,a.Ou(this.j),this.j.status.result===Ua.h&&0<this.j.li.Be?(null!==this.j.Ob&&window.document.body.removeChild(this.j.Ob),
this.j.status.Zb=md.Sb,this.pL(this.j)):(this.j.status.result=0,this.j.status.Zb=md.xa,this.j.status.Wd=!0,this.j.Kc.Mc=this.j.Kc.Mc&-5,this.j.Kc.Mc&=-9)):this.j.status.Wd?(a.Ou(this.j),this.j.status.Wd=!1,this.j.status.result===Ua.h?this.j.status.xe=b=!0:(null!==this.j.Ob&&window.document.body.removeChild(this.j.Ob),this.j.Ob=null)):this.j.status.xe&&a.jD(this.j),this.g.D(this.Nc,0),b&&(a=new Ba(db.ab,this.g.A.ma,this.j.zv,this.j.status.result),this.g.yb.push(a),1===this.j.direction&&(null!==this.j.Ob&&
window.document.body.removeChild(this.j.Ob),this.j.Ob=null)))):(null!==this.j.Ob&&(window.document.body.removeChild(this.j.Ob),this.j.Ob=null),a=new Ba(528,this.g.A.ma,this.j.zv,7),this.g.Tj(null),this.g.D(this.Nc,0),this.g.yb.push(a))},yj:function(){return!0},PD:function(a){var b,c;var d=a.Vh.split("/");var e=a.iD.split("/");if(0<d.length&&0<e.length){for(c=0;c<d.length-1;++c)0===c?b=d[c]:b=b+"/"+d[c];void 0!==b?b=b+"/"+e[e.length-1]:b=e[e.length-1];a.Vh=b}},uD:function(a){var b=null,c=this.oO();
null===a.buffer||0!==a.direction&&2!==a.direction||(b=a.buffer.Zd());null!==this.j.Ob&&window.document.body.removeChild(a.Ob);a.status.Zb=md.h;null!==b&&a.status.result===Ua.h&&(b=new Blob([b],{type:"application/octet-binary"}),a=a.Vh,a=a.split("/"),a=a[a.length-1],c?this.uO(b,a):this.download(b,a))},uO:function(a,b){window.navigator.msSaveBlob(a,b)},oO:function(){var a=window.navigator.userAgent,b=a.indexOf("Trident/");return 0<a.indexOf("MSIE ")?!0:0<b?!0:!1},download:function(a,b){var c=window.document.createElement("a");
c.setAttribute("href",window.URL.createObjectURL(a));c.setAttribute("download",b);window.document.createEvent?(a=document.createEvent("MouseEvents"),a.initEvent("click",!0,!0),c.dispatchEvent(a)):c.click()},Yo:function(){return!0},O:function(a){this.g.error("Error while processing the visualization: "+a)},className:function(){return"VisuFileTransferState"},dn:function(a){var b=window.document.createElement("p");b.textContent=a;return b},Me:function(a,b,c){var d=window.document.createElement("input");
d.className="fileTransferButton";d.type=b;null!==a?d.value=a:(d.style.display="none",null!==c&&null!==c.Kc&&0<c.Kc.Pk&&(d.accept=Pf.h(c.Kc.Pk,c.Kc.Tq)));return d},oo:function(a){var b=window.document.createElement("div"),c=window.document.createElement("div"),d=window.document.createElement("div"),e=window.document.createElement("div"),f=window.document.createElement("div"),g=this.Me(null,"file",a),k=this.Me("Browse...","button",a);a=this.Me("Cancel","button",a);var l=this.dn("Choose file to transfer..."),
E=this.dn("File Transfer"),u=this;b.id="visuFileTransfer";b.className="fileTransferDialog";c.className="fileTransferDialogContent";d.className="fileTransferDialogHeader";e.className="fileTransferDialogBody";f.className="fileTransferDialogFooter";g.addEventListener("change",function(ka){u.RJ(ka,b)},!1);a.addEventListener("click",function(){u.Ch(b)},!1);k.addEventListener("click",function(){g.click()},!1);d.appendChild(E);e.appendChild(l);f.appendChild(g);f.appendChild(a);f.appendChild(k);c.appendChild(d);
c.appendChild(e);c.appendChild(f);b.appendChild(c);window.document.body.appendChild(b);this.j.Ob=b},pL:function(a){a.bD?window.confirm("The file already exists in the plc.\nDo you want to overwrite the file?")?this.Nz(null):this.Ch(null):this.qL(a)},qL:function(a){var b=window.document.createElement("div"),c=window.document.createElement("div"),d=window.document.createElement("div"),e=window.document.createElement("div"),f=window.document.createElement("div"),g=this.Me("Ok","button",a);a=this.Me("Cancel",
"button",a);var k=this.dn("The file already exists in the plc.\nDo you want to overwrite the file?"),l=this.dn("File Transfer"),E=this;b.id="visuFileTransfer";b.className="fileTransferDialog";c.className="fileTransferDialogContent";d.className="fileTransferDialogHeader";e.className="fileTransferDialogBody";f.className="fileTransferDialogFooter";a.addEventListener("click",function(){E.Ch(b)},!1);g.addEventListener("click",function(){E.Nz(b)},!1);d.appendChild(l);e.appendChild(k);f.appendChild(a);f.appendChild(g);
c.appendChild(d);c.appendChild(e);c.appendChild(f);b.appendChild(c);window.document.body.appendChild(b);this.j.Ob=b},RJ:function(a){Pf.l(a,this.g)},mx:function(a,b){var c=this.g.V().Qf();return new I((c.u+c.Z-a)/2,(c.v+c.da-b)/2)},Ch:function(a){var b=this.g.j;null!==b&&(b.status.Zb=md.l);null!==a&&window.document.body.removeChild(a)},Nz:function(a){null!==this.g.j&&(this.j.status.Zb=md.xa,this.j.Kc.Mc=this.j.Kc.Mc&-5,this.j.Kc.Mc&=-9);null!==a&&(window.document.body.removeChild(a),this.j.Ob=null)},
cn:function(a){var b=null;"utf-8"===this.g.getConfiguration().ANSIStringEncoding&&(b=this.g.getConfiguration().wd());return Cc.F(a,!0,b)},XH:function(a){var b=this.g.A.CommBufferSize-2E3;var c=Ga.F(b+4);var d=this.cn(c);var e=d.jb(a.Vh,!1);b=e.length();d.jc(e);a=new Ba(528,this.g.A.ma,a.zv,a.status.result);0<b&&a.Qb(c);return a},VH:function(a){var b=0;var c=this.g.A.CommBufferSize-2E3,d=Ga.F(c+4),e=this.cn(d),f;a.buffer.size()-a.status.ai<c&&(c=a.buffer.size()-a.status.ai,a.status.Zb=md.h,b=1);e.K(c);
for(f=0;f<c;f++)e.Ua(a.buffer.getUint8());b=new Ba(530,this.g.A.ma,b,0);b.Qb(d);a.status.ai+=c;return b},WH:function(a){var b=this.g.A.CommBufferSize-2E3;var c=Ga.F(b+4),d=this.cn(c);a=d.jb(a.Vh,!1);b=a.length();d.K(b);d.jc(a);b=new Ba(530,this.g.A.ma,2,0);b.Qb(c);return b},UH:function(a){var b=Ga.F(20);var c=this.cn(b);var d=c.jb("DummyFileName",!1);c.jc(d);c=new Ba(db.xa,this.g.A.ma,0,0);c.Qb(b);a.status.Wd=!0;return c}};
Pf.h=function(a,b){var c,d;for(d=0;d<a;++d){var e=b[d];e=e.split("|");"*.*"!==e[1]&&(0===d?c=e[1].substr(1):c=c+","+e[1].substr(1))}return c};Pf.l=function(a,b){var c=new FileReader,d=b.j;c.onload=function(e){Pf.J(e,b)};null!==d&&void 0!==d&&(d.iD=a.target.files[0].name,c.readAsArrayBuffer(a.target.files[0]))};Pf.J=function(a,b){var c=b.j;c.buffer=Nb.F(a.target.result,b.A.Ia,b.Db.Cb);c.status.Wd=!0};var lg;lg=function(a,b){this.g=a;this.Ko=b};
lg.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=new Ba(3145728,this.g.A.ma,0,0),d=Ga.F(32),e=Cc.F(d,!0),f=e.jb(this.Ko,!1);e.K(1);e.jc(f);c.Qb(d);b.Xj(c);a.tb(b.kb(),this);N.h("Redundancy, request for the ID with ticket:"+this.Ko)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).Qj(null);a instanceof hb?a.Kg()?(this.g.Kb.FD(Ua.l),this.g.Kb.pw=J.l(),this.g.D(new mg(this.g),0)):this.O("Unexpected paint result in "+this.className()):this.O(a)},O:function(a){this.g.error("Error during redundancy initializing (1) the visualization: "+
a)},className:function(){return"VisuOnlineInitRedundState1"}};var mg;mg=function(a){this.g=a};
mg.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=new Ba(1048576,this.g.A.ma,0,0);b.Xj(c);a.tb(b.kb(),this)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).Qj(null);var b=this;a instanceof hb?a.Kg()?(this.g.Kb.nq=!0,this.g.V().jp(a,function(){var c=b.g.Kb;c.sm===Ua.l?7E3>J.l()-c.pw?b.g.D(b,10):b.O("Timeout on receiving command in "+b.className()):(N.h("Redundancy, ID to use, ID :"+c.sm),N.h("Redundancy, ID to remove, ID :"+b.g.A.ma),c.tq=b.g.A.ma,b.g.A.ma=c.sm,c.nq=!1,b.g.D(new ng(b.g),
0))})):this.O("Unexpected paint result in "+this.className()):this.O(a)},O:function(a){this.g.error("Error during redundancy initializing (2) the visualization: "+a)},className:function(){return"VisuOnlineInitRedundState2"}};var ng;ng=function(a){this.g=a};
ng.prototype={i:function(){var a=this.g.La(),b=this.g.ib();b.yv(this.g.Kb.tq);a.tb(b.kb(),this)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).DQ();0===a?(N.h("Redundancy, Client removed:"+this.g.Kb.tq),N.l("Start normal machine state after redundancy switchover, ID: "+this.g.A.ma),this.g.D(new og(this.g),0)):this.O(a)},O:function(a){this.g.error("Error during redundancy initializing (3) the visualization: "+a)},className:function(){return"VisuOnlineInitRedundState3"}};var og;
og=function(a){this.g=a};
og.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=Ba.xa(this.g.A.ma,this.g.getConfiguration().BestFit,this.g.getConfiguration().BestFitForDialogs,this.g.getConfiguration().ScaleTypeIsotropic,this.g.V().Qf(),this.g.V().xr,this.g.getConfiguration().FillBackground,a.Fg()instanceof lc&&a.Fg().isConnected());b.Xj(c);a.tb(b.kb(),this)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).Qj(null);a instanceof hb?!a.Kg()||0<a.jh?this.O("Unexpected paint result in "+this.className()):this.g.D(new pg(this.g),
0):this.O(a)},O:function(a){this.g.error("Error during initializing (1) the visualization: "+a)},className:function(){return"VisuOnlineInitState1"}};var pg;pg=function(a){this.g=a};
pg.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=new Ba(1048576,this.g.A.ma,0,0),d=Ga.F(16),e=Cc.F(d,!0),f=this.g.getConfiguration();var g=458752;var k=this.g.fz;""===k&&f.UseBrowserLanguage&&(k=D.Xv());""!==k&&(g|=524288);e.K(g);e.K(7);g=0;f.HasKeyboard&&(g|=24);f.TouchHandlingActive&&(g|=3);this.g.A.iq&&(g|=128);e.K(g|256);""!==k&&(f=e.jb(k,!1),e.jc(f));c.Qb(d);b.Xj(c);a.tb(b.kb(),this)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).Qj(null);a instanceof hb?!a.Kg()||0<a.jh?this.O("Unexpected paint result in "+
this.className()+", complete: "+a.Kg()+", commands: "+a.jh):this.g.D(new qg(this.g),0):this.O(a)},O:function(a){this.g.error("Error during initializing (2) the visualization: "+a)},className:function(){return"VisuOnlineInitState2"}};var qg;qg=function(a){this.g=a};
qg.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=new Ba(1048576,this.g.A.ma,0,0),d=Ga.F(32),e=Cc.F(d,!0);if(!1===this.g.Kb.Gm)if(e.K(1),""!==this.g.getConfiguration().StartVisu){var f=e.jb(this.g.getConfiguration().StartVisu,!1);e.jc(f)}else""!==this.g.getConfiguration().StartVisuDefaultEncodingBase64&&window.atob&&(f=window.atob(this.g.getConfiguration().StartVisuDefaultEncodingBase64),f=e.jb(f,!1),e.jc(f));else e.K(2),e.Ua(0);c.Qb(d);b.Xj(c);a.tb(b.kb(),this)},sb:function(a){var b=(new ld(a,
this.g.A.Ia,this.g.Db.Cb)).Qj(null);a=!1;if(b instanceof hb)if(!b.Kg()||0<b.jh)this.O("Unexpected paint result in "+this.className()+", complete: "+b.Kg()+", commands: "+b.jh);else{!0===this.g.Kb.Gm&&(this.g.Kb.Gm=!1,a=!0);b=location.search;var c="&BRLG";D.Bb(b,c)&&(b=b.replace(c,""),a=!0);c="&RLLG";D.Bb(b,c)&&(b=b.replace(c,""),a=!0);c="&"+Wa.h;D.Bb(b,c)?(b=b.replace(c,""),a=!0):(c=Wa.h,D.Bb(b,c)&&(b=b.replace(c,""),a=!0));c="&CFG_Lang="+this.g.ou();D.Bb(b,c)?(b=b.replace(c,""),a=!0):(c="CFG_Lang="+
this.g.ou(),D.Bb(b,c)&&(b=b.replace(c,""),a=!0));"?"===b&&(b="");a&&"TRACE"!==this.g.getConfiguration().LogLevel&&(history.replaceState(null,"",location.pathname+b),window.document.title="");this.g.D(new rg(this.g),0)}else this.O(b)},O:function(a){this.g.error("Error during initializing (3) the visualization: "+a)},className:function(){return"VisuOnlineInitState3"}};var rg;rg=function(a){this.g=a;this.Ci=null;this.kz=J.l();this.g.IR(new nd);this.Ft=!1;this.uy=!0;this.Qs=!1;this.He=[]};
rg.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=this.g.V().Qk;this.BH(c);null===this.Ci?(c=this.g.yb.empty()?new Ba(1,this.g.A.ma,0,0):this.g.yb.pop(),c.ll?(this.Qs=!0,b.zT(c)):(this.Qs=!1,b.Xj(c))):b.xT(this.Ci.qr);this.uM=J.l();a.tb(b.kb(),this)},Yo:function(){return null===this.Ci&&!this.Ft},sb:function(a){if(this.Qs)this.g.D(this.zy(),this.Tx());else{a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).Qj(this.Ci);var b=this;a instanceof hb?a.Kg()?(this.Ci=null,this.uy&&(this.g.V().uB(),this.g.ef(),
this.uy=!1),this.Ft=!0,this.g.V().jp(a,function(){b.Ft=!1;b.g.D(b.zy(),b.Tx())},function(c){return b.Xm(c)})):(this.Ci=a,this.g.D(this,0)):this.O(a)}},zy:function(){return!this.g.A.wq&&4E3<=J.l()-this.kz?(this.kz=J.l(),new Wf(this.g,this)):null!==this.g.j?new Pf(this.g,this):this.g.La().Fg()instanceof lc?new sg(this.g,this):this},Tx:function(){var a=this.g.yb;if(null!==this.g.j&&3===this.g.j.direction)return this.g.getConfiguration().UpdateRate;if(a.empty()&&null===this.g.j){var b=J.l(),c=this.g.getConfiguration().UpdateRate;
a=b-a.mz;return this.g.La().Fg()instanceof lc?0:0<=a&&a<Math.min(2*c,500)?Math.max(10,c/5):Math.max(10,c-(b-this.uM))}return 0},BH:function(a){a.QN()},O:function(a,b){var c=!1,d=!1,e="";"number"===typeof b?b>=$a.h&&100>=b&&(d=!0,e="Err="+b):"Client id not present or no longer valid"===a?(d=!0,e="Err=1000"):"Unexpected format of service: 6"===a&&(d=!0,e="Err=1001");d&&this.g.Kb.xP()&&(this.g.Kb.gT(!0),b=this.g.Kb.Pm,b+=location.pathname,b+=location.search,b+="#CKT="+this.g.Kb.Ew,"TRACE"===this.g.getConfiguration().LogLevel&&
(b+="#"+e),location.assign(b),c=!0);!1===c&&("Unexpected format of service: 6"===a?(this.g.ac.Sh()&&this.g.ac.Wh(!1),this.g.pD()):this.g.error("Error while processing the visualization: "+a))},Xm:function(a){var b=-1;this.g.la&&(b=this.g.Ni.Xn);return-1!==b?(this.He.length=0,this.jA(a),a instanceof Ld&&(a=a.wc(),b=this.g.ny.F(b,a),void 0!==b&&null!==b&&this.jA(b),this.g.Ni.ZF()),this.He):null},jA:function(a){this.He.push(a)},className:function(){return"VisuOnlineState"}};var sg;
sg=function(a,b){this.oL=b;this.g=a;this.lc=this.g.La().Fg();this.pf=this.g.getConfiguration();this.nN=this.g.yb};sg.prototype={i:function(){this.lc.hs?(this.g.ep(),this.g.error("WebSocket Connection Error -> Reload")):this.lc.EP()||!this.nN.empty()?this.g.D(this.oL,0):this.g.D(this,5)},Yo:function(){return!0},className:function(){return"VisuOnlineWaitState"}};var tg;tg=function(a){this.g=a;this.eM=0};
tg.prototype={i:function(){var a=this.g.La(),b=this.g.ib();b.yT(this.g.A.ma);a.tb(b.kb(),this)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).BQ();"number"===typeof a?0===a?(N.l("Successfully finished visu registration: "+this.g.A.ma),a=this.g.sC(),""!==a?(this.g.Kb.Gm=!0,this.g.D(new lg(this.g,a),0)):this.g.D(new ug(this.g),0)):1===a?(0===this.eM++%20&&N.info("Still polling the registration of the visualization. Is the visu stopped?"),this.g.D(this,this.g.getConfiguration().PollingRegistrationInterval)):
this.O("Unexpected return value: "+a):this.handleError(a)},handleError:function(a){"The maximum number of visualization clients is already connected. Please try again later."===a||"Not enough memory in the PLC to create the client."===a?this.g.VE()&&""!==this.g.A.Jc&&this.g.A.Jc!==Ua.J?this.aP(a):this.AO(a):this.O(a)},aP:function(a){"The maximum number of visualization clients is already connected. Please try again later."===a?(a=new hd(0,this.g.A.ff,2,248),this.g.D(new wc(this.g,a,!0,!1),0)):"Not enough memory in the PLC to create the client."===
a&&(a=new hd(0,this.g.A.ff,2,247),this.g.D(new wc(this.g,a,!0,!1),0))},O:function(a){this.g.error("Visu registration in the plc failed: "+a,!0)},AO:function(a){this.g.error(a)},className:function(){return"VisuPollingRegistrationState"}};var $f;$f=function(a){this.g=a};
$f.prototype={i:function(){var a=this.g.La(),b=this.g.ib(),c=this.g.getConfiguration();b.AT(c.Application,c.ClientName,this.g.A.Aq,this.g.Rc);a.tb(b.kb(),this)},sb:function(a){a=(new ld(a,this.g.A.Ia,this.g.Db.Cb)).CQ();"number"===typeof a?(N.l("Successful first visu registration step: "+a),this.g.A.ma=a,window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess.notifyValidExternId(a),this.g.getConfiguration().CasFactoryName&&this.Kl(),a=new tg(this.g),this.g.D(a,this.g.getConfiguration().PollingRegistrationInterval)):
"no rights"===a?(this.g.ac.Sh()&&this.g.ac.Wh(!1),this.g.pD()):this.O(a)},O:function(a){this.g.error("Visu registration in the plc failed: "+a)},className:function(){return"VisuRegistrationState"},Kl:function(){var a=this.g.A;if(null!==a&&a.ma!==Ua.l&&(a.ci!==Ua.xa||this.Rc)){var b=this.g.ib(a);b.yv(a.ma);this.g.La().Kl(b.kb())}}};var ug;ug=function(a){this.g=a;this.lc=this.g.La().Fg(!0);this.xt=null;this.pf=this.g.getConfiguration();this.xl=0};
ug.prototype={i:function(){if(this.lc instanceof lc){this.xl=J.l();var a=this;this.xt=setInterval(function(){var b=a.lc instanceof lc;if(b&&a.lc.isConnected()){b=new ArrayBuffer(8);var c=new DataView(b);c.setUint8(0,0);c.setUint8(1,0);c.setUint16(2,1);c.setUint32(4,a.g.A.ma,!1);a.lc.send(b);a.lc.hR();a.Fc()}else!b||a.lc.Vn?(N.l("Failed to connect to the WebSocket-Endpoint => Fallback to XHR"),a.g.ep(),a.pf.WebSocketsDisabled=!0,a.Fc()):b&&J.l()-a.xl>=a.pf.Kw&&(a.lc.disconnect(),a.g.ep(),a.pf.WebSocketsDisabled=
!0,N.l("WebSocket Connection Timeout => Fallback to XHR"),a.Fc())},5)}else this.pf.WebSocketsDisabled=!0,this.Fc()},Fc:function(){null!==this.xt&&clearInterval(this.xt);this.pf.Mw&&(this.pf.WebSocketsDisabled=!1);this.g.D(new og(this.g),0)},className:function(){return"VisuWaitForConnectionState"}};var Vb;Vb=function(a){this.g=a;this.Md=this.Gh=null;this.Wl()?this.Sh()&&this.h():N.warn("AutoSignIn not supported or blocked by browser!")};
Vb.prototype={Sh:function(){try{return"localStorage"in window?"true"===window.localStorage.getItem("AutoSignInEnabled"):!1}catch(a){return!1}},Wl:function(){return"localStorage"in window&&"PasswordCredential"in window&&"credentials"in navigator&&"get"in navigator.credentials&&"store"in navigator.credentials},Wh:function(a){"localStorage"in window&&window.localStorage.setItem("AutoSignInEnabled",a);a||(this.password=this.username=null)},h:function(){if(this.Wl())try{var a=this;navigator.credentials.get({password:!0}).then(function(b){b?
(a.Gh=b.id,a.Md=b.password):a.Wh(!1)})}catch(b){N.error("Error while reading credentials :"+b)}},$Q:function(a,b){if(this.Wl())try{var c=new PasswordCredential({id:a,password:b});navigator.credentials.store(c).then(function(){N.h("Successfully stored credentials")})}catch(d){N.error("Error while storing credentials :"+d)}},bC:function(){return[this.Gh,this.Md]}};var eg;eg=function(a,b,c,d){void 0===d&&(d=!1);this.g=a;this.Pa=b;this.Xa=c;this.Mn=d};
eg.prototype={FE:function(){var a=window.document.createElement("div"),b=this.Me("Ok"),c=this.Me("Cancel"),d=this.$H(),e=this;b.addEventListener("click",function(){e.lL(a,d.username,d.password)},!1);c.addEventListener("click",function(){e.Ch(a)},!1);a.style.boxShadow=a.style.WebkitBoxShadow="2px 2px 6px 6px rgba(0,0,0,0.5)";a.align="center";a.appendChild(d.form);a.appendChild(b);a.appendChild(c);window.document.body.appendChild(a);J.ab(a,this.mx(300,200));a.style.zIndex=300;a.style.backgroundColor=
"#d4d0c8";d.username.focus()},$H:function(){var a=window.document.createElement("table"),b=window.document.createElement("input"),c=window.document.createElement("input"),d=window.document.createElement("form");b.autocomplete="username";c.type="password";c.autocomplete="current-password";a.border="0";a.appendChild(this.Kx("Username: ",b));a.appendChild(this.Kx("Password: ",c));d.appendChild(a);return{form:d,table:a,username:b,password:c}},Kx:function(a,b){var c=window.document.createElement("tr"),
d=window.document.createElement("td");d.appendChild(window.document.createTextNode(a));c.appendChild(d);d=window.document.createElement("td");d.appendChild(b);c.appendChild(d);return c},mx:function(a,b){var c=this.g.V().Qf();return new I((c.u+c.Z-a)/2,(c.v+c.da-b)/2)},yx:function(a){window.document.body.removeChild(a)},lL:function(a,b,c){this.yx(a);this.g.BD(!1);this.Mn?(a=new Yf(this.g,this.Xa,!1),a.ND(new Zf(this.g,b.value,c.value,this.Xa,0,new hd(0,0,0,0))),this.g.D(a,0)):(this.Pa.Error=0,this.g.D(new Zf(this.g,
b.value,c.value,this.Xa,0,this.Pa),0))},Ch:function(a){this.g.Wp("The user did not provide credentials.","No credentials");this.yx(a)},Me:function(a){var b=window.document.createElement("input");b.type="button";b.value=a;return b}};var cg;cg=function(a){this.wb=this.Gd=null;this.ia=!0;this.sL=a;this.Um=null;this.rh=this.WA=this.sj=!1;this.Qc=null;this.kl=-1;this.Es=0};
cg.prototype={ew:function(a){var b;if(null!==a){if(this.Um=a)this.Gd=new Uint8Array(this.Um),this.wb=new Ac(this.Um,this.ia,this.sL),a=this.wb.getUint16(),65279===a?this.sj=!0:48111===a&&(a=this.wb.getUint8(),191===a&&(this.WA=!0)),this.rh=!0;a=this.FJ();if(null!==a&&(a=a.split(";"),2<=a.length&&(this.Es=a.length,"ID"===a[0].toUpperCase()&&"DEFAULT"===a[1].toUpperCase()&&2<a.length)))for(this.Qc=[],b=2;b<a.length;b++)this.Qc.push(a[b])}},PE:function(a,b,c,d){var e=null,f,g=a.toUpperCase();if(this.rh&&
-1!==this.kl&&null!==this.Qc){for(a=0;a<this.Qc.length&&this.Qc[a].toUpperCase()!==g;a++);if(0<=a&&a<this.Qc.length){d?f=b:f="$"+b+"$";for(this.wb.seek(this.kl);;){b=this.Fy();if(null===b)break;b=b.split(";");if(b.length===this.Es&&(d=!1,c?D.hG(b[1],f)&&(d=!0):b[1]===f&&(d=!0),d)){e=b[2+a];break}}if(null!==e&&D.Bb(e,"$"))for(b=e.split("$"),e="",c=0;c<b.length;c++)e=e.concat("",b[c])}}return e},OE:function(a,b){var c=null;var d=a.toUpperCase();if(this.rh&&-1!==this.kl&&null!==this.Qc){for(a=0;a<this.Qc.length&&
this.Qc[a].toUpperCase()!==d;a++);if(0<=a&&a<this.Qc.length)for(this.wb.seek(this.kl);;){d=this.Fy();if(null===d)break;d=d.split(";");if(d.length===this.Es&&d[0]===b){c=d[2+a];break}}}return c},FJ:function(){var a=null;if(this.rh){this.sj?this.wb.seek(2):this.WA?(this.wb.Uj("utf-8"),this.wb.seek(3)):this.wb.seek(0);var b=this.Dy();-1!==b&&(a=this.Cy(b),this.kl=this.wb.ga())}return a},Fy:function(){var a=null;if(this.rh){var b=this.Dy();-1!==b&&(a=this.Cy(b))}return a},Cy:function(a){a=this.wb.ha(a,
this.sj);var b=this.wb.ga();b=this.sj?b+4:b+2;this.wb.seek(b);return a},Dy:function(){for(var a=this.wb.ga(),b=-1,c;!this.wb.Pf();)if(c=this.Gn(),"\r"===c){this.wb.Pf()||(c=this.Gn(),"\n"===c&&(b=this.wb.ga()-a,this.sj?(b-=4,b/=2):b-=2,this.wb.seek(a)));break}return b},Gn:function(){return this.sj?String.fromCharCode(this.wb.getUint16()):String.fromCharCode(this.wb.getUint8())},className:function(){return"LocalizedTextsFileRead"}};var bg;
bg=function(a){this.qe=null;this.oe=this.pe=0;this.ie=this.Fd=4294967295;this.gh="";this.Dl=this.Oi=!1;this.ia=a};
bg.prototype={SF:function(a){var b=0;this.qe=null;if(null!==a&&a){var c=new DataView(a);if(14<c.byteLength){var d=c.getUint8(b);b+=2;if(1===d&&(d=c.getUint8(b),1===d&&!0===this.ia||0===d&&!1===this.ia)){b+=2;this.pe=c.getUint16(b,this.ia);this.oe=c.getUint16(b+2,this.ia);b+=4;var e=c.getUint8(b);d=c.getUint8(b+1);var f=c.getUint8(b+2);var g=c.getUint8(b+3);b+=4;this.ie=e<<24;this.ie|=d<<16;this.ie|=f<<8;this.ie|=g;e=c.getUint8(b);d=c.getUint8(b+1);f=c.getUint8(b+2);g=c.getUint8(b+3);b+=4;this.Fd=
e<<24;this.Fd|=d<<16;this.Fd|=f<<8;this.Fd|=g;d=c.getUint16(b,this.ia);b+=2;if(0<d){f=Array(d);for(e=0;e<d;e++)f[e]=c.getUint8(b),b+=1;this.gh=String.fromCharCode.apply(null,f)}else this.gh="";e=c.getUint16(b,this.ia);b+=2;this.Oi=e&1?!0:!1;this.Dl=e&2?!0:!1;e=c.getUint16(b,this.ia);b+=2;c=c.getUint32(b,this.ia);b+=4;this.qe=new hb(e,c,0);this.qe.Zd().Uo(a,b,c);this.qe.finish();N.h("The paintbuffer of the login page has been read from the file, command: "+e+", dataSize: "+c)}}}},className:function(){return"PaintBufferFileRead"}};
var dg;dg=function(a,b,c){this.g=a;this.Pa=b;this.U=c;this.zk="";var d=this;this.Yf=null;this.g.ac.Sh()&&(this.Yf=setInterval(function(){d.g.ac.Sh()?null!==d.g.ac.bC()[0]&&(clearInterval(d.Yf),d.U.Yu(!0)):clearInterval(d.Yf)},1))};
dg.prototype={JE:function(a,b){var c=a.na,d=this,e=!1,f=a.wc(),g=null;var k=null;var l=this.U;l.Up("");this.zk="";k=this.nh(c,"$USERNAME_PH$");var E=this.nh(c,"$USERNAME_STAR_PH$");if("$USERNAME$"===c||"$USERNAME_STAR$"===c||"$USERNAME_PH$"===k||"$USERNAME_STAR_PH$"===E){var u="";"$USERNAME_PH$"===k&&(u=this.Re(l.Hb,k,!0,!1));"$USERNAME_STAR_PH$"===E&&(u=this.Re(l.Hb,E,!0,!1));null!==u&&""!==u&&l.Up(u);null===l.Gf?(g=this.fA(f,"$USERNAME_STAR$"===c||"$USERNAME_STAR_PH$"===E,a),l.qS(g)):b&&(l.Gf.ee(f),
g=l.Gf);null!==g&&(l.Qp(g),e=!0)}if(!1===e){k=this.nh(c,"$PASSWORD_PH$");E=this.nh(c,"$PASSWORD_CLEARTEXT_PH$");if("$PASSWORD$"===c||"$PASSWORD_CLEARTEXT$"===c||"$PASSWORD_PH$"===k||"$PASSWORD_CLEARTEXT_PH$"===E)u="","$PASSWORD_PH$"===k&&(u=this.Re(l.Hb,k,!0,!1)),"$PASSWORD_CLEARTEXT_PH$"===E&&(u=this.Re(l.Hb,E,!0,!1)),null!==u&&""!==u&&l.Up(u),null===l.Ff?(g=this.fA(f,"$PASSWORD$"===c||"$PASSWORD_PH$"===k,a),l.oS(g)):b&&(l.Ff.ee(f),g=l.Ff);null!==g&&(l.Qp(g),g.Xb().addEventListener("keypress",function(va){"Enter"===
va.key&&(null!==d.Yf&&clearInterval(d.Yf),d.U.Yu(!0))},!1),e=!0)}if(!1===e){k=this.Nr(c,"$LANG_SELECTOR$");if("$LANG_SELECTOR$"===c||"$LANG_SELECTOR$"===k)null===l.sg?(g=this.EL(f,a),g.Xb().addEventListener("change",function(){var va=d.U.sg;null!==va&&(va=va.Xb().value,d.U.pm(va))},!1),l.nS(g)):b&&(l.sg.ee(f),g=l.sg);null!==g&&(l.Qp(g),e=!0)}if(!1===e&&(k=this.Nr(c,"$LANG$"),E=this.Nr(c,"$LANG_DEF$"),"$LANG$"===c||"$LANG$"===k||"$LANG_DEF$"===c||"$LANG_DEF$"===E)){if(""===this.zk)u=Wa.xa;else{u=this.zk;
var ka="";k=c.split("$");5===k.length&&(ka=k[3])}null===l.sp(u)?(("$LANG_DEF$"===c||"$LANG_DEF$"===E)&&""!==u&&this.g.jC()&&l.pm(u),g=this.ml(),g.Nt(u),g.Xb().addEventListener(D.Tb()?"pointerup":"mouseup",function(){d.U.pm(this.id)},!1),l.mS(u,g)):b&&(l.sp(u).ee(f),g=l.sp(u));u=this.Re(l.Hb,"$LANG$$"+u+"$",!0,!1);null!==u&&""!==u&&(ka=u);l.vc().Rb(ka);null!==g&&(l.Pg(g),e=!0)}!1===e&&"$SYS_ERROR$"===c&&(g=l.vc(),e=!0,k="",!1===this.g.ty&&null!==this.Pa&&this.Pa.Error!==Ua.h&&(this.g.ac.Wh(!1),k=l.OO(this.Pa.Error,
l.Hb),e=!1),g.Rb(k),g.cv(e),null!==l.Fs&&l.Fs.cv(e),e=!0);!1===e&&(k=this.nh(c,"$AUTOSIGNIN_CUSTOMIZED$"),"$AUTOSIGNIN$"===k&&(this.g.ac.Wl()||l.vc().Rb(""),null===l.qg&&this.g.ac.Wl()?(g=this.DL(),u=this.Re(l.Hb,k,"$LOGIN_CUSTOMIZED$"===k,!1),this.g.ac.Sh()||g.Xb().addEventListener("checkboxChanged",function(va){d.g.ac.Wh(va.detail.checked)}),null!==u&&""!==u?l.vc().Rb(u):l.vc().Rb("Store credentials in Browser"),l.lS(g)):b&&null!==l.qg&&(l.qg.ee(f),g=l.qg)),null!==g&&(l.Pg(g),e=!0));if(!1===e&&
(k=this.nh(c,"$LOGIN_CUSTOMIZED$"),"$LOGIN$"===k||"$LOGIN_DOT$"===k||"$LOGIN_EMPTY$"===k||"$LOGIN_OK$"===k||"$LOGIN_CUSTOMIZED$"===k)){null===l.Ef?(g=this.ml(),g.Xb().addEventListener(D.Tb()?"pointerup":"mouseup",function(){null!==d.Yf&&clearInterval(d.Yf);d.U.Yu(!0)},!1),l.kS(g)):b&&(l.Ef.ee(f),g=l.Ef);u=this.Re(l.Hb,k,"$LOGIN_CUSTOMIZED$"===k,!1);if(null!==u&&""!==u)l.vc().Rb(u);else switch(k){case "$LOGIN$":l.vc().Rb("LOGIN");break;case "$LOGIN_DOT$":l.vc().Rb("...");break;case "$LOGIN_EMPTY$":l.vc().Rb(" ");
break;case "$LOGIN_OK$":l.vc().Rb("OK");break;case "$LOGIN_CUSTOMIZED$":l.vc().Rb(l.Ho)}null!==g&&(l.Pg(g),e=!0)}if(!1===e){k=this.nh(c,"$CANCEL_CUSTOMIZED$");if("$CANCEL$"===k||"$CANCEL_DOT$"===k||"$CANCEL_EMPTY$"===k||"$CANCEL_CUSTOMIZED$"===k)if(null===l.bh?(g=this.ml(),g.Xb().addEventListener(D.Tb()?"pointerup":"mouseup",function(){clearInterval(d.Yf);d.U.wR(!0)},!1),l.jS(g)):b&&(l.bh.ee(f),g=l.bh),u=this.Re(l.Hb,k,"$CANCEL_CUSTOMIZED$"===k,!1),null!==u&&""!==u)l.vc().Rb(u);else switch(k){case "$CANCEL$":l.vc().Rb("CANCEL");
break;case "$CANCEL_DOT$":l.vc().Rb("...");break;case "$CANCEL_EMPTY$":l.vc().Rb(" ");break;case "$CANCEL_CUSTOMIZED$":l.vc().Rb(l.Ho)}null!==g&&(l.Pg(g),e=!0)}if(!1===e&&(k=this.LJ(c,"$URL$"),"$URL$"===k)){k=ka=E="";var ja=c.split("$");u=0;1<ja.length&&"URL"===ja[1]&&(E=ja[2],u=this.Re(l.Hb,E,!1,!0),null!==u&&""!==u&&(E=u),2<ja.length&&(ka=ja[3],3<ja.length&&(k=ja[4])),u=l.$O(),null===l.oC(u)?(g=l.hA instanceof Cb?this.gA(l.Rh(),a):this.gA(f,a),g.Rb(E),g.US(ka,"replace"===k?!1:!0),g.Rj("transparent"),
l.pS(u,g)):b&&(g=l.oC(u),g.ee(f)));null!==g&&(l.Qp(g),e=!0)}!1===e&&(u=this.Re(l.Hb,c,!1,!0),null!==u&&""!==u&&a.Rb(u))},nh:function(a,b){var c=a;0===c.indexOf(b)&&(c.length>b.length&&"$"===c.charAt(c.length-1)?(this.U.Up(a.substring(b.length,c.length-1)),c=b):c="");return c},Nr:function(a,b){var c=a;0===c.indexOf(b)&&(a=a.split("$"),3<a.length?(this.zk=a[2],c=b):0>a.length&&(c=""));return c},Re:function(a,b,c,d){var e=this.U.Ah;return""!==a&&null!==e&&(a=e.PE(a,b,c,d),null!==a)?a:""},LJ:function(a,
b){0===a.indexOf(b)&&(a.length>b.length&&"$"===a.charAt(a.length-1)?a=b:a="");return a},fA:function(a,b,c){a=new Qf(a,b,this.g.V());b=this.U;a.Ug(b.Nh(),b.Oh());a.im(c.mu(),c.ru());a.bf(b.Tl());a.tS(b.Ho);a.Rj(b.Pi);a.setColor(b.Mh());return a},EL:function(a,b){a=new Sf(a,this.g.V());var c=this.U.Ah,d=this.U,e=[];a.Ug(d.Nh(),d.Oh());a.im(b.mu(),b.ru());a.bf(d.Tl());a.Rj(d.Pi);a.setColor(d.Mh());null!==c&&(null!==c.Qc&&(e=c.Qc.slice()),a.eS(e));b=this.zk;""!==b?this.g.jC()?d.pm(b):a.UD(d.Hb):a.UD(d.Hb);
return a},ml:function(){var a=this.U,b=new Nf(a.Rh(),this.g.V(),null);b.setRadius(a.rC(a.Rh().C(),a.Rh().B()));b.uR(a.Je);b.tR(a.nf);b.bf(a.Tl());b.vR(1<a.Ue?a.Ue:a.Ue+1);return b},DL:function(){var a=this.U,b=new Of(a.Rh(),this.g.V());b.setRadius(a.rC(a.Rh().C(),a.Rh().B()));b.bf(a.Tl());return b},gA:function(a,b){var c=this.U;a=new Tf(a,this.g.V());a.Ug(c.Nh(),c.Oh());a.im(b.mu(),b.ru());a.bf(c.Tl());a.Rj(c.Pi);a.setColor(c.Mh());return a},className:function(){return"PlaceHoldersHelper"}};var vg;
vg=function(a,b){this.g=a;this.Rn=this.Ke=null;this.gb=[];this.qb=-1;this.Mk=[];this.Eb=b;this.CL=D.Tb();this.oA(this.gb,!1)};
vg.prototype={register:function(a,b){this.Ke=a;this.Rn=b},uc:function(){return this.g.uc()},handleEvent:function(a,b){var c=this.CL;switch(b){case db.J:return c?this.mo(a,!1):this.ug(a.xb,!1);case db.h:return c?this.il(a,!1):this.ug(a.xb,!1);case db.l:return c?this.hl(a,!1):this.ug(a.xb,!1);default:N.warn(J.h("BrowserTouchEventHandling.handleEvent. Unknown event: {0}",b))}return!1},rb:function(){this.g.Le.hu();this.sl(this.gb);this.sl(this.Mk)},Ph:function(){return this.g.la?J.bb():this.Eb.Ph()},
nA:function(a){var b;for(b=0;b<a.length;++b)this.Ph().addEventListener(a[b].e,a[b].Ra,a[b].c)},sl:function(a){var b;for(b=0;b<a.length;++b)this.Ph().removeEventListener(a[b].e,a[b].Ra)},oA:function(a,b){var c=b?"Capturing ":"";D.Tb()?(N.h(c+"Touchsupport using PointerEvents"),this.eJ(a,b),this.nA(a)):"ontouchstart"in window?(N.h(c+"Touchsupport using TouchEvents"),this.fJ(a,b),this.nA(a)):N.warn("No touch support")},fJ:function(a,b){if(!(this.Eb instanceof Vc)){var c=this,d=function(e){c.ug(e,b)};
a.push({e:"touchstart",Ra:d,c:b});a.push({e:"touchmove",Ra:d,c:b});a.push({e:"touchend",Ra:d,c:b})}},eJ:function(a,b){if(!(this.Eb instanceof Vc)){var c=this;a.push({e:"pointerdown",Ra:function(d){c.hL(new $c(d),b)},c:b});a.push({e:"pointermove",Ra:function(d){c.hl(new $c(d),b)},c:b});a.push({e:"pointerup",Ra:function(d){c.il(new $c(d),b)},c:b})}},QL:function(){0<this.Mk.length||!this.g.la||this.Eb instanceof Vc||this.oA(this.Mk,!0)},GH:function(){0<this.Mk.length||!this.g.la||this.Eb instanceof Vc||
this.sl(this.Mk)},XM:function(a,b){var c;for(c=0;c<a.length;++c)if(a[c].identifier===b)return!0;return!1},Vq:function(a,b,c){var d;for(d=0;d<a.length;++d){var e=a[d];b.Jh(this.Eb.Xt(new $c(e),c))}},Tw:function(a,b,c){var d;for(d=0;d<a.length;++d){var e=a[d];this.XM(b,e.identifier)||c.Jh(this.Eb.Xt(new $c(e),V.Fe))}},sI:function(){null!==this.g.getConfiguration()&&this.g.getConfiguration().WorkaroundDisableMouseUpDownAfterActiveTouch&&this.g.ho.ZR(J.l()+this.g.getConfiguration().WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch)},
ug:function(a){if(!this.g.Ap()&&null!==this.Ke){this.IA(a);this.sI();this.g.kU().ap(a);var b=new wg;"touchstart"===a.type?(0===this.uc().Size()&&this.g.Le.fp(),this.Vq(a.changedTouches,b,V.$c),this.Tw(a.targetTouches,a.changedTouches,b,V.Fe)):"touchmove"===a.type?this.Vq(a.targetTouches,b,V.Fe):(this.Vq(a.changedTouches,b,V.ad),this.Tw(a.targetTouches,a.changedTouches,b,V.Fe),0===a.targetTouches.length&&this.NU.Le.hp());this.Ke(b)}},hL:function(a,b){if(!this.g.Ap()){var c=a.xb;if(this.mo(a,b)&&this.g.la){var d=
this;this.g.Li.Qt(c,d,function(e){d.hl(new $c(e),b)},function(e){d.il(new $c(e),b)})}}},mo:function(a,b){var c=a.xb;return"touch"===c.pointerType?(this.g.ub.UP(c),this.g.le.ap(c),0===this.uc().Size()&&this.g.Le.fp(),this.xu(c,b)?(N.warn(J.h("Unexpected Pointerdown event for id: {0}; Ignored!",c.pointerId)),!1):this.Sr(a,b,V.$c)?!0:!1):!1},il:function(a,b){if(this.g.Ap())return!1;var c=a.xb;if(!this.xu(c,b))return!1;if("touch"===c.pointerType){this.g.ub.VP(c);if(!this.Sr(a,b,V.ad))return!1;0===this.uc().Size()&&
this.g.Le.hp();return!0}return!1},hl:function(a,b){if(this.g.Ap())return!1;var c=a.xb;return this.xu(c,b)?"touch"===c.pointerType?this.Sr(a,b,V.Fe)?!0:!1:!1:!1},Sr:function(a,b,c){this.hM(c);var d=this.Eb.Xt(a,c);this.fN();switch(c){case V.$c:this.uc().MF(d);break;case V.Fe:case V.ad:this.uc().Yv(d.id()),this.uc().xG(d)}var e=this.GJ();if(b&&c===V.$c)if(this.Rn(e))d.$u(!0);else return this.uc().nw(d),!1;e.HR(a.xb);this.Ke(e);c===V.ad&&this.uc().nw(d);this.IA(a.xb);return!0},hM:function(a){a==V.$c&&
0<this.g.getConfiguration().Oq&&J.l()-this.HK>this.g.getConfiguration().Oq&&0<this.uc().Size()&&(N.warn("Touchhandling: Sanitycheck discarding obsolete events"),this.uc().kE(),null!==this.g.Pe&&this.g.Pe.ZQ());this.HK=J.l()},xu:function(a,b){a=J.Uf(a);if(-1===this.uc().tm(a))return!1;a=this.uc().Yv(a);return b?a.Wk:!0},GJ:function(){var a=new wg;this.uc().mE(a);return a},fN:function(){this.uc().wG(V.Fe)},IA:function(a){a.preventDefault();a.stopPropagation()}};var $c;
$c=function(a,b,c,d){void 0===d&&(d=null);void 0===b&&(b=J.VB(a)?J.$j(a.target,J.bb()).offset(D.Cq(a)):J.ck(a)?J.$j(a.target,J.bb()).offset(D.mi(a)):new I(-1,-1));void 0===c&&(c=b);this.xb=a;this.lj=b;this.Od=c;this.Gb=d;this.iA=null};$c.prototype={uS:function(a){this.iA=a},Ea:function(){return this.Gb},ce:function(a){this.Gb=a}};var xg;xg=function(a){this.Ee=this.gd=null;a||(a=V.bd);this.Gb=null;this.Vp(a)};
xg.prototype={type:function(){if(null===this.gd)throw Error("Unexpected call. Gesture data not yet assigned");return this.gd.type()},ce:function(a){this.Gb=a},Ea:function(){return this.Gb},Vp:function(a){if(null===this.gd||this.type()!==a)switch(a){case V.hf:this.gd=new yg;break;case V.bd:this.gd=new zg;break;case V.$g:this.gd=new Ag;break;case V.Ge:this.gd=new Bg(!1);break;case V.he:this.gd=new Bg(!0);break;default:throw Error("Unexpected gesture type");}},data:function(){return this.gd},clone:function(){var a=
new xg;null!==this.gd&&(a.gd=this.gd.clone());null!==this.Gb&&(a.Gb=this.Gb);a.Ee=this.Ee;return a}};var V;V={Fe:1,ad:2,$c:4,Om:8,Iw:16,zq:5,bd:0,$g:1,hf:2,Ge:3,he:4,Zg:0,Nm:1,vG:2,Mm:4,Gw:8,Hw:16,NT:255,Cd:0,ik:5,jk:10};V.Zc=V.jk;V.kk=11;V.De=12;V.gf=13;V.gG=V.gf;var Cg;Cg=function(){this.fq=this.ek=this.um=this.Fm=this.jq=!1};var Dg;Dg=function(){this.Fb=[]};
Dg.prototype={nD:function(a,b){N.l("Record GesturesTouchEvent");!this.empty()&&this.zK(a)&&b?this.Fb[this.Fb.length-1]=a:this.Fb.push(a)},PQ:function(a,b){N.l("Replay");for(var c;"undefined"!==typeof(c=this.Fb.shift());)a.bm(c,b)},empty:function(){return 0===this.Fb.length},zK:function(a){var b=this.Fb[this.Fb.length-1],c;if(a.touches().length!==b.touches().length)return!1;for(c=0;c<a.touches().length;++c){var d=a.touches()[c];var e=b.touches()[c];if(d.id()!==e.id()||d.flags()!==e.flags()||d.$(V.ad)||
d.$(V.$c))return!1}return!0}};var Eg;Eg=function(a,b,c,d,e,f){f=f?f:null;this.ta=a;this.pb=d;this.ne=new Fg(b,c);this.Od=e;this.Gb=f;this.Wk=!1;this.Bk=null};
Eg.prototype={id:function(){return this.ta},Ea:function(){return this.Gb},ce:function(a){this.Gb=a},$u:function(a){this.Wk=a},gS:function(a){this.ne.BR(a)},location:function(){return this.ne},GR:function(a){this.Bk=a},vv:function(a){this.Bk=a;this.ne.vv(a)},flags:function(){return this.pb},vj:function(a){this.pb|=a},$:function(a){return(this.pb&a)===a},update:function(a){this.pb=a},clone:function(){var a=new Eg(this.id(),this.location().current(),this.location().ij,this.flags(),this.Od,this.Ea());
a.$u(this.Wk);return a}};var wg;wg=function(){this.Wa=[];this.WM=J.l();this.Te=null;this.Wz=!1;this.xb=null};wg.prototype={touches:function(){return this.Wa},LD:function(a){this.Te=a},sS:function(a){this.Wz=a},HR:function(a){this.xb=a},event:function(){return this.xb},Jh:function(a){this.Wa.push(a)},timeStamp:function(){return this.WM}};var Fg;Fg=function(a,b){this.Di=a;this.ij=new I(a.X,a.Y);void 0!==b&&null!==b&&(this.ij=new I(b.X,b.Y));this.gz=null};
Fg.prototype={BR:function(a){this.Di=a},vv:function(a){this.Di.X+=a.X;this.Di.Y+=a.Y},current:function(){return this.Di},Zl:function(){return this.gz},KD:function(a){this.gz=a}};var Gg;
Gg={ku:function(a,b){var c=0<b.touches().length,d;a.data().XN();for(d=0;d<b.touches().length;++d){var e=b.touches()[d];a.data().Jh(e.clone());e.$(V.ad)||(c=!1)}return c},HN:function(a,b){var c;for(c=0;c<a.touches().length;++c)if(a.touches()[c].$(b))return!0;return!1},wj:function(a,b){var c;for(c=0;c<a.touches().length;++c)if(!a.touches()[c].$(b))return!1;return!0},NB:function(a){var b=V.Gw|V.Hw;1===a.touches().length?b|=V.Nm|V.Mm:2===a.touches().length&&(b|=V.vG);return b},Vl:function(a){return a===
V.Ge||a===V.he}};var sc;sc=function(a,b){var c=this;this.g=a;this.Eb=b;this.PJ=!(b instanceof Vc);this.Fk=new vg(a,this.Eb);this.Fk.register(function(d){c.Ke(d)},function(d){return c.Rn(d)});this.Rd=null;this.ya=new Hg;this.bt=-1;this.BA("none");this.ms=new Ig(this.g.yg)};
sc.prototype={rb:function(){this.BA("auto");this.Fk.rb()},handleEvent:function(a,b){return this.Fk.handleEvent(a,b)},Qo:function(a,b){this.ya.Kt(a,b);this.AH(a)},Su:function(a){this.ya.MQ(a)},sB:function(){this.ya.clear();this.FH()},Sp:function(a){this.g.N.Sp(a);a&&(this.Rd=this.Eb.cp(!0))},RO:function(){return this.g.yg.qu()},lC:function(){return this.g.yg.np()},up:function(){return this.g.yg.up()},Lp:function(a,b,c){a=Ba.Sb(a,this.g.A.ma,b);void 0!==c&&null!==c&&a.ce(c);this.Eb.ud(a)},JP:function(){return this.ms.active()},
aE:function(){this.ms.stop()},$B:function(a,b,c){var d=new Cg;c=this.pI(a,b,c);this.gs(a,V.Gw)&&this.ya.DO(b,c,this.PJ)?d.fq=!0:this.gs(a,V.Hw)&&this.ya.GN(b,c)?d.ek=!0:this.gs(a,V.Nm|V.Mm)&&(a=[],this.ya.RN(b,a,c),d.Fm=a[0],d.um=a[1]);d.jq=!this.xH();return d},pI:function(a,b,c){if(this.g.la){if(void 0===c){a=b.touches();if(0<a.length)for(b=0;b<a.length;b++)if(a[b]&&a[b].Wk)return Wc.gq;return 0}return c?Wc.gq:Wc.hE}return 0},lu:function(a,b,c){if(a>=V.jk&&a<=V.gG)if(b.type()===V.bd||b.type()===
V.$g){if(this.tJ(a,b,b.Ee,c))return!0}else if(this.yK(b.type())&&this.uJ(a,b,b.Ee))return!0;return!1},Hl:function(){this.g.N.lO();!this.g.N.zp()&&this.g.Pe.buffer().empty()&&(N.h("Acknowledged gesture and queue empty -> record := false"),this.g.N.hv(!1))},BA:function(a){this.Eb.Ph().style.touchAction=a},xH:function(){return this.g.N.zp()?(N.h("New gesture starting despite currently ignored -> record := true"),this.g.N.hv(!0),!1):!0},gs:function(a,b){return(a&b)===b},yK:function(a){return a===V.hf||
Gg.Vl(a)},Vy:function(a){return a===V.he},Xy:function(a){return null!==a&&null!==a.ca&&(a=a.ca,a instanceof Oc&&a.Ze())?!0:!1},tJ:function(a,b,c){var d=Y.gi;if(a===V.Zc){c=this.ya.XB(b);if(null===c)return!0;var e=c.ca;if(null!==e&&e.Bp())return!0;this.Xy(c)&&e.JN();b.Ee=c;this.GM(c);this.g.N.iP()}else if(a===V.gf||a===V.De)this.Xy(c)?a=this.VJ(c,b):null===c||b.type()===V.bd&&this.ms.start(this.g.V(),c,this.Rd,b,this)||(this.ly(d,b,c),this.eA(b,c));if(null!==c){if(b.type()===V.$g||b.type()===V.bd)d=
b.data().kB(c,a,this);Y.Hj(d,Y.Cv)&&(d=Y.af(d,Y.Ov))}a!==V.De&&(this.ly(d,b,c),this.Rd.Th(this.g.V(),c));return!1},VJ:function(a,b){var c=a.ca;var d=c.Ya;var e=c.Qa;var f=d.style.left;var g=d.style.top;e=this.yM(e,d,c,b);this.aE();this.Hl();c.Wu();b.gd.eR(e);this.AM(a,b,d,f,g,e);return V.De},RA:function(a,b,c,d){var e=b.ca;this.aN(a,b,c);d.style.transition="";c||e.dE()},AM:function(a,b,c,d,e,f){var g=this;var k=a.ca;var l=k.Qa;c.style.transition="all 200ms ease-in-out";k.bE();this.VI(l,c,d,e)?setTimeout(function u(){g.RA(b,
a,f,c);this.removeEventListener("transitionend",u)},0):c.addEventListener("transitionend",function ka(){g.RA(b,a,f,c);this.removeEventListener("transitionend",ka)},!1)},VI:function(a,b,c,d){return a.vu()?b.style.left===c:b.style.top===d},aN:function(a,b,c){c&&this.to(a,b)},yM:function(a,b,c,d){var e=d.data().Ju();d=d.data().Ye();var f=Math.abs(e.X)>Math.abs(e.Y);var g=Math.abs(e.Y)>Math.abs(e.X);if(a.vu()){if(b.style.left="0px",(Math.abs(e.X)>c.ka/3||5<Math.abs(d.X))&&f){if(0<e.X){if(b.style.left=
c.ka+"px",!c.yp())return b.style.left="0px",!1}else if(b.style.left=-c.ka+"px",!c.xp())return b.style.left="0px",!1;return!0}}else if(a.QC()&&(b.style.top="0px",(Math.abs(e.Y)>c.qa/3||5<Math.abs(d.Y))&&g)){if(0<e.Y){if(b.style.top=c.qa+"px",!c.yp())return b.style.top="0px",!1}else if(b.style.top=-c.qa+"px",!c.xp())return b.style.top="0px",!1;return!0}return!1},KP:function(a,b){var c=this.Rd.Kj(b);this.eA(a,b);this.Lp(4098,c,a.Ea())},uJ:function(a,b,c){if(a===V.Zc){c=this.ya.XB(b);if(null===c&&!this.Vy(b.type()))return!0;
b.Ee=c;Gg.Vl(b.type())&&this.to(b,c)}else if(null!==c||this.Vy(b.type()))Gg.Vl(b.type())?this.to(b,c):(a===V.gf||a===V.De)&&this.to(b,c);return!1},to:function(a,b){b=a.data().createEvent(this.g.A.ma,b,this.Eb);null!==a.Ea()&&b.ce(a.Ea());this.Xx(b)},Xx:function(a){this.Eb.ud(a)},eA:function(a,b){var c=a.data().createEvent(this.g.A.ma,b,this.Eb);c.OD(b.za);null!==a.Ea()&&c.ce(a.Ea());this.Xx(c)},GM:function(a){a.info().zoom().Rp(1);a.info().scroll().Sg(new I(0,0));this.g.N.Zi||this.Rd.Pt(this.g.V(),
a.za)},ly:function(a,b,c){Y.Hj(a,Y.AF)&&this.vI(a,b,c);Y.$(a,Y.Jq)&&(c.info().zoom().Rp(c.info().zoom().Va().Dc),this.VG(b,c));Y.$(a,Y.Iq)&&c.info().zoom().Rp(c.info().zoom().Va().Cc)},VG:function(a,b){this.sz(Y.ii|Y.ji,b)},vI:function(a,b,c){b.type()===V.$g?this.sz(a,c):b.type()===V.bd&&this.LK(a,c)},sz:function(a,b){var c=b.MB(),d=b.info().zoom();if(Y.$(a,Y.fk))d.Sj(new I(d.tf.X+c.u,d.ed.Y));else if(Y.$(a,Y.ii)){var e=d.tf.X-(1-d.fg)*d.tf.X;d.Sj(new I(e,d.ed.Y));b.info().scroll().Sg(new I(d.ed.X-
d.tf.X,b.info().scroll().eb.Y))}Y.$(a,Y.gk)?d.Sj(new I(d.ed.X,d.tf.Y+c.v)):Y.$(a,Y.ji)&&(e=d.tf.Y-(1-d.fg)*d.tf.Y,d.Sj(new I(d.ed.X,e)),b.info().scroll().Sg(new I(b.info().scroll().eb.X,d.ed.Y-d.tf.Y)))},LK:function(a,b){b.UC(a)},Rn:function(a){var b=Gg.NB(a);a=this.$B(b,a,!0);return!!(a.fq||a.um||a.ek||a.Fm)},Ke:function(a){var b=this.g.getConfiguration();null!==b&&this.g.N.Xr&&b.TouchHandlingActive&&(b.DebugOnlyPrintRawTouches&&this.LI(a),this.DH(a),null===this.Rd&&(this.Rd=this.Eb.cp(!1)),this.g.N.Us?
(this.g.Pe.buffer().nD(a,!0),this.jt()):this.g.Pe.bm(a,this)&&(this.g.N.Us&&this.g.Pe.buffer().nD(a,!0),this.g.Pe.buffer().empty()||this.jt()))},DH:function(a){Gg.wj(a,V.$c)?this.g.ho.JD(!0):Gg.wj(a,V.ad)&&this.g.ho.JD(!1)},jt:function(){if(-1===this.bt){var a=this;this.bt=window.setTimeout(function(){a.nL()},25)}},nL:function(){this.bt=-1;this.g.N.zp()?this.jt():(this.g.Pe.buffer().PQ(this.g.Pe,this),N.h("Replayed gestures and queue empty -> record := false"),this.g.N.hv(!1))},LI:function(a){var b;
var c=J.h("Touches ({0}): ",a.touches().length);for(b=0;b<a.touches().length;++b){var d=a.touches()[b];var e="";null!==d.Ea()&&(e=" ("+d.Ea().toString()+")");var f="D";var g="";d.$(V.Fe)?f="M":d.$(V.ad)&&(f="U");d.$(V.Om)&&(g="P");c+=J.h("[{0}{1}{2} ({3}/{4}){5}] ",g,f,d.id(),d.location().current().X,d.location().current().Y,e)}N.h(c)},AH:function(a){a.$(Wc.gq)&&this.Fk.QL()},FH:function(){this.Fk.GH()}};var Ig;Ig=function(a){this.qb=-1;this.vb=this.gg=this.Rd=this.hb=this.Fh=null;this.ez=a};
Ig.prototype={start:function(a,b,c,d,e){this.hb=a;this.Fh=b;this.Rd=c;this.gg=d.clone();this.vb=e;var f=this;this.qb=window.setInterval(function(){f.Ke()},60);return-1!==this.qb},stop:function(){-1!==this.qb&&(window.clearInterval(this.qb),this.vb.KP(this.gg,this.Fh),this.qb=-1,this.gg=this.Rd=this.hb=this.Fh=null)},active:function(){return-1!==this.qb},qu:function(){return this.ez.qu()},np:function(){return this.ez.np()},Ke:function(){var a=this.Fh.info().scroll();1>Math.abs(a.Ye().X)&&1>Math.abs(a.Ye().Y)?
this.stop():(a.Ye().hm(1-this.np()),a.Ye().X=J.YB(a.Ye().X),a.Ye().Y=J.YB(a.Ye().Y),a.eb.offset(a.Ye()),a=this.Fh.Rt(),this.Fh.UC(a),Y.$(a,Y.Ov)||Y.$(a,Y.BF)&&Y.$(a,Y.CF)?this.stop():this.Rd.Th(this.hb,this.Fh))}};var qc;qc=function(){this.EA=0;this.Px=1;this.vA=!0};qc.prototype={NS:function(a){this.EA=a},qu:function(){return this.EA},FR:function(a){this.Px=a},np:function(){return this.Px},JS:function(a){this.vA=a},up:function(){return this.vA}};var uc;
uc=function(){this.Us=this.Xr=!1;this.Yr=0;this.Zi=!1};uc.prototype={ID:function(a){this.Xr=a},hv:function(a){this.Us=a},iP:function(){this.Yr++},lO:function(){this.Yr--},zp:function(){return 0<this.Yr},Sp:function(a){this.Zi=a}};var Y;Y={gi:0,Jq:1,Iq:2};Y.LT=Y.Jq|Y.Iq;Y.fk=4;Y.gk=8;Y.ii=16;Y.ji=32;Y.AF=Y.fk|Y.gk|Y.ii|Y.ji;Y.BF=Y.fk|Y.ii;Y.CF=Y.gk|Y.ji;Y.Ov=65536;Y.Hv=131072;Y.Iv=262144;Y.Fv=524288;Y.Gv=1048576;Y.Kv=2097152;Y.Jv=4194304;Y.Dv=Y.Hv|Y.Fv;Y.Ev=Y.Iv|Y.Gv;Y.hq=Y.Dv|Y.Ev;Y.jE=Y.Kv|Y.Jv;
Y.Cv=Y.jE|Y.hq;Y.af=function(a,b){return a|b};Y.KQ=function(a){return a&~Y.hq};Y.$=function(a,b){return(a&b)===b};Y.Hj=function(a,b){return 0!==(a&b)};var tc;tc=function(a){this.g=a};tc.prototype={Xt:function(a,b){b=this.RH(a,b,this);null!==a.Ea()&&b.ce(a.Ea());return b},RH:function(a,b){return new Eg(J.Uf(a.xb),a.lj,a.iA,b,a.Od)},cp:function(a){return this.g.la?new Jg:new Kg(this.Ph(),a)},Ph:function(){return this.g.V().Gg().canvas},ud:function(a){this.g.ud(a)}};var Vc;
Vc=function(a,b,c){tc.call(this,a);this.rc=b;this.WK=c};Vc.prototype=Object.create(tc.prototype);Vc.prototype.constructor=Vc;Vc.prototype.cp=function(){return this.rc};Vc.prototype.Ph=function(){return this.WK};var rc;rc=function(a){var b;this.oa=new Dg;this.ql=[];this.ql[0]=new Lg;for(b=1;b<V.zq;++b)this.ql[b]=new Mg;this.ct();this.lt=new Ng(a);this.N=new Og;this.Ki=new Pg;this.Tk=null;this.JI=a.DebugOnlyPrintGestures};
rc.prototype={bm:function(a,b){return 1>a.touches().length||a.touches().length>V.zq?!1:this.wI(a,b)},ZQ:function(){this.N.Uu();this.ct()},BK:function(a){return!this.Ki.Ti.ek&&Gg.wj(a,V.$c)},$y:function(a,b){return!b.JP()&&!this.Ki.Ti.ek&&Gg.wj(a,V.ad)},wI:function(a,b){var c=new xg,d=!1;var e=this.wH(a,b);this.LG(a);this.dJ(a);e&&(this.BK(a)&&this.XJ(a,b),this.N.Sa.state()!==V.Zc&&this.N.Sa.state()!==V.kk||this.lJ(a,b),this.N.Uu(),this.ct(),this.Ki.Ti.fq&&this.N.Sa.ye().Vp(V.Ge));if(this.N.Sa.ye().type()!==
V.Ge&&(e=a.touches().length-1,e=this.ql[e].bm(this,a,c),e===V.ik||e>=V.jk)){if(e>=V.jk)return null!==this.Tk?(this.$y(a,b)&&b.Lp(4098,a.touches()[0].location().ij,a.touches()[0].Ea()),this.ol(this.Tk.state(),this.Tk.ye(),a,b),this.Tk=null,this.ol(e,c,a,b)):(this.ol(e,c,a,b),this.$y(a,b)&&b.Lp(4098,a.touches()[0].location().ij,a.touches()[0].Ea())),!0;this.N.Sa.assign(e,c);this.N.Sa.jB(a);d=!0}if(!d)return this.Ki.Ti.jq||(e=this.lI(c,a),this.ol(e,c,a,b)),!0;this.Ar(V.Cd,c);return!1},XJ:function(a,
b){var c=a.touches()[0].Ea();b.aE();null!==a.Te&&a.Wz&&(c=a.Te.Ea());b.Lp(4097,a.touches()[0].location().ij,c)},buffer:function(){return this.oa},jP:function(a){var b=new xg(V.he);a=a.clone();a.update(V.$c|V.Om);b.data().Jh(a);this.Tk=new Qg(b)},ol:function(a,b,c,d){if(this.N.Sa.state()!==V.De){var e=this.N.Sa.ye().Ee;this.zH(a,b);this.Ar(a,b);this.N.Sa.assign(a,b.clone());b.Ee=e;e={delay:!1,callback:function(){d.lu(V.De,b)}};d.lu(a,b,e)&&(this.Ar(V.De,b),e.delay||d.lu(V.De,b),this.N.Sa.Tp(V.De));
this.N.Sa.ye().Ee=b.Ee;a!==V.gf&&this.N.Sa.jB(c)}a===V.gf&&this.N.Uu()},zH:function(a,b){var c;if(a===V.Zc&&b.type()===V.he){a=!1;for(c=0;c<b.data().touches().length;++c)if(b.data().touches()[c].$(V.Om)){a=!0;break}if(!a)for(c=0;c<b.data().touches().length;++c)if(b.data().touches()[c].$(V.$c)){this.N.Sa.VR(b.data().touches()[c].id());break}}if(this.N.Sa.xy)for(c=0;c<b.data().touches().length;++c)if(b.data().touches()[c].id()===this.N.Sa.Zw){b.data().touches()[c].vj(V.Iw);break}},lI:function(a,b){var c=
Gg.wj(b,V.ad);var d=this.N.Sa.ye().type()===V.Ge?V.Ge:V.he;a.Vp(d);Gg.ku(a,b);return c?V.gf:this.N.Sa.state()===V.Zc||this.N.Sa.state()===V.kk?V.kk:V.Zc},ct:function(){var a;for(a=0;a<this.ql.length;++a)this.ql[a].Tp(V.Cd)},dJ:function(a){var b;for(b=0;b<a.touches().length;++b){var c=a.touches()[b];this.N.rT(c)||this.N.AN(c)||N.error("Could not store touch information; probably a touch release/up was missing")}},LG:function(a){var b;if(null!==a.event().currentTarget&&null!==a.Te&&a.Te instanceof Oc&&
a.event().currentTarget!=a.Te.S&&null!==a.Te.Ya){var c=J.vC(a.Te.Ya,a.event().currentTarget);for(b=0;b<a.touches().length;++b){var d=a.touches()[b];var e=d.location().current();e.X+=c.X;e.Y+=c.Y;d.gS(e);d.GR(c)}}},wH:function(a,b){return this.vK(a)?(this.Ki.iS(b.$B(Gg.NB(a),a)),!0):!1},lJ:function(a,b){Gg.Vl(this.N.Sa.ye().type())&&Gg.ku(this.N.Sa.ye(),a);this.ol(V.gf,this.N.Sa.ye(),a,b)},vK:function(a){if(this.N.Sa.state()===V.Cd)return!0;if(Gg.Vl(this.N.Sa.ye().type()))return Gg.wj(a,V.$c);if(this.N.Sa.Bl.length!==
a.touches().length)return!0;var b;for(b=0;b<a.touches().length;++b)if(!this.N.Sa.sP(a.touches()[b].id()))return!0;return!1},Ar:function(a,b){if(this.JI){var c="";switch(a){case V.Cd:N.l("No gesture");return;case V.ik:c="Gesture (candidate); ";break;case V.Zc:c="Gesture (new); ";break;case V.gf:c="Gesture (finished); ";break;case V.kk:return;case V.De:c="Gesture (cancelled); "}c+=b.data().gp();null!==b.Ea()&&(c+=" IdStack: "+b.Ea().toString());N.l(c)}}};var Rg;
Rg=function(){this.fa=V.Cd;this.gg=new xg;this.Bl=[];this.xy=!1;this.Zw=-1};Rg.prototype={state:function(){return this.fa},Tp:function(a){this.fa=a},ye:function(){return this.gg},VR:function(a){this.xy=!0;this.Zw=a},assign:function(a,b){this.fa=a;this.gg=b},jB:function(a){var b;this.Bl=[];for(b=0;b<a.touches().length;++b)this.Bl.push(a.touches()[b].id())},sP:function(a){var b;for(b=0;b<this.Bl.length;++b)if(this.Bl[b]===a)return!0;return!1}};var Pg;Pg=function(){this.Ti=null};
Pg.prototype={iS:function(a){this.Ti=a}};var Qg;Qg=function(a){this.fa=V.Zc;this.gg=a};Qg.prototype={state:function(){return this.fa},ye:function(){return this.gg}};var Og;Og=function(){this.vh=[];this.Sa=new Rg};
Og.prototype={rT:function(a){var b;for(b=0;b<this.vh.length;++b)if(this.vh[b].id===a.id())return a.location().KD(this.vh[b].Zl),a.$(V.ad)?this.vh.splice(b,1):this.vh[b].Zl=a.location().Zl(),!0;return!1},AN:function(a){if(!a.$(V.$c))return!0;if(this.vh.length===V.zq)return!1;this.vh.push({id:a.id(),Zl:a.location().current()});return!0},Uu:function(){this.Sa=new Rg}};var Ng;Ng=function(a){this.pJ=a.GesturesFlickPanThresholdPxPerSecond;this.zL=a.GesturesPanFlickTimeThresholdMs;this.yL=a.GesturesPanClickThresholdDistSquare};
Ng.prototype={};var yg;yg=function(a){void 0===a&&(a=new I(0,0));this.sc=a;this.Kf=void 0;this.Ec=new I(0,0);this.tj=0};
yg.prototype={type:function(){return V.hf},clone:function(){var a=new yg(this.sc);a.Ml(this);return a},gp:function(){return J.h("Flick: start({0}), overall move({1}), velocity {2}",J.Yc(this.sc),J.Yc(this.Ec),this.tj)},createEvent:function(a,b){a=new Ba(2051,a,b.id(),0);b=Ga.F(12);var c=Cc.F(b,!0);c.K(this.sc.tc());c.K(this.Ec.tc());c.K(this.tj);a.Qb(b);return a},Ml:function(a){this.sc=a.sc;this.Kf=a.Kf;this.Ec=a.Ec;this.tj=a.tj},start:function(){return this.sc},lv:function(a){this.Kf=a},pv:function(){return this.Kf},
setVelocity:function(a){this.tj=a},Ju:function(){return this.Ec},xv:function(a){this.Ec=a.Sf(this.sc)}};var Bg;Bg=function(a){this.Cl=a;this.Wa=[]};
Bg.prototype={type:function(){return this.Cl?V.he:V.Ge},touches:function(){return this.Wa},XN:function(){this.Wa=[]},Jh:function(a){this.Wa.push(a)},clone:function(){var a=new Bg(this.Cl);a.Wa=this.Wa.slice(0);return a},gp:function(){var a="",b;var c=this.Cl?"TouchToMouse":"IEC-Touches";for(b=0;b<this.Wa.length;++b)if(2>b)a+=J.h("[{0}, {1}]({2}) ",b,this.Wa[b].flags(),J.Yc(this.Wa[b].location().current()));else{a+="...";break}return J.h("{0} ({1}): {2}",c,this.Wa.length,a)},createEvent:function(a,
b,c){var d=0,e,f=!0;var g=c.g.la?12:0;var k=null;this.Cl||(d=b.id());var l=this.Wa.length;b=this.Cl?2054:2052;g=Ga.F((8+g)*this.Wa.length);var E=Cc.F(g,!0);for(e=0;e<this.Wa.length;++e){var u=this.Wa[e].location().ij;E.K(u.tc());u=255&this.PK(this.Wa[e]);this.Wa[e].$(V.Fe)||(f=!1);if(this.Wa[e].$(V.Om)||this.Wa[e].$(V.Iw))u|=256;u|=(this.Wa[e].id()&65535)<<16>>>0;E.K(u)}if(c.g.la){for(e=0;e<this.Wa.length;++e)if(u=this.Wa[e].Ea(),null!==u){if(null===k||k!==u)k=u;E.K(u.Ib);E.K(u.ec)}else E.K(0),E.K(0);
for(e=0;e<this.Wa.length;++e)E.K(this.Wa[e].Od.tc())}f&&b++;a=new Ba(b,a,d,l);a.Qb(g);!c.g.la||2052!==b&&2053!==b||null!==k&&a.ce(k);return a},PK:function(a){return a.$(V.Fe)?2:a.$(V.ad)?3:a.$(V.$c)?1:0}};var zg;zg=function(a){void 0===a&&(a=new I(0,0));this.sc=a;this.Kf=void 0;this.Ec=new I(0,0);this.uf=new I(0,0);this.rz=0;this.yA=!1};
zg.prototype={eR:function(a){this.yA=a},type:function(){return V.bd},clone:function(){var a=new zg(this.sc);a.Ml(this);return a},Ml:function(a){this.sc=a.sc;this.Kf=a.Kf;this.Ec=a.Ec;this.uf=a.uf},kB:function(a,b,c){var d=a.info().scroll(),e=this.sc.Pb(this.Ec);b===V.Zc&&d.ER(this.sc);b=this.KK(this.uf,c,a);var f=a.ca&&a.ca.Ze()&&a.ca.tk;c.up()||a.za.xB(e.X)||f?(d.CR(this.Ec.X),d.CD(b.X)):d.CD(0);c.up()||a.za.yB(e.Y)||f?(d.DR(this.Ec.Y),d.DD(b.Y)):d.DD(0);return a.Rt()},KK:function(a,b,c){c=c.za.size().scale(b.RO());
b=new I(c.L*b.lC(),c.aa*b.lC());return new I(Math.max(-b.X,Math.min(b.X,a.X)),Math.max(-b.Y,Math.min(b.Y,a.Y)))},gp:function(){return J.h("Pan: start({0}), overall move({1})",J.Yc(this.sc),J.Yc(this.Ec))},createEvent:function(a,b){if(this.yA){a=new Ba(2051,a,b.id(),0);var c=Ga.F(12);var d=Cc.F(c,!0);d.K(b.info().scroll().Ei.tc());d.K(b.info().scroll().eb.tc());d.K(2E3)}else a=new Ba(2050,a,b.id(),0),c=Ga.F(8),d=Cc.F(c,!0),d.K(b.info().scroll().Ei.tc()),d.K(b.info().scroll().eb.tc());a.Qb(c);return a},
start:function(){return this.sc},lv:function(a){this.Kf=a},pv:function(){return this.Kf},Ju:function(){return this.Ec},xv:function(a){this.Ec=a.Sf(this.sc)},Ye:function(){return this.uf},qT:function(a,b){var c=b-this.rz;1E-6>c&&(c=1);this.rz=b;this.uf=a.aR(60/c)}};var Ag;Ag=function(){this.nt=new I(0,0);this.lx=new I(0,0);this.tL=1;this.qo=this.Fo=0};
Ag.prototype={type:function(){return V.$g},clone:function(){},gp:function(){return"SpreadPinch: "},kB:function(a,b){var c=a.info().zoom(),d=a.info().scroll();b===V.Zc&&c.Sj(this.nt);c.Sj(this.lx);c.Rp(this.tL);c.OS(this.Fo);c.setOrientation(this.qo);d.Sg(this.lx.Sf(this.nt));b=a.Rt();Y.Hj(b,Y.hq)&&this.AK(a)&&(b=Y.KQ(b));return b},createEvent:function(a,b){a=new Ba(2049,a,b.id(),0);var c=b.info().zoom();b=Ga.F(16);var d=Cc.F(b,!0);d.K(c.ed.tc());d.K(c.tf.tc());d.K(65536*c.fg);var e=c.Fo/2/Math.PI*
65536;c=c.orientation()/2/Math.PI*65536;d.K(e|c<<16);a.Qb(b);return a},AK:function(a){return 400>a.info().scroll().kO.gu(new I(0,0))}};var Mg;Mg=function(){};Mg.prototype={bm:function(){return V.Cd},state:function(){return V.Cd},Tp:function(){}};var Lg;Lg=function(){this.fa=V.Cd;this.pt=0;this.Gb=this.dd=this.wh=this.xh=null;this.eg=-1};
Lg.prototype={bm:function(a,b,c){var d=a.Ki.Ti;if(Gg.HN(b,V.ad))this.fa===V.ik&&(this.dd=V.Zg,this.eg=V.he,this.oK(a,b)),this.fa=this.qH();else{var e=b.touches()[0].location();switch(this.fa){case V.Cd:if(d.jq)return V.Cd;d.ek?(this.dd=V.Zg,this.eg=V.he,this.fa=V.Zc):d.Fm||d.um?(this.dd=V.Zg,d.Fm&&(this.dd|=V.Nm),d.um&&(this.dd|=V.Mm),this.fa=V.ik):(this.dd=V.Zg,this.eg=V.he,this.fa=V.Zc);this.jK(b);break;case V.ik:e=e.current().gu(e.Zl())>a.lt.yL;b.sS(e);if(e)if(this.dd===V.Nm)this.$n(b,V.bd);else if(this.dd===
V.Mm)this.$n(b,V.hf);else if(e=b.timeStamp()-this.pt>a.lt.zL)this.zt(b),this.wh.tj<a.lt.pJ?this.$n(b,V.bd):this.$n(b,V.hf);break;default:this.zt(b),this.fa=V.kk}}if(this.fa>=V.jk)switch(c.Vp(this.eg),this.eg){case V.bd:c.data().Ml(this.xh);c.ce(this.Gb);break;case V.hf:c.data().Ml(this.wh);c.ce(this.Gb);break;case V.Ge:case V.he:Gg.ku(c,b);break;default:throw Error("unexpected");}return this.fa},state:function(){return this.fa},Tp:function(a){this.fa=a},jK:function(a){var b=a.touches()[0],c=b.location().current(),
d=b.Od;this.pt=J.l();this.wh=new yg(c);this.wh.lv(d);this.xh=new zg(c);this.xh.lv(d);this.Gb=b.Ea();null!==a.Te&&(this.Gb=a.Te.Ea())},$n:function(a,b){this.zt(a);this.dd=V.Zg;this.eg=b;this.fa=V.Zc},oK:function(a,b){a.jP(b.touches()[0])},zt:function(a){var b=a.touches()[0].location().current();if(this.eg===V.bd||this.dd!==V.Zg){var c=b.Sf(this.xh.start().Pb(this.xh.Ju()));this.xh.qT(c,a.timeStamp());this.xh.xv(b)}if(this.eg===V.hf||this.dd!==V.Zg)c=this.wh.start().tO(b),a=a.timeStamp()-this.pt,1E-6>
a&&(a=10),this.wh.setVelocity(c/a*1E3),this.wh.xv(b)},qH:function(){return this.fa===V.Cd?V.Cd:V.gf}};var of;of=function(a,b,c){this.ta=a;this.za=b;this.pb=c;this.yf=new Sg;this.ar=this.ca=null};
of.prototype={xR:function(a){var b=a.wc().size();this.ca=a;0>=this.za.da&&0>=this.za.Z&&(this.za.Z=b.L,this.za.da=b.aa)},id:function(){return this.ta},zD:function(a){this.ar=a},flags:function(){return this.pb},vj:function(a){this.pb|=a},$:function(a){return(this.pb&a)===a},info:function(){return this.yf},Wt:function(a){return a.X>=this.za.u&&a.X<=this.za.Z&&a.Y>=this.za.v&&a.Y<=this.za.da},xo:function(a,b,c,d){if(!Y.Hj(d,Y.Cv)){var e=Math.abs(b.X-c.X);b=Math.abs(b.Y-c.Y);if(Y.Hj(a,Y.Dv)&&e>b||Y.Hj(a,
Y.Ev)&&b>e)d=Y.af(d,a)}return d},Rt:function(){var a=Y.gi,b=this.yf.zoom(),c=this.yf.scroll(),d=b.fg,e=c.eb,f=this.MB();d<b.Va().Dc&&(a=Y.af(a,Y.Jq),a=Y.af(a,Y.Kv));d>b.Va().Cc&&(a=Y.af(a,Y.Iq),a=Y.af(a,Y.Jv));e.X<f.u&&(a=Y.af(a,Y.fk),a=this.xo(Y.Hv,e,c.Va().Dc,a));e.Y<f.v&&(a=Y.af(a,Y.gk),a=this.xo(Y.Iv,e,c.Va().Dc,a));e.X>f.Z&&(a=Y.af(a,Y.ii),a=this.xo(Y.Fv,e,c.Va().Cc,a));e.Y>f.da&&(a=Y.af(a,Y.ji),a=this.xo(Y.Gv,e,c.Va().Cc,a));return a},UC:function(a){var b=this.info().scroll(),c=b.Va();Y.$(a,
Y.fk)&&b.Sg(new I(c.Dc.X,b.eb.Y));Y.$(a,Y.gk)&&b.Sg(new I(b.eb.X,c.Dc.Y));Y.$(a,Y.ii)&&b.Sg(new I(c.Cc.X,b.eb.Y));Y.$(a,Y.ji)&&b.Sg(new I(b.eb.X,c.Cc.Y))},MB:function(){var a=this.za.zc().Sf(this.yf.scroll().Va().Cc);var b=this.za.Xd().Sf(this.yf.scroll().Va().Dc);b=(new Bb(a.X,a.Y,b.X,b.Y)).NN(this.yf.zoom().ed,this.yf.zoom().fg);a=this.za.zc().Sf(b.zc());b=this.za.Xd().Sf(b.Xd());b=new Bb(a.X,a.Y,b.X,b.Y);a=b.Xd().min(this.yf.scroll().Va().Dc);b=b.zc().min(this.yf.scroll().Va().Cc);return new Bb(a.X,
a.Y,b.X,b.Y)}};var Wc;Wc={gi:0,ow:1,AG:3,KT:4,Uv:8,Fw:16,Nw:32,si:64,NF:128,hE:256,OT:512,gq:1024,Km:2048};var Sg;Sg=function(){this.vN=new Tg;this.lM=new Ug;new Bb(0,0,0,0);this.Jf=[]};
Sg.prototype={zoom:function(){return this.vN},scroll:function(){return this.lM},zR:function(){},Tu:function(a){return this.Jf.length>a?(a=this.Jf[a],"undefined"!==typeof a?a:null):null},TD:function(a,b){this.Jf[a]=b},nP:function(a){for(var b=0;b<this.Jf.length;++b)if("undefined"===typeof this.Jf[b]||null!==this.Jf[b]&&this.Jf[b].Jn===a)this.Jf[b]=null}};var Ug;Ug=function(){this.vs=new dd;this.Ei=new I(0,0);this.eb=new I(0,0);this.uf=new I(0,0)};
Ug.prototype={Va:function(){return this.vs},ER:function(a){this.Ei=a},kO:function(){return this.eb},Sg:function(a){this.eb=a},CR:function(a){this.eb.X=a},DR:function(a){this.eb.Y=a},Ye:function(){return this.uf},CD:function(a){this.uf.X=a},DD:function(a){this.uf.Y=a}};var Tg;Tg=function(){this.vs=new Wg;this.ed=new I(0,0);this.tf=new I(0,0);this.fg=1;this.qo=this.Fo=0};
Tg.prototype={Va:function(){return this.vs},Sj:function(a){this.ed=a},Rp:function(a){this.fg=a},OS:function(a){this.Fo=a},orientation:function(){return this.qo},setOrientation:function(a){this.qo=a}};var pf;pf=function(a,b,c,d){this.Jn=a;this.xs=b;this.ys=c;this.Gs=d};pf.prototype={offset:function(){return this.Gs}};var Hg;Hg=function(){this.T=[]};
Hg.prototype={XB:function(a){var b;switch(a.type()){case V.$g:var c=Wc.AG;break;case V.bd:c=Wc.ow;break;case V.hf:c=Wc.Uv;break;case V.Ge:c=Wc.Fw;break;default:c=0}for(b=0;b<this.T.length;++b)if(this.T[b].$(c)&&(a.type()===V.$g&&this.T[b].Wt(a.data().nt)||a.type()===V.bd&&this.Dx(this.T[b],a.data().start(),a.data().pv())||a.type()===V.hf&&this.Dx(this.T[b],a.data().start(),a.data().pv())||a.type()===V.Ge&&this.Yq(a.data().touches(),this.T[b]))){if(this.T[b].$(Wc.Km))break;return this.T[b]}return null},
DO:function(a,b,c){var d;for(d=0;d<this.T.length&&(!this.T[d].$(Wc.Km)||!this.Yq(a.touches(),this.T[d]));++d)if(this.T[d].$(Wc.Fw)&&this.T[d].$(b)&&(!c||null===a.xb||null===this.T[d].ca||J.PB(this.T[d].ca.P(),a.xb.target))&&this.Yq(a.touches(),this.T[d]))return this.T[d];return null},GN:function(a,b){var c,d,e=[],f=!1;for(c=0;c<this.T.length;++c){for(d=0;d<a.touches().length;++d){var g=this.pr(this.T[c],a.touches()[d]);if(!e[d]&&g){if(this.T[c].$(Wc.Km)){f=!0;break}this.T[c].$(Wc.NF)&&this.T[c].$(b)&&
(e[d]=!0)}}if(f)break}for(d=0;d<a.touches().length;++d)if(!0!==e[d])return!1;return!0},pr:function(a,b,c){var d=a.ca;var e=b.location().current();e=a.Wt(e);return null!==d&&(e=J.dk(d.S),a.zD(a.za.Pb(e.X,e.Y)),(e=a.ar.contains(b.Od))&&void 0!==c&&null!==c&&!J.PB(d.P(),c))?!1:e},Dx:function(a,b,c){var d=a.ca;b=a.Wt(b);null!==d&&(d=J.dk(d.S),a.zD(a.za.Pb(d.X,d.Y)),b=a.ar.contains(c));return b},Yq:function(a,b){var c;for(c=0;c<a.length;++c)if(!this.pr(b,a[c]))return!1;return!0},RN:function(a,b,c){b[0]=
!1;b[1]=!1;if(1===a.touches().length){var d=a.xb;if(void 0!==d&&null!==d)var e=d.target;for(d=0;d<this.T.length;++d)if(this.pr(this.T[d],a.touches()[0],e)){if(this.T[d].$(Wc.Km))break;var f=!1;this.T[d].$(Wc.ow)&&this.T[d].$(c)&&(f=b[0]=!0,a.LD(this.T[d].ca));this.T[d].$(Wc.Uv)&&this.T[d].$(c)&&(f=b[1]=!0,a.LD(this.T[d].ca));if(!f)break}}},clear:function(){this.T=[]},Kt:function(a,b){b?this.T.push(a):this.T.unshift(a)},MQ:function(a){this.T=this.T.filter(function(b){return b.ca!==a})},wc:function(a){return this.T.length>
a?this.T[a]:null},WO:function(a){for(var b=0;b<this.T.length;++b)if(this.T[b].id()===a)return this.T[b];return null},oP:function(a){for(var b=0;b<this.T.length;++b)this.T[b].info().nP(a)}};var dd;dd=function(){this.Dc=new I(0,0);this.Cc=new I(0,0)};dd.prototype={$h:function(a){this.Dc=a},Zh:function(a){this.Cc=a}};var Wg;Wg=function(){this.Cc=this.Dc=0};Wg.prototype={gv:function(a){this.Dc=a},fv:function(a){this.Cc=a}};var Xg;Xg=function(){};
Xg.prototype={Th:function(a,b){null!==b.ca&&b.ca.Th(a,b)},Ip:function(){},Pt:function(){},Kj:function(a){null!==a.ca&&a.ca.Kj(a);return a.info().scroll().Ei.Pb(a.info().scroll().eb)}};var Jg;Jg=function(){Xg.call(this)};Jg.prototype=Object.create(Xg.prototype);Jg.prototype.constructor=Jg;var Kg;Kg=function(a,b){Xg.call(this);b||(this.gt=this.Ix(a.width,a.height),this.BL=this.aI())};Kg.prototype=Object.create(Xg.prototype);q=Kg.prototype;q.constructor=Kg;
q.Th=function(a,b){var c=a.Gg();c.save();a.g.ra.g.N.Zi?null!==b.info().Tu(0)&&this.Ip(a,b):(this.wL(c,b),this.xL(c,b));c.restore()};q.wL=function(a,b){var c=b.za.u,d=b.za.v,e=b.za.C()+1;b=b.za.B()+1;a.fillStyle=this.BL;a.fillRect(c,d,e,b)};q.xL=function(a,b){var c=b.za.u,d=b.za.v,e=b.za.C()+1,f=b.za.B()+1;a.beginPath();a.rect(c,d,e,f);a.clip();this.PA(a,b,null);a.drawImage(this.gt,c,d,e,f,c,d,e,f)};
q.Ip=function(a,b){var c=a.Gg();var d=b.za.u;var e=b.za.v;var f=b.za.C()+1;var g=b.za.B()+1;c.beginPath();c.rect(d,e,f,g);c.clip();for(e=0;e<b.info().Jf.length;++e)d=b.info().Tu(e),null!==d&&(f=a.te.Np(d.Jn),f=f.fn.canvas,c.save(),this.PA(c,b,d),c.drawImage(f,0,0),c.restore())};
q.PA=function(a,b,c){a.translate(b.info().zoom().ed.X,b.info().zoom().ed.Y);a.scale(b.info().zoom().fg,b.info().zoom().fg);a.translate(-b.info().zoom().ed.X,-b.info().zoom().ed.Y);a.translate(null!==c&&c.xs?0:b.info().scroll().eb.X,null!==c&&c.ys?0:b.info().scroll().eb.Y);null!==c&&a.translate(b.za.u-c.offset().X,b.za.v-c.offset().Y)};
q.Pt=function(a,b){var c=this.gt.getContext("2d");c.drawImage(a.Oa.canvas,b.u,b.v,b.C(),b.B(),b.u,b.v,b.C(),b.B());c.drawImage(a.Rl().canvas,b.u,b.v,b.C(),b.B(),b.u,b.v,b.C(),b.B())};q.Ix=function(a,b){var c=window.document.createElement("canvas");c.width=a;c.height=b;return c};
q.aI=function(){var a=this.Ix(8,8),b=a.getContext("2d");b.fillStyle="#fff";b.fillRect(0,0,a.width,a.height);b.wU="#000";b.lineWidth=1;b.beginPath();b.moveTo(b.lineWidth/2,a.height);b.lineTo(b.lineWidth/2,b.lineWidth/2);b.lineTo(a.width,b.lineWidth/2);b.stroke();b.closePath();return this.gt.getContext("2d").createPattern(a,"repeat")};q.Kj=function(a){return a.info().scroll().Ei.Pb(a.info().scroll().eb)};var ac,Yg;Yg=function(){this.Go=-1;this.$b=!1};
ac=function(a){this.g=a;this.ll=this.$b=this.$i=!1;this.nz=this.ss=this.lz=this.ps=0;this.Ve=null;this.fo=!1;this.Fz=0;this.sn=this.es=!1;this.ue=[];this.oz=[];this.FK=5;this.qs=0;this.Af=null};
ac.prototype={$S:function(a){this.$i||this.mK();this.$b&&(1>a||a>ra.hw?N.warn("Cannot benchmark with invalid type: "+a):(this.ss=J.ak(),this.ue[a].$b=!0,this.ue[a].Go=this.ss))},zO:function(a,b){if(this.$b&&!a){a=J.ak();var c=!1;b==ra.yq&&(this.nz=a-this.lz,this.lz=a,this.oz[this.qs]=(a-this.ss)/1E3,this.qs=(this.qs+1)%this.FK);this.fo&&(this.ps=a-this.ue[ra.Wg].Go,this.fo=this.ue[ra.Wg].$b=!1,c=!0);this.ll&&(c&&this.dA(this.ps,ra.Wg),c=this.ue[b],c.$b&&this.dA(a-c.Go,b))}},$C:function(a){this.$b&&
this.Wi(D.mi(a),a.currentTarget)},Wi:function(a,b){this.Fz=J.ak();this.es?this.ue[ra.Wg].$b=!1:(this.Af=b,this.sn||(this.Ve=a),this.GA())},aD:function(a){this.$b&&this.Xi(D.mi(a),a.currentTarget)},Xi:function(a,b){this.sn&&3E6<J.ak()-this.Fz&&(this.Ve=a);this.es&&(this.Af=b,this.sn||(this.Ve=a),this.GA())},ZC:function(){return null===this.Ve?new I(-1,-1):this.Ve},UP:function(a){this.$b&&this.Wi(D.mi(a),a.currentTarget)},VP:function(a){this.$b&&this.Xi(D.mi(a),a.currentTarget)},kT:function(a,b){this.$b&&
this.Wi(a,b.currentTarget)},jT:function(a,b){this.$b&&this.Xi(a,b.currentTarget)},cm:function(a){this.$b&&(this.g.la?(a=this.g.ba().wa(),null!==a&&null!==this.Af&&null!==a.S&&void 0!==a.S&&null!==this.Af.firstChild&&void 0!==this.Af.firstChild&&null!==a.S.firstChild&&void 0!==a.S.firstChild&&null!==this.Af.firstChild.id&&void 0!==this.Af.firstChild.id&&a.S.firstChild.id===this.Af.firstChild.id&&(this.Af=null,this.fo=!0)):null===this.Ve||null===a||this.Ve.X<a.u||this.Ve.X>a.Z||this.Ve.Y<a.v||this.Ve.Y>
a.da||!this.ue[ra.Wg].$b||(this.fo=!0))},TN:function(){this.cm(null)},MP:function(){return Math.round(this.ps/1E3)},NP:function(){return Math.round(this.nz/1E3)},dA:function(a,b){a=new Ba(2097152,this.g.A.ma,b,a&4294967295);a.LS();this.g.ud(a)},mK:function(){var a=this.g.getConfiguration();this.$b=a.Benchmarking||a.DebugOnlyDiagnosisDisplay;this.ll=a.Benchmarking;this.es=a.DebugOnlyInputReactionOnUp;this.sn=a.DebugOnlyInputReactionExplCoord;this.ue.push(null);for(a=1;a<=ra.hw;a++)this.ue.push(new Yg);
this.$i=!0},GA:function(){this.ue[ra.Wg].$b=!0;this.ue[ra.Wg].Go=J.ak()}};var za;
(function(){function a(b){if(0>b)throw"Only non negative values supported";if(4294967296<=b)throw"Only values occupiing less than 32-Bit supported";}za=function(b){if(void 0!==b)if("number"==typeof b)a(b),this.Ib=b,this.ec=0;else if(b instanceof za)this.Ib=b.Ib,this.ec=b.ec;else throw"Unexpected initial value";else this.ec=this.Ib=0};za.prototype={vq:function(b){if(0>b||64<=b)throw"Unexpected shift amount";if(32<b)this.vq(32),this.vq(b-32);else if(32===b)this.ec=this.Ib,this.Ib=0;else{var c=this.YH(b);
var d=(c&this.Ib)>>>0;this.ec=this.ec<<b>>>0;this.ec=(this.ec|d>>>32-b)>>>0;this.Ib&=~c;this.Ib=this.Ib<<b>>>0}},iw:function(b){if("number"==typeof b)a(b),this.iw(new za(b));else if(b instanceof za)this.Ib=(this.Ib|b.Ib)>>>0,this.ec=(this.ec|b.ec)>>>0;else throw"Unexpected argument";},KE:function(b){return b instanceof za?this.Ib===b.Ib&&this.ec===b.ec:!1},YH:function(b){var c,d=0;if(0===b)return 0;for(c=0;c<b-1;++c)d=(d|2147483648)>>>0,d>>>=1;return(d|2147483648)>>>0},toString:function(){return this.ec+
" "+this.Ib}}})();var sb;sb=function(){this.clear()};sb.prototype={clear:function(){this.T=[]},Kt:function(a){this.T.push(a)},iB:function(a){a.beginPath();for(var b=0;b<this.T.length;++b)a.rect(this.T[b].u,this.T[b].v,this.T[b].C(),this.T[b].B());a.clip()}};var ud;
ud=function(a,b){this.J=a;this.h=b;this.ex=[];this.Qx=[];b=this.xa(this.J);for(a=0;a<this.h;++a){var c=Math.floor(b.Ra+(a+1)*(128-Math.floor(b.Ra/2))/this.h);this.ex[this.h-a-1]=this.l(b.Hc,b.yd,c,b.a);c=Math.floor(Math.floor(b.Ra/3)+Math.floor(2*a*b.Ra/(3*this.h)));this.Qx[a]=this.l(b.Hc,b.yd,c,b.a)}};
ud.prototype={HO:function(a){return this.ex[a]},cC:function(a){return this.Qx[a]},xa:function(a){var b={};var c=((a&16711680)>>16)/255;var d=((a&65280)>>8)/255;var e=(a&255)/255;var f=Math.min(c,Math.min(d,e));var g=Math.max(c,Math.max(d,e));var k=g-f;b.Ra=(f+g)/2;if(0===k)b.Hc=b.yd=0;else{b.yd=.5>b.Ra?k/(g+f):k/(2-g-f);f=((g-c)/6+k/2)/k;var l=((g-d)/6+k/2)/k;k=((g-e)/6+k/2)/k;c===g?b.Hc=k-l:d===g?b.Hc=1/3+f-k:e===g&&(b.Hc=2/3+l-f);0>b.Hc&&(b.Hc+=1);1<b.Hc&&--b.Hc}b.Hc=Math.round(255*b.Hc);b.yd=Math.round(255*
b.yd);b.Ra=Math.round(255*b.Ra);b.a=Math.round(((a&4278190080)>>24)/255*255);return b},l:function(a,b,c,d){var e;if(0===b)c=e=a=c;else{a/=255;b/=255;c/=255;b=.5>c?c*(1+b):c+b-c*b;var f=2*c-b;c=Math.round(255*this.Ur(f,b,a+1/3));e=Math.round(255*this.Ur(f,b,a));a=Math.round(255*this.Ur(f,b,a-1/3))}return(d<<24)+(c<<16)+(e<<8)+a},Ur:function(a,b,c){0>c&&(c+=1);1<c&&--c;return 1>6*c?a+6*(b-a)*c:1>2*c?b:2>3*c?a+(b-a)*(2/3-c)*6:a}};var pc;
pc=function(a){this.g=a;this.fu=function(b){b.preventDefault()};a=this.g.getConfiguration();this.Qn=!0;a.ContextMenuDisabled?(J.bb().addEventListener("contextmenu",this.fu),this.Qn=!1):a.TouchContextMenuEnabled&&(this.Qn=!1)};
pc.prototype={hp:function(){var a=this;this.px();this.qb=window.setTimeout(function(){a.hu()},500)},fp:function(){this.Qn&&(this.hu(),J.bb().addEventListener("contextmenu",this.fu))},px:function(){-1!==this.qb&&(window.clearTimeout(this.qb),this.qb=-1)},hu:function(){this.Qn&&(this.px(),J.bb().removeEventListener("contextmenu",this.fu))}};var Eb;Eb=function(){};
Eb.prototype={cB:function(a,b){this.wM(a,b,90)},zC:function(a){return""!==this.vp(a)},vp:function(a){return this.zJ(a)},wM:function(a,b,c){var d=new Date;d.setTime(d.getTime()+864E5*c);document.cookie=a+"="+b+"; expires="+d.toUTCString()},zJ:function(a){a+="=";var b,c;var d=document.cookie.split(";");for(b=0;b<d.length;b++){for(c=d[b];" "==c.charAt(0);)c=c.substring(1);if(-1!==c.indexOf(a))return c.substring(a.length,c.length)}return""}};var cd;cd=function(){};
cd.J=function(a){a=window.atob(a.substring(a.indexOf("-----BEGIN PUBLIC KEY-----")+26,a.indexOf("-----END PUBLIC KEY-----")));a=J.iT(a);return this.pq().subtle.importKey("spki",a,{name:"RSA-OAEP",hash:"SHA-256"},!0,["encrypt"])};cd.l=function(a,b){return this.pq().subtle.encrypt({name:"RSA-OAEP",hash:{name:"SHA-256"}},a,b)};cd.h=function(){var a=new Uint8Array(16);a=this.pq().getRandomValues(a);return J.SC(a.buffer)};
cd.pq=function(){if(void 0!==window.crypto&&void 0!==window.crypto.subtle)return window.crypto;if(void 0!==window.msrCrypto&&void 0!==window.msrCrypto.subtle)return window.msrCrypto};var gc;gc=function(a){this.Cb=a.Hg();this.Ji=a.wd()};gc.prototype={};var Ab;Ab=function(a){this.g=a;this.cc=[]};
Ab.prototype={xj:function(){if(null!==this.g.getConfiguration()&&this.g.getConfiguration().DebugOnlyDiagnosisDisplay){var a=13*this.cc.length+3;var b=document.getElementById("diag");null===b&&(b=J.wm(175,150),b.id="diag",b.style.zIndex=8,b.style.position="absolute",J.bb().parentNode.appendChild(b));b=this.Lk(b);this.WG();b.save();b.strokeStyle="rgb(0,0,0)";b.fillStyle="rgb(220,220,220)";b.font="10px Arial";b.beginPath();b.rect(10,10,150,a);b.clip();b.fillRect(10,10,150,a);b.strokeRect(10,10,150,a);
b.fillStyle="rgb(0,0,0)";b.textAlign="left";b.textBaseline="top";for(a=0;a<this.cc.length;++a){var c=J.h("{0}: {1}",this.cc[a].title,this.cc[a].Tf());b.fillText(c,13,13+13*a)}b.restore()}},WG:function(){if(0===this.cc.length){var a=this.g.qc,b=this.g.V(),c=this;this.cc.push({title:"DPR",Tf:function(){return b.su()?J.h("{0} (Changed)",D.df()):D.df()}});this.cc.push({title:"Canvas-Size",Tf:function(){return J.h("{0}/{1}",b.Qf().C(),b.Qf().B())}});this.cc.push({title:"Resize-Count",Tf:function(){return null!==
a?a.Jz:"---"}});this.cc.push({title:"Window-Size",Tf:function(){return J.h("{0}/{1}",window.innerWidth,window.innerHeight)}});this.cc.push({title:"DocElem-Size",Tf:function(){return J.h("{0}/{1}",document.documentElement.clientWidth,document.documentElement.clientHeight)}});this.cc.push({title:"Last Input Reaction (*)",Tf:function(){return J.h("{0}",c.g.ub.MP())}});this.g.getConfiguration().DebugOnlyInputReactionExplCoord&&this.cc.push({title:"Input check coords",Tf:function(){return J.h("{0}/{1}",
c.g.ub.ZC().X,c.g.ub.ZC().Y)}});this.cc.push({title:"FPS (*)",Tf:function(){return(1E3/c.g.ub.NP()).toFixed(1)}});this.cc.push({title:"PTs (*)",Tf:function(){return c.g.ub.oz.map(function(d){return d.toFixed(0)}).join(", ")}})}},Lk:function(a){a=a.getContext("2d");if(null===a)throw Error("Creating graphics context failed");return a}};var Tb;Tb=function(a){this.g=a;this.o=null;this.nr=this.Gl=!1;this.vk=this.nc=null;this.gb=[]};
Tb.prototype={ap:function(a){(J.Pq(a)||J.ck(a)&&"touch"===a.pointerType||J.Sq(a))&&this.wu()&&(this.Ut(this.g.getConfiguration().CommitEditcontrolOnClickOut),this.Rg())},Rg:function(){null!==this.g.qc&&this.g.qc.Rg()},wu:function(){return null!==this.o},open:function(a,b,c){this.o="editcontrol-inputform"===a.id?a.children[1]:a;this.Gl=b;this.DG();c.g.la?(this.vk=c.g.ba().wa(),this.vk.ED(a)):(this.nc=c.Oa.canvas.parentNode,this.Zm=a,this.nc.appendChild(this.Zm))},close:function(){this.Rg();null!==
this.o&&(null!==this.nc&&null!==this.Zm&&this.nc.removeChild(this.Zm),null!==this.vk&&this.vk.ED(null),this.sl());this.vk=this.Zm=this.nc=this.o=null},$N:function(a){for(var b=0;b<a.length;b++)if(255<a.charCodeAt(b))return!1;return!0},Ut:function(a){if(!this.nr){var b=J.cq(this.o);if(this.Gl||this.g.getConfiguration().Qq||this.$N(this.o.value))var c=new Ec(this.o.value,this.Gl,this.g.getConfiguration().wd());else{if(a)return;c=new Ec("",!1,this.g.getConfiguration().wd())}var d=c.length()+1;this.Gl&&
(d*=2);d=Ga.F(d);Cc.F(d,this.g.A.Ia,this.g.getConfiguration().wd()).jc(c);c=new Ba(512,this.g.A.ma,a?this.Gl?3:1:2,0);c.Qb(d);c.OD(b.FC(4));this.g.yb.push(c);a?this.nr=!0:this.close()}},RQ:function(){this.nr=!1},Xb:function(){return this.o},OI:function(a){null!==this.o&&(a.stopPropagation(),27===a.keyCode?(a.preventDefault(),this.Ut(!1)):13===a.keyCode&&this.Ut(!0))},NI:function(a){a.stopPropagation()},RI:function(a){a.stopPropagation()},QI:function(a){a.stopPropagation()},Hi:function(a){a.stopPropagation()},
DG:function(){var a=this,b;this.gb.push({e:"keydown",Ra:function(c){a.OI(c)}});this.gb.push({e:"keyup",Ra:function(c){a.RI(c)}});this.gb.push({e:"focus",Ra:function(c){a.NI(c)}});this.gb.push({e:"keypress",Ra:function(c){a.QI(c)}});D.Tb()?(this.gb.push({e:"pointerup",Ra:function(c){a.Hi(c)}}),this.gb.push({e:"pointerdown",Ra:function(c){a.Hi(c)}})):(this.gb.push({e:"mouseup",Ra:function(c){a.Hi(c)}}),this.gb.push({e:"mousedown",Ra:function(c){a.Hi(c)}}),this.gb.push({e:"touchstart",Ra:function(c){a.Hi(c)}}),
this.gb.push({e:"touchend",Ra:function(c){a.Hi(c)}}));for(b=0;b<this.gb.length;++b)this.o.addEventListener(this.gb[b].e,this.gb[b].Ra)},sl:function(){var a;for(a=0;a<this.gb.length;++a)this.o.removeEventListener(this.gb[a].e,this.gb[a].Ra);this.gb=[]}};var Ec;Ec=function(a,b,c){c=new Zg(c);this.gn=null;this.UG=b;if(null!==a)if(b){b=Array(a.length);for(c=0;c<a.length;c++)b[c]=a.charCodeAt(c);this.gn=b}else this.gn=c.jb(a)};
Ec.prototype={length:function(){return this.gn.length},data:function(){return this.gn},unicode:function(){return this.UG}};var Zg;Zg=function(a){void 0===a&&(a=null);this.no=a};Zg.prototype={XG:function(){if(null===this.no)try{this.no=(new Configuration).wd()}catch(a){this.no={encode:function(){return 63}}}},jb:function(a){this.XG();return this.no.encode(a)}};var xc;xc=function(a,b){this.Bi=a;this.dI=J.l();this.QK=null!==b?b.ConnectionInfoValidTimeMsForLeaveAfterError:1E3};
xc.prototype={cT:function(){return J.l()-this.dI<this.QK}};var ah;ah=function(){this.Fb=[]};ah.prototype={MF:function(a){this.Fb.push(a)},kE:function(){this.Fb.splice(0,this.Fb.length)},Wv:function(a){this.Fb.forEach(a)},XF:function(a){0<=a&&this.Fb.splice(a,1)},Size:function(){return this.Fb.length},wG:function(a){this.Wv(function(b){b.update&&b.update(a)})},mE:function(a){a.Jh&&this.Wv(function(b){a.Jh(b)})}};var Sa;
Sa=function(a){try{this.h(a)}catch(b){throw Error("Parsing the fontstring '"+a+"' failed for the following reason: "+b);}};
Sa.prototype={h:function(a){var b=null,c=null,d,e=!1,f=a.split(/\s+/);for(d=0;d<f.length;++d){var g=f[d];switch(g){case "normal":break;case "italic":case "oblique":break;case "small-caps":break;case "bold":case "bolder":case "lighter":case "100":case "200":case "300":case "400":case "500":case "600":case "700":case "800":case "900":break;default:null===c?(g=g.split("/"),g=J.bi(g[0]),"p"===g.charAt(g.length-2)&&"x"===g.charAt(g.length-1)&&(c=parseInt(g.substr(0,g.length-2),10))):(b=g,d<f.length-1&&
(b+=" "+f.slice(d+1).join(" ")),e=!0)}if(e)break}if(null===b)throw Error("Font Family/Name missing");if(null===c||isNaN(c))throw Error("Invalid or unsupported font Size");this.NE=c;this.oq=a}};var Xb;Xb=function(){ah.call(this)};Xb.prototype=Object.create(ah.prototype);q=Xb.prototype;q.constructor=Xb;q.tm=function(a){for(var b=0;b<this.Fb.length;b++)if(this.Fb[b].id()===a)return b;return-1};
q.BG=function(a,b){a=this.tm(a);if(0<=a){var c=this.Fb[a];this.Fb[a]=b;b.location().KD(c.location().current());b.$u(c.Wk);null!==c.Bk&&null===b.Bk&&b.vv(c.Bk)}};q.Yv=function(a){a=this.tm(a);return 0<=a?this.Fb[a]:null};q.xG=function(a){null!==a&&a.id&&this.BG(a.id(),a)};q.YF=function(a){a=this.tm(a);this.XF(a)};q.nw=function(a){null!==a&&a.id&&this.YF(a.id())};var I;I=function(a,b){this.X=a;this.Y=b};
I.prototype={Xc:function(a){this.X-=a.X;this.Y-=a.Y;return this},Sf:function(a){return this.clone().Xc(a)},min:function(a){return new I(Math.min(this.X,a.X),Math.min(this.Y,a.Y))},max:function(a){return new I(Math.max(this.X,a.X),Math.max(this.Y,a.Y))},offset:function(a){this.X+=a.X;this.Y+=a.Y;return this},Pb:function(a){return this.clone().offset(a)},dQ:function(a){this.X+=a.L;this.Y+=a.aa;return this},eD:function(a){return this.clone().dQ(a)},tc:function(){return(this.Y>>>0&65535|this.X>>>0<<16)>>>
0},tO:function(a){return Math.sqrt(this.gu(a))},gu:function(a){return(this.X-a.X)*(this.X-a.X)+(this.Y-a.Y)*(this.Y-a.Y)},clone:function(){return new I(this.X,this.Y)},hm:function(a){this.X*=a;this.Y*=a;return this},aR:function(a){return this.clone().hm(a)},rotate:function(a,b){if(0===a%360)return this;var c=a*Math.PI/180;a=Math.cos(c);c=Math.sin(c);var d=this.X,e=this.Y;if(b){var f=b.X;b=b.Y}else f=b=0;this.X=d*a-e*c+f*(1-a)+b*c;this.Y=d*c+e*a+b*(1-a)-f*c;return this}};var Bb;
Bb=function(a,b,c,d,e){this.u=a;this.v=b;this.Z=c;this.da=d;this.Bd=void 0!==e?e:null};
Bb.prototype={C:function(){return this.Z-this.u},B:function(){return this.da-this.v},Ql:function(){return new I((this.u+this.Z)/2,(this.v+this.da)/2)},clone:function(){return new Bb(this.u,this.v,this.Z,this.da,this.Bd)},zc:function(){return new I(this.u,this.v)},Xd:function(){return new I(this.Z,this.da)},NN:function(a,b){var c=this.size().scale(b),d=this.zc().Xc(a);b=(new Ja(d.X,d.Y)).scale(b);a=a.eD(b);c=a.eD(c);return new Bb(a.X,a.Y,c.X,c.Y)},size:function(){return new Ja(this.C(),this.B())},
Pb:function(a,b){return new Bb(this.u+a,this.v+b,this.Z+a,this.da+b,this.Bd)},FC:function(a){return new Bb(this.u-a,this.v-a,this.Z+a,this.da+a,this.Bd)},ip:function(a){return this.u===a.u&&this.v===a.v&&this.Z===a.Z&&this.da===a.da},normalize:function(){if(this.u>this.Z){var a=this.Z;this.Z=this.u;this.u=a}this.v>this.da&&(a=this.da,this.da=this.v,this.v=a)},YP:function(){var a=this.clone();a.normalize();return a},xB:function(a){return a>=this.u&&a<=this.Z},yB:function(a){return a>=this.v&&a<=this.da},
contains:function(a){return this.xB(a.X)&&this.yB(a.Y)}};var vc;vc=function(a){this.g=a;this.qk=null;this.$x=!1;this.Jz=0;this.Lz=D.df();this.pd=new ag(this.g)};
vc.prototype={Ll:function(){var a=this;this.pd.Rg();this.pd.ef();this.qk=function(){a.Wq()};window.addEventListener("resize",this.qk,!1)},detach:function(){null!==this.qk&&(window.removeEventListener("resize",this.qk,!1),this.qk=null)},ef:function(){this.pd.ef()},Hq:function(){this.pd.Hq()},Rg:function(){this.pd.Rg()},KS:function(a){this.pd.IS(a)},Ls:function(){var a=D.df(),b=this.$x?a:1;this.pd.Qv()&&(a!==this.Lz&&(this.$x=!0,this.Lz=b=a,this.g.V().aQ()),this.Jz++,this.g.V().iu(b),this.pd.Rg(),null!==
this.g.A&&null!==this.g.getConfiguration()&&(a=Ba.xa(this.g.A.ma,this.g.getConfiguration().BestFit,this.g.getConfiguration().BestFitForDialogs,this.g.getConfiguration().ScaleTypeIsotropic,this.g.V().Qf(),this.g.V().xr,this.g.getConfiguration().FillBackground,!1),this.g.JR(a)));this.pd.ef()},Wq:function(){var a=this;setTimeout(function(){a.Ls()},50)}};var Ja;Ja=function(a,b){this.L=a;this.aa=b};Ja.prototype={scale:function(a){return new Ja(this.L*a,this.aa*a)}};var ag;
ag=function(a){this.g=a;this.hz=this.iz=this.ns=this.os=this.pz=this.qz=0};
ag.prototype={ef:function(){this.qz=window.screen.width;this.pz=window.screen.height;this.os=document.documentElement.clientWidth;this.ns=document.documentElement.clientHeight},Hq:function(){D.cw()&&(this.iz=document.scrollingElement.scrollTop,this.hz=document.scrollingElement.scrollLeft)},Qv:function(){var a=!1;var b=this.g.getConfiguration();if(null!==b){var c=b.MaxResizePixel;this.pz===window.screen.width&&this.qz===window.screen.height&&(a=!0);0<c&&(this.os!==document.documentElement.clientWidth&&
this.ns!==document.documentElement.clientHeight?a=!0:(b=Math.abs(this.os-document.documentElement.clientWidth),0<b&&b<c&&(a=!0),b=Math.abs(this.ns-document.documentElement.clientHeight),0<b&&b<c&&(a=!0)));return a}},IS:function(a){this.jN=a},Rg:function(){D.cw()&&this.jN&&(document.scrollingElement.scrollTop=this.iz,document.scrollingElement.scrollLeft=this.hz)}};var kc;
kc=function(a,b,c,d){this.na=a;this.Qd=b;this.Ox=window.getComputedStyle(document.body,null).backgroundColor;this.Qd.clear(this.Ox);this.GK=J.l();this.FM=J.l();this.hI=d;this.Oe=null;if(c)this.h();else{var e=this,f=function(){e.l();e.qb=window.requestAnimationFrame(f)};this.qb=window.requestAnimationFrame(f)}};
kc.prototype={close:function(){this.Qd.clear(this.Ox);window.cancelAnimationFrame(this.qb)},l:function(){if(!(J.l()-this.FM<this.hI)){var a=this.Qd.Gg(),b=this.Qd.Qf(),c=2*Math.PI/6,d=(2*Math.PI-5*c)/5,e=250/3,f=10+e,g=2*Math.PI*(J.l()-this.GK)/5E3,k=1;a.save();if(250>b.C()||250>b.B())k=.9*Math.min(b.C()/250,b.B()/250);a.scale(k,k);a.translate(Math.max(5,(b.C()-250)/2),Math.max(5,(b.B()-250)/2));a.strokeStyle="#a90018";a.lineWidth=4;a.strokeRect(0,0,250,250);a.fillStyle="#f4f4f4";a.fillRect(0,0,250,
250);for(b=0;5>b;++b)a.save(),a.translate(125,f),a.rotate(g+b*(c+d)),this.HI(a,c,e,"#cd001c"),a.restore();null===this.Oe&&this.kI(a,250);a.font=this.Oe;a.textAlign="center";a.textBaseline="bottom";a.fillStyle="#000000";a.fillText(this.na,125,2750/12);a.restore()}},kI:function(a,b){var c=40;for(a.font=this.Ay(c);2<c&&a.measureText(this.na).width>=.95*b;)c-=2,a.font=this.Ay(c);this.Oe=a.font},Ay:function(a){return"italic "+a+"px Arial"},HI:function(a,b,c,d){var e=.9*c;a.beginPath();a.moveTo(0,-c);a.arc(0,
0,c,-Math.PI/2,b-Math.PI/2,!1);a.lineTo(Math.sin(b)*e,-(Math.cos(b)*e));a.arc(0,0,e,b-Math.PI/2,-Math.PI/2,!0);a.lineTo(0,-c);a.closePath();a.strokeStyle=d;a.fillStyle=a.strokeStyle;a.stroke();a.fill()},h:function(){var a=this.Qd.Rl();a.font="1em Arial";a.textAlign="left";a.textBaseline="top";a.fillStyle="#000";a.fillText(this.na,20,20)}};var hc;
(function(){var a={},b={},c={},d={};var e=function(g,k,l){this.jx=g;this.lH=k;this.hc=l;this.ix=1;this.qf=0};e.prototype={qB:function(g){this.ix=this.hc/g;this.qf=0},hT:function(g){this.qf=g.qf},call:function(g){0===g%this.ix&&this.lH(this.jx,this.qf++)}};var f=function(g){this.hc=g;this.Hx=0;this.fh=[];this.fs=0};f.prototype={vP:function(g){return this.ky(g)!==d},ZN:function(g){return 0<=this.qy(g)},Ll:function(g,k,l){var E=this.ky(l),u=new e(g,k,l);if(E===b)u.qB(this.hc);else if(E===c){var ka=this;
this.hc=l;this.Bn(function(ja){ja.qB(ka.hc)});this.stop();this.start()}this.Bn(function(ja){return ja.hc===l?(u.hT(ja),!0):!1});this.fh.push(u)},detach:function(g){g=this.qy(g);return 0<=g&&(this.fh.splice(g,1),0===this.fh.length)?(this.stop(),!0):!1},start:function(){var g=this;this.fs=setInterval(function(){g.Ke()},this.hc)},stop:function(){clearInterval(this.fs);this.fs=0},Ke:function(){var g=this;this.Hx++;this.Bn(function(k){k.call(g.Hx)})},qy:function(g){for(var k=0;k<this.fh.length;++k)if(this.fh[k].jx===
g)return k;return-1},Bn:function(g){for(var k=0;k<this.fh.length&&!g(this.fh[k]);++k);},ky:function(g){if(this.hc===g)return a;if(g/this.hc===Math.floor(g/this.hc)&&8>=g/this.hc)return b;if(this.hc/g===Math.floor(this.hc/g)&&8>=this.hc/g){var k=0;this.Bn(function(l){k=Math.max(k,l.hc/g)});return 8<k?d:c}return d}};hc=function(){this.Mf=[]};hc.prototype={aT:function(g,k,l){var E=this.kJ(l);null===E&&(E=new f(l),E.start(),this.Mf.push(E));E.Ll(g,k,l)},eT:function(g){var k=this.jJ(g);null!==k&&k.detach(g)&&
this.TL(k)},kJ:function(g){for(var k=0;k<this.Mf.length;++k)if(this.Mf[k].vP(g))return this.Mf[k];return null},jJ:function(g){for(var k=0;k<this.Mf.length;++k)if(this.Mf[k].ZN(g))return this.Mf[k];return null},TL:function(g){g=this.Mf.indexOf(g);0<=g&&this.Mf.splice(g,1)}}})();var yb;yb=function(a){this.Qd=a;this.wl=[]};
yb.prototype={clear:function(){this.wl=[]},count:function(){return this.wl.length},C:function(a){return this.wl[a].X},B:function(a){return this.wl[a].Y},bB:function(a,b,c){a=Q.yF(this.Qd,a,b,c);this.wl.push(a)}};var zb;zb=function(a){this.Qd=a;this.fj=[]};
zb.prototype={clear:function(){this.fj=[]},count:function(){return this.fj.length},vp:function(a){return this.fj[a]},BN:function(a){this.fj.push(a.length+1);var b;for(b=1;b<=a.length;b++){var c=Q.Xg(this.Qd.getContext(),a.substring(0,b),!0);this.fj.push(c)}a=J.Sb(this.Qd);this.fj.push(a)}};var mf;mf=function(){this.zz=this.Az=this.Bz=this.Cz=this.by=this.ey=this.mb=null};mf.h=function(a,b,c,d,e,f){var g=new mf;g.zz=a;g.Az=b;g.Bz=c;g.Cz=d;g.by=e;g.ey=f;return g};
mf.prototype={Wo:function(a,b){null!==this.mb?this.fM(a,b):this.TG(a)},fM:function(a,b){a.translate(b.u,b.v);a.rotate(this.mb);a.translate(-b.u,-b.v)},TG:function(a){a.transform(this.zz,this.Az,this.Bz,this.Cz,this.by,this.ey)}};var Ka;
Ka={Na:function(a){if(null!==a){if("false"===a.toLowerCase())return!1;if("true"===a.toLowerCase())return!0}return null},$F:function(){var a={};location.search.substr(1).split("&").forEach(function(b){b=b.split("=");a[b[0]]=b[1]});return a},zm:function(a,b){return void 0===a[b]?null:a[b]},xF:function(a){a=(new RegExp("[\\?&]"+a+"=([^&#]*)")).exec(window.location.href);return null===a?null:a[1]},gw:function(a){var b=window.WebvisuInst;return void 0===b?Ka.xF(a):Ka.zm(b.Ag,a)},bk:function(a,b,c){return null!==
Ka.zm(a,b)?Ka.Na(a[b]):c},QE:function(a,b){a=Ka.gw(a);return null!==a?Ka.Na(a):b},RE:function(a){a=Ka.gw(a);return null!==a?parseInt(a,10):null}};var J;J=function(){};J.nT=function(){var a=window.performance||{};a.now=function(){return a.now||a.webkitNow||a.l||a.J||a.h||function(){return(new Date).getTime()}}();return a.now()};
J.Fq=function(a){var b=window.location;var c=b.pathname.lastIndexOf("/");-1!==c&&(a=b.pathname.substr(0,c+1)+a,"/"===a[0]&&(a=a.substr(1)));return b.protocol+"//"+b.host+"/"+a};J.Cm=function(a,b,c){var d=3,e=5;void 0===a&&(a="");void 0===d&&(d=0);void 0===e&&(e=0);void 0===b&&(b=0);void 0===c&&(c=0);a=a.split(".");b=[d,e,b,c];e=d=0;if(4!==a.length)return!1;var f=1E9;for(c=0;3>=c;c++){var g=parseInt(a[c],10);if(isNaN(g))return!1;d+=g*f;e+=b[c]*f;f/=1E3}return d>=e};J.l=function(){return(new Date).getTime()};
J.iT=function(a){if(null===a||void 0===a)return new ArrayBuffer(0);var b=new ArrayBuffer(a.length),c=new Uint8Array(b),d;var e=0;for(d=a.length;e<d;e++)c[e]=a.charCodeAt(e);return b};J.ak=function(){return 1E3*J.nT()};J.FP=function(a,b){var c=a;var d=a.indexOf("px");-1!==d&&(c=a.slice(0,d),d=c.lastIndexOf(" "),d=-1!==d?c.slice(d+1,c.length):c,c=a.replace(d,b));return c};J.Sb=function(a){return J.Vf(a.getState().Qi)};J.Vf=function(a){return 1.15*a};J.sQ=function(a){return.15*a.getState().Qi};
J.cq=function(a){var b=0,c=0,d=a;do b+=d.offsetLeft,c+=d.offsetTop;while(null!==(d=d.offsetParent));return new Bb(b,c,b+a.offsetWidth,c+a.offsetHeight)};J.ab=function(a,b){var c=b instanceof Bb?new I(b.u,b.v):b;a.style.position="absolute";a.style.left=Math.floor(c.X)+"px";a.style.top=Math.floor(c.Y)+"px";b instanceof Bb&&(a.style.width=Math.floor(b.C())+"px",a.style.height=Math.floor(b.B())+"px")};
J.h=function(a){var b=arguments;if(0===b.length)return"";var c=b[0];for(b=1;b<arguments.length;b++){var d=new RegExp("\\{"+(b-1)+"\\}","gi");c=c.replace(d,arguments[b])}return c};J.J=function(a){return a.fd instanceof wc};J.YQ=function(a){return J.h("{0}/{1} {2}/{3}",a.u,a.v,a.Z,a.da)};J.Yc=function(a){return J.h("{0}/{1}",a.X,a.Y)};J.hQ=function(a){var b=0,c;for(c in a)a.hasOwnProperty(c)&&b++;return b};J.bi=function(a){return a.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};
J.wm=function(a,b){var c=window.document.createElement("canvas");c.width=a;c.height=b;return c};J.WP=function(a,b,c){b=J.wm(b,c);b.style.width="100%";b.style.height="100%";b.style.left="0px";b.style.top="0px";b.style.position="absolute";b.style.margin=0;b.style.padding=0;b.id=a;return b};J.YB=function(a){return 0<a?Math.floor(a):Math.ceil(a)};J.Rq=function(a){return 3<=a.length&&"SVG"===a.substring(a.length-3).toUpperCase()};
J.Dm=function(a){var b=a.pageX;a=a.pageY;var c=J.dk(J.bb());return new I(b-c.X,a-c.Y)};J.dk=function(a){var b=a.getBoundingClientRect();a=void 0!==window.pageXOffset?window.pageXOffset:(document.documentElement||document.body.parentNode||document.body).scrollLeft;var c=void 0!==window.pageYOffset?window.pageYOffset:(document.documentElement||document.body.parentNode||document.body).scrollTop;b=new I(b.left,b.top);D.ei()&&b.hm(D.qq());return new I(b.X+a,b.Y+c)};
J.vC=function(a,b){a=a.getBoundingClientRect();if(b===document)return new I(a.left,a.top);b=b.getBoundingClientRect();return new I(b.left-a.left,b.top-a.top)};J.SC=function(a){var b="";a=new Uint8Array(a);var c=a.byteLength,d;for(d=0;d<c;d++)b+=String.fromCharCode(a[d]);return window.btoa(b)};J.pB=function(a){var b=Ga.F(4),c=Cc.F(b,!0);c.Gc(a.X);c.Gc(a.Y);return b};J.PB=function(a,b){for(b=b.parentNode;void 0!==b&&null!==b;){if(a===b)return!0;b=b.parentNode}return!1};
J.$j=function(a,b){var c=0,d=0;null!==a&&(""!==a.style.paddingLeft&&(c=parseInt(a.style.paddingLeft,10)),""!==a.style.paddingTop&&(d=parseInt(a.style.paddingTop,10)));for(;null!==a&&a!==b;){var e=0;void 0!==a.style&&""!==a.style.borderWidth&&(e=parseInt(a.style.borderWidth,10));a.offsetLeft&&(c+=a.offsetLeft+e);a.offsetTop&&(d+=a.offsetTop+e);a=a.parentNode}return new I(c,d)};
J.RP=function(a,b){var c=0,d=0;null!==a&&a.style&&(""!==a.style.paddingLeft&&(c=parseInt(a.style.paddingLeft,10)),""!==a.style.paddingTop&&(d=parseInt(a.style.paddingTop,10)));return new I(b.X-c,b.Y-d)};J.bb=function(){return document.getElementById("cdsRoot")};J.LP=function(a,b){a.g.la&&(a.g.an.em(),a.g.hd.em(),a.g.hd.Lh(b))};J.Uf=function(a){if(J.VB(a))return a.identifier;if(J.ck(a))return a.pointerId;if(J.tQ(a))return 1;throw Error("IllegalArgument!");};
J.VB=function(a){return"undefined"!==typeof Touch&&a instanceof Touch};J.Pq=function(a){return 1===a.which};J.Sq=function(a){return"undefined"!==typeof TouchEvent&&a instanceof TouchEvent};J.ck=function(a){return"undefined"!==typeof PointerEvent&&a instanceof PointerEvent};J.tQ=function(a){return"undefined"!==typeof MouseEvent&&a instanceof MouseEvent};J.xm=function(a,b){b=b.split("_").slice(1);try{for(var c in b){var d=a.Qe(parseInt(b[c],10));a=d.ba()}}catch(e){return null}return void 0!==d?d:null};
J.CC=function(a,b){var c=[],d;for(d=0;d<=b-1;d++)c.push(a.getInt16());return c};J.Dq=function(a){return a(0,0,0,[],null,!0).Ea()};J.Bq=function(a,b,c){c.Rr?(a.u+=Math.floor(a.C()/2)-Math.floor(b.L/2),a.Z=a.u+b.L):c.et?a.u=a.Z-b.L:a.Z=a.u+b.L;c.Dt?(a.v+=Math.floor(a.B()/2)-Math.floor(b.aa/2),a.da=a.v+b.aa):c.gr?a.v=a.da-b.aa:a.da=a.v+b.aa;return a};
J.lB=function(a,b,c){a.C()<b.C()&&(c.Rr?a=a.Pb(Math.floor(b.C()/2)-Math.floor(a.C()/2),0):c.et&&(a=a.Pb(b.C()-a.C(),0)));a.B()<b.B()&&(c.Dt?a=a.Pb(0,Math.floor(b.B()/2)-Math.floor(a.B()/2)):c.gr&&(a=a.Pb(0,b.B()-a.B())));return a};J.Lq=function(a){return"cdsRoot"===a.id};J.FB=function(a){return a&&"[object Date]"===Object.prototype.toString.call(a)&&!isNaN(a)};J.Am=function(a){return"object"===typeof a&&!(a instanceof Array)&&null!==a};
J.bQ=function(a){var b,c="";for(b=0;b<a.length;b++)c=0===b?c+('"'+a[b]+'"'):c+(',"'+a[b]+'"');return c};J.It=function(a,b){for(;a.lastElementChild&&!a.lastElementChild.id.startsWith(b);)a.removeChild(a.lastElementChild)};J.xa=function(a,b){return a.querySelector("#"+b)};var N,jc;N=function(){this.level=jc.vm};N.l=function(a){this.level>=jc.kq&&console.info("--DEBUG--"+JSON.stringify(a))};N.info=function(a){this.level>=jc.vm&&console.info("--INFO--"+JSON.stringify(a))};
N.warn=function(a){this.level>=jc.Jw&&console.warn(a)};N.h=function(a){this.level>=jc.Mq&&console.info("--TRACE--"+JSON.stringify(a))};N.error=function(a){this.level>=jc.Rv&&console.error(a)};N.J=function(a){this.level=a};jc={JT:0,LE:1,Rv:2,Jw:3,vm:4,kq:5,Mq:6};
