// CAS: "1.0.0"
// This software uses the following Open Source software:
// - a simplified (and thus modified) version of stringencoding
//	* Licensed under Apache License 2.0 and Unlicense (can be found here: http://www.apache.org/licenses/, http://unlicense.org/)
//	* Source: https://github.com/inexorabletash/text-encoding
// - requestAnimationFrame polyfill by Erik Möller. fixes from Paul Irish and Tino Zijdel
//	* MIT license
//	* Source: https://gist.github.com/paulirish/1579671
// - a simplified (and thus modified) version of the Microsoft Research JavaScript Cryptography Library (msrCrypto) 
//	* Licensed under Apache License 2.0 (can be found here: http://www.apache.org/licenses/LICENSE-2.0)
//	* Source: https://github.com/microsoft/MSR-JavaScript-Cryptovar r,na,oa;
(function(){function a(ca){var da=0;this.get=function(){return da>=ca.length?-1:Number(ca[da])};this.offset=function(ea){da+=ea;if(0>da)throw Error("Seeking past start of the buffer");if(da>ca.length)throw Error("Seeking past EOF");}}function b(ca){var da=0;this.get=function(){return da>=ca.length?-1:ca[da]};this.offset=function(ea){da+=ea;if(0>da)throw Error("Seeking past start of the buffer");if(da>ca.length)throw Error("Seeking past EOF");}}function c(ca){var da=0;this.h=function(ea){var ba=-1,
Aa;for(Aa=0;Aa<arguments.length;++Aa)ba=Number(arguments[Aa]),ca[da++]=ba;return ba}}function d(ca){var da=0,ea=function(){for(var ba=[],Aa=0,qb=ca.length;Aa<ca.length;){var Ia=ca.charCodeAt(Aa);if(55296<=Ia&&57343>=Ia)if(56320<=Ia&&57343>=Ia)ba.push(65533);else if(Aa===qb-1)ba.push(65533);else{var xa=ca.charCodeAt(Aa+1);56320<=xa&&57343>=xa?(Ia&=1023,xa&=1023,Aa+=1,ba.push(65536+(Ia<<10)+xa)):ba.push(65533)}else ba.push(Ia);Aa+=1}return ba}();this.offset=function(ba){da+=ba;if(0>da)throw Error("Seeking past start of the buffer");
if(da>ea.length)throw Error("Seeking past EOF");};this.get=function(){return da>=ea.length?-1:ea[da]}}function e(){var ca="";this.m=function(){return ca};this.h=function(da){65535>=da?ca+=String.fromCharCode(da):(da-=65536,ca+=String.fromCharCode(55296+(da>>10&1023)),ca+=String.fromCharCode(56320+(da&1023)))}}function f(ca,da){if(ca)throw Error("EncodingError");return da||65533}function g(){throw Error("EncodingError");}function k(ca){ca=String(ca).trim().toLowerCase();if(Object.prototype.hasOwnProperty.call(va,
ca))return va[ca];throw Error("EncodingError: Unknown encoding: "+ca);}function l(ca){var da=ca.fatal,ea=0,ba=0,Aa=0,qb=0;this.decode=function(Ia){var xa=Ia.get();if(-1===xa)return 0!==ba?f(da):-1;Ia.offset(1);if(0===ba){if(0<=xa&&127>=xa)return xa;if(194<=xa&&223>=xa)ba=1,qb=128,ea=xa-192;else if(224<=xa&&239>=xa)ba=2,qb=2048,ea=xa-224;else if(240<=xa&&244>=xa)ba=3,qb=65536,ea=xa-240;else return f(da);ea*=Math.pow(64,ba);return null}if(!(128<=xa&&191>=xa))return qb=Aa=ba=ea=0,Ia.offset(-1),f(da);
Aa+=1;ea+=(xa-128)*Math.pow(64,ba-Aa);if(Aa!==ba)return null;Ia=ea;xa=qb;qb=Aa=ba=ea=0;return xa<=Ia&&1114111>=Ia&&!(55296<=Ia&&57343>=Ia)?Ia:f(da)}}function G(){this.encode=function(ca,da){var ea=da.get();if(-1===ea)return-1;da.offset(1);if(55296<=ea&&57343>=ea)return g(ea);if(0<=ea&&127>=ea)return ca.h(ea);if(128<=ea&&2047>=ea){var ba=1;var Aa=192}else 2048<=ea&&65535>=ea?(ba=2,Aa=224):65536<=ea&&1114111>=ea&&(ba=3,Aa=240);for(da=ca.h(Math.floor(ea/Math.pow(64,ba))+Aa);0<ba;)da=ca.h(128+Math.floor(ea/
Math.pow(64,ba-1))%64),--ba;return da}}function u(ca,da){var ea=da.fatal;this.decode=function(ba){var Aa=ba.get();if(-1===Aa)return-1;ba.offset(1);if(0<=Aa&&127>=Aa)return Aa;ba=ca[Aa-128];return null===ba?f(ea):ba}}function ka(ca){this.encode=function(da,ea){var ba=ea.get();if(-1===ba)return-1;ea.offset(1);if(0<=ba&&127>=ba)return da.h(ba);ea=ca.indexOf(ba);ea=-1===ea?null:ea;null===ea&&g(ba);return da.h(ea+128)}}var ja={},va={};[{encodings:[{labels:"csisolatin2 iso-8859-2 iso-ir-101 iso8859-2 iso_8859-2 l2 latin2".split(" "),
name:"iso-8859-2"},{labels:"csisolatin3 iso-8859-3 iso_8859-3 iso-ir-109 l3 latin3".split(" "),name:"iso-8859-3"},{labels:"csisolatin4 iso-8859-4 iso_8859-4 iso-ir-110 l4 latin4".split(" "),name:"iso-8859-4"},{labels:["csisolatincyrillic","cyrillic","iso-8859-5","iso_8859-5","iso-ir-144"],name:"iso-8859-5"},{labels:"arabic csisolatinarabic ecma-114 iso-8859-6 iso_8859-6 iso-ir-127".split(" "),name:"iso-8859-6"},{labels:"csisolatingreek ecma-118 elot_928 greek greek8 iso-8859-7 iso_8859-7 iso-ir-126".split(" "),
name:"iso-8859-7"},{labels:"csisolatinhebrew hebrew iso-8859-8 iso-8859-8-i iso-ir-138 iso_8859-8 visual".split(" "),name:"iso-8859-8"},{labels:"csisolatin6 iso-8859-10 iso-ir-157 iso8859-10 l6 latin6".split(" "),name:"iso-8859-10"},{labels:["iso-8859-13"],name:"iso-8859-13"},{labels:["iso-8859-14","iso8859-14"],name:"iso-8859-14"},{labels:["iso-8859-15","iso_8859-15"],name:"iso-8859-15"},{labels:["iso-8859-16"],name:"iso-8859-16"},{labels:"ascii ansi_x3.4-1968 csisolatin1 iso-8859-1 iso8859-1 iso_8859-1 l1 latin1 us-ascii windows-1252".split(" "),
name:"windows-1252"},{labels:["unicode-1-1-utf-8","utf-8","utf8"],name:"utf-8"}],heading:"Legacy single-byte encodings"}].forEach(function(ca){ca.encodings.forEach(function(da){ja[da.name]=da;da.labels.forEach(function(ea){va[ea]=da})})});var Xa={"iso-8859-2":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,728,321,164,317,346,167,168,352,350,356,377,173,381,379,176,261,731,322,180,318,347,711,184,353,351,357,
378,733,382,380,340,193,194,258,196,313,262,199,268,201,280,203,282,205,206,270,272,323,327,211,212,336,214,215,344,366,218,368,220,221,354,223,341,225,226,259,228,314,263,231,269,233,281,235,283,237,238,271,273,324,328,243,244,337,246,247,345,367,250,369,252,253,355,729],"iso-8859-3":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,294,728,163,164,null,292,167,168,304,350,286,308,173,null,379,176,295,178,179,180,
181,293,183,184,305,351,287,309,189,null,380,192,193,194,null,196,266,264,199,200,201,202,203,204,205,206,207,null,209,210,211,212,288,214,215,284,217,218,219,220,364,348,223,224,225,226,null,228,267,265,231,232,233,234,235,236,237,238,239,null,241,242,243,244,289,246,247,285,249,250,251,252,365,349,729],"iso-8859-4":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,312,342,164,296,315,167,168,352,274,290,358,173,
381,175,176,261,731,343,180,297,316,711,184,353,275,291,359,330,382,331,256,193,194,195,196,197,198,302,268,201,280,203,278,205,206,298,272,325,332,310,212,213,214,215,216,370,218,219,220,360,362,223,257,225,226,227,228,229,230,303,269,233,281,235,279,237,238,299,273,326,333,311,244,245,246,247,248,371,250,251,252,361,363,729],"iso-8859-5":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,1025,1026,1027,1028,1029,1030,
1031,1032,1033,1034,1035,1036,173,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,8470,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,167,1118,1119],"iso-8859-6":[128,129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,null,null,null,164,null,null,null,null,null,null,null,1548,173,null,null,null,null,null,null,null,null,null,null,null,null,null,1563,null,null,null,1567,null,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,null,null,null,null,null,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,null,
null,null,null,null,null,null,null,null,null,null,null,null],"iso-8859-7":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,8216,8217,163,8364,8367,166,167,168,169,890,171,172,173,null,8213,176,177,178,179,900,901,902,183,904,905,906,187,908,189,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,null,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,
953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,null],"iso-8859-8":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,null,162,163,164,165,166,167,168,169,215,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,247,187,188,189,190,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,8215,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,null,null,8206,8207,null],"iso-8859-10":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,274,290,298,296,310,167,315,272,352,358,381,173,362,330,176,261,275,291,299,297,311,183,316,273,353,359,382,8213,363,331,256,193,194,195,196,197,198,302,268,201,280,
203,278,205,206,207,208,325,332,211,212,213,214,360,216,370,218,219,220,221,222,223,257,225,226,227,228,229,230,303,269,233,281,235,279,237,238,239,240,326,333,243,244,245,246,361,248,371,250,251,252,253,254,312],"iso-8859-13":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,8221,162,163,164,8222,166,167,216,169,342,171,172,173,174,198,176,177,178,179,8220,181,182,183,248,185,343,187,188,189,190,230,260,302,256,262,
196,197,280,274,268,201,377,278,290,310,298,315,352,323,325,211,332,213,214,215,370,321,346,362,220,379,381,223,261,303,257,263,228,229,281,275,269,233,378,279,291,311,299,316,353,324,326,243,333,245,246,247,371,322,347,363,252,380,382,8217],"iso-8859-14":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,7682,7683,163,266,267,7690,167,7808,169,7810,7691,7922,173,174,376,7710,7711,288,289,7744,7745,182,7766,7809,7767,
7811,7776,7923,7812,7813,7777,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,372,209,210,211,212,213,214,7786,216,217,218,219,220,221,374,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,373,241,242,243,244,245,246,7787,248,249,250,251,252,253,375,255],"iso-8859-15":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,8364,165,352,167,353,169,170,171,172,173,174,175,176,
177,178,179,381,181,182,183,382,185,186,187,338,339,376,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255],"iso-8859-16":[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,261,321,8364,8222,352,167,353,169,
536,171,377,173,378,379,176,177,268,322,381,8221,182,183,382,269,537,187,338,339,376,380,192,193,194,258,196,262,198,199,200,201,202,203,204,205,206,207,272,323,210,211,212,336,214,346,368,217,218,219,220,280,538,223,224,225,226,259,228,263,230,231,232,233,234,235,236,237,238,239,273,324,242,243,244,337,246,347,369,249,250,251,252,281,539,255],"windows-1252":[8364,129,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,141,381,143,144,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,157,382,
376,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255]};ja["utf-8"].AB=function(ca){return new G(ca)};ja["utf-8"].zB=function(ca){return new l(ca)};(function(){"iso-8859-2 iso-8859-3 iso-8859-4 iso-8859-5 iso-8859-6 iso-8859-7 iso-8859-8 iso-8859-10 iso-8859-13 iso-8859-14 iso-8859-15 iso-8859-16 windows-1252".split(" ").forEach(function(ca){var da=
ja[ca],ea=Xa[ca];da.zB=function(ba){return new u(ea,ba)};da.AB=function(ba){return new ka(ea,ba)}})})();oa=function(ca){ca=ca?String(ca):"utf-8";var da=Object(da);this.uk=k(ca);this.Ts=!1;this.zi=null;this.os={fatal:!!da.fatal};Object.defineProperty&&Object.defineProperty(this,"encoding",{get:function(){return this.uk.name}});return this};oa.prototype={encode:function(ca,da){ca=ca?String(ca):"";da=Object(da);this.Ts||(this.zi=this.uk.AB(this.os));this.Ts=!!da.stream;da=[];var ea=new c(da);for(ca=
new d(ca);-1!==ca.get();)this.zi.encode(ea,ca);if(!this.Ts){do var ba=this.zi.encode(ea,ca);while(-1!==ba);this.zi=null}return new Uint8Array(da)}};na=function(ca){ca=ca?String(ca):"utf-8";var da=Object(da);this.uk=k(ca);this.os={fatal:!!da.fatal};this.yb=this.uk.zB(this.os);Object.defineProperty&&Object.defineProperty(this,"encoding",{get:function(){return this.uk.name}});return this};na.prototype={decode:function(ca){if(ca&&!("buffer"in ca&&"byteOffset"in ca&&"byteLength"in ca))throw new TypeError("Expected ArrayBufferView");
ca=new Uint8Array(ca.buffer,ca.byteOffset,ca.byteLength);return this.qx(new a(ca))},yN:function(ca){if(!ca)throw new TypeError("Expected array of bytes");return this.qx(new b(ca))},qx:function(ca){for(var da=new e,ea;-1!==ca.get();)ea=this.yb.decode(ca),null!==ea&&-1!==ea&&da.h(ea);return da.m()}}})();
(function(a,b){void 0!==window.Promise&&("function"===typeof define&&define.$S?define([],function(){return a.msrCrypto=b(a)}):"object"===typeof exports?module.exports=b(a):a.msrCrypto=b(a))})(this,function(a){a=a||{};return function(){function b(h,p,A){function Q(){if(!A||!A.Vd)throw Error("missing hash function");}var E=c(h);if(!p)throw Error("padding mode");var t=null,m=null;switch(p){case "RSAES-PKCS1-V1_5":h=Zb.GT(h);break;case "RSASSA-PKCS1-V1_5":Q();h=Zb.HT(h,A);break;case "RSA-OAEP":Q();h=
Zb.lP(h,A);break;case "RSA-PSS":Q();h=Zb.JT(h,A);break;case "raw":h={mp:function(q){return q},Dp:function(q){return q}};break;default:throw Error("invalid mode");}h&&(t=h.mp||h.sign,m=h.Dp||h.verify);return{encrypt:function(q,y){q=null!==t?t(q,y):q.slice();return E.encrypt(q)},decrypt:function(q,y){q=E.decrypt(q);if(null!==m){q=m(q,y);if(!1===q.valid)throw Error("OperationError");q=q.data}else q=q.slice(0);return q},bS:function(q,y,C){return E.decrypt(t(q,y,C))},CS:function(q,y,C){q=E.encrypt(q);
return m(q,y,C)},Fl:function(q){genRsaKeyFromRandom(q)},mode:p}}function c(h){function p(q){q=la.iB(q);Q.rP(q,0,m);return q}function A(q,y,C){y=la.Ch(y);C=la.OE(C);q=C.rN(q);return C.bP(q,y).Xa}var Q=ba,E=h.hasOwnProperty("n")&&h.hasOwnProperty("d"),t=h.hasOwnProperty("p")&&h.hasOwnProperty("q"),m=h.n.length;return{encrypt:function(q){return p(A(q,h.e,h.n,!0))},decrypt:function(q){if(t){var y=la.Ch,C=h.q,M=h.dp,B=h.dq,v=h.qi,F=y(h.p);C=y(C);var H=Array(F.length+C.length),O=Array(F.length+1),U=Array(C.length+
1);q=y(q);var ia=la.Wh,Z=new ia(h.Dt?void 0:F,h.Dt);ia=new ia(h.Et?void 0:C,h.Et);Z.reduce(q,H);Z.Cj(H,y(M),O);ia.reduce(q,H);ia.Cj(H,y(B),U);M=la.Tc(O,U,H);0!==M&&la.Tc(U,O,H);la.rC(H,y(v),F,q);0!==M&&la.Tc(F,q,q);la.multiply(q,C,H);la.add(U,H,O);return p(O)}if(E)return y=A(q,h.d,h.n),p(y);throw Error("missing private key");}}}function d(h){function p(X,x){for(var n=Math.floor(x.length/16),z,w=0;w<n;w++){z=x.slice(16*w,16*w+16);var K;z=q.$e(O,z);var S=X;var W=q.vc(16),T=S.slice(0);for(S=0;128>S;S++){var L=
-(z[Math.floor(S/8)]>>7-S%8&1)&255;for(K=0;16>K;K++)W[K]^=T[K]&L;L=-(T[15]&1)&255;K=T;for(var P=K.length-1;0<P;P--)K[P]=(K[P-1]&1)<<7|K[P]>>>1;K[0]>>>=1;T[0]^=225&L}O=W}U=x.slice(16*n);return O}function A(){var X=16*Math.ceil(ma/16)-ma,x=t(8*M.length),n=t(8*ma);X=U.concat(q.vc(X)).concat(x).concat(n);return p(H,X)}function Q(X){for(var x=256,n=1;4>=n;n++)x=(x>>>8)+X[X.length-n],X[X.length-n]=x&255;return X}function E(X,x){var n=Math.ceil(x.length/16),z=[];Z!==X&&(Z=X.slice());for(var w=0;w<n;w++){X=
x.slice(16*w,16*w+16);var K=h.encrypt(Z.slice());z=z.concat(q.$e(X,K));Z=Q(Z)}return z}function t(X){return[0,0,0,0,X>>>24&255,X>>>16&255,X>>>8&255,X&255]}function m(){ma=0;y=[];ia=[];O=q.vc(16);U=[];Z=C=M=null}var q=ba,y=[],C,M,B,v,F,H=h.encrypt(q.vc(16)),O=q.vc(16),U=[],ia=[],Z,ma=0;return{ud:function(X,x,n){M=x||[];B=isNaN(n)?128:n;if(0!==B%8)throw Error("DataError");C=X;12===C.length?v=C.concat([0,0,0,1]):(v=p(H,C.concat(q.vc(16*Math.ceil(C.length/16)-C.length+8)).concat(t(8*C.length))),O=q.vc(16));
F=Q(v.slice());p(H,M.concat(q.vc(16*Math.ceil(M.length/16)-M.length)))},encrypt:function(X){ma=X.length;X=E(F,X);p(H,X);var x=A();x=E(v,x).slice(0,B/8);m();return X.slice().concat(x)},decrypt:function(X,x){ma=X.length;var n=E(F,X);p(H,X);X=A();X=E(v,X).slice(0,B/8);m();return q.zl(X,x)?n:null},nu:function(X){y=y.concat(X);X=y.slice(0,16*Math.floor(y.length/16));ma+=X.length;y=y.slice(X.length);X=E(Z||F,X);ia=ia.concat(X);p(H,X)},op:function(X){y=y.concat(X);X=y.slice(0,16*Math.floor((y.length-B/8)/
16));ma+=X.length;y=y.slice(X.length);var x=E(Z||F,X);ia=ia.concat(x);p(H,X)},Qo:function(){var X=E(Z,y);ia=ia.concat(X);ma+=y.length;X=A();X=E(v,X).slice(0,B/8);X=ia.slice().concat(X);m();return X},Po:function(){var X=Math.floor(B/8),x=y.slice(-X);y=y.slice(0,y.length-X);X=E(Z,y);ia=ia.concat(X);ma+=y.length;X=A();X=E(v,X).slice(0,B/8);var n=ia.slice();m();return q.zl(X,x)?n:null}}}function e(h){function p(C){var M=[],B,v;for(B=0;B<C.length;B+=1){var F=C[B];for(v=0;v<F.length;v+=1)M.push(F[v])}return M}
function A(C){var M=[];m=m.concat(C);C=Math.floor(m.length/E);for(var B=0;B<C;B++)M.push(m.slice(B*E,(B+1)*E));m=m.slice(C*E);return M}function Q(C){for(var M=[],B,v=0;v<C.length;v++)B=ba.$e(y,C[v]),M.push(h.encrypt(B)),y=M[v];return M}var E=h.blockSize/8,t=zd.tP(E),m=[],q=[],y;return{ud:function(C){if(C.length!==E)throw Error("Invalid iv size");y=C.slice()},encrypt:function(C){C=Q(A(C));q=q.concat(p(C));return this.Qo()},nu:function(C){return p(Q(A(C)))},Qo:function(){var C=1===m.length?[[m[0]]]:
[m];t.mp(C);C=q.concat(p(Q(C)));m=[];q=[];y=null;return C},decrypt:function(C){this.op(C);return this.Po()},op:function(C){C=A(C);for(var M=[],B,v=0;v<C.length;v+=1)B=C[v].slice(0,C[v].length),B=h.decrypt(B),M.push(ba.$e(y,B)),y=C[v];q=q.concat(p(M))},Po:function(){var C=q;t.Dp(C);m=[];q=[];y=null;return C}}}function f(h,p){function A(H,O){for(var U=Array(H),ia=0;ia<H.length;ia++)U[ia]=H[ia]^O[ia];return U}function Q(H,O){var U=H.slice();for(H=H.length;H<O;H++)U.push(0);return U}function E(H){y?p.process(H):
(y=v.concat(H),p.process(y))}function t(){var H=p.finish();return p.Vd(F.concat(H))}var m={384:128,512:128}[p.name.replace(/SHA-/,"")]||64,q=h.length===m?h:h.length>m?Q(p.Vd(h),m):Q(h,m),y;var C=Array(m);var M=Array(m);for(var B=0;B<m;B++)C[B]=54,M[B]=92;var v=A(q,C);var F=A(q,M);return{RA:function(H){E(H);H=t();q=p=h=null;return H},process:function(H){E(H);return null},finish:function(){var H=t();q=p=h=null;return H}}}function g(h,p,A,Q,E,t,m){function q(H){for(var O=Math.floor(H.length/E),U=0;U<
O;U++)t(H,U,M,Q,B);F+=O;return H.slice(O*E)}function y(){var H=v,O=E-H.length%E;O<=E/8&&(O+=E);var U=C.vc(O);U[0]=128;for(var ia=8*(H.length+F*E),Z=1;8>=Z;Z++)U[O-Z]=ia%256,ia=Math.floor(ia/256);if(0!==q(H.concat(U)).length)throw Error("buffer.length !== 0");H=[];for(O=0;O<M.length;O++)H=H.concat(C.fC(M[O]));H.length=m/8;v=[];M=A.slice();F=0;return H}var C=ba,M=A.slice(),B=Array(E),v=[],F=0;return{name:h,Vd:function(H){v=q(H);return y()},process:function(H){v=v.concat(H);v.length>=E&&(v=q(v))},finish:y,
lT:p,Xt:m,maxMessageSize:4294967295}}function k(){function h(x){var n,z=null;if(!arguments.length||"number"===typeof arguments[0])for(z=Array(x),n=0;n<x;n+=1)z[n]=0;else if("object"===typeof arguments[0])for(z=Array(x.length),n=0;n<x.length;n+=1)z[n]=x[n];return z}function p(x,n,z,w,K){for(;0<K--;)z[w+K]=x[n+K]}function A(x){var n,z=0;for(n=0;n<x.length;n+=1)z|=x[n];return!z}function Q(x){for(var n=Math.floor((x.length+3-1)/3),z=Array(n),w=z[0]=0,K=0,S=0,W=x.length-1;0<=W;W--)w+=ia[S++]*(x[W]&255),
16777216===ia[S]&&(S=0,z[K++]=w,w=0);for(0!==w&&(z[K]=w);null==z[--n];)z[n]=0;return z}function E(x,n){"undefined"===typeof n&&(n=1>=x?1:Math.ceil(Math.log(x)/Math.LN2/24));for(var z=[];0<x;)z.push(x%16777216),x=Math.floor(x/16777216);for(;z.length<n;)z.push(0);return z}function t(x){for(var n=x.length-1;0<=n;n--)if(void 0!==x[n]&&0!==x[n])return n;return 0===x[0]?-1:0}function m(x,n){var z=0,w;for(w=0;w<Math.max(x.length,n.length);w++){var K=~~x[w]-~~n[w];z=K+(z&-!K)}return z}function q(x,n,z){var w=
t(x);x.length=n||w+1;if(z)for(;++w<x.length;)x[w]=0;0>=x.length&&(x[0]=0,x.length=1);return x}function y(x,n,z,w){if(void 0===z)z=1;else if(24<=z||0>z)throw Error("bit count must be smaller than DIGIT_BITS and positive in shiftLeft");void 0===w&&(w=x.length);var K=24-z;n[w]=x[w-1]>>>24-z||n[w];for(--w;0<w;w--)n[w]=(x[w]<<z|x[w-1]>>>K)&16777215;n[0]=x[0]<<z&16777215}function C(x,n,z){var w=x,K=n;n.length<x.length&&(w=n,K=x);x=w.length;n=0;var S;for(S=0;S<x;S+=1)n+=w[S]+K[S],z[S]=n&16777215,n>>=24;
for(S=x;S<K.length;S+=1)n+=K[S],z[S]=n&16777215,n>>=24;z.length=K.length;0!==n&&(z[S]=n&16777215);return n}function M(x,n,z){var w=n.length;if(x.length<n.length&&(w=t(n)+1,x.length<w))throw Error("Subtrahend is longer than minuend, not supported.");var K,S=0;for(K=0;K<w;K+=1)S+=x[K]-n[K],z[K]=S&16777215,S>>=24;for(;K<x.length;)S+=x[K],z[K++]=S&16777215,S>>=24;return S}function B(x,n,z){n="number"===typeof n?[n]:n;var w,K,S,W=x.length,T=n.length;for(w=0;w<W+T;w+=1)z[w]=0;for(var L=S=w=0;w<T;){for(S=
Math.min(S+31,T);w<S;w++){var P=n[w];for(K=0;K<W;K++)z[w+K]+=x[K]*P}P=0;for(K=L;K<w+W;K++){P=z[K]+P;var aa=P&16777215;z[K]=aa;P=(P-aa)*U}z[K]=P;L+=31}z.length=W+T;return z}function v(x,n,z,w,K,S){var W=t(x)+1,T=t(n)+1;if(W<T)p(x,0,w,0,x.length),w.length=x.length,q(w),z[0]=0,z.length=1;else{if(0===T||1===T&&0===n[T-1])throw Error("Division by zero.");if(1===T){var L=n[0];var P=0;for(n=W-1;0<=n;n--)P=16777216*P+x[n],z[n]=P/L&16777215,P=P-z[n]*L&16777215;z.length=W;q(z);w[0]=P;w.length=1}else{var aa=
0;for(P=0;24>P;P++)aa=Math.max(aa,-(n[T-1]>>>P&1)&P);aa=23-aa;K=K||[];K.length=T;y(n,K,aa,T);S=S||[];S.length=W;y(x,S,aa,W);S[W]=S[W]||0;z.length=W-T+1;w.length=T;for(n=W-T;0<=n;n--){x=Math.floor((16777216*S[n+T]+S[n+T-1])/K[T-1]);for(P=16777216*S[n+T]+S[n+T-1]-x*K[T-1];;){if(16777216<=x||x*K[T-2]>16777216*P+S[n+T-2])if(--x,P+=K[T-1],16777216>P)continue;break}for(W=L=0;W<T;W++)P=x*K[W],L=S[W+n]-L-(P&16777215),S[W+n]=L&16777215,L=Math.floor(P/16777216)-Math.floor(L/16777216);L=S[n+T]-L;S[n+T]=L&16777215;
z[n]=x&16777215;if(0>L){--z[n];for(W=L=0;W<T;W++)L=S[W+n]+K[W]+L,S[W+n]=L&16777215,L>>=24;S[n+T]=S[n+T]+L&16777215}}for(W=0;W<T;W++)w[W]=(S[W]>>>aa|S[W+1]<<24-aa)&16777215;q(z);q(w)}}}function F(x,n,z,w,K){if(A(x))return p(n,0,K,0,n.length),K.length=n.length,0;if(A(n))return p(x,0,K,0,x.length),K.length=x.length,0;if(0>m(x,n)){var S=x.slice(0);p(n,0,K,0,n.length);K.length=n.length}else S=n.slice(0),p(x,0,K,0,x.length),K.length=x.length;q(K);q(S);x=Array(K.length);n=Array(K.length);var W=Array(K.length),
T=void 0!==w;if(T){var L=Array(K.length);L[0]=1;L.length=1;w[0]=0;w.length=1}var P=Array(K.length),aa=void 0!==z;if(aa){var ua=Array(K.length);ua[0]=0;ua.length=1;z[0]=1;z.length=1}for(var La=-1,Ya=z,Pa=w,sa=K,fa;!A(S);)v(K,S,x,n,P,W),aa&&(B(x,ua,P),C(P,z,P),q(P),fa=z,z=ua,ua=P,P=fa),T&&(B(x,L,W),C(W,w,W),q(W),fa=w,w=L,L=W,W=fa),fa=K,K=S,S=n,n=fa,La++;aa&&(p(z,0,Ya,0,z.length),Ya.length=z.length);T&&(p(w,0,Pa,0,w.length),Pa.length=w.length);p(K,0,sa,0,K.length);sa.length=K.length;return La}function H(x,
n,z,w){w=w||[];if(0===m(n,ma))w[0]=1;else if(0===m(n,X))p(x,0,w,0,x.length),w.length=x.length;else{var K=new O(z);q(x,K.vd,!0);K.Cj(x,n,w);w.length=z.length}return w}function O(x,n){function z(fa,ha,pa,ya){ya=ya||this;for(var Da=ya.ip,wa=Da.length,Ea=ya.fu,rb=ya.eu,Za,Ba,jb,eb=0,wb,jc=0,mb=h(wa+2);eb<wa;){for(jc=Math.min(wa,jc+16);eb<jc;){Za=~~ha[eb];Ba=mb[0]+fa[0]*Za;jb=(Ba&16777215)*Ea&16777215;mb[1]+=(rb*jb+Ba)*U|0;Ba=1;for(wb=0;Ba<wa;wb=Ba,Ba+=1)mb[wb]=mb[Ba]+Da[Ba]*jb+fa[Ba]*Za;mb[wb]=mb[Ba];
mb[Ba]=0;eb++}for(Ba=Za=0;Ba<wa;Ba++)Za=mb[Ba]+Za,jb=Za&16777215,mb[Ba]=jb,Za=(Za-jb)*U;mb[Ba]=Za}for(eb=0;eb<wa;eb+=1)pa[eb]=mb[eb];pa.length=wa;fa=+(0<la.Hf(mb,Da));la.Tc(pa,Da,ya.Tu);w(fa,pa,ya.Tu)}function w(fa,ha,pa){fa=-fa;for(var ya=~fa,Da=0;Da<ha.length;Da++)ha[Da]=ha[Da]&ya|pa[Da]&fa}function K(fa){for(var ha=fa.length,pa=fa[0],ya=1,Da=2,wa=3,Ea=wa&pa,rb=2;24>=rb;rb+=1)Da<Ea&&(ya+=Da),Da<<=1,wa=wa<<1|1,Ea=pa*ya&wa;pa={ip:fa,fu:(~ya&16777215)+1,eu:pa,Su:h(2*ha+1),Tu:h(2*ha+1)};ya=h(2*fa.length);
ya[ya.length]=1;pa.kp=[];v(ya,fa,pa.kp,[]);ya=h(2*ha+1);Ea=h(ha+1);Da=h(2*ha+1);wa=h(2*ha+1);Ea[ha]=1;v(Ea,fa,ya,Ea,Da,wa);pa.pp=q(Ea,ha,!0);Ea=h(2*ha+1);Ea[2*ha]=1;v(Ea,fa,ya,Ea,Da,wa);pa.pu=q(Ea,ha,!0);pa.ou=h(ha);z(Ea,Ea,pa.ou,pa);return pa}n=n||K(x);var S=n.ip;x=n.kp;var W=n.eu,T=S.length,L=h(T+1).slice(0,T);L[0]=1;var P=n.fu,aa=n.pp,ua=n.pu,La=n.ou,Ya=h(2*T+1),Pa=h(2*T+1),sa=Array(4);sa[0]=aa;sa[1]=Array(T);sa[2]=Array(T);sa[3]=Array(T);return{ip:S,eu:W,fu:P,kp:x,pu:ua,vd:T,pp:aa,ou:La,AC:L,
Su:Ya,Tu:Pa,hT:function(fa){if(fa.length<this.vd){fa.length=this.vd;for(var ha=0;ha<this.vd;ha++)fa[ha]=isNaN(fa[ha])?0:fa[ha]}var pa=h(fa.length);this.Dj(fa,this.pu,pa);for(ha=0;ha<this.vd;ha+=1)fa[ha]=pa[ha]},iT:function(fa){this.Dj(fa,this.AC,this.Su);for(var ha=0;ha<this.vd;ha+=1)fa[ha]=this.Su[ha]},Dj:z,Cj:function(fa,ha,pa,ya){ya=!!ya;var Da=2;var wa=24*ha.length;var Ea=3*Math.ceil(wa/2)+5;do{Da++;var rb=Ea;Ea=Math.pow(2,Da)+Math.ceil(wa/Da)*(Da+1)+1}while(Ea<rb);--Da;rb=ha.length;Ea=0;var Za=
0,Ba,jb=Array(Math.ceil(24*rb/Da));var eb=0;for(jb[0]=0;Ea<rb;Ea++)for(wa=0,Ba=ha[Ea];24>wa;wa++,Ba>>>=1)eb===Da&&(eb=jb[++Za]=0),jb[Za]+=(Ba&1)<<eb++;rb=jb.reverse();Ea=this.pp.slice(0);wa=Math.pow(2,Da);sa.length=wa;sa[0]=this.pp;for(ha=1;ha<wa;ha++)sa[ha]=[],B(sa[ha-1],fa,sa[ha]),this.reduce(sa[ha]);fa=[];for(ha=0;ha<rb.length;ha++){for(wa=0;wa<Da;wa++)this.Dj(Ea,Ea,Ea);eb=rb[ha];if(ya)fa=sa[eb];else{var wb;wa=sa;Za=fa;for(Ba=0;Ba<wa[0].length;Ba++)Za[Ba]=0;for(wb=0;wb<wa.length;wb++){jb=wa[wb];
var jc=-(eb===wb);for(Ba=0;Ba<jb.length;Ba++)Za[Ba]|=jb[Ba]&jc}}this.Dj(Ea,fa,Ea)}this.Dj(Ea,this.AC,pa);return pa},reduce:function(fa,ha){var pa=this.ip.length,ya=[];ha=ha||fa;var Da=fa.slice(pa-1);var wa=[];B(Da,this.kp,wa);Da=wa.slice(pa+1);fa=fa.slice(0,pa+1);wa=[];B(Da,S,wa);wa=wa.slice(0,pa+1);fa[pa+1]=m(fa,wa)>>>31;for(pa=0;pa<ha.length;pa++)ha[pa]=0;M(fa,wa,ha);pa=+(0<m(ha,S));la.Tc(ha,S,ya);w(pa,ha,ya);q(ha)},wg:n}}for(var U=1/16777216,ia=[1,256],Z=2;3>=Z;Z++)ia[Z]=256*ia[Z-1];var ma=[0],
X=[1];return{Op:24,KS:3,IS:16777215,YD:16777216,JS:16777215,VS:ma,YE:X,fP:q,Ch:Q,OT:function(x,n){x=x.replace(/^\s+|\s+$/g,"");var z=[0],w=[0];n=n||10;for(var K=0;K<x.length;K+=1){var S=parseInt(x[K],n);if(isNaN(S))throw Error("Failed to convert string to integer in radix "+n.toString());B(z,n,w);C(w,[S],z);q(z)}return z},mT:function(x,n){n=n||10;if(16777216<=n)throw Error("DIGIT_BASE is smaller than RADIX; cannot convert.");var z=x.length,w=[],K=[],S=[],W=[],T=[],L=[],P,aa="",ua="0";for(T[0]=n;Math.floor(16777216/
T[0])>=n;)T[0]*=n,ua=ua.concat("0");for(P=0;P<z;P+=1)L[P]=x[P];do{x=!0;for(P=0;P<L.length;P+=1)if(0!==L[P]){x=!1;break}if(x)break;v(L,T,w,K,S,W);q(w,L.length,!0);P=K[0].toString(n);aa=ua.substring(0,ua.length-P.length)+P+aa;P=L;L=w;w=P}while(1);for(;0!==aa.length&&"0"===aa[0];)aa=aa.substring(1,aa.length);0===aa.length&&(aa="0");return aa},yT:E,iB:function(x,n,z){var w,K,S=[0];"undefined"===typeof n&&(n=!0);for(w=0;w<x.length;w+=1){var W=x[w];for(K=0;3>K;K+=1)S[3*w+K]=W&255,W=Math.floor(W/256)}S.reverse();
void 0===z&&(z=1);if(n)for(;S.length>z&&0===S[0];)S.shift();return S},lC:A,AT:function(x){return 0===(x[0]&1)},pD:function(x,n,z,w){if(void 0===z)z=1;else if(24<=z||0>z)throw Error("Invalid bit count for shiftRight");void 0===w&&(w=x.length);--w;for(var K=24-z,S=0;S<w;S++)n[S]=(x[S+1]<<K|x[S]>>>z)&16777215;n[w]=x[w]>>>z},shiftLeft:y,Hf:m,bT:function(x){for(var n=0,z=0;n<x.length;){if(0===z)for(var w=7;0<=w&&0===z;){var K=1<<w;(x[n]&K)===K&&(z=w+1);w--}else z+=8;n+=1}return z},oT:function(x,n,z){x=
x.slice();for(var w=[],K=Math.pow(2,n),S=Math.pow(2,n-1),W=0;W<z;W++)w[W]=x[0]%K-S,x[0]-=w[W],la.pD(x,x,n-1);w[W]=x[0];return w},OE:function(x){function n(L,P){return{Xa:L,gu:P,No:function(aa){return 0===m(this.Xa,aa.Xa)&&this.gu.No(this.gu,aa.gu)}}}x=Q(x);var z=x.length,w=E(0,z),K=E(1,z),S=h(z),W=h(z),T=new O(x);return{Dg:x,Bj:z,sC:T,kT:function(L){L=E(L,this.Bj);return n(L,this)},rN:function(L){L=Q(L);if(0<=la.Hf(L,this.Dg))throw Error("The number provided is not an element of this group");q(L,
this.Bj,!0);return n(L,this)},jT:function(L){la.fP(L,this.Bj,!0);return n(L,this)},No:function(L){return 0===m(this.Dg,L.Dg)},add:function(L,P,aa){var ua=this.Bj;aa=aa.Xa;la.add(L.Xa,P.Xa,aa);P=(m(aa,this.Dg)>>>31)-1&16777215;var La=0;for(L=0;L<ua;L+=1)La=aa[L]-(this.Dg[L]&P)+La,aa[L]=La&16777215,La>>=24;aa.length=ua},Tc:function(L,P,aa){var ua=this.Bj,La=aa.Xa;P=la.Tc(L.Xa,P.Xa,aa.Xa);if(-1===P)for(L=P=0;L<ua;L+=1)P+=La[L]+this.Dg[L],La[L]=P&16777215,P>>=24},multiply:function(L,P,aa){return la.rC(L.Xa,
P.Xa,this.Dg,aa.Xa,S,W)},inverse:function(L,P){la.hu(L.Xa,this.Dg,P.Xa)},bP:function(L,P,aa){aa=aa||n([],this);if(0===m(P,w))aa.Xa=E(1,this.Bj);else if(0===m(P,K)){for(P=0;P<L.Xa.length;P++)aa.Xa[P]=L.Xa[P];aa.Xa.length=L.Xa.length}else this.sC.Cj(L.Xa,P,aa.Xa),aa.Xa.length=this.sC.vd;return aa}}},add:C,Tc:M,multiply:B,nT:v,reduce:function(x,n,z,w,K){v(x,n,[],z,w,K);return z},hu:function(x,n,z,w){var K=Array(n.length),S=Array(n.length);x=F(x,n,Array(n.length),K,S);z=z||[];0!==m(S,X)?(z[0]=NaN,z.length=
1):(1===(x&1)?M(n,K,z):(p(K,0,z,0,K.length),z.length=K.length),w?q(z,n.length,!0):q(z));return z},DT:function(x,n,z){var w=[];z=z||[];M(n,[2],w);H(x,w,n,z);q(z);return z},Cj:H,rC:function(x,n,z,w,K,S){var W=[];B(x,n,W);v(W,z,W,w,K,S);return w},Wh:O,RN:function(x,n,z){var w=x,K=n;0<m(x,n)&&(w=n,K=x);F(w,K,void 0,void 0,z);return q(z)},LT:function(x,n){for(var z=x.length===n.length,w=0;w<Math.min(x.length,n.length);w+=1)x[w]!==n[w]&&(z=!1);return z},PT:function(x){return x.reverse()},gT:function(x){for(var n=
h(8*x.length),z=0,w=x.length-1;0<=w;){for(var K=0;8>K;){var S=1<<K;S=(x[w]&S)===S?1:0;var W=8*(x.length-w-1)+K;1===S&&(z=W+1);n[W]=S;K+=1}w--}return n.slice(0,z)}}}function l(){function h(v){var F;for(F=v.length-1;0<=F&&(v[F]+=1,256<=v[F]&&(v[F]=0),!v[F]);--F);}function p(){m=ba.vc(32);q=ba.vc(16);y=32;C=48;M=1}function A(v,F){F=F||[0];if(F.length>C)throw Error("Incorrect entropy or additionalEntropy length");F=F.concat(ba.vc(C-F.length));v=v.concat(ba.vc((C-v.length%C)%C));for(var H=0;H<v.length;H+=
C){var O=ba.$e(v.slice(H,H+C),F);Q(O)}M=1}function Q(v){for(var F=[],H=new Db.ug(m);F.length<C;){h(q);var O=H.encrypt(q.slice(0,16));F=F.concat(O)}F=ba.$e(F,v);m=F.slice(0,y);q=F.slice(y)}function E(v,F){if(65536<=v)throw Error("too much random requested");if(M>B)throw Error("Reseeding is required");if(F&&0<F.length){for(;F.length<C;)F=F.concat(ba.vc(C-F.length));Q(F)}else F=ba.vc(C);for(var H=[],O=new Db.ug(m);H.length<v;){h(q);var U=O.encrypt(q.slice(0,q.length));H=H.concat(U)}H=H.slice(0,v);Q(F);
M+=1;return H}if(!(this instanceof l))throw Error("create MsrcryptoPrng object with new keyword");var t=!1,m,q,y,C,M=1,B=Math.pow(2,48);p();return{Wl:A,ve:function(v,F){if(!t)throw Error("can't get randomness before initialization");return E(v,F)},uT:function(v,F){if(!t)throw Error("can't get randomness before initialization");for(var H=[],O;H.length<v;){O=E(v,F);for(var U=0;U<O.length;U+=1)0!==O[U]&&H.push(O[U])}return H.slice(0,v)},ud:function(v,F){if(v.length<C)throw Error("Initial entropy length too short");
p();A(v,F);t=!0}}}function G(h){function p(){var M="Cookie RedirectUri ETag x-ms-client-antiforgery-id x-ms-client-request-id x-ms-client-session-id SubscriptionPool".split(" "),B,v=[];for(B=0;48>B;B+=1)v[B]=Math.floor(256*Math.random());if((B=q.crypto||q.msCrypto)&&"function"===typeof B.getRandomValues&&h.Uint8Array){var F=new h.Uint8Array(48);B.getRandomValues(F);v=v.concat(Array.prototype.slice.call(F));m=!0}if("undefined"!==typeof XMLHttpRequest)for(F=new XMLHttpRequest,B=0;B<M.length;B+=1)try{var H=
F.getResponseHeader(M[B]);H&&(v=v.concat(ba.Nj(H)))}catch(O){}!m&&y&&(v=v.concat(Q.splice(0,Q.length)),C.rD());t?E.Wl(v):E.ud(v);t=!0}function A(M){for(var B=0;B<M.length;++B)Q.push(M[B]);128<=Q.length&&C.jS()}var Q=[],E=new l,t=!1,m=!1,q=h,y=h&&h.addEventListener||"undefined"!==typeof document&&document.attachEvent,C=function(){return{rD:function(){if(!this.wt){if(h.addEventListener)h.addEventListener("mousemove",this.rm,!0),h.addEventListener("load",this.om,!0);else if(document.attachEvent)document.attachEvent("onmousemove",
this.rm),document.attachEvent("onload",this.om);else throw Error("Can't attach events for entropy collection");this.wt=1}},jS:function(){this.wt&&(h.removeEventListener?(h.removeEventListener("mousemove",this.rm,1),h.removeEventListener("load",this.om,1)):h.detachEvent&&(h.detachEvent("onmousemove",this.rm),h.detachEvent("onload",this.om)),this.wt=0)},rm:function(M){var B=(new Date).valueOf(),v=M.x||M.clientX||M.offsetX||0;M=M.y||M.clientY||M.offsetY||0;A([B&255,B>>8&255,B>>16&255,B>>24&255,v&255,
v>>8&255,M&255,M>>8&255])},om:function(){var M=(new Date).valueOf();A([M&255,M>>8&255,M>>16&255,M>>24&255])}}}();return{ud:function(){p();if(!m&&y)try{C.rD()}catch(M){}},Wl:function(M){E.Wl(M)},read:function(M){if(!t)throw Error("Entropy pool is not initialized.");M=E.ve(M);p();return M}}}var u={register:function(h,p,A){u[h]||(u[h]={});h=u[h];h[p]||(h[p]=A)},oB:function(h,p){return u[h]?u[h][p]?!0:!1:!1}},ka=self.location.href,ja="undefined"!==typeof Worker,va="function"===typeof importScripts&&self instanceof
WorkerGlobalScope,Xa=!1,ca="undefined"!==typeof ArrayBuffer;try{Object.defineProperty({},"oncomplete",{})}catch(h){}var da=!1,ea={},ba=function(){function h(t){for(t=t.replace(/-/g,"+").replace(/_/g,"/");0!==t.length%4;)t+="=";var m=[],q;t=t.replace(/[^A-Za-z0-9\+\/=]/g,"");for(q=0;q<t.length;q+=4){var y="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(q));var C="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(q+1));var M="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(q+
2));var B="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(t.charAt(q+3));y=y<<2|C>>4;C=(C&15)<<4|M>>2;var v=(M&3)<<6|B;m.push(y);64!==M&&m.push(C);64!==B&&m.push(v)}return m}function p(t){return Object.prototype.toString.call(t).slice(8,-1)}function A(t){return[t>>>24&255,t>>>16&255,t>>>8&255,t&255]}function Q(t){if(!t)return[];if(t.pop)return t;"ArrayBuffer"===p(t)?t=new Uint8Array(t):1<t.BYTES_PER_ELEMENT&&(t=new Uint8Array(t.buffer));if(1===t.length)return[t[0]];if(65536>
t.length)return Array.apply(null,t);for(var m=Array(t.length),q=0;q<t.length;q++)m[q]=t[q];return m}function E(t){return"number"===typeof t&&isFinite(t)&&Math.floor(t)===t}return{yt:function(t){"console"in self&&"log"in console&&console.log(t)},ce:function(t,m){var q=p(t);if("Array"!==q&&"Uint8Array"!==q&&"ArrayBuffer"!==q)throw Error("invalid input");q="";t=Q(t);void 0===m&&(m=!1);var y;for(y=0;y<t.length;y+=3){var C=t[y];var M=t[y+1];var B=t[y+2];var v=C>>2;C=(C&3)<<4|M>>4;var F=(M&15)<<2|B>>6;
var H=B&63;isNaN(M)?F=H=64:isNaN(B)&&(H=64);q=q+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(v)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(C)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(F)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(H)}return m?q.replace(/\+/g,"-").replace(/\//g,"_").replace(/=/g,""):q},El:h,eT:function(t,m,q){if(!t)throw Error(q);if(m&&p(t)!==m)throw Error(q);
return!0},Tt:p,bytesToHexString:function(t,m){var q="";"undefined"===typeof m&&(m=!1);for(var y=0;y<t.length;y++){m&&0===y%4&&0!==y&&(q+="-");var C=t[y].toString(16).toUpperCase();1===C.length&&(q+="0");q+=C}return q},IA:function(t,m){m=m||0;return t[m]<<24|t[m+1]<<16|t[m+2]<<8|t[m+3]},Nj:function(t){for(var m=[],q=0,y=0;q<t.length;q++){var C=t.charCodeAt(q);128>C?m[y++]=C:2048>C?(m[y++]=C>>>6|192,m[y++]=C&63|128):55296>C||57343<C?(m[y++]=C>>>12|224,m[y++]=C>>>6&63|128,m[y++]=C&63|128):(C=1024*(C-
55296)+(t.charCodeAt(++q)-56320)+65536,m[y++]=C>>>18|240,m[y++]=C>>>12&63|128,m[y++]=C>>>6&63|128,m[y++]=C&63|128)}return m},JA:function(t){var m="",q;t=Q(t);for(var y=0;y<t.length;){var C=t[y++];128>C?q=C:q=224>C?(C<<6)+t[y++]-12416:240>C?(C<<12)+(t[y++]<<6)+t[y++]-925824:(C<<18)+(t[y++]<<12)+(t[y++]<<6)+t[y++]-63447168;m=65535<q?m+String.fromCharCode(Math.floor((q-65536)/1024)+55296,(q-65536)%1024+56320):m+String.fromCharCode(q)}return m},Cp:function(t,m,q){t=h(t);var y=[],C;if(isNaN(m))return t;
for(C=0;C<t.length;C+=m)y.push(t.slice(C,C+m));if(q)for(C=0;C<y.length;C++)y[C]=(y[C][0]<<24)+(y[C][1]<<16)+(y[C][2]<<8)+y[C][3];return y},vT:function(t){t=t.replace(/\-/g,"");for(var m=[];2<=t.length;)m.push(parseInt(t.substring(0,2),16)),t=t.substring(2,t.length);return m},fC:A,xT:function(t){for(var m=[],q=0;q<t.length;q++)m=m.concat(A(t[q]));return m},wc:Q,zl:function(t,m){var q=!0;t.length!==m.length&&(q=!1);for(var y=0;y<t.length;y++)t[y]!==m[y]&&(q=!1);return q},clone:function(t){var m={},
q;for(q in t)t.hasOwnProperty(q)&&(m[q]=t[q]);return m},$e:function(t,m,q){var y=Math.min(t.length,m.length);q=q||Array(y);for(var C=0;C<y;C+=1)q[C]=t[C]^m[C];return q},padEnd:function(t,m,q){for(;t.length<q;)t.push(m);return t},rP:function(t,m,q){for(;t.length<q;)t.unshift(m);return t},vc:function(t,m){isNaN(m)&&(m=0);for(var q=Array(t),y=0;y<t;y+=1)q[y]=m;return q},ST:function(t){if("Array"!==p(t))return!1;for(var m,q=0;q<t.length;q++)if(m=t[q],isNaN(m)||0>m||255<m)return!1;return!0},error:function(t,
m){m=Error(m);m.name=t;throw m;},zT:function(t){if(!(t instanceof Array))return!1;for(var m=0;m<t.length;m++){var q=t[m];if(!E(q)||255<q||0>q)return!1}return!0},isInteger:E}}(),Aa=function(){function h(m,q){var y=t[m[0]&31],C=m[1],M=0,B=!!(m[0]&32);if(C&128)for(C=M=0;M<(m[1]&127);M++)C=(C<<8)+m[2+M];var v=2+M;if(void 0===y||C>m.length)return null;var F=B?[]:{};F.type=y;F.Ag=v;F.data=m.slice(0,C+v);if(B||q)for("BIT STRING"===F.type&&0===m[v]&&M++,m=m.slice(v,F.data.length);0<m.length;){q=h(m);if(null===
q)break;F.push(q);m=m.slice(q.data.length)}return F}function p(m){if(m.hasOwnProperty("INTEGER")){m=m.xd;ba.isInteger(m)&&(m=Q(m));m[0]&128&&m.unshift(0);var q=[2].concat(A(m),m);return q}if(m.hasOwnProperty("OCTET STRING"))return m=m["OCTET STRING"],m instanceof Array||(m=p(m)),q=[4].concat(A(m),m);if(m.hasOwnProperty("BIT STRING"))return m=m["BIT STRING"],m instanceof Array||(m=p(m)),m.unshift(0),q=[3].concat(A(m),m);if(m.hasOwnProperty("NULL"))return[5,0];if(m.hasOwnProperty("OBJECT IDENTIFIER")){q=
m["OBJECT IDENTIFIER"].split(".");for(var y=[parseInt(40*q[0]+parseInt(q[1]))],C=2;C<q.length;C++){m=parseInt(q[C]);for(var M=[];0<m;)M.push(m&127|128),m>>>=7;M[0]&=127;y=y.concat(M.reverse())}m=y;return q=[6].concat(A(m),m)}if(m.hasOwnProperty("SEQUENCE")){q=m.fi;m=[];for(M=0;M<q.length;M++)m=m.concat(p(q[M]));return q=[48].concat(A(m),m)}if(m.hasOwnProperty("APPLICATION")){q=m.BD;y=isNaN(parseInt(q[0]))?32:0;C=m.tag;m=y?[]:m.BD;if(y)for(M=0;M<q.length;M++)m=m.concat(p(q[M]));return q=[160|y|C].concat(A(m),
m)}throw Error("unsupported asn.1 type");}function A(m){m=m.length;if(127>=m)return[m];m=Q(m);m.unshift(m.length|128);return m}function Q(m){var q=[];if(0===m)return[0];for(;0<m;)q.unshift(m&255),m>>>=8;return q}function E(m,q){var y=Array(q+1).join(" ")+m.type+" ("+m.length+") "+bytesToHexString(m.data).substring(0,16)+"\n";if(!m.children)return y;for(var C=0;C<m.children.length;C++)y+=E(m.children[C],q+4)+"";return y}var t={0:"CUSTOM",1:"BOOLEAN",2:"INTEGER",3:"BIT STRING",4:"OCTET STRING",5:"NULL",
6:"OBJECT IDENTIFIER",16:"SEQUENCE",17:"SET",19:"PRINTABLE STRING",23:"UTCTime"};return{parse:h,encode:p,toString:function(m){return E(m,0)}}}(),qb=function(){function h(p){Xa&&va&&self.postMessage(p);return p}return{nC:function(p){var A=p.data.operationType,Q=u[A][p.data.algorithm.name],E=p.data;if(!u.oB(A,p.data.algorithm.name))throw Error("unregistered algorithm.");return E.Ja?h({type:E.Ja,result:Q(E)}):h(Q(E))},eQ:h}}();va&&(self.onmessage=function(h){if(!Xa&&h.data.mu)return nb.ud(h.data.mu),
Xa=!0,qb.eQ({cC:!0});!0===Xa&&qb.nC(h)});var Ia=function(){function h(E){E=E.algorithm.name.slice(0,3).toUpperCase();return"RSA"===E?"RSA":"ECD"===E?"EC":"oct"}function p(E){return E.hash.name.substring(E.hash.name.indexOf("-")+1)}var A=ba,Q={HMAC:function(E){return"HS"+p(E)},"AES-CBC":function(E){return"A"+E.length.toString()+"CBC"},"AES-GCM":function(E){return"A"+E.length.toString()+"GCM"},"AES-KW":function(E){return"A"+E.length.toString()+"KW"},"RSAES-PKCS1-V1_5":function(){return"RSA1_5"},"RSASSA-PKCS1-V1_5":function(E){return"RS"+
p(E)},"RSA-OAEP":function(E){return"SHA-1"===E.hash.name.toUpperCase()?"RSA-OAEP":"RSA-OAEP-"+p(E)},"RSA-PSS":function(E){return"PS"+p(E)},ECDSA:function(E){return"EC-"+E.namedCurve.substring(E.namedCurve.indexOf("-")+1)}};return{RO:function(E,t){var m={};m.kty=h(E);m.extractable=E.extractable;if(t.pop)m.k=A.ce(t,!0);else for(var q in t)t[q].pop&&(m[q]=A.ce(t[q],!0));E.algorithm.namedCurve&&(m.crv=E.algorithm.namedCurve);E=JSON.stringify(m,null,"\t");t=[];for(m=0;m<E.length;m++)t[m]=E.charCodeAt(m);
0===t[t.length-1]&&t.pop();return t},hp:function(E,t){var m={};m.kty=h(E);m.ext=E.extractable;Q[E.algorithm.name.toUpperCase()]&&(m.alg=Q[E.algorithm.name.toUpperCase()](E.algorithm));m.key_ops=E.usages;if(t.pop)m.k=A.ce(t,!0);else for(var q in t)t[q].pop&&"key_ops"!==q&&(m[q]=A.ce(t[q],!0));E.algorithm.namedCurve&&(m.crv=E.algorithm.namedCurve);return m},Ol:function(E,t,m){E=JSON.parse(JSON.stringify(E));for(t=0;t<m.length;t+=1){var q=E[m[t]];q&&(E[m[t]]=A.El(q))}return E}}}(),xa=function(){function h(m,
q,y,C,M){var B,v=y[0],F=y[1],H=y[2],O=y[3],U=y[4];for(B=0;16>B;B++)M[B]=p.IA(m,64*q+4*B);for(B=16;80>B;B++)m=M[B-3]^M[B-8]^M[B-14]^M[B-16],M[B]=m<<1|m>>>31;for(B=0;80>B;B++)m=v<<5|v>>>27,m+=60<=B?F^H^O:40<=B?F&H^F&O^H&O:20<=B?F^H^O:F&H^~F&O,m+=U+C[B]+M[B],U=O,O=H,H=F<<30|F>>>2,F=v,v=m;y[0]+=v&4294967295;y[1]+=F&4294967295;y[2]+=H&4294967295;y[3]+=O&4294967295;y[4]+=U&4294967295;return y}var p=ba,A=p.Cp,Q=A("Z0UjAe/Nq4mYutz+EDJUdsPS4fA=",4,1),E=A("WoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlagnmZWoJ5mVqCeZlu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroW7Z66Fu2euhbtnroY8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcjxu83I8bvNyPG7zcymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdbKYsHWymLB1spiwdY",
4,1),t=A("MCEwCQYFKw4DAhoFAAQU");return{$l:function(){return g("SHA-1",t,Q,E,64,h,160)}}}();"undefined"!==typeof u&&(xa.Wb={},xa.rT=function(h){return xa.Wb[h]||(xa.Wb[h]=xa.$l())},xa.deleteInstance=function(h){xa.Wb[h]=null;delete xa.Wb[h]},xa.hash=function(h){if("process"===h.Ja)xa.$l.process(h.buffer);else return"finish"===h.Ja?xa.$l.finish():xa.$l().Vd(h.buffer)},u.register("digest","SHA-1",xa.hash));ea["SHA-1"]=xa.$l;var Ca=function(){function h(y,C,M,B,v){var F,H=M[0],O=M[1],U=M[2],ia=M[3],
Z=M[4],ma=M[5],X=M[6],x=M[7];for(F=0;16>F;F++)v[F]=p.IA(y,64*C+4*F);for(F=16;64>F;F++)y=v[F-15],C=v[F-2],v[F]=((C>>>17|C<<15)^(C>>>19|C<<13)^C>>>10)+v[F-7]+((y>>>7|y<<25)^(y>>>18|y<<14)^y>>>3)+v[F-16],v[F]&=4294967295;for(F=0;64>F;F++)y=x+((Z>>>6|Z<<26)^(Z>>>11|Z<<21)^(Z>>>25|Z<<7))+(Z&ma^~Z&X)+B[F]+v[F],ia+=y,y+=((H>>>2|H<<30)^(H>>>13|H<<19)^(H>>>22|H<<10))+(H&(O^U)^O&U),x=X,X=ma,ma=Z,Z=ia,ia=U,U=O,O=H,H=y;M[0]=M[0]+H>>>0;M[1]=M[1]+O>>>0;M[2]=M[2]+U>>>0;M[3]=M[3]+ia>>>0;M[4]=M[4]+Z>>>0;M[5]=M[5]+
ma>>>0;M[6]=M[6]+X>>>0;M[7]=M[7]+x>>>0;return M}var p=ba,A=p.Cp;var Q=A("wQWe2DZ81QcwcN0X9w5ZOf/ACzFoWBURZPmPp776T6Q",4,1);var E=A("agnmZ7tnroU8bvNypU/1OlEOUn+bBWiMH4PZq1vgzRk",4,1);var t=A("QoovmHE3RJG1wPvP6bXbpTlWwltZ8RHxkj+CpKscXtXYB6qYEoNbASQxhb5VDH3Dcr5ddIDesf6b3AanwZvxdOSbacHvvkeGD8GdxiQMocwt6SxvSnSEqlywqdx2+YjamD5RUqgxxm2wAyfIv1l/x8bgC/PVp5FHBspjURQpKWcntwqFLhshOE0sbfxTOA0TZQpzVHZqCruBwskuknIshaK/6KGoGmZLwkuLcMdsUaPRkugZ1pkGJPQONYUQaqBwGaTBFh43bAgnSHdMNLC8tTkcDLNO2KpKW5zKT2gub/N0j4LueKVjb4TIeBSMxwIIkL7/+qRQbOu++aP3xnF48g",
4,1);var m=A("MC0wDQYJYIZIAWUDBAIEBQAEHA");var q=A("MDEwDQYJYIZIAWUDBAIBBQAEIA");return{Pu:function(){return g("SHA-224",m,Q,t,64,h,224)},Qu:function(){return g("SHA-256",q,E,t,64,h,256)}}}();"undefined"!==typeof u&&(Ca.dC=Ca.dC||Ca.Pu(),Ca.eC=Ca.eC||Ca.Qu(),Ca.Wb={},Ca.DB=function(h){return Ca.Wb[h]||(Ca.Wb[h]=Ca.Pu())},Ca.EB=function(h){return Ca.Wb[h]||(Ca.Wb[h]=Ca.Qu())},Ca.deleteInstance=function(h){Ca.Wb[h]=null;delete Ca.Wb[h]},Ca.oO=function(h){if("process"===h.Ja)return Ca.EB(h.Fc).process(h.buffer),
null;if("finish"===h.Ja){var p=Ca.EB(h.Fc).finish();Ca.deleteInstance(h.Fc);return p}if("abort"===h.Ja)Ca.deleteInstance(h.Fc);else return Ca.eC.Vd(h.buffer)},Ca.nO=function(h){if("process"===h.Ja)Ca.DB(h.Fc).process(h.buffer);else if("finish"===h.Ja&&Ca.DB(h.Fc).finish(),"abort"===h.Ja)msrcryptoSha224.deleteInstance(h.Fc);else return Ca.dC.Vd(h.buffer)},u.register("digest","SHA-224",Ca.nO),u.register("digest","SHA-256",Ca.oO));ea["SHA-224"]=Ca.Pu;ea["SHA-256"]=Ca.Qu;var Na=function(){function h(M,
B,v,F,H){B=B+F|0;H[0]=M+v+(B>>>0<F>>>0)|0;H[1]=B}function p(M,B,v,F,H){var O,U=[],ia=[],Z=[],ma=v[0],X=v[1],x=v[2],n=v[3],z=v[4],w=v[5],K=v[6],S=v[7],W=v[8],T=v[9],L=v[10],P=v[11],aa=v[12],ua=v[13],La=v[14],Ya=v[15];for(O=0;32>O;O++){var Pa=128*B+4*O;H[O]=M.slice(Pa,Pa+4);H[O]=H[O][0]<<24|H[O][1]<<16|H[O][2]<<8|H[O][3]}for(O=32;160>O;O+=2){var sa=H[O-30];var fa=H[O-29];M=(sa>>>1|fa<<31)^(sa>>>8|fa<<24)^sa>>>7;B=(fa>>>1|sa<<31)^(fa>>>8|sa<<24)^(fa>>>7|sa<<25);sa=H[O-4];fa=H[O-3];Pa=(sa>>>19|fa<<13)^
(fa>>>29|sa<<3)^sa>>>6;sa=(fa>>>19|sa<<13)^(sa>>>29|fa<<3)^(fa>>>6|sa<<26);h(Pa,sa,H[O-14],H[O-13],U);h(M,B,U[0],U[1],U);h(H[O-32],H[O-31],U[0],U[1],U);H[O]=U[0];H[O+1]=U[1]}for(O=0;160>O;O+=2)M=(W>>>14|T<<18)^(W>>>18|T<<14)^(T>>>9|W<<23),B=(T>>>14|W<<18)^(T>>>18|W<<14)^(W>>>9|T<<23),Pa=W&L^aa&~W,sa=T&P^ua&~T,h(La,Ya,M,B,U),h(Pa,sa,F[O],F[O+1],ia),h(U[0],U[1],H[O],H[O+1],Z),h(ia[0],ia[1],Z[0],Z[1],Z),h(Z[0],Z[1],K,S,U),K=U[0],S=U[1],B=(X>>>28|ma<<4)^(ma>>>2|X<<30)^(ma>>>7|X<<25),M=(ma>>>28|X<<4)^
(X>>>2|ma<<30)^(X>>>7|ma<<25),sa=X&(n^w)^n&w,Pa=ma&(x^z)^x&z,h(Z[0],Z[1],M,B,U),M=U[0],B=U[1],h(Pa,sa,M,B,U),M=U[0],B=U[1],La=aa,Ya=ua,aa=L,ua=P,L=W,P=T,W=K,T=S,K=z,S=w,z=x,w=n,x=ma,n=X,ma=M,X=B;h(v[0],v[1],ma,X,U);v[0]=U[0];v[1]=U[1];h(v[2],v[3],x,n,U);v[2]=U[0];v[3]=U[1];h(v[4],v[5],z,w,U);v[4]=U[0];v[5]=U[1];h(v[6],v[7],K,S,U);v[6]=U[0];v[7]=U[1];h(v[8],v[9],W,T,U);v[8]=U[0];v[9]=U[1];h(v[10],v[11],L,P,U);v[10]=U[0];v[11]=U[1];h(v[12],v[13],aa,ua,U);v[12]=U[0];v[13]=U[1];h(v[14],v[15],La,Ya,U);
v[14]=U[0];v[15]=U[1];return v}var A=ba.Cp;var Q=A("y7udXcEFnthimikqNnzVB5FZAVowcN0XFS/s2PcOWTlnMyZn/8ALMY60SodoWBUR2wwuDWT5j6dHtUgdvvpPpA==",4,1);var E=A("agnmZ/O8yQi7Z66FhMqnOzxu83L+lPgrpU/1Ol8dNvFRDlJ/reaC0ZsFaIwrPmwfH4PZq/tBvWtb4M0ZE34heQ",4,1);var t=A("QoovmNcoriJxN0SRI+9lzbXA+8/sTTsv6bXbpYGJ27w5VsJb80i1OFnxEfG2BdAZkj+CpK8ZT5urHF7V2m2BGNgHqpijAwJCEoNbAUVwb74kMYW+TuSyjFUMfcPV/7Ticr5ddPJ7iW+A3rH+OxaWsZvcBqclxxI1wZvxdM9pJpTkm2nBnvFK0u++R4Y4TyXjD8GdxouM1bUkDKHMd6ycZS3pLG9ZKwJ1SnSEqm6m5INcsKncvUH71Hb5iNqDEVO1mD5RUu5m36uoMcZtLbQyELADJ8iY+yE/v1l/x77vDuTG4AvzPaiPwtWnkUeTCqclBspjUeADgm8UKSlnCg5ucCe3CoVG0i/8LhshOFwmySZNLG38WsQq7VM4DROdlbPfZQpzVIuvY952agq7PHeyqIHCyS5H7a7mknIshRSCNTuiv+ihTPEDZKgaZku8QjABwkuLcND4l5HHbFGjBlS+MNGS6BnW71IY1pkGJFVlqRD0DjWFV3EgKhBqoHAyu9G4GaTBFrjS0MgeN2wIUUGrUydId0zfjuuZNLC8teGbSKg5HAyzxclaY07YqkrjQYrLW5zKT3dj43NoLm/z1rK4o3SPgu5d77L8eKVjb0MXL2CEyHgUofCrcozHAggaZDnskL7/+iNjHiikUGzr3oK96b75o/eyxnkVxnF48uNyUyvKJz7O6iZhnNGGuMchwMIH6tp91s3g6x71fU9/7m7ReAbwZ6pyF2+6CmN9xaLImKYRP5gEvvkNrhtxCzUTHEcbKNt39SMEfYQyyqt7QMckkzyevgoVyb68Qx1nxJwQDUxMxdS+yz5Ctll/KZz8ZX4qX8tvqzrW+uxsRBmMSkdYFw==",
4,1);var m=A("MEEwDQYJYIZIAWUDBAICBQAEMA");var q=A("MFEwDQYJYIZIAWUDBAIDBQAEQA");var y=A("MC0wDQYJYIZIAWUDBAIFBQAEHA");var C=A("MDEwDQYJYIZIAWUDBAIGBQAEIA");return{am:function(){return g("SHA-384",m,Q,t,128,p,384)},bm:function(){return g("SHA-512",q,E,t,128,p,512)},MT:function(){return g("SHA-512.224",y,E,t,128,p,224)},NT:function(){return g("SHA-512.256",C,E,t,128,p,256)}}}();"undefined"!==typeof u&&(Na.Wb={},Na.sT=function(h){return Na.Wb[h]||(Na.Wb[h]=Na.am())},Na.tT=function(h){return Na.Wb[h]||
(Na.Wb[h]=Na.bm())},Na.deleteInstance=function(h){Na.Wb[h]=null;delete Na.Wb[h]},Na.pO=function(h){if("process"===h.Ja)Na.am.process(h.buffer);else return"finish"===h.Ja?Na.am.finish():Na.am().Vd(h.buffer)},Na.qO=function(h){if("process"===h.Ja)Na.bm.process(h.buffer);else return"finish"===h.Ja?Na.bm.finish():Na.bm().Vd(h.buffer)},u.register("digest","SHA-384",Na.pO),u.register("digest","SHA-512",Na.qO));ea["SHA-384"]=Na.am;ea["SHA-512"]=Na.bm;var la=la||k();if("undefined"!==typeof u){var kb={};f.cS=
function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.Fc;kb[A]||(kb[A]=f(h.keyData,p));if("process"===h.Ja)return kb[A].process(h.buffer),null;if("finish"===h.Ja)return h=kb[A].finish(),kb[A]=null,h;h=kb[A].RA(h.buffer);kb[A]=null;return h};f.BS=function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.Fc;kb[A]||(kb[A]=f(h.keyData,p));if("process"===h.Ja)return kb[A].process(h.buffer),null;if("finish"===h.Ja)return p=kb[A].finish(),p=ba.zl(p,h.qD),kb[A]=null,p;
p=kb[A].RA(h.buffer);p=ba.zl(p,h.qD);kb[A]=null;return p};f.generateKey=function(h){var p={"SHA-1":64,"SHA-224":64,"SHA-256":64,"SHA-384":128,"SHA-512":128},A=h.algorithm.length;void 0===A&&(A=p[h.algorithm.hash.name.toUpperCase()]);return{type:"keyGeneration",keyData:nb.ve(A),keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:"secret"}}};f.importKey=function(h){if("jwk"===h.format){var p=Ia.Ol(h.keyData,h.algorithm,["k"]);p.alg=p.alg.replace("HS","SHA-")}else if("raw"===
h.format)p={k:ba.wc(h.keyData)};else throw Error("unsupported import format");return{type:"keyImport",keyData:p.k,keyHandle:{algorithm:{name:"HMAC",hash:{name:h.algorithm.hash.name}},extractable:h.extractable||p.extractable,usages:h.usages,type:"secret"}}};f.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.hp(h.keyHandle,h.keyData)};if("raw"===h.format)return{type:"keyExport",keyHandle:h.keyData};throw Error("unsupported export format");};u.register("importKey","HMAC",
f.importKey);u.register("exportKey","HMAC",f.exportKey);u.register("generateKey","HMAC",f.generateKey);u.register("sign","HMAC",f.cS);u.register("verify","HMAC",f.BS)}var Db=function(){var h,p,A,Q,E,t,m,q,y,C;return{ug:function(M){function B(n,z){return[n[4*z],n[4*z+1],n[4*z+2],n[4*z+3]]}function v(n){for(var z=0;z<n.length;z+=1)n[z]=y[n[z]]}function F(n){for(var z=0;z<n.length;z+=1)n[z]=q[n[z]]}function H(n,z,w){for(var K=0;K<n.length;K+=1)n[K]^=z[K+w]}function O(n,z){return[n[0]^z[0],n[1]^z[1],
n[2]^z[2],n[3]^z[3]]}function U(n){var z=n[13];n[13]=n[9];n[9]=n[5];n[5]=n[1];n[1]=z;z=n[10];n[10]=n[2];n[2]=z;z=n[14];n[14]=n[6];n[6]=z;z=n[3];n[3]=n[7];n[7]=n[11];n[11]=n[15];n[15]=z}function ia(n){var z=n[1];n[1]=n[5];n[5]=n[9];n[9]=n[13];n[13]=z;z=n[2];n[2]=n[10];n[10]=z;z=n[6];n[6]=n[14];n[14]=z;z=n[15];n[15]=n[11];n[11]=n[7];n[7]=n[3];n[3]=z}h||(h=ba.Cp("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",
256,!1),p=h[0],A=h[1],Q=h[2],E=h[3],t=h[4],m=h[5],q=h[6],y=h[7],C=h[8]);var Z=8*M.length;switch(Z){case 128:case 192:case 256:break;default:throw Error("Unsupported keyLength");}var ma=Z/32;var X=ma+6;var x=function(n){for(var z=[],w=0;w<4*ma;)z.push(n[w++]);for(w=ma;w<4*(X+1);){n=B(z,w-1);if(0===w%ma){var K=[C[w/ma],0,0,0],S=n,W=S[0];S[0]=S[1];S[1]=S[2];S[2]=S[3];S[3]=W;F(n);n=O(n,K)}else 6<ma&&4===w%ma&&F(n);K=O(B(z,w-ma),n);n=z;S=w;n[4*S]=K[0];n[4*S+1]=K[1];n[4*S+2]=K[2];n[4*S+3]=K[3];w+=1}return z}(M);
return{encrypt:function(n){var z;H(n,x,0);for(z=1;z<=X-1;z+=1){F(n);ia(n);var w=n,K=w[0],S=w[1],W=w[2],T=w[3],L=w[4],P=w[5],aa=w[6],ua=w[7],La=w[8],Ya=w[9],Pa=w[10],sa=w[11],fa=w[12],ha=w[13],pa=w[14],ya=w[15];w[0]=p[K]^A[S]^W^T;w[1]=K^p[S]^A[W]^T;w[2]=K^S^p[W]^A[T];w[3]=A[K]^S^W^p[T];w[4]=p[L]^A[P]^aa^ua;w[5]=L^p[P]^A[aa]^ua;w[6]=L^P^p[aa]^A[ua];w[7]=A[L]^P^aa^p[ua];w[8]=p[La]^A[Ya]^Pa^sa;w[9]=La^p[Ya]^A[Pa]^sa;w[10]=La^Ya^p[Pa]^A[sa];w[11]=A[La]^Ya^Pa^p[sa];w[12]=p[fa]^A[ha]^pa^ya;w[13]=fa^p[ha]^
A[pa]^ya;w[14]=fa^ha^p[pa]^A[ya];w[15]=A[fa]^ha^pa^p[ya];H(n,x,16*z)}F(n);ia(n);H(n,x,16*X);return n},decrypt:function(n){var z;H(n,x,16*X);for(z=X-1;1<=z;--z){U(n);v(n);H(n,x,16*z);var w=n,K=w[0],S=w[1],W=w[2],T=w[3],L=w[4],P=w[5],aa=w[6],ua=w[7],La=w[8],Ya=w[9],Pa=w[10],sa=w[11],fa=w[12],ha=w[13],pa=w[14],ya=w[15];w[0]=Q[K]^t[S]^E[W]^m[T];w[1]=m[K]^Q[S]^t[W]^E[T];w[2]=E[K]^m[S]^Q[W]^t[T];w[3]=t[K]^E[S]^m[W]^Q[T];w[4]=Q[L]^t[P]^E[aa]^m[ua];w[5]=m[L]^Q[P]^t[aa]^E[ua];w[6]=E[L]^m[P]^Q[aa]^t[ua];w[7]=
t[L]^E[P]^m[aa]^Q[ua];w[8]=Q[La]^t[Ya]^E[Pa]^m[sa];w[9]=m[La]^Q[Ya]^t[Pa]^E[sa];w[10]=E[La]^m[Ya]^Q[Pa]^t[sa];w[11]=t[La]^E[Ya]^m[Pa]^Q[sa];w[12]=Q[fa]^t[ha]^E[pa]^m[ya];w[13]=m[fa]^Q[ha]^t[pa]^E[ya];w[14]=E[fa]^m[ha]^Q[pa]^t[ya];w[15]=t[fa]^E[ha]^m[pa]^Q[ya]}U(n);v(n);H(n,x,0);return n},clear:function(){},BT:Z,blockSize:128}}}}(),zd=zd||{};zd.tP=function(h){return{mp:function(p){var A=p[0<=p.length-1?p.length-1:0],Q=A.length;if(Q===h){A=[];for(Q=0;Q<h;Q+=1)A.push(h);p.push(A)}else for(p=h-Q&255;A.length!==
h;)A.push(p)},Dp:function(p){var A=!0;0!==p.length%h&&(A=!1);for(var Q=p.slice(-h),E=Q[Q.length-1],t=0;t<h;t++){var m=Q[t]===E;A=(h-t<=E?m:!0)&&A}p.length-=A?E:0;return A}}};if("undefined"!==typeof u){var fb={};e.Gp=function(h){var p=h.Fc;fb[p]||(fb[p]=e(Db.ug(h.keyData)),fb[p].ud(h.algorithm.iv));if("process"===h.Ja)return fb[p].nu(h.buffer);if("finish"===h.Ja)return h=fb[p].Qo(),fb[p]=null,h;h=fb[p].encrypt(h.buffer);fb[p]=null;return h};e.Fp=function(h){var p=h.Fc;fb[p]||(fb[p]=e(Db.ug(h.keyData)),
fb[p].ud(h.algorithm.iv));if("process"===h.Ja)fb[p].op(h.buffer);else{if("finish"===h.Ja)return h=fb[p].Po(),fb[p]=null,h;h=fb[p].decrypt(h.buffer);fb[p]=null;return h}};e.generateKey=function(h){if(0!==h.algorithm.length%8)throw Error();return{type:"keyGeneration",keyData:nb.ve(Math.floor(h.algorithm.length/8)),keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:"secret"}}};e.importKey=function(h){var p=8*h.keyData.length;if("jwk"===h.format)p=Ia.Ol(h.keyData,h.algorithm,
["k"]);else if("raw"===h.format){if(128!==p&&192!==p&&256!==p)throw Error("invalid key length (should be 128, 192, or 256 bits)");p={k:ba.wc(h.keyData)}}else throw Error("unsupported import format");h.algorithm.length=8*p.k.length;return{keyData:p.k,keyHandle:{algorithm:h.algorithm,extractable:h.extractable||p.extractable,usages:h.usages,type:"secret"},type:"keyImport"}};e.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.hp(h.keyHandle,h.keyData)};if("raw"===h.format)return{type:"keyExport",
keyHandle:h.keyData};throw Error("unsupported export format");};u.register("importKey","AES-CBC",e.importKey);u.register("exportKey","AES-CBC",e.exportKey);u.register("generateKey","AES-CBC",e.generateKey);u.register("encrypt","AES-CBC",e.Gp);u.register("decrypt","AES-CBC",e.Fp)}if("undefined"!==typeof u){var gb={};d.encrypt=function(h){var p=h.Fc;gb[p]||(gb[p]=d(Db.ug(h.keyData)),gb[p].ud(h.algorithm.iv,h.algorithm.additionalData,h.algorithm.tagLength));if("process"===h.Ja)gb[p].nu(h.buffer);else{if("finish"===
h.Ja)return h=gb[p].Qo(),gb[p]=null,h;h=gb[p].encrypt(h.buffer);gb[p]=null;return h}};d.decrypt=function(h){var p=h.Fc;gb[p]||(gb[p]=d(Db.ug(h.keyData)),gb[p].ud(h.algorithm.iv,h.algorithm.additionalData,h.algorithm.tagLength));if("process"===h.Ja)gb[p].op(h.buffer);else{if("finish"===h.Ja){h=gb[p].Po();gb[p]=null;if(null===h)throw Error("OperationError");return h}var A=h.algorithm.tagLength?Math.floor(h.algorithm.tagLength/8):16;h=gb[p].decrypt(h.buffer.slice(0,h.buffer.length-A),h.buffer.slice(-A));
gb[p]=null;if(null===h)throw Error("OperationError");return h}};d.generateKey=function(h){if(0!==h.algorithm.length%8)throw Error();return{type:"keyGeneration",keyData:nb.ve(Math.floor(h.algorithm.length/8)),keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:"secret"}}};d.importKey=function(h){var p=8*h.keyData.length;if("jwk"===h.format)p=Ia.Ol(h.keyData,h.algorithm,["k"]);else if("raw"===h.format){if(128!==p&&192!==p&&256!==p)throw Error("invalid key length (should be 128, 192, or 256 bits)");
p={k:ba.wc(h.keyData)}}else throw Error("unsupported import format");return{type:"keyImport",keyData:p.k,keyHandle:{algorithm:h.algorithm,extractable:h.extractable||p.extractable,usages:h.usages,type:"secret"}}};d.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.hp(h.keyHandle,h.keyData)};if("raw"===h.format)return{type:"keyExport",keyHandle:h.keyData};throw Error("unsupported export format");};u.register("importKey","AES-GCM",d.importKey);u.register("exportKey","AES-GCM",
d.exportKey);u.register("generateKey","AES-GCM",d.generateKey);u.register("encrypt","AES-GCM",d.encrypt);u.register("decrypt","AES-GCM",d.decrypt)}var nb=new l,Qg=function(){function h(Q){Q=nb.ve(Math.ceil(Q/8));Q[0]|=128;Q[Q.length-1]|=1;return la.Ch(Q)}var p=[],A=[];return{tB:function(Q){Q=h(Q);var E=0,t=[],m,q;var y=Q.length-1;var C=la.YD,M=Q[y];if(0===p.length){var B=Array(16385);var v=[];var F=Math.sqrt(16384)|0;for(m=3;m<=F;m+=2)for(q=m*m;16384>=q;q+=2*m)B[q]=0;for(m=3;16384>=m;m+=2)0!==B[m]&&
v.push(m);p=v}q=p.length;A=Array(q);for(B=0;B<q;B++){v=y;m=p[B];M<m?(F=M,v--):F=0;for(;0<=v;)F=F*C+Q[v--],F-=(F/m|0)*m;A[B]=F}for(;;){a:{C=A.length;for(y=0;y<C;y++)if(0===(A[y]+E)%p[y]){y=!1;break a}y=!0}if(y){la.add(Q,[E],t);a:{B=t;y=[];la.Tc(B,[1],y);m=y;if(la.lC(m))C=0;else{for(v=0;0===m[v];v++);M=0;for(C=2;0===m[v]%C;C*=2,M++);C=v*la.Op+M}M=[];la.pD(y,M,C);F=B;if(la.lC(F))v=0;else{for(q=F.length-1;0===F[q];q--);m=la.Op-1;for(v=1<<m;0<m&&0===(F[q]&v);v>>>=1,m--);v=q*la.Op+m}B=la.Wh(B);for(m=1;6>=
m;m++){q=!1;do var H=h(v);while(0<=la.Hf(H,y));F=[];B.Cj(H,M,F,!0);if(0!==la.Hf(F,[1])&&0!==la.Hf(F,y)){for(H=1;H<C;H++){B.Dj(F,F,F);if(0===la.Hf(F,y)){q=!0;break}if(0===la.Hf(F,[1])){y=!1;break a}}if(!1===q){y=!1;break a}}}y=!0}if(!0===y)return t}E+=2}}}}(),Lc={jp:function(h,p,A){var Q=[],E,t=A.Xt/8;for(E=0;E<=Math.floor(p/t);E+=1){var m=[E>>>24&255,E>>>16&255,E>>>8&255,E&255];m=A.Vd(h.concat(m));Q=Q.concat(m)}return Q.slice(0,p)},dT:function(h,p){if(h.length>(p.maxMessageSize||4294967295))throw Error("message too long");
}},Zb=Zb||{};Zb.lP=function(h,p){var A=ba,Q=nb,E=h.n.length;if(null===p)throw Error("must supply hashFunction");return{mp:function(t,m){if(t.length>E-p.Xt/8*2-2)throw Error("Message too long.");null==m&&(m=[]);m=p.Vd(m);var q=A.vc(E-t.length-2*m.length-2);q=m.concat(q,[1],t);t=Q.ve(m.length);var y=Lc.jp(t,E-m.length-1,p);q=A.$e(q,y);m=Lc.jp(q,m.length,p);m=A.$e(t,m);return t=[0].concat(m,q).slice()},Dp:function(t,m){var q=m;m=0;var y=0===t[0];void 0===q&&(q=[]);q=p.Vd(q);var C=t.slice(1,q.length+
1);t=t.slice(q.length+1);var M=Lc.jp(t,q.length,p);C=A.$e(C,M);C=Lc.jp(C,E-q.length-1,p);t=A.$e(t,C);C=t.slice(0,q.length);y=y&&A.zl(q,C);for(t=t.slice(q.length);!t[m++];);return{valid:y,data:t.slice(m)}}}};"undefined"!==typeof u&&(b.sign=function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.algorithm.saltLength,Q=h.algorithm.salt;return b(h.keyData,h.algorithm.name,p).bS(h.buffer,A,Q)},b.verify=function(h){var p=ea[h.keyHandle.algorithm.hash.name.toUpperCase()](),A=h.algorithm.saltLength;
return b(h.keyData,h.algorithm.name,p).CS(h.qD,h.buffer,A)},b.Gp=function(h){switch(h.algorithm.name){case "RSAES-PKCS1-V1_5":var p=b(h.keyData,h.algorithm.name);h=p.encrypt(h.buffer);break;case "RSA-OAEP":p=h.keyHandle.algorithm.hash.name;if(!p)throw Error("unsupported hash algorithm");p=ea[p.toUpperCase()]();p=b(h.keyData,h.algorithm.name,p);h=p.encrypt(h.buffer);break;default:throw Error("unsupported algorithm");}return h},b.Fp=function(h){switch(h.algorithm.name){case "RSAES-PKCS1-V1_5":var p=
b(h.keyData,h.algorithm.name);h=p.decrypt(h.buffer);break;case "RSA-OAEP":p=h.keyHandle.algorithm.hash.name;if(!p)throw Error("unsupported hash algorithm");p=ea[p.toUpperCase()]();p=b(h.keyData,h.algorithm.name,p);h=p.decrypt(h.buffer);break;default:throw Error("unsupported algorithm");}return h},b.importKey=function(h){if("jwk"===h.format){var p=Ia.Ol(h.keyData,h.algorithm,"n e d p q dp dq qi".split(" "));p.d&&(p.Dt=(new la.Wh(la.Ch(p.p))).wg,p.Et=(new la.Wh(la.Ch(p.q))).wg)}else if("spki"===h.format){var A=
Aa.parse(h.keyData);if(null==A)throw Error("invalid key data.");A=A[1];A=Aa.parse(A.data.slice(A.Ag+1),!0);if(null==A)throw Error("invalid key data.");p=A[0];A=A[1];if("INTEGER"!==p.type||"INTEGER"!==A.type)throw Error("invalid key data.");p=p.data.slice(p.Ag);A=A.data.slice(A.Ag);0===p[0]&&p[1]&128&&(p=p.slice(1));0===A[0]&&A[1]&128&&(A=A.slice(1));p={n:p,e:A}}else if("pkcs8"===h.format){A=Aa.parse(h.keyData);if(null==A)throw Error("invalid key data.");A=A[2];A=Aa.parse(A.data.slice(A.Ag),!0);if(null==
A)throw Error("invalid key data.");var Q="n e d p q dp dq qi".split(" ");p={};for(var E=1;E<A.length;E++){var t=A[E];t=t.data.slice(t.Ag);0===t[0]&&t[1]&128&&(t=t.slice(1));p[Q[E-1]]=t}}else throw Error("unsupported key import format.");return{type:"keyImport",keyData:p,keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:h.usages,type:p.d||p.dq?"private":"public"}}},b.exportKey=function(h){if("jwk"===h.format)return{type:"keyExport",keyHandle:Ia.hp(h.keyHandle,h.keyData)};if("spki"===
h.format)return h=Aa.encode({fi:[{fi:[{"OBJECT IDENTIFIER":"1.2.840.113549.1.1.1"},{UE:1}]},{"BIT STRING":{fi:[{xd:h.keyData.n},{xd:h.keyData.e}]}}]}),{type:"keyExport",keyHandle:h};if("pkcs8"===h.format)return h=Aa.encode({fi:[{xd:0},{fi:[{"OBJECT IDENTIFIER":"1.2.840.113549.1.1.1"},{UE:1}]},{"OCTET STRING":{fi:[{xd:0},{xd:h.keyData.n},{xd:h.keyData.e},{xd:h.keyData.d},{xd:h.keyData.p},{xd:h.keyData.q},{xd:h.keyData.dp},{xd:h.keyData.dq},{xd:h.keyData.qi}]}}]}),{type:"keyExport",keyHandle:h};throw Error(h.format+
" not implemented");},b.genRsaKeyFromRandom=function(h,p){p=p?la.Ch(p):[65537];do{var A=Qg.tB(h/2),Q=Qg.tB(h/2);if(0<la.Hf(Q,A)){var E=A;A=Q;Q=E}E=[];la.multiply(A,Q,E);var t=[];la.Tc(A,[1],t);var m=[];la.Tc(Q,[1],m);var q=[];la.multiply(t,m,q);var y=[];la.RN(p,q,y);y=0===la.Hf(y,la.YE)}while(!y);h=[];la.hu(p,q,h);q=[];la.reduce(h,t,q);t=[];la.reduce(h,m,t);m=[];la.hu(Q,A,m);y=la.iB;return{privateKey:{n:y(E),e:y(p),d:y(h),p:y(A),q:y(Q),dp:y(q),dq:y(t),qi:y(m)},publicKey:{n:y(E),e:y(p)}}},b.Fl=function(h){if("undefined"===
typeof h.algorithm.modulusLength)throw Error("missing modulusLength");var p=la.Ch;switch(h.algorithm.modulusLength){case 1024:case 2048:case 4096:var A=b.genRsaKeyFromRandom(h.algorithm.modulusLength,h.algorithm.publicExponent);break;default:throw Error("invalid modulusLength");}var Q=A.privateKey;Q.Dt=(new la.Wh(p(Q.p))).wg;Q.Et=(new la.Wh(p(Q.q))).wg;p=h.algorithm.name;"RSASSA-PKCS1-V1_5"===p||"RSA-PSS"===p?(p=["verify"],Q=["sign"]):(p=["encrypt"],Q=["decrypt"]);return{type:"keyGeneration",Kf:{publicKey:{keyData:A.publicKey,
keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:p,type:"public"}},privateKey:{keyData:A.privateKey,keyHandle:{algorithm:h.algorithm,extractable:h.extractable,usages:Q,type:"private"}}}}},u.register("sign","RSASSA-PKCS1-V1_5",b.sign),u.register("sign","RSA-PSS",b.sign),u.register("verify","RSASSA-PKCS1-V1_5",b.verify),u.register("verify","RSA-PSS",b.verify),u.register("encrypt","RSAES-PKCS1-V1_5",b.Gp),u.register("decrypt","RSAES-PKCS1-V1_5",b.Fp),u.register("encrypt","RSA-OAEP",
b.Gp),u.register("decrypt","RSA-OAEP",b.Fp),u.register("importKey","RSA-OAEP",b.importKey),u.register("importKey","RSAES-PKCS1-V1_5",b.importKey),u.register("importKey","RSASSA-PKCS1-V1_5",b.importKey),u.register("importKey","RSA-PSS",b.importKey),u.register("exportKey","RSA-OAEP",b.exportKey),u.register("exportKey","RSAES-PKCS1-V1_5",b.exportKey),u.register("exportKey","RSASSA-PKCS1-V1_5",b.exportKey),u.register("exportKey","RSA-PSS",b.exportKey),u.register("generateKey","RSA-OAEP",b.Fl),u.register("generateKey",
"RSAES-PKCS1-V1_5",b.Fl),u.register("generateKey","RSASSA-PKCS1-V1_5",b.Fl),u.register("generateKey","RSA-PSS",b.Fl));var Eb=function(){return{deriveBits:function(h){var p=ea[h.algorithm.hash.name.toUpperCase()](),A=h.algorithm,Q=Qa.wc(A.XS).concat(Qa.wc(A.ET),Qa.wc(A.FT),Qa.wc(A.KT)||[],Qa.wc(A.IT)||[]);A=Math.ceil(h.length/p.Xt);var E=1;Q=h.keyData.concat(Q);for(var t=[],m=0;m<A;m++){var q=Qa.fC(E++).concat(Q);q=p.Vd(q);t=t.concat(q)}return t.slice(0,h.length/8)}}}();"undefined"!==typeof u&&(Eb.importKey=
function(h){if("raw"===h.format)var p=ba.wc(h.keyData);else throw Error("unsupported import format");if(!1!==h.extractable)throw Error("only extractable=false is supported.");return{type:"keyImport",keyData:p,keyHandle:{algorithm:{name:"CONCAT"},extractable:!1,usages:h.usages,type:"secret"}}},u.register("deriveBits","CONCAT",Eb.deriveBits),u.register("importKey","CONCAT",Eb.importKey));var Qa=ba;var Mc=function(){function h(B){return{process:function(v){return B.process(v)},finish:function(){return B.finish()},
abort:function(){return B.abort()}}}function p(){var B;return{postMessage:function(v){try{v.Fc=this.id,B=qb.nC({data:v})}catch(F){this.onerror({data:F,type:"error"});return}this.onmessage({data:B})},onmessage:null,onerror:null,terminate:function(){}}}function A(B){var v,F;var H=new Promise(function(O,U){v=O;F=U});return{dispatchEvent:function(O){"error"===O.type?F&&(O.data&&(O.data.stack="Error")&&(O.data.code=0),F.apply(H,[O.data||O])):"process"===O.data.type?B(O.data.result,!0):"finish"===O.data.type?
B(O.data.result,!0):(this.result=B(O.data),v.apply(H,[this.result]))},promise:H,result:null}}function Q(){return A(function(B){switch(B.type){case "keyGeneration":case "keyImport":case "keyDerive":if(B.Kf)return q.add(B.Kf.publicKey.keyHandle,B.Kf.publicKey.keyData),q.add(B.Kf.privateKey.keyHandle,B.Kf.privateKey.keyData),{publicKey:B.Kf.publicKey.keyHandle,privateKey:B.Kf.privateKey.keyHandle};q.add(B.keyHandle,B.keyData);return B.keyHandle;case "keyExport":return B.keyHandle;case "keyPairGeneration":var v=
B.Kf.privateKey;B=B.Kf.publicKey;q.add(B.keyHandle,B.keyData);q.add(v.keyHandle,v.keyData);return{publicKey:B.keyHandle,privateKey:v.keyHandle};default:throw Error("Unknown key operation");}})}function E(B){var v=[],F=A(function(H,O){var U;if(U=H)U=ca&&H.pop?(new Uint8Array(H)).buffer:H;H=U;if(O)v.resolve(H);else return H});F.stream=B.algorithm.stream;v.add=function(H){var O,U,ia=new Promise(function(Z,ma){O=Z;U=ma});ia.label=H;v.push({resolve:O,reject:U,promise:ia});return ia};v.resolve=function(H){var O=
v.shift();O.resolve.apply(O.promise,[H])};F.process=function(H){B.Ja="process";B.buffer=Qa.wc(H);y.UA(this,Qa.clone(B));return v.add("process")};F.finish=function(){B.Ja="finish";B.buffer=[];y.UA(this,Qa.clone(B));return v.add("finish")};F.abort=function(){y.IM(this)};F.algorithm=B.algorithm||null;F.key=B.keyHandle||null;return F}function t(B){B=q.YO(B);if(!B)throw Error("key not found");return B}function m(B,v,F){var H=B,O={operationType:H},U;"importKey"!==H||"raw"!==v[0]&&"spki"!==v[0]&&"pkcs8"!==
v[0]||(H="importKeyRaw");"importKey"===H&&"jwk"===v[0]&&(H="importKeyJwk");H=M[H];for(U=0;U<H.length;U+=1){var ia=C[H[U]];var Z=v[U];if(null==Z){if(ia.required)throw Error(ia.name);}else{Z.subarray&&(Z=Qa.wc(Z));"ArrayBuffer"===Qa.Tt(Z)&&(Z=Qa.wc(Z));if(ba.Tt(Z)!==ia.type)throw Error(ia.name);"algorithm"===ia.name&&(Z.name=Z.name.toUpperCase(),Z.iv&&(Z.iv=Qa.wc(Z.iv)),Z.publicExponent&&(Z.publicExponent=Qa.wc(Z.publicExponent)),Z.salt&&(Z.salt=Qa.wc(Z.salt)),Z.additionalData&&(Z.additionalData=Qa.wc(Z.additionalData)),
Z.hash&&!Z.hash.name&&"String"===Qa.Tt(Z.hash)&&(Z.hash={name:Z.hash}));O.hasOwnProperty(ia.name)?O[ia.name+"1"]=Z:O[ia.name]=Z}}if(!u.oB(B,O.algorithm.name))throw Error("unsupported algorithm");O.keyHandle&&(O.keyData=t(O.keyHandle));O.cu&&(O.QO=t(O.cu));O.algorithm&&O.algorithm.public&&(O.WS=t(O.algorithm.public));v=F?Q(O):E(O);(F||O.buffer||"deriveBits"===B||"wrapKey"===B)&&y.fQ(v,O);return v.stream?Promise.resolve(h(v)):v.promise}var q=[];q.add=function(B,v){q.push({keyHandle:B,keyData:v})};q.remove=
function(B){for(var v=0;v<q.length;v+=1)if(q[v].keyHandle===B){q=q.splice(v,1);break}};q.YO=function(B){for(var v=0;v<q.length;v+=1)if(q[v].keyHandle===B)return q[v].keyData;return null};var y=function(){function B(){K.shift()()}function v(T){K.push(T);S(B,0)}function F(T){for(var L=0;L<x.length;L++)if(x[L]===T){T.terminate();x.splice(L,1);break}}function H(T){for(var L=0;L<x.length;L++)if(x[L].Rc===T)return x[L];return null}function O(T,L){n.push({Rc:T,data:L,id:z++})}function U(T){T.Eo=!1;if(da)if(0<
n.length){T=n.shift();var L;ma(T.Rc,T.data);if("process"===T.data.Ja){for(L=0;L<n.length;L++)T.Rc===n[L].Rc&&ma(n[L].Rc,n[L].data);for(L=n.length-1;0<=L;L--)T.Rc===n[L].Rc&&n.splice(L,1)}}else{for(var P=L=0;P<x.length;P++)x[P].Eo||(L+=1);2<L&&F(T)}}function ia(T){if("pending"===W)throw Error("Creating new worker while workerstatus=pending");if("ready"===W)try{var L=new Worker(ka);L.postMessage({mu:nb.ve(48)});L.bu=!0}catch(P){da=!1,W="failed",L.terminate(),L=p(),L.bu=!1}else L=p(),L.bu=!1;L.Rc=T;
L.id=w++;L.Eo=!1;L.onmessage=function(P){if(!0!==P.data.cC){var aa=L.Rc;P.target||(P.target={data:L.data});for(var ua=0;ua<n.length;ua++)if(n[ua].Rc===L.Rc){P=n[ua];n.splice(ua,1);X(L,P.data);return}P.data.hasOwnProperty("type")&&"process"===P.data.type||U(L);aa.dispatchEvent(P)}};L.onerror=function(P){var aa=L.Rc;U(L);aa.dispatchEvent(P)};x.push(L);return L}function Z(T,L){if("pending"===W)O(T,L);else{a:{var P=!da;for(var aa=x.length-1;0<=aa;--aa)x[aa].bu===P&&(x[aa].terminate(),x.splice(aa,1));
for(P=0;P<x.length;P++)if(!x[P].Eo){P=x[P];break a}P=null}if(da&&null===P&&12<=x.length)O(T,L);else{null===P&&(P=ia(T));if(null===P)throw O(T,L),Error("could not create new worker");P.Rc=T;P.Eo=!0;L.Fc=P.id;X(P,L)}}}function ma(T,L){var P=H(T);P?X(P,L):Z(T,L)}function X(T,L){L.Fc=T.id;da?T.postMessage(L):v(function(P){return function(){return T.postMessage(P)}}(L))}var x=[],n=[],z=0,w=0,K=[],S="undefined"===typeof setImmediate?setTimeout:setImmediate,W=ja?"available":"unavailable";return{fQ:Z,UA:ma,
IM:function(T){(T=H(T))&&F(T)},Ep:function(T){function L(aa){var ua=!(!aa.data||!0!==aa.data.cC);P.removeEventListener("message",L,!1);P.removeEventListener("error",L,!1);P.terminate();W=ua?"ready":"failed";da=ua;Qa.yt("web worker initialization "+(ua?"succeeded. Now using web workers.":"failed. running synchronously."+(aa.message||"")));0<n.length&&(aa=n.shift(),Z(aa.Rc,aa.data))}if("unavailable"===W)Qa.yt("web workers not available in this browser.");else if(!0!==T||"ready"!==W)if(!1!==T||"available"!==
W)if(!1===T&&"ready"===W)da=!1,W="available",Qa.yt("web workers disabled.");else if("pending"!==W){W="pending";var P=new Worker(ka);P.addEventListener("message",L,!1);P.addEventListener("error",L,!1);P.postMessage({mu:nb.ve(48)})}}}}(),C=[{name:"algorithm",type:"Object",required:!0},{name:"keyHandle",type:"Object",required:!0},{name:"buffer",type:"Array",required:!1},{name:"signature",type:"Array",required:!0},{name:"format",type:"String",required:!0},{name:"keyData",type:"Object",required:!0},{name:"extractable",
type:"Boolean",required:!1},{name:"usages",type:"Array",required:!1},{name:"derivedKeyType",type:"Object",required:!0},{name:"length",type:"Number",required:!1},{name:"extractable",type:"Boolean",required:!0},{name:"usages",type:"Array",required:!0},{name:"keyData",type:"Array",required:!0}],M={encrypt:[0,1,2],decrypt:[0,1,2],sign:[0,1,2],verify:[0,1,3,2],digest:[0,2],generateKey:[0,6,7],importKeyRaw:[4,12,0,10,11],importKeyJwk:[4,5,0,10,11],exportKey:[0,4,1,6,7],deriveKey:[0,1,8,6,7],deriveBits:[0,
1,9],wrapKey:[1,1,0],unwrapKey:[2,0,1,6,7]};return{yP:{encrypt:function(B,v,F){return m("encrypt",arguments,0)},decrypt:function(B,v,F){return m("decrypt",arguments,0)},sign:function(B,v,F){return m("sign",arguments,0)},verify:function(B,v,F,H){return m("verify",arguments,0)},digest:function(B,v){return m("digest",arguments,0)},generateKey:function(B,v,F){return m("generateKey",arguments,1)},deriveKey:function(B,v,F,H,O){var U=this.deriveBits,ia=this.importKey;return new Promise(function(Z,ma){switch(F.name.toUpperCase()){case "AES-CBC":case "AES-GCM":var X=
F.length;break;case "HMAC":X=F.length||{"SHA-1":512,"SHA-224":512,"SHA-256":512,"SHA-384":1024,"SHA-512":1024}[F.hash.name.toUpperCase()];break;default:ma(Error("No Supported"));return}U(B,v,X).then(function(x){return ia("raw",x,F,H,O)}).then(function(x){Z(x)})["catch"](function(x){ma(x)})})},deriveBits:function(B,v,F){return m("deriveBits",arguments,0)},importKey:function(B,v,F,H,O){return m("importKey",arguments,1)},exportKey:function(B,v){return m("exportKey",[v.algorithm,B,v],1)},wrapKey:function(B,
v,F,H){var O=this.encrypt,U=this.exportKey;return new Promise(function(ia,Z){if(!1===v.extractable||0>F.usages.indexOf("wrapKey")||F.algorithm.name.toUpperCase()!==H.name)Z(Error("InvalidAccessError"));else U(B,v).then(function(ma){console.log(Qa.ce(ma));return O(H,F,"jwk"===B?Qa.Nj(JSON.stringify(ma,null,0)):ma)}).then(function(ma){ia(ma)})["catch"](function(ma){Z(ma)})})},unwrapKey:function(B,v,F,H,O,U,ia){var Z=this.decrypt,ma=this.importKey;return new Promise(function(X,x){if(0>F.usages.indexOf("unwrapKey")||
F.algorithm.name.toUpperCase()!==H.name)x(Error("InvalidAccessError"));else Z(H,F,v).then(function(n){return ma(B,"jwk"===B?JSON.parse(Qa.JA(n)):n,O,U,ia)}).then(function(n){X(n)})["catch"](function(n){x(n)})})}},xO:{Ep:y.Ep}}}();Eb=function(){var h=ba;return{wrapKey:function(p){var A=b(p.QO,p.cu.algorithm.name,ea["SHA-1"])(),Q=Ia.RO(p.keyHandle,p.keyData);p=h.ce(JSON.stringify({alg:p.cu.algorithm.name.toUpperCase(),enc:"A128GCM"}),!0);var E=nb.ve(32);A=A.encrypt(E);A=h.ce(A,!0);var t=nb.ve(12),m=
h.ce(t,!0),q=p.concat(".",A,".",m);E=d(Db.ug(E));E.ud(t,h.Nj(q),128);E=E.encrypt(Q);t=E.slice(-16);Q=h.ce(t,!0);E=h.ce(E.slice(0,E.length-t.length),!0);return h.Nj(JSON.stringify({Rl:[{Ag:p,kB:A,wO:Q}],bC:m,gN:E}))},unwrapKey:function(p){var A=h.El,Q=JSON.parse(String.fromCharCode.apply(null,p.buffer));h.El(Q.Rl[0].Ag);var E=A(Q.Rl[0].kB),t=A(Q.Rl[0].wO),m=A(Q.bC);A=A(Q.gN);var q=ea["SHA-1"]();E=b(p.keyData,p.keyHandle.algorithm.name,q).decrypt(E);Q=Q.Rl[0].Ag.concat(".",Q.Rl[0].kB,".",Q.bC);E=d(Db.ug(E));
E.ud(m,h.Nj(Q),128);t=E.decrypt(A,t);t=Ia.Ol(t,p.algorithm,["k"]);return{type:"keyImport",keyData:t.k,keyHandle:{algorithm:{name:p.algorithm.name},extractable:p.extractable||t.extractable,usages:p.usages,type:"secret"}}}}}();"undefined"!==typeof u&&(u.register("wrapKey","AES-GCM",Eb.wrapKey),u.register("unwrapKey","AES-CBC",Eb.unwrapKey));Eb={subtle:Mc?Mc.yP:null,getRandomValues:function(h){var p,A=nb.ve(h.length);for(p=0;p<h.length;p+=1)h[p]=A[p];return h},wT:function(h){var p=Object.prototype.toString.call(h);
if("[object Array]"!==p&&"[object Uint8Array]"!==p)throw Error("entropyData must be a Array or Uint8Array");$b&&$b.Wl(h);nb.Wl($b.read(48))},ce:function(h,p){return ba.ce(h,p)},El:function(h){return ba.El(h)},QT:function(h){return ba.Nj(h)},cT:function(h){return ba.JA(h)},aT:Aa,url:ka,version:"1.6.6",Ep:function(h){return Mc?Mc.xO.Ep(h):null}};var $b=$b||new G(a);$b.ud();var Vg=$b.read(48);nb.ud(Vg);return Eb}()});
function qa(){Promise.all=function(a){function b(e,f){return function(g){c[e]=g;d+=1;d===a.length&&f(c)}}var c=[],d=0;return new Promise(function(e,f){function g(l){f(l)}var k;for(k=0;k<a.length;k+=1)a[k].then?(a[k].then(b(k,e)),a[k]["catch"](g)):Promise.resolve(a[k]).then(b(k,e))})};Promise.race=function(a){function b(d){return function(e){c||(c=!0,d(e))}}var c=!1;return new Promise(function(d,e){for(var f=0;f<a.length;f+=1)a[f].then(b(d),b(e))})};Promise.reject=function(a){return new Promise(function(b,
c){c(a)})};Promise.resolve=function(a){return new Promise(function(b){b(a)})};return Promise}"undefined"===typeof Promise&&void 0!==window.Promise&&(this.Promise=qa());
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(d){var e=(new Date).getTime(),f=Math.max(0,16-(e-a)),g=window.setTimeout(function(){d(e+f)},f);a=e+f;return g});window.cancelAnimationFrame||(window.cancelAnimationFrame=
function(d){clearTimeout(d)})})();var ra;ra={bq:1,Og:2,MS:3,OS:4,NS:5,Lv:5};var ta;ta=function(a){this.g=a};ta.prototype={XA:function(a){var b=this;return function(c,d,e,f,g,k){c=b.hH(e,b.g.A.la,c,d,f,a,g);return k?c:b.g.rd(c)}},hH:function(a,b,c,d,e,f,g){var k,l=1;f=new za(f);for(var G;k=e.pop();)G=new za(k.id),G.Zp(l),f.Mv(G),l+=this.zG(k.qC);a=new Fa(a,b,c,d);a.$d(f);(g instanceof Ga||g instanceof Ha)&&a.Nb(g);return a},zG:function(a){var b=0;do++b,a>>>=1;while(0!==a);return b}};var D;D=function(){};
D.bk=function(){return D.fA};D.ZD=function(){return D.zH};D.ci=function(a){var b=new I(a.offsetX,a.offsetY);null!==a.currentTarget&&(b=J.$O(a.currentTarget,b));return b};D.Vx=function(a){var b=new I(a.offsetLeft,a.offsetTop);a.offsetParent&&(a=D.Vx(a.offsetParent),b.X+=a.X,b.Y+=a.Y);return b};D.jA=!1;D.hq=function(a){var b=this.UF(a);null!==b&&(a=D.Vx(a.target),b.X-=a.X,b.Y-=a.Y);return b};
D.UF=function(a){return a.pageX&&a.target?new I(a.pageX,a.pageY):(D.jA||(D.jA=!0,N.error("Evaluation of Touch events not supported because the browser uses an unexpected interface")),null)};D.FJ=navigator.userAgent.match(/OS 6(_\d)+ like Mac OS X/i);D.sO=function(){return D.FJ};D.rE=function(){var a=void 0!==window.TouchEvent&&"ontouchstart"in window&&"ontouchend"in document;return void 0!==window.PointerEvent&&void 0!==navigator.maxTouchPoints&&0<navigator.maxTouchPoints||a};
D.qE=function(a){return J.uq(a.RuntimeVersion,16)};D.oE=function(a,b){return J.uq(a.RuntimeVersion,18)&&2147527629!=b.Th};D.mE=function(a){return J.uq(a.RuntimeVersion,18,10)};D.Gv=function(){return void 0!==document.scrollingElement};D.nE=function(){return void 0!==window.atob&&(void 0!==window.crypto&&void 0!==window.crypto.subtle||void 0!==window.msrCrypto&&void 0!==window.msrCrypto.subtle)};
D.oy=function(a,b){a.style.cssText+="outline: none; -webkit-tap-highlight-color: rgba(0,0,0,0);";b&&(a.style.cssText+="display:block;");a.addEventListener("MSHoldVisual",function(c){c.preventDefault()})};D.af=function(){return window.devicePixelRatio?window.devicePixelRatio:1};D.Wp=function(){return void 0!==window.visualViewport};D.NE=function(a,b){D.oy(a,2E3);D.oy(b,1E3)};D.uz=function(a){if(void 0!==a&&null!==a&&!(0<=a.indexOf("%")))return parseFloat(a)};
D.wz=function(a){if(void 0===a)return null;a=a.split(/[\s,]/);return 4>a.length?null:new Ja(parseFloat(a[2]),parseFloat(a[3]))};D.fM=function(a){var b=new XMLHttpRequest;b.open("GET",a.src,!1);b.send();return b.responseXML&&b.responseXML.documentElement?b.responseXML&&b.responseXML.documentElement:null};
D.rG=function(a,b){var c=new XMLHttpRequest;c.open("GET",a.src);c.onreadystatechange=function(){4===c.readyState&&(200===c.status?c.responseXML&&c.responseXML.documentElement?b(c.responseXML.documentElement):b(null):b(null))};c.send()};
D.pL=function(a){try{if(0<=a.src.toLowerCase().indexOf(".svg")){N.h("Derivation of SVG size for '"+a.src+"' failed. Parsing manually");var b=D.fM(a);if(null!==b){var c=D.uz(b.getAttribute("width"));var d=D.uz(b.getAttribute("height"));if(c&&d)return new Ja(c,d);var e=D.wz(b.getAttribute("viewBox"));if(null!==e)return e}}}catch(f){N.error("Exception during manual parsing of SVG size.")}return null};
D.Dv=function(a){if(a.naturalWidth&&a.naturalHeight)return new Ja(a.naturalWidth,a.naturalHeight);if(a.width&&a.height)return new Ja(a.width,a.height);a=D.pL(a);return null!==a?a:new Ja(0,0)};D.lq=function(){return D.tL};D.EI="undefined"!==typeof InstallTrigger;D.QE=function(a,b,c){return!D.EI&&!c.WorkaroundForceSVGEmptySizeWorkaround||c.WorkaroundDisableSVGEmptySizeWorkaround?!1:J.wq(b)&&void 0!==a.naturalWidth&&0===a.naturalWidth&&void 0!==a.naturalHeight&&0===a.naturalHeight};
D.bE=function(a,b,c){try{D.rG(a,function(d){if(null===d)c("DoZeroWidthHeightWorkaround: svg xml not available");else{var e=D.wz(d.getAttribute("viewBox"));null===e?c("DoZeroWidthHeightWorkaround: no view box available"):(d.setAttribute("width",e.L),d.setAttribute("height",e.aa),d=(new XMLSerializer).serializeToString(d),b("data:image/svg+xml;base64,"+btoa(d)))}})}catch(d){c(d.toString())}};
D.Qb=function(){return"onpointerdown"in window&&"PointerEvent"in window&&!Ka.kE("CFG_WorkaroundDisablePointerEvents",!1)};D.Cv=function(){var a=Ka.lE("CFG_WorkaroundFileTransferTimeout");return null!==a?a:D.lq()?400:0};D.tL=-1!==navigator.userAgent.indexOf("Safari")&&0>navigator.userAgent.indexOf("Chrome");var Ma="undefined"===typeof ArrayBuffer||"undefined"===typeof Uint8Array||"undefined"===typeof Int8Array,Oa,Ra;Ma||(Oa=new ArrayBuffer(4),Ra=new Int8Array(Oa,1,2),Ma=2!==Ra.byteLength);D.fA=Ma;
D.zH=function(){if(D.fA)return!1;var a="undefined"!==typeof DataView,b;if(/opera [56789]|opera\/[56789]/i.test(navigator.userAgent)||/MSIE (\d+\.\d+);/.test(navigator.userAgent))return!1;try{if(a){var c=new ArrayBuffer(8);var d=new Int8Array(c);for(b=0;8>b;++b)d[b]=b;var e=new DataView(c);if(a="function"===typeof e.getFloat64&&"function"===typeof e.getFloat32&&"function"===typeof e.getInt32&&"function"===typeof e.getUint32&&"function"===typeof e.getInt16&&"function"===typeof e.getUint16&&"function"===
typeof e.getInt8&&"function"===typeof e.getInt8)e.getFloat64(0),e.getFloat32(0),e.getInt32(0),e.getUint32(0),e.getInt16(0),e.getUint16(0),e.getInt8(0),e.getInt8(0)}}catch(f){return!1}return a}();D.xb=function(a,b){return void 0!==a.includes?a.includes(b):0<=a.indexOf(b)};D.CF=function(a,b){return void 0!==a.startsWith?a.startsWith(b):0===a.lastIndexOf(b,0)};
D.Av=function(){try{var a=void 0!==navigator.languages?navigator.languages.length?navigator.languages[0]:navigator.language:navigator.language;var b=a.split("-");b.length&&(a=b[0]);return a}catch(c){return""}};D.Vh=function(){return window.WindowZoomFactor?1E-4<=Math.abs(parseFloat(window.WindowZoomFactor)-1):!1};D.Yj=function(a){var b=D.Up();b&&a.Yl(1/b);return a};D.Up=function(){return parseFloat(window.WindowZoomFactor)};var Configuration;
Configuration=function(){this.PlcAddress="0101";this.UseLocalHost=!0;this.CommBufferSize=5E4;this.ErrorReconnectTime=1E4;this.Application="Application";this.UpdateRate=200;this.BestFitForDialogs=this.BestFit=!1;this.StartVisu="Visualization";this.StartVisuDefaultEncodingBase64="";this.XhrSendTimeout=0;this.LoginVisuDefLang=this.LoginVisuNamespace=this.LoginVisuErrorTexts=this.LoginVisuTexts=this.LoginVisu="";this.PollingRegistrationInterval=100;this.TimeMeasurements="";this.LogLevel="INFO";this.MaxUnusedImageAge=
2E4;this.MaxUndrawnImageAge=1E4;this.NumCachedImages=15;this.ChangeWindowTitle=!0;this.TooltipFont="";this.DefaultKeyActions=!0;this.KeysForWebVisu="Backspace,Tab";this.ANSIStringEncoding="iso-8859-1";this.CommitEditcontrolOnClickOut=!0;this.HandleTouchEvents=!1;this.FuzzyTransparencyColorEvaluation=!0;this.TouchHandlingActive=this.Benchmarking=this.HasKeyboard=this.LoadImagesById=!1;this.ClientName="";this.ScaleTypeIsotropic=this.IecSupportsCommonMiterLimit=this.SemiTransparencyActive=!1;this.GesturesFlickPanThresholdPxPerSecond=
1E3;this.GesturesPanFlickTimeThresholdMs=40;this.GesturesPanClickThresholdDistSquare=10;this.PostDataInHeader=0;this.vq=this.AutoFontReductionActive=!1;this.ProgrammingSystemModeWaitingText="The online visualization is waiting for a connection. Please start the application.";this.ProgrammingSystemModeErrorText="Some sort of error occurred during the Visualisation.";this.ConnectionInfoValidTimeMsForLeaveAfterError=1E3;this.WorkaroundDisableMouseUpDownAfterActiveTouch=!0;this.WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch=
500;this.WorkaroundForceSVGEmptySizeWorkaround=this.WorkaroundDisableSVGEmptySizeWorkaround=this.WorkaroundDisableSVGAspectRatioWorkaround=this.WorkaroundDisableResizeHandling=!1;this.ContentSecurityPolicyIncludeTrustedOrigins=this.RuntimeVersion=this.CasFactoryName="";this.DefaultConfigurationOnError=!1;this.MaxResizePixel=30;this.FillBackground=!1;this.tq=5E3;this.UseBrowserLanguage=this.ContextMenuDisabled=this.TouchContextMenuEnabled=this.DebugHTML5=this.DebugOnlyInputReactionExplCoord=this.DebugOnlyInputReactionOnUp=
this.DebugOnlyDiagnosisDisplay=this.DebugOnlyPrintTouchRectangles=this.DebugOnlyPrintGestures=this.DebugOnlyPrintRawTouches=this.DebugOnlyPrintPaintCommands=!1};
Configuration.prototype={validate:function(){if("string"!==typeof this.PlcAddress)throw Error("Plc address must be of type string");if("boolean"!==typeof this.UseLocalHost)throw Error("UseLocalHost must be of type boolean");if("number"!==typeof this.CommBufferSize)throw Error("CommBufferSize must be of type number");if("number"!==typeof this.ErrorReconnectTime)throw Error("ErrorReconnectTime must be of type number");if("string"!==typeof this.Application)throw Error("Application must be of type string");
if("number"!==typeof this.UpdateRate)throw Error("UpdateRate must be of type number");if("number"!==typeof this.MaxResizePixel)throw Error("MaxResizePixel must be of type number");void 0!==this.LoginMaxResizePixel&&30===this.MaxResizePixel&&(this.MaxResizePixel=this.LoginMaxResizePixel);if("boolean"!==typeof this.BestFit)throw Error("BestFit must be of type boolean");if("boolean"!==typeof this.BestFitForDialogs)throw Error("BestFitForDialogs must be of type boolean");if("string"!==typeof this.StartVisu)throw Error("StartVisu must be of type string");
if("string"!==typeof this.LoginVisu)throw Error("LoginVisu must be of type string");if("string"!==typeof this.LoginVisuTexts)throw Error("LoginVisuTexts must be of type string");if("string"!==typeof this.LoginVisuErrorTexts)throw Error("LoginVisuErrorTexts must be of type string");if("string"!==typeof this.LoginVisuNamespace)throw Error("LoginVisuNamespace must be of type string");if("string"!==typeof this.LoginVisuDefLang)throw Error("LoginVisuDefLang must be of type string");if("number"!==typeof this.PollingRegistrationInterval)throw Error("PollingRegistrationInterval must be of type number");
if("string"!==typeof this.TimeMeasurements)throw Error("TimeMeasurements must be of type string");if("string"!==typeof this.TooltipFont)throw Error("TooltipFont must be of type string");if("boolean"!==typeof this.DefaultKeyActions)throw Error("DefaultKeyActions must be of type boolean");if("string"!==typeof this.ANSIStringEncoding)throw Error("ANSIStringEncoding must be of type string");if("boolean"!==typeof this.FuzzyTransparencyColorEvaluation)throw Error("FuzzyTransparencyColorEvaluation must be of type boolean");
if("boolean"!==typeof this.LoadImagesById)throw Error("LoadImagesById must be of type boolean");if("boolean"!==typeof this.Benchmarking)throw Error("Benchmarking must be of type boolean");if("boolean"!==typeof this.TouchHandlingActive)throw Error("TouchHandlingActive must be of type boolean");if("boolean"!==typeof this.HasKeyboard)throw Error("HasKeyboard must be of type boolean");if("boolean"!==typeof this.SemiTransparencyActive)throw Error("SemiTransparencyActive must be of type boolean");if("boolean"!==
typeof this.ScaleTypeIsotropic)throw Error("ScaleTypeIsotropic must be of type boolean");if("number"!==typeof this.GesturesFlickPanThresholdPxPerSecond||0>this.GesturesFlickPanThresholdPxPerSecond)throw Error("GesturesFlickPanThresholdPxPerSecond must be of type nonnegative number");if("number"!==typeof this.GesturesPanFlickTimeThresholdMs||0>this.GesturesPanFlickTimeThresholdMs)throw Error("GesturesPanFlickTimeThresholdMs must be of type nonnegative number");if("number"!==typeof this.GesturesPanClickThresholdDistSquare||
0>this.GesturesPanClickThresholdDistSquare)throw Error("GesturesPanClickThresholdDistSquare must be of type nonnegative number");if("number"!==typeof this.PostDataInHeader||0>this.PostDataInHeader||2<this.PostDataInHeader)throw Error("PostDataInHeader must be a number in the range 0..2");if("boolean"!==typeof this.AutoFontReductionActive)throw Error("AutoFontReductionActive must be of type boolean");if("boolean"!==typeof this.vq)throw Error("UseUTF8Encoding must be of type boolean");if("string"!==
typeof this.ProgrammingSystemModeWaitingText)throw Error("ProgrammingSystemModeWaitingText must be of type string");if("string"!==typeof this.ProgrammingSystemModeErrorText)throw Error("ProgrammingSystemModeErrorText must be of type string");if("number"!==typeof this.ConnectionInfoValidTimeMsForLeaveAfterError)throw Error("ConnectionInfoValidTimeMsForLeaveAfterError must be of type number");if("boolean"!==typeof this.FillBackground)throw Error("FillBackground must be of type boolean");if("boolean"!==
typeof this.DebugOnlyPrintPaintCommands)throw Error("DebugOnlyPrintPaintCommands must be of type boolean");if("boolean"!==typeof this.DebugOnlyPrintRawTouches)throw Error("DebugOnlyPrintRawTouches must be of type boolean");if("boolean"!==typeof this.DebugOnlyPrintGestures)throw Error("DebugOnlyPrintGestures must be of type boolean");if("boolean"!==typeof this.DebugOnlyPrintTouchRectangles)throw Error("DebugOnlyPrintTouchRectangles must be of type boolean");if("boolean"!==typeof this.DebugOnlyDiagnosisDisplay)throw Error("DebugOnlyDiagnosisDisplay must be of type boolean");
if("boolean"!==typeof this.DebugOnlyInputReactionOnUp)throw Error("DebugOnlyInputReactionOnUp must be of type boolean");if("boolean"!==typeof this.DebugOnlyInputReactionExplCoord)throw Error("DebugOnlyInputReactionExplCoord must be of type boolean");if("boolean"!==typeof this.WorkaroundDisableMouseUpDownAfterActiveTouch)throw Error("WorkaroundDisableMouseUpDownAfterActiveTouch must be of type boolean");if("boolean"!==typeof this.WorkaroundDisableResizeHandling)throw Error("WorkaroundDisableResizeHandling must be of type boolean");
if("number"!==typeof this.WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch||0>this.WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch)throw Error("WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch must be of type nonnegative number");if("string"!==typeof this.CasFactoryName)throw Error("CasFactoryName must be of type string");if("string"!==typeof this.RuntimeVersion)throw Error("RuntimeVersion must be of type string");if("string"!==typeof this.ContentSecurityPolicyIncludeTrustedOrigins)throw Error("ContentSecurityPolicyIncludeTrustedOrigins must be of type string");
if("number"!==typeof this.tq)throw Error("TouchSanityInterval must be of type number");if("boolean"!==typeof this.ContextMenuDisabled)throw Error("ContextMenuDisabled must be of type boolean");if("boolean"!==typeof this.TouchContextMenuEnabled)throw Error("TouchContextMenuEnabled must be of type boolean");this.yg()},PB:function(){try{return new Sa(this.TooltipFont)}catch(a){return this.TooltipFont=""}},yg:function(){return new na(this.ANSIStringEncoding)},td:function(){return new oa(this.ANSIStringEncoding)}};
var Ta;Ta=function(a,b,c,d,e){this.CommBufferSize=a;this.Fa=b;this.cf=c;this.$p=d;this.Th=Ua.xa;this.la=Ua.m;this.eq="";this.yF=e;this.Lp=!1;this.Gc=""};Ta.prototype={IQ:function(a){this.Gc=a}};var Va;Va=function(){};Va.Pp="";Va.RE="";Va.Qp="2";Va.cv="3";Va.bF="4";Va.PF="5";Va.xF="6";var Wa;Wa=function(){};Wa.h="NOSP";Wa.xa="---";Wa.m=1E3;Wa.J=1100;var $a;$a=function(){};$a.ProgrammingSystemModeErrorText="Some sort of error occurred during the Visualisation.";$a.ProgrammingSystemModeWaitingText="The online visualization is waiting for a connection. Please start the application.";
$a.h=1;$a.Ya=$a.h;$a.Pb=$a.h+1;$a.J=$a.h+2;$a.m=$a.h+3;$a.xa=$a.h+4;$a.Uc=$a.h+5;var ab;ab=function(a,b,c,d,e,f,g,k,l){this.xr=a;this.jb=d%360;this.MG=e;this.NG=f;this.ur=g;(0===this.ur||2===this.ur)&&180<this.jb?(this.jb-=180,this.Om=k?c:l,this.mk=b):(this.Om=b,this.mk=k?c:l)};
ab.prototype={bO:function(a,b){if(0===b.C()||0===b.B())return"#ffffff";switch(this.ur){case 0:return this.Gw(a,b,!1);case 1:return this.AG(a,b);case 2:return this.Gw(a,b,!0);default:return"#ffffff"}},Gw:function(a,b,c){var d=b.Gl();var e=90<this.jb?R.gm(180-this.jb):R.gm(this.jb);var f=d.X-Math.max(b.B(),b.C())*Math.cos(e);var g=d.Y-Math.max(b.B(),b.C())*Math.sin(e);if(this.Uy(d.X,d.Y,f,g,b.u,b.v,b.u,b.ca)){d=e;e=b.C()/2*Math.tan(d);e=b.B()/2-e;d=Math.PI/2-d;d=e*Math.cos(d);f=d*d/e;g=e-f;var k=Math.sqrt(Math.max(0,
g*f));e=b.u-k;d=b.v+g;f=b.V+k;g=b.ca-g}else this.Uy(d.X,d.Y,f,g,b.u,b.v,b.V,b.v)?(d=e,e=b.B()/2/Math.tan(d),e=b.C()/2-e,d=Math.PI/2-d,d=Math.cos(d)*e,f=d*d/e,k=Math.sqrt(Math.max(0,(e-f)*f)),e=b.u+f,d=b.v-k,f=b.V-f,g=b.ca+k):(e=b.u,d=b.v,f=b.V,g=b.ca);90<this.jb&&(e=b.V-(e-b.u),f=b.V-(f-b.u));a=a.createLinearGradient(e,d,f,g);a.addColorStop(0,this.Om);c?(a.addColorStop(.45,this.mk),a.addColorStop(.55,this.mk),a.addColorStop(1,this.Om)):a.addColorStop(1,this.mk);return a},AG:function(a,b){var c=new I(b.u+
b.C()*this.MG,b.v+b.B()*this.NG);b=this.aJ(b,c);a=a.createRadialGradient(c.X,c.Y,0,c.X,c.Y,b);a.addColorStop(0,this.Om);a.addColorStop(1,this.mk);return a},Uy:function(a,b,c,d,e,f,g,k){var l=(k-f)*(c-a)-(g-e)*(d-b);g=(g-e)*(b-f)-(k-f)*(a-e);a=(c-a)*(b-f)-(d-b)*(a-e);if(0===l)return g===a;b=g/l;l=a/l;return 0<=b&&1>=b&&0<=l&&1>=l},aJ:function(a,b){var c=[];c[0]=this.Vm(new I(a.u,a.v),b);c[1]=this.Vm(new I(a.V,a.v),b);c[2]=this.Vm(new I(a.V,a.ca),b);c[3]=this.Vm(new I(a.u,a.ca),b);for(a=b=0;4>a;++a)b=
Math.max(b,c[a]);return Math.sqrt(b)},Vm:function(a,b){return(a.X-b.X)*(a.X-b.X)+(a.Y-b.Y)*(a.Y-b.Y)}};var bb;bb=function(a){this.g=a;this.Er()};
bb.prototype={Er:function(){var a=this;window.document.addEventListener("keydown",function(b){a.tK(b)},!1);window.document.addEventListener("keypress",function(b){a.uK(b)},!1);window.document.addEventListener("keyup",function(b){a.vK(b)},!1)},uK:function(a){if(a.repeat)a.preventDefault();else{var b=this.g.A;a=this.sn(a);null!==b&&null!==a&&this.g.rd(Fa.Ya(b.la,a))}},tK:function(a){if(a.repeat)a.preventDefault();else{var b=this.Yx(a),c=this.g.A;this.lz("onKeyDown",b)||(this.Jw(a),null!==c&&null!==
b&&void 0!==b.key&&this.g.rd(Fa.J(128,c.la,b.key,b.flags)))}},vK:function(a){var b=this.Yx(a),c=this.g.A;this.lz("onKeyUp",b)||(this.Jw(a),null!==c&&null!==b&&void 0!==b.key&&this.g.rd(Fa.J(256,c.la,b.key,b.flags)))},lz:function(a,b){return this.g.Oc&&window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess[a]&&window.ProgrammingSystemAccess[a](b.key,b.flags)?!0:!1},Yx:function(a){var b=a.keyCode,c=0;if(16<=b&&18>=b)return null;a.shiftKey&&(c|=1);a.altKey&&(c|=2);a.ctrlKey&&(c|=4);return{key:b,
flags:c}},sn:function(a){var b=0;a.charCode?b=a.charCode:a.which&&(b=a.which);if(0===b||void 0!==a.altKey&&!0===a.altKey&&48<=b&&57>=b)return null;if(void 0!==a.ctrlKey&&a.ctrlKey||void 0!==a.altKey&&a.altKey)if(void 0===a.ctrlKey||!a.ctrlKey||void 0===a.altKey||!a.altKey)return null;return String.fromCharCode(b)},VK:function(a){var b;if(void 0===this.g.getConfiguration().KeysForWebVisu||""===this.g.getConfiguration().KeysForWebVisu)return!1;var c=this.g.getConfiguration().KeysForWebVisu.split(",");
for(b=0;b<c.length;b++)if(c[b]==a.key)return!0;return!1},Jw:function(a){J.J(this.g)||null===this.g.getConfiguration()||this.g.getConfiguration().DefaultKeyActions&&!this.VK(a)||a.preventDefault&&a.preventDefault()}};var cb;cb=function(a){this.g=a;this.xn=!1;this.Cr=0;this.ZJ=[];this.h()};
cb.prototype={eD:function(a){this.xn=a},gR:function(a){this.Cr=a},ZR:function(a){this.tr().style.touchAction=a?"none":"auto"},h:function(){var a=this;if(D.Qb()){var b=!this.g.pa;N.h("Mouse-Handling using PointerEvents");this.ie("pointerup",function(c){a.$k(c)},b);this.ie("pointerdown",function(c){a.Tn(c)},b);this.ie("pointermove",function(c){a.Zk(c)},b);this.ie("pointerout",function(c){a.CK(c)},b)}else N.h("Mouse-Handling using MouseEvents"),this.ie("mouseup",function(c){a.Sn(c)},!1),this.ie("mousedown",
function(c){a.Qn(c)},!1),this.ie("mousemove",function(c){a.Rn(c)},!1),this.ie("mouseout",function(c){a.yK(c)},!1),this.ie("touchstart",function(c){a.mg(c)},!0),this.ie("touchmove",function(c){a.mg(c)},!0),this.ie("touchend",function(c){a.mg(c)},!0)},tr:function(){return this.g.pa?this.g.Za():this.g.U().xg().canvas},ie:function(a,b,c){this.tr().addEventListener(a,b,c,{passive:!1});this.ZJ.push({type:a,callback:b,RT:c})},cn:function(a,b){if(null!==this.g.A){var c=D.ci(a);this.g.pa&&(a=J.Rj(a.target,
this.tr()),c=c.offset(a));b=Fa.h(b,this.g.A.la,c);this.g.rd(b)}},Dn:function(a){var b=this.g.getConfiguration();null===b||"touch"!==a.pointerType||b.TouchHandlingActive||("pointerup"===a.type?this.g.He.Mo():"pointerout"===a.type?(this.g.He.Ko(),this.g.He.Mo()):"pointerdown"===a.type&&this.g.He.Ko());return null!==b&&b.TouchHandlingActive?"touch"!==a.pointerType:a.isPrimary},Tn:function(a){!J.J(this.g)&&this.Dn(a)&&(a.preventDefault(),this.Mi(a))},$k:function(a){!J.J(this.g)&&this.Dn(a)&&(a.preventDefault(),
this.Ni(a))},Zk:function(a){!J.J(this.g)&&this.Dn(a)&&(a.preventDefault(),this.ey(a))},CK:function(a){!J.J(this.g)&&this.Dn(a)&&(a.preventDefault(),this.gy(a))},Ni:function(a){J.qq(a)&&(this.g.rb.vC(a),this.cn(a,db.h))},Mi:function(a){J.qq(a)&&(this.g.he.Ho(a),this.g.rb.uC(a),this.cn(a,db.J))},ey:function(a){this.xn||this.cn(a,db.m)},gy:function(a){null!==a.relatedTarget&&void 0!==a.relatedTarget&&"string"===typeof a.relatedTarget.nodeName&&"html"!==a.relatedTarget.nodeName.toLowerCase()||this.cn(a,
4096)},Sn:function(a){J.J(this.g)||(J.m()<this.Cr?N.h("Dropping mouse up due to required delay!"):this.Ni(a))},Qn:function(a){J.J(this.g)||(J.m()<this.Cr?N.h("Dropping mouse down due to required delay!"):this.Mi(a))},Rn:function(a){J.J(this.g)||this.ey(a)},yK:function(a){J.J(this.g)||this.gy(a)},mg:function(a){if(!J.J(this.g)&&null!==this.g.getConfiguration()&&this.g.getConfiguration().HandleTouchEvents&&!this.g.getConfiguration().TouchHandlingActive){var b=null;switch(a.type){case "touchstart":var c=
db.J;this.xn=!0;break;case "touchmove":c=db.m;break;case "touchend":c=db.h;this.xn=!1;break;default:return}a.touches&&1<=a.touches.length?b=D.hq(a.touches[0]):a.changedTouches&&1<=a.changedTouches.length&&(b=D.hq(a.changedTouches[0]));null!==b&&(null!==this.g.A&&(c===db.J?this.g.rb.qS(b,a):c==db.h&&this.g.rb.pS(b,a),c=Fa.h(c,this.g.A.la,b),this.g.rd(c)),a.preventDefault())}}};var hb;hb=function(a,b,c){this.ah=a;this.yH=b;this.Uq=c;this.mz=Ga.D(1E3)};
hb.prototype={aP:function(){return this.yH-this.mz.size()},Wd:function(){return this.mz},finish:function(){this.Uq=0},Bg:function(){return 0===this.Uq}};var ib;ib=function(a){this.En=0!==(a&65536);this.oz=0!==(a&131072);this.pz=0!==(a&262144);this.qz=0!==(a&524288);this.nz=0!==(a&1048576);this.yy=0!==(a&2097152);this.zy=0!==(a&4194304);this.En=this.En||this.yy||this.zy;this.MJ=!(this.oz||this.pz||this.qz||this.nz)};
ib.prototype={Zt:function(){return this.left()||this.right()||this.Vu()},kC:function(){return this.top()||this.bottom()||this.Wu()},jC:function(){return this.left()||this.top()},iC:function(){return this.right()||this.bottom()},Qc:function(){return this.MJ},left:function(){return this.oz},right:function(){return this.pz},top:function(){return this.qz},bottom:function(){return this.nz},cm:function(){return this.Qc()&&this.En},Wu:function(){return this.Qc()&&this.zy},Vu:function(){return this.Qc()&&
this.yy}};var lb;lb=function(a,b){this.g=a;this.ri=b};lb.prototype={mQ:function(){var a=this.g.eb();D.oE(this.g.getConfiguration(),this.ri)||this.FL(a);this.CL(a)},Xb:function(){},S:function(){},CL:function(a){var b=this.g.ob(this.ri);b.DN();a.wb(b.qb(),this,!0)},FL:function(a){var b=this.g.ob(this.ri);b.$u(this.ri.la);a.wb(b.qb(),this,!0)}};var ob;
ob=function(a,b,c,d,e){this.g=a;this.pi=null;b=this.h(b);e?c=b:(this.pe=new pb,c=this.h(c));if(b.width!==c.width||b.height!==c.height)throw Error("Expected two canvasses of the same size");D.NE(b,c);this.La=this.Bk(b);this.Rb=this.Bk(c);this.EM=Ka.Tj(this.g.sg,"WorkaroundDisableDPRBasedZoom",!1);this.DM=Ka.Tj(this.g.sg,"WorkaroundAnisoAddWidthPixel",!1);this.CM=Ka.Tj(this.g.sg,"WorkaroundAnisoAddHeightPixel",!1);d&&(this.Wt()||this.m(),this.Mt(1));this.on=new sb;this.ar=D.af();this.pn=new tb(this.Rb);
this.Rf=new tb(this.La);this.oi=new ub;this.Bs=this.Cs=null;this.wh=!1;this.cg=new vb;this.Hk=new xb(this.g);this.qo=new yb(this);this.Xs=new zb(this);this.Rq=!1;this.LH=new Ab(a);this.dh=0;this.bj=this.jo=1;this.jl=null;this.yn=!1};
ob.prototype={Jf:function(){return new Bb(0,0,this.La.canvas.width,this.La.canvas.height)},Hl:function(){return null!==this.pi?this.pi:this.Rb},xg:function(){return this.g.pa?this.La:this.Rb},Zd:function(){return 0!==this.dh},hC:function(){return 2===this.dh},YQ:function(){this.dh=0},WQ:function(){this.dh=1},XQ:function(){this.dh=2},PR:function(a){this.jo=a},QR:function(a){this.bj=a},OR:function(a){this.jl=a},gi:function(a){return new Bb(this.wm(a.u),this.xm(a.v),this.wm(a.V),this.xm(a.ca))},wF:function(a){var b;
for(b=0;b<a.length;++b)a[b].X=this.wm(a[b].X),a[b].Y=this.xm(a[b].Y);return a},wm:function(a){a*=this.jo;2==this.dh&&null!==this.jl&&(a+=this.jl.u);return Math.round(a)},xm:function(a){a*=this.bj;2==this.dh&&null!==this.jl&&(a+=this.jl.v);return Math.round(a)},clear:function(a){"undefined"===typeof a&&(a="#ffffff");this.g.ed&&this.g.ed.tu();this.g.Nm&&this.g.Nm.tu();this.Rb.clearRect(0,0,this.Rb.canvas.width,this.Rb.canvas.height);this.La.fillStyle=a;this.La.fillRect(0,0,this.La.canvas.width,this.La.canvas.height)},
pj:function(){var a=J.Hp(this.La.canvas);return new I(a.u,a.v)},getContext:function(){if(null!==this.pi)return this.pi;if(this.g.pa){var a=this.g.ba().wa();var b=this.wh?null!==a?a.U():this.La:null!==a?a.U():this.Rb;a=this.getState();this.oi.Qc()?a.Oh(b):b=a.Ba;return b}a=null;b=this.pe.lt();-1!==b&&(a=this.pe.sp(b));return this.wh?null!==a?a.La:this.La:null!==a?a.Sm:this.Rb},Oh:function(a){this.pi=a.getContext("2d");this.Rf=new tb(this.pi)},vt:function(){if(this.g.pa){var a=this.g.ba().wa();if(null!==
a){a.vt();return}}a=this.getContext();a.clearRect(0,0,a.canvas.width,a.canvas.height)},getState:function(){if(this.g.pa)return this.oi.before()&&this.Cs?this.Cs:this.oi.after()&&this.Bs?this.Bs:this.Rf;var a=null;var b=this.pe.lt();-1!==b&&(a=this.pe.sp(b));return this.wh?null!==a?a.Rf:this.Rf:null!==a?a.tG:this.pn},NC:function(){this.wh=!0;this.g.pa&&(this.Rf.Oh(this.La),this.Rf.apply())},XP:function(){this.wh=!1;this.g.pa&&(this.pn.Oh(this.Rb),this.pn.apply())},PA:function(){this.Rq=!0},Oo:function(a,
b,c){this.g.rb.fS(ra.bq);this.on.clear();this.Rb.save();this.pn.Oh(this.Rb);this.Rf.Oh(this.La);var d=this.$K(a,c);c=!1;var e=this;this.yn=!1;for(a=0;a<d.length;++a)d[a]instanceof Cb&&!d[a].YB(this.Hk,this.cg)&&(c=!0),d[a]instanceof Fb&&!this.g.pa&&d[a].j(this);this.JG()?(c?(N.m("Waiting for image(s) to load"),this.Hk.WM(function(){N.m("Loading image(s) finished so continue with drawing");e.yn=!0;e.wx(d,b)})):(this.yn=!0,this.wx(d,b)),null!==this.g.qa&&this.g.qa.g.N.Pi&&this.SH()):b()},jP:function(){this.ar=
D.af();(new Gb).xA("DevicePixelRatioChanged","true")},Wt:function(){return(new Gb).UB("DevicePixelRatioChanged")},m:function(){var a=D.af();(new Gb).xA("OriginalDevicePixelRatio",a)},hO:function(){var a=new Gb;return parseFloat(a.$o("OriginalDevicePixelRatio"))},Hq:function(a){this.La.canvas.width=this.Rb.canvas.width=a.L;this.La.canvas.height=this.Rb.canvas.height=a.aa;var b=this.g.Za();null!==b&&(b.style.height=a.aa+"px",b.style.width=a.L+"px",this.g.Oc||(b.style.overflow="hidden"))},sx:function(){return new Ja(document.documentElement.clientWidth,
document.documentElement.clientHeight)},$I:function(a,b,c){return 0<a.L-b.L?a.L-b.L:0<c.L-b.L?c.L-b.L:0},fJ:function(a,b,c){return 0<a.aa-b.aa?a.aa-b.aa:0<c.aa-b.aa?c.aa-b.aa:0},dG:function(a,b){var c=!1;var d=new Ja(window.innerWidth,window.innerHeight);var e=this.$I(a,b,d);a=this.fJ(a,b,d);if(D.Wp()){var f=window.visualViewport;b.L=Math.floor(f.width);b.aa=Math.floor(f.height)}0<e&&(b.L=D.Wp()?Math.floor(f.width)+e:b.L-.5+e,this.DM&&(b.L+=1),c=!0);0<a&&(b.aa=D.Wp()?Math.floor(f.height)+a:b.aa-.5+
a,this.CM&&(b.aa+=1),c=!0);return c},Mt:function(a){this.EM?a=1:this.Wt()&&(a=this.oI());try{var b=this.sx();this.Hq(b.scale(a));var c=this.sx();(this.dG(b,c)||c.L>b.L||c.aa>b.aa)&&this.Hq(c.scale(a))}catch(d){N.warn("Exception during resizing canvasses: "+d),this.Hq((new Ja(window.innerWidth,window.innerHeight)).scale(a))}},aR:function(a,b,c){c?(this.oi.FR(),this.Cs=this.Zz(a,"cdsClip_before_canvas",b)):(this.oi.ER(),this.Bs=this.Zz(a,"cdsClip_after_canvas",b))},Zz:function(a,b,c){a=J.xa(a.O(),b);
if(null===a)return null;a=this.Bk(a);a=new tb(a);a.LS=c;a.HR();return a},PC:function(){this.oi.aQ()},wx:function(a,b){this.Rq&&(this.g.OA(),this.Rq=!1);var c,d=this;if(this.g.Tb.Rp){for(c=0;c<a.length;++c){var e=a[c];(e instanceof Hb||e instanceof Ib||e instanceof Jb)&&e.j(this)}for(c=0;c<a.length;++c)e=a[c];this.Rb.restore()}else if(this.g.pa){for(c=0;c<a.length;++c)a[c]instanceof Kb&&a[c].j(this);this.on.DA(this.Rb);for(c=0;c<a.length;++c)e=a[c],e instanceof Kb||a[c].j(this);this.Rb.restore()}else{var f=
[];for(c=0;c<a.length;++c)e=a[c],e instanceof Kb?e.j(this):e instanceof Lb&&f.push(e);this.on.DA(this.Rb);for(c=0;c<a.length;++c)e=a[c],e instanceof Kb||e instanceof Lb||e instanceof Fb||a[c].j(this);this.Rb.restore();for(c=0;c<f.length;++c)f[c].j(this)}this.LH.mj();this.g.yl(function(){d.rI()});this.qI();this.g.rb.LN(0===a.length,ra.bq);b()},rI:function(){var a=this.g.aO();0!==a.length&&setTimeout(function(){window.requestAnimationFrame(function(){a.forEach(function(b){b()})})})},qI:function(){var a=
this.g.XN();0!==a.length&&window.requestAnimationFrame(function(){a.forEach(function(b){b()})})},JG:function(){return null===this.g.qa||this.g.qa.g.N.Pi||!this.g.qa.g.N.ep()},$K:function(a,b){var c=[],d;if(0<a.ah){var e=Mb.D(a.Wd().Wd(),this.g.A.Fa,this.g.getConfiguration().yg());e=new Nb(e);for(d=0;d<a.ah;++d)if(e.ga()<e.size()-4){var f=e.ga(),g=e.getUint32(),k=e.getUint32();var l=Ob.KD(k,e,g,this);if(void 0!==b&&null!==b)if(k=b(l),void 0!==k&&null!==k)for(l=0;l<k.length;l++)c.push(k[l]);else c.push(l);
else c.push(l);e.seek(f+g)}}else c=[];return c},h:function(a){var b=window.document.getElementById(a);if(null===b)throw Error("Canvas "+a+" does not exist");return b},Bk:function(a){a=a.getContext("2d");if(null===a)throw Error("Creating graphics context failed");return a},SH:function(){var a,b=this.g.qa;if(null!==b)for(a=0;a<b.ya.R.length;++a){var c=b.ya.uc(a);if(null!==c.info().vu(0)){var d=b.Od;if(null!==d){var e=this.xg();e.save();d.np(this,c);e.restore()}}}},oI:function(){return(new Gb).UB("OriginalDevicePixelRatio")?
D.af()/this.hO():D.af()}};var Pb;Pb=function(a,b,c){this.Qi=!1;this.Sm=a;this.La=b;this.tG=new tb(this.Sm);this.Rf=new tb(this.La);this.cj=c};Pb.prototype={jR:function(a){this.Qi=a},size:function(){return this.cj}};var tb;tb=function(a){this.Ki=null;this.hn="#ffffff";this.iy=!1;this.Kn="#000000";this.Oi=!1;this.Qe=.5;this.hA="#000000";this.Ke="12px Arial";this.Gi=12;a.font=this.Ke;this.Ba=a;this.ly=this.ky=-1;this.ys=new I(0,0);this.ts=new I(0,0)};
tb.prototype={HR:function(){this.Oh(this.Ba)},Oh:function(a){null!==a&&void 0!==a&&(this.Ba=a,this.apply(),this.zw())},Eu:function(a,b){this.hn=a;this.iy=b;this.Ba.fillStyle=this.hn},Hu:function(a,b,c,d,e,f){this.Qe=a;this.Kn=b;this.wf=c;this.ff=d;this.gf=e;this.Of=f;this.Ba.strokeStyle=this.Kn;this.Ba.lineWidth=Math.max(1,this.Qe);this.Ba.lineCap=this.ff;this.Ba.lineJoin=this.gf;this.Ba.miterLimit=this.Of;"function"===typeof this.Ba.setLineDash?(this.Oi=!1,this.zw()):this.Oi=5===this.wf},NR:function(a,
b){if("number"!==typeof a)throw new TypeError("Expected numeric value");if("number"!==typeof b)throw new TypeError("Expected numeric value");this.ky=a;this.ly=b},oD:function(a,b,c){this.Ke=a;this.Gi=b;this.hA=c},apply:function(){this.Ba.fillStyle!==this.hn&&(this.Ba.fillStyle=this.hn);this.Ba.strokeStyle!==this.Kn&&(this.Ba.strokeStyle=this.Kn);this.Ba.lineWidth!==this.Qe&&(this.Ba.lineWidth=this.Qe);this.Ba.lineCap!==this.ff&&(this.Ba.lineCap=this.ff);this.Ba.lineJoin!==this.gf&&(this.Ba.lineJoin=
this.gf);this.Ba.miterLimit!==this.Of&&(this.Ba.miterLimit=this.Of)},sj:function(){return this.Ke},Yt:function(){return null===this.Ki?this.iy:this.Ki.xr},zg:function(){return null!==this.Ki},dR:function(a){this.Ki=a},Xl:function(){this.Ki=null;this.apply()},Co:function(a){this.Ba.fillStyle=this.Ki.bO(this.Ba,a)},cD:function(a){this.Gi=a},Lg:function(a){this.Ke=a},zw:function(){"function"===typeof this.Ba.setLineDash&&(0===this.wf&&this.Ba.setLineDash([]),1===this.wf&&this.Ba.setLineDash([8,3]),2===
this.wf&&this.Ba.setLineDash([3,3]),3===this.wf&&this.Ba.setLineDash([8,3,3,3]),4===this.wf&&this.Ba.setLineDash([8,3,3,3,3,3]),5===this.wf&&(this.Oi=!0,this.Ba.setLineDash([0,0])))}};var pb;pb=function(){this.ll=[];this.dk=[]};pb.prototype={sp:function(a){return this.ll.length>a?this.ll[a]:null},OM:function(a,b){this.ll[a]=b},WP:function(a){this.ll.length>a&&(this.ll[a]=null)},lt:function(){return 0<this.dk.length?this.dk[this.dk.length-1]:-1},zP:function(a){this.dk.push(a)},vP:function(){return this.dk.pop()}};
var Qb;Qb=function(a,b,c,d,e,f){try{this.h(a,b,c,d,e,f)}catch(g){throw Error("Could not initialize the tooltip style. Error: "+g);}};Qb.prototype={h:function(a,b,c,d,e,f){this.Font=new Sa(b+"px "+a);this.yv=R.$a(c);this.Pj=d;this.dv=R.$a(e);this.wv=R.$a(f)}};var Rb;Rb=function(){};Rb.h="4.8.0.0";Rb.m=Rb.h;var Webvisu;
Webvisu=function(a,b,c,d,e,f){"undefined"===typeof f&&(f=!1);this.sg=Ka.uF();this.AJ();N.info("Webvisualization starting");N.info("Version: "+Rb.m);this.WG();this.an=this.qg=this.He=this.Le=this.N=this.qa=this.oc=null;this.pa=d;this.Yh=!1;void 0!==e&&e?(this.lb=new Configuration,this.Oc=this.Yh=this.lb.SemiTransparencyActive=!0):this.DJ(a,b,c,d,f)};window.Webvisu=Webvisu;
Webvisu.prototype={ba:function(){return this.ed.isActive()?this.ed:this.Nm},openDialog:function(a,b){this.ed.LM(a,b)},sc:function(){return this.NI},Za:function(){return this.yc},jN:function(a){this.ed.RP(a)},eS:function(a){this.ed.AP(a)},JN:function(){return this.ed.wP()},XC:function(a){this.Qx=a},nR:function(a){this.Gy=a},DJ:function(a,b,c,d,e){this.nr=[];this.cr=[];this.yc=J.Za();this.he=new Sb(this);this.Es();this.so=new Tb;this.Zc=new Ub(this);this.gb=new ob(this,a,b,c,d);this.Er();this.Ow=new ta(this);
new bb(this);this.On=new cb(this);this.Bi=new Vb(this);this.NI=new Wb;this.Nm=Xb.UD(this.Ow.XA(Yb.TF));this.ed=Xb.MD(this.Ow.XA(Yb.XD));this.fc=new ac(this);this.rb=new bc(this);this.BJ(this.gb.xg().canvas.id);this.Vp=new $a;this.Tb=new cc;this.Di=new dc(this);this.Lx=new ec(this);a=this.WN();this.dj=null;this.zb=new fc(new Configuration);this.Oc||e||(0<a?this.nl("Loading Webvisualization (delayed)"):this.nl("Loading Webvisualization"));this.bn=null;this.Qx=!0;this.Gy="";this.nb=-1;this.Dw=new gc;
0<a&&null!==this.dj?this.I(new hc(this),a):(this.cd=new hc(this),this.Kx())},Kx:function(){var a=this.cd;null!==this.bn&&(null!==this.Bb&&this.Bb.push(this.bn),this.bn=null);this.cd=null;try{a.j()}catch(b){this.error("Unexpected Exception: "+b)}},Es:function(){this.Bb=this.lb=this.i=this.A=null;this.zz=!1;null!==this.qa&&(this.qa.pb(),this.qa=null);this.he.$t()&&this.he.close();null!==this.oc&&this.oc.detach();WebvisuExtensionMgr.zN()},Er:function(){var a=this;window.addEventListener("unload",function(b){a.wK(b)},
!1)},BJ:function(a){window.WebvisuAutotestInst=new WebvisuAutotest(this,a);window.WebvisuAutotest_raiseMouse=window.WebvisuAutotestInst.raiseMouse;window.WebvisuAutotest_raiseKey=window.WebvisuAutotestInst.raiseKey;window.WebvisuExtensionMgr=WebvisuExtensionMgr;WebvisuExtensionMgr.zR(this.pa);window.WebvisuExtensionMgr_register=window.WebvisuExtensionMgr.register;window.WebvisuExtensionMgr_openControlRelative=window.WebvisuExtensionMgr.openControlRelative;window.WebvisuInst=this},yl:function(a){this.cr.push(a)},
XN:function(){var a=this.cr;this.cr=[];return a},wo:function(a){this.nr.push(a)},aO:function(){var a=this.nr;this.nr=[];return a},AJ:function(){var a=Ka.pm(this.sg,"CFG_LogLevel");"TRACE"===a?N.J(ic.rq):"DEBUG"===a?N.J(ic.Np):N.J(ic.km)},nl:function(a,b){var c=0,d=!1;null!==this.dj&&this.OA();"boolean"===typeof b&&(d=b);if(d||!this.gO()){""!==this.NB()&&(c=5E3);b=this.Oc;if("The maximum number of visualization clients is already connected. Please try again later."===a||"Not enough memory in the PLC to create the client."===
a)b=!0;this.dj=new kc(a,this.gb,b,c)}},OA:function(){null!==this.dj&&this.dj.close();this.dj=null},eb:function(){return new lc(this)},ob:function(a){a=void 0!==a?a:this.A;var b=null;"utf-8"===this.getConfiguration().ANSIStringEncoding&&(b=this.getConfiguration().td());return null===a?new mc(!0,Ua.xa,5E4,b):new mc(a.Fa,a.Th,a.CommBufferSize,b)},setConfiguration:function(a){this.Yh||("TRACE"===a.LogLevel?N.J(ic.rq):"DEBUG"===a.LogLevel?N.J(ic.Np):"INFO"===a.LogLevel?N.J(ic.km):"WARNING"===a.LogLevel?
N.J(ic.nw):"ERROR"===a.LogLevel?N.J(ic.uv):"FATAL"===a.LogLevel?N.J(ic.fE):N.warn("Unexpected loglevel: "+a.LogLevel),this.lb=a,this.zb=new fc(a),this.He=new nc(this),this.lb.TouchHandlingActive&&(this.qg=new oc,this.Le=new pc(this.getConfiguration()),this.qa=new qc(this,new rc(this)),this.N=new sc),this.On.ZR(this.lb.HandleTouchEvents||this.lb.TouchHandlingActive),(this.lb.BestFit||this.lb.HandleTouchEvents||this.lb.TouchHandlingActive)&&!this.lb.WorkaroundDisableResizeHandling&&(null===this.oc&&
(this.oc=new tc(this)),this.oc.TR(this.lb.HandleTouchEvents||this.lb.TouchHandlingActive),this.oc.Bl()),this.pa&&this.lb.BestFit&&(this.Za().style.overflow="hidden"),this.Oc&&(this.Vp.ProgrammingSystemModeErrorText=a.ProgrammingSystemModeErrorText,this.Vp.ProgrammingSystemModeWaitingText=a.ProgrammingSystemModeWaitingText,this.nl(this.lb.ProgrammingSystemModeWaitingText)))},bf:function(){null!==this.oc&&this.oc.bf()},getConfiguration:function(){return this.lb},lD:function(a){!window.btoa&&a&&(N.warn("POST data in header should be done but is not supported by the browser"),
a=!1);this.zz=a},GQ:function(a){this.A=a},Kj:function(a){null===a?this.i=null:this.i=a},NB:function(){var a=location.hash;var b="";""!==a&&(b=a.split("CKT=").pop().split("#")[0]);return b},gO:function(){var a=location.search;return""!==a&&D.xb(a,Wa.h)?!0:!1},WN:function(){var a=location.search;var b=0;""!==a&&(a=a.split("CFG_DelayedStart=").pop().split("?")[0],b=parseInt(a,10));return b},St:function(){var a=location.search;var b="";""!==a&&(b=a.split("CFG_Lang=").pop().split("?")[0],b=b.split("&")[0]);
return b},FB:function(){var a=location.search;return""!==a&&D.xb(a,"BRLG")?!0:!1},cO:function(){var a=location.search;return""!==a&&D.xb(a,"RLLG")?!0:!1},LC:function(){var a=location.href;if(!D.xb(a,Wa.h)){var b=D.xb(a,"?")?"&":"?";a+=b+Wa.h}location.assign(a)},KC:function(a,b,c){var d=location.href,e,f="";if(D.xb(d,"CFG_Lang")){for(b=e=d.indexOf("CFG_Lang");"&"!==d.charAt(e)&&e<d.length;)e++;b=d.substring(b,e);""!==a&&(f="CFG_Lang="+a);d=d.replace(b,f);D.xb(d,Wa.h)||""===a||(d+="&"+Wa.h)}else""!==
a&&(f=D.xb(d,"?")?"&":"?",d+=f+"CFG_Lang="+a,b&&(d+="&BRLG"),D.xb(d,Wa.h)||(d+="&"+Wa.h));c&&(f="&BRLG",D.xb(d,f)&&(d=d.replace(f,"")));D.xb(d,"RLLG")||(d+="&RLLG");location.assign(d)},fp:function(){return this.cd instanceof uc},I:function(a,b){if(null!==this.cd&&void 0!==this.cd){var c="function"===typeof this.cd.className?this.cd.className():"unknown",d="function"===typeof a.className?a.className():"unknown";N.warn("WebVisu.setFollowUpState called while former state not yet processed! Src: "+c+
" Dest: "+d)}this.cd=a;0>=b&&(b=0);this.Ns(b)},RQ:function(a){this.bn=a},ML:function(a){this.cd=a},U:function(){return this.gb},error:function(a,b){if(!this.Yh){this.Oc||N.error(a);var c=null!==this.lb?this.lb.ErrorReconnectTime:1E4;N.info("Will restart in "+c+"ms");null!==this.A&&(this.an=new vc(this.A,this.lb));this.Es();this.lL();if(this.Oc){var d=this.Vp.ProgrammingSystemModeErrorText;window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess.errorOccurred(d,a)}else d="An error happened; will automatically restart";
if("The maximum number of visualization clients is already connected. Please try again later."===a||"Not enough memory in the PLC to create the client."===a)d=a;this.nl(d,b);this.I(new wc(this),c)}},XO:function(){this.Uu("The webvisualization license expired.","License Expired")},Uu:function(a,b){this.Yh||(N.warn(a+" Webvisualization is stopped"),this.nl(b),this.Es(),this.ML(new wc(this)))},QQ:function(a){this.Bb=a},Ns:function(a){var b=this;this.nb=window.setTimeout(function(){b.Kx()},a)},rd:function(a){null!==
this.Bb&&(this.Bb.push(a),null!==this.cd&&this.cd.qt()&&(clearTimeout(this.nb),this.Ns(0)))},pE:function(){return""!==this.getConfiguration().LoginVisu.toLowerCase()},wK:function(){if(!this.Oc){var a=this.A;null===a&&null!==this.an&&this.an.iS()&&(a=this.an.ri);null!==a&&a.la!==Ua.m&&a.Th!==Ua.xa&&(new lb(this,a)).mQ()}},lL:function(){var a=this.gb.Hl(),b;for(b=0;20>b;++b)a.restore()},WG:function(){Ka.Tj(this.sg,"ProgrammingSystemMode",!1)?(this.Oc=!0,Ka.Tj(this.sg,"ProgrammingSystemModeCefSharp",
!1)&&CefSharp.BindObjectAsync("ProgrammingSystemAccess")):this.Oc=!1},changeUpdateRate:function(a){null!==this.lb&&(a<this.lb.UpdateRate&&null!==this.cd&&(clearTimeout(this.nb),this.Ns(0)),this.lb.UpdateRate=a)}};var WebvisuAutotest;WebvisuAutotest=function(a,b){this.g=a;this.LG=b;this.Ur=this.Tr=0};
WebvisuAutotest.prototype={raiseMouse:function(a,b,c){var d=window.document.elementFromPoint(b,c);this.Tr=b;this.Ur=c;var e={bubbles:!0,cancelable:"mousemove"!==a,view:window,detail:0,screenX:b,screenY:c,clientX:b,clientY:c,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:d};if(D.Qb()){a=this.wD(a);var f={};this.ZB(f,e,d);f.pointerType="mouse";f=new PointerEvent(a,f)}else f=window.document.createEvent("MouseEvents"),f.initMouseEvent(a,e.bubbles,e.cancelable,e.view,e.detail,e.screenX,
e.screenY,e.clientX,e.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,e.button,d);this.fB(f,b,c,d);!J.J(this.g)||"mouseup"!==a&&"pointerup"!==a||(a=new MouseEvent("click"),d.dispatchEvent(a))},raiseTouch:function(a,b,c,d){var e=window.document.elementFromPoint(b,c);d={bubbles:!0,cancelable:"touchmove"!==a,view:window,detail:0,screenX:b,screenY:c,clientX:b,clientY:c,pointerId:d,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:e};a=this.wD(a);var f={};this.ZB(f,d,e);f.pointerId=d.pointerId;
f.pointerType="touch";a=new PointerEvent(a,f);this.fB(a,b,c,e)},ZB:function(a,b,c){a.isPrimary=!0;a.bubbles=b.bubbles;a.cancelable=b.cancelable;a.view=b.view;a.detail=b.detail;a.screenX=b.screenX;a.clientX=b.clientX;a.screenY=b.screenY;a.clientY=b.clientY;a.ctrlKey=b.ctrlKey;a.altKey=b.altKey;a.shiftKey=b.shiftKey;a.metaKey=b.metaKey;a.button=b.button;a.relatedTarget=c},fB:function(a,b,c,d){Object.defineProperty(a,"layerX",{value:b});Object.defineProperty(a,"layerY",{value:c});a.button=1;a.which=
1;d.dispatchEvent(a)},wD:function(a){switch(a){case "touchmove":case "mousemove":return"pointermove";case "touchup":case "mouseup":return"pointerup";case "touchdown":case "mousedown":return"pointerdown"}},raiseKey:function(a,b,c,d,e){var f=this.g.he.Vb();null===f&&J.J(this.g)&&(f=window.document.elementFromPoint(this.Tr,this.Ur));if(J.J(this.g)&&9===b&&"keydown"===a){var g=f.tabIndex,k=c?-1:1,l=this;document.querySelectorAll("input, button").forEach(function(G){if(G.tabIndex===g+k){var u=G.getBoundingClientRect();
l.Tr=u.x+u.width/2;l.Ur=u.y+u.height/2;G.focus()}})}else null!==f?this.Kr(b)?this.Hz(f,a,b,c,d,e,!0):this.XK(f,b,a,c):this.Hz(window.document.getElementById(this.LG),a,b,c,d,e,!1)},Kr:function(a){return 13===a||27===a||37===a||38===a||39===a||40===a},XK:function(a,b,c,d){if("keypress"===c){c=a.selectionStart;var e=a.selectionEnd;b=String.fromCharCode(b);d||(b=b.toLowerCase());void 0===a.value&&(a.value="");a.value=a.value.substr(0,c)+b+a.value.substr(e);c===e&&this.QI(a);this.IL(a,c+1)}},IL:function(a,
b){a.setSelectionRange?(a.focus(),a.setSelectionRange(b,b)):a.createTextRange&&(a=a.createTextRange(),a.collapse(!0),a.moveEnd("character",b),a.moveStart("character",b),a.select())},QI:function(a){var b=0;if(document.selection)a.focus(),b=document.selection.createRange(),b.moveStart("character",-a.value.length),b=b.text.length;else if(a.selectionStart||"0"===a.selectionStart)b=a.selectionStart;return b},UJ:function(a,b){return b||this.Kr(a)?a:String.fromCharCode(a).toLowerCase().charCodeAt(0)&255},
Hz:function(a,b,c,d,e,f,g){var k,l,G=c;"keypress"===b&&(G=this.UJ(c,d));if(void 0!==window.document.createEventObject)c=document.createEvent("Events"),c.initEvent(b,!0,!0),c.which=G,c.keyCode=G,c.shiftKey=d,c.ctrlKey=f,c.altKey=e,c.metaKey=!1;else{var u=l=k=G;c=window.document.createEvent("KeyboardEvent");void 0===c.initKeyboardEvent?c.initKeyEvent(b,!0,!0,null,f,e,d,!1,k,l,u,a):c.initKeyboardEvent(b,!0,!0,null,f,e,d,!1,k,l,u,a);delete c.keyCode;Object.defineProperty(c,"keyCode",{value:G});delete c.charCode;
Object.defineProperty(c,"charCode",{value:0});delete c.shiftKey;Object.defineProperty(c,"shiftKey",{value:d});delete c.ctrlKey;Object.defineProperty(c,"ctrlKey",{value:f});delete c.altKey;Object.defineProperty(c,"altKey",{value:e});delete c.metaKey;Object.defineProperty(c,"metaKey",{value:!1});delete c.which;d=G;if("keypress"===b&&this.Kr(G)&&13!==G||g)d=0;Object.defineProperty(c,"which",{value:d});delete c.target;Object.defineProperty(c,"target",{value:a})}a.dispatchEvent(c)}};var WebvisuExtensionMgr;
(function(){var a=function(){this.hr=[];this.ki={}};a.prototype={register:function(b){if(null===b)throw Error("null value not expected");if("function"!==typeof b.instantiateIf)throw Error("function instantiateIf of extensionFactory expected");this.hr.push(b)},zR:function(b){this.pa=b},openControlRelative:function(b,c,d,e,f,g){if(null===b)throw Error("null value not expected");if("number"!==typeof c)throw new TypeError("Expected numeric value");if("number"!==typeof d)throw new TypeError("Expected numeric value");
if("number"!==typeof e)throw new TypeError("Expected numeric value");if("number"!==typeof f)throw new TypeError("Expected numeric value");if(null===g)throw Error("null value not expected");c=new Bb(c,d,c+e,d+f);d=J.Hp(g);c=c.Mb(d.u,d.v);this.pa?g.appendChild(b):(J.Ya(b,c),b.style.zIndex=300,g.parentNode.appendChild(b));g.vv=b},rS:function(b){var c;for(c=0;c<this.hr.length;++c){var d=this.hr[c].instantiateIf(b);if(null!==d&&void 0!==d){if(this.yM(d))return d;break}}return null},zN:function(){var b;
for(b=0;b<this.ki.length;++b)this.ki[b]&&this.Ht(b);this.ki=[]},pN:function(b,c,d,e){b.create(d.u,d.v,d.C(),d.B(),e);this.ki[c]=b},Ht:function(b){var c=this.un(b);null!==c&&(c.destroy(),delete this.ki[b])},oN:function(b,c){b=this.un(b);null!==b&&b.setVisibility(c)},nN:function(b,c){b=this.un(b);null!==b&&b.move(c.u,c.v,c.C(),c.B())},mN:function(b,c,d){b=this.un(b);return null===b?null:b.invoke(c,d)},un:function(b){var c=this.ki[b];return c?c:(N.warn("Not existing extension with id "+b+" accessed; ignored"),
null)},yM:function(b){return this.jk(b,"create")&&this.jk(b,"setVisibility")&&this.jk(b,"move")&&this.jk(b,"invoke")&&this.jk(b,"destroy")?!0:!1},jk:function(b,c){return"function"!==typeof b[c]?(N.warn("Extension object is missing an implementation of '"+c+"'"),!1):!0}};WebvisuExtensionMgr=new a})();var Ga;Ga=function(a){void 0===a&&(a=10);this.ma=new ArrayBuffer(a);this.Dd=new Uint8Array(this.ma);this.cb=0};Ga.D=function(a){return D.bk()?new Ha:new Ga(a)};
Ga.prototype={mL:function(){this.Oz(this.kK(this.ma.byteLength))},Oz:function(a){var b=this.Dd;this.ma=new ArrayBuffer(a);this.Dd=new Uint8Array(this.ma);for(a=0;a<this.cb;++a)this.Dd[a]=b[a]},kK:function(a){return 500>a?2*a:Math.floor(1.3*a)},lo:function(a,b){this.Dd[a]=b},OC:function(a){a>this.ma.byteLength&&this.Oz(a)},yo:function(a){this.cb>=this.ma.byteLength&&this.mL();var b=this.cb;this.cb++;this.lo(b,a)},Bo:function(a,b,c){var d=new Uint8Array(a);this.OC(this.size()+c);if(200<c&&0===b%4&&
0===this.cb%4&&!D.lq()){var e=Math.floor(c/4);var f=Math.floor(this.cb/4);a=new Uint32Array(a,4*Math.floor(b/4),e);var g=new Uint32Array(this.ma,4*f,e),k=c-4*e;for(f=0;f<e;++f)g[f]=a[f];for(f=0;f<k;++f)this.Dd[this.cb+f+4*e]=d[b+f+4*e]}else if(d.slice)this.Dd.set(d.slice(b,b+c),this.cb);else for(f=0;f<c;++f)this.Dd[this.cb+f]=d[b+f];this.cb+=c},Bu:function(a,b){this.lo(a,b)},vB:function(a){return this.Dd[a]},size:function(){return this.cb},Wd:function(){var a=new ArrayBuffer(this.cb),b=new Uint8Array(this.ma),
c=new Uint8Array(a);if(b.slice)c.set(b.slice(0,this.cb),0);else{var d;for(d=0;d<this.cb;++d)c[d]=b[d]}return a}};var Ha;
(function(){function a(b){return String.fromCharCode((b>>4)+65)+String.fromCharCode((b&15)+65)}Ha=function(){this.ma="";this.cb=0};Ha.prototype={lo:function(b,c){var d=null,e=null;0<b&&(d=this.ma.substr(0,2*b));b<this.cb-1&&(e=this.ma.substr(2*b+2,this.ma.length-2*b-2));b="";null!==d&&(b=d);b=b.concat(a(c));null!==e&&(b=b.concat(e));this.ma=b},OC:function(){},yo:function(b){this.ma=this.ma.concat(a(b));this.cb++},UM:function(b){var c="",d;for(d=0;d<b.length;++d)c=c.concat(a(b.charCodeAt(d)));this.ma=
this.ma.concat(c);this.cb+=c.length/2},Bo:function(b,c,d){this.ma=this.ma.concat(b.substr(2*c,2*d));this.cb+=d},Bu:function(b,c){this.lo(b,c)},vB:function(b){return this.ma.charCodeAt(2*b)-65<<4|this.ma.charCodeAt(2*b+1)-65},size:function(){return this.cb},Wd:function(){return this.ma}}})();var Mb;
(function(){function a(g,k,l){return function(){if(0===this.s%l&&(1===l||this.ha))try{return(new g[k+"Array"](this.ma,this.s,1))[0]}catch(G){}return null}}function b(g,k,l){return function(){var G=this["getOptimized"+k]();null===G&&(G=this["_get"+k]());this.s+=l;return G}}function c(g,k,l){Mb.prototype["getOptimized"+k]=a(this,k,l);Mb.prototype["get"+k]=b(this,k,l)}Mb=function(g,k,l,G,u){if(!(g instanceof ArrayBuffer))throw new TypeError("BinaryReader requires an ArrayBuffer");if(void 0===k)throw Error("Byteorder must be explicitly assigned");
void 0===l&&(l=(new Configuration).yg());void 0===G&&(G=0);void 0===u&&(u=g.byteLength);if(!(l instanceof na))throw new TypeError("BinaryReader requires a WebVisuTextDecoder");if(0>G)throw Error("Invalid start offset");if(0===u||G+u>g.byteLength)throw Error("Valid data range exceeded");this.ha=k;this.Sf=u;this.ma=g;this.s=G;this.Dd=new Uint8Array(this.ma);this.oe=l;this.M=new xc(this,this.ha)};Mb.D=function(g,k,l,G,u){return D.ZD()?new yc(g,k,l,G,u):D.bk()?new zc(g,k,l,G,u):new Mb(g,k,l,G,u)};Mb.prototype=
{xj:function(){return this.ha},Mj:function(){return this.oe},Lj:function(g){this.oe=new na(g)},ja:function(g,k){var l=g*(k?2:1);if(0>g||this.s+l>this.ma.byteLength)throw Error("INDEX_SIZE_ERR: DOM Exception 1");g=this.M.HC(this.ma,this.s,g,l,k,this.oe);this.s+=l;return g},Xe:function(g){return this.M.Xe(g)},qj:function(){return String.fromCharCode(this.getUint8())},If:function(){return this.s>=this.Sf},ga:function(){return this.s},seek:function(g){this.s=g},size:function(){return this.Sf},m:function(){return this.M.bB()},
h:function(){return this.M.aB()},xa:function(){return this.M.dB()},Mf:function(){return this.M.Gt()},J:function(){return this.M.cB()},Uc:function(){return this.M.Ft()},Pb:function(){return this.M.eB()},Ya:function(){return this.M.Xd()},Nf:function(){return this.M.Yd()},Da:function(g){return this.Dd[g]},getUint8:function(){var g=this.Da(this.s);this.s++;return g},oj:function(){return this.ma}};var d={Int8:1,Int16:2,Int32:4,Uint16:2,Uint32:4,Float32:4,Float64:8},e;for(e in d)if(d.hasOwnProperty(e)){c(this,
e,d[e]);var f="_getFloat64";Mb.prototype[f]=Mb.prototype.m;f="_getFloat32";Mb.prototype[f]=Mb.prototype.h;f="_getInt64";Mb.prototype[f]=Mb.prototype.Ya;f="_getUint64";Mb.prototype[f]=Mb.prototype.Nf;f="_getInt32";Mb.prototype[f]=Mb.prototype.xa;f="_getUint32";Mb.prototype[f]=Mb.prototype.Mf;f="_getInt16";Mb.prototype[f]=Mb.prototype.J;f="_getUint16";Mb.prototype[f]=Mb.prototype.Uc;f="_getInt8";Mb.prototype[f]=Mb.prototype.Pb}})();var Nb;Nb=function(a){this.M=a};
Nb.prototype={xj:function(){return this.M.xj()},Mj:function(){return this.M.Mj()},Lj:function(a){this.M.Lj(a)},ja:function(a,b){return this.M.ja(a,b)},Xe:function(a){return this.M.Xe(a)},qj:function(){return this.M.qj()},If:function(){return this.M.If()},ga:function(){return this.M.ga()},seek:function(a){this.M.seek(a)},size:function(){return this.M.size()},getFloat64:function(){this.Ad(8);return this.M.getFloat64()},getFloat32:function(){this.Ad(4);return this.M.getFloat32()},getInt32:function(){this.Ad(4);
return this.M.getInt32()},getUint32:function(){this.Ad(4);return this.M.getUint32()},getInt16:function(){this.Ad(2);return this.M.getInt16()},getUint16:function(){this.Ad(2);return this.M.getUint16()},Yd:function(){this.Ad(8);return this.M.Yd()},Xd:function(){this.Ad(8);return this.M.Xd()},getInt8:function(){return this.M.getInt8()},getUint8:function(){return this.M.getUint8()},Da:function(a){return this.M.Da(a)},oj:function(){return this.M.oj()},Ad:function(a){if(8===a||4===a||2===a){var b=this.M.ga();
0!==b%a&&this.M.seek(b+a-b%a)}}};var yc;
yc=function(a,b,c,d,e){if(!(a instanceof ArrayBuffer))throw new TypeError("BinaryReader_DataView requires an ArrayBuffer");if(void 0===b)throw Error("Byteorder must be explicitly assigned");void 0===c&&(c=(new Configuration).yg());void 0===d&&(d=0);void 0===e&&(e=a.byteLength);if(!(c instanceof na))throw new TypeError("BinaryReader_DataView requires a WebVisuTextDecoder");if(0>d)throw Error("Invalid start offset");if(0===e||d+e>a.byteLength)throw Error("Valid data range exceeded");this.ha=b;this.Pd=
new DataView(a,0,e+d);this.Sf=e;this.ma=a;this.s=d;this.oe=c;this.M=new xc(this,this.ha)};
yc.prototype={xj:function(){return this.ha},Mj:function(){return this.oe},Lj:function(a){this.oe=new na(a)},ja:function(a,b){var c=a*(b?2:1);if(0>a||2*(this.s+c)>this.ma.length)throw Error("INDEX_SIZE_ERR: DOM Exception 1");a=this.M.HC(this.ma,this.s,a,c,b,this.oe);this.s+=c;return a},Xe:function(a){return this.M.Xe(a)},qj:function(){return String.fromCharCode(this.getUint8())},If:function(){return this.s>=this.Sf},ga:function(){return this.s},seek:function(a){this.s=a},size:function(){return this.Sf},
getFloat64:function(){var a=this.Pd.getFloat64(this.s,this.ha);this.s+=8;return a},getFloat32:function(){var a=this.Pd.getFloat32(this.s,this.ha);this.s+=4;return a},Xd:function(){if("function"===typeof this.Pd.Xd){var a=this.Pd.Xd(this.s,this.ha);this.s+=8}else a=this.M.Xd();return a},Yd:function(){if("function"===typeof this.Pd.Yd){var a=this.Pd.Yd(this.s,this.ha);this.s+=8}else a=this.M.Yd();return a},getInt32:function(){var a=this.Pd.getInt32(this.s,this.ha);this.s+=4;return a},getUint32:function(){var a=
this.Pd.getUint32(this.s,this.ha);this.s+=4;return a},getInt16:function(){var a=this.Pd.getInt16(this.s,this.ha);this.s+=2;return a},getUint16:function(){var a=this.Pd.getUint16(this.s,this.ha);this.s+=2;return a},getInt8:function(){var a=this.Pd.getInt8(this.s);this.s++;return a},getUint8:function(){var a=this.Da(this.s);this.s++;return a},Da:function(a){return this.Pd.getUint8(a)},oj:function(){return this.ma}};var zc;
zc=function(a,b,c,d,e){if("string"!==typeof a)throw new TypeError("BinaryReader_StringBased expects a string");if(void 0===b)throw Error("Byteorder must be explicitly assigned");void 0===c&&(c=(new Configuration).yg());void 0===d&&(d=0);void 0===e&&(e=a.length/2);if(!(c instanceof na))throw new TypeError("BinaryReader requires a WebVisuTextDecoder");if(0>d)throw Error("Invalid start offset");if(0===e||d+e>a.length/2)throw Error("Valid data range exceeded");this.ha=b;this.Sf=e;this.ma=a;this.s=d;this.oe=
c;this.M=new xc(this,b)};
zc.prototype={xj:function(){return this.ha},Mj:function(){return this.oe},Lj:function(a){this.oe=new na(a)},ja:function(a,b){var c=a*(b?2:1);if(0>a||2*(this.s+c)>this.ma.length)throw Error("INDEX_SIZE_ERR: DOM Exception 1");var d=Array(a);if(b){if(this.ha)for(b=0;b<a;++b){var e=2*b+this.s;d[b]=(this.Da(e+1)<<8)+this.Da(e)}else for(b=0;b<a;++b)e=2*b+this.s,d[b]=this.Da(e+1)+(this.Da(e)<<8);a=String.fromCharCode.apply(null,d)}else{for(b=this.s;b<this.s+a;++b)d[b-this.s]=this.Da(b);a=this.oe.yN(d)}this.s+=
c;return a},Xe:function(a){return this.M.Xe(a)},qj:function(){return String.fromCharCode(this.getUint8())},If:function(){return this.s>=this.Sf},ga:function(){return this.s},seek:function(a){this.s=a},size:function(){return this.Sf},getFloat64:function(){var a=this.M.bB();this.s+=8;return a},getFloat32:function(){var a=this.M.aB();this.s+=4;return a},Xd:function(){return this.M.Xd()},Yd:function(){return this.M.Yd()},getInt32:function(){var a=this.M.dB();this.s+=4;return a},getUint32:function(){var a=
this.M.Gt();this.s+=4;return a},getInt16:function(){var a=this.M.cB();this.s+=2;return a},getUint16:function(){var a=this.M.Ft();this.s+=2;return a},getInt8:function(){var a=this.M.eB();this.s++;return a},getUint8:function(){var a=this.Da(this.s);this.s++;return a},Da:function(a){return this.ma.charCodeAt(2*a)-65<<4|this.ma.charCodeAt(2*a+1)-65},oj:function(){return this.ma}};var xc;xc=function(a,b){this.va=a;this.ha=b};
xc.prototype={Xe:function(a){var b=this.va.ga(),c=0;if(a)for(;0!==this.va.getUint16();)c++;else for(;0!==this.va.getUint8();)c++;this.va.seek(b);b=this.va.ja(c,a);a?this.va.getUint16():this.va.getUint8();return b},bB:function(){var a=this.va.ga(),b=this.va.Da(this.Sb(a,0,8)),c=this.va.Da(this.Sb(a,1,8)),d=this.va.Da(this.Sb(a,2,8)),e=this.va.Da(this.Sb(a,3,8)),f=this.va.Da(this.Sb(a,4,8)),g=this.va.Da(this.Sb(a,5,8)),k=this.va.Da(this.Sb(a,6,8)),l=this.va.Da(this.Sb(a,7,8));a=1-2*(b>>7);b=((b<<1&
255)<<3|c>>4)-(Math.pow(2,10)-1);c=(c&15)*Math.pow(2,48)+d*Math.pow(2,40)+e*Math.pow(2,32)+f*Math.pow(2,24)+g*Math.pow(2,16)+k*Math.pow(2,8)+l;return 1024===b?0!==c?NaN:Infinity*a:-1023===b?a*c*Math.pow(2,-1074):a*(1+c*Math.pow(2,-52))*Math.pow(2,b)},aB:function(){var a=this.va.ga(),b=this.va.Da(this.Sb(a,0,4)),c=this.va.Da(this.Sb(a,1,4)),d=this.va.Da(this.Sb(a,2,4)),e=this.va.Da(this.Sb(a,3,4));a=1-2*(b>>7);b=(b<<1&255|c>>7)-127;c=(c&127)<<16|d<<8|e;return 128===b?0!==c?NaN:Infinity*a:-127===b?
a*c*Math.pow(2,-149):a*(1+c*Math.pow(2,-23))*Math.pow(2,b)},dB:function(){var a=this.Gt();return a>Math.pow(2,31)-1?a-Math.pow(2,32):a},Gt:function(){var a=this.va.ga(),b=this.va.Da(this.Sb(a,0,4)),c=this.va.Da(this.Sb(a,1,4)),d=this.va.Da(this.Sb(a,2,4));a=this.va.Da(this.Sb(a,3,4));return b*Math.pow(2,24)+(c<<16)+(d<<8)+a},cB:function(){var a=this.Ft();return a>Math.pow(2,15)-1?a-Math.pow(2,16):a},Ft:function(){var a=this.va.ga(),b=this.va.Da(this.Sb(a,0,2));a=this.va.Da(this.Sb(a,1,2));return(b<<
8)+a},eB:function(){var a=this.va.Da(this.va.ga());return a>Math.pow(2,7)-1?a-Math.pow(2,8):a},HC:function(a,b,c,d,e,f){var g=null;if(e){if(this.ha&&0===b%2)try{g=new Int16Array(a,b,c)}catch(k){}if(null===g)if(g=new Int16Array(Array(c)),b=new Uint8Array(a,b,d),this.ha)for(a=0;a<c;++a)g[a]=(b[2*a+1]<<8)+b[2*a];else for(a=0;a<c;++a)g[a]=b[2*a+1]+(b[2*a]<<8);b=[];for(a=0;a<c;++a)b[a]=g[a];return String.fromCharCode.apply(null,b)}g=new Int8Array(a,b,c);return f.decode(g)},Yd:function(){var a=this.va.getUint32(),
b=this.va.getUint32();return this.ha?a+b*Math.pow(2,32):a*Math.pow(2,32)+b},Xd:function(){var a=this.va.ga(),b=this.va.getUint32(),c=this.va.getUint32();if(this.ha){var d=b;b=c}else d=c;if(0===(b&2147483648))return this.va.seek(a),this.Yd();a=(~d>>>0)+1;d=~b;4294967296<=a&&(a-=4294967296,d+=1);return-1*(a+Math.pow(2,32)*d)},Sb:function(a,b,c){return a+(this.ha?c-b-1:b)}};var Ac;
Ac=function(a,b,c){if(!(a instanceof Ga))throw new TypeError("BinaryWriter expects a BinaryBuffer");if(void 0===b)throw Error("Byteorder must be explicitly assigned");this.bh=a;this.ha=b;this.gd=-1;this.Us=c};Ac.D=function(a,b,c){null===c|void 0===c&&(c=(new Configuration).td());return D.bk()?new Bc(a,b,c):new Ac(a,b,c)};
Ac.prototype={dM:function(a){var b=a.length/2,c;if(1!==b&&2!==b&&4!==b)throw Error("Unexpected size for swapping");for(c=0;c<b;++c){var d=a[c];a[c]=a[a.length-c-1];a[a.length-c-1]=d}},Vg:function(a,b,c){var d=new ArrayBuffer(c);b=new b(d);d=new Uint8Array(d);b[0]=a;this.Eq(d,c)},Eq:function(a,b){var c;1<b&&!this.ha&&this.dM(a,b);for(c=0;c<b;++c)this.xw(a[c])},xw:function(a){-1!==this.gd?(this.bh.Bu(this.gd,a),this.gd++):this.bh.yo(a)},seek:function(a){this.gd=a},ga:function(){return-1!==this.gd?this.gd:
this.bh.size()},zo:function(a){var b=[204,221],c;for(c=0;c<a;++c)this.Ra(b[c%2])},Ra:function(a){this.xw(a)},BA:function(a){this.Vg(a,Int8Array,1)},Kb:function(a){this.Vg(a,Uint16Array,2)},Dc:function(a){this.Vg(a,Int16Array,2)},K:function(a){this.Vg(a,Uint32Array,4)},Sd:function(a){this.Vg(a,Int32Array,4)},Ao:function(a){this.Vg(a,Float32Array,4)},ot:function(a){this.Vg(a,Float64Array,8)},CA:function(a){var b=new ArrayBuffer(8);var c=new Uint8Array(b);b=new Uint32Array(b);b[0]=a&4294967295;b[1]=
a/4294967296;this.Eq(c,8)},AA:function(a){var b=new ArrayBuffer(8);var c=new Uint8Array(b);b=new Uint32Array(b);0<a&&(b[0]=a&4294967295|0,b[1]=a/4294967296|0);if(0>a){var d=~(-a&4294967295|0)+1|0;b[0]=d;b[1]=~(-a/4294967296|0)+!d|0}this.Eq(c,8)},vg:function(a){this.ek(a,!1)},hc:function(a){this.ek(a,!0)},hb:function(a,b){return new Cc(a,b,this.Us)},ek:function(a,b){for(var c,d=a.data(),e=0;e<a.length();++e)c=d[e],a.unicode()?this.Kb(c):this.Ra(c);b&&(a.unicode()?this.Kb(0):this.Ra(0))}};var Bc;
Bc=function(a,b,c){if(!(a instanceof Ha))throw new TypeError("BinaryWriter expects a BinaryBuffer_StringBased");if(void 0===b)throw Error("Byteorder must be explicitly assigned");this.bh=a;this.ha=b;this.gd=-1;this.Us=c};
Bc.prototype={Bd:function(a){if(-1!==this.gd)for(var b=0;b<a.length;++b)this.bh.Bu(this.gd,a.charCodeAt(b)&255),this.gd++;else this.bh.UM(a)},seek:function(a){this.gd=a},ga:function(){return-1!==this.gd?this.gd:this.bh.size()},zo:function(a){var b=[204,221],c;for(c=0;c<a;++c)this.Ra(b[c%2])},Ra:function(a){this.Bd(this.Je(a,8,!1))},BA:function(a){this.Bd(this.Je(a,8,!0))},Kb:function(a){this.Bd(this.Je(a,16,!1))},Dc:function(a){this.Bd(this.Je(a,16,!0))},K:function(a){this.Bd(this.Je(a,32,!1))},Sd:function(a){this.Bd(this.Je(a,
32,!0))},CA:function(a){var b=a/4294967296;this.Bd(this.Je(a&4294967295,32,!1));this.Bd(this.Je(b,32,!1))},AA:function(a){if(0<a){var b=a&4294967295|0;var c=a/4294967296|0}0>a&&(b=c=~(-a&4294967295|0)+1|0,c=~(-a/4294967296|0)+!c|0);this.Bd(this.Je(b,32,!1));this.Bd(this.Je(c,32,!1))},Ao:function(a){this.Bd(this.Gx(a,23,8))},ot:function(a){this.Bd(this.Gx(a,52,11))},vg:function(a){this.ek(a,!1)},hc:function(a){this.ek(a,!0)},hb:function(a,b){return new Cc(a,b,this.Us)},ek:function(a,b){for(var c,d=
a.data(),e=0;e<a.length();++e)c=d[e],a.unicode()?this.Kb(c):this.Ra(c);b&&(a.unicode()?this.Kb(0):this.Ra(0))},Gx:function(a,b,c){var d=Math.pow(2,c-1)-1,e=-d+1,f=e-b,g=parseFloat(a),k=isNaN(g)||-Infinity===g||Infinity===g?g:0,l=0,G=2*d+1+b+3,u=Array(G),ka=0>(g=0!==k?0:g),ja=Math.floor(g=Math.abs(g)),va=g-ja,Xa;for(a=G;a;u[--a]=0);for(a=d+2;ja&&a;u[--a]=ja%2,ja=Math.floor(ja/2));for(a=d+1;0<va&&a;(u[++a]=(1<=(va*=2))-0)&&--va);for(a=-1;++a<G&&!u[a];);if(u[(g=b-1+(a=(l=d+1-a)>=e&&l<=d?a+1:d+1-(l=e-
1)))+1]){if(!(Xa=u[g]))for(va=g+2;!Xa&&va<G;Xa=u[va++]);for(va=g+1;Xa&&0<=--va;(u[va]=!u[va]-0)&&(Xa=0));}for(a=0>a-2?-1:a-3;++a<G&&!u[a];);(l=d+1-a)>=e&&l<=d?++a:l<e&&(l!==d+1-G&&l<f&&this.warn("encodeFloat::float underflow"),a=d+1-(l=e-1));if(ja||0!==k)this.warn(ja?"encodeFloat::float overflow":"encodeFloat::"+k),l=d+1,a=d+2,-Infinity===k?ka=1:isNaN(k)&&(u[a]=1);g=Math.abs(l+d);va=c+1;for(c="";--va;c=g%2+c,g=g>>=1);va=g=0;a=(c=(ka?"1":"0")+c+u.slice(a,a+b).join("")).length;for(b=[];a;va=(va+1)%
8)g+=(1<<va)*c.charAt(--a),7===va&&(b[b.length]=String.fromCharCode(g),g=0);b[b.length]=g?String.fromCharCode(g):"";return(this.ha?b:b.reverse()).join("")},Je:function(a,b,c){var d=[],e=Math.pow(2,b);if(c){if(c=-Math.pow(2,b-1),a>-c-1||a<c)this.tA("encodeInt::overflow"),a=0}else if(a>e||0>a)this.tA("encodeInt::overflow"),a=0;for(0>a&&(a+=e);a;a=Math.floor(a/256))d[d.length]=String.fromCharCode(a%256);for(b=-(-b>>3)-d.length;b;b--)d[d.length]=String.fromCharCode(0);return(this.ha?d:d.reverse()).join("")},
tA:function(a){throw Error(a);}};var Dc;Dc=function(a,b,c){this.M=Mb.D(a,b,c,void 0,void 0)};Dc.prototype={uj:function(){var a=0,b=0;do{var c=this.M.getUint8();a|=(c&127)<<b;b+=7}while(0!==(c&128));return a}};var Ec;Ec=function(a,b,c){this.jf=Ac.D(a,b,c)};
Ec.prototype={G:function(a,b){var c;b=void 0!==b?b:this.HB(a);if(0===b)throw Error("Expected value for MBui greater then zero");var d=a;for(c=0;c<b-1;c++)this.jf.Ra(d&127|128),d>>=7;this.jf.Ra(d&127);if(0!==d>>7)throw Error("Value "+a+" cannot be written as an MBUI with "+b+" bytes");},HB:function(a){var b=0;do a>>=7,b++;while(0<a);return b}};var Fc;Fc=function(a){16<=a&&(a=0);this.li=a};
Fc.prototype={bD:function(a){16<=a&&(a=0);this.li=a},Qc:function(){return 0===this.li},right:function(){return 0!==(this.li&1)},left:function(){return 0!==(this.li&2)},top:function(){return 0!==(this.li&4)},bottom:function(){return 0!==(this.li&8)}};var Xb;Xb=function(){};
Xb.SD=function(a,b,c,d,e,f,g,k){var l=window.document.createElement("div");l.id="cdsClientObject";l.style.position="absolute";if(b)return new Gc(l,new Hc,k,a);if(c)return new Ic(l,new Hc,k,a);var G=c=b=null;e&&(c=new Jc(g));d&&(b=this.Wq());return f?(e&&(G=window.document.createElement("div"),G.id="cdsTouchScrollable",G.style.position="absolute",G.style.cssText+="outline: none; -webkit-tap-highlight-color: transparent;"),new Kc(l,new Hc,k,b,c,new Nc,G,a)):new Oc(l,new Hc,k,b,c,a)};
Xb.LD=function(a,b,c,d){var e=window.document.createElement("div");a=a?window.document.createElement("div"):null;var f=this.Wq(),g=new Jc(!1);e.id="cdsDialog";e.style.position="absolute";e.style.overflow="hidden";e.style.zIndex=Va.Qp;a&&(a.id="cdsModal",a.style.top="0",a.style.left="0",a.style.width="100%",a.style.height="100%",b&&(a.style.backgroundColor="rgb(0,0,0)",a.style.backgroundColor="rgba(0,0,0,0.4)"),a.style.zIndex=Va.Qp,a.style.position="fixed");return new Pc(e,new Hc,f,g,a,b,c,d)};
Xb.UD=function(a){var b=new Jc(!1);b.ae(J.Za());b.Kg(a);return b};Xb.MD=function(a){var b=new Qc;b.ae(J.Za());b.Kg(a);return b};Xb.sv=function(a,b,c){var d=this.Wq(a?Va.xF:Va.RE),e;a&&(d.canvas.id="cdsSelectionCanvas",d.canvas.style.pointerEvents="none");b?e=this.iH():e=null;return new Rc(d,e,c)};
Xb.iH=function(){var a=window.document.createElement("div");a.id="cdsClip";a.style.overflow="hidden";a.style.position="absolute";a.style.top="0 px";a.style.left="0 px";a.style.width="-1 px";a.style.height="-1 px";a.style.touchAction="none";a.style.zIndex=Va.Pp;return a};
Xb.Wq=function(a){var b=window.document.createElement("canvas").getContext("2d");b.canvas.id="cdsCanvas";b.canvas.style.position="absolute";b.canvas.style.width="100%";b.canvas.style.height="100%";b.canvas.style.zIndex=void 0!==a?a:Va.Pp;return b};Xb.QD=function(a,b){return new Sc(a,b)};var Hc;Hc=function(){this.Te=null};Hc.prototype={bD:function(a){this.Te=a},gC:function(){return 0!==(this.Te&1)},QN:function(){return 0!==(this.Te&2)}};var Sc;Sc=function(a,b){this.ya=[];this.qa=null;this.g=b;this.Lu(a)};
Sc.prototype={pb:function(a){var b=this.g.qa;null!==this.ya&&null!==b&&b.uu(a);null!==this.qa&&this.qa.pb()},handleEvent:function(a,b){return null!==this.qa?this.qa.handleEvent(a,b):!1},xl:function(){null!==this.qa&&this.qa.xl()},initialize:function(a,b,c){this.qa=new qc(a,new Tc(a,c,b));a=a.qa;null!==a&&(this.qa.g.N.dD(a.g.N.Ar),this.qa.g.N.xp(a.g.N.Pi));this.Lu(this.ya)},Lu:function(a){this.ya=a;if(null!==this.qa){this.qa.NA();for(a=0;a<this.ya.length;++a)this.qa.xo(this.ya[a]);this.qa.Ab instanceof
Tc&&(a=this.qa.Ab.Jo(),null!==a&&void 0!==a&&a instanceof Nc&&a.zD(this))}},zS:function(a,b,c,d){var e=this.qa.ya.R.length,f,g=this.g.qa,k=null;for(f=0;f<e;++f){var l=this.qa.ya.uc(f);k=l.da;var G=l.info().scroll().Sa();var u=l.info().zoom().Sa();G.Qh(new I(c,d));G.Ph(new I(a,b));u.Ju(1);u.Iu(1);l.$(Uc.hi)||l.kj(Uc.hi)}e=g.ya.R.length;for(f=0;f<e;++f)l=g.ya.uc(f),null!==k&&l.da===k&&(G=l.info().scroll().Sa(),u=l.info().zoom().Sa(),G.Qh(new I(c,d)),G.Ph(new I(a,b)),u.Ju(1),u.Iu(1),l.$(Uc.hi)||l.kj(Uc.hi))}};
var Vc;Vc=function(){};Vc.Ng=function(a,b){var c=new Wc;c.promiseId=a;c.error=b;return c};Vc.RD=function(a,b){var c=new MethodCallMessage;c.methodName=a;c.params=b;return c};Vc.JD=function(a,b,c){var d=new CheckSimpleValueResultMessage;d.promiseId=a;d.result=b;d.value=c;return d};Vc.ID=function(a,b,c,d,e,f,g){var k=new CheckComplexValueResultMessage;k.promiseId=a;k.result=b;k.value=c;k.indexCount=d;k.index0=e;k.index1=f;k.index2=g;return k};
Vc.TD=function(a,b){var c=new ResizeMessage;c.width=a;c.height=b;return c};Vc.PD=function(a,b,c){var d=new GetTypeDescResultMessage;d.promiseId=a;d.result=b;d.typeDesc=c;return d};Vc.ND=function(a,b,c,d){var e=new GetAdditionalFileNameResultMessage;e.promiseId=a;e.result=b;e.originalAdditionalFileName=c;e.resultingAdditionalFileName=d;return e};Vc.OD=function(a,b,c,d){var e=new GetImagePoolFileNameResultMessage;e.promiseId=a;e.result=b;e.imageId=c;e.resultingFileName=d;return e};
Vc.WD=function(a,b,c){var d=new SetSimpleValueResultMessage;d.promiseId=a;d.result=b;d.value=c;return d};Vc.VD=function(a,b,c,d,e,f,g){var k=new SetComplexValueResultMessage;k.promiseId=a;k.result=b;k.value=c;k.indexCount=d;k.index0=e;k.index1=f;k.index2=g;return k};var ub;ub=function(){this.kd=0};ub.Xh=0;ub.u=1;ub.V=2;ub.v=3;ub.ca=4;
ub.prototype={bR:function(a){this.kd=ub.Xh;null!==a&&void 0!==a&&(a.left()?this.kd=ub.u:a.right()?this.kd=ub.V:a.top()?this.kd=ub.v:a.bottom()&&(this.kd=ub.ca))},FR:function(){this.kd=ub.u},ER:function(){this.kd=ub.V},aQ:function(){this.kd=0},Qc:function(){return this.kd===ub.Xh},left:function(){return this.kd===ub.u},right:function(){return this.kd===ub.V},top:function(){return this.kd===ub.v},bottom:function(){return this.kd===ub.ca},before:function(){return this.left()||this.top()},after:function(){return this.right()||
this.bottom()}};var Nc;Nc=function(){this.ul=null;this.In=this.Hn=this.mf=this.lf=this.Rk=this.Qk=this.Uk=this.Tk=0};
Nc.prototype={initialize:function(a){this.ul=a},update:function(a,b,c,d,e,f){this.Tk=a;this.Uk=b;this.Qk=c;this.Rk=d;this.lf=e;this.mf=f;this.ul(this.lf,this.mf)},zD:function(a){null!==a&&a.zS(this.lf-this.Tk,this.mf-this.Uk,this.lf-this.Qk,this.mf-this.Rk)},RC:function(){return this.Qk-this.Tk},SC:function(){return this.Rk-this.Uk},Kh:function(a,b){this.lJ(b.info().scroll())},np:function(){},st:function(){},lJ:function(a){var b=this.In-a.ab.Y;this.lf+=this.Hn-a.ab.X;this.mf+=b;this.Hn=a.ab.X;this.In=
a.ab.Y;this.ul(this.lf,this.mf)},yu:function(){this.In=this.Hn=0},Aj:function(a){this.In=this.Hn=0;return a.info().scroll().vi.Mb(a.info().scroll().ab)}};var Tb;Tb=function(){this.Qz=J.Za();this.ej=this.uo=this.to=this.re=null};
Tb.prototype={pP:function(a,b,c,d){this.re=this.vH(a,b,c,d);this.Qz.appendChild(this.re)},QA:function(){null!==this.re&&this.Qz.removeChild(this.re);this.re=null},$M:function(a,b,c){this.re.innerHTML!=a&&(this.re.innerHTML=a,this.PG(b,c))},YR:function(a){this.ej=a},PG:function(a,b,c){this.to+a.L>b&&(this.to=b-a.L,this.re.style.left=this.to+"px");this.uo+a.aa>c&&(this.uo=c-a.aa,this.re.style.top=this.uo+"px")},vH:function(a,b,c,d){var e=document.createElement("div");e.id="cdsTooltip";e.style.msUserSelect=
"none";e.style.WebkitUserSelect="none";e.style.MozUserSelect="none";e.style.userSelect="none";e.style.position="absolute";e.style.left=a+"px";e.style.top=b+"px";this.to=a;this.uo=b;e.innerHTML=c;e.style.borderStyle="solid";e.style.font=d;e.style.color=this.ej.yv;e.style.borderColor=this.ej.dv;e.style.borderWidth=this.ej.Pj+"px";e.style.padding="2px 3px 2px 3px";e.style.backgroundColor=this.ej.wv;e.style.zIndex=Va.PF;return e}};var Xc;
Xc=function(a,b,c,d){this.T=null;this.eh=this.jb=this.Ah=this.zh=this.Rd=this.Qd=this.ra=this.na=this.qd=this.pd=0;this.Ii="solid";this.Hi="";this.mc=null;this.up=this.tp=1;this.Ma=new ib(0);this.bc=a;c?(this.Z=window.document.createElement("div"),this.Z.id="cdsClip",this.Z.style.overflow="hidden",this.Z.style.position="relative",this.bc.appendChild(this.Z)):this.Z=this.bc;this.fa=b;this.fg=null;this.ta="";this.Zq=Va.Pp;this.Ub=d};
Xc.prototype={initialize:function(){},MA:function(){},pb:function(){this.T&&this.O().parentNode===this.T?this.T.removeChild(this.O()):N.warn("Error when removing a client object. This node doesn't have a parent:"+this.O().id)},update:function(a,b,c,d,e,f,g,k,l,G,u){this.pd=a;this.qd=b;this.na=c;this.ra=d;this.Qd=e;this.Rd=f;this.zh=g;this.Ah=k;this.jb=l;this.fa.bD(G);this.rM(a,b,c,d,e,f,g,k,l,u)},lx:function(){},mx:function(a){var b=window.document.createElement("div");b.style.overflow="hidden";b.style.position=
"absolute";b.style.margin="";b.style.padding="";b.id=a;b.style.left="0px";b.style.top="0px";b.style.width=this.na+"px";b.style.height=this.ra+"px";a=J.eP(a+"_canvas",this.na,this.ra);b.appendChild(a);return b},IR:function(a){a?this.LR():this.JR()},aS:function(a,b){this.tp=a;this.up=b},O:function(){return this.bc},rM:function(a,b,c,d,e,f,g,k,l,G){var u=this;e=void 0===this.vl;void 0!==this.vl&&this.vl!==this.fa.gC()?window.WebvisuInst.yl(function(){u.wi(a,b,c,d,g,k,l,G)}):(this.vl=!this.fa.gC())?(null!==
this.fg&&(this.O().removeEventListener("transitionend",this.fg,!1),this.fg=null),e?(window.WebvisuInst.yl(function(){u.wi(a,b,c,d,g,k,l,G,100)}),window.WebvisuInst.wo(function(){u.Xi()})):(this.Xi(),window.WebvisuInst.wo(function(){u.wi(a,b,c,d,g,k,l,G,100)}))):(e||""===G?window.WebvisuInst.wo(function(){u.Xi()}):(this.fg=function(){u.Xi()},this.O().addEventListener("transitionend",this.fg,!1)),window.WebvisuInst.yl(function(){u.wi(a,b,c,d,g,k,l,G,0)}))},wi:function(a,b,c,d,e,f,g,k,l){c=this.O();
d=this.Z;g=1/this.tp;var G=1/this.up;this.We()&&this.lx();c.style.left=a+"px";c.style.top=b+"px";c.style.width=this.ag()+"px";c.style.height=this.$f()+"px";d.style.width=this.ag()+"px";d.style.height=this.$f()+"px";0<this.eh&&(d.style.border=this.eh+"px "+this.Ii+" "+this.Hi);c.style.transformOrigin=e+.5+"px "+(f+.5)+"px";c.style.transform="";0!==this.jb&&(c.style.transform=1!==(this.tp||this.up)?c.style.transform+("scale("+this.tp+","+this.up+") rotate("+this.jb+"deg) scale("+g+","+G+")"):c.style.transform+
(" rotate("+this.jb+"deg)"));void 0!==l&&(c.style.opacity=l);c.style.zIndex=this.fa.QN()?Va.cv:this.Zq;delete c.tabIndex;c.style.transition=k},U:function(){return null},Dh:function(){},KR:function(a,b,c){this.T=a;void 0===c?b.appendChild(this.O()):b.insertBefore(this.O(),b.children[c])},ae:function(a,b){this.T=a;void 0===b?this.T.appendChild(this.O()):this.T.insertBefore(this.O(),this.T.children[b])},wa:function(){return this},Lh:function(){return-1},Kg:function(a){this.mc=a},kO:function(){var a=
J.Rj(this.Z,J.Za());return new Bb(a.X,a.Y,a.X+this.na,a.Y+this.ra)},uc:function(){return new Bb(this.pd,this.qd,this.pd+this.ag(),this.qd+this.$f())},getParent:function(){return this.T},Fg:function(a){this.bc.id+="_"+a;this.ta+="_"+a;this.Z!==this.bc&&(this.Z.id+="_"+a)},Eg:function(){void 0!==this.Ub&&null!==this.Ub&&this.Ub.Lx.aE(this)},Xi:function(){this.O().style.display=this.vl?"":"none";this.fg&&(this.O().removeEventListener("transitionend",this.fg,!1),this.fg=null)},$Q:function(a){this.Ma=
a},We:function(){return!1},ag:function(){return Math.max(0,this.na-2*this.eh)},$f:function(){return Math.max(0,this.ra-2*this.eh)},Gu:function(){},zj:function(){return!1},SB:function(){return!1},gp:function(){return!1}};var Oc;Oc=function(a,b,c,d,e,f){Xc.call(this,a,b,c,f);this.gb=d;this.ua=e;this.Fr();this.Zm=this.Ik=this.Hd=null;this.Ri=[];this.qh=[];this.og=null;this.dg=-1;this.ik=!1;this.hd=null;this.$i=!1;this.An=this.ua&&this.ua.kh?!0:!1;this.Ee=[];this.$c=[];this.Cw=this.Im=0};
Oc.prototype=Object.create(Xc.prototype);r=Oc.prototype;r.constructor=Oc;r.initialize=function(){!this.An&&this.Ma.Qc()&&this.$F(this.Z);this.$i&&this.aG()};r.kD=function(a){this.$i=a};r.WC=function(a){this.ik=a};r.We=function(){return this.Ma.cm()};r.Xi=function(){this.mi(this.gb,this.rf(),this.qf());Xc.prototype.Xi.call(this)};r.Dh=function(a){this.ua&&this.ua.Dh(a);this.gb.clearRect(a.u,a.v,a.C(),a.B())};r.Eg=function(){this.Ub.Bi.SP(this);this.ua&&this.ua.Eg();Xc.prototype.Eg.call(this)};
r.pb=function(){this.zs();this.ua&&this.ua.su();this.hd&&this.hd.pb(this);this.Nl()&&this.tD();Xc.prototype.pb.call(this)};r.MA=function(){for(var a in this.qh)this.Z.removeChild(this.qh[a].O());this.dg=-1;this.qh=[]};r.hN=function(){var a,b=!1,c=this.Z;for(d in this.Ee)c.removeChild(this.Ee[d].O());for(a in this.$c)c.removeChild(this.$c[a]),b=!0;this.Ee=[];this.$c=[];this.dg=-1;if(0===c.childElementCount){b&&null!==this.Hd&&c.appendChild(this.Hd);var d=this.U();c.appendChild(d.canvas)}};
r.U=function(){var a=this.qr();if(a){var b=a.Ga;this.mi(b,-1===b.width?this.ag():b.width,-1===b.height?this.$f():b.height);a.qy&&b.setTransform(1,0,0,1,this.Qd,this.Rd)}else b=this.gb,this.mi(b,this.rf(),this.qf()),b.setTransform(1,0,0,1,this.Qd,this.Rd);return b};
r.vt=function(){var a;(a=this.qr())?(a=a.Ga,this.mi(a,-1===a.width?this.ag():a.width,-1===a.height?this.$f():a.height),a.clearRect(0,0,a.canvas.width,a.canvas.height)):(a=this.gb,this.mi(a,this.rf(),this.qf()),a.clearRect(-this.Qd,-this.Rd,a.canvas.width,a.canvas.height))};r.wa=function(){if(this.ua){var a=this.ua.wa();if(null!==a)return a}this.mi(this.gb,this.rf(),this.qf());return this};r.ba=function(){return this.ua};r.Ql=function(a){this.ua.Ql(a)};r.Lh=function(){return this.ua?this.ua.Lh():Xc.prototype.Lh.call(this)};
r.JM=function(a,b){this.We()&&(this.ua.Ma=this.Ma);this.ua.uA(a,b)};r.QP=function(){this.ua&&(-1===this.ua.Qa&&this.We()&&(this.Va.style.left="0px",this.Va.style.top="0px",this.cQ()),this.ua.su())};r.Kg=function(a){Xc.prototype.Kg.call(this,a);this.ua&&this.ua.Kg(this.mc)};r.ZQ=function(a,b,c){this.eh=a;this.Ii=b;this.Hi=c};r.update=function(a,b,c,d,e,f,g,k,l,G,u){this.oA();Xc.prototype.update.call(this,a,b,c,d,e,f,g,k,l,G,u)};
r.hR=function(a,b){var c=this,d=b.uc(),e=!1,f,g=this.Cw;c.Nl()&&this.Cw++;this.An&&null!==this.Hd&&this.Hd.src===a.src||(a.onerror=function(){c.Nl()||(c.Hd&&c.Z.removeChild(c.Hd),c.Hd=null,c.Ik=null)},a.onload=function(){b.mn&&b.wk&&(a.width=Math.round(b.en*a.width),a.height=Math.round(b.fn*a.height),e=!0,f=new Ja(a.width,a.height),d=J.fq(d,f,b));if(b.Em&&!e)a.width=d.C(),a.height=d.B();else if(b.Lr&&!e){if(d.C()/a.width<d.B()/a.height){var k=Math.round(d.C()*a.height/a.width);var l=d.C()}else k=
d.B(),l=Math.round(d.B()*a.width/a.height);a.width=l;a.height=k;l=new Bb(d.u,d.v,d.u+l,d.v+k);d=J.GA(l,d,b)}c.Nl()?c.XF(a,g):c.ZF(a);c.Ik=d.xc().clone();c.oA()})};r.ZF=function(a){this.Hd?this.Z.replaceChild(a,this.Hd):this.Z.insertBefore(a,this.gb.canvas);this.Hd=a};r.XF=function(a,b){for(var c in this.$c)if(a.src==this.$c[c].src)return;b%=2;void 0===this.$c[b]&&(this.Z.appendChild(a),this.$c[b]=a)};r.kR=function(a,b){null!==this.hd&&this.hd.pb();this.hd=b;this.hd.initialize(a,this.Z,this.pc)};
r.MC=function(){null!==this.og&&(this.O().removeChild(this.og.O()),this.og=null)};r.PM=function(a){null!==this.og&&this.MC();this.og=a;this.og.zu();this.O().appendChild(this.og.O())};r.vA=function(a,b){32767===a?this.PM(b):b.qy?this.py(b,a,this.Ee):this.py(b,a,this.qh)};
r.py=function(a,b,c){var d;if(void 0===c[b])if(a.zu(),a.eR(this.ta,b),c[b]=a,b===c.length-1){var e=this.gb.nextSibling;if(1<c.length)for(d in c)b>d&&(e=c[d].O().nextSibling);null===e||void 0===e?this.Z.append(a.O()):this.Z.insertBefore(a.O(),e)}else for(d in c){if(b<d){this.Z.insertBefore(a.O(),c[d].O());break}}else a=c[b].Ga,a.save(),a.setTransform(1,0,0,1,0,0),a.clearRect(0,0,a.canvas.width,a.canvas.height),a.restore(),c[b].zu()};
r.hy=function(a,b){void 0!==this.Ee[a]?this.Ee[a].Ga.canvas.hidden=b:void 0!==this.$c[a]&&(this.$c[a].hidden=b)};r.yS=function(a,b,c,d,e,f,g,k,l,G,u){var ka=this.qr();null!==ka&&(g=new Fc(g),ka.vS(a,b,c,d,e,f,g,k,l,G,u))};r.sD=function(a){this.dg=a};r.KN=function(){this.dg=-1};r.oA=function(){if(null!==this.Ik){null!==this.Hd&&this.zx(this.Hd);for(var a in this.$c)null!==this.$c[a]&&this.zx(this.$c[a])}};
r.zx=function(a){var b=this.Ik.Y+this.Rd,c=this.Ik.X+this.Qd;0!==b&&(a.style.top=b+"px");0!==c&&(a.style.left=c+"px")};r.$F=function(a){var b=this,c=D.Qb();this.ld(a,c?"pointerdown":"mousedown",function(d){b.Qn(d)});this.ld(a,c?"pointermove":"mousemove",function(d){b.Rn(d)});this.ld(a,c?"pointerup":"mouseup",function(d){b.Sn(d)});!c&&window.ontouchstart&&(this.ld(a,"touchstart",function(d){b.Qn(d)}),this.ld(a,"touchmove",function(d){b.Rn(d)}),this.ld(a,"touchend",function(d){b.Sn(d)}))};
r.aG=function(){var a=this.Ub.ed,b=null,c=null;this instanceof Pc?(c=this,b=this.gb.canvas):a===this.Ub.ba()&&(c=a.UN(),b=this.Z);null!==c&&null!==b&&(D.Qb()?(b.addEventListener("pointerup",function(d){c.lp(d)},!1),b.addEventListener("pointerdown",function(d){c.lp(d)},!1),b.addEventListener("pointermove",function(d){c.lp(d)},!1),b.addEventListener("pointerout",function(d){c.lp(d)},!1)):(b.addEventListener("mousedown",function(d){c.Ej(d)},!1),b.addEventListener("mousemove",function(d){c.Ej(d)},!1),
b.addEventListener("mouseup",function(d){c.Ej(d)},!1),b.addEventListener("mouseout",function(d){c.Ej(d)},!1),b.addEventListener("touchstart",function(d){c.ku(d)},!1),b.addEventListener("touchmove",function(d){c.ku(d)},!1),b.addEventListener("touchend",function(d){c.ku(d)},!1)))};r.rj=function(a){var b=new I(0,0),c=this.pI(a,b),d=this.mM(a),e=J.gq(this.mc);a=new Yc(a,c,d,e);a.CR(b);return a};r.Ca=function(){return J.gq(this.mc)};r.mM=function(a){return J.sm(a)};
r.Yk=function(a,b,c){D.Vh()&&(a=D.Yj(a),c=D.Yj(c));c=this.Hx(c);this.mc(a.rc(),0,b,[],c)};r.Lk=function(a,b){if(J.xq(a.tb)||J.Uj(a.tb)&&"touch"===a.tb.pointerType)if(null!==this.hd&&this.hd.handleEvent(a,b)||null!==this.Ub.qa&&this.Ub.qa.handleEvent(a,b))return!0;return J.xq(a.tb)};r.Qn=function(a){this.Ub.rb.uC(a);this.mI(a);var b=this.rj(a);this.Lk(b,db.J)||(a.stopPropagation(),this.KJ(a)&&void 0!==this.Ub&&this.Ub.he.$t()&&this.Ub.he.Ho(a),this.Yk(b.aj,db.J,b.Ld))};
r.pI=function(a,b){var c=new I(a.offsetX,a.offsetY);var d=a.target;var e=this.Z,f=!1;d===document&&(c=new I(a.pageX,a.pageY));b.X=c.X;b.Y=c.Y;a.target!==this.Z&&(a=this.AI(),null!==a&&null!==a.pc&&null===this.hd&&(d=a.gb.canvas,e=a.Z,f=!0),d=J.QB(e,d),D.Vh()&&d.Yl(D.Up()),c.X+=d.X,c.Y+=d.Y,f||(b.X+=d.X,b.Y+=d.Y));c=this.fz(c);this.fz(b);return c};
r.AI=function(){var a;if(null===this.T)return null;for(a=J.mm(this.Ub.ba(),this.T.id);null!==a&&(void 0===a.pc||null===a.pc||0===a.pc.RC()&&0===a.pc.SC());)a=J.mm(this.Ub.ba(),a.T.id);return a};r.KJ=function(a){return 1===a.which};r.qJ=function(){return this.ik||null!==this.hd};r.Rn=function(a){var b=this.rj(a);this.Lk(b,db.m)||(a.stopPropagation(),this.Yk(b.aj,db.m,b.Ld))};r.Sn=function(a){this.Ub.rb.vC(a);var b=this.rj(a);this.Lk(b,db.h)||(a.stopPropagation(),this.Yk(b.aj,db.h,b.Ld))};r.Hx=function(a){return J.KA(a)};
r.zs=function(){for(var a=0;a<this.Ri.length;++a)this.Ri[a].IN.removeEventListener(this.Ri[a].nB,this.Ri[a].callback,!1);this.Ri=[]};r.mI=function(a){if(this.qJ()){var b=this;this.Ub.Bi.tt(a,b,function(c){b.rK(c)},function(c){b.sK(c)})}};r.rK=function(a){var b=this.rj(a);a.stopPropagation();this.Lk(b,db.m)||this.Yk(b.aj,db.m,b.Ld)};r.sK=function(a){var b=this.rj(a);a.stopPropagation();this.Lk(b,db.h)||this.Yk(b.aj,db.h,b.Ld)};
r.ld=function(a,b,c){this.Ri.push({IN:a,nB:b,callback:c});a.addEventListener(b,c,!1)};r.fz=function(a){a.X=a.X-this.Qd;a.Y=a.Y-this.Rd;return a};r.qr=function(){return-1!==this.dg?32767===this.dg?this.og:0<this.Ee.length?this.Ee[this.dg]:this.qh[this.dg]:null};r.mi=function(a,b,c){a.canvas.width!==b&&(a.canvas.width=b);a.canvas.height!==c&&(a.canvas.height=c)};
r.Fr=function(){this.Z.appendChild(this.gb.canvas);this.ua&&(this.ua.ae(this.Z),"cdsDialog"!==this.O().id&&(this.O().id=this.ua.kh?"cdsClientObjectBackgroundContainer":"cdsClientObjectContainer"))};r.rf=function(){return this.ag()};r.qf=function(){return this.$f()};r.Fg=function(a){Xc.prototype.Fg.call(this,a);this.gb.canvas.id+="_"+a};r.$C=function(a){null===a&&null!==this.Zm&&(this.Z.removeChild(this.Zm),this.Z.focus());null===this.Zm&&null!==a&&this.Z.appendChild(a);this.Zm=a};
r.Gu=function(a){this.An=a};r.zj=function(){return this.An};r.SB=function(){return this.ua instanceof Jc&&this.ua.kh};r.sP=function(a){a%=2;this.hy(1-a,!0);this.hy(a,!1)};r.dS=function(){var a=this.Z;0===this.Ee.length&&0===this.$c.length&&J.kt(a);this.Ub.Dw.gS(this,function(b,c){b.sP(c)},this.Im)};r.tD=function(){this.Ub.Dw.kS(this);this.Nl()||this.hN()};r.zQ=function(a){this.sD(a);if(void 0===this.Ee[a]){var b=Xb.sv(!1,!1,!0);this.vA(a,b)}};
r.yQ=function(a){a!=this.Im&&(this.Im=a,this.tD(),0<a&&this.dS())};r.Nl=function(){return 0<this.Im};var Gc;Gc=function(a,b,c,d){Xc.call(this,a,b,c,d);this.g=d;this.ny();this.sk=this.Gd=null;this.ta="";this.fc=null;this.$y=new Zc};Gc.prototype=Object.create(Xc.prototype);r=Gc.prototype;r.constructor=Gc;r.ny=function(){this.O().id="cdsClientObjectNative"};
r.pR=function(a,b){if(b instanceof $c){this.Gd=b;this.fc=a;var c=ad.h();this.sk=b.vN(c,a.getConfiguration().ContentSecurityPolicyIncludeTrustedOrigins,this.na,this.ra,this.g);this.fc.register(c,this)}else this.Gd=b,a=b.pT(),a.style.width="100%",a.style.height="100%",a.style.position="absolute",this.sk=a;this.sk.id="cdsNativeElem"+this.ta;this.Z.appendChild(this.sk);this.yD()};r.pb=function(){window.WebvisuInst.fc.unregister(this);Xc.prototype.pb.call(this)};r.OP=function(a,b){this.$y.ru(a,b)};
r.Uo=function(a){return this.$y.Rt(a)};r.GL=function(a,b,c){this.mc(a,b,536,[],c)};r.qQ=function(a,b,c,d,e){var f=Ga.D(12);a=Ac.D(f,a.A.Fa,a.zb.zi);a.Sd(c);a.Sd(d);a.Ra(e);this.mc(b,0,539,[],f)};r.BL=function(a,b,c){this.mc(a,b,540,[],c)};r.pQ=function(a,b,c){var d=new I(b,c);if(0>b||0>c||b>this.na||c>this.ra)throw Error("Illegal argument!");"mousedown"===a?this.mc(d.rc(),0,db.J,[],void 0):"mousemove"===a?this.mc(d.rc(),0,db.m,[],void 0):"mouseup"===a&&this.mc(d.rc(),0,db.h,[],void 0)};
r.YM=function(a,b){if(this.Gd instanceof $c)this.fc.Sc(this,Vc.RD(a,b));else{a=a.split(".");var c=this.Gd;if(null!==c){for(var d=0;d<a.length-1;++d)c=c[a[d]]();c[a[a.length-1]].apply(c,b)}}};r.update=function(a,b,c,d,e,f,g,k,l,G,u){Xc.prototype.update.call(this,a,b,c,d,e,f,g,k,l,G,u);this.yD()};r.yD=function(){this.Gd instanceof $c&&this.fc.Sc(this,Vc.TD(this.na,this.ra))};var Ic;Ic=function(a,b,c,d){Xc.call(this,a,b,c,d);this.ds=-1};Ic.prototype=Object.create(Xc.prototype);
Ic.prototype.constructor=Ic;Ic.prototype.ny=function(){this.O().id="cdsClientObjectOldNative"};Ic.prototype.pb=function(){-1!==this.ds&&WebvisuExtensionMgr.Ht(this.ds);Xc.prototype.pb.call(this)};Ic.prototype.hD=function(a){this.ds=a};var Kc;Kc=function(a,b,c,d,e,f,g,k){this.pc=f;this.Va=g;this.Vs=!1;this.Kd=new bd;Oc.call(this,a,b,c,d,e,k)};Kc.prototype=Object.create(Oc.prototype);r=Kc.prototype;r.constructor=Kc;
r.initialize=function(){Oc.prototype.initialize.call(this);var a=this;this.pc.initialize(function(b,c){a.ul(b,c)})};r.Mu=function(a,b,c,d,e,f){this.pc.update(a,b,c,d,e,f);this.pc.zD(this.hd)};r.VM=function(){var a=this.Ma;a.Vu()?this.Mu(this.Kd.Bc.X,0,this.Kd.Ac.X,0,0,0):a.Wu()&&this.Mu(0,this.Kd.Bc.Y,0,this.Kd.Ac.Y,0,0)};
r.MR=function(){this.Ma.Vu()?(this.Kd.Qh(new I(.3*-this.na,0)),this.Kd.Ph(new I(.3*this.na,0)),this.cp()&&this.Kd.Qh(new I(-this.na,0)),this.bp()&&this.Kd.Ph(new I(this.na,0))):this.Ma.Wu()&&(this.Kd.Qh(new I(0,.3*-this.ra)),this.Kd.Ph(new I(0,.3*this.ra)),this.cp()&&this.Kd.Qh(new I(0,-this.ra)),this.bp()&&this.Kd.Ph(new I(0,this.ra)))};r.LR=function(){this.vs=!0};r.JR=function(){this.us=!0};r.cQ=function(){this.us=this.vs=!1};r.vD=function(){this.Vs=!0};r.xD=function(){this.Vs=!1};r.gp=function(){return this.Vs};
r.cp=function(){return void 0===this.vs?!1:this.vs};r.bp=function(){return void 0===this.us?!1:this.us};r.Kh=function(a,b){this.gp()||this.pc.Kh(a,b)};r.yu=function(){this.pc.yu()};r.Aj=function(a){this.pc.Aj(a)};r.wi=function(a,b,c,d,e,f,g,k,l){this.Va&&(this.Va.style.width=this.rf()+"px",this.Va.style.height=this.qf()+"px");Oc.prototype.wi.call(this,a,b,c,d,e,f,g,k,l)};r.tM=function(a,b){this.gp()||null===this.Va||(this.Va.style.left=a+"px",this.Va.style.top=b+"px")};
r.Fg=function(a){Oc.prototype.Fg.call(this,a);null!==this.Va&&(this.Va.id+="_"+a)};r.ul=function(a,b){this.tM(-a,-b);for(var c in this.qh){var d=this.qh[c].Ga;d&&(d.kQ&&(d.canvas.style.left=d.x-a+"px"),d.lQ&&(d.canvas.style.top=d.y-b+"px"))}};r.Fr=function(){this.Va?(this.Va.appendChild(this.gb.canvas),this.Z.appendChild(this.Va),this.ua&&(this.ua.ae(this.Va),this.O().id="cdsClientObjectContainer")):Oc.prototype.Fr.call(this)};
r.rf=function(){return this.We()?this.ag():this.Va?Math.max(0,this.ag()+this.pc.RC()):Oc.prototype.rf.call(this)};r.qf=function(){return this.We()?this.$f():this.Va?Math.max(0,this.$f()+this.pc.SC()):Oc.prototype.qf.call(this)};
r.lx=function(){var a=J.xa(this.Va,"cdsClip_before");var b=J.xa(this.Va,"cdsClip_after");var c=this.Ma;if(null===a){a=this.mx("cdsClip_before");var d=!0}if(null===b){b=this.mx("cdsClip_after");var e=!0}c.Zt()?(!0===d&&(a.style.left=-this.na+"px"),b.style.left=this.na+"px"):c.kC()&&(!0===d&&(a.style.top=-this.ra+"px"),b.style.top=this.ra+"px");!0===d&&this.Va.appendChild(a);!0===e&&this.Va.appendChild(b)};var Pc;
Pc=function(a,b,c,d,e,f,g,k){Oc.call(this,a,b,!1,c,d,g);this.Wa=null;this.Pn=this.ln=this.al=!1;this.s=null;this.lA=!1;this.Aa=e;this.ni=null;this.Zq=Va.Qp;this.it=f;this.g=g;this.Vk=!1;this.bs=null;this.Yq="";this.yc=null;this.Yn=this.yz=this.Zn=this.xz=0;k&&this.WC(k)};Pc.prototype=Object.create(Oc.prototype);r=Pc.prototype;r.constructor=Pc;
r.initialize=function(a,b,c,d,e,f,g){Oc.prototype.initialize.call(this);this.al=b;this.Pn=c;this.ln=d;this.Wa=a;this.ni=e;this.s=f;this.O().style.transform="scale(0)";this.O().style.opacity=0;this.Aa&&(this.Aa.style.opacity=0,this.bL());g&&(this.Zq=Va.bF)};r.pb=function(){this.Aa&&(this.pM(),this.T===this.Aa.parentNode&&this.T.removeChild(this.Aa));Oc.prototype.pb.call(this)};
r.update=function(a,b,c,d,e,f,g,k,l,G,u,ka){""===u&&(this.lA=!0);if(this.ln)Oc.prototype.update.call(this,0,0,c,d,e,f,0,0,l,G,u);else{g=c/2;k=d/2;var ja=c,va=d;null!==this.ni&&null!==this.ni.canvas&&(ja=this.ni.canvas.width-c,va=this.ni.canvas.height-d);this.Wa instanceof Bb&&(this.al?(a=this.Wa.Gl().X-c/2,b=this.Wa.Gl().Y-d/2,a=Math.min(Math.max(0,ja),Math.max(0,a)),b=Math.min(Math.max(0,va),Math.max(0,b))):this.Pn&&(this.s.iP&&this.s.hP?(g=this.Wa.xc().Y,k=this.ni.canvas.height-this.Wa.Ud().Y,this.s.yC||
this.s.xC)?this.s.yC?this.s.xC||(b=this.Wa.Ud().Y,a=this.Mq(c)):(b=this.Wa.xc().Y-d,a=this.Mq(c)):this.s.nt||this.s.zA?this.s.nt&&(a=this.Mq(c),b=this.Wa.Ud().Y,d>k&&g>k&&(b=this.Wa.xc().Y-d)):(a=this.Wa.xc().X,b=this.Wa.Ud().Y,d>k&&g>k&&(b=this.Wa.xc().Y-d)):(a=this.Wa.Ud().X,b=this.Wa.Ud().Y,a>ja&&(a=this.Wa.xc().X-c),b>va&&(b=this.Wa.xc().Y-d),a=Math.min(Math.max(0,ja),Math.max(0,a)),b=Math.min(Math.max(0,va),Math.max(0,b)))),g=this.Wa.Gl().X-a,k=this.Wa.Gl().Y-b);Oc.prototype.update.call(this,
a,b,c,d,e,f,g,k,l,G,u);this.O().style.opacity=1;this.Aa&&(this.Aa.style.transition=u,this.it&&(this.Aa.style.backgroundColor=ka),this.Aa.style.opacity=1)}};r.Mq=function(a){return this.s.zA?this.Wa.xc().X:this.s.nt?this.Wa.Ud().X-a:this.Wa.xc().X+(this.Wa.Ud().X-this.Wa.xc().X)/2-a/2};r.ae=function(a){this.Aa&&a.appendChild(this.Aa);Oc.prototype.ae.call(this,a)};
r.close=function(a){if(this.lA)this.lB(a);else{var b=this;this.ld(this.O(),"transitionend",function(){b.lB(a)})}this.Aa&&(this.Aa.style.opacity=0);this.O().style.transform="scale(0)";this.O().style.opacity=0};r.lB=function(a){this.Aa&&this.T===this.Aa.parentNode&&this.T.removeChild(this.Aa);a()};
r.bL=function(){var a=this,b=D.Qb();this.ld(this.Aa,b?"pointerdown":"mousedown",function(c){a.Fd(c)});this.ld(this.Aa,b?"pointermove":"mousemove",function(c){a.Fd(c)});this.ld(this.Aa,b?"pointerup":"mouseup",function(c){a.Fd(c)});!b&&window.ontouchstart&&(this.ld(this.Aa,"touchstart",function(c){a.Fd(c)}),this.ld(this.Aa,"touchmove",function(c){a.Fd(c)}),this.ld(this.Aa,"touchend",function(c){a.Fd(c)}))};
r.pM=function(){var a=this,b=D.Qb();this.Aa.removeEventListener(b?"pointerdown":"mousedown",function(c){a.Fd(c)});this.Aa.removeEventListener(b?"pointermove":"mousemove",function(c){a.Fd(c)});this.Aa.removeEventListener(b?"pointerup":"mouseup",function(c){a.Fd(c)});!b&&window.ontouchstart&&(this.Aa.removeEventListener("touchstart",function(c){a.Fd(c)}),this.Aa.removeEventListener("touchmove",function(c){a.Fd(c)}),this.Aa.removeEventListener("touchend",function(c){a.Fd(c)}))};
r.Fd=function(a){this.Aa&&a.target===this.Aa&&a.stopPropagation()};r.Ej=function(a){var b=J.sm(a);this.ms(a,b,!1)};r.lp=function(a){var b=J.sm(a);this.ms(a,b,!1)};r.ku=function(a){if(null!==a.touches&&1<=a.touches.length){var b=J.sm(a.touches[0]);this.ms(a,b,!0)}};
r.ms=function(a,b,c){switch(a.type){case "mouseout":case "pointerout":this.Vk?(a.preventDefault(),this.Fw(a,b)):this.Pz();break;case "mousedown":case "pointerdown":case "touchstart":a.preventDefault();this.zK(b,c);var d=this;this.g.Bi.tt(a,d,function(e){d.Ej(e)},function(e){d.Ej(e)});break;case "mousemove":case "pointermove":case "touchmove":a.preventDefault();this.ls(a,b,c);break;case "mouseup":case "pointerup":case "touchend":a.preventDefault(),this.AK(a,c)}};
r.zK=function(a,b){b||(this.Yq=this.Z.style.cursor,this.Z.style.cursor="move");this.yc=J.Za().getBoundingClientRect();this.yc.x=0;this.yc.y=0;this.xz=this.yc.x+2;this.Zn=this.yc.x+this.yc.width-2;this.yz=this.yc.y+2;this.Yn=this.yc.y+this.yc.height-2;b=new I(parseInt(this.O().offsetLeft,10),parseInt(this.O().offsetTop,10));this.Is(a);this.bs=new I(b.X-a.X,b.Y-a.Y);this.Vk=!0};r.ls=function(a,b,c){this.Vk?this.Fw(a,b):c||this.Pz()};r.AK=function(a,b){this.Vk&&(this.bz(b),this.Vz(a))};
r.Fw=function(a,b){this.Is(b);b.X<=this.xz||b.X>=this.Zn||b.Y<=this.yz||b.Y>=this.Yn?(this.bz(this),this.Vz(a)):(a=b.X+this.bs.X,b=b.Y+this.bs.Y,a<=this.yc.x&&(a=this.yc.x),a+this.na>=this.Zn&&(a=this.Zn-this.na),b<=this.yc.y&&(b=this.yc.y),b+this.ra>=this.Yn&&(b=this.Yn-this.ra),this.O().style.top=b+"px",this.O().style.left=a+"px")};r.bz=function(a){a||(this.Z.style.cursor=""!==this.Yq?this.Yq:"default");this.Vk=!1};
r.Vz=function(a){if(null!==this.g.A){var b=new I(parseInt(this.O().style.left,10),parseInt(this.O().style.top,10));a=this.rj(a).Ld;this.Is(a);a=this.Hx(a);this.mc(b.rc(),0,537,[],a)}};r.Pz=function(){"move"===this.Z.style.cursor&&(this.Z.style.cursor="default")};r.Is=function(a){D.Vh()&&D.Yj(a)};var Rc;Rc=function(a,b,c){this.Ga=a;this.Vf=b;(this.Li=null!==b)&&this.Vf.appendChild(this.Ga.canvas);this.qy=c};
Rc.prototype={O:function(){return this.Li?this.Vf:this.Ga.canvas},eR:function(a,b){this.Ga.canvas.id="cdsCanvas"+a+"_Layer_"+b.toString();this.Li&&(this.Vf.id="cdsClip"+a+"_Layer_"+b.toString())},vS:function(a,b,c,d,e,f,g,k,l,G,u){g.Qc()?(this.Ga.x=a,this.Ga.y=b,this.Ga.canvas.style.left=a+"px",this.Ga.canvas.style.top=b+"px"):this.gG(g);this.Ga.width=c;this.Ga.height=d;this.Ga.kQ=e;this.Ga.lQ=f;this.Ga.canvas.style.width=-1===this.Ga.width?"100%":c+"px";this.Ga.canvas.style.height=-1===this.Ga.height?
"100%":d+"px";this.Li&&(this.Vf.fT=u,this.Vf.style.left=k+"px",this.Vf.style.top=l+"px",this.Vf.style.width=G+"px",this.Vf.style.height=u+"px")},gG:function(a){a.right()&&(this.Ga.canvas.style.right="0px");a.left()&&(this.Ga.canvas.style.left="0px");a.top()&&(this.Ga.canvas.style.top="0px");a.bottom()&&(this.Ga.canvas.style.bottom="0px")},zu:function(){this.Ga.x=0;this.Ga.y=0;this.Ga.width=-1;this.Ga.height=-1}};var Jc;
Jc=function(a){this.T=null;this.sa=[];this.$b={};this.Qa=-1;this.mc=null;this.Gf=-1;this.kh=a;this.gr=this.Wi=null;this.ps=!1;this.ng=new cd;this.Ma=new ib(0);this.$q=null};
Jc.prototype={uA:function(a,b){32767===a?(b.O().id="cdsDemoMode",b.O().style.zIndex=Va.cv,b.ae(J.Za()),this.$q=b):-1===this.Qa?(b.zj()||b.SB()?(b.Fg(a),this.Du(b,1),b.Gu(!0),this.ps=!0):(b.ua instanceof Jc?null===this.Wi&&(this.Wi=a):this.ps&&!this.kh?this.Du(b,a+1):this.Du(b,a),b.Gu(this.kh),b.Fg(a)),b.Kg(this.ix(a)),this.Yz(a,b)):(b.Fg(this.Qa),this.Me(this.Qa).JM(a,b))},Du:function(a,b){if(this.Ma.cm()&&!a.Ma.Qc()){var c=this.LB(a.Ma);a.KR(this.T,c,b)}else a.ae(this.T,b)},su:function(){if(-1===
this.Qa)this.vx(),this.Ma.cm()&&this.T&&this.ng.clear(this.T),this.ps=!1;else{var a=this.Me(this.Qa);void 0!==a&&a.QP()}},tu:function(){this.vx();this.Qa=-1},Dh:function(a){for(var b=0;b<this.sa.length;++b)this.sa[b]&&this.sa[b].Dh(a)},Vl:function(){for(var a=0;a<this.sa.length;++a)this.sa[a]&&this.sa[a].ua&&this.sa[a].ua.Vl();for(var b in this.$b)this.$b[b]&&this.$b[b].pb();this.$b={}},Eg:function(){for(var a=0;a<this.sa.length;++a)this.sa[a]&&this.sa[a].Eg();for(var b in this.$b)this.$b[b]&&this.$b[b].Eg()},
vx:function(){this.Eg();for(var a=0;a<this.sa.length;++a)this.sa[a]&&this.sa[a].pb();for(var b in this.$b)this.$b[b]&&this.$b[b].pb();this.Pq()},wa:function(){return-1!==this.Qa?this.Me(this.Qa).wa():null},Ql:function(a){-1===this.Qa?this.Qa=a:this.Me(this.Qa).Ql(a)},Lh:function(){var a;if(-1===this.Qa)return-1;var b=this.wa();(a=b.We())&&(b=b.ba())&&b.ng.xu();b=this.Me(this.Qa).Lh();-1===b&&(this.Qa===this.Wi&&(this.jG(),this.Wi=null),a&&this.ng.xu(),b=this.Qa,this.Qa=-1);return b},Kg:function(a){this.mc=
a},ae:function(a){this.T=a;for(var b=0;b<this.sa.length;++b)this.sa[b]&&this.sa[b].ae(a);for(var c in this.$b)this.$b[c]&&this.$b[c].ae(a)},jG:function(){this.ng.RB()&&null!==this.Wi&&this.kG()||this.sa.forEach(function(a){a&&(a.T=this.T,this.T.appendChild(a.O()))}.bind(this))},kG:function(){var a=this.ng.KB(this.Wi);if(null===a)return!1;var b=this.LB(a.Ma);a.T=this.T;null===b?this.T.appendChild(a.O()):b.appendChild(a.O());return!0},isActive:function(){return-1!==this.Qa},Ou:function(a){this.Gf=a},
SQ:function(a){this.gr=a},Pq:function(){this.sa=[];this.$b={};this.$q=null},LB:function(a){return this.Ma.cm()&&this.Ma.Qc()&&a?a.jC()?J.xa(this.T,"cdsClip_before"):a.iC()?J.xa(this.T,"cdsClip_after"):null:null},Me:function(a){if(32767===a)return this.$q;if(this.ng.RB()){var b=this.ng.KB(a);if(null!==b)return b}return this.$b.hasOwnProperty(a)?this.$b[a]:this.sa[a-1]},Yz:function(a,b){b.Ma.Qc()?b.zj()?this.$b[a]=b:this.sa[a-1]=b:this.ng.GR(a,b)},ay:function(){return null===this.gr?this.sa.length:
this.gr},ix:function(a){var b=this;return function(c,d,e,f,g,k){var l=b.Me(a);l&&!l.zj()&&f.push({id:a,qC:b.ay()});-1!==b.Gf&&f.push({id:b.Gf,qC:15});c=b.mc(c,d,e,f,g,k);if(k)return c}}};var Qc;Qc=function(){Jc.call(this,!1);this.sa={};this.Mn=0};Qc.prototype=Object.create(Jc.prototype);r=Qc.prototype;r.constructor=Qc;r.LM=function(a,b){b.ae(this.T);b.Kg(this.ix(a));b.Fg(a);this.sa[String(a)]=b;this.Mn=Math.max(this.Mn,a)};r.RP=function(a){var b=this,c=this.Me(a);this.CH(a);c.Eg();c.close(function(){b.pK(c)})};
r.AP=function(a){this.Qa=a};r.wP=function(){var a=this.Qa;this.Qa=-1;return a};r.tu=function(){this.JI();this.Pq();this.Qa=-1};r.Vl=function(){for(var a in this.sa)this.sa[a]&&this.sa[a].ua&&this.sa[a].ua.Vl()};r.Dh=function(a){for(var b in this.sa)this.sa[b]&&this.sa[b].Dh(a)};r.UN=function(){return-1!==this.Qa?this.Me(this.Qa):null};r.Pq=function(){this.sa={}};
r.CH=function(a){delete this.sa[String(a)];this.Qa===a&&(this.Qa=-1);this.Mn=Object.keys(this.sa).map(Number).reduce(function(b,c){return Math.max(b,c)},0)};r.pK=function(a){a.pb()};r.JI=function(){var a=Pc.prototype.pb,b=[],c;for(c in this.sa)this.sa[c]&&a.apply(this.sa[c],b)};r.Me=function(a){return this.sa[String(a)]};r.Yz=function(a,b){this.sa[String(a)]=b};r.ay=function(){return this.Mn};var cd;cd=function(){this.Uf=[];this.Tf=[];this.ck=new ub};
cd.prototype={empty:function(){return 0===this.Uf.length&&0===this.Tf.length},xu:function(){this.ck=new ub},RB:function(){return!this.ck.Qc()},clear:function(a){var b=J.xa(a,"cdsClip_before");var c=J.xa(a,"cdsClip_after");b&&(J.kt(b,"cdsClip_before_canvas"),b=J.xa(a,"cdsClip_before_canvas"),b=b.getContext("2d"),b.clearRect(0,0,b.canvas.width,b.canvas.height));c&&(J.kt(c,"cdsClip_after_canvas"),b=J.xa(a,"cdsClip_after_canvas"),b=b.getContext("2d"),b.clearRect(0,0,b.canvas.width,b.canvas.height));this.Uf=
[];this.Tf=[];this.xu()},KB:function(a){return this.ck.before()&&0<this.Uf.length?this.Uf.hasOwnProperty(a)?this.Uf[a]:this.Uf[a-1]:this.ck.after()&&0<this.Tf.length?this.Tf.hasOwnProperty(a)?this.Tf[a]:this.Tf[a-1]:null},GR:function(a,b){var c=b.Ma;this.ck.bR(b.Ma);c.jC()?b.zj()?this.Uf[a]=b:this.Uf[a-1]=b:c.iC()&&(b.zj()?this.Tf[a]=b:this.Tf[a-1]=b)}};var dd;dd=function(a,b,c,d){this.ic=a;this.ZE=b;this.$E=c;this.aF=d};var ed;ed=function(a,b){this.ic=a;this.cf=b};var fd;
fd=function(a,b,c,d){this.ic=a;this.cf=b;this.Gc=c;this.Error=d};var gd,hd,lc;lc=function(a){this.Ha=new XMLHttpRequest;this.g=a;this.Wf=null};
lc.prototype={wb:function(a,b,c,d){this.g.getConfiguration()?(this.wB(),this.Wf.send(a,b,c,d)):this.g.error("Error while creating a connection to the webserver: No configuration found")},wB:function(){if(null===this.Wf)this.g.getConfiguration().CasFactoryName?this.Wf=new gd:this.Wf=new hd(this.g,this.Ha);else return this.Wf},du:function(a,b){this.jc=b;this.Ha.open("GET",a,!0);var c=this;this.Ha.onreadystatechange=function(){c.nP(a)};this.Ha.send()},nP:function(a){4===this.Ha.readyState&&(200===this.Ha.status||
"OK"===this.Ha.status?this.jc.Dl(this.Ha.responseText):this.jc.S("Loading file '"+a+"' failed: "+this.Ha.status,$a.Ya))},Al:function(a){this.wB();null!==this.Wf&&this.Wf instanceof gd&&this.Wf.Al(a)}};gd=function(){var a=this;window.CODESYS.CAS.resultListener=function(b){a.jc.Xb(b)}};gd.prototype={send:function(a,b){this.jc=b;window.CODESYS.CAS.sendMessage(a)},Al:function(a){window.CODESYS.CAS.sendCloseBeacon(a)}};hd=function(a,b){this.g=a;this.Ha=b};
hd.prototype={send:function(a,b,c,d){void 0===c&&(c=!1);void 0===d&&(d=!1);this.jc=b;b="WebVisuV3.bin";var e=this;d=this.DL(d,a);D.sO()&&(b+="?"+J.m());c&&"function"==typeof navigator.sendBeacon?navigator.sendBeacon(b,new Uint8Array(a)):(this.Ha.open("POST",b,!c),c||D.bk()||(this.Ha.responseType="arraybuffer"),this.Ha.setRequestHeader("Content-Type","application/octet-stream"),d&&this.Ha.setRequestHeader("3S-Repl-Content",J.mC(a)),c||(this.Ha.onreadystatechange=function(){e.oP()}),0<this.g.getConfiguration().XhrSendTimeout&&
(this.Ha.timeout=this.g.getConfiguration().XhrSendTimeout,this.Ha.ontimeout=function(){e.jc.S("Sending service timeout",$a.Uc)}),d?this.Ha.send():this.Ha.send(a))},oP:function(){if(4===this.Ha.readyState)if(200===this.Ha.status||"OK"===this.Ha.status){this.Ha.onreadystatechange=null;if(D.bk()){var a=this.Ha.responseText;""===a&&(a=null)}else a=this.Ha.response,a instanceof ArrayBuffer&&0===a.byteLength&&(a=null);try{null!==a||this.sI()?this.jc.Xb(a):this.jc.S("Sending service failed, server not available?",
$a.Pb)}catch(b){this.jc.S("Unexpected exception while evaluating comm result"+b,$a.J)}}else 4E3===this.Ha.status?this.g.XO():0===this.Ha.status?this.jc.S("Sending service aborted",$a.m):this.jc.S("Sending service failed, status: "+this.Ha.status,$a.xa)},sI:function(){return"function"!==typeof this.jc.nj?!1:this.jc.nj()},DL:function(a,b){return window.btoa?(a||this.g.zz)&&b instanceof ArrayBuffer&&70>b.byteLength?!0:!1:!1}};var Ua;Ua=function(){};Ua.xa=43981;Ua.m=0;Ua.Pb=1;Ua.Uc=129;Ua.h=0;Ua.J=0;
Ua.Ya=1;var id;id=function(a,b,c){this.Ks=a;this.Ls=b;this.Wz=c;this.ne=0};id.read=function(a){var b=a.getUint16(),c;if(52565!==b)throw Error("Unsupported protocol: "+b);this.Dk=a.getUint16();if(12>this.Dk)throw Error("Unsupported length of header: "+this.Dk);this.Ks=a.getUint16();this.Ls=a.getUint16();this.Wz=a.getUint32();this.ne=a.getUint32();b=this.Dk-12;16<=this.Dk&&(a.getUint16(),b-=2);for(c=0;c<b;++c)a.getUint8();return this};
id.prototype={write:function(a,b){a.Kb(52565);a.Kb(16);a.Kb(this.Ks);a.Kb(this.Ls);a.K(this.Wz);a.K(b);a.Kb(0);a.Kb(0)}};var jd;jd=function(a,b,c){this.sh=new Dc(a,b,c);this.P=this.sh.M};
jd.prototype={GC:function(){try{if("|"!==this.P.qj())return"Unexpected format of service: 1";var a=this.iA(),b=!1;if(4>a.length)return"Unexpected format of service: 2";5<=a.length&&(b="true"===a[4]);return new Ta(parseInt(a[0],10),0===parseInt(a[1],10),parseInt(a[2],10),"true"!==a[3],b)}catch(c){return"Exception during readOpenConnectionResult: "+c}},JP:function(){var a=this.iA(),b;for(b=0;b<a.length;++b)if(0===a[b].indexOf("IPv4:"))return a[b].substr(5);return""},iA:function(){for(var a=[],b="";!this.P.If();){var c=
this.P.qj();"|"===c?(a.push(b),b=""):b+=c}return a},Gb:function(a,b){for(a=this.P.ga()+a;this.P.ga()<a;){var c=this.sh.uj(),d=this.sh.uj();c=b[c];var e=this.P.ga();"function"===typeof c&&c(this,d);c=this.P.ga()-e;c<d&&this.RL(d-c)}},FP:function(a){return a?this.YK():this.ZK()},ZK:function(){try{var a=this.Md(1,2),b=0,c=0,d=0,e=Ua.J;this.Gb(a.ne,{130:function(f,g){f.Gb(g,{32:function(k){b=k.P.getUint16()},33:function(k){c=k.P.getUint32()}})},34:function(f){e=f.P.getUint32()},65407:function(f){d=f.P.getUint16()}});
return new fd(b,c,e,d)}catch(f){return"Exception during readOldDeviceSessionResult: "+f}},YK:function(){try{var a=this.Md(1,10),b=0,c=0,d=Ua.J;this.Gb(a.ne,{33:function(e){b=e.P.getUint32()},70:function(e){d=e.P.getUint32()},65407:function(e){c=e.P.getUint16()}});770===c&&(d=Ua.Ya);return new fd(0,b,d,c)}catch(e){return"Exception during readNewDeviceSessionResult: "+e}},DP:function(a,b){return 2===a?this.HP():this.IP(b?65315:35)},HP:function(){try{var a=this.Md(1,2),b=0,c=0,d=null,e=null,f=null;this.Gb(a.ne,
{65410:function(g,k){g.Gb(k,{32:function(l){c=l.P.getUint16()}})},130:function(g,k){g.Gb(k,{32:function(l){b=l.P.getUint16()}})},39:function(g){d=g.P.Xe(!1)},38:function(g,k){var l=Ga.D(k);l.Bo(g.P.oj(),g.P.ga(),k);e=l.Wd()},65315:function(g){f=g.P.getUint32()}});return new dd(0!==b?b:c,f,d,e)}catch(g){return"Exception during readNewDeviceCryptResult: "+g}},IP:function(a){try{var b=this.Md(1,2),c=0,d=0,e=0,f={65410:function(g,k){g.Gb(k,{32:function(l){d=l.P.getUint16()}})},130:function(g,k){g.Gb(k,
{32:function(l){c=l.P.getUint16()}})}};f[a]=function(g){e=g.P.getUint32()};this.Gb(b.ne,f);return new dd(0!==c?c:d,e,null,null)}catch(g){return"Exception during readOldDeviceCryptResult: "+g}},EP:function(){try{var a=this.Md(1,2),b=0,c=0,d=0;this.Gb(a.ne,{65410:function(e,f){e.Gb(f,{32:function(g){c=g.P.getUint16()},33:function(g){d=g.P.getUint32()}})},130:function(e,f){e.Gb(f,{32:function(g){b=g.P.getUint16()},33:function(g){d=g.P.getUint32()}})}});return new ed(0!==b?b:c,d)}catch(e){return"Exception during readOldDeviceLoginResult: "+
e}},LP:function(){try{for(this.Md(4,1);!this.P.If();){var a=this.sh.uj();this.sh.uj();if(1===a){var b=this.P.getUint32();return 2952790016>b?b:4294967290===b?"Visualization is not allowed":4294967292===b?"No more memory on the plc":4294967293===b?"Connection to invalid application":4294967289===b?"Too many clients are registering at the same time":"Unknown error"}return 65410===a?"no rights":65407===a?"Visu not supported by the plc":"Unknown tag ID"}return"Unexpected format of service: 4"}catch(c){return"Exception during readVisuRegisterClientResult: "+
c}},KP:function(){try{for(this.Md(4,3);!this.P.If();){var a=this.sh.uj();this.sh.uj();if(65407===a)return"Visu not supported by the plc";var b=this.P.getUint32();return 0===b||1===b?b:2===b?"Client registration failed":3===b?"Client registration failed due to an invalid external id":4===b?"The maximum number of visualization clients is already connected. Please try again later.":5===b?"Not enough memory in the PLC to create the client.":"Unknown error"}return"Unexpected format of service: 5"}catch(c){return"Exception during readVisuIsRegisteredClientResult: "+
c}},MP:function(){try{return this.Md(4,2),0}catch(a){return"Exception during readVisuRemoveClientResult: "+a}},qu:function(a){var b=0===a.direction?5:2,c=132;a.status.Yb===kd.J&&(b=Ua.Pb,c=Ua.Uc);try{var d=this.Md(8,b);b={};b[c]=function(e,f){e.Gb(f,{2:function(g){a.bi.uS=g.P.getUint32();a.bi.xe=g.P.getUint32()},3:function(g){a.Bp=g.P.getUint32()},8:function(g){a.status.result=g.P.getUint16()}})};b[34]=function(e){e.P.getUint32()};b[65410]=function(e,f){e.Gb(f,{32:function(g){a.status.result=g.P.getUint16()}})};
this.Gb(d.ne,b)}catch(e){return"Exception during readtFileAndSessionInfoResult: "+e}},FC:function(a){var b=0===a.direction?7:4,c=0;try{var d=this.Md(8,b),e=0===a.direction?a.bi.xe:a.Uh.xe,f={};0===a.direction?(f[6]=function(g){c=g.P.getUint32()},f[7]=function(g,k){a.status.se=!0;f[5](g,k)},f[5]=function(g,k){null===a.buffer&&(a.buffer=Ga.D(e));if(a.status.wd+c<=e&&c<=k){for(k=0;k<c;)a.buffer.yo(g.P.getUint8()),k++;a.status.wd+=c;a.status.result=Ua.h}else a.status.wd=4294967295}):f[5]=function(g){g=
g.P.getUint16();g===Ua.h?(a.status.result=Ua.h,a.status.wd+=a.status.Rh,a.status.Rh=0,a.status.se=a.status.wd>=e):a.status.result=g};this.Gb(d.ne,f)}catch(g){return"Exception during readtFileAndSessionInfoResult: "+g}},GP:function(a){var b=0===a.direction?a.bi.xe:a.Uh.xe;b=a.status.result===Ua.h&&a.status.wd===b&&a.status.se?8:9;try{var c=this.Md(8,b);this.Gb(c.ne,{7:function(d){d.P.getUint16();a.status.se=!0}})}catch(d){return"Exception during readFinishFileTransferResult: "+d}},Gj:function(a){try{var b=
this.Md(4,4),c=0,d=a;this.Gb(b.ne,{132:function(e,f){e.Gb(f,{2:function(g){g.P.getUint32();var k=g.P.getUint32(),l=g.P.getUint32();g=g.P.getUint32();d=new hb(k,l,g)},4:function(){d.finish()},1:function(g){c=g.P.getUint32()},3:function(g,k){d.Wd().Bo(g.P.oj(),g.P.ga(),Math.min(k,d.aP()))}})}});return 0!==c?65535===c?"Client id not present or no longer valid":c.toString():null===d?"Unexpected format of service: 6":d}catch(e){return"Exception during readVisuGetPaintDataResult: "+e}},RL:function(a){this.P.seek(this.P.ga()+
a)},Md:function(a,b){var c=id.read(this.P),d=4+c.Dk+c.ne;if(this.P.size()<d)throw Error("Actual packet size "+this.P.size()+" smaller than expected "+d);if(c.Ks!==(128|a)||c.Ls!==b)throw Error("Unexpected format of service: 3");return c}};var mc;
(function(){var a=!1;mc=function(b,c,d,e){this.ha=b;this.KH=c;this.ma=Ga.D(50);this.eH=d;this.ea=new Ec(this.ma,b,e);this.F=this.ea.jf};mc.prototype={hS:function(b){a=b},qb:function(){return this.ma.Wd()},BC:function(b,c,d){var e=this.F.hb("|",!1);b=this.F.hb(b,!1);c=this.F.hb(c.toString(),!1);d=this.F.hb(d.toString(),!1);this.Gm(1);this.F.vg(e);this.F.vg(b);this.F.vg(e);this.F.vg(c);this.F.vg(e);this.F.vg(d);this.F.vg(e)},dQ:function(){this.Gm(3)},HN:function(){this.Gm(100)},vo:function(b,c,d){d=
c.hb(d,!1);var e=d.length()+1,f=this.bg(e,4,2);b.G(e+f,3);c.hc(d);this.Pf(c,f,0)},qN:function(b){var c=Ga.D(500),d=new Ec(c,this.ha),e=d.jf;d.G(64);d.G(4,3);e.K(2882382797);d.G(65);this.vo(d,e,"WebVisualization");d.G(67);this.vo(d,e,b);d.G(68);this.vo(d,e,Rb.h);d.G(69);this.vo(d,e,Rb.h);return c},wH:function(b,c){var d=Ga.D(500),e=new Ec(d,this.ha),f=e.jf,g=new Uint8Array(c);e.G(16);var k=b.byteLength;var l=this.bg(k,4,2);e.G(k+l,3);for(k=0;k<b.length;++k)f.Ra(b[k]);this.Pf(f,l,0);e.G(17);k=c.byteLength;
e.G(k,3);for(k=0;k<g.length;++k)f.Ra(g[k]);return d},EN:function(b){var c=this.Pc(1,10);b=this.qN(b.A.eq);var d=Ua.Ya;this.ea.G(131);this.Fq(b,this.ea,this.F);this.ea.G(70);D.nE()&&(d|=2);this.ea.G(4,3);this.F.K(d);this.Ic(c)},Fq:function(b,c,d){var e=2>=c.HB(b.size())?2:6;c.G(b.size(),e);this.Fm(d,b)},BN:function(b){var c=this.Pc(1,2);this.yw(b,1);this.Ic(c)},yw:function(b,c){this.ea.G(34);this.ea.G(4,3);this.F.K(b);this.ea.G(37);this.ea.G(4,3);this.F.K(c)},CN:function(b,c){var d=this.Pc(1,2);b=
this.wH(b,c);this.yw(2,2);this.ea.G(129);this.Fq(b,this.ea,this.F);this.Ic(d)},It:function(b,c,d,e){if(void 0===b||null===b)b="";void 0===c&&(c=null);void 0===d&&(d=0);void 0===e&&(e=Ua.J);var f=this.Pc(1,2),g=null,k=null,l=new oa("utf-8");this.ea.G(34);this.ea.G(4,3);this.F.K(e);0!==d&&(this.ea.G(35),this.ea.G(4,3),this.F.K(d));null!==c&&(k=l.encode(c));b=l.encode(b);b=this.VI(b);null!==k&&0!==d&&e===Ua.Ya&&(g=this.UI(k,d));this.ea.G(129);this.ea.G(b.size()+(null!==g?g.size():0),2);this.Fm(this.F,
b);null!==g&&this.Fm(this.F,g);this.Ic(f)},DN:function(){var b=this.Pc(1,3);this.F.K(0);this.Ic(b)},GS:function(b,c,d,e){var f=this.Pc(4,1);b=this.F.hb(b,!1);var g=b.length()+4+1,k=this.bg(g,4,0),l=0,G=0,u=524288,ka=this.F.hb(c,!1),ja=this.F.hb(d,!1);c&&0<c.length&&l++;d&&0<d.length&&l++;0<l&&(G=8+84*l,g+=G);e&&(u=2097152);this.ea.G(1);this.ea.G(g+k,3);this.F.hc(b);this.Pf(this.F,k,0);this.F.K(u);0<l&&(this.F.K(G),this.F.K(l),c&&0<c.length&&(this.F.Kb(1),this.F.hc(ka),this.F.zo(82-ka.length()-1)),
d&&0<d.length&&(this.F.Kb(2),this.F.hc(ja),this.F.zo(82-ja.length()-1)));this.Ic(f)},ES:function(b){var c=this.Pc(4,3);this.ea.G(3);this.ea.G(4,3);this.F.K(b);this.Ic(c)},Oj:function(b){this.sA(b,4,132)},DS:function(b){var c=this.Pc(4,4);this.ea.G(132);this.ea.G(8,2);this.ea.G(4);this.ea.G(4,3);this.F.K(b);this.Ic(c)},FS:function(b){this.sA(b,6,134)},$u:function(b){var c=this.Pc(4,2);this.ea.G(2);this.ea.G(4,3);this.F.K(b);this.Ic(c)},sN:function(b){var c=this.Pc(8,Ua.Pb);b=this.F.hb(b.Mh,!1);var d=
b.length()+1,e=this.bg(d,4,2);this.ea.G(1);this.ea.G(d+e);this.F.hc(b);this.Pf(this.F,e,0);this.ea.G(2);this.ea.G(8,3);this.F.K(0);this.F.K(0);this.Ic(c)},ZA:function(b){var c=this.Pc(8,0===b.direction?5:2),d=this.F.hb(b.Mh,!1),e=d.length()+1,f=this.bg(e,4,2);this.ea.G(1);this.ea.G(e+f);this.F.hc(d);this.Pf(this.F,f,0);0===b.direction?(this.ea.G(2),this.ea.G(8,3),this.F.K(0),this.F.K(0)):(this.ea.G(2),this.ea.G(8,3),b.Uh.xe=b.buffer.size(),this.F.K(0),this.F.K(b.Uh.xe));this.Ic(c)},YA:function(b){var c=
this.Pc(8,0===b.direction?7:4);if(1===b.direction){var d=b.Uh.xe;var e;var f=this.OI();if(20<f)f-=20;else return 1;f>d-b.status.wd&&(f=d-b.status.wd);d=this.bg(f,4,0);this.ea.G(6);this.ea.G(4,3);this.F.K(f);b.status.Rh=f;this.ea.G(5);this.ea.G(4+f+d,3);this.F.K(b.Bp);for(e=0;e<f;e++)this.F.Ra(b.buffer.getUint8());this.Pf(this.F,d,0)}else this.ea.G(5),this.ea.G(4,3),this.F.K(b.Bp),this.F.K(Ua.h);this.Ic(c)},tN:function(b){var c=0===b.direction?b.bi.xe:b.Uh.xe;c=this.Pc(8,b.status.result===Ua.h&&b.status.wd===
c&&b.status.se?8:9);this.ea.G(7);this.ea.G(4,3);this.F.K(b.Bp);this.Ic(c)},sA:function(b,c,d){c=this.Pc(4,c);b=this.gJ(b);this.ea.G(d);this.Fq(b,this.ea,this.F);this.Ic(c)},Ic:function(b){var c=this.F.ga()-b.AF;this.GM(b.sE,c)},Pc:function(b,c){b=new id(b,c,this.KH);this.Gm(2);this.F.zo(20);return{sE:b,AF:this.F.ga()}},VI:function(b){var c=Ga.D(10+b.byteLength),d=new Ec(c,this.ha),e=d.jf,f=b.byteLength+1,g=this.bg(f,4,2);d.G(16);d.G(f+g);for(d=0;d<b.byteLength;++d)e.Ra(b[d]);e.Ra(0);this.Pf(e,g,0);
return c},UI:function(b,c){b=this.TI(b,c);c=Ga.D(10+b.length);var d=new Ec(c,this.ha),e=d.jf;d.G(17);d.G(b.length,3);for(d=0;d<b.length;++d)e.Ra(b[d]);return c},TI:function(b,c){var d="Qcw@e46A6!R.gssltR4dg=_l)B^nQSo^",e="",f=[],g=0,k=0,l=b.byteLength+1,G=[c&255,0,0,0];for(c=0;c<d.length;c+=4)e=e.concat(String.fromCharCode(d.charCodeAt(c+2)+3)),e=e.concat(String.fromCharCode(d.charCodeAt(c+1)+2)),e=e.concat(String.fromCharCode(d.charCodeAt(c+3)+4)),e=e.concat(String.fromCharCode(d.charCodeAt(c)+1));
d=e;32>l&&(l=32);0!==l%4&&(l+=4-l%4);for(c=0;c<l;++c){e=d.charCodeAt(g);var u=0;c<b.byteLength&&(u=b[c]);f[c]=(u^e+G[k])&255;g++;g===d.length&&(g=0);k++;4===k&&(k=0)}return f},OI:function(){return this.eH-this.F.ga()},gJ:function(b){var c=Ga.D(100),d=new Ec(c,this.ha),e=d.jf,f=b.vw,g=b.Ca();d.G(1);d.G(16,3);e.K(b.de);e.K(b.cF);e.K(b.dF);e.K(b.GD);(null!==f||null!==g&&!a)&&this.FM(d,f,a?null:g);null!==b.ai&&(d.G(3),d.G(8,3),e.Kb(b.ai.u),e.Kb(b.ai.v),e.Kb(b.ai.V),e.Kb(b.ai.ca));null!==g&&a&&(d.G(5),
d.G(8,3),e.K(g.Fb),e.K(g.cc));return c},FM:function(b,c,d){b.G(2);var e=0,f=b.jf;null!==d&&(e=8);null!==c&&(e+=c.size());var g=this.bg(e,4,0);b.G(e+g,3);null!==d&&(f.K(d.Fb),f.K(d.cc));null!==c&&this.Fm(f,c);this.Pf(f,g,0)},Fm:function(b,c){var d=c.size(),e;for(e=0;e<d;++e)b.Ra(c.vB(e))},bg:function(b,c,d){for(var e=0;0!==(b+d)%c;)b++,e++;return e},Pf:function(b,c,d){for(var e=0;e<c;++e)b.Ra(d)},Gm:function(b){this.F.Ra(b);this.F.Ra(0);this.F.Kb(0)},GM:function(b,c){this.F.seek(4);b.write(this.F,
c)}}})();var Yb;Yb=function(){};Yb.TF=0;Yb.XD=1;var Vb;Vb=function(a){this.m=D.Qb();this.fb=[];this.g=a;var b=this;this.h(this.m?"pointermove":"mousemove",function(c){b.ls(c)});this.h(this.m?"pointerup":"mouseup",function(c){b.J(c)});this.h(this.m?"pointercancel":"mousecancel",function(c){b.uh(c)});this.fd=[]};
Vb.prototype={SP:function(a){var b=[],c,d=this;for(c=0;c<this.fd.length;++c)this.fd[c].target===a&&b.push(c);if(0!==b.length){var e=J.qm(a.Z);var f=J.gq(a.mc);a=function(k){k.stopPropagation()};var g=function(k){d.HH(k,db.h,e,f)};for(c=0;c<b.length;++c)this.fd[c].target=null,this.fd[c].iu=a,this.fd[c].Xu=g,this.fd[c].rt=void 0}},HH:function(a,b,c,d){a.stopPropagation();var e=new I(a.pageX,a.pageY),f=new I(a.pageX,a.pageY);e.Tc(c);a=new Yc(a,e,f,d);if(null!==this.g.qa&&this.g.qa.handleEvent(a,b))return!0;
b=Fa.h(b,this.g.A.la,e);b.$d(d);D.Vh()&&(f=D.Yj(f));d=J.KA(f);b.Nb(d);this.g.rd(b)},zs:function(a){for(var b=a.length-1;0<=b;--b)this.fd.splice(a[b],1)},h:function(a,b){this.fb.push({nB:a,callback:b});document.addEventListener(a,b,!0)},ls:function(a){var b=this.rn(J.Mf(a));null!==b&&b.iu&&b.iu(a)},J:function(a){var b=J.Mf(a),c=this.rn(b);null!==c&&(this.rp(b),c.Xu&&c.Xu(a))},uh:function(a){var b=J.Mf(a),c=this.rn(b);null!==c&&(this.rp(b),c.rt&&c.rt(a))},rn:function(a){for(var b=0;b<this.fd.length;++b)if(this.fd[b].mB===
a)return this.fd[b];return null},rp:function(a){for(var b=[],c=0;c<this.fd.length;++c)this.fd[c].mB===a&&b.push(c);this.zs(b)},tt:function(a,b,c,d,e){var f=J.Mf(a);if(null!==this.rn(f))throw Error("This event is already registered.");if(J.Uj(a)&&a.target.releasePointerCapture)try{a.target.releasePointerCapture(f)}catch(g){}this.fd.push({mB:f,target:b,iu:c,Xu:d,rt:e})}};var db;db=function(){};db.J=2;db.h=4;db.m=16;db.Ya=521;db.xa=529;var Fa;
Fa=function(a,b,c,d){void 0===c&&(c=0);void 0===d&&(d=0);this.de=a;this.GD=b;this.cF=c;this.dF=d;this.ai=this.vw=null;this.dl=!1;this.Db=null};Fa.h=function(a,b,c){D.Vh()&&(c=D.Yj(c));return Fa.m(a,b,c)};Fa.J=function(a,b,c,d){return new Fa(a,b,c,d)};Fa.Ya=function(a,b){return new Fa(257,a,b.charCodeAt(0))};Fa.xa=function(a,b,c,d,e,f,g){var k=Ga.D(12),l=Ac.D(k,!0);a=new Fa(516,a,(b?c?d?7:5:d?3:1:0)|(g?16:0),0);l.Dc(0);l.Dc(0);l.Dc(e.C()-1);l.Dc(e.B()-1);l.Ao(f);a.Nb(k);return a};
Fa.Pb=function(a,b,c){return Fa.m(a,b,c)};Fa.m=function(a,b,c){return new Fa(a,b,c.rc())};Fa.prototype={iD:function(a){this.ai=new Bb(Math.max(0,a.u),Math.max(0,a.V),Math.max(0,a.v),Math.max(0,a.ca))},Nb:function(a){this.vw=a},UR:function(){this.dl=!0},$d:function(a){this.Db=a},Ca:function(){return this.Db}};var ld;ld=function(){var a;void 0===a&&(a=100);this.$m=[];this.jj=this.hl=0;this.Pk=a;this.qn=!1;this.Ny=0};
ld.prototype={push:function(a){2097152!==a.de&&(this.Ny=J.m());if(this.HJ(a))return!0;if(this.qn)return"undefined"!==typeof N&&N.warn(J.h("Eventqueue full, dropped event with tag {0}",a.de)),!1;this.$m[this.jj%this.Pk]=a;this.jj=(this.jj+1)%this.Pk;this.jj===this.hl&&(this.qn=!0);return!0},empty:function(){return!this.qn&&this.hl===this.jj},pop:function(){if(this.empty())return null;this.qn=!1;var a=this.hl;this.hl=(this.hl+1)%this.Pk;return this.$m[a]},HJ:function(a){if(!this.empty()&&(a.de===db.m||
2053===a.de||2055===a.de||516===a.de||this.sy(a.de))){var b=(this.jj+this.Pk-1)%this.Pk,c=this.$m[b];if(c.de===a.de&&(!this.sy(a.de)||this.tJ(a,c)))return this.$m[b]=a,!0}return!1},sy:function(a){return 539===a},tJ:function(a,b){return a.Ca()===b.Ca()?!0:null===a.Ca()||null===b.Ca()?!1:a.Ca().eE(b.Ca())}};var xb;xb=function(a){this.pg={};this.g=a;this.Wr=null};
xb.prototype={tj:function(a,b,c){void 0===c&&(c=null);var d=this.nK(a,c);var e=this.pg[d];if(void 0!==e)return e;e=new md(this.g,a,c,b);return this.pg[d]=e},WM:function(a){var b=[];this.Sx(function(c){c.Cg()||(b.push(c),c.XM(function(){b.splice(b.indexOf(c),1);0===b.length&&setTimeout(a,0)}))})},bN:function(){var a=J.m(),b=[],c=this.g.getConfiguration(),d;if(-1!==c.NumCachedImages)if(0===c.NumCachedImages)this.pg={};else{this.Sx(function(f,g){var k=f.YJ;f=f.jz?c.MaxUnusedImageAge:c.MaxUndrawnImageAge;
0!==k&&k<a-f&&b.push({path:g,time:k})});var e=Math.min(J.qP(this.pg)-c.NumCachedImages,b.length);if(0<e)for(b.sort(function(f,g){return f.time-g.time}),d=0;d<e;++d)delete this.pg[b[d].path]}},UP:function(a){delete this.pg[a]},pC:function(){null===this.Wr&&(this.Wr=this.g.getConfiguration().LoadImagesById);return this.Wr},Sx:function(a){var b;for(b in this.pg){var c=this.pg[b];a(c,b)}},nK:function(a,b){return null===b?a:a+":"+b}};var md;
md=function(a,b,c,d){this.g=a;this.jz=!1;this.rg=c;this.hh=J.iq(b);this.eL=3;this.Rs(d,null);this.ct();this.Jk=this.Wn=this.gj=null};
md.prototype={xJ:function(){try{D.QE(this.Oe,this.hh,this.g.getConfiguration())?this.FI():(null===this.rg||this.wy()||this.oM(),this.Lm(2))}catch(a){this.g.error("Unexpected exception during load image callback: "+a)}},wy:function(){return J.wq(this.hh)},oM:function(){try{var a=window.document.createElement("canvas"),b=a.getContext("2d"),c,d=parseInt(this.rg.substr(1,2),16),e=parseInt(this.rg.substr(3,2),16),f=parseInt(this.rg.substr(5,2),16),g=this.RI(),k=this.Wo();a.width=k.L;a.height=k.aa;b.drawImage(this.Oe,
0,0);var l=b.getImageData(0,0,a.width,a.height);for(c=0;c<l.data.length;c+=4)g(l.data[c],l.data[c+1],l.data[c+2],d,e,f)&&(l.data[c+3]=0,l.data[c]=0,l.data[c+1]=0,l.data[c+2]=0);b.putImageData(l,0,0);this.gj=a;this.Oe=null}catch(G){this.gj=this.rg=null,N.warn("Exception during making image "+this.hh+" transparent. Is this an SVG? As a workaround it will be rendered ignoring the transparency color")}},bK:function(a){try{if(N.warn("Loading image "+this.hh+" failed: "+a.type),0<=this.eL--){var b=this;
window.setTimeout(function(){N.info("Triing to load the image "+b.hh+" again");b.Rs(!0,null)},50);this.Lm(4)}else this.Lm(3)}catch(c){this.g.error("Unexpected exception during handling of load image problems: "+c)}},Vo:function(){this.ct();this.jz=!0;2!==this.fa&&N.warn("Access to not (yet) loaded image");return null!==this.gj?this.gj:this.Oe},Wo:function(){null===this.Jk&&(null!==this.Oe?this.Jk=D.Dv(this.Oe):null!==this.gj&&(this.Jk=D.Dv(this.gj)));return this.Jk},bQ:function(){this.Jk=null},XM:function(a){this.Wn=
a},Cg:function(){return 2===this.fa||3===this.fa},loaded:function(){return 2===this.fa},Lm:function(a){this.ct();this.fa=a;null!==this.Wn&&this.Cg()&&(this.Wn(),this.Wn=null)},ct:function(){this.YJ=J.m()},Rs:function(a,b){this.Oe=new Image;var c=this;b=null===b?this.hh:b;this.Oe.onload=function(){c.xJ()};this.Oe.onerror=function(d){c.bK(d)};this.fa=1;this.Oe.src=this.xG(b,a)},xG:function(a,b){b&&(a+="?"+J.m());this.wy()&&!this.g.getConfiguration().WorkaroundDisableSVGAspectRatioWorkaround&&(a+="#svgView(preserveAspectRatio(none))");
return a},RI:function(){return this.g.getConfiguration().FuzzyTransparencyColorEvaluation?function(a,b,c,d,e,f){return 2>Math.abs(a-d)&&2>Math.abs(b-e)&&2>Math.abs(c-f)}:function(a,b,c,d,e,f){return a===d&&b===e&&c===f}},FI:function(){N.m("Workaround for image "+this.hh+" without width/height activated");var a=this;D.bE(this.Oe,function(b){a.Rs(!1,b)},function(b){N.warn("Retrieving workaround image failed so going on as formerly, reason: "+b);a.Lm(3)})}};var vb;
vb=function(){this.yf={};this.hf=null;this.tm="<Project>"};
vb.prototype={Ih:function(a){a=a.toLowerCase().split(".");var b=[],c;for(c=0;c<a.length;++c)b[c]=J.Sh(a[c]);if(1>b.length)return null;a=b[b.length-1];if(1===b.length)return this.Zi(this.kn(a));c=b[b.length-2];if(2===b.length){var d=this.yI(c);if(null!==d)return this.Zi(this.jr(a,d));d=this.lr(c);return null!==d?(c=this.jn(a,d),null===c&&(c=this.kn(a)),this.Zi(c)):this.Zi(this.kn(a))}b=b.slice(0,b.length-2).join(".");d=this.lr(b);if(null!==d&&(d=this.kr(c,d),null!==d))return this.Zi(this.jr(a,d));
d=this.lr(b+"."+c);return null!==d?(c=this.jn(a,d),null===c&&(c=this.kn(a)),this.Zi(c)):this.Ih(c+"."+a)},uQ:function(a){this.hf=a},Zi:function(a){return null!==a?a.path:null},lr:function(a){var b=this.Px(a);null===b&&(b=this.zI(a));return b},Px:function(a){a=this.yf[a];return void 0!==a?a:null},zI:function(a){if(null!==this.hf){a=a.toLowerCase();var b,c=null;for(b=0;b<this.hf.length;++b)if(this.hf[b].ju===a){c=this.hf[b].DC;break}if(null!==c)for(b=0;b<this.hf.length;++b)if(this.hf[b].ju!==a&&this.hf[b].DC===
c){var d=this.Px(this.hf[b].ju);if(null!==d)return d}}return null},kn:function(a){var b=this.yf[this.tm],c;if(void 0!==b&&(b=this.jn(a,b),null!==b))return b;for(c in this.yf)if(c!==this.tm&&(b=this.jn(a,this.yf[c]),null!==b))return b;return null},jn:function(a,b){var c;for(c in b.Fj){var d=this.jr(a,b.Fj[c]);if(null!==d)return d}return null},jr:function(a,b){a=b.entries[a];return void 0===a?null:a},yI:function(a){var b=this.yf[this.tm],c;if(void 0!==b&&(b=this.kr(a,b),null!==b))return b;for(c in this.yf)if(b=
this.kr(a,this.yf[c]),null!==b)return b;return null},kr:function(a,b){a=b.Fj[a];return void 0!==a?a:null},fill:function(a){a=a.replace(/\r\n/g,"\n").split("\n");var b;for(b=0;b<a.length;++b){var c=a[b].split(";");if(!(4>c.length)){var d=this.mK(J.Sh(c[1]));var e=J.Sh(c[0]).toLowerCase();var f=J.Sh(c[2]).toLowerCase();var g=J.Sh(c[3]);c=this.yf[d];if(void 0===c){c={Fj:{}};var k=this.kx(e);k.entries[f]=this.Vq(f,g);c.Fj[e]=k;this.yf[d]=c}else k=c.Fj[e],void 0===k?(k=this.kx(e),k.entries[f]=this.Vq(f,
g),c.Fj[e]=k):k.entries[f]=this.Vq(f,g)}}},mK:function(a){return null===a||""===a?this.tm:a.toLowerCase()},kx:function(a){return{name:a,entries:{}}},Vq:function(a,b){return{id:a,path:b}}};var Fb;Fb=function(){};Fb.prototype={j:function(a){if(a.g.pa){var b=a.g.ba().wa();if(null!==b&&!(b instanceof Gc)&&(b=b.hd,null!==b&&void 0!==b)){b.xl();return}}a=a.g.qa;null!==a&&a.xl()}};var nd;nd=function(a,b){this.l=R.ye(b)};nd.prototype={j:function(a){a.vt();a.g.rb.Tl(this.l)}};var od;
od=function(a,b){this.l=R.ye(b)};od.prototype={j:function(a){a.getContext().clearRect(this.l.u,this.l.v,this.l.C(),this.l.B());a.g.rb.Tl(this.l)}};var pd;pd=function(a,b){this.l=R.ye(b)};pd.prototype={j:function(a){a=a.getContext();a.save();a.beginPath();a.rect(this.l.u,this.l.v,this.l.C()+1,this.l.B()+1);a.clip()}};var qd;qd=function(){};qd.prototype={j:function(a){(a=a.g.so)&&a.QA()}};var rd;
rd=function(a,b,c,d){this.l=R.di(b,!1);this.ao=0!==b.getInt8();this._type=b.getInt8();switch(this._type){case 2:case 4:this.Xm=b.getUint32();this.Ym=b.getUint32();this.xi=b.getUint32();break;case 1:case 3:this.Yw=b.getInt16(),this.Xm=b.getUint32()}d.Zd()&&(this.l=d.gi(this.l))};
rd.prototype={j:function(a){var b=a.getContext(),c=this.l.u,d=this.l.v,e=this.l.C(),f=this.l.B(),g=b.lineWidth;b.save();this.ko=a.g.getConfiguration().SemiTransparencyActive;a.getState().zg()?a.getState().Co(this.l):b.fillStyle=!0===this.ko?R.$a(this.Xm):R.ib(this.Xm);b.lineWidth=1;c+=.5;d+=.5;switch(this._type){case 2:case 4:this.KK(b,c,d,e,f);break;case 1:case 3:this.JK(b,c,d,e,f)}b.lineWidth=g;a.getState().zg()&&a.getState().Xl();b.restore()},uc:function(){return this.l},eO:function(){return!0===
this.ko?R.$a(this.Ym):R.ib(this.Ym)},VN:function(){return!0===this.ko?R.$a(this.xi):R.ib(this.xi)},KK:function(a,b,c,d,e){if(!0===this.ko){var f=this.ao?R.$a(this.xi):"#000000";var g=R.$a(this.Ym);var k=R.$a(this.xi)}else f=this.ao?R.ib(this.xi):"#000000",g=R.ib(this.Ym),k=R.ib(this.xi);this.ao?(a.strokeStyle=f,a.strokeRect(b,c,d,e),a.fillRect(b,c,d,e)):(a.fillRect(b,c,d,e),a.strokeStyle=g,a.beginPath(),a.moveTo(b,c),a.lineTo(b+d,c),a.moveTo(b,c),a.lineTo(b,c+e),a.stroke(),a.closePath(),a.strokeStyle=
f,a.beginPath(),a.moveTo(b,c+e),a.lineTo(b+d,c+e),a.lineTo(b+d,c),a.stroke(),a.closePath(),a.strokeStyle=k,a.beginPath(),a.moveTo(b+1,c+e-1),a.lineTo(b+d-2,c+e-1),a.moveTo(b+d-1,c+1),a.lineTo(b+d-1,c+e-1),a.stroke(),a.closePath())},JK:function(a,b,c,d,e){var f=new sd(this.Xm,this.Yw);if(this.ao)a.strokeStyle=R.ib(f.yB(0)),a.strokeRect(b,c,d,e),a.fillRect(b,c,d,e);else{a.strokeStyle="#000000";a.fillRect(b,c,d,e);a.strokeRect(b,c,d,e);var g;for(g=0;g<this.Yw;++g)a.beginPath(),a.moveTo(b+g,c+e-g),a.lineTo(b+
g,c+g),a.lineTo(b+d-g,c+g),a.strokeStyle=R.ib(f.TN(g)),a.stroke(),a.beginPath(),a.moveTo(b+d-g,c+1+g),a.lineTo(b+d-g,c+e-g),a.lineTo(b+1+g,c+e-g),a.strokeStyle=R.ib(f.yB(g)),a.stroke()}}};var Cb;
Cb=function(a,b,c,d){a=b.ga();var e=b.getUint16();var f=b.ja(e,!1);e=b.getUint16();e=b.ja(e,!1);""!==f&&(e=f+"."+e);this.sf=e;this.l=R.di(b,!0);this.l.normalize();d.Zd()&&(this.l=d.gi(this.l));f=b.getUint32();this.Lr=0!==(f&1);this.Em=0!==(f&2);this.mn=0!==(f&4);this.QL=0!==(f&8);this.Qw=0!==(f&16);this.fj=0!==(f&32);this.vr=0!==(f&128);this.Hs=0!==(f&256);this.ft=0!==(f&1024);this.Lq=0!==(f&2048);this.vh=0!==(f&4096);this.wk=!1;this.Jz=this.l;this.rg=R.ib(b.getUint32());c>=b.ga()-a+16&&(this.wk=
!0,this.en=b.getFloat32(),this.fn=b.getFloat32(),d.Zd()&&(this.en=d.jo,this.fn=d.bj));this.Ea=null};
Cb.prototype={j:function(a){a=a.getContext();var b=R.PE(this.l),c=this.l.clone(),d=this;this.OL(a,c,b);null!==this.Ea&&(this.Ea.loaded()?this.rk(a,this.Ea.Vo(),function(){return d.Ea.Wo()},c,!1):this.XH(a,this.l));this.QL&&(c=R.aq(a),a.strokeRect(this.l.u+c,this.l.v+c,this.l.C(),this.l.B()));this.YG(a,b)},iR:function(a){this.sf=a},YB:function(a,b){var c;this.vh&&null!==(c=b.Ih(this.sf))&&a.UP(c);if(null===this.Ea){if(a.pC())return b="ImageByImagePoolId?id="+this.sf,this.Ea=this.fj?a.tj(b,this.vh,
this.rg):a.tj(b,this.vh),this.Ea.Cg();c=b.Ih(this.sf);if(null!==c)return this.Ea=this.fj?a.tj(c,this.vh,this.rg):a.tj(c,this.vh),this.Ea.Cg();-1===this.sf.indexOf("VisuUserManagement.__VisualizationStyle.")&&N.warn("Imagepoolentry for "+this.sf+" not found");return!0}return this.Ea.Cg()},qv:function(){var a=this,b=this.l.clone();null!==this.Ea&&(this.rk(null,this.Ea.Vo(),function(){return a.Ea.Wo()},b,!0),this.Ea.bQ());return this.Jz},rk:function(a,b,c,d,e){if(this.mn&&this.wk){var f=c();f=new Ja(Math.round(this.en*
f.L),Math.round(this.fn*f.aa));d=J.fq(d,f,this);this.mn=!1;this.Em=!0}if(this.Em)e||a.drawImage(b,d.u,d.v,d.C(),d.B());else if(this.Lr){f=c();d.C()/f.L<d.B()/f.aa?(c=Math.round(d.C()*f.aa/f.L),f=d.C()):(c=d.B(),f=Math.round(d.B()*f.L/f.aa));var g=new Bb(d.u,d.v,d.u+f,d.v+c);d=J.GA(g,d,this);e||a.drawImage(b,d.u,d.v,f,c)}else e||a.drawImage(b,d.u,d.v);this.Jz=d},OL:function(a,b,c){c&&(a.save(),b.yd.Do(a,b));this.Qw&&(a.save(),a.beginPath(),a.rect(b.u,b.v,b.C()+1,b.B()+1),a.clip())},YG:function(a,b){this.Qw&&
a.restore();b&&a.restore()},XH:function(a,b){b=b.$B(-3);a.save();a.fillStyle="#eeeeee";a.strokeStyle="#ff0000";a.lineWidth=3;a.fillRect(b.u,b.v,b.C(),b.B());a.beginPath();a.moveTo(b.u,b.v);a.lineTo(b.V,b.ca);a.moveTo(b.V,b.v);a.lineTo(b.u,b.ca);a.closePath();a.stroke();a.restore()}};var td;td=function(a,b,c,d){this.l=R.di(b,!0);this.aA=R.gm(b.getInt16());this.eM=R.gm(b.getInt16());this.uI=1===b.getInt16();d.Zd()&&(this.l=d.gi(this.l))};
td.prototype={j:function(a){var b=a.getContext(),c=this.l.C(),d=this.l.B(),e=!a.getState().Yt(),f=!a.getState().Oi,g=Math.min(c,d)/2;0>=c||0>=d||(b.save(),this.lG(b),a.getState().zg()&&a.getState().Co(this.cJ(g)),b.beginPath(),b.arc(0,0,g,this.aA,this.aA+this.eM,!1),this.uI&&(b.lineTo(0,0),b.closePath(),e&&b.fill()),b.restore(),f&&b.stroke(),a.getState().zg()&&a.getState().Xl())},cJ:function(a){return new Bb(-a,-a,a,a)},lG:function(a){var b=this.l.C(),c=this.l.B();null!==this.l.yd?this.l.yd.Do(a,
this.l):a.translate(this.l.u+.5,this.l.v+.5);a.translate(b/2,c/2);b>c?a.scale(b/c,1):a.scale(1,c/b)}};var ud;ud=function(a,b){this.ia=R.Pv(b)};ud.prototype={j:function(a){a=a.getContext();var b;for(b=0;b<this.ia.length;++b)a.fillRect(this.ia[b].X,this.ia[b].Y,1,1)}};var vd;vd=function(a,b,c,d){this._type=b.getUint16();2===a?this.ia=R.Pv(b):59===a&&(this.ia=R.qF(b));d.Zd()&&(this.ia=d.wF(this.ia))};
vd.prototype={j:function(a){var b=a.getContext(),c=!a.getState().Yt(),d=!a.getState().Oi;if(!(2>this.ia.length)){a.getState().zg()&&a.getState().Co(this.cM());d&&this.UK(b);switch(this._type){case 0:this.YH(b,c,d);break;case 1:d&&this.ZH(b);break;case 2:d&&this.TH(b)}a.getState().zg()&&a.getState().Xl()}},UK:function(a){a=R.aq(a);var b;if(0!==a)for(b=0;b<this.ia.length;++b)this.ia[b].X+=a,this.ia[b].Y+=a},YH:function(a,b,c){a.beginPath();a.moveTo(this.ia[0].X,this.ia[0].Y);for(var d=1;d<this.ia.length;++d)a.lineTo(this.ia[d].X,
this.ia[d].Y);a.closePath();b&&a.fill();c&&a.stroke()},ZH:function(a){var b;a.beginPath();a.moveTo(this.ia[0].X,this.ia[0].Y);for(b=1;b<this.ia.length;++b)a.lineTo(this.ia[b].X,this.ia[b].Y);a.stroke()},TH:function(a){a.beginPath();a.moveTo(this.ia[0].X,this.ia[0].Y);for(var b=1;b+3<=this.ia.length;)a.bezierCurveTo(this.ia[b].X,this.ia[b].Y,this.ia[b+1].X,this.ia[b+1].Y,this.ia[b+2].X,this.ia[b+2].Y),b+=3;for(;b<this.ia.length;++b)a.lineTo(this.ia[b].X,this.ia[b].Y);a.stroke()},cM:function(){var a=
1E9,b=-1E9,c=1E9,d=-1E9,e;for(e=0;e<this.ia.length;++e)this.ia[e].X<a&&(a=this.ia[e].X),this.ia[e].Y<c&&(c=this.ia[e].Y),this.ia[e].X>b&&(b=this.ia[e].X),this.ia[e].Y>d&&(d=this.ia[e].Y);return new Bb(a,c,b,d)}};var wd;wd=function(a,b,c,d){this._type=b.getUint16();switch(a){case 1:this.l=R.di(b,!0);break;case 45:this.l=R.ye(b);break;case 60:this.l=R.jF(b);break;case 61:this.l=R.iF(b)}d.Zd()&&(this.l=d.gi(this.l));this.Ek=!1;this.xM=new xd(this._type,this.l)};
wd.prototype={j:function(a){this.Ek||(this.xM.mj(a),a.g.rb.eN())},uc:function(){return this.l},Fu:function(a){this.Ek=a}};var yd;yd=function(a,b){this._type=b.getUint16();a=b.getUint16();var c=b.getUint16();this.cj=new Ja(a,c);a=b.getUint16();c=b.getUint16();this.Ps=new Ja(a,c);b=b.getUint32();this.uM=0!==(b&1);this.vM=0!==(b&2);this.et=0!==(b&4)};
yd.prototype={j:function(a){var b=a.getState().ys;var c=new I(b.X+this.Ps.L,b.Y+this.Ps.aa);if(this.et){var d=a.getState().ts;var e=c.X;c.X=d.X+this.Ps.L;d=e-c.X}else d=this.cj.L;c=new Bb(c.X,c.Y,c.X+d,c.Y+this.cj.aa);(new xd(this._type,c)).mj(a);this.uM&&(b.X+=this.cj.L);this.vM&&(b.Y+=this.cj.aa)}};var xd;xd=function(a,b){this._type=a;this.l=b.gP()};
xd.prototype={UH:function(a,b,c,d,e,f,g){a.beginPath();if("function"===typeof a.ellipse){var k=d/2;e/=2;a.ellipse(b+k,c+e,k,e,0,0,2*Math.PI)}else{k=d/2*.5522848;var l=e/2*.5522848,G=b+d,u=c+e;d=b+d/2;e=c+e/2;a.moveTo(b,e);a.bezierCurveTo(b,e-l,d-k,c,d,c);a.bezierCurveTo(d+k,c,G,e-l,G,e);a.bezierCurveTo(G,e+l,d+k,u,d,u);a.bezierCurveTo(d-k,u,b,e+l,b,e);a.closePath()}f&&a.fill();g&&a.stroke()},$H:function(a,b,c,d,e,f,g){f&&a.fillRect(b,c,d,e);g&&a.strokeRect(b,c,d,e)},WH:function(a,b,c,d,e){a.beginPath();
a.moveTo(b,c+e);a.lineTo(b+d,c);a.stroke()},mj:function(a){this.wg=a.getContext();this.Hg=a;this.x=this.l.u;this.y=this.l.v;this.w=this.l.C();this.Ec=this.l.B();this.radiusX=a.getState().ky;this.radiusY=a.getState().ly;this.fill=!a.getState().Yt();this.stroke=!a.getState().Oi;this.CC=this.l.yd;0>this.w||0>this.Ec||(this.Hg.getState().zg()&&this.Hg.getState().Co(this.l),this.NH())},NH:function(){var a=this.wg,b=this.x,c=this.y,d=this.w,e=this.Ec,f=this.radiusX,g=this.radiusY,k=this.fill,l=this.stroke,
G=this.CC;null!==G&&(a.save(),this.l.yd.Do(a,this.l));if(this.stroke&&null===this.CC){var u=R.aq(a);b+=u;c+=u}switch(this._type){case 0:this.$H(a,b,c,d,e,k,l);break;case 1:R.cE(a,b,c,d,e,k,l,f,g);break;case 2:this.UH(a,b,c,d,e,k,l);break;case 3:l&&this.WH(a,b,c,d,e);break;case 4:l&&(a.beginPath(),a.moveTo(b,c),a.lineTo(b+d,c+e),a.stroke())}null!==G&&a.restore();this.Hg.getState().zg()&&this.Hg.getState().Xl()}};var Ad;
Ad=function(a,b,c,d){if(3===a||11===a)var e=R.Nv(b);else if(46===a||47===a)e=R.lF(b);c=b.getUint32();this.dc=this.rJ(c);this.Jb=this.zM(c);this.Bw=0!==(c&16);this.BG=0!==(c&32);this.dL=0!==(c&64);this.vL=0!==(c&1024);this.et=0!==(c&2048);this.po=0!==(c&256);this.ql=0!==(c&512);this.l=R.ov(e,0!==(c&128));d.Zd()&&(this.l=d.gi(this.l));d=b.getUint16();this.ka=b.ja(d,11===a||47===a);this.Ui=R.Yp(this.ka);this.Ws=R.Jv(this.ka);this.Ef=this.ka;this.Ek=!1};
Ad.prototype={j:function(a){if(!this.Ek){this.Hg=a;this.wg=a.getContext();this.state=a.getState();if(this.dL){var b=this.state.ys;if(this.et){b=this.state.ts;var c=b.X;b=b.Y}else c=b.X,b=b.Y;a.Zd()&&(c=a.wm(c),b=a.xm(b));this.l=new Bb(c,b,c+this.l.C(),b+this.l.B())}this.OH()}},Ob:function(a){this.ka=a;this.Ui=R.Yp(this.ka);this.Ws=R.Jv(this.ka);this.Ef=this.ka},uc:function(){return this.l},Qt:function(){switch(this.dc){case 1:return"LEFT";case 2:return"RIGHT";default:return"HCENTER"}},Vt:function(){switch(this.Jb){case 1:return"TOP";
case 2:return"BOTTOM";default:return"VCENTER"}},Fu:function(a){this.Ek=a},OH:function(){var a=this.wg,b=this.state,c=this.Hg;a.save();null!==this.l.yd&&this.l.yd.Do(a,this.l);a.beginPath();a.rect(this.l.u-.5,this.l.v-.5,this.l.C()+1,this.l.B()+1);a.clip();a.fillStyle=b.hA;a.font=b.sj();var d=!1;var e=b.Gi;var f=a.font;!c.g.Yh&&(this.eG(a,c),!0===c.g.getConfiguration().AutoFontReductionActive&&this.ql||!1===c.g.getConfiguration().AutoFontReductionActive&&(this.po||this.ql))&&(d=this.iL(a,c));!1===
d&&(this.Ui?this.As(a,c):this.Mz(a));if(this.BG){d=b.ys;var g=b.ts;d.X=this.l.u;d.Y=this.l.v;this.vL&&(g.X=d.X+1,g.Y=d.Y);d.X=this.l.u+this.hM(a)}c.g.Yh||!0!==c.g.getConfiguration().AutoFontReductionActive||!1!==this.ql||(b.cD(e),b.Lg(f));a.restore()},eG:function(a,b){var c=b.getState(),d,e;if(!0===b.g.getConfiguration().AutoFontReductionActive&&!this.ql){var f=a.font;var g=c.Gi;var k=this.l.C()+1;var l=this.l.B()+1;for(d=!0;(k>this.l.C()||l>this.l.B())&&1<g;){d||(--g,c.cD(g),c.Lg(J.PO(f,g)),a.font=
c.sj());this.Ef=this.ka;this.po&&(this.Nz(a,b,!0,this.Ef,!0),this.Ui=R.Yp(this.Ef));if(this.Ui)if(l=R.ym(this.Ef),k=0,0<l.length){for(e=0;e<l.length;++e)d=a.measureText(l[e]).width,k<d&&(k=d);l=J.Pb(b)*l.length}else k=a.measureText(this.Ef).width,l=J.Pb(b);else k=a.measureText(this.Ef).width,l=J.Pb(b);d=!1}this.ka=this.Ef}},Mz:function(a){this.Ws?this.gL(a):this.Wm(a,this.ka,this.Cq(a))},As:function(a,b){var c=R.ym(this.ka),d=this,e;if(0<c.length){var f=J.Pb(b);var g=f*c.length;g-=J.BP(b);this.cG(a,
g);b=this.hG(a,g);var k=function(G){d.Wm(a,G.text,l)};for(e=0;e<c.length;++e){if(this.Ws){g=R.pq(a,c[e]);var l=this.ww(a,g);l.Y=b.Y;this.Ey(g,l,k)}else this.Wm(a,c[e],b);b.Y+=f}}},iL:function(a,b){var c;this.po?c=this.Nz(a,b,!1,this.ka,!1):this.ql&&(c=this.hL(a,b));return c},Nz:function(a,b,c,d,e){var f=!1;var g=this.l.V-this.l.u;this.Ys(a,d)>g&&(f=!0,d=this.BM(a,d,g,e),!1===c?(this.ka=d,this.As(a,b)):this.Ef=d);return f},BM:function(a,b,c,d){var e=!1,f="",g=!1,k=1;do{if(1===b.length)break;for(;this.Ys(a,
b.slice(0,k))<c;)if(k++,k===b.length){e=!0;break}1===k&&k++;if(!e){g=!1;for(var l=k-1;0<l;l--)if(this.TJ(b.charAt(l))){f+=[b.slice(0,l),"\n"].join("");b=b.slice(l+1);g=!0;break}g||(d?e=!0:(f+=[b.slice(0,k-1),"\n"].join(""),b=b.slice(k-1)));k=1}}while(!e);return!g&&d?this.ka:[f,b].join("")},TJ:function(a){return(new RegExp(/^\s$/)).test(a.charAt(0))},hL:function(a,b){this.Bw=!0;this.Ui?this.As(a,b):this.Mz(a,b);return!0},gL:function(a){var b=R.pq(a,this.ka),c=this.ww(a,b),d=this;this.Ey(b,c,function(e){d.Wm(a,
e.text,c)})},Ey:function(a,b,c){var d;if(2===this.dc)for(d=a.length-1;0<=d;--d)c(a[d]),b.X-=a[d].bv*R.ii;else for(d=0;d<a.length;++d)c(a[d]),b.X+=a[d].bv*R.ii},Wm:function(a,b,c){this.Bw&&(b=this.GI(a,b));a.fillText(b,c.X,c.Y)},GI:function(a,b){if(R.Pg(a,b,!1)<=this.l.C())return b;for(var c,d=0,e=b.length-1,f,g;1<e-d;){f=Math.floor((d+e)/2);c=b.substr(0,f)+"...";g=R.Pg(a,c,!1)-this.l.C();if(0===g)return c;0>g?(d=f,g=!1):(e=f,g=!0)}return!0===g?0<f?c.substr(0,f-1)+"...":"":c},hG:function(a,b){var c=
this.Cq(a);a.textBaseline="top";3===this.Jb?c=new I(c.X,this.l.v+this.l.B()/2-b/2):2===this.Jb&&(c=new I(c.X,c.Y-b));return c},cG:function(a,b){this.po&&3===this.Jb&&this.l.B()<b&&(this.Jb=1)},Cq:function(a){if(1===this.dc){var b=this.l.u+1;a.textAlign="left"}else 3===this.dc?(b=this.l.u+this.l.C()/2,a.textAlign="center"):(b=this.l.V-1,a.textAlign="right");if(1===this.Jb){var c=this.l.v+2;a.textBaseline="top"}else 3===this.Jb?(c=this.l.v+this.l.B()/2,a.textBaseline="middle"):(c=this.l.ca-1,a.textBaseline=
"bottom");return new I(b,c)},ww:function(a,b){a=this.Cq(a);var c,d=0;if(3===this.dc){for(c=0;c<b.length;++c)d+=b[c].bv*R.ii;a.X=this.l.u+(this.l.C()-d+R.ii)/2}return a},rJ:function(a){var b=1;0!==(a&1)?b=3:0!==(a&2)&&(b=2);return b},zM:function(a){var b=1;0!==(a&4)?b=3:0!==(a&8)&&(b=2);return b},hM:function(a){return this.Ys(a,this.ka)},Ys:function(a,b){if(this.Ui){var c=0;b=R.ym(b);var d;for(d=0;d<b.length;++d)c=Math.max(c,R.Pg(a,b[d],!0));return c}return R.Pg(a,b,!0)}};var Lb;
(function(){var a=null;Lb=function(b,c){var d=c.getUint16();this.ka=c.ja(d,15===b);this.s=R.ei(c);this.dz=1===(c.getUint32()&1)};Lb.prototype={j:function(b){var c=b.getContext(),d=b.g.so,e=R.ym(this.ka);b.g.getConfiguration().PB();var f=d.ej;var g=this.eJ(b,f);var k=this.CG(c,g,e);var l=k.size;var G=new Ja(2*f.Pj+6,2*f.Pj+4);var u=this.DG(b.Jf(),l,G,b);b.g.pa?(this.ka=this.ka.replace(/(?:\r\n|\r|\n)/g,"<br>"),this.dz?d.pP(u.u,u.v,this.ka,g.Sp):d.$M(this.ka,l,document.getElementById("background").width,
document.getElementById("background").height)):(c.save(),this.VH(c,f,u,g,G,e,k.lineHeight),this.dz&&(a=new Bb(0,0,0,0)),null!==a&&u.No(a)||this.EL(b.g,u),a=u,c.restore())},EL:function(b,c){var d=new Fa(513,b.A.la,0,0),e=Ga.D(8),f=Ac.D(e,!0);f.Dc(Math.floor(c.u));f.Dc(Math.floor(c.v));f.Dc(Math.ceil(c.V));f.Dc(Math.ceil(c.ca));d.Nb(e);b.Bb.push(d)},CG:function(b,c,d){var e=new Ja(0,0),f=b.font,g,k=0;b.font=c.Sp;for(g=0;g<d.length;++g){0===g&&(k=J.Nf(c.hE)+2);var l=R.Pg(b,d[g],!1);e.L=Math.max(e.L,
l);e.aa+=k}e.aa=Math.ceil(e.aa);e.L=Math.ceil(e.L);b.font=f;return{size:e,lineHeight:k}},DG:function(b,c,d,e){var f;if(e.g.pa){var g=document.getElementById("background").height;var k=document.getElementById("background").width;e=e.g.ba().wa().Z;e=J.Rj(e,J.Za());k<20+c.L+e.X+this.s.X?f=e.X+this.s.X-20-d.L-c.L:f=e.X+this.s.X+20;g=g<20+c.aa+e.Y+this.s.Y?e.Y+this.s.Y-c.aa+20+d.L:e.Y+this.s.Y+20}else this.s.X+20+d.L+c.L>=b.C()?f=this.s.X-20-d.L-c.L:f=this.s.X+20,this.s.Y+20+c.aa>=b.B()?g=this.s.Y-20-
c.aa:g=this.s.Y+20;0>f&&(f=c.L<b.C()?(b.C()-c.L)/2:0);0>g&&(g=c.aa<b.B()?(b.B()-c.aa)/2:0);return new Bb(f,g,f+c.L+d.L,g+d.aa+c.aa)},VH:function(b,c,d,e,f,g,k){var l=c.Pj/2;b.fillStyle=c.wv;b.fillRect(d.u,d.v,d.C(),d.B());b.lineWidth=c.Pj;b.strokeStyle=c.dv;l=new Bb(d.u+l,d.v+l,d.V-l,d.ca-l);b.strokeRect(l.u,l.v,l.C(),l.B());b.font=e.Sp;b.textBaseline="top";b.textAlign="left";b.fillStyle=c.yv;c=new I(d.u+f.L/2,d.v+f.aa/2);for(d=0;d<g.length;++d)b.fillText(g[d],c.X,c.Y),c=new I(c.X,c.Y+k)},eJ:function(b,
c){b=b.g.getConfiguration().PB();return""===b||void 0===b||null===b?c.Font:b}}})();var Bd;Bd=function(){};Bd.prototype={j:function(){}};var Cd;Cd=function(a,b){a=b.getUint16();this.bH=0===a||2===a};Cd.prototype={j:function(a){this.bH&&a.g.he.close();a.g.he.$P()}};var Dd;Dd=function(a,b,c){var d=b.ga();this.cH=b.getUint16();a=b.getUint16();this.Ww=b.ja(a,!1);c>=b.ga()-d+10?(a=b.getUint16(),this.Xw=b.ja(a,!1)):this.Xw=""};
Dd.prototype={j:function(){switch(this.cH){case 0:N.warn("The functionality start process is not possible in the webvisualization.");break;case 1:case 2:case 3:N.warn("The functionality printing is not possible in the webvisualization.");break;case 4:this.iK()}},iK:function(){"replace"===this.Xw?window.location.href=this.Ww:window.open(this.Ww)}};var Ed;Ed=function(a,b){this.pk=b.getUint8();this.pk=0===this.pk?2:3;this.gn=new Fd(b)};
Ed.prototype={j:function(a){var b=new Gd(0,this.pk,this.gn.jh,null,this.gn);a.g.Kj(b)}};var Hd;Hd=function(a,b,c,d){a=d.g.i;c=0;this.Jc=b.getUint32();d=b.getUint16();this.gt=b.ja(d,!1);d=b.getUint32();null===a.buffer&&(a.buffer=Ga.D(d));for(;c<d;)a.buffer.yo(b.getUint8()),c++;a.status.wd+=d;0!==(this.Jc&1)&&(a.status.Td?(a.status.Td=!1,a.status.te=!0):a.status.se=!0);0===d&&(a.status.se=!0)};Hd.prototype={j:function(){}};var Id;
Id=function(a,b){this.jL=b.getUint16();this.pk=b.getUint8();a=b.getUint16();this.rs=b.ja(a,!1);a=b.getUint16();0<a?this.gt=b.ja(a,!1):this.gt="";this.gn=new Fd(b)};Id.prototype={j:function(a){var b=new Gd(this.jL,this.pk,this.rs,this.gt,this.gn);a.g.Kj(b)}};var Jd;Jd=function(a,b){this.l=R.di(b,!1)};Jd.prototype={j:function(){},uc:function(){return this.l}};var Kd;
Kd=function(a,b,c,d){this.zq=b.getUint16();a=b.getUint16();this.rs=b.ja(a,!1);a=b.getUint16();this.jh=b.ja(a,!1);this.xk=b.getUint16();this.yk=[];for(c=0;c<this.xk;++c)a=b.getUint16(),this.yk[c]=b.ja(a,!1);this.mb=b.getUint32();this.Gr=b.getUint8();b=new Ld(!1,this.zq,this.rs,this.jh,this.xk,this.yk,this.mb,this.Gr);d.g.Di.Qv(b)};Kd.prototype={j:function(){}};var Md;
Md=function(a,b,c,d){this.zq=b.getUint16();a=b.getUint16();this.jh=b.ja(a,!1);this.xk=b.getUint16();this.yk=[];for(c=0;c<this.xk;++c)a=b.getUint16(),this.yk[c]=b.ja(a,!1);this.mb=b.getUint32();this.Gr=b.getUint8();b=new Ld(!0,this.zq,"",this.jh,this.xk,this.yk,this.mb,this.Gr);d.g.Di.Qv(b)};Md.prototype={j:function(){}};var Kb;Kb=function(a,b,c){a=b.ga();this.l=R.ye(b);this.Qq=!0;c>=b.ga()-a+12&&(this.Qq=0===(b.getUint32()&1))};
Kb.prototype={j:function(a){a.on.mt(this.l);this.Qq&&(a.xg().clearRect(this.l.u,this.l.v,this.l.C(),this.l.B()),J.UO(a,this.l));a.g.rb.Tl(this.l)}};var Nd;
Nd=function(a,b){var c;this.Bx=b.getUint32();this.fI=b.getUint32();a=b.getUint16();this.Zy=b.ja(a,!1);a=b.getUint32();var d=b.getUint16();this.Id=[];this.sz=!1;try{for(c=0;c<d;++c){var e=b.getUint32();var f=b.getUint32();this.Id.push(this.fo(b,e,f))}}catch(g){if(g instanceof TypeError)N.error("Invalid argumenttype for calling '"+this.Zy+"'; call will not be executed"),this.sz=!0;else throw g;}2===(a&2)?(this.ml=b.getUint32(),this.Gs=b.getUint32()):this.Gs=this.ml=null};
Nd.prototype={j:function(a){if(!this.sz){var b=WebvisuExtensionMgr.mN(this.Bx,this.Zy,this.Id);null!==b&&void 0!==b&&null!==this.Gs&&null!==this.ml&&this.kI(b,a.g)}},fo:function(a,b,c){var d=new Od;a=d.WA(a,c);return d.IC(b,a)},kI:function(a,b){var c=Ga.D(this.Gs),d=Ac.D(c,b.A.Fa,b.getConfiguration().td()),e=new Fa(515,b.A.la,this.Bx,this.fI);try{this.lI(a,d),e.Nb(c)}catch(f){N.error("Failed to encode return value: "+a.toString()+". Result ignored")}b.rd(e)},lI:function(a,b){switch(this.ml){case 0:case 1:b.Ra(a?
1:0);break;case 2:case 10:b.Ra(a);break;case 6:b.BA(a);break;case 3:case 11:b.Kb(a);break;case 7:b.Dc(a);break;case 8:b.Sd(a);break;case 9:throw new TypeError("Type LINT not supported");case 4:case 12:b.K(a);break;case 5:case 13:throw new TypeError("Type LWORD/ULINT not supported");case 14:b.Ao(a);break;case 15:b.ot(a);break;case 16:case 17:a=b.hb(a,17===this.ml);b.hc(a);break;case 18:case 19:case 20:case 21:b.K(a);break;default:throw new TypeError("TypeCode + "+this.ml.toString()+" not supported");
}}};var Pd;Pd=function(a,b){this.ge=b.getUint32();a=b.getUint16();this.ex=b.ja(a,!1);this.je=R.ye(b)};
Pd.prototype={j:function(a){var b=WebvisuExtensionMgr.rS(this.ex);if(null===b)N.warn("No native control named '"+this.ex+"' found");else{if(a.g.pa){var c=a.g.ba().wa();var d=c.Z;"function"===typeof c.hD&&c.hD(this.ge);this.je=new Bb(0,0,this.je.V,this.je.ca,this.je.yd)}else d=a.Hl().canvas;WebvisuExtensionMgr.pN(b,this.ge,this.je,d);a.g.pa&&(void 0!==d.vv?(a=d.vv,a.style.position="absolute",a.style.width="100%",a.style.height="100%"):2==d.childNodes.length&&(a=d.childNodes[1],a.style.position="absolute",
a.style.width="100%",a.style.height="100%"))}}};var Qd;Qd=function(a,b){this.ge=b.getUint32();this.je=R.ye(b)};Qd.prototype={j:function(){WebvisuExtensionMgr.nN(this.ge,this.je)}};var Rd;Rd=function(a,b){this.ge=b.getUint32();a=b.getUint32();this.PL=1===(a&1);this.GH=4===(a&4)};Rd.prototype={j:function(){this.GH?WebvisuExtensionMgr.Ht(this.ge):WebvisuExtensionMgr.oN(this.ge,this.PL)}};var Sd;
Sd=function(a,b){var c;b.getUint16();b.getUint16();this.oa=R.ye(b);var d=b.getUint32();this.lh=0!==(d&1);this.Zg=0!==(d&2);this.Lc=b.getUint16();var e=b.getUint16();this.Mc=b.ja(e,!1);this.Dm=b.getUint16();var f=b.getUint16();e=Ga.D(f);d=Ac.D(e,!0);for(c=0;c<f;++c)d.Ra(b.getUint8());this.gk=this.Jd=!1;25===a&&(d=b.getUint16(),this.Jd=0!==(d&1),this.gk=2===(d&2));a=f;0<a?(this.gk&&(a/=2),b=Mb.D(e.Wd(),b.xj(),b.Mj()),this.zn=b.ja(a,this.gk)):this.zn=""};
Sd.prototype={j:function(a){null!==a.g.oc&&a.g.oc.mq();var b=window.document.createElement("input"),c=window.document.createElement("form"),d=this.$g(),e=a.pj();b.value=this.zn;b.id="editcontrol-input";d=d.Mb(e.X,e.Y);J.Ya(b,d);b.style.zIndex=300;b.style.textAlign=0!==(this.Dm&1)?"center":0!==(this.Dm&2)?"right":"left";b.style.fontFamily=this.Mc;b.style.fontSize=this.Lc+"px";this.lh&&(b.style.fontStyle="italic");this.Zg&&(b.style.fontWeight="bold");this.Jd?(d=window.document.createElement("input"),
d.type="text",d.autocomplete="username",d.style.display="none",b.type="password",b.autocomplete="current-password",c.id="editcontrol-inputform",c.appendChild(d),c.appendChild(b),a.g.he.open(c,this.gk,a)):a.g.he.open(b,this.gk,a);b.select()},$g:function(){var a=this.oa.u+3,b=this.oa.V-9,c,d=J.Nf(this.Lc);0!==(this.Dm&8)?c=this.oa.ca-d-9:c=0!==(this.Dm&4)?this.oa.v+(this.oa.B()-d)/2:this.oa.v+1;return new Bb(a,c,b,c+d)}};var Ob;
(function(){var a=null,b=null;Ob=function(){};Ob.KD=function(c,d,e,f){null===a&&(a=[Bd,wd,vd,Ad,Td,Ud,Vd,Kb,pd,Wd,Sd,Ad,Cd,Bd,Lb,Lb,qd,Dd,Xd,Cb,Yd,Zd,Zd,rd,$d,Sd,Pd,Nd,Qd,Rd,ae,yd,be,ce,ce,de,td,ee,Bd,Bd,Bd,Fb,fe,ge,ud,wd,Ad,Ad,ae,he,ie,je,je,ke,le,me,ne,oe,pe,vd,wd,wd,Bd,Bd,Bd,Bd,qe,Id,Ed,Hd,Bd,re,se,te,ue,ve,we,xe,ye,ze,Ae,Be,Ce,De,Bd,Ee,Fe,Ge,He,Ie,Je,Ke,Le,od,Me,Bd,Ne,Bd,Oe,Pe,Qe,Re,Se,Te,Ue,nd,Ve,We,Xe,Ye,Ze,$e,af,bf,Kd,Md,Jd,cf,df,Bd,ef,ff,gf,hf,jf]);null===b&&(b=[Ib,Jb,Hb]);return c<a.length?
new a[c](c,d,e,f):8192<=c&&9215>=c&&c-8192<b.length?new b[c-8192](c,d,e,f):new Bd(c,d,e,f)}})();var R;
(function(){var a="0123456789ABCDEF".split("");var b=function(d){return a[d>>4&15]+a[d&15]};var c=function(d){return d&255};R=function(){};R.ii=50;R.pv=0;R.em=1;R.Qj=2;R.dm=3;R.ei=function(d){var e=d.getInt16();d=d.getInt16();return new I(e,d)};R.jq=function(d){var e=d.getFloat32();d=d.getFloat32();return new I(e,d)};R.sw=function(d,e){var f=[],g;for(g=0;4>g;++g)f[g]=e(d);return f};R.Nv=function(d){return R.sw(d,R.ei)};R.kF=function(d){return R.sw(d,R.jq)};R.lF=function(d){var e=[];e[0]=R.ei(d);e[2]=
R.ei(d);e[1]=new I(e[2].X,e[0].Y);e[3]=new I(e[0].X,e[2].Y);return e};R.eF=function(d){return d[1].Y!==d[0].Y||d[2].X!==d[1].X||d[3].Y<d[0].Y||d[2].X<d[1].X};R.ov=function(d,e){if(e&&R.eF(d)){e=Math.sqrt((d[0].X-d[1].X)*(d[0].X-d[1].X)+(d[0].Y-d[1].Y)*(d[0].Y-d[1].Y));var f=Math.sqrt((d[0].X-d[3].X)*(d[0].X-d[3].X)+(d[0].Y-d[3].Y)*(d[0].Y-d[3].Y));return new Bb(0,0,e,f,kf.h((d[1].X-d[0].X)/e,(d[1].Y-d[0].Y)/e,(d[3].X-d[0].X)/f,(d[3].Y-d[0].Y)/f,d[0].X,d[0].Y))}return new Bb(d[0].X,d[0].Y,d[2].X,d[2].Y)};
R.rw=function(d,e,f){d=f(d);return R.ov(d,e)};R.di=function(d,e){return R.rw(d,e,R.Nv)};R.jF=function(d){return R.rw(d,!0,R.kF)};R.qw=function(d,e){var f=e(d);d=e(d);return new Bb(f.X,f.Y,d.X,d.Y)};R.ye=function(d){return R.qw(d,R.ei)};R.iF=function(d){return R.qw(d,R.jq)};R.tw=function(d,e){var f=d.getUint16(),g;var k=Array(f);for(g=0;g<f;++g)k[g]=e(d);return k};R.Pv=function(d){return R.tw(d,R.ei)};R.qF=function(d){return R.tw(d,R.jq)};R.Fv=function(d){var e=[];0!==(d&1)&&e.push("italic");0!==(d&
2)&&e.push("bold");0!==(d&16)&&e.push("lighter");0!==(d&32)&&e.push("500");0!==(d&64)&&e.push("900");return e.join(" ")};R.Ov=function(d,e){return R.nF(d,e.g.getConfiguration().SemiTransparencyActive,e.Zd(),e.bj)};R.nF=function(d,e,f,g){var k=!0===e?R.$a(d.getUint32()):R.ib(d.getUint32());e=R.Fv(d.getUint32());var l=d.getUint16();var G=d.getUint16();d=d.ja(G,!1);f&&(f=l*g,1.01<g&&(f*=.95),l=Math.round(f));return new lf(e+" "+l+'px "'+d+'"',d,l,e,k)};R.oF=function(d,e){return R.pF(d,e.g.getConfiguration().SemiTransparencyActive,
e.Zd(),e.bj)};R.pF=function(d,e,f,g){var k;var l=!0===e?R.$a(d.getUint32()):R.ib(d.getUint32());e=R.Fv(d.getUint32());var G=d.getUint16();var u=d.getUint16();var ka=[];for(k=0;k<u;k++){var ja=d.getUint16();ka.push(d.ja(ja,!1))}f&&(d=G*g,1.01<g&&(d*=.95),G=Math.round(d));g=J.kP(ka);return new lf(e+" "+G+"px "+g,g,G,e,l)};R.gm=function(d){return Math.PI*d/180};R.ib=function(d){return"#"+b(d>>16)+b(d>>8)+b(d)};R.$a=function(d){var e=d>>24&255;if(255===e)return"#"+b(d>>16)+b(d>>8)+b(d);e/=255;return"rgba("+
c(d>>16)+", "+c(d>>8)+", "+c(d)+", "+e+")"};R.aq=function(d){return 1===d.lineWidth%2?.5:0};R.Yp=function(d){return 0<=d.indexOf("\n")||0<=d.indexOf("\r")};R.Nh=function(d,e,f){return e>d.length-1?d:d.substr(0,e)+f+d.substr(e+1)};R.fF=function(d){var e,f;var g=d.length;var k=e=0;for(f=R.pv;e<g;)switch(f){case R.pv:switch(d[e]){case "\n":f=R.Qj;break;case "\r":f=R.dm;break;default:f=R.em}break;case R.em:switch(d[e]){case "\n":f=R.Qj;k!==e&&(d=R.Nh(d,k,d[e]));k++;break;case "\r":f=R.dm;break;default:k!==
e&&(d=R.Nh(d,k,d[e])),k++}e++;break;case R.Qj:switch(d[e]){case "\n":k!==e&&(d=R.Nh(d,k,d[e]));k++;break;case "\r":f=R.dm;break;default:f=R.em,k!==e&&(d=R.Nh(d,k,d[e])),k++}e++;break;case R.dm:d=R.Nh(d,k,"\n");k++;switch(d[e]){case "\n":f=R.Qj;break;case "\r":d=R.Nh(d,k,"\n");k++;f=R.Qj;break;default:k!==e&&(d=R.Nh(d,k,d[e])),k++,f=R.em}e++}return d.substring(0,k)};R.ym=function(d){return R.fF(d).split("\n")};R.Jv=function(d){return 0<=d.indexOf("\t")};R.zF=function(d){return d.split("\t")};R.Pg=
function(d,e,f){if(f){d=R.pq(d,e);for(e=f=0;e<d.length;++e)f+=d[e].HS;return f}return d.measureText(e).width};R.TE=function(d,e,f,g){var k=d.getContext(),l=R.Pg(k,e,!0);if(void 0!==f&&void 0!==g&&l>f&&0!==(g&256)){var G=1,u=0,ka=0,ja=0,va=-1;for(g=0;g<e.length;++g){l=e.charAt(g);var Xa=e.charAt(g+1);"\r"===l&&"\n"===Xa?(++G,ka=Math.max(u,ka),u=0):(Xa=k.measureText(l).width,u+Xa<=f||0>=va?(u+=Xa," "===l&&(ja=u,va=g)):(++G,ka=Math.max(u,ja),u=u-ja+Xa))}ka=Math.max(u,ka);return new I(ka,G*J.Pb(d))}return new I(l,
J.Pb(d))};R.pq=function(d,e){e=R.zF(e);var f=[],g;for(g=0;g<e.length;++g){var k=d.measureText(e[g]).width;var l=Math.max(1,Math.ceil(k/R.ii));g<e.length-1&&(k=l*R.ii);f.push({text:e[g],bv:l,HS:k})}return f};R.PE=function(d){return null!==d.yd};R.cE=function(d,e,f,g,k,l,G,u,ka){var ja;0>u||0>ka?ja=Math.max(1,Math.min(g,k)/8):ja=u;d.beginPath();d.moveTo(e+ja,f);d.lineTo(e+g-ja,f);d.quadraticCurveTo(e+g,f,e+g,f+ja);d.lineTo(e+g,f+k-ja+.5);d.quadraticCurveTo(e+g,f+k,e+g-ja,f+k);d.lineTo(e+ja+.5,f+k);
d.quadraticCurveTo(e,f+k,e,f+k-ja+.5);d.lineTo(e,f+ja);d.quadraticCurveTo(e,f,e+ja+.5,f);d.closePath();l&&d.fill();G&&d.stroke()}})();var jf;jf=function(a,b,c,d){a=b.getUint32();!0===d.g.getConfiguration().SemiTransparencyActive?this.kb=R.$a(a):this.kb=R.ib(a)};jf.prototype={j:function(){J.Za().style.backgroundColor=this.kb}};var Oe;Oe=function(a,b){this.cK=b.getUint16();this.dK=b.getUint16();a=b.getUint16();this.ka=b.ja(a,!1)};
Oe.prototype={j:function(){var a=J.h("Message ID: {0}   Message description: {1}",this.dK,this.ka);switch(this.cK){case 0:break;case 1:N.info(a);break;case 2:N.warn(a);break;case 4:case 8:N.error(a);break;case 16:N.m(a);break;default:N.h("Unknown log level")}}};var Ve;Ve=function(a,b){this.gK=1===b.getUint16()?"copy":"source-over"};Ve.prototype={j:function(a){a.getContext().globalCompositeOperation=this.gK}};var qe;
qe=function(a,b){this.gA=b.getUint16();this.tg=b.getUint32();this.Uv=8;this.gA===this.Uv&&this.tg&&b.Lj("utf-8")};
qe.prototype={j:function(a){switch(this.gA){case 1:a=a.g.qg;null!==a&&a.VR(this.tg/100);break;case 2:a=a.g.qg;null!==a&&a.NQ(this.tg/100);break;case 3:a=a.g.qg;null!==a&&a.SR(!!this.tg);break;case 4:a.g.getConfiguration().AutoFontReductionActive=!0;break;case 6:mc.prototype.hS(0!==this.tg);break;case 7:a.g.getConfiguration().XhrSendTimeout=this.tg;break;case this.Uv:a.g.getConfiguration().vq=!!this.tg,this.tg&&(a.g.getConfiguration().ANSIStringEncoding="utf-8")}}};var $d;
$d=function(a,b){switch(b.getUint16()){case 0:this.kc="pointer";break;case 1:this.kc="default";break;case 2:this.kc="pointer";break;case 3:this.kc="wait";break;case 4:this.kc="text";break;case 5:this.kc="crosshair";break;case 6:this.kc="help";break;case 7:this.kc="col-resize";break;case 8:this.kc="row-resize";break;case 9:this.kc="nw-resize";break;case 10:this.kc="ne-resize";break;case 11:this.kc="w-resize";break;case 12:this.kc="s-resize";break;case 13:this.kc="pointer";break;default:this.kc="default"}};
$d.prototype={j:function(a){a.g.pa?(a=a.g.ba().wa(),null!==a&&(a=a.Z,null!==a&&(a.style.cursor=this.kc))):a.Hl().canvas.style.cursor=this.kc}};var Td;Td=function(a,b,c,d){a=b.getUint32();b=b.getUint32();this.xr=1===(a&1);!0===d.g.getConfiguration().SemiTransparencyActive?this.kb=R.$a(b):this.kb=R.ib(b)};Td.prototype={j:function(a){a.getState().Eu(this.kb,this.xr)},Ro:function(){return this.kb}};var Vd;Vd=function(a,b,c,d){this.od=R.Ov(b,d)};
Vd.prototype={j:function(a){a.getState().oD(this.od.Font,this.od.Size,this.od.Color)},Fh:function(){return this.od.Name},Gh:function(){return this.od.Size},Eh:function(){return this.od.Color}};var cf;cf=function(a,b,c,d){this.od=R.oF(b,d)};cf.prototype={j:function(a){a.getState().oD(this.od.Font,this.od.Size,this.od.Color)},Fh:function(){return this.od.Name},Gh:function(){return this.od.Size},Eh:function(){return this.od.Color}};var ae;
ae=function(a,b,c,d){c=1===b.getUint32();var e=b.getUint32(),f=b.getUint32();if(30===a){var g=b.getUint32();var k=b.getUint32()/100;var l=b.getUint32()/100;var G=b.getUint32();var u=0===b.getUint32();b.getUint32();b=b.getUint32()}else g=b.getUint16(),k=b.getUint8()/100,l=b.getUint8()/100,G=b.getUint8(),u=!0,b=0;!0===d.g.getConfiguration().SemiTransparencyActive?(e=R.$a(e),f=R.$a(f),30===a&&(b=R.$a(b))):(e=R.ib(e),f=R.ib(f),30===a&&(b=R.ib(b)));this.iJ=new ab(c,e,f,g,k,l,G,u,b)};ae.prototype={j:function(a){a.getState().dR(this.iJ)}};
var fe;fe=function(a,b,c,d){this.mb=b.getUint32();d.g.getConfiguration().SemiTransparencyActive=2===(this.mb&2);d.g.getConfiguration().IecSupportsCommonMiterLimit=8===(this.mb&8)};fe.prototype={j:function(a){a=a.g.qa;null!==a&&(a.g.N.dD(1===(this.mb&1)),a.xp(0!==(this.mb&4)))}};var Me;
Me=function(a,b,c){a=b.ga();var d=b.getUint16();var e=b.ja(d,!1);d=b.getUint16();d=b.ja(d,!1);""!==e&&(d=e+"."+d);this.sf=d;this.l=R.di(b,!0);this.l.normalize();e=b.getUint32();this.Lr=0!==(e&1);this.Em=0!==(e&2);this.mn=0!==(e&4);this.vr=0!==(e&128);this.Hs=0!==(e&256);this.ft=0!==(e&1024);this.Lq=0!==(e&2048);this.vh=0!==(e&4096);this.wk=!1;c>=b.ga()-a+16&&(this.wk=!0,this.en=b.getFloat32(),this.fn=b.getFloat32());this.Ea=null};
Me.prototype={j:function(a){var b=a.g.ba().wa(),c=this;this.Hg=a;window.WebvisuInst.yl(function(){var d=c.sH(c.Hg);b.hR(d,c)})},uc:function(){return this.l.clone()},sH:function(a){var b=new Image;var c=a.cg.Ih(this.sf);null===c?b.src="#":b.src=c;c=b.src;this.vh&&(b.src+="?"+J.m());J.wq(c)&&(D.lq()?this.KM():a.g.getConfiguration().WorkaroundDisableSVGAspectRatioWorkaround||(b.src+="#svgView(preserveAspectRatio(none))"));b.style.position="absolute";b.style.msUserSelect="none";b.style.WebkitUserSelect=
"none";b.style.MozUserSelect="none";b.style.userSelect="none";return b},KM:function(){N.warn("Anisotropic scaling of Svg images in Safari is not supported because of known bugs in WebKit. The default (isotropic) scaling is used instead.")}};var he;
he=function(a,b,c,d){var e;a=b.getUint16();var f=[];for(c=0;c<a;++c){var g=b.getUint16();f[c]=b.ja(g,!1)}this.ac=[];a=b.getUint16();for(c=0;c<a;++c){var k=[];g=b.getUint16();for(e=0;e<g;++e)k[e]=f[b.getUint16()];this.ac.push({ju:k.join(".").toLowerCase(),DC:b.getUint16()})}d.cg.uQ(this.ac)};he.prototype={j:function(){}};var Ud;
Ud=function(a,b,c,d){var e=b.ga(),f=b.getUint32(),g=b.getUint32();a=b.getUint16();var k=["butt","square","round"],l=["miter","bevel","round"];this.wf=f;!0===d.g.getConfiguration().SemiTransparencyActive?this.kb=R.$a(g):this.kb=R.ib(g);this.na=a;c>=b.ga()-e+11?(c=b.getUint16(),this.ff=k[0],0!==(c&0)&&(this.ff=k[0]),0!==(c&1)&&(this.ff=k[1]),0!==(c&2)&&(this.ff=k[2]),c=b.getUint16(),this.gf=l[0],0!==(c&0)&&(this.gf=l[0]),0!==(c&1)&&(this.gf=l[1]),0!==(c&2)&&(this.gf=l[2]),b=b.getUint16(),d.g.getConfiguration().IecSupportsCommonMiterLimit?
this.Of=b/2:this.Of=1===b?1.7*a:2*b):(this.ff=k[0],this.gf=l[0],d.g.getConfiguration().IecSupportsCommonMiterLimit?this.Of=1.5:this.Of=1.7*a)};Ud.prototype={j:function(a){a.getState().Hu(this.na,this.kb,this.wf,this.ff,this.gf,this.Of)},C:function(){return this.na},Ro:function(){return this.kb}};var ge;
ge=function(a,b,c){this.ya=[];var d=null;a=b.ga();for(var e,f;b.ga()-a<c-8;)e=b.getUint32(),e&2147483648?(f=b.getUint32(),d=R.ye(b),--d.ca,--d.V,d=new mf(f,d,e&2147483647),this.ya.push(d)):null!==d&&(f=e&65535,e=(e&2147483647)>>16,f=b.ga()+f,this.aL(b,d,e),b.seek(f))};
ge.prototype={j:function(a){var b=a.g.qa;if(a.g.pa){var c=a.g.ba().wa();if(null!==c&&!(c instanceof Gc)){var d=c.hd;null!==d?d.Lu(this.ya):c.kR(a.g,Xb.QD(this.ya,a.g));b.uu(c);for(d=0;d<this.ya.length;++d)this.ya[d].FQ(c),b.xo(this.ya[d],!0)}else if(null!==b)for(b.uu(null),d=0;d<this.ya.length;++d)b.xo(this.ya[d],!1)}else if(null!==b)for(b.NA(),d=0;d<this.ya.length;++d)b.xo(this.ya[d],!1);a.g.getConfiguration().DebugOnlyPrintTouchRectangles&&this.dI()},aL:function(a,b,c){switch(c){case 3:b.info().scroll().Sa().Qh(new I(a.getInt32(),
a.getInt32()));b.info().scroll().Sa().Ph(new I(a.getInt32(),a.getInt32()));b.kj(Uc.hi);break;case 4:b.info().zoom().Sa().Ju(a.getFloat32());b.info().zoom().Sa().Iu(a.getFloat32());b.kj(Uc.ow);break;case 5:b.info().HQ(new Bb(a.getUint16(),a.getUint16(),a.getUint16(),a.getUint16()));break;case 6:c=a.getUint16();var d=a.getUint16(),e=!!a.getUint8(),f=!!a.getUint8();a=new I(a.getUint16(),a.getUint16());b.info().mD(c,new nf(d,e,f,a))}},dI:function(){var a;for(a=0;a<this.ya.length;++a){var b=this.ya[a];
N.m(J.h("TouchRect ({0}): {1} (Flags: {2})",b.id(),J.gQ(b.za),b.flags()));b.$(Uc.hi)&&N.m(J.h("  ScrollLimits {0} -> {1}",J.Uc(b.info().scroll().Sa().Bc),J.Uc(b.info().scroll().Sa().Ac)));b.$(Uc.ow)&&N.m(J.h("  Zoomlimits: {0} -> {1}",b.info().zoom().Sa().Bc,b.info().zoom().Sa().Ac))}}};var Xd;Xd=function(a,b){this.uG=1===b.getUint16()};Xd.prototype={j:function(a){this.uG?a.NC():a.XP()}};var te;te=function(a,b){this.VB=b.getInt16();this.WB=b.getInt16()};
te.prototype={j:function(a){a.getState().NR(this.VB,this.WB)}};var df;df=function(a,b){a=b.getUint16();this.Ke=b.ja(a,!1);this.zk=b.getUint32();this.Ak=b.getUint16();this.wG=b.getUint32();this.hk=b.getUint32();this.Fi=b.getUint32()};df.prototype={j:function(a){var b=a.g.so;a=new Qb(this.Ke,this.Ak,this.zk,this.hk,this.wG,this.Fi);null!==b&&b.YR(a)}};var ee;ee=function(a,b){a=b.getUint16();this.ka=b.ja(a,!1)};
ee.prototype={j:function(a){a.g.getConfiguration().ChangeWindowTitle&&(window.document.title=this.ka);a.g.Oc&&window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess.setVisualizationName(this.ka)}};var Wd;Wd=function(a,b){this.l=R.ye(b)};Wd.prototype={j:function(a){a.getContext().restore();a.getState().apply()}};var gf;gf=function(a,b){this.ec=b.getUint32()};gf.prototype={j:function(a){a.g.pa&&(a=a.g.ba().wa(),a instanceof Oc&&a.yQ(this.ec))}};var hf;hf=function(a,b){this.uJ=b.getUint16()};
hf.prototype={j:function(a){a.g.pa&&(a=a.g.ba().wa(),a instanceof Oc&&a.zQ(this.uJ))}};var Re;Re=function(a,b){a=b.getInt16();this.wn=J.XB(b,a)};Re.prototype={j:function(a){var b=this.wn.length-1,c=a.g.ba();for(a=0;a<=b;++a)c.Lh()}};var xe;xe=function(a,b){this.ta=b.getInt16()};xe.prototype={j:function(a){a.g.ba().Lh()}};var ue;
ue=function(a,b){this.ta=b.getInt16();a=b.getUint32();this.pJ=0!==(a&1);this.GJ=0!==(a&2);this.nJ=0!==(a&4);this.oJ=0!==(a&16);this.lM=0!==(a&8);this.vG=0!==(a&32);this.aH=0===(a&64);this.ik=0===(a&128);this.$i=0!==(a&1024);this.Ma=new ib(a);this.En=this.Ma.cm()};
ue.prototype={j:function(a){this.kL(a);var b=Xb.SD(a.g,this.nJ,this.oJ,this.pJ,this.GJ,this.lM,this.vG,this.aH);b.$Q(this.Ma);a.g.ba().uA(this.ta,b);b instanceof Oc&&(b.WC(this.ik),b.kD(this.$i));b.initialize()},kL:function(a){this.Ma.Qc()||a.PC()}};var Ce;Ce=function(a,b){this.zc=b.getInt16()};Ce.prototype={j:function(a){a.g.ba().wa().KN()}};var ze;ze=function(a,b,c){this.zc=b.getInt16();this.Li=2<c?0!==(b.getUint32()&1):!1};
ze.prototype={j:function(a){var b=Xb.sv(32767===this.zc,this.Li,!1);a.g.ba().wa().vA(this.zc,b)}};var Pe;Pe=function(a,b){this.zc=b.getInt16()};Pe.prototype={j:function(a){a=a.g.ba().wa();32767===this.zc&&a.MC()}};var Be;Be=function(a,b){this.zc=b.getInt16()};Be.prototype={j:function(a){a.g.ba().wa().sD(this.zc)}};var Ae;
Ae=function(a,b,c){a=b.ga();this.pd=b.getInt16();this.qd=b.getInt16();this.na=b.getInt16();this.ra=b.getInt16();this.zL=0!==b.getUint8();this.AL=0!==b.getUint8();this.iG=b.getUint8();c>=b.ga()-a+9?(this.Tw=b.getInt16(),this.Uw=b.getInt16(),this.Sw=b.getInt16(),this.Rw=b.getInt16()):(this.Uw=this.Tw=0,this.Rw=this.Sw=-1)};Ae.prototype={j:function(a){a.g.ba().wa().yS(this.pd,this.qd,this.na,this.ra,this.zL,this.AL,this.iG,this.Tw,this.Uw,this.Sw,this.Rw)}};var Se;Se=function(a,b){this.si=b.getInt16()};
Se.prototype={j:function(a){var b=a.g.ba().wa();(null!==b?b.ba():a.g.ba()).SQ(this.si)}};var Ne;Ne=function(a,b){this.Gf=b.getUint8()};Ne.prototype={j:function(a){var b=a.g.ba().wa();(null!==b?b.ba():a.g.ba()).Ou(this.Gf)}};var Te;Te=function(a,b){this.wL=b.getFloat32();this.xL=b.getFloat32()};Te.prototype={j:function(a){a.g.ba().wa().aS(this.wL,this.xL)}};var Ee;
Ee=function(a,b){this.eh=b.getInt16();a=b.getInt16();switch(a){case 0:case 5:this.Ii="solid";break;case 1:this.Ii="dashed";break;case 2:case 3:case 4:this.Ii="dotted"}this.IJ=5===a;this.Hi=b.getUint32()};Ee.prototype={j:function(a){var b=this.IJ?R.$a(this.Hi&16777215):!0===a.g.getConfiguration().SemiTransparencyActive?R.$a(this.Hi):R.ib(this.Hi);a.g.ba().wa().ZQ(this.eh,this.Ii,b)}};var De;
De=function(a,b){this.Tk=b.getInt32();this.Uk=b.getInt32();this.Qk=b.getInt32();this.Rk=b.getInt32();this.lf=b.getInt32();this.mf=b.getInt32()};De.prototype={j:function(a){a.g.ba().wa().Mu(this.Tk,this.Uk,this.Qk,this.Rk,this.lf,this.mf)}};var ye;ye=function(){};ye.prototype={j:function(a){a.g.ba().su();var b=a.getContext(),c=a.g.ba().wa();b.save();b.setTransform(1,0,0,1,0,0);b.clearRect(0,0,b.canvas.width,b.canvas.height);b.restore();null!==c&&c.MA();a.g.rb.Tl(this.l)}};var Qe;
Qe=function(a,b){a=b.getInt16();this.wn=J.XB(b,a)};Qe.prototype={j:function(a){var b,c=this.wn.length-1;for(b=0;b<=c;b++)a.g.ba().Ql(this.wn[b])}};var we;we=function(a,b){this.ta=b.getInt16()};we.prototype={j:function(a){a.g.ba().Ql(this.ta)}};var ve;ve=function(a,b){this.pd=b.getInt16();this.qd=b.getInt16();this.na=b.getInt16();this.ra=b.getInt16();this.Qd=b.getInt16();this.Rd=b.getInt16();this.zh=b.getInt16();this.Ah=b.getInt16();this.jb=b.getInt16();this.nd=b.getInt16();this.Te=b.getUint32()};
ve.prototype={j:function(a){this.nd||(this.nd=0);var b=a.g.ba().wa(),c="",d=this;0<this.nd&&(c="all "+this.nd+"ms ease");if(b.ua instanceof Jc&&b.ua.kh)if(this.qd=this.pd=0,this.ra=this.na=1,this.Te=this.jb=this.Ah=this.zh=this.Rd=this.Qd=0,J.kq(b.T)){var e=document.getElementById("background");null!==e&&(this.na=e.width,this.ra=e.height)}else e=J.mm(a.g.ba(),b.T.id),null!==e?(this.na=e.rf(),this.ra=e.qf()):N.h("Could not find parent node. Size will be 0");0!==(this.Te&4)?a.g.wo(function(){d.yx(b,
c)}):this.yx(b,c)},yx:function(a,b){a.update(this.pd,this.qd,this.na,this.ra,this.Qd,this.Rd,this.zh,this.Ah,this.jb,this.Te,b)}};var Ue;Ue=function(a,b){this.pd=b.getInt16();this.qd=b.getInt16();this.na=b.getInt16();this.ra=b.getInt16();this.Qd=b.getInt16();this.Rd=b.getInt16();this.zh=b.getFloat32();this.Ah=b.getFloat32();this.jb=b.getInt16();this.nd=b.getInt16();this.Te=b.getUint32()};
Ue.prototype={j:function(a){this.nd||(this.nd=0);var b=a.g.ba().wa(),c="";0<this.nd&&(c="all "+this.nd+"ms ease");b.ua instanceof Jc&&b.ua.kh&&(this.qd=this.pd=0,this.ra=this.na=1,this.Te=this.jb=this.Ah=this.zh=this.Rd=this.Qd=0,J.kq(b.T)?(a=document.getElementById("background"),null!==a&&(this.na=a.width,this.ra=a.height)):(a=J.mm(a.g.ba(),b.T.id),null!==a?(this.na=a.rf(),this.ra=a.qf()):N.h("Could not find parent node. Size will be 0")));b.update(this.pd,this.qd,this.na,this.ra,this.Qd,this.Rd,
this.zh,this.Ah,this.jb,this.Te,c)}};var Ie;Ie=function(a,b){this.ta=b.getInt16();this.Gf=b.getInt16()};Ie.prototype={j:function(a){a.g.pa&&a.g.so.QA();a.g.jN(this.ta);a.g.ed.Ou(this.Gf)},Il:function(){return this.ta}};var Le;Le=function(a,b){this.ta=b.getInt16()};Le.prototype={j:function(a){a.g.JN()}};var He;
He=function(a,b){this.ta=b.getInt16();this.Gf=b.getInt16();a=b.getUint32();this.Aa=0!==(a&1);this.al=0!==(a&2);this.Pn=0!==(a&4);this.s={xC:0!==(a&16),hP:0!==(a&32),iP:0!==(a&128),yC:0!==(a&64),YS:0!==(a&512),zA:0!==(a&1024),nt:0!==(a&2048),ZS:0!==(a&256)};this.ln=0!==(a&8);this.it=0!==(a&4096);this.OG=0!==(a&8192);this.dH=0!==(a&16384);this.NJ=0!==(a&32768);this.$i=0!==(a&65536)};
He.prototype={j:function(a){a.g.ed.Ou(this.Gf);var b=Xb.LD(this.Aa,this.it,a.g,this.dH),c=a.g.ba().wa();c=c?c.kO():null;this.OG&&(c=J.Za().getBoundingClientRect(),this.al=!0,c=new Bb(c.x,c.y,c.x+c.width,c.y+c.height));b.kD(this.$i);b.initialize(c,this.al,this.Pn,this.ln,a.La,this.s,this.NJ);a.g.openDialog(this.ta,b)}};var Ke;Ke=function(a,b){this.ta=b.getInt16()};Ke.prototype={j:function(a){a.g.eS(this.ta)},Il:function(){return this.ta}};var Je;
Je=function(a,b){this.pd=b.getInt16();this.qd=b.getInt16();this.na=b.getInt16();this.ra=b.getInt16();this.nd=b.getInt16();a=b.getUint32();this.kb=R.$a(a)};Je.prototype={j:function(a){a=a.g.ba().wa();var b="";0<this.nd&&(b="transform "+this.nd+"ms ease, opacity "+this.nd+"ms ease");a.update(this.pd,this.qd,this.na,this.ra,0,0,0,0,0,null,b,this.kb)}};var Fd;
Fd=function(a){this.jh="";this.Fk=0;this.yq=[];this.Jc=0;if(null!==a){var b=a.getUint16(),c;a.ja(b,!1);b=a.getUint16();this.jh=a.ja(b,!1);this.Fk=a.getUint16();for(c=0;c<this.Fk;++c)b=a.getUint16(),this.yq[c]=a.ja(b,!1);this.Jc=a.getUint32();a.getUint32()}};var of;of=function(){this.xe=this.uS=0};var ec;ec=function(a){this.g=a;this.nc=[]};
ec.prototype={D:function(a,b){var c=this.tn(a);0<=c&&this.ux(c);a=new pf(this.g,a,b);this.nc.push(a);return a},aE:function(a){a instanceof Xc&&this.ux(this.WI(a.bc.id))},ux:function(a){0<=a&&(null!==this.nc[a].lc&&null!==this.nc[a].O()&&this.nc[a].lc.removeChild(this.nc[a].O()),this.nc.splice(a,1))},tn:function(a){for(var b=0;b<this.nc.length;b++)if(this.nc[b].Il()===a)return b;return-1},WI:function(a){for(var b=0;b<this.nc.length;b++)if(this.nc[b].Pw===a)return b;return-1},className:function(){return"FileTransferButtonsStorage"}};
var Gd;Gd=function(a,b,c,d,e){this.av=a;this.direction=b;this.Mh=c;this.EC=d;this.Hc=e;this.Bp=0;this.bi=new of;this.Uh=new of;this.status=new kd;this.Lb=this.buffer=null;this.UC=J.m();this.wC=!1};var Ld;Ld=function(a,b,c,d,e,f,g,k){this.stream=a;this.Hv=b;this.uP=c;this.aC=d;this.qB=e;this.filters=f;this.flags=g;this.vO=k};var dc;dc=function(a){this.g=a;this.Gn=-1;this.nc=[]};
dc.prototype={Qv:function(a){this.Gn=a.Hv;var b=this.tn(this.Gn);0>b?this.nc.push(a):this.nc[b]=a},Ev:function(a){a=this.tn(a);return 0>a?null:this.nc[a]},tF:function(){this.Gn=-1},tn:function(a){for(var b=0;b<this.nc.length;b++)if(this.nc[b].Hv===a)return b;return-1}};var kd;kd=function(){this.Ue=!0;this.se=this.te=this.Td=!1;this.Rh=this.wd=this.result=0;this.Yb=kd.xa};kd.xa=1;kd.J=2;kd.Pb=3;kd.m=4;kd.Ya=19;kd.h=20;var ff;ff=function(a,b){this.JJ=0!==b.getUint8();b.getUint8();b.getUint8()};
ff.prototype={j:function(a){a.g.pa&&(a.PC(),a=a.g.ba().wa(),this.JJ&&(a.MR(),a.xD()))}};var ef;ef=function(a,b){this.KI=b.getInt16();this.uy=0!==b.getUint8()};ef.prototype={j:function(a){if(a.g.pa){var b=a.g.ba().wa();a.aR(b,this.KI,this.uy);b.We()&&(b.vD(),b.IR(this.uy))}}};var Ge,qf;qf={IF:0,SS:1,Xv:2,vF:3,gE:4,COLOR:5};
Ge=function(a,b,c,d){var e;c=a=0;var f=d.g.fc.ub,g=new Od;this.Nd=d;this.ge=b.getUint32();d=b.getUint16();this.Id=[];for(var k=0;k<d;++k){var l=b.getUint32();var G=b.getInt8();if(G===qf.vF){var u=e=b.getUint8();b.Ad(g.SN(u))}else if(G===qf.gE||G===qf.COLOR)u=e=b.getUint16(),b.Ad(8);else if(G===qf.Xv){e=u=this.Iz(b);b.Ad(8);a=b.getInt32();c=b.getInt32();var ka=new rf(a,c)}else G===qf.IF&&(e=u=this.Iz(b),b.Ad(8));G===qf.Xv?a<=c?(l=this.fo(b,e,l,u,f,ka),ka.setData(l),this.Id.push(ka)):this.Id.push(0):
this.Id.push(this.fo(b,e,l,u,f,ka));this.Id.push(e);this.Id.push(u)}};Ge.prototype={j:function(a){var b=a.g.fc.fO(this.ge);a=a.g.ba().wa();3!==this.Id.length&&5!==this.Id.length||a.OP(b,this.Id[1]);a.YM(b,this.Id)},fo:function(a,b,c,d,e,f){var g=new Od;a=g.WA(a,c);return g.ap(b,a,this.Nd,d,e,f)},Iz:function(a){var b=a.getUint8();var c=a.getUint8()<<8;b|=c;c=a.getUint8()<<16;return b|c}};var sf;sf=function(a,b){this.da=b;this.Gk=null;this.vJ=a;this.ty=!1;this.Nq=[]};
sf.prototype={fR:function(a){this.Gk=a;this.ty=!0},BB:function(){return null===this.Gk?null:this.Gk.contentWindow},lS:function(a){this.Nq.push(a)},sQ:function(a){this.Nq.forEach(function(b){a(b)});this.Nq=[]}};var We;We=function(a,b){var c;a=b.getUint16();this.xf={};for(c=0;c<a;c++){var d=b.getUint16();d=b.ja(d,!1);var e=b.getUint32();this.xf[d]=e}};We.prototype={j:function(a){a=a.g.fc;for(var b in this.xf)this.xf.hasOwnProperty(b)&&a.NP(b,this.xf[b])}};var tf;tf=function(){this.Wk={}};
tf.prototype={Bt:function(a){return"EmbeddedBrowser"===a?window[a+"ElementFactory"].createElement():void 0!==this.Wk[a]?this.Wk[a]:null},fill:function(a,b){this.Wk={};try{var c=JSON.parse(a)}catch(k){throw new TypeError("Expected json containing a array.");}if(!(c instanceof Array))throw new TypeError("Expected json containing a array.");var d;for(d=0;d<c.length;d++){a=c[d];if(!(a instanceof Object))throw new TypeError("Expected entry to be an object.");if("string"!==typeof a.name)throw new TypeError("Expected name to be a string.");
if("string"!==typeof a.wrapper)throw new TypeError("Expected wrapper to be a string.");if(!(a.js instanceof Array))throw new TypeError("Expected js to be an Array.");if(!(a.css instanceof Array))throw new TypeError("Expected css to be an Array.");if(!J.nm(a.additionalFiles))throw new TypeError("Expected additionalFiles to be an Object.");var e=this.OB(a.js);var f=this.OB(a.css);var g=this.jO(a.additionalFiles);if(void 0!==this.Wk[a.name])throw new TypeError(J.h("There is already a native element named {0}.",
a.name));this.Wk[a.name]=new $c(a.wrapper,e,f,g,b)}},jO:function(a){var b={},c;for(c in a){if("string"!==typeof c)throw new TypeError("Only strings are expected in the object.");if("string"!==typeof a[c])throw new TypeError("Only strings are expected in the object.");b[c]=a[c]}return b},OB:function(a){var b=[],c;for(c=0;c<a.length;c++){var d=a[c];if("string"!==typeof d)throw new TypeError("Only strings are expected in the array.");b.push(d)}return b}};var Fe;Fe=function(a,b){this.ge=b.getUint32()};
Fe.prototype={j:function(a){var b=a.g.fc,c=b.ZN(this.ge),d=b.Bt(c);null!==d?(a=a.g.ba().wa(),a.pR(b,d)):N.warn("The HTML5 element '"+c+"' can not be used because it hasn't been downloaded. View Messages in the Development system for more details.")}};var ac;ac=function(a){this.Ex=new tf;this.er=new Zc;this.Sk=new Zc;this.ub=new uf;this.tk=[];this.g=a;var b=this;window.addEventListener("message",function(c){b.h(c)})};
ac.prototype={Bt:function(a){return this.Ex.Bt(a)},getConfiguration:function(){return this.g.getConfiguration()},NP:function(a,b){this.er.ru(a,b)},PP:function(a,b){this.Sk.ru(a,b)},ZN:function(a){return this.er.IB(a)},fO:function(a){return this.Sk.IB(a)},CB:function(a){return this.Sk.Rt(a)},h:function(a){if(null!==a&&void 0!==a&&J.nm(a))if("null"!==a.origin)N.h("Unhandled message: Wrong origin. "+a.origin);else if(null!==a.data&&void 0!==a.data&&J.nm(a.data)){var b=this.YN(a.data);if(null===b)N.h("Unhandled message: Unable to determine element for postMessage.");
else{a=a.data;var c=a.promiseId;if(null!==a.data&&void 0!==a.data&&J.nm(a.data))if(null!==c&&"number"!==typeof c)N.warn("Promise Id is not of type number.");else if(this.Cy(a)||b.da.Ma.Qc())try{this.Kl(a,c,b)}catch(d){N.warn("Error at handling the followig message: \n\r"+JSON.stringify(a.data,null,4)),N.warn(d.stack),this.Sc(b.da,Vc.Ng(c,d))}else N.h("Messages from preview visualizations are not supported.");else N.h("Invalid message: Wrong data.")}}else N.h("Invalid message: Wrong data.");else N.h("Invalid message.")},
Kl:function(a,b,c){var d=this;var e=J.$A(a.data.param);N.info(J.h("Message from element {0}: {1}",null!==c.Gk?c.Gk.id:c.da.bc.id,JSON.stringify(a.type)));this.Cy(a)&&this.rO(c.da);"SetValue"===a.type?vf.xa(this,c.da,b,a.data,e):"CheckValue"===a.type?vf.m(this,c.da,b,a.data,e):"SendMouseEvent"===a.type?"string"===typeof a.data.type&&"number"===typeof a.data.xPos&&"number"===typeof a.data.yPos&&c.da.pQ(a.data.type,a.data.xPos,a.data.yPos):"GetTypeDesc"===a.type?"number"===typeof a.data.typeId&&(a=this.ub.we(a.data.typeId),
this.Sc(c.da,Vc.PD(b,void 0!==a&&0!==a,a))):"SetScrollRange"===a.type?"string"===typeof a.data.methodName&&"number"===typeof a.data.startIndex&&"number"===typeof a.data.endIndex&&"number"===typeof a.data.scrollDimension&&(b=this.Sk.Rt(a.data.methodName),e=c.da,e.qQ(this.g,b,a.data.startIndex,a.data.endIndex,a.data.scrollDimension)):"CheckComplexValue"===a.type?vf.h(this,c.da,b,a.data,e):"SetComplexValue"===a.type?vf.J(this,c.da,b,a.data,e):"GetAdditionalFileName"===a.type?wf.Kl(c.da.Gd,b,a.data,function(f){d.Sc(c.da,
f)}):"GetImagePoolFileName"===a.type?xf.Kl(this.g.U().cg,b,a.data,function(f){d.Sc(c.da,f)}):"GetImageByFilename"===a.type?yf.J(c.da.Gd,b,a.data,function(f){d.Sc(c.da,f)}):"GetImageById"===a.type?yf.m(c.da.Gd,this.g.U().cg,b,a.data,function(f){d.Sc(c.da,f)}):"GetTextFile"===a.type?yf.xa(c.da.Gd,b,a.data,function(f){d.Sc(c.da,f)}):"GetBinaryFile"===a.type&&yf.h(c.da.Gd,b,a.data,function(f){d.Sc(c.da,f)})},unregister:function(a){if(a.Gd instanceof $c){var b=this.To(a);null!==b?this.tk.splice(this.tk.indexOf(b),
1):N.warn("No element data found for "+a.bc.id)}},To:function(a){if(!(a instanceof Gc))return null;var b=this.tk.find(function(c){return c.da===a});return void 0===b?null:b},YN:function(a){if(void 0===a||null===a||"string"!==typeof a.identification)return null;var b=this.tk.find(function(c){return c.vJ===a.identification});return void 0===b?null:b},rO:function(a){var b=a.sk,c=this,d=this.To(a);d.fR(b);d.sQ(function(e){c.TC(d.BB(),e)})},fill:function(a){this.Ex.fill(a,this.g.getConfiguration().DebugHTML5);
this.er=new Zc;this.Sk=new Zc},TC:function(a,b){this.tQ(a,{type:b.type(),data:b})},Sc:function(a,b){a=this.To(a);a.ty?this.TC(a.BB(),b):a.lS(b)},tQ:function(a,b){a.postMessage(b,"*")},register:function(a,b){b.Gd instanceof $c&&(null!==this.To(b)&&this.unregister(b),this.tk.push(new sf(a,b)))},Fo:function(a,b){return(new zf(this.ub)).dN(a,b)},Io:function(a,b){var c=new zf(this.ub);return Number(c.yA(a,b))},oQ:function(a,b,c,d,e,f,g,k){var l=d,G=16,u=new Od;var ka=u.vj(c,this.ub);c=u.getType(c,this.ub);
4<ka||c===Af.ji||c===Af.Qg?(l=1,G+=ka):c===Af.sq&&(l=this.Tx(d));ka=Ga.D(G);G=Ac.D(ka,this.g.A.Fa,this.g.getConfiguration().td());G.Sd(e);G.Sd(f);G.Sd(g);G.Sd(k);this.Go(G,c,d);a.BL(b,l,ka)},rQ:function(a,b,c,d){var e=d,f=null,g=new Od;var k=g.vj(c,this.ub);c=g.getType(c,this.ub);if(4<k||c===Af.ji||c===Af.Qg){f=Ga.D(k);var l=Ac.D(f,this.g.A.Fa,this.g.getConfiguration().td());e=1}else c===Af.sq&&(e=this.Tx(d));this.Go(l,c,d);a.GL(b,e,f)},fN:function(a,b){var c=new Od;var d=c.vj(a,this.ub);a=c.getType(a,
this.ub);if(4<d||a===Af.ji||a===Af.Qg)var e=Ac.D(Ga.D(d),this.g.A.Fa,this.g.getConfiguration().td());this.Go(e,a,b)},aN:function(a,b,c,d,e,f){var g=16,k=new Od;var l=k.vj(a,this.ub);a=k.getType(a,this.ub);if(4<l||a===Af.ji||a===Af.Qg)g+=l;l=Ac.D(Ga.D(g),this.g.A.Fa,this.g.getConfiguration().td());l.Sd(c);l.Sd(d);l.Sd(e);l.Sd(f);this.Go(l,a,b)},Go:function(a,b,c){switch(b){case Af.$v:a.AA(c);break;case Af.gw:case Af.dw:a.CA(c);break;case Af.aw:a.ot(c);break;case Af.ji:case Af.Qg:b=a.hb(c,b===Af.Qg),
a.hc(b)}},Tx:function(a){var b=Ga.D(4),c=this.g.A.Fa;Ac.D(b,c).Ao(a);return Mb.D(b.Wd(),c).getUint32()},Cy:function(a){return"WebvisuSupportLoaded"===a.type}};var Xe;Xe=function(a,b){var c;a=b.getUint16();this.xf={};for(c=0;c<a;c++){var d=b.getUint16();d=b.ja(d,!1);var e=b.getUint32();this.xf[d]=e}};Xe.prototype={j:function(a){a=a.g.fc;for(var b in this.xf)this.xf.hasOwnProperty(b)&&a.PP(b,this.xf[b])}};var Zc;Zc=function(){this.cs={};this.my={}};
Zc.prototype={ru:function(a,b){void 0===this.cs[a]&&(this.cs[a]=b,this.my[b]=a)},Rt:function(a){return this.cs[a]},IB:function(a){return this.my[a]}};var zf,Af,Bf,Cf;zf=function(a){this.$s=a};
zf.prototype={dN:function(a,b){var c=J.$A(b);try{if("string"===typeof b){if(a===Af.ji||a===Af.Qg)return this.Mw(b,81);var d=this.$s.we(a);if(d instanceof Df)return this.Mw(b,d.getSize())}c&&(b=this.yA(a,b));var e="number"===typeof b;if("bigint"===typeof b||e){if(e&&isNaN(b))return!1;d=this.$s.we(a);return d instanceof Ef?b>=d.LowerBorder&&b<=d.UpperBorder?!0:!1:this.By(b,a)?!0:this.SJ(b,a)?!0:!1}}catch(f){return!1}},Mw:function(a,b){return null===a||void 0===a||a.length>b-1?!1:!0},By:function(a,b){switch(b){case Af.EF:case Af.DF:return this.AO(a);
case Af.FF:case Af.NF:return this.OO(a);case Af.OF:case Af.MF:return this.MO(a);case Af.HF:case Af.LF:case Af.ew:case Af.Vv:case Af.Wv:case Af.fw:return this.LO(a);case Af.dw:case Af.gw:case Af.bw:case Af.Yv:case Af.Zv:case Af.cw:return this.NO(a);case Af.KF:return this.JO(a);case Af.JF:return this.CO(a);case Af.GF:return this.BO(a);case Af.$v:return this.EO(a);case Af.sq:return this.HO(a);case Af.aw:return this.FO(a);default:return!1}},SJ:function(a,b){return(b=this.$s.we(b))&&b instanceof Ff?this.By(a,
b.sd()):!1},AO:function(a){return 0===a||1===a},OO:function(a){return a>=Bf.ME&&a<=Bf.LE},MO:function(a){return a>=Bf.IE&&a<=Bf.HE},LO:function(a){return a>=Bf.GE&&a<=Bf.FE},NO:function(a){var b=BigInt(Cf.KE),c=BigInt(Cf.JE);var d=a;"bigint"!==typeof a&&(d=BigInt(a));return d>=b&&d<=c},JO:function(a){return a>=Bf.EE&&a<=Bf.DE},CO:function(a){return a>=Bf.wE&&a<=Bf.vE},BO:function(a){return a>=Bf.uE&&a<=Bf.tE},EO:function(a){var b=BigInt(Cf.yE),c=BigInt(Cf.xE);var d=a;"bigint"!==typeof a&&(d=BigInt(a));
return d>=b&&d<=c},HO:function(a){return a>=Bf.CE&&a<=Bf.BE},FO:function(a){return a>=Bf.AE&&a<=Bf.zE},yA:function(a,b){switch(a){case Af.ew:case Af.fw:return Number(b.valueOf());case Af.Vv:case Af.Wv:return this.QM(b.valueOf());case Af.bw:case Af.Yv:case Af.Zv:case Af.cw:return this.RM(BigInt(b.valueOf()))}return b},QM:function(a){return Math.floor(Number(a)/1E3)},RM:function(a){return BigInt(a)*BigInt(1E6)}};
Af={EF:0,DF:1,FF:2,OF:3,HF:4,dw:5,KF:6,JF:7,GF:8,$v:9,NF:10,MF:11,LF:12,gw:13,sq:14,aw:15,ji:16,Qg:17,ew:18,Vv:19,Wv:20,fw:21,bw:37,Yv:46,Zv:47,cw:48};Bf={ME:0,LE:255,IE:0,HE:65535,GE:0,FE:4294967295,EE:-128,DE:127,wE:-32768,vE:32767,uE:-2147483648,tE:2147483647,CE:-3.402823466E38,BE:3.402823466E38,AE:-1.7976931348623157E308,zE:1.7976931348623157E308};Cf={KE:"0",JE:"0xffffffffffffffff",yE:"-9223372036854775808",xE:"9223372036854775807"};var $c;
$c=function(a,b,c,d,e){this.Ci=a;this.Fn=b;this.Xq=c;this.bG=d;this.Um=e;void 0===this.Um&&(this.Um=!1);this.Um||this.Fn.push("webvisu-support.js")};
$c.prototype={Ct:function(a,b,c,d,e){b='</head><body><script nonce="'+(b+'">window["CdsInfo"] = {"TargetOrigin": "')+(window.location.origin+'", "Identification": "'+c+'"};');return b+='window["CdsInfo"]["Wrapper"] = new '+a+"("+d+", "+e+");\x3c/script></body></html>"},vN:function(a,b,c,d,e){var f=document.createElement("iframe"),g=ad.h();b=this.gH(g,b);f.setAttribute("src","about:blank");f.setAttribute("seamless","");f.setAttribute("sandbox","allow-scripts");f.setAttribute("style","border:0; width:100%; height:100%");
f.setAttribute("csp",b);if(!this.Um)return this.uN(g,a,b,f,c,d,e);var k="<!DOCTYPE html>"+J.h('<html><style nonce="{0}">* { margin:0px;}</style><head>',g);k+=J.h('<meta http-equiv="Content-Security-Policy" content="{0}">',b);k+=J.h('<script language="javascript" src="webvisu-support.js" nonce="{0}">\x3c/script>',g);0!==this.Fn.length&&this.Fn.forEach(function(l){k+=J.h('<script language="javascript" src="{0}" nonce="{1}">\x3c/script>',l,g)});0!==this.Xq.length&&this.Xq.forEach(function(l){k+=J.h('<link rel="stylesheet" href="{0}" nonce="{1}">',
l,g)});k+=this.Ct(this.Ci,g,a,c,d);f.srcdoc=k;return f},uN:function(a,b,c,d,e,f,g){var k=this;var l="<!DOCTYPE html><html><head>";l+=J.h('<style nonce="{0}">* { margin:0px;}</style>',a);l+=J.h('<meta http-equiv="Content-Security-Policy" content="{0}">',c);if(void 0!==g.Jm){if(void 0!==g.Jm[this.Ci])return l+=g.Jm[this.Ci],l=l.replaceAll("Wg3uwOo94xmWPpB",a),l+=this.Ct(this.Ci,a,b,e,f),d.srcdoc=l,d}else g.Jm={};c=k.Fn.map(function(G){return k.ON(G,a,k)});c=k.Xq.map(function(G){return k.NN(G,a,k)}).concat(c);
Promise.all(c).then(function(G){var u=G.pop();l+=u;G.forEach(function(ka){l+=ka});g.Jm[k.Ci]=l.replaceAll(a,"Wg3uwOo94xmWPpB");l+=k.Ct(k.Ci,a,b,e,f);d.srcdoc=l;return d}).catch(function(G){console.warn("Error when loading the additional files. Details:"+G)});return d},ON:function(a,b,c){return new Promise(function(d,e){c.Nt(a,"text").then(function(f){d('<script language="javascript" nonce="'+b+'">'+f+"\x3c/script>")},function(f){e(f)})})},NN:function(a,b,c){return new Promise(function(d,e){c.Nt(a,
"text").then(function(f){f=J.h('<style nonce="'+b+'"> '+f+" </style>",f,b);d(f)},function(f){e(f)})})},Nt:function(a,b){return new Promise(function(c,d){var e=new XMLHttpRequest;e.responseType=b;e.open("GET",a);e.onload=function(){4===e.readyState&&200===e.status?c(e.response):(console.error(e.statusText),d({ZP:a,status:e.status,statusText:e.statusText}))};e.onerror=function(){console.error(e.statusText);d({ZP:a,status:e.status,statusText:e.statusText})};e.send()})},h:function(a){if("string"!==typeof a)return null;
a=a.toLowerCase();a=this.bG[a];return null===a||void 0===a||"string"!==typeof a?null:a},gH:function(a,b){a=J.h("'nonce-{0}' 'unsafe-inline' {1}",a,b);var c=J.h("'self' blob: {0} {1} data:",window.location.origin,b);b=J.h("'unsafe-inline' 'self' {0} data:",b);return J.h("default-src {0}; object-src 'none'; script-src {0}; img-src {1}; style-src {2}; style-src-elem {2}; base-uri 'none';",a,c,b)}};var wf;wf=function(){};
wf.Kl=function(a,b,c,d){if("number"===typeof b&&"string"===typeof c.originalAdditionalFileName&&null!==a&&void 0!==a)c=c.originalAdditionalFileName,a=a.h(c),d(Vc.ND(b,null!==a,c,a));else throw new TypeError("Message is not in the correct format.");};var yf;yf=function(){};yf.J=function(a,b,c,d){var e=a.h(c.filename);null===e?d(Vc.Ng(b,"handleGetImageMessage Error: Could not resolve requested filename: "+c.filename)):this.Rm(a,b,"GetImageMessageResult","blob",e,d)};
yf.m=function(a,b,c,d,e){"string"===typeof d.imagePoolId&&(b=b.Ih(d.imagePoolId),null===b?e(Vc.Ng(c,"handleGetImageByIdMessage Error: Could not resolve requested filename: "+d.imagePoolId)):this.Rm(a,c,"GetImageByIdMessageResult","blob",b,e))};yf.xa=function(a,b,c,d){var e=a.h(c.filename);null===e?d(Vc.Ng(b,"handleGetTextFileMessage Error: Could not resolve requested filename: "+c.filename)):this.Rm(a,b,"GetTextFileMessageResult","",e,d)};
yf.h=function(a,b,c,d){var e=a.h(c.filename);null===e?d(Vc.Ng(b,"handleGetBinaryFileMessage Error: Could not resolve requested filename: "+c.filename)):this.Rm(a,b,"GetBinaryFileMessageResult","blob",e,d)};yf.tI=function(a,b,c){if(void 0===c||""===c)c="text";return a.Nt(b,c)};
yf.Rm=function(a,b,c,d,e,f){"string"!==typeof e&&f(Vc.Ng(b,"Message is not in the correct format. Expected "+e+" to be of type string. Is: "+typeof e));this.tI(a,e,d).then(function(g){f(new CommonAdditionalFileResultMessage(b,!0,c,e,g))},function(g){f(Vc.Ng(b,g))})};var xf;xf=function(){};xf.Kl=function(a,b,c,d){if("number"===typeof b&&"string"===typeof c.imageId)c=c.imageId,a=a.Ih(c),d(Vc.OD(b,""!==a,c,a));else throw new TypeError("Message is not in the correct format.");};var vf;vf=function(){};
vf.Yo=function(a){return"boolean"===typeof a?a?1:0:a};vf.xa=function(a,b,c,d,e){var f;if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var g=a.CB(d.methodName);var k=b.Uo(d.methodName);var l=this.Yo(d.param);if(f=a.Fo(k,l)){e&&(l=a.Io(k,l));try{a.rQ(b,g,k,l)}catch(G){f=!1}}a.Sc(b,Vc.WD(c,f,d.param))};
vf.m=function(a,b,c,d,e){var f;if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var g=b.Uo(d.methodName);var k=this.Yo(d.param);if(f=a.Fo(g,k)){e&&(k=a.Io(g,k));try{a.fN(g,k)}catch(l){f=!1}}a.Sc(b,Vc.JD(c,f,d.param))};
vf.J=function(a,b,c,d,e){if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.index0||"number"!==typeof d.index1||"number"!==typeof d.index2||"number"!==typeof d.indexCount||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var f=a.ub;var g=a.CB(d.methodName);var k=f.we(b.Uo(d.methodName));var l=this.Yo(d.param);if(k instanceof Gf||k instanceof Hf){var G=
k.sd(f,d.indexCount,d.index0,d.index1,d.index2);k=a.Fo(G,l)}else k=!1;if(k){e&&(l=a.Io(G,l));try{a.oQ(b,g,G,l,d.index0,d.index1,d.index2,d.indexCount)}catch(u){k=!1}}a.Sc(b,Vc.VD(c,k,d.param,d.indexCount,d.index0,d.index1,d.index2))};
vf.h=function(a,b,c,d,e){if("number"!==typeof c||"string"!==typeof d.methodName||"number"!==typeof d.indexCount||"number"!==typeof d.index0||"number"!==typeof d.index1||"number"!==typeof d.index2||"number"!==typeof d.param&&"bigint"!==typeof d.param&&"boolean"!==typeof d.param&&"string"!==typeof d.param&&!e)throw new TypeError("Message is not in the correct format.");var f=a.ub;var g=f.we(b.Uo(d.methodName));var k=this.Yo(d.param);if(g instanceof Gf||g instanceof Hf){var l=g.sd(f,d.indexCount,d.index0,
d.index1,d.index2);g=a.Fo(l,k)}else g=!1;if(g){e&&(k=a.Io(l,k));try{a.aN(l,k,d.index0,d.index1,d.index2,d.indexCount)}catch(G){g=!1}}a.Sc(b,Vc.ID(c,g,d.param,d.indexCount,d.index0,d.index1,d.index2))};var CheckComplexValueResultMessage;CheckComplexValueResultMessage=function(){this.index2=this.index1=this.index0=this.indexCount=this.value=this.result=this.promiseId=null};CheckComplexValueResultMessage.prototype={type:function(){return"CheckComplexValueResult"}};var CheckSimpleValueResultMessage;
CheckSimpleValueResultMessage=function(){this.value=this.result=this.promiseId=null};CheckSimpleValueResultMessage.prototype={type:function(){return"CheckSimpleValueResult"}};var CommonAdditionalFileResultMessage;CommonAdditionalFileResultMessage=function(a,b,c,d,e){this.promiseId=a;this.result=b;this._type=c;this.requestFilename=d;this.responseContent=e};CommonAdditionalFileResultMessage.prototype={type:function(){return this._type?this._type:"CommonAdditionalFileResult"}};var Wc;
Wc=function(){this.error=this.promiseId=null};Wc.prototype={type:function(){return"ErrorMessage"}};var GetAdditionalFileNameResultMessage;GetAdditionalFileNameResultMessage=function(){this.resultingAdditionalFileName=this.originalAdditionalFileName=this.result=this.promiseId=null};GetAdditionalFileNameResultMessage.prototype={type:function(){return"GetAdditionalFileNameResult"}};var GetImagePoolFileNameResultMessage;
GetImagePoolFileNameResultMessage=function(){this.resultingFileName=this.imageId=this.result=this.promiseId=null};GetImagePoolFileNameResultMessage.prototype={type:function(){return"GetImagePoolFileNameResult"}};var GetTypeDescResultMessage;GetTypeDescResultMessage=function(){this.typeDesc=this.result=this.promiseId=null};GetTypeDescResultMessage.prototype={type:function(){return"GetTypeDescResult"}};var MethodCallMessage;MethodCallMessage=function(){this.params=this.methodName=null};
MethodCallMessage.prototype={type:function(){return"MethodCall"}};var ResizeMessage;ResizeMessage=function(){this.height=this.width=null};ResizeMessage.prototype={type:function(){return"Resize"}};var SetComplexValueResultMessage;SetComplexValueResultMessage=function(){this.index2=this.index1=this.index0=this.indexCount=this.value=this.result=this.promiseId=null};SetComplexValueResultMessage.prototype={type:function(){return"SetComplexValueResult"}};var SetSimpleValueResultMessage;
SetSimpleValueResultMessage=function(){this.value=this.result=this.promiseId=null};SetSimpleValueResultMessage.prototype={type:function(){return"SetSimpleValueResult"}};var If;If=function(a,b){this.MinRange=a;this.MaxRange=b};If.prototype={};var rf;rf=function(a,b){this.Data=0;this.StartIndex=a;this.EndIndex=b;this.ScrollDimension=0};rf.prototype={setData:function(a){this.Data=a}};var uf;uf=function(){this.zr={}};uf.prototype={Ul:function(a,b){void 0===this.zr[b]&&(this.zr[b]=a)},we:function(a){return this.zr[a]}};
var bf;bf=function(a,b,c,d){a=d.g.fc;this.id=b.getUint32();this.size=b.getUint32();this.type=b.getUint32();b=new Df(this.size,this.type);a.ub.Ul(b,this.id)};bf.prototype={j:function(){}};var Ze;Ze=function(a,b,c,d){a=d.g.fc;this.id=b.getUint32();this.size=b.getUint32();this.sS=b.getUint32();c=b.getUint16();this._dimensions=[];for(var e=0;e<c;++e){d=b.getUint32();var f=b.getUint32();this._dimensions.push(new If(d,f))}b=new Gf(this.size,this.sS,this._dimensions);a.ub.Ul(b,this.id)};Ze.prototype={j:function(){}};
var Ye;Ye=function(a,b,c,d){a=d.g.fc;d=new Od;this.id=b.getUint32();this.HA=b.getUint32();c=b.getUint16();this._enumValues={};for(var e=0;e<c;++e){var f=b.getUint16();var g=b.ja(f,!1);f=b.Yd();this._enumValues[g]=f}b=new Ff(this.HA,d.vj(this.HA,a.ub),this._enumValues);a.ub.Ul(b,this.id)};Ye.prototype={j:function(){}};var $e;
$e=function(a,b,c,d){a=d.g.fc;this.id=b.getUint32();this.size=b.getUint32();c=b.getUint32();this.Zw=[];for(var e=0;e<c;++e){d=b.getUint32();var f=b.getUint32();this.Zw.push(new Jf(d,f))}b=new Hf(this.size,this.Zw);a.ub.Ul(b,this.id)};$e.prototype={j:function(){}};var af;af=function(a,b,c,d){a=d.g.fc;this.id=b.getUint32();this.type=b.getUint32();this.ZO=b.Xd();this.AS=b.Xd();b=new Ef(this.type,this.ZO,this.AS);a.ub.Ul(b,this.id)};af.prototype={j:function(){}};var Jf;
Jf=function(a,b){this.TypeId=a;this.Offset=b};Jf.prototype={};var Od;Od=function(){};
Od.prototype={KO:function(a){return 0<=a&&48>=a},getType:function(a,b){if(this.KO(a))return a;var c=b.we(a);if(c instanceof Gf)return this.getType(c.sd(),b);if(c instanceof Df)return this.getType(c.getType(),b);if(c instanceof Ff)return this.getType(c.sd(),b);throw new TypeError("Cannot determine type for "+a.toString());},SN:function(a){switch(a){case 4:case 8:case 12:case 14:case 18:case 21:case 19:case 20:return 4;case 5:case 13:case 9:case 15:return 8}return 0},WA:function(a,b){var c=Ga.D(b),
d=Ac.D(c,!0),e;for(e=0;e<b;++e)d.Ra(a.getUint8());a=Mb.D(c.Wd(),a.xj(),a.Mj());return new Nb(a)},ap:function(a,b,c,d,e,f){var g=e.we(d);void 0===g&&(g=e.we(a));if(g instanceof Gf||g instanceof Hf)return g.VA(b,c,e,f);if(998===d)return R.Ov(b,c);if(997===d)return a=b.getUint32(),R.$a(a);g instanceof Ff?a=g.sd():g instanceof Df?a=g.getType():g instanceof Ef&&(a=g.getType());return this.IC(a,b)},IC:function(a,b){switch(a){case 0:case 1:return 0!==b.getUint8();case 2:case 10:return b.getUint8();case 6:return b.getInt8();
case 3:case 11:return b.getUint16();case 7:return b.getInt16();case 8:return b.getInt32();case 9:return b.Xd();case 4:case 12:return b.getUint32();case 5:case 13:return b.Yd();case 14:return b.getFloat32();case 15:return b.getFloat64();case 16:case 17:return b.Xe(17===a);case 18:return b.getUint32();case 19:case 20:case 21:return b=b.getUint32(),this.fH(b,a);case 26:case 28:return b;default:throw new TypeError("TypeCode + "+a.toString()+" not supported");}},vj:function(a,b){switch(a){case 0:case 1:case 2:case 10:case 6:return 1;
case 3:case 11:case 7:return 2;case 8:return 4;case 9:return 8;case 4:case 12:return 4;case 5:case 13:return 8;case 14:return 4;case 15:return 8;case 16:return 81;case 17:return 162;case 18:case 19:case 20:case 21:return 4;default:b=b.we(a);if(b instanceof Gf||b instanceof Hf||b instanceof Df||b instanceof Ff)return b.getSize();throw new TypeError("TypeCode + "+a.toString()+" cannot determine type size");}},sd:function(a,b,c,d,e){if(1E3<=a){var f=b.we(a);if(f instanceof Gf||f instanceof Hf)return f.sd(b,
c,d,e,0);if(f instanceof Df)return a;if(f instanceof Ff)return f.sd();throw new TypeError("SystemTypeClass: wrong base type id");}return a},fH:function(a,b){a=21===b?new Date(a):new Date(1E3*a);if(19===b)a.setHours(0,0,0,0);else if(21===b)return b=new Date(0),b.setHours(a.getHours()),b.setMinutes(a.getMinutes()),b.setSeconds(a.getSeconds()),b.setMilliseconds(a.getMilliseconds()),b;return a}};var Gf;Gf=function(a,b,c){this.Size=a;this.BaseTypeId=b;this.Dimensions=c};
Gf.prototype={getSize:function(){return this.Size},sd:function(a,b,c,d,e){if(1<=this.Dimensions.length)return(new Od).sd(this.BaseTypeId,a,b-1,d,e);throw new TypeError("TypeDescArray with no dimensions");},VA:function(a,b,c,d){if(1<=this.Dimensions.length){var e=this.Dimensions[0],f=[],g=0,k=new Od,l=a.ga();var G=k.vj(this.BaseTypeId,c);var u=e.MinRange;e=e.MaxRange;void 0!==d&&d instanceof rf&&(u=d.StartIndex,e=d.EndIndex);for(d=u;d<=e;d++)if(2<=this.Dimensions.length){var ka=this.Dimensions[1],
ja=[];for(u=ka.MinRange;u<=ka.MaxRange;u++)a.seek(l+g*G),ja.push(k.ap(this.BaseTypeId,a,b,this.BaseTypeId,c)),g++;f.push(ja)}else a.seek(l+g*G),f.push(k.ap(this.BaseTypeId,a,b,this.BaseTypeId,c)),g++;return f}throw new TypeError("TypeDescArray with no dimensions");}};var Ff;Ff=function(a,b,c){this.BaseTypeId=a;this.DD=b;this.EnumValues=c};Ff.prototype={getSize:function(){return this.DD},sd:function(){return this.BaseTypeId}};var lf;
lf=function(a,b,c,d,e){this.Font=a;this.Name=b;this.Size=c;this.Style=d;this.Color=e};lf.prototype={sj:function(){return this.Font},getSize:function(){return this.Size},Ro:function(){return this.Color}};var Df;Df=function(a,b){this.Size=a;this.TypeId=b};Df.prototype={getSize:function(){return this.Size},getType:function(){return this.TypeId}};var Hf;Hf=function(a,b){this.Size=a;this.Components=b};
Hf.prototype={getSize:function(){return this.Size},sd:function(a,b,c,d,e){if(0<this.Components.length&&0<b)return(new Od).sd(this.Components[c].TypeId,a,b-1,d,e);throw new TypeError("TypeDescStruct with no components");},VA:function(a,b,c,d){if(0<this.Components.length){var e=[],f=new Od,g=a.ga();var k=0;var l=this.Components.length-1;void 0!==d&&d instanceof rf&&(k=d.StartIndex,l=d.EndIndex);for(d=k;d<=l;d++)a.seek(g+this.Components[d].Offset),e.push(f.ap(this.Components[d].TypeId,a,b,this.Components[d],
c));return e}throw new TypeError("TypeDescStruct with no components");}};var Ef;Ef=function(a,b,c){this.TypeId=a;this.LowerBorder=b;this.UpperBorder=c};Ef.prototype={getType:function(){return this.TypeId}};var Yd;Yd=function(){};Yd.prototype={j:function(){N.warn("The functionality ExecuteClientProgram is not possible in the webvisualization.")}};var Zd;Zd=function(){};Zd.prototype={j:function(){N.warn("The functionality OpenFileDialog is not possible in the webvisualization.")}};var Kf;
Kf=function(a,b){this.oa=a;this.Iq=this.Jq=-1;this.ir=!1;this.Nx=this.Mx=1;b.Zd()&&(this.oa=b.gi(this.oa));this.Ea=null};
Kf.prototype={j:function(a){var b=new Bb(0,0,document.documentElement.clientWidth,document.documentElement.clientHeight);var c=new xd(0,b);var d=!0===a.g.getConfiguration().SemiTransparencyActive?R.$a(this.Iq):R.ib(this.Iq);a.getState().Hu(1,d,0,"","",0);a.getState().Eu(d,!1);c.mj(a);c=new xd(0,this.oa);d=!0===a.g.getConfiguration().SemiTransparencyActive?R.$a(this.Jq):R.ib(this.Jq);a.getState().Hu(1,d,0,"","",0);a.getState().Eu(d,!1);c.mj(a);null!==this.Ea&&this.Ea.loaded()&&(a.hC()&&this.ir?this.rk(a,
this.Ea,b):this.rk(a,this.Ea,this.oa))},wQ:function(a){this.Jq=a},vQ:function(a){this.Iq=a},xQ:function(a){this.Ea=a},TQ:function(a){this.ir=a},UQ:function(a){this.Mx=a},VQ:function(a){this.Nx=a},rk:function(a,b,c){if(a.Zd()){var d=b.Wo();if(a.hC()&&this.ir){var e=this.Mx;var f=this.Nx}else e=a.jo,f=a.bj;d=new Ja(Math.round(e*d.L),Math.round(f*d.aa));c=J.fq(c,d,this);a.getContext().drawImage(b.Vo(),c.u,c.v,c.C(),c.B())}else a.getContext().drawImage(b.Vo(),c.u,c.v)}};var Lf;
Lf=function(a,b,c){this.oa=a;this.Kq=this.fj=!0;this.o=window.document.createElement("button");this.vb=null!==c&&void 0!==c?c:b.La.canvas.parentNode;this.bo=0;this.hk=1;this.kf=this.Fe="#000000";this.Hb=-1;this.ta="";this.xs=!1};
Lf.prototype={j:function(a){a=a.pj();var b=null,c=this;b=this.oa.Mb(a.X,a.Y);J.Ya(this.o,b);this.xs&&(this.o.style.position="relative",this.o.style.left="0px",this.o.style.top="0px");this.fj&&(this.o.style.background="transparent",this.o.style.color="transparent");this.Kq?(this.o.style.borderRadius=J.h("{0}px",this.bo),this.o.style.borderWidth=J.h("{0}px",this.hk),this.o.style.borderColor=this.Fe===this.kf?this.Fe:J.h("{0} {0} {0} {0}",this.Fe,this.Fe,this.kf,this.kf)):this.o.style.border="none";
this.o.tabIndex=this.Hb;this.o.addEventListener("keydown",function(d){c.bx(d)});this.vb.appendChild(this.o)},bx:function(a){if(32===a.keyCode||13===a.keyCode){var b=null;a.stopPropagation();D.Qb()?b=new PointerEvent("pointerup"):b=new MouseEvent("mouseup");this.o.dispatchEvent(b)}},Vb:function(){return this.o},be:function(a){this.oa=a},setRadius:function(a){this.bo=a},DQ:function(a){this.hk=a},CQ:function(a){this.Fe=a},BQ:function(a){this.kf=a},Ze:function(a){this.Hb=a},AQ:function(a){this.Kq=a},
pt:function(a){this.ta=a;this.o.id=this.ta},Il:function(){return this.ta},remove:function(){if(null!==this.o){var a=this;this.o.removeEventListener("keydown",function(b){a.bx(b)});this.o.parentElement===this.vb&&this.vb.removeChild(this.o)}},TB:function(){return null!==this.o?null!==this.o.parentElement:!1}};var Mf;
Mf=function(a,b){this.oa=a;this.Kq=this.fj=!0;this.o=window.document.createElement("div");this.vb=b.La.canvas.parentNode;this.bo=0;this.hk=1;this.kf=this.Fe="#000000";this.Hb=-1;this.ta="";this.xs=!1;this.re="";this.Fx=!0};
Mf.prototype={j:function(a){a=a.pj();var b=null,c=this;b=this.oa.Mb(a.X,a.Y);J.Ya(this.o,b);this.xs&&(this.o.style.position="relative",this.o.style.left="0px",this.o.style.top="0px");this.fj&&(this.o.style.background="transparent",this.o.style.color="transparent");this.o.style.border="none";this.o.tabIndex=this.Hb;this.Ed=document.createElement("input");this.Ed.type="checkbox";this.Ed.style.opacity="1";this.Ed.style.width="90%";this.Ed.style.height="90%";this.Ed.style.left="-5px";this.Ed.style.top=
"-2px";this.Ed.style.position="absolute";this.Ed.style.cursor="pointer";this.uf=document.createElement("div");this.uf.style.width="100%";this.uf.style.height="100%";this.uf.style.backgroundSize="contain";this.uf.style.backgroundRepeat="no-repeat";this.uf.style.borderRadius="4px";this.uf.style.cursor="pointer";this.Fx?this.Ed.addEventListener("change",function(){c.ax()}):(this.uf.style.opacity="0.4",this.uf.title=this.re);this.o.appendChild(this.Ed);this.o.appendChild(this.uf);this.vb.appendChild(this.o)},
ax:function(){var a=new CustomEvent("checkboxChanged",{detail:{checked:this.Ed.checked}});this.o.dispatchEvent(a)},Vb:function(){return this.o},be:function(a){this.oa=a},setRadius:function(a){this.bo=a},Ze:function(a){this.Hb=a},pt:function(a){this.ta=a;this.o.id=this.ta},Il:function(){return this.ta},remove:function(){if(null!==this.o){var a=this;this.Fx&&this.Ed.removeEventListener("change",function(){a.ax()});this.o.parentElement===this.vb&&this.vb.removeChild(this.o)}},TB:function(){return null!==
this.o?null!==this.o.parentElement:!1}};var pf;pf=function(a,b,c){this.g=a;this.ta=b;this.l=c;this.Tg=this.br=this.lc=this.bc=null;this.Hb=Wa.J;this.Pw="";this.jy=1;this.ks=!1;this.Zs=this.nb=-1;this.Xk=null};
pf.prototype={j:function(a){if(null===this.Tg){var b=a.g.ba().wa();if(null!==b&&(this.l=b.uc(),0===this.jy?this.lc=b.getParent():(this.lc=b.O(),this.br=b.Z,this.l=new Bb(0,0,this.l.C(),this.l.B())),this.Pw=b.bc.id,null!==this.lc)){var c=window.document.createElement("div");c.id="FTButtonElement_"+this.ta;0===this.jy&&J.kq(this.lc)&&(this.lc=b.O(),this.lc=window.document.body);this.lc.appendChild(c);this.bc=c}this.Ie()}null!==this.Tg&&this.Tg.j(a)},O:function(){return this.bc},Il:function(){return this.ta},
Ie:function(){this.jH();var a=document.getElementById("FTButton_"+this.ta);if(null===a||void 0===a)this.mH(this.ta),this.lH(this.ta,this.l)},lH:function(a,b){var c=this;this.Tg=this.el(a,b);this.Tg.Vb().addEventListener(D.Qb()?"pointerup":"mouseup",function(d){c.$r(d,a)},!1);this.Tg.Vb().addEventListener(D.Qb()?"pointerdown":"mousedown",function(d){c.$r(d,a)},!1);this.Tg.Vb().addEventListener(D.Qb()?"pointermove":"mousemove",function(d){c.$r(d,a)},!1)},mH:function(a){var b=this;var c=window.document.createElement("input");
c.id="FTButtonFile_"+a;c.type="file";c.style.display="none";c.addEventListener("change",function(d){b.oK(d,a)},!1);this.bc.appendChild(c)},jH:function(){if(null===this.bc){var a="FTButtonElement_"+this.ta;var b=document.getElementById(a);if(null===b||void 0===b)b=window.document.createElement("div"),b.id=a,a=window.document.body,null!==a&&void 0!==a&&(a.appendChild(b),this.lc=a);this.bc=b}},$r:function(a,b){var c=1;var d=this.g.Di.Ev(b);null!==d&&(c=d.vO,1!==c&&2!==c&&6!==c&&(c=1));d=this.nA(a.type);
if("pointerup"===d){if(this.qM(a),1===c||6===c)this.hz(b),this.g.Bi.rp(-123)}else"pointerdown"===d?(this.RH(a),2===c&&(this.hz(b),this.g.Bi.rp(-123))):"pointermove"===d&&this.hK(a,b)},hz:function(a){var b=document.getElementById("FTButtonFile_"+a),c=null,d=null,e=this;d=d=null;null!==b&&void 0!==b&&(c=this.g.Di.Ev(a),d=this.g.i,null!==c&&null===d&&(this.ks=!1,this.Zs=0,this.ho(),this.Xk=function(){e.qK()},window.addEventListener("focus",this.Xk,!1),d=new Fd(null),d.jh=c.aC,d.Fk=c.qB,d.yq=c.filters,
d.Jc=c.flags,d=c.stream?new Gd(0,3,c.aC,"",d):new Gd(a,1,c.uP,"",d),d.wC=!0,d.status.Ue=!1,this.g.Kj(d),b.accept=Nf.h(c.qB,c.filters),b.click()))},oK:function(a){this.ks=!0;Nf.m(a,this.g);this.ho()},qK:function(){var a=this;this.nb=window.setInterval(function(){a.II()},250)},II:function(){if(this.ks)this.ho();else if(this.Zs++,3<this.Zs){this.ho();var a=this.g.i;null!==a&&(a.status.Yb=kd.m,N.info("File Transfer cancelled"))}},ho:function(){null!==this.Xk&&(window.removeEventListener("focus",this.Xk,
!1),this.Xk=null);clearInterval(this.nb)},RH:function(a){this.pr(a,"mousedown")},qM:function(a){this.pr(a,"mouseup")},hK:function(a,b){this.pr(a,"mousemove");this.KL(b)},pr:function(a,b){a.preventDefault();a.stopPropagation();var c=null===this.br?this.g.Za():this.br;null!==c&&void 0!==c&&this.WK(b,c,a.pageX,a.pageY)},KL:function(a){a=document.getElementById("FTButton_"+a);null!==a&&void 0!==a&&(a.style.cursor="pointer")},el:function(a,b){b=new Lf(b,this.g.U(),this.bc);b.pt("FTButton_"+a);b.AQ(!1);
b.Ze(this.Hb++);return b},WK:function(a,b,c,d){var e={bubbles:!0,cancelable:"mousemove"!==a,view:window,detail:0,screenX:c,screenY:d,clientX:c,clientY:d,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:b};if(D.Qb()){a=this.nA(a);var f={};this.yJ(f,e,b);f.pointerType="mouse";a=new PointerEvent(a,f)}else a=new MouseEvent(a,e);this.AH(a,c,d,b)},yJ:function(a,b,c){a.isPrimary=!0;a.bubbles=b.bubbles;a.cancelable=b.cancelable;a.view=b.view;a.detail=b.detail;a.screenX=b.screenX;a.clientX=
b.clientX;a.screenY=b.screenY;a.clientY=b.clientY;a.ctrlKey=b.ctrlKey;a.altKey=b.altKey;a.shiftKey=b.shiftKey;a.metaKey=b.metaKey;a.button=b.button;a.relatedTarget=c;a.pointerId=-123},AH:function(a,b,c,d){Object.defineProperty(a,"layerX",{value:b});Object.defineProperty(a,"layerY",{value:c});a.button=1;a.which=1;d.dispatchEvent(a)},nA:function(a){switch(a){case "touchmove":case "mousemove":return"pointermove";case "touchup":case "mouseup":return"pointerup";case "touchdown":case "mousedown":return"pointerdown";
default:return a}}};var Of;Of=function(a,b,c){this.oa=a;this.Lc=12;this.zn="";this.dc="HCENTER";this.Jb="VCENTER";this.Mc="";this.Zg=this.lh=!1;this.Jd=b;this.o=window.document.createElement("input");this.vb=c.La.canvas.parentNode;this.gh=this.eg=null;this.Hb=-1;this.qs="";this.Qf="#FFFFFF";this.kb="#000000"};
Of.prototype={j:function(a){var b=this.$g();a=a.pj();b=b.Mb(a.X,a.Y);J.Ya(this.o,b);this.o.style.zIndex=300;this.o.style.textAlign="HCENTER"===this.dc?"center":"RIGHT"===this.dc?"right":"left";this.o.style.fontFamily=this.Mc;this.o.style.fontSize=this.Lc+"px";this.lh&&(this.o.style.fontStyle="italic");this.Zg&&(this.o.style.fontWeight="bold");this.Jd?(b=document.getElementsByTagName("input"),0===b.length?(this.gh=window.document.createElement("input"),this.gh.type="text",this.gh.autocomplete="username",
this.gh.style.display="none",b=this.gh):b=b[0],this.eg=window.document.createElement("form"),this.o.type="password",this.o.autocomplete="current-password",this.eg.appendChild(b),this.eg.appendChild(this.o),this.vb.appendChild(this.eg)):(this.o.autocomplete="username",this.vb.appendChild(this.o));""!==this.qs&&(this.o.placeholder=this.qs);this.o.style.border="none";this.o.style.backgroundColor=this.Qf;this.o.style.color=this.kb;this.o.tabIndex=this.Hb},Vb:function(){return this.o},Lg:function(a,b){this.Mc=
a;this.Lc=b},Zl:function(a,b){this.dc=a;this.Jb=b},be:function(a){this.oa=a},Ze:function(a){this.Hb=a},BR:function(a){this.qs=a},Ij:function(a){this.Qf=a},setColor:function(a){this.kb=a},remove:function(){null!==this.eg?(null!==this.gh&&this.eg.removeChild(this.gh),null!==this.o&&this.eg.removeChild(this.o),this.vb.removeChild(this.eg)):null!==this.o&&this.o.parentElement===this.vb&&this.vb.removeChild(this.o)},$g:function(){var a=this.oa.u+3,b=this.oa.V-9,c,d=J.Nf(this.Lc);"BOTTOM"===this.Jb?c=this.oa.ca-
d-9:c="VCENTER"===this.Jb?this.oa.v+(this.oa.B()-d)/2:this.oa.v+1;return new Bb(a,c,b,c+d)}};var Pf;Pf=function(a){this.l=a;this.Qq=!0};Pf.prototype=Object.create(Kb.prototype);Pf.prototype.constructor=Pf;var Qf;Qf=function(a,b){this.oa=a;this.Lc=12;this.zn="";this.dc="HCENTER";this.Jb="VCENTER";this.Mc="";this.Zg=this.lh=!1;this.o=window.document.createElement("select");this.vb=b.La.canvas.parentNode;this.Hb=-1;this.Qf="#FFFFFF";this.kb="#000000";this.Dy=[];this.Tz=""};
Qf.prototype={j:function(a){var b=this.$g(),c=this;a=a.pj();b=b.Mb(a.X,a.Y);J.Ya(this.o,b);this.o.style.zIndex=300;this.o.style.textAlign="HCENTER"===this.dc?"center":"RIGHT"===this.dc?"right":"left";this.o.style.fontFamily=this.Mc;this.o.style.fontSize=this.Lc+"px";this.lh&&(this.o.style.fontStyle="italic");this.Zg&&(this.o.style.fontWeight="bold");this.Dy.forEach(function(d){var e=window.document.createElement("option");e.value=d;e.text=d;e.selected=c.Tz.toUpperCase()===d.toUpperCase()?!0:!1;c.o.appendChild(e)});
this.vb.appendChild(this.o);this.o.style.border="none";this.o.style.backgroundColor=this.Qf;this.o.style.color=this.kb;this.o.tabIndex=this.Hb},Vb:function(){return this.o},Lg:function(a,b){this.Mc=a;this.Lc=b},Zl:function(a,b){this.dc=a;this.Jb=b},be:function(a){this.oa=a},Ze:function(a){this.Hb=a},Ij:function(a){this.Qf=a},setColor:function(a){this.kb=a},mR:function(a){this.Dy=a},nD:function(a){this.Tz=a},remove:function(){null!==this.o&&this.o.parentElement===this.vb&&this.vb.removeChild(this.o)},
$g:function(){var a=this.oa.u+3,b=this.oa.V-9,c,d=J.Nf(this.Lc);"BOTTOM"===this.Jb?c=this.oa.ca-d-9:c="VCENTER"===this.Jb?this.oa.v+(this.oa.B()-d)/2:this.oa.v+1;return new Bb(a,c,b,c+d)}};var Rf;Rf=function(a,b){this.oa=a;this.Lc=12;this.dc="HCENTER";this.Jb="VCENTER";this.Mc="";this.Zg=this.lh=!1;this.o=window.document.createElement("div");this.Ug=null;this.vb=b.La.canvas.parentNode;this.Hb=-1;this.Qf="#FFFFFF";this.kb="#000000";this.dt=this.ka="";this.cz=!0};
Rf.prototype={j:function(a){var b=this.$g();a=a.pj();b=b.Mb(a.X,a.Y);J.Ya(this.o,b);this.o.style.zIndex=300;this.o.style.textAlign="HCENTER"===this.dc?"center":"RIGHT"===this.dc?"right":"left";this.o.style.fontFamily=this.Mc;this.o.style.fontSize=this.Lc+"px";this.lh&&(this.o.style.fontStyle="italic");this.Zg&&(this.o.style.fontWeight="bold");""!==this.dt?(this.Ug=window.document.createElement("a"),this.Ug.innerText=this.ka,this.Ug.href=this.dt,this.cz&&(this.Ug.target="_blank"),this.o.appendChild(this.Ug)):
this.o.innerText=this.ka;this.vb.appendChild(this.o);this.o.style.backgroundColor=this.Qf;this.o.style.color=this.kb;this.o.tabIndex=this.Hb},Vb:function(){return this.o},$R:function(a,b){this.dt=a;this.cz=b},Lg:function(a,b){this.Mc=a;this.Lc=b},Zl:function(a,b){this.dc=a;this.Jb=b},be:function(a){this.oa=a},Ze:function(a){this.Hb=a},Ij:function(a){this.Qf=a},setColor:function(a){this.kb=a},Ob:function(a){this.ka=a},remove:function(){null!==this.o&&(null!==this.Ug.href&&this.o.removeChild(this.Ug),
this.vb.removeChild(this.o))},$g:function(){var a=this.oa.u+3,b=this.oa.V-9,c,d=J.Nf(this.Lc);"BOTTOM"===this.Jb?c=this.oa.ca-d-9:c="VCENTER"===this.Jb?this.oa.v+(this.oa.B()-d)/2:this.oa.v+1;return new Bb(a,c,b,c+d)}};var Ib;Ib=function(a,b){a=b.getUint16();this.Mk=b.ja(a,!1);this.bl=b.getUint16()};Ib.prototype={j:function(a){a=a.g.Tb;null!==a&&(a.lR(this.Mk),a.DR(this.bl))}};var Hb;Hb=function(a,b){this.jK=b.getUint32()};Hb.prototype={j:function(a){a.g.Tb.aD(this.jK)}};var Jb;
Jb=function(a,b){a=b.getUint16();this.ro=b.ja(a,!1)};Jb.prototype={j:function(a){a=a.g.Tb;null!==a&&a.XR(this.ro)}};var le;le=function(a,b){this.zc=b.getUint16();this.na=b.getUint16();this.ra=b.getUint16();this.mb=b.getUint32();this.AD=1};
le.prototype={j:function(a){var b=null,c=J.lm(this.na-1,this.ra-1).getContext("2d");c.fillStyle="white";c.fillRect(0,0,this.na-1,this.ra-1);this.mb&this.AD&&(b=J.lm(this.na-1,this.ra-1).getContext("2d"),b.fillStyle="white",b.fillRect(0,0,this.na-1,this.ra-1));a.pe.OM(this.zc,new Pb(c,b,new Ja(this.na,this.ra)))}};var me;me=function(a,b){this.zc=b.getUint16()};me.prototype={j:function(a){a.pe.WP(this.zc);a.g.qa.ya.zO(this.zc)}};var pe;
pe=function(a,b){this.kM=b.getUint32();this.sJ=b.getUint16();this.vn=b.getUint16();this.Xr=!!b.getUint8();this.Yr=!!b.getUint8();this.gs=new I(b.getUint16(),b.getUint16())};pe.prototype={j:function(a){var b=new nf(this.vn,this.Xr,this.Yr,this.gs);a.g.qa.ya.iO(this.kM).info().mD(this.sJ,b)}};var ne;ne=function(a,b){this.zc=b.getUint16()};ne.prototype={j:function(a){a.pe.zP(this.zc)}};var oe;oe=function(a,b){this.zc=b.getUint16()};
oe.prototype={j:function(a){var b=a.pe.sp(a.pe.lt());!b.Qi&&a.wh&&b.Sm.drawImage(b.La.canvas,0,0);b.Qi||a.wh||b.jR(!0);a.pe.vP()}};var ke;ke=function(){};ke.prototype={j:function(a){var b=a.g.Bb,c=a.Xs,d;var e=Ga.D(2*c.count());var f=Ac.D(e,a.g.A.Fa);for(d=0;d<c.count();++d)f.Dc(c.$o(d));a=new Fa(519,a.g.A.la,0,0);a.Nb(e);b.push(a)}};var de;de=function(){};
de.prototype={j:function(a){var b=a.g.Bb,c=a.qo,d;var e=Ga.D(4*c.count());var f=Ac.D(e,a.g.A.Fa);for(d=0;d<c.count();++d)f.Dc(c.C(d)),f.Dc(c.B(d));a=new Fa(518,a.g.A.la,0,0);a.Nb(e);b.push(a)}};var je;je=function(a,b){var c=b.getUint16();this.ka=b.ja(c,52===a)};je.prototype={j:function(a){a.getContext().font=a.getState().sj();a.Xs.NM(this.ka)}};var ce;ce=function(a,b){var c=b.getUint16();this.ka=b.ja(c,34===a)};ce.prototype={j:function(a){a.getContext().font=a.getState().sj();a.qo.wA(this.ka)}};var ie;
ie=function(a,b){b.getUint32();b.getUint32()};ie.prototype={j:function(a){a.Xs.clear()}};var be;be=function(a,b){b.getUint32();b.getUint32()};be.prototype={j:function(a){a.qo.clear()}};var Sf;Sf=function(a,b){this.gM=b.getUint32();this.sG=b.getInt16();b.getInt16()};Sf.prototype={j:function(a){a.getContext().font=a.getState().sj();a.qo.wA(this.ka,this.sG,this.gM)}};var re;re=function(a,b,c){var d=b.getUint16();this.ka=b.ja(d,!1);Sf.call(this,a,b,c)};re.prototype=Object.create(Sf.prototype);
re.prototype.constructor=re;var se;se=function(a,b,c){var d=b.getUint16();this.ka=b.ja(d,!0);Sf.call(this,a,b,c)};se.prototype=Object.create(Sf.prototype);se.prototype.constructor=se;var cc;cc=function(){this.hw="";this.hm=Ua.m;this.mw="";this.vm=this.Rp=!1;this.Xp=Ua.m;this.Tv=J.m();this.Mk="";this.bl=0};
cc.prototype={lR:function(a){this.Mk=a},DR:function(a){this.bl=a},XR:function(a){this.hw=a},aD:function(a){this.hm=a},IO:function(){return""===this.Mk||0===this.bl?!1:!0},mS:function(a){this.mw=a?location.protocol+"//"+this.Mk+":"+this.bl:""}};var Tf;Tf=function(a,b){this.g=a;this.Kc=b};
Tf.prototype={j:function(){var a=this.g.eb(),b=this.g.getConfiguration(),c=this.g.ob();c.BC(b.PlcAddress,b.CommBufferSize,b.UseLocalHost);a.wb(c.qb(),this)},Xb:function(a){a=(new jd(a,!0,this.g.zb.yb)).GC();a instanceof Ta?(this.g.A.$p=a.$p,this.g.I(this.Kc,0)):this.g.error("Checking for demo mode failed (1): "+a)},qt:function(){return!1},S:function(a){this.g.error("Checking for demo mode failed (2): "+a)},className:function(){return"CheckDemoModeState"}};var Uf;
Uf=function(a){this.g=a;this.Zr=!0;this.cA=this.jt=0};
Uf.prototype={j:function(){var a=this.g.eb(),b=this.g.ob();b.HN();this.cA=J.m();a.wb(b.qb(),this,!1,!this.Zr)},nj:function(){return!0},Xb:function(){var a=J.m()-this.cA;this.Zr?(this.jt=a,this.Zr=!1,this.g.I(this,0)):(N.h(J.h("Deriving post method difference: {0}ms data in body, {1}ms without",this.jt,a)),a<this.jt-20&&(N.m("POST requests will be sent with the data in header because this seems faster"),this.g.lD(!0)),this.g.I(new Vf(this.g),0))},S:function(){this.g.error("deriving the best post method failed")},
className:function(){return"DerivingPostMethodState"}};var Wf;Wf=function(a,b,c,d,e,f,g){void 0===g&&(g=null);this.g=a;this.yh=b;this.Jd=c;this.bb=f;this.pl=e;this.GK=g;this.Ib=d;this.rA=new oa("utf-8")};
Wf.prototype={j:function(){var a=this.g.eb(),b=this.g.ob();N.m("DeviceLoginState, executing step: "+this.pl+", cryptType: "+this.bb.Gc);2===this.bb.Gc?0===this.pl?b.BN(this.bb.Gc):b.CN(this.yh,this.Jd):0===this.pl?b.It("","",0,this.bb.Gc):b.It(this.yh,this.Jd,this.GK.ZE,this.bb.Gc);a.wb(b.qb(),this)},Xb:function(a){0===this.pl?this.nL(a):this.oL(a)},nL:function(a){var b=(new jd(a,this.g.A.Fa,this.g.zb.yb)).DP(this.bb.Gc,this.Ib);if(b instanceof dd)if(2===this.bb.Gc){var c=this;ad.J(b.$E).then(function(d){var e=
b.aF,f=c.rA.encode(c.Jd),g=Math.min(f.byteLength,60),k=new ArrayBuffer(60),l=new Uint8Array(k);f=new Uint8Array(f);var G=new Uint8Array(e);var u=Math.min(e.byteLength,60);for(e=0;60>e;e++)l[e]=0;for(e=0;e<g;e++)l[e]=f[e];for(e=0;e<u;e++)l[e]^=G[e];ad.m(d,k).then(function(ka){var ja=c.yh;60<ja.length&&(ja=ja.substr(0,60));ja=c.rA.encode(ja);c.g.I(new Wf(c.g,ja,ka,c.Ib,1,c.bb,b),0)},function(ka){c.S("DeviceLogin failed with the following error: "+ka)})},function(d){c.S("DeviceLogin failed with the following error: "+
d)})}else this.g.I(new Wf(this.g,this.yh,this.Jd,this.Ib,1,this.bb,b),0);else this.S("DeviceLogin failed with the following error: "+b)},oL:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).EP();var b=!1;a instanceof ed?(a.ic===Ua.h?b=!0:63===a.ic&&D.mE(this.g.getConfiguration())&&(b=!0),b?(this.Ib||(N.m("Successfully Logged in! DeviceSessionId: "+a.cf),this.g.A.Th=a.cf),this.g.A.Lp=!1,63===a.ic&&(N.m("Successfully Logged with 'Change Password' set"),this.g.A.Lp=!0),this.g.I(new Xf(this.g),0)):25===
a.ic||63===a.ic?(25===a.ic?N.m("DeviceLogin failed with the following error: NO_ACCESS_RIGHTS"):N.m("DeviceLogin failed with the following error: ERR_CHANGE_PASSWORD"),this.bb.Error=a.ic,this.g.I(new uc(this.g,this.bb,this.Ib),0)):this.S("DeviceLogin failed with the following error: "+a.ic)):this.S("DeviceLogin failed with the following error: "+a.ic)},S:function(a){this.g.error("Login to the plc device failed: "+a);this.g.Zc.Hj(!1)},className:function(){return"DeviceLoginState Step: "+this.pl+" CryptType: "+
this.bb.Gc}};var Vf;Vf=function(a,b,c){void 0===b&&(b=D.qE(a.getConfiguration()));void 0===c&&(c=!1);this.g=a;this.qL=c;this.Ib=b};
Vf.prototype={j:function(){var a=this.g.eb(),b=this.g.ob();this.Ib?b.EN(this.g):b.It();a.wb(b.qb(),this)},Xb:function(a){null!==a||this.qL?(a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).FP(this.Ib),a instanceof fd?(this.g.A.IQ(a.Gc),this.Ib?a.ic===Ua.h?(this.Rz(a.cf),a.Error===Ua.h||18===a.Error?this.g.cO()?(a.Error=0,this.g.I(new uc(this.g,a,this.Ib),0),N.m("DeviceLoginState, Skipped")):this.g.I(new Wf(this.g,"","",this.Ib,0,a),0):this.S("DeviceSessionCreate failed with the following error: "+a.ic+" "+
a.Error)):this.S("DeviceSessionCreate failed with the following error: "+a.ic):a.ic===Ua.h&&a.Gc===Ua.J?(this.Rz(a.cf),this.g.I(new Xf(this.g),0)):(N.m("Login failed. Probably credentials necessary; result: "+a.ic),this.g.I(new uc(this.g,a,this.Ib),0))):this.S("DeviceSessionCreate failed with the following error: "+a)):this.g.I(new Vf(this.g,!1,!0),0)},Rz:function(a){N.m("Successfully Logged in! DeviceSessionId: "+a);this.g.A.Th=a},nj:function(){return this.Ib},S:function(a){this.g.error("Login to the plc device failed: "+
a)},className:function(){return"DeviceSessionState NewServices: "+this.Ib}};var wc;wc=function(a){this.g=a};wc.prototype={j:function(){N.info("Trying to reconnect after error");this.g.I(new hc(this.g),0)},className:function(){return"ErrorState"}};var uc;
(function(){var a=[["LoginVisuErr1","Authentication failed, try again"],["LoginVisuErr2","Change password at first login is not supported"],["LoginVisuErr3","Error during authentication"],["LoginVisuErr4","Maximum number of clients reached"],["LoginVisuErr5","Not enough memory in the PLC for new client"]];uc=function(b,c,d){this.g=b;this.bb=c;this.Ib=d;this.Si=this.Ti=this.Ln="";this.me=null;this.ke=this.le=this.fa=0;this.Bf=null;this.Ak=12;this.Mc="Arial";this.kg=this.zf=this.Af=null;this.jg=[];
this.fs=this.ig=this.hg=this.th=null;this.lg=[];this.Nr=this.hs=!1;this.fe=this.Cd=4294967295;this.tl=this.Ei=!1;this.Yg="";this.mr=!1;this.Ea=null;this.dA=0;this.jd=!1;this.oo="";this.ph=new Bb(0,0,0,0);this.co=this.fl=0;this.Qe=1;this.Fe="#909090";this.kf="#000000";this.Fi="#FFFFFF";this.zk="#000000";this.Hb=Wa.m;this.pA=0;this.De=[];this.lk=0;this.Dr=this.kz=!1;this.Ok=this.rh=this.Ez=this.Ky=null;this.md=new Yf(this.g);""!==this.g.getConfiguration().LoginVisu.toLowerCase()&&(this.Eb=this.g.St(),
""===this.Eb&&(this.Eb=this.g.getConfiguration().LoginVisuDefLang,""===this.Eb&&(this.Eb=D.Av(),this.g.KC(this.Eb,!0,!1))))};uc.prototype={j:function(){switch(this.fa){case 0:this.XL();break;case 1:this.$L();break;case 2:this.bJ();break;case 3:this.bM();break;case 4:this.XI();break;case 5:this.ZL();break;case 6:this.aM();break;case 7:this.WL();break;case 8:this.YL();break;case 9:this.UL();break;case 10:this.VL();break;default:this.Vn()}},className:function(){return"QueryCredentialsState"},zp:function(b){this.oo=
b},yR:function(b){this.Af=b},wR:function(b){this.zf=b},vR:function(b){this.kg=b},vp:function(b){this.De[this.lk]=b},tc:function(){return this.De[this.lk]},Au:function(b){this.hs=b},EQ:function(b){this.Nr=b},sR:function(b){this.th=b},tR:function(b){this.ig=b},rR:function(b){this.hg=b},xR:function(b,c){this.lg.push([b,c])},JB:function(b){var c;for(c=0;c<this.lg.length;c++)if(this.lg[c][0]===b)return this.lg[c][1];return null},uR:function(b,c){null===this.Xo(b)&&this.jg.push([b,c])},Xo:function(b){var c;
for(c=0;c<this.jg.length;c++)if(this.jg[c][0]===b)return this.jg[c][1];return null},Fh:function(){return this.Mc},Gh:function(){return this.Ak},Eh:function(){return this.zk},Jl:function(){return this.Hb++},lO:function(){return this.pA++},$N:function(b,c){var d="";switch(b){case 25:b="LoginVisuErr1";break;case 63:b="LoginVisuErr2";break;case 248:b="LoginVisuErr4";break;case 247:b="LoginVisuErr5";break;default:b="LoginVisuErr3"}var e=this.Ok;null===e&&(e=this.rh);""!==c&&null!==e&&(c=e.iE(c,b),null!==
c&&(d=c));if(""===d)for(c=0;c<a.length;c++)a[c][0]===b&&(d=a[c][1]);return d},Gg:function(b){this.De.push(b)},xP:function(){this.De.pop()},Jh:function(b){return 0===this.ph.C()&&0===this.ph.B()?b:this.ph},MB:function(b,c){var d=this.fl;if(0>this.fl||0>this.co)d=Math.max(1,Math.min(b,c)/8);return d},fm:function(b){this.g.KC(b,!1,!0)},HG:function(b,c){this.g.pw&&(this.g.pw=!1,this.g.Zc.Hj(!1));c=new Zf(c);c.mF(b);this.me=c.me;null!==this.me&&(this.le=c.le,this.ke=c.ke,this.fe=c.fe,this.Cd=c.Cd,this.Yg=
c.Yg,this.Ei=c.Ei,this.tl=c.tl,N.h("Login page '"+this.Ln+"' is availabe"));this.jd=!0;this.g.I(this,0)},IG:function(b){this.rh=new $f(this.g.getConfiguration().yg());this.rh.Iv(b);this.rh.ih&&(N.h("Localized texts file '"+this.Ti+"' is availabe"),b=this.rh.Nc,null!==b?N.h("Languages found: "+b.length):N.h("Languages found: 0"));this.jd=!0;this.g.I(this,0)},GG:function(b){this.Ok=new $f(this.g.getConfiguration().yg());this.Ok.Iv(b);this.Ok.ih&&(N.h("Localized Error texts file '"+this.Si+"' is availabe"),
b=this.Ok.Nc,null!==b?N.h("Languages found: "+b.length):N.h("Languages found: 0"));this.jd=!0;this.g.I(this,0)},EG:function(){this.Dr?this.g.U().yn?this.kz?this.fa=8:(this.kz=!0,this.io(!0),this.fa=7):(this.io(!0),this.fa=7):this.fa=8;this.g.I(this,0)},XL:function(){var b=this;this.Ln=this.g.getConfiguration().LoginVisu.toLowerCase();this.fa=1;""===this.Ln?(this.jd=!0,this.g.I(this,0)):(this.jd=!1,this.sr(function(c){b.HG(c,b.g.A.Fa)},this.Ln))},$L:function(){this.jd&&(this.fa=2,this.g.I(this,0))},
bJ:function(){var b=this;this.Ti=this.g.getConfiguration().LoginVisuTexts.toLowerCase();this.fa=3;""===this.Ti?(this.jd=!0,this.g.I(this,0)):(this.jd=!1,this.sr(function(c){b.IG(c)},this.Ti))},bM:function(){this.jd&&(this.fa=4,this.g.I(this,0))},XI:function(){var b=this;this.Si=this.g.getConfiguration().LoginVisuErrorTexts.toLowerCase();this.fa=5;if(""===this.Si)this.jd=!0;else if(this.Si.toUpperCase()===this.Ti.toUpperCase())this.Si=this.Ti,this.jd=!0;else{this.jd=!1;this.sr(function(c){b.GG(c)},
this.Si);return}this.g.I(this,0)},ZL:function(){this.jd&&(this.fa=6,this.dA=J.m(),this.g.I(this,0))},aM:function(){this.fa=7;0<this.Yg.length&&!this.wJ(this.Yg)&&(this.fa=6,5E3<J.m()-this.dA&&(this.Ea=null,this.fa=7));this.g.I(this,0)},WL:function(){var b=this;if(null!==this.me){if(null===this.Bf){var c=this.g.oc;null!==c&&c.detach();this.Bf=function(){b.Bq()};window.addEventListener("resize",this.Bf,!1)}this.io(!1);this.g.U().PA();this.g.U().NC();this.g.U().Oo(this.me,function(){b.EG()},function(d){return b.Km(d,
!1)});this.md.bf()}else this.Vn()},YL:function(){this.hs&&(this.fa=10);this.Nr&&(this.fa=9);this.g.I(this,0)},UL:function(){var b=this.g.oc;null!==this.Bf&&(window.removeEventListener("resize",this.Bf,!1),this.Bf=null,null!==b&&b.Bl());this.Oq();this.g.Uu("The user did not provide credentials.","No credentials")},VL:function(){var b="",c="",d=this.g.oc;null!==this.Bf&&(window.removeEventListener("resize",this.Bf,!1),this.Bf=null,null!==d&&d.Bl());null!==this.Af&&(b=this.Af.Vb().value);null!==this.zf&&
(c=this.zf.Vb().value);d=this.g.Zc.xB();null!==d[0]?(b=d[0],c=d[1]):this.g.Zc.yj()&&(this.g.Zc.iQ(b,c),this.g.pw=!0);this.Oq();this.g.nR(this.Eb);this.g.XC(!1);this.bb.Error=0;this.g.U().YQ();this.g.I(new Wf(this.g,b,c,this.Ib,0,this.bb),0)},Km:function(b,c){var d=!1;this.lk=this.De.length=0;if(this.mr){this.Dr=this.mr=!1;this.g.U().g.getConfiguration().SemiTransparencyActive=this.tl;this.g.U().getState().Xl();var e=new Bb(0,0,this.le,this.ke);var f=new Kf(e,this.g.U());var g=this.Cd;this.g.getConfiguration().ScaleTypeIsotropic&&
(!1===this.Ei?g=this.fe:(e=new Bb(0,0,document.documentElement.clientWidth,document.documentElement.clientHeight),f.UQ(e.C()/this.le),f.VQ(e.B()/this.ke)));f.vQ(g);f.wQ(this.Cd);f.xQ(this.Ea);f.TQ(this.Ei);this.Gg(new Pf(new Bb(0,0,1E4,1E4)));this.Gg(f);this.Gg(b);this.lk=2}else this.Gg(b),this.lk=0;b instanceof Ad?(d=new ag(this.g,this.bb,this),d.dE(b,c)):b instanceof rd?(this.ph=b.uc(),this.Qe=1,this.Fe=b.eO(),this.kf=b.VN(),this.fl=this.co=-1):b instanceof wd?(this.fs=b,this.ph=b.uc(),0===b._type&&
(this.fl=this.co=-1)):b instanceof Vd?(this.Ak=b.Gh(),this.Mc=b.Fh(),this.zk=b.Eh()):b instanceof cf?(this.Ak=b.Gh(),this.Mc=b.Fh(),this.zk=b.Eh()):b instanceof te?(this.fl=b.VB,this.co=b.WB):b instanceof Ud?(this.Qe=b.C(),this.Fe=this.kf=b.Ro()):b instanceof Td?this.Fi=b.Ro():b instanceof Cb&&(e=this.g.getConfiguration().LoginVisuNamespace,c=b.sf,"__VisualizationStyle.CheckboxUnchecked"===c&&(d=!0),""!==e&&2>=c.split(".").length&&(e+=".",D.xb(c,e)||b.iR(e+c)),d?(this.ph=b.qv(),this.xP()):(b.YB(this.g.U().Hk,
this.g.U().cg),this.ph=b.qv(),this.Dr=!0));this.Ez=this.Ky;this.Ky=b;return this.De},Oq:function(){null!==this.Af&&(this.Af.remove(),this.Af=null);null!==this.zf&&(this.zf.remove(),this.zf=null);null!==this.kg&&(this.kg.remove(),this.kg=null);null!==this.th&&(this.th.remove(),this.th=null);null!==this.ig&&(this.ig.remove(),this.ig=null);null!==this.hg&&(this.hg.remove(),this.hg=null);var b;for(b=0;b<this.lg.length;b++)null!==this.lg[b][1]&&this.lg[b][1].remove();this.lg=[];for(b=0;b<this.jg.length;b++)null!==
this.jg[b][1]&&this.jg[b][1].remove();this.jg=[];this.Nr=this.hs=!1},io:function(b){this.mr=!0;this.Hb=Wa.m;this.pA=0;b&&this.Oq();this.yG()},sr:function(b,c){var d=new XMLHttpRequest;d.open("GET",c,!0);d.responseType="arraybuffer";d.timeout=5E3;d.onreadystatechange=function(){d.readyState===XMLHttpRequest.DONE&&(200===d.status?b(d.response):b(null))};d.send()},yG:function(){this.g.U().Mt(1);if(this.g.getConfiguration().BestFit){var b=this.g.U().Jf();if(!1===this.g.getConfiguration().ScaleTypeIsotropic){var c=
b.C()/this.le;b=b.B()/this.ke;this.g.U().WQ()}else{var d=new Bb(0,0,0,0);var e=b.C()+1;var f=b.B()+1;b=e/2;c=f/2;var g=this.le/this.ke;g<e/f?(e=f*this.le/this.ke,d.v=0,d.u=b-e/2):(f=e*this.ke/this.le,d.v=c-f/2,d.u=0);d.V=d.u+e;d.ca=d.v+f;c=d.C()/this.le;b=d.B()/this.ke;c<=b?b=c:c=b;this.g.U().OR(d);this.g.U().XQ()}this.g.U().PR(c);this.g.U().QR(b)}},Bq:function(){var b=this;setTimeout(function(){b.ns()},50)},ns:function(){if(this.hg.TB()){if(this.md.tv()){var b=this;this.io(!0);this.g.U().Oo(this.me,
function(){},function(c){return b.Km(c,!0)})}this.md.bf()}},wJ:function(b){var c=this.g.U().Hk;var d=this.g.U().cg;if(null===this.Ea){if(c.pC())return this.Ea=c.tj("ImageByImagePoolId?id="+b,!1),this.Ea.Cg();d=d.Ih(b);if(null!==d)return this.Ea=c.tj(d,!1),this.Ea.Cg();N.warn("Imagepoolentry for "+b+" not found");return!0}return this.Ea.Cg()},Vn:function(){(new bg(this.g,this.bb,this.Ib)).$D()}}})();var cg;cg=function(a){this.g=a;this.fr=""};
cg.prototype={j:function(){var a=this,b;for(b=document.getElementById("cas-script");null!==b;)b.parentNode.removeChild(b),b=document.getElementById("cas-script");b=document.createElement("script");b.id="cas-script";b.onload=function(){a.Dl()};b.onerror=function(c){a.S(c)};window.onerror=function(c){a.S(c)};b.src=this.g.getConfiguration().CasFactoryName;document.head.appendChild(b)},Dl:function(){""===this.fr&&this.Se()},S:function(a){this.fr="Loading the automation server helper script failed for the following reason: "+
a+".";this.g.error(this.fr)},Se:function(){this.g.I(new dg(this.g),0)},className:function(){return"RetrievingAutomationServerScriptState"}};var hc,eg;eg=function(){};eg.Ta=function(a){return Ka.Ta(a)};eg.J=function(a){a=parseInt(a,10);if(0===a||1===a||2===a)return a;N.info("Unexpected value at the URL configured; only 0..2 are allowed so falling back to default value");return 0};eg.h=function(a){return parseInt(a,10)};
eg.m=[{Ia:"HandleTouchEvents",Oa:"CFG_HandleTouchEvents",type:"boolean",Ka:eg.Ta},{Ia:"TouchHandlingActive",Oa:"CFG_TouchHandlingActive",type:"boolean",Ka:eg.Ta},{Ia:"BestFit",Oa:"CFG_BestFit",type:"boolean",Ka:eg.Ta},{Ia:"BestFitForDialogs",Oa:"CFG_BestFitForDialogs",type:"boolean",Ka:eg.Ta},{Ia:"LogLevel",Oa:"CFG_LogLevel",type:"string",Ka:null},{Ia:"Benchmarking",Oa:"CFG_Benchmarking",type:"boolean",Ka:eg.Ta},{Ia:"WorkaroundDisableMouseUpDownAfterActiveTouch",Oa:"CFG_WorkaroundDisableMouseUpDownAfterActiveTouch",
type:"boolean",Ka:eg.Ta},{Ia:"WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch",Oa:"CFG_WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch",type:"number",Ka:eg.h},{Ia:"WorkaroundDisableResizeHandling",Oa:"CFG_WorkaroundDisableResizeHandling",type:"boolean",Ka:eg.Ta},{Ia:"WorkaroundDisableSVGAspectRatioWorkaround",Oa:"CFG_WorkaroundDisableSVGAspectRatioWorkaroundg",type:"boolean",Ka:eg.Ta},{Ia:"WorkaroundDisableSVGEmptySizeWorkaround",Oa:"CFG_WorkaroundDisableSVGEmptySizeWorkaround",type:"boolean",
Ka:eg.Ta},{Ia:"WorkaroundForceSVGEmptySizeWorkaround",Oa:"CFG_WorkaroundForceSVGEmptySizeWorkaround",type:"boolean",Ka:eg.Ta},{Ia:"PostDataInHeader",Oa:"CFG_PostDataInHeader",type:"number",Ka:eg.J},{Ia:"DebugOnlyPrintPaintCommands",Oa:"CFG_DebugOnlyPrintPaintCommands",type:"boolean",Ka:eg.Ta},{Ia:"DebugHTML5",Oa:"CFG_DebugHTML5",type:"boolean",Ka:eg.Ta},{Ia:"DebugOnlyPrintRawTouches",Oa:"CFG_DebugOnlyPrintRawTouches",type:"boolean",Ka:eg.Ta},{Ia:"DebugOnlyPrintGestures",Oa:"CFG_DebugOnlyPrintGestures",
type:"boolean",Ka:eg.Ta},{Ia:"DebugOnlyPrintTouchRectangles",Oa:"CFG_DebugOnlyPrintTouchRectangles",type:"boolean",Ka:eg.Ta},{Ia:"DebugOnlyDiagnosisDisplay",Oa:"CFG_DebugOnlyDiagnosisDisplay",type:"boolean",Ka:eg.Ta},{Ia:"DebugOnlyInputReactionOnUp",Oa:"CFG_DebugOnlyInputReactionOnUp",type:"boolean",Ka:eg.Ta},{Ia:"DebugOnlyInputReactionExplCoord",Oa:"CFG_DebugOnlyInputReactionExplCoord",type:"boolean",Ka:eg.Ta},{Ia:"DefaultConfigurationOnError",Oa:"CFG_DefaultConfigurationOnError",type:"boolean",
Ka:eg.Ta},{Ia:"KeysForWebVisu",Oa:"CFG_KeysForWebVisu",type:"string",Ka:null},{Ia:"MaxResizePixel",Oa:"CFG_MaxResizePixel",type:"number",Ka:eg.h},{Ia:"TouchContextMenuEnabled",Oa:"CFG_TouchContextMenuEnabled",type:"boolean",Ka:eg.Ta},{Ia:"ContextMenuDisabled",Oa:"CFG_ContextMenuDisabled",type:"boolean",Ka:eg.Ta},{Ia:"ClientName",Oa:"ClientName",type:"string",Ka:null}];hc=function(a){this.g=a};
hc.prototype={j:function(){var a=this.g.eb();var b=window.document.URL;b=b.substr(0,b.lastIndexOf("."));a.du(b+".cfg.json",this)},Dl:function(a){try{var b=this.PK(a);this.IH(b);this.vz(b);this.g.setConfiguration(b);this.bI(b);this.Se()}catch(c){this.S(c)}},IH:function(a){if(a.TouchHandlingActive){var b=D.rE();b||(a.TouchHandlingActive=b,N.info("No multitouch support detected, therefore disabling multitouch for this client."))}},vz:function(a){var b;for(b=0;b<eg.m.length;++b){var c=eg.m[b];var d=Ka.pm(this.g.sg,
c.Oa);null!==d&&(d=null!==c.Ka?c.Ka(d):d,a[c.Ia]=d,N.info("Overridden Config Entry: "+c.Ia+" = "+d))}},PK:function(a){try{var b=JSON.parse(a),c=new Configuration,d;for(d in b)void 0!==d&&(c[d]=b[d]);c.validate();return c}catch(e){return this.gg(e),new Configuration}},S:function(a){var b=this.g.getConfiguration();null===b&&(b=new Configuration,this.vz(b));b.DefaultConfigurationOnError?(this.gg(a),this.g.setConfiguration(new Configuration),this.Se()):this.g.error(a)},Se:function(){this.g.getConfiguration().CasFactoryName?
this.g.I(new cg(this.g),0):this.g.I(new dg(this.g),0)},gg:function(a){N.error("Loading the configuration failed for the following reason: "+a+". A default config will be used instead.")},className:function(){return"RetrievingConfigurationState"},bI:function(a){N.m("Configuration:");for(var b in a)a.hasOwnProperty(b)&&N.m(J.h(" - {0}: {1}",b,a[b]));a.Benchmarking&&N.info("Benchmarking active")}};var fg;fg=function(a){this.g=a};
fg.prototype={j:function(){var a=this.g.eb(),b=this.g.ob();b.dQ();a.wb(b.qb(),this)},nj:function(){return!0},Xb:function(a){null!==a&&(a=(new jd(a,!0,this.g.zb.yb)).JP(),""!==a&&(this.g.A.eq=a));this.g.I(this.DH(),0)},DH:function(){if(this.g.A.yF){if(0===this.g.getConfiguration().PostDataInHeader)return new Uf(this.g);1===this.g.getConfiguration().PostDataInHeader&&(N.info("POST-Data in header active by override"),this.g.lD(!0))}1===this.g.getConfiguration().PostDataInHeader&&N.warn("POST-Data in header active by override but not supported by Webserver");
return new Vf(this.g)},S:function(a){this.g.error("Retrieving IP Info failed: "+a)},className:function(){return"RetrievingMyIpState"}};var gg;gg=function(a){this.g=a};
gg.prototype={j:function(){var a=this.g.eb(),b=this.g.getConfiguration(),c=this.g.ob();c.BC(b.PlcAddress,b.CommBufferSize,b.UseLocalHost);a.wb(c.qb(),this)},nj:function(){return!0},Xb:function(a){null===a?this.g.I(this,this.g.getConfiguration().PollingRegistrationInterval):(a=(new jd(a,!0,this.g.zb.yb)).GC(),a instanceof Ta?(N.m("Successfully connected! SessionId: "+a.cf+" IntelByteOrder: "+a.Fa),this.g.GQ(a),this.g.Oc?this.g.I(new Xf(this.g),0):this.g.I(new fg(this.g),0)):this.g.error("Connection failed: "+
a))},S:function(a){this.g.error("Starting to connect failed: "+a)},className:function(){return"StartConnectState"}};var hg;hg=function(a){this.g=a};
hg.prototype={j:function(){var a=this.g.eb(),b=this.g.getConfiguration();a.du(J.iq((b.Application+".nativeelements.json").toLowerCase()),this)},Dl:function(a){try{this.g.fc.fill(a)}catch(b){this.gg(b)}this.Se()},S:function(a){this.gg(a);this.Se()},Se:function(){this.g.I(new gg(this.g),0)},gg:function(a){N.error("Loading the native element list failed for the following reason: "+a+". Native elements will not work at all.")},className:function(){return"UpdateNativeElementsState"}};var dg;
dg=function(a){this.g=a};dg.prototype={j:function(){var a=this.g.eb(),b=this.g.getConfiguration();a.du(J.iq((b.Application+".imagepoolcollection.csv").toLowerCase()),this)},Dl:function(a){try{this.g.U().cg.fill(a)}catch(b){this.gg(b)}this.Se()},S:function(a){this.gg(a);this.Se()},Se:function(){this.g.I(new hg(this.g),0)},gg:function(a){N.error("Loading the imagepool failed for the following reason: "+a+". Images will not work at all.")},className:function(){return"UploadImagePoolState"}};var Nf;
Nf=function(a,b){this.g=a;this.Kc=b;this.i=this.g.i};
Nf.prototype={j:function(){if(null===this.i)this.g.I(this.Kc,0);else{if(3===this.i.direction){var a=J.m();if(a-this.i.UC<this.g.getConfiguration().UpdateRate){this.g.I(this.Kc,0);return}}if(this.i.status.Yb===kd.m){var b=db.Ya;3===this.i.direction&&(b=db.xa);b=new Fa(b,this.g.A.la,0,1);this.g.Kj(null);this.g.I(this.Kc,0);this.g.Bb.push(b)}else if(this.i.status.Yb===kd.h)3!==this.i.direction&&(b=this.qH(this.i)),this.g.Kj(null),this.g.I(this.Kc,0),3!==this.i.direction&&this.g.Bb.push(b);else if(1!==
this.i.direction&&0!==this.i.direction||this.i.status.result===Ua.h&&!this.i.status.se||this.i.status.Yb===kd.Ya){if(1===this.i.direction||3===this.i.direction){if(this.i.status.Ue){this.i.status.Ue=!1;this.Vn(this.i);this.g.I(this.Kc,0);return}if(1===this.i.direction){if(this.i.status.Yb!==kd.Pb&&(this.i.status.Td||this.i.status.te)){b=this.g.eb();a=this.g.ob();this.i.status.Td?(0<(this.i.Hc.Jc&4)&&this.jD(this.i),0<(this.i.Hc.Jc&8)?(a.sN(this.i),this.i.status.Yb=kd.J):a.ZA(this.i)):this.i.status.te&&
a.YA(this.i);b.wb(a.qb(),this);return}}else if(this.i.status.Td||this.i.status.te){null!==this.i.Lb&&(window.document.body.removeChild(this.i.Lb),this.i.Lb=null);this.i.status.Td?(this.jD(this.i),b=this.pH(this.i),this.i.status.Td=!1,this.i.status.te=!0,this.g.Bb.push(b),b=new Fa(532,this.g.A.la,this.i.buffer.size(),0)):b=this.oH(this.i);this.g.I(this.Kc,0);this.g.Bb.push(b);this.i.UC=J.m();return}}else if(0===this.i.direction){if(this.i.status.Ue||this.i.status.te){b=this.g.eb();a=this.g.ob();this.i.status.Ue?
a.ZA(this.i):this.i.status.te&&a.YA(this.i);b.wb(a.qb(),this);return}}else if(2===this.i.direction){if(this.i.status.Ue){this.i.status.Ue=!1;b=this.nH(this.i);this.g.I(this.Kc,0);this.g.Bb.push(b);return}if(this.i.status.se&&this.i.status.Yb!==kd.h){b=D.Cv();this.g.I(this.Kc,b);this.QC(this.i);return}}this.g.I(this.Kc,0)}else b=this.g.eb(),a=this.g.ob(),a.tN(this.i),b.wb(a.qb(),this),this.i.status.se=!0,this.i.status.Yb=kd.Ya,this.i.status.result!==Ua.h&&(this.i.status.Yb=kd.h)}},Xb:function(a){var b=
!1;null!==a||0!==this.i.direction&&1!==this.i.direction?(a=new jd(a,this.g.A.Fa,this.g.zb.yb),this.i.status.se&&this.i.status.Yb!==kd.h?(b=D.Cv(),a.GP(this.i),this.g.I(this.Kc,b),this.QC(this.i)):(0===this.i.direction?this.i.status.Ue?(this.i.status.Ue=!1,a.qu(this.i),this.i.status.result===Ua.h&&(this.i.status.te=b=!0)):this.i.status.te&&a.FC(this.i):this.i.status.Yb===kd.J?(this.i.status.Ue=!1,a.qu(this.i),this.i.status.result===Ua.h&&0<this.i.bi.xe?(null!==this.i.Lb&&window.document.body.removeChild(this.i.Lb),
this.i.status.Yb=kd.Pb,this.EK(this.i)):(this.i.status.result=0,this.i.status.Yb=kd.xa,this.i.status.Td=!0,this.i.Hc.Jc=this.i.Hc.Jc&-5,this.i.Hc.Jc&=-9)):this.i.status.Td?(a.qu(this.i),this.i.status.Td=!1,this.i.status.result===Ua.h?this.i.status.te=b=!0:(null!==this.i.Lb&&window.document.body.removeChild(this.i.Lb),this.i.Lb=null)):this.i.status.te&&a.FC(this.i),this.g.I(this.Kc,0),b&&(a=new Fa(db.Ya,this.g.A.la,this.i.av,this.i.status.result),this.g.Bb.push(a),1===this.i.direction&&(null!==this.i.Lb&&
window.document.body.removeChild(this.i.Lb),this.i.Lb=null)))):(null!==this.i.Lb&&(window.document.body.removeChild(this.i.Lb),this.i.Lb=null),a=new Fa(528,this.g.A.la,this.i.av,7),this.g.Kj(null),this.g.I(this.Kc,0),this.g.Bb.push(a))},nj:function(){return!0},jD:function(a){var b,c;var d=a.Mh.split("/");var e=a.EC.split("/");if(0<d.length&&0<e.length){for(c=0;c<d.length-1;++c)0===c?b=d[c]:b=b+"/"+d[c];void 0!==b?b=b+"/"+e[e.length-1]:b=e[e.length-1];a.Mh=b}},QC:function(a){var b=null,c=this.AN();
null===a.buffer||0!==a.direction&&2!==a.direction||(b=a.buffer.Wd());null!==this.i.Lb&&window.document.body.removeChild(a.Lb);a.status.Yb=kd.h;null!==b&&a.status.result===Ua.h&&(b=new Blob([b],{type:"application/octet-binary"}),a=a.Mh,a=a.split("/"),a=a[a.length-1],c?this.GN(b,a):this.download(b,a))},GN:function(a,b){window.navigator.msSaveBlob(a,b)},AN:function(){var a=window.navigator.userAgent,b=a.indexOf("Trident/");return 0<a.indexOf("MSIE ")?!0:0<b?!0:!1},download:function(a,b){var c=window.document.createElement("a");
c.setAttribute("href",window.URL.createObjectURL(a));c.setAttribute("download",b);window.document.createEvent?(a=document.createEvent("MouseEvents"),a.initEvent("click",!0,!0),c.dispatchEvent(a)):c.click()},qt:function(){return!0},S:function(a){this.g.error("Error while processing the visualization: "+a)},className:function(){return"VisuFileTransferState"},Qm:function(a){var b=window.document.createElement("p");b.textContent=a;return b},Ie:function(a,b,c){var d=window.document.createElement("input");
d.className="fileTransferButton";d.type=b;null!==a?d.value=a:(d.style.display="none",null!==c&&null!==c.Hc&&0<c.Hc.Fk&&(d.accept=Nf.h(c.Hc.Fk,c.Hc.yq)));return d},Vn:function(a){var b=window.document.createElement("div"),c=window.document.createElement("div"),d=window.document.createElement("div"),e=window.document.createElement("div"),f=window.document.createElement("div"),g=this.Ie(null,"file",a),k=this.Ie("Browse...","button",a);a=this.Ie("Cancel","button",a);var l=this.Qm("Choose file to transfer..."),
G=this.Qm("File Transfer"),u=this;b.id="visuFileTransfer";b.className="fileTransferDialog";c.className="fileTransferDialogContent";d.className="fileTransferDialogHeader";e.className="fileTransferDialogBody";f.className="fileTransferDialogFooter";g.addEventListener("change",function(ka){u.jJ(ka,b)},!1);a.addEventListener("click",function(){u.uh(b)},!1);k.addEventListener("click",function(){g.click()},!1);d.appendChild(G);e.appendChild(l);f.appendChild(g);f.appendChild(a);f.appendChild(k);c.appendChild(d);
c.appendChild(e);c.appendChild(f);b.appendChild(c);window.document.body.appendChild(b);this.i.Lb=b},EK:function(a){a.wC?window.confirm("The file already exists in the plc.\nDo you want to overwrite the file?")?this.iz(null):this.uh(null):this.FK(a)},FK:function(a){var b=window.document.createElement("div"),c=window.document.createElement("div"),d=window.document.createElement("div"),e=window.document.createElement("div"),f=window.document.createElement("div"),g=this.Ie("Ok","button",a);a=this.Ie("Cancel",
"button",a);var k=this.Qm("The file already exists in the plc.\nDo you want to overwrite the file?"),l=this.Qm("File Transfer"),G=this;b.id="visuFileTransfer";b.className="fileTransferDialog";c.className="fileTransferDialogContent";d.className="fileTransferDialogHeader";e.className="fileTransferDialogBody";f.className="fileTransferDialogFooter";a.addEventListener("click",function(){G.uh(b)},!1);g.addEventListener("click",function(){G.iz(b)},!1);d.appendChild(l);e.appendChild(k);f.appendChild(a);f.appendChild(g);
c.appendChild(d);c.appendChild(e);c.appendChild(f);b.appendChild(c);window.document.body.appendChild(b);this.i.Lb=b},jJ:function(a){Nf.m(a,this.g)},Lw:function(a,b){var c=this.g.U().Jf();return new I((c.u+c.V-a)/2,(c.v+c.ca-b)/2)},uh:function(a){var b=this.g.i;null!==b&&(b.status.Yb=kd.m);null!==a&&window.document.body.removeChild(a)},iz:function(a){null!==this.g.i&&(this.i.status.Yb=kd.xa,this.i.Hc.Jc=this.i.Hc.Jc&-5,this.i.Hc.Jc&=-9);null!==a&&(window.document.body.removeChild(a),this.i.Lb=null)},
Pm:function(a){var b=null;"utf-8"===this.g.getConfiguration().ANSIStringEncoding&&(b=this.g.getConfiguration().td());return Ac.D(a,!0,b)},qH:function(a){var b=this.g.A.CommBufferSize-2E3;var c=Ga.D(b+4);var d=this.Pm(c);var e=d.hb(a.Mh,!1);b=e.length();d.hc(e);a=new Fa(528,this.g.A.la,a.av,a.status.result);0<b&&a.Nb(c);return a},oH:function(a){var b=0;var c=this.g.A.CommBufferSize-2E3,d=Ga.D(c+4),e=this.Pm(d),f;a.buffer.size()-a.status.Rh<c&&(c=a.buffer.size()-a.status.Rh,a.status.Yb=kd.h,b=1);e.K(c);
for(f=0;f<c;f++)e.Ra(a.buffer.getUint8());b=new Fa(530,this.g.A.la,b,0);b.Nb(d);a.status.Rh+=c;return b},pH:function(a){var b=this.g.A.CommBufferSize-2E3;var c=Ga.D(b+4),d=this.Pm(c);a=d.hb(a.Mh,!1);b=a.length();d.K(b);d.hc(a);b=new Fa(530,this.g.A.la,2,0);b.Nb(c);return b},nH:function(a){var b=Ga.D(20);var c=this.Pm(b);var d=c.hb("DummyFileName",!1);c.hc(d);c=new Fa(db.xa,this.g.A.la,0,0);c.Nb(b);a.status.Td=!0;return c}};
Nf.h=function(a,b){var c,d;for(d=0;d<a;++d){var e=b[d];e=e.split("|");"*.*"!==e[1]&&(0===d?c=e[1].substr(1):c=c+","+e[1].substr(1))}return c};Nf.m=function(a,b){var c=new FileReader,d=b.i;c.onload=function(e){Nf.J(e,b)};null!==d&&void 0!==d&&(d.EC=a.target.files[0].name,c.readAsArrayBuffer(a.target.files[0]))};Nf.J=function(a,b){var c=b.i;c.buffer=Mb.D(a.target.result,b.A.Fa,b.zb.yb);c.status.Td=!0};var ig;ig=function(a,b){this.g=a;this.ro=b};
ig.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=new Fa(3145728,this.g.A.la,0,0),d=Ga.D(32),e=Ac.D(d,!0),f=e.hb(this.ro,!1);e.K(1);e.hc(f);c.Nb(d);b.Oj(c);a.wb(b.qb(),this);N.h("Redundancy, request for the ID with ticket:"+this.ro)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).Gj(null);a instanceof hb?a.Bg()?(this.g.Tb.aD(Ua.m),this.g.Tb.Tv=J.m(),this.g.I(new jg(this.g),0)):this.S("Unexpected paint result in "+this.className()):this.S(a)},S:function(a){this.g.error("Error during redundancy initializing (1) the visualization: "+
a)},className:function(){return"VisuOnlineInitRedundState1"}};var jg;jg=function(a){this.g=a};
jg.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=new Fa(1048576,this.g.A.la,0,0);b.Oj(c);a.wb(b.qb(),this)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).Gj(null);var b=this;a instanceof hb?a.Bg()?(this.g.Tb.Rp=!0,this.g.U().Oo(a,function(){var c=b.g.Tb;c.hm===Ua.m?7E3>J.m()-c.Tv?b.g.I(b,10):b.S("Timeout on receiving command in "+b.className()):(N.h("Redundancy, ID to use, ID :"+c.hm),N.h("Redundancy, ID to remove, ID :"+b.g.A.la),c.Xp=b.g.A.la,b.g.A.la=c.hm,c.Rp=!1,b.g.I(new kg(b.g),
0))})):this.S("Unexpected paint result in "+this.className()):this.S(a)},S:function(a){this.g.error("Error during redundancy initializing (2) the visualization: "+a)},className:function(){return"VisuOnlineInitRedundState2"}};var kg;kg=function(a){this.g=a};
kg.prototype={j:function(){var a=this.g.eb(),b=this.g.ob();b.$u(this.g.Tb.Xp);a.wb(b.qb(),this)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).MP();0===a?(N.h("Redundancy, Client removed:"+this.g.Tb.Xp),N.m("Start normal machine state after redundancy switchover, ID: "+this.g.A.la),this.g.I(new lg(this.g),0)):this.S(a)},S:function(a){this.g.error("Error during redundancy initializing (3) the visualization: "+a)},className:function(){return"VisuOnlineInitRedundState3"}};var lg;
lg=function(a){this.g=a};
lg.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=Fa.xa(this.g.A.la,this.g.getConfiguration().BestFit,this.g.getConfiguration().BestFitForDialogs,this.g.getConfiguration().ScaleTypeIsotropic,this.g.U().Jf(),this.g.U().ar,this.g.getConfiguration().FillBackground);b.Oj(c);a.wb(b.qb(),this)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).Gj(null);a instanceof hb?!a.Bg()||0<a.ah?this.S("Unexpected paint result in "+this.className()):this.g.I(new mg(this.g),0):this.S(a)},S:function(a){this.g.error("Error during initializing (1) the visualization: "+
a)},className:function(){return"VisuOnlineInitState1"}};var mg;mg=function(a){this.g=a};
mg.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=new Fa(1048576,this.g.A.la,0,0),d=Ga.D(16),e=Ac.D(d,!0),f=this.g.getConfiguration();var g=458752;var k=this.g.Gy;""===k&&f.UseBrowserLanguage&&(k=D.Av());""!==k&&(g|=524288);e.K(g);e.K(7);g=0;f.HasKeyboard&&(g|=24);f.TouchHandlingActive&&(g|=3);this.g.A.Lp&&(g|=128);e.K(g|256);""!==k&&(f=e.hb(k,!1),e.hc(f));c.Nb(d);b.Oj(c);a.wb(b.qb(),this)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).Gj(null);a instanceof hb?!a.Bg()||0<a.ah?this.S("Unexpected paint result in "+
this.className()+", complete: "+a.Bg()+", commands: "+a.ah):this.g.I(new ng(this.g),0):this.S(a)},S:function(a){this.g.error("Error during initializing (2) the visualization: "+a)},className:function(){return"VisuOnlineInitState2"}};var ng;ng=function(a){this.g=a};
ng.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=new Fa(1048576,this.g.A.la,0,0),d=Ga.D(32),e=Ac.D(d,!0);if(!1===this.g.Tb.vm)if(e.K(1),""!==this.g.getConfiguration().StartVisu){var f=e.hb(this.g.getConfiguration().StartVisu,!1);e.hc(f)}else""!==this.g.getConfiguration().StartVisuDefaultEncodingBase64&&window.atob&&(f=window.atob(this.g.getConfiguration().StartVisuDefaultEncodingBase64),f=e.hb(f,!1),e.hc(f));else e.K(2),e.Ra(0);c.Nb(d);b.Oj(c);a.wb(b.qb(),this)},Xb:function(a){var b=(new jd(a,
this.g.A.Fa,this.g.zb.yb)).Gj(null);a=!1;if(b instanceof hb)if(!b.Bg()||0<b.ah)this.S("Unexpected paint result in "+this.className()+", complete: "+b.Bg()+", commands: "+b.ah);else{!0===this.g.Tb.vm&&(this.g.Tb.vm=!1,a=!0);b=location.search;var c="&BRLG";D.xb(b,c)&&(b=b.replace(c,""),a=!0);c="&RLLG";D.xb(b,c)&&(b=b.replace(c,""),a=!0);c="&"+Wa.h;D.xb(b,c)?(b=b.replace(c,""),a=!0):(c=Wa.h,D.xb(b,c)&&(b=b.replace(c,""),a=!0));c="&CFG_Lang="+this.g.St();D.xb(b,c)?(b=b.replace(c,""),a=!0):(c="CFG_Lang="+
this.g.St(),D.xb(b,c)&&(b=b.replace(c,""),a=!0));"?"===b&&(b="");a&&"TRACE"!==this.g.getConfiguration().LogLevel&&(history.replaceState(null,"",location.pathname+b),window.document.title="");this.g.I(new og(this.g),0)}else this.S(b)},S:function(a){this.g.error("Error during initializing (3) the visualization: "+a)},className:function(){return"VisuOnlineInitState3"}};var og;og=function(a){this.g=a;this.ti=null;this.Ly=J.m();this.g.QQ(new ld);this.ht=!1;this.Rx=!0;this.ss=!1;this.De=[]};
og.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=this.g.U().Hk;this.VG(c);null===this.ti?(c=this.g.Bb.empty()?new Fa(1,this.g.A.la,0,0):this.g.Bb.pop(),c.dl?(this.ss=!0,b.FS(c)):(this.ss=!1,b.Oj(c))):b.DS(this.ti.Uq);this.HL=J.m();a.wb(b.qb(),this)},qt:function(){return null===this.ti&&!this.ht},Xb:function(a){if(this.ss)this.g.I(this.Wx(),this.tx());else{a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).Gj(this.ti);var b=this;a instanceof hb?a.Bg()?(this.ti=null,this.Rx&&(this.g.U().PA(),this.g.bf(),
this.Rx=!1),this.ht=!0,this.g.U().Oo(a,function(){b.ht=!1;b.g.I(b.Wx(),b.tx())},function(c){return b.Km(c)})):(this.ti=a,this.g.I(this,0)):this.S(a)}},Wx:function(){return!this.g.A.$p&&4E3<=J.m()-this.Ly?(this.Ly=J.m(),new Tf(this.g,this)):null!==this.g.i?new Nf(this.g,this):this},tx:function(){var a=this.g.Bb;if(null!==this.g.i&&3===this.g.i.direction)return this.g.getConfiguration().UpdateRate;if(a.empty()&&null===this.g.i){var b=J.m(),c=this.g.getConfiguration().UpdateRate;a=b-a.Ny;return 0<=a&&
a<Math.min(2*c,500)?Math.max(10,c/5):Math.max(10,c-(b-this.HL))}return 0},VG:function(a){a.bN()},S:function(a,b){var c=!1,d=!1,e="";"number"===typeof b?b>=$a.h&&100>=b&&(d=!0,e="Err="+b):"Client id not present or no longer valid"===a?(d=!0,e="Err=1000"):"Unexpected format of service: 6"===a&&(d=!0,e="Err=1001");d&&this.g.Tb.IO()&&(this.g.Tb.mS(!0),b=this.g.Tb.mw,b+=location.pathname,b+=location.search,b+="#CKT="+this.g.Tb.hw,"TRACE"===this.g.getConfiguration().LogLevel&&(b+="#"+e),location.assign(b),
c=!0);!1===c&&("Unexpected format of service: 6"===a?(this.g.Zc.yj()&&this.g.Zc.Hj(!1),this.g.LC()):this.g.error("Error while processing the visualization: "+a))},Km:function(a){var b=-1;this.g.pa&&(b=this.g.Di.Gn);return-1!==b?(this.De.length=0,this.Gz(a),a instanceof Jd&&(a=a.uc(),b=this.g.Lx.D(b,a),void 0!==b&&null!==b&&this.Gz(b),this.g.Di.tF()),this.De):null},Gz:function(a){this.De.push(a)},className:function(){return"VisuOnlineState"}};var pg;pg=function(a){this.g=a;this.rL=0};
pg.prototype={j:function(){var a=this.g.eb(),b=this.g.ob();b.ES(this.g.A.la);a.wb(b.qb(),this)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).KP();"number"===typeof a?0===a?(N.m("Successfully finished visu registration: "+this.g.A.la),a=this.g.NB(),""!==a?(this.g.Tb.vm=!0,this.g.I(new ig(this.g,a),0)):this.g.I(new lg(this.g),0)):1===a?(0===this.rL++%20&&N.info("Still polling the registration of the visualization. Is the visu stopped?"),this.g.I(this,this.g.getConfiguration().PollingRegistrationInterval)):
this.S("Unexpected return value: "+a):this.handleError(a)},handleError:function(a){"The maximum number of visualization clients is already connected. Please try again later."===a||"Not enough memory in the PLC to create the client."===a?this.g.pE()&&""!==this.g.A.Gc&&this.g.A.Gc!==Ua.J?this.mO(a):this.MN(a):this.S(a)},mO:function(a){"The maximum number of visualization clients is already connected. Please try again later."===a?(a=new fd(0,this.g.A.cf,2,248),this.g.I(new uc(this.g,a,!0),0)):"Not enough memory in the PLC to create the client."===
a&&(a=new fd(0,this.g.A.cf,2,247),this.g.I(new uc(this.g,a,!0),0))},S:function(a){this.g.error("Visu registration in the plc failed: "+a,!0)},MN:function(a){this.g.error(a)},className:function(){return"VisuPollingRegistrationState"}};var Xf;Xf=function(a){this.g=a};
Xf.prototype={j:function(){var a=this.g.eb(),b=this.g.ob(),c=this.g.getConfiguration();b.GS(c.Application,c.ClientName,this.g.A.eq,this.g.Oc);a.wb(b.qb(),this)},Xb:function(a){a=(new jd(a,this.g.A.Fa,this.g.zb.yb)).LP();"number"===typeof a?(N.m("Successful first visu registration step: "+a),this.g.A.la=a,window.ProgrammingSystemAccess&&window.ProgrammingSystemAccess.notifyValidExternId(a),this.g.getConfiguration().CasFactoryName&&this.Al(),a=new pg(this.g),this.g.I(a,this.g.getConfiguration().PollingRegistrationInterval)):
"no rights"===a?(this.AM.yj()&&this.AM.Hj(!1),this.g.LC()):this.S(a)},S:function(a){this.g.error("Visu registration in the plc failed: "+a)},className:function(){return"VisuRegistrationState"},Al:function(){var a=this.g.A;if(null!==a&&a.la!==Ua.m&&(a.Th!==Ua.xa||this.Oc)){var b=this.g.ob(a);b.$u(a.la);this.g.eb().Al(b.qb())}}};var Ub;Ub=function(a){this.g=a;this.Jd=this.yh=null;this.Ml()?this.yj()&&this.h():N.warn("AutoSignIn not supported or blocked by browser!")};
Ub.prototype={yj:function(){try{return"localStorage"in window?"true"===window.localStorage.getItem("AutoSignInEnabled"):!1}catch(a){return!1}},Ml:function(){return"localStorage"in window&&"PasswordCredential"in window&&"credentials"in navigator&&"get"in navigator.credentials&&"store"in navigator.credentials},Hj:function(a){"localStorage"in window&&window.localStorage.setItem("AutoSignInEnabled",a);a||(this.password=this.username=null)},h:function(){if(this.Ml())try{var a=this;navigator.credentials.get({password:!0}).then(function(b){b?
(a.yh=b.id,a.Jd=b.password):a.Hj(!1)})}catch(b){N.error("Error while reading credentials :"+b)}},iQ:function(a,b){if(this.Ml())try{var c=new PasswordCredential({id:a,password:b});navigator.credentials.store(c).then(function(){N.h("Successfully stored credentials")})}catch(d){N.error("Error while storing credentials :"+d)}},xB:function(){return[this.yh,this.Jd]}};var bg;bg=function(a,b,c){this.g=a;this.bb=b;this.Ib=c};
bg.prototype={$D:function(){var a=window.document.createElement("div"),b=this.Ie("Ok"),c=this.Ie("Cancel"),d=this.tH(),e=this;b.addEventListener("click",function(){e.BK(a,d.username,d.password)},!1);c.addEventListener("click",function(){e.uh(a)},!1);a.style.boxShadow=a.style.WebkitBoxShadow="2px 2px 6px 6px rgba(0,0,0,0.5)";a.align="center";a.appendChild(d.form);a.appendChild(b);a.appendChild(c);window.document.body.appendChild(a);J.Ya(a,this.Lw(300,200));a.style.zIndex=300;a.style.backgroundColor=
"#d4d0c8";d.username.focus()},tH:function(){var a=window.document.createElement("table"),b=window.document.createElement("input"),c=window.document.createElement("input"),d=window.document.createElement("form");b.autocomplete="username";c.type="password";c.autocomplete="current-password";a.border="0";a.appendChild(this.jx("Username: ",b));a.appendChild(this.jx("Password: ",c));d.appendChild(a);return{form:d,table:a,username:b,password:c}},jx:function(a,b){var c=window.document.createElement("tr"),
d=window.document.createElement("td");d.appendChild(window.document.createTextNode(a));c.appendChild(d);d=window.document.createElement("td");d.appendChild(b);c.appendChild(d);return c},Lw:function(a,b){var c=this.g.U().Jf();return new I((c.u+c.V-a)/2,(c.v+c.ca-b)/2)},Vw:function(a){window.document.body.removeChild(a)},BK:function(a,b,c){this.Vw(a);this.g.XC(!1);this.bb.Error=0;this.g.I(new Wf(this.g,b.value,c.value,this.Ib,0,this.bb),0)},uh:function(a){this.g.Uu("The user did not provide credentials.",
"No credentials");this.Vw(a)},Ie:function(a){var b=window.document.createElement("input");b.type="button";b.value=a;return b}};var $f;$f=function(a){this.sb=this.Dd=null;this.ha=!0;this.HK=a;this.Hm=null;this.ih=this.qA=this.hj=!1;this.Nc=null;this.cl=-1;this.es=0};
$f.prototype={Iv:function(a){var b;if(null!==a){if(this.Hm=a)this.Dd=new Uint8Array(this.Hm),this.sb=new yc(this.Hm,this.ha,this.HK),a=this.sb.getUint16(),65279===a?this.hj=!0:48111===a&&(a=this.sb.getUint8(),191===a&&(this.qA=!0)),this.ih=!0;a=this.YI();if(null!==a&&(a=a.split(";"),2<=a.length&&(this.es=a.length,"ID"===a[0].toUpperCase()&&"DEFAULT"===a[1].toUpperCase()&&2<a.length)))for(this.Nc=[],b=2;b<a.length;b++)this.Nc.push(a[b])}},jE:function(a,b,c,d){var e=null,f,g=a.toUpperCase();if(this.ih&&
-1!==this.cl&&null!==this.Nc){for(a=0;a<this.Nc.length&&this.Nc[a].toUpperCase()!==g;a++);if(0<=a&&a<this.Nc.length){d?f=b:f="$"+b+"$";for(this.sb.seek(this.cl);;){b=this.by();if(null===b)break;b=b.split(";");if(b.length===this.es&&(d=!1,c?D.CF(b[1],f)&&(d=!0):b[1]===f&&(d=!0),d)){e=b[2+a];break}}if(null!==e&&D.xb(e,"$"))for(b=e.split("$"),e="",c=0;c<b.length;c++)e=e.concat("",b[c])}}return e},iE:function(a,b){var c=null;var d=a.toUpperCase();if(this.ih&&-1!==this.cl&&null!==this.Nc){for(a=0;a<this.Nc.length&&
this.Nc[a].toUpperCase()!==d;a++);if(0<=a&&a<this.Nc.length)for(this.sb.seek(this.cl);;){d=this.by();if(null===d)break;d=d.split(";");if(d.length===this.es&&d[0]===b){c=d[2+a];break}}}return c},YI:function(){var a=null;if(this.ih){this.hj?this.sb.seek(2):this.qA?(this.sb.Lj("utf-8"),this.sb.seek(3)):this.sb.seek(0);var b=this.$x();-1!==b&&(a=this.Zx(b),this.cl=this.sb.ga())}return a},by:function(){var a=null;if(this.ih){var b=this.$x();-1!==b&&(a=this.Zx(b))}return a},Zx:function(a){a=this.sb.ja(a,
this.hj);var b=this.sb.ga();b=this.hj?b+4:b+2;this.sb.seek(b);return a},$x:function(){for(var a=this.sb.ga(),b=-1,c;!this.sb.If();)if(c=this.sn(),"\r"===c){this.sb.If()||(c=this.sn(),"\n"===c&&(b=this.sb.ga()-a,this.hj?(b-=4,b/=2):b-=2,this.sb.seek(a)));break}return b},sn:function(){return this.hj?String.fromCharCode(this.sb.getUint16()):String.fromCharCode(this.sb.getUint8())},className:function(){return"LocalizedTextsFileRead"}};var Zf;
Zf=function(a){this.me=null;this.ke=this.le=0;this.fe=this.Cd=4294967295;this.Yg="";this.tl=this.Ei=!1;this.ha=a};
Zf.prototype={mF:function(a){var b=0;this.me=null;if(null!==a&&a){var c=new DataView(a);if(14<c.byteLength){var d=c.getUint8(b);b+=2;if(1===d&&(d=c.getUint8(b),1===d&&!0===this.ha||0===d&&!1===this.ha)){b+=2;this.le=c.getUint16(b,this.ha);this.ke=c.getUint16(b+2,this.ha);b+=4;var e=c.getUint8(b);d=c.getUint8(b+1);var f=c.getUint8(b+2);var g=c.getUint8(b+3);b+=4;this.fe=e<<24;this.fe|=d<<16;this.fe|=f<<8;this.fe|=g;e=c.getUint8(b);d=c.getUint8(b+1);f=c.getUint8(b+2);g=c.getUint8(b+3);b+=4;this.Cd=
e<<24;this.Cd|=d<<16;this.Cd|=f<<8;this.Cd|=g;d=c.getUint16(b,this.ha);b+=2;if(0<d){f=Array(d);for(e=0;e<d;e++)f[e]=c.getUint8(b),b+=1;this.Yg=String.fromCharCode.apply(null,f)}else this.Yg="";e=c.getUint16(b,this.ha);b+=2;this.Ei=e&1?!0:!1;this.tl=e&2?!0:!1;e=c.getUint16(b,this.ha);b+=2;c=c.getUint32(b,this.ha);b+=4;this.me=new hb(e,c,0);this.me.Wd().Bo(a,b,c);this.me.finish();N.h("The paintbuffer of the login page has been read from the file, command: "+e+", dataSize: "+c)}}}},className:function(){return"PaintBufferFileRead"}};
var ag;ag=function(a,b,c){this.g=a;this.bb=b;this.T=c;this.nk="";var d=this;this.Xg=null;this.g.Zc.yj()&&(this.Xg=setInterval(function(){null!==d.g.Zc.xB()[0]&&(d.T.Au(!0),clearInterval(d.Xg))},.5))};
ag.prototype={dE:function(a,b){var c=a.ka,d=this,e=!1,f=a.uc(),g=null;var k=null;var l=this.T;l.zp("");this.nk="";k=this.fh(c,"$USERNAME_PH$");var G=this.fh(c,"$USERNAME_STAR_PH$");if("$USERNAME$"===c||"$USERNAME_STAR$"===c||"$USERNAME_PH$"===k||"$USERNAME_STAR_PH$"===G){var u="";"$USERNAME_PH$"===k&&(u=this.Ne(l.Eb,k,!0,!1));"$USERNAME_STAR_PH$"===G&&(u=this.Ne(l.Eb,G,!0,!1));null!==u&&""!==u&&l.zp(u);null===l.Af?(g=this.Cz(f,"$USERNAME_STAR$"===c||"$USERNAME_STAR_PH$"===G,a),l.yR(g)):b&&(l.Af.be(f),
g=l.Af);null!==g&&(l.vp(g),e=!0)}if(!1===e){k=this.fh(c,"$PASSWORD_PH$");G=this.fh(c,"$PASSWORD_CLEARTEXT_PH$");if("$PASSWORD$"===c||"$PASSWORD_CLEARTEXT$"===c||"$PASSWORD_PH$"===k||"$PASSWORD_CLEARTEXT_PH$"===G)u="","$PASSWORD_PH$"===k&&(u=this.Ne(l.Eb,k,!0,!1)),"$PASSWORD_CLEARTEXT_PH$"===G&&(u=this.Ne(l.Eb,G,!0,!1)),null!==u&&""!==u&&l.zp(u),null===l.zf?(g=this.Cz(f,"$PASSWORD$"===c||"$PASSWORD_PH$"===k,a),l.wR(g)):b&&(l.zf.be(f),g=l.zf);null!==g&&(l.vp(g),g.Vb().addEventListener("keypress",function(va){"Enter"===
va.key&&(null!==d.Xg&&clearInterval(d.Xg),d.T.Au(!0))},!1),e=!0)}if(!1===e){k=this.rr(c,"$LANG_SELECTOR$");if("$LANG_SELECTOR$"===c||"$LANG_SELECTOR$"===k)null===l.kg?(g=this.TK(f,a),g.Vb().addEventListener("change",function(){var va=d.T.kg;null!==va&&(va=va.Vb().value,d.T.fm(va))},!1),l.vR(g)):b&&(l.kg.be(f),g=l.kg);null!==g&&(l.vp(g),e=!0)}if(!1===e&&(k=this.rr(c,"$LANG$"),G=this.rr(c,"$LANG_DEF$"),"$LANG$"===c||"$LANG$"===k||"$LANG_DEF$"===c||"$LANG_DEF$"===G)){if(""===this.nk)u=Wa.xa;else{u=this.nk;
var ka="";k=c.split("$");5===k.length&&(ka=k[3])}null===l.Xo(u)?(("$LANG_DEF$"===c||"$LANG_DEF$"===G)&&""!==u&&this.g.FB()&&l.fm(u),g=this.el(),g.pt(u),g.Vb().addEventListener(D.Qb()?"pointerup":"mouseup",function(){d.T.fm(this.id)},!1),l.uR(u,g)):b&&(l.Xo(u).be(f),g=l.Xo(u));u=this.Ne(l.Eb,"$LANG$$"+u+"$",!0,!1);null!==u&&""!==u&&(ka=u);l.tc().Ob(ka);null!==g&&(l.Gg(g),e=!0)}!1===e&&"$SYS_ERROR$"===c&&(g=l.tc(),e=!0,k="",!1===this.g.Qx&&this.bb.Error!==Ua.h&&(k=l.$N(this.bb.Error,l.Eb),e=!1),g.Ob(k),
g.Fu(e),null!==l.fs&&l.fs.Fu(e),e=!0);!1===e&&(k=this.fh(c,"$AUTOSIGNIN_CUSTOMIZED$"),"$AUTOSIGNIN$"===k&&(this.g.Zc.Ml()||l.tc().Ob(""),null===l.ig&&this.g.Zc.Ml()?(g=this.SK(),u=this.Ne(l.Eb,k,"$LOGIN_CUSTOMIZED$"===k,!1),this.g.Zc.yj()||g.Vb().addEventListener("checkboxChanged",function(va){d.g.Zc.Hj(va.detail.checked)}),null!==u&&""!==u?l.tc().Ob(u):l.tc().Ob("Store credentials in Browser"),l.tR(g)):b&&null!==l.ig&&(l.ig.be(f),g=l.ig)),null!==g&&(l.Gg(g),e=!0));if(!1===e&&(k=this.fh(c,"$LOGIN_CUSTOMIZED$"),
"$LOGIN$"===k||"$LOGIN_DOT$"===k||"$LOGIN_EMPTY$"===k||"$LOGIN_OK$"===k||"$LOGIN_CUSTOMIZED$"===k)){null===l.th?(g=this.el(),g.Vb().addEventListener(D.Qb()?"pointerup":"mouseup",function(){null!==d.Xg&&clearInterval(d.Xg);d.T.Au(!0)},!1),l.sR(g)):b&&(l.th.be(f),g=l.th);u=this.Ne(l.Eb,k,"$LOGIN_CUSTOMIZED$"===k,!1);if(null!==u&&""!==u)l.tc().Ob(u);else switch(k){case "$LOGIN$":l.tc().Ob("LOGIN");break;case "$LOGIN_DOT$":l.tc().Ob("...");break;case "$LOGIN_EMPTY$":l.tc().Ob(" ");break;case "$LOGIN_OK$":l.tc().Ob("OK");
break;case "$LOGIN_CUSTOMIZED$":l.tc().Ob(l.oo)}null!==g&&(l.Gg(g),e=!0)}if(!1===e){k=this.fh(c,"$CANCEL_CUSTOMIZED$");if("$CANCEL$"===k||"$CANCEL_DOT$"===k||"$CANCEL_EMPTY$"===k||"$CANCEL_CUSTOMIZED$"===k)if(null===l.hg?(g=this.el(),g.Vb().addEventListener(D.Qb()?"pointerup":"mouseup",function(){clearInterval(d.Xg);d.T.EQ(!0)},!1),l.rR(g)):b&&(l.hg.be(f),g=l.hg),u=this.Ne(l.Eb,k,"$CANCEL_CUSTOMIZED$"===k,!1),null!==u&&""!==u)l.tc().Ob(u);else switch(k){case "$CANCEL$":l.tc().Ob("CANCEL");break;case "$CANCEL_DOT$":l.tc().Ob("...");
break;case "$CANCEL_EMPTY$":l.tc().Ob(" ");break;case "$CANCEL_CUSTOMIZED$":l.tc().Ob(l.oo)}null!==g&&(l.Gg(g),e=!0)}if(!1===e&&(k=this.dJ(c,"$URL$"),"$URL$"===k)){k=ka=G="";var ja=c.split("$");u=0;1<ja.length&&"URL"===ja[1]&&(G=ja[2],u=this.Ne(l.Eb,G,!1,!0),null!==u&&""!==u&&(G=u),2<ja.length&&(ka=ja[3],3<ja.length&&(k=ja[4])),u=l.lO(),null===l.JB(u)?(g=l.Ez instanceof Cb?this.Dz(l.Jh(),a):this.Dz(f,a),g.Ob(G),g.$R(ka,"replace"===k?!1:!0),g.Ij("transparent"),l.xR(u,g)):b&&(g=l.JB(u),g.be(f)));null!==
g&&(l.vp(g),e=!0)}!1===e&&(u=this.Ne(l.Eb,c,!1,!0),null!==u&&""!==u&&a.Ob(u))},fh:function(a,b){var c=a;0===c.indexOf(b)&&(c.length>b.length&&"$"===c.charAt(c.length-1)?(this.T.zp(a.substring(b.length,c.length-1)),c=b):c="");return c},rr:function(a,b){var c=a;0===c.indexOf(b)&&(a=a.split("$"),3<a.length?(this.nk=a[2],c=b):0>a.length&&(c=""));return c},Ne:function(a,b,c,d){var e=this.T.rh;return""!==a&&null!==e&&(a=e.jE(a,b,c,d),null!==a)?a:""},dJ:function(a,b){0===a.indexOf(b)&&(a.length>b.length&&
"$"===a.charAt(a.length-1)?a=b:a="");return a},Cz:function(a,b,c){a=new Of(a,b,this.g.U());b=this.T;a.Lg(b.Fh(),b.Gh());a.Zl(c.Qt(),c.Vt());a.Ze(b.Jl());a.BR(b.oo);a.Ij(b.Fi);a.setColor(b.Eh());return a},TK:function(a,b){a=new Qf(a,this.g.U());var c=this.T.rh,d=this.T,e=[];a.Lg(d.Fh(),d.Gh());a.Zl(b.Qt(),b.Vt());a.Ze(d.Jl());a.Ij(d.Fi);a.setColor(d.Eh());null!==c&&(null!==c.Nc&&(e=c.Nc.slice()),a.mR(e));b=this.nk;""!==b?this.g.FB()?d.fm(b):a.nD(d.Eb):a.nD(d.Eb);return a},el:function(){var a=this.T,
b=new Lf(a.Jh(),this.g.U(),null);b.setRadius(a.MB(a.Jh().C(),a.Jh().B()));b.CQ(a.Fe);b.BQ(a.kf);b.Ze(a.Jl());b.DQ(1<a.Qe?a.Qe:a.Qe+1);return b},SK:function(){var a=this.T,b=new Mf(a.Jh(),this.g.U());b.setRadius(a.MB(a.Jh().C(),a.Jh().B()));b.Ze(a.Jl());return b},Dz:function(a,b){var c=this.T;a=new Rf(a,this.g.U());a.Lg(c.Fh(),c.Gh());a.Zl(b.Qt(),b.Vt());a.Ze(c.Jl());a.Ij(c.Fi);a.setColor(c.Eh());return a},className:function(){return"PlaceHoldersHelper"}};var qg;
qg=function(a,b){this.g=a;this.Cn=this.Ge=null;this.fb=[];this.nb=-1;this.Ck=[];this.Ab=b;this.RK=D.Qb();this.Lz(this.fb,!1)};
qg.prototype={register:function(a,b){this.Ge=a;this.Cn=b},sc:function(){return this.g.sc()},handleEvent:function(a,b){var c=this.RK;switch(b){case db.J:return c?this.Tn(a,!1):this.mg(a.tb,!1);case db.h:return c?this.$k(a,!1):this.mg(a.tb,!1);case db.m:return c?this.Zk(a,!1):this.mg(a.tb,!1);default:N.warn(J.h("BrowserTouchEventHandling.handleEvent. Unknown event: {0}",b))}return!1},pb:function(){this.g.He.Lt();this.kl(this.fb);this.kl(this.Ck)},Hh:function(){return this.g.pa?J.Za():this.Ab.Hh()},
Kz:function(a){var b;for(b=0;b<a.length;++b)this.Hh().addEventListener(a[b].e,a[b].Na,a[b].c)},kl:function(a){var b;for(b=0;b<a.length;++b)this.Hh().removeEventListener(a[b].e,a[b].Na)},Lz:function(a,b){var c=b?"Capturing ":"";D.Qb()?(N.h(c+"Touchsupport using PointerEvents"),this.wI(a,b),this.Kz(a)):"ontouchstart"in window?(N.h(c+"Touchsupport using TouchEvents"),this.xI(a,b),this.Kz(a)):N.warn("No touch support")},xI:function(a,b){if(!(this.Ab instanceof Tc)){var c=this,d=function(e){c.mg(e,b)};
a.push({e:"touchstart",Na:d,c:b});a.push({e:"touchmove",Na:d,c:b});a.push({e:"touchend",Na:d,c:b})}},wI:function(a,b){if(!(this.Ab instanceof Tc)){var c=this;a.push({e:"pointerdown",Na:function(d){c.xK(new Yc(d),b)},c:b});a.push({e:"pointermove",Na:function(d){c.Zk(new Yc(d),b)},c:b});a.push({e:"pointerup",Na:function(d){c.$k(new Yc(d),b)},c:b})}},cL:function(){0<this.Ck.length||!this.g.pa||this.Ab instanceof Tc||this.Lz(this.Ck,!0)},$G:function(){0<this.Ck.length||!this.g.pa||this.Ab instanceof Tc||
this.kl(this.Ck)},jM:function(a,b){var c;for(c=0;c<a.length;++c)if(a[c].identifier===b)return!0;return!1},Aq:function(a,b,c){var d;for(d=0;d<a.length;++d){var e=a[d];b.Bh(this.Ab.At(new Yc(e),c))}},uw:function(a,b,c){var d;for(d=0;d<a.length;++d){var e=a[d];this.jM(b,e.identifier)||c.Bh(this.Ab.At(new Yc(e),V.Be))}},MH:function(){null!==this.g.getConfiguration()&&this.g.getConfiguration().WorkaroundDisableMouseUpDownAfterActiveTouch&&this.g.On.gR(J.m()+this.g.getConfiguration().WorkaroundSetIgnoreTimeMsForMouseUpDownAfterActiveTouch)},
mg:function(a){if(!this.g.fp()&&null!==this.Ge){this.eA(a);this.MH();this.g.qT().Ho(a);var b=new rg;"touchstart"===a.type?(0===this.sc().Size()&&this.g.He.Ko(),this.Aq(a.changedTouches,b,V.Wc),this.uw(a.targetTouches,a.changedTouches,b,V.Be)):"touchmove"===a.type?this.Aq(a.targetTouches,b,V.Be):(this.Aq(a.changedTouches,b,V.Xc),this.uw(a.targetTouches,a.changedTouches,b,V.Be),0===a.targetTouches.length&&this.TT.He.Mo());this.Ge(b)}},xK:function(a,b){if(!this.g.fp()){var c=a.tb;if(this.Tn(a,b)&&this.g.pa){var d=
this;this.g.Bi.tt(c,d,function(e){d.Zk(new Yc(e),b)},function(e){d.$k(new Yc(e),b)})}}},Tn:function(a,b){var c=a.tb;return"touch"===c.pointerType?(this.g.rb.cP(c),this.g.he.Ho(c),0===this.sc().Size()&&this.g.He.Ko(),this.au(c,b)?(N.warn(J.h("Unexpected Pointerdown event for id: {0}; Ignored!",c.pointerId)),!1):this.wr(a,b,V.Wc)?!0:!1):!1},$k:function(a,b){if(this.g.fp())return!1;var c=a.tb;if(!this.au(c,b))return!1;if("touch"===c.pointerType){this.g.rb.dP(c);if(!this.wr(a,b,V.Xc))return!1;0===this.sc().Size()&&
this.g.He.Mo();return!0}return!1},Zk:function(a,b){if(this.g.fp())return!1;var c=a.tb;return this.au(c,b)?"touch"===c.pointerType?this.wr(a,b,V.Be)?!0:!1:!1:!1},wr:function(a,b,c){this.uL(c);var d=this.Ab.At(a,c);this.sM();switch(c){case V.Wc:this.sc().gF(d);break;case V.Be:case V.Xc:this.sc().Bv(d.id()),this.sc().SF(d)}var e=this.ZI();if(b&&c===V.Wc)if(this.Cn(e))d.Cu(!0);else return this.sc().Rv(d),!1;e.PQ(a.tb);this.Ge(e);c===V.Xc&&this.sc().Rv(d);this.eA(a.tb);return!0},uL:function(a){a==V.Wc&&
0<this.g.getConfiguration().tq&&J.m()-this.XJ>this.g.getConfiguration().tq&&0<this.sc().Size()&&(N.warn("Touchhandling: Sanitycheck discarding obsolete events"),this.sc().FD(),null!==this.g.Le&&this.g.Le.hQ());this.XJ=J.m()},au:function(a,b){a=J.Mf(a);if(-1===this.sc().im(a))return!1;a=this.sc().Bv(a);return b?a.Nk:!0},ZI:function(){var a=new rg;this.sc().HD(a);return a},sM:function(){this.sc().RF(V.Be)},eA:function(a){a.preventDefault();a.stopPropagation()}};var Yc;
Yc=function(a,b,c,d){void 0===d&&(d=null);void 0===b&&(b=J.pB(a)?J.Rj(a.target,J.Za()).offset(D.hq(a)):J.Uj(a)?J.Rj(a.target,J.Za()).offset(D.ci(a)):new I(-1,-1));void 0===c&&(c=b);this.tb=a;this.aj=b;this.Ld=c;this.Db=d;this.Fz=null};Yc.prototype={CR:function(a){this.Fz=a},Ca:function(){return this.Db},$d:function(a){this.Db=a}};var sg;sg=function(a){this.Ae=this.dd=null;a||(a=V.Yc);this.Db=null;this.Ap(a)};
sg.prototype={type:function(){if(null===this.dd)throw Error("Unexpected call. Gesture data not yet assigned");return this.dd.type()},$d:function(a){this.Db=a},Ca:function(){return this.Db},Ap:function(a){if(null===this.dd||this.type()!==a)switch(a){case V.ef:this.dd=new tg;break;case V.Yc:this.dd=new ug;break;case V.Sg:this.dd=new vg;break;case V.Ce:this.dd=new wg(!1);break;case V.ee:this.dd=new wg(!0);break;default:throw Error("Unexpected gesture type");}},data:function(){return this.dd},clone:function(){var a=
new sg;null!==this.dd&&(a.dd=this.dd.clone());null!==this.Db&&(a.Db=this.Db);a.Ae=this.Ae;return a}};var V;V={Be:1,Xc:2,Wc:4,Cm:8,lw:16,cq:5,Yc:0,Sg:1,ef:2,Ce:3,ee:4,Rg:0,Bm:1,QF:2,Am:4,jw:8,kw:16,TS:255,zd:0,Zj:5,$j:10};V.Vc=V.$j;V.ak=11;V.ze=12;V.df=13;V.BF=V.df;var xg;xg=function(){this.Ip=this.Vj=this.jm=this.um=this.Mp=!1};var yg;yg=function(){this.Cb=[]};
yg.prototype={JC:function(a,b){N.m("Record GesturesTouchEvent");!this.empty()&&this.PJ(a)&&b?this.Cb[this.Cb.length-1]=a:this.Cb.push(a)},YP:function(a,b){N.m("Replay");for(var c;"undefined"!==typeof(c=this.Cb.shift());)a.Sl(c,b)},empty:function(){return 0===this.Cb.length},PJ:function(a){var b=this.Cb[this.Cb.length-1],c;if(a.touches().length!==b.touches().length)return!1;for(c=0;c<a.touches().length;++c){var d=a.touches()[c];var e=b.touches()[c];if(d.id()!==e.id()||d.flags()!==e.flags()||d.$(V.Xc)||
d.$(V.Wc))return!1}return!0}};var zg;zg=function(a,b,c,d,e,f){f=f?f:null;this.ta=a;this.mb=d;this.je=new Ag(b,c);this.Ld=e;this.Db=f;this.Nk=!1;this.qk=null};
zg.prototype={id:function(){return this.ta},Ca:function(){return this.Db},$d:function(a){this.Db=a},Cu:function(a){this.Nk=a},oR:function(a){this.je.JQ(a)},location:function(){return this.je},OQ:function(a){this.qk=a},Yu:function(a){this.qk=a;this.je.Yu(a)},flags:function(){return this.mb},kj:function(a){this.mb|=a},$:function(a){return(this.mb&a)===a},update:function(a){this.mb=a},clone:function(){var a=new zg(this.id(),this.location().current(),this.location().Yi,this.flags(),this.Ld,this.Ca());
a.Cu(this.Nk);return a}};var rg;rg=function(){this.Ua=[];this.iM=J.m();this.Pe=null;this.rz=!1;this.tb=null};rg.prototype={touches:function(){return this.Ua},gD:function(a){this.Pe=a},AR:function(a){this.rz=a},PQ:function(a){this.tb=a},event:function(){return this.tb},Bh:function(a){this.Ua.push(a)},timeStamp:function(){return this.iM}};var Ag;Ag=function(a,b){this.ui=a;this.Yi=new I(a.X,a.Y);void 0!==b&&null!==b&&(this.Yi=new I(b.X,b.Y));this.Hy=null};
Ag.prototype={JQ:function(a){this.ui=a},Yu:function(a){this.ui.X+=a.X;this.ui.Y+=a.Y},current:function(){return this.ui},Pl:function(){return this.Hy},fD:function(a){this.Hy=a}};var Bg;
Bg={Ot:function(a,b){var c=0<b.touches().length,d;a.data().iN();for(d=0;d<b.touches().length;++d){var e=b.touches()[d];a.data().Bh(e.clone());e.$(V.Xc)||(c=!1)}return c},TM:function(a,b){var c;for(c=0;c<a.touches().length;++c)if(a.touches()[c].$(b))return!0;return!1},lj:function(a,b){var c;for(c=0;c<a.touches().length;++c)if(!a.touches()[c].$(b))return!1;return!0},hB:function(a){var b=V.jw|V.kw;1===a.touches().length?b|=V.Bm|V.Am:2===a.touches().length&&(b|=V.QF);return b},Ll:function(a){return a===
V.Ce||a===V.ee}};var qc;qc=function(a,b){var c=this;this.g=a;this.Ab=b;this.hJ=!(b instanceof Tc);this.vk=new qg(a,this.Ab);this.vk.register(function(d){c.Ge(d)},function(d){return c.Cn(d)});this.Od=null;this.ya=new Cg;this.Ds=-1;this.Xz("none");this.Mr=new Dg(this.g.qg)};
qc.prototype={pb:function(){this.Xz("auto");this.vk.pb()},handleEvent:function(a,b){return this.vk.handleEvent(a,b)},xo:function(a,b){this.ya.mt(a,b);this.UG(a)},uu:function(a){this.ya.VP(a)},NA:function(){this.ya.clear();this.ZG()},xp:function(a){this.g.N.xp(a);a&&(this.Od=this.Ab.Jo(!0))},dO:function(){return this.g.qg.Ut()},GB:function(){return this.g.qg.So()},Zo:function(){return this.g.qg.Zo()},qp:function(a,b,c){a=Fa.Pb(a,this.g.A.la,b);void 0!==c&&null!==c&&a.$d(c);this.Ab.rd(a)},SO:function(){return this.Mr.active()},
uD:function(){this.Mr.stop()},uB:function(a,b,c){var d=new xg;c=this.JH(a,b,c);this.Jr(a,V.jw)&&this.ya.PN(b,c,this.hJ)?d.Ip=!0:this.Jr(a,V.kw)&&this.ya.SM(b,c)?d.Vj=!0:this.Jr(a,V.Bm|V.Am)&&(a=[],this.ya.cN(b,a,c),d.um=a[0],d.jm=a[1]);d.Mp=!this.SG();return d},JH:function(a,b,c){if(this.g.pa){if(void 0===c){a=b.touches();if(0<a.length)for(b=0;b<a.length;b++)if(a[b]&&a[b].Nk)return Uc.Jp;return 0}return c?Uc.Jp:Uc.CD}return 0},Pt:function(a,b,c){if(a>=V.$j&&a<=V.BF)if(b.type()===V.Yc||b.type()===
V.Sg){if(this.LI(a,b,b.Ae,c))return!0}else if(this.OJ(b.type())&&this.MI(a,b,b.Ae))return!0;return!1},xl:function(){this.g.N.xN();!this.g.N.ep()&&this.g.Le.buffer().empty()&&(N.h("Acknowledged gesture and queue empty -> record := false"),this.g.N.Ku(!1))},Xz:function(a){this.Ab.Hh().style.touchAction=a},SG:function(){return this.g.N.ep()?(N.h("New gesture starting despite currently ignored -> record := true"),this.g.N.Ku(!0),!1):!0},Jr:function(a,b){return(a&b)===b},OJ:function(a){return a===V.ef||
Bg.Ll(a)},vy:function(a){return a===V.ee},xy:function(a){return null!==a&&null!==a.da&&(a=a.da,a instanceof Kc&&a.We())?!0:!1},LI:function(a,b,c){var d=Y.Xh;if(a===V.Vc){c=this.ya.rB(b);if(null===c)return!0;var e=c.da;if(null!==e&&e.gp())return!0;this.xy(c)&&e.VM();b.Ae=c;this.TL(c);this.g.N.tO()}else if(a===V.df||a===V.ze)this.xy(c)?a=this.kJ(c,b):null===c||b.type()===V.Yc&&this.Mr.start(this.g.U(),c,this.Od,b,this)||(this.Jx(d,b,c),this.Bz(b,c));if(null!==c){if(b.type()===V.Sg||b.type()===V.Yc)d=
b.data().FA(c,a,this);Y.wj(d,Y.ev)&&(d=Y.Ye(d,Y.rv))}a!==V.ze&&(this.Jx(d,b,c),this.Od.Kh(this.g.U(),c));return!1},kJ:function(a,b){var c=a.da;var d=c.Va;var e=c.Ma;var f=d.style.left;var g=d.style.top;e=this.LL(e,d,c,b);this.uD();this.xl();c.yu();b.dd.nQ(e);this.NL(a,b,d,f,g,e);return V.ze},mA:function(a,b,c,d){var e=b.da;this.nM(a,b,c);d.style.transition="";c||e.xD()},NL:function(a,b,c,d,e,f){var g=this;var k=a.da;var l=k.Ma;c.style.transition="all 200ms ease-in-out";k.vD();this.nI(l,c,d,e)?setTimeout(function u(){g.mA(b,
a,f,c);this.removeEventListener("transitionend",u)},0):c.addEventListener("transitionend",function ka(){g.mA(b,a,f,c);this.removeEventListener("transitionend",ka)},!1)},nI:function(a,b,c,d){return a.Zt()?b.style.left===c:b.style.top===d},nM:function(a,b,c){c&&this.$n(a,b)},LL:function(a,b,c,d){var e=d.data().lu();d=d.data().Ve();var f=Math.abs(e.X)>Math.abs(e.Y);var g=Math.abs(e.Y)>Math.abs(e.X);if(a.Zt()){if(b.style.left="0px",(Math.abs(e.X)>c.na/3||5<Math.abs(d.X))&&f){if(0<e.X){if(b.style.left=
c.na+"px",!c.cp())return b.style.left="0px",!1}else if(b.style.left=-c.na+"px",!c.bp())return b.style.left="0px",!1;return!0}}else if(a.kC()&&(b.style.top="0px",(Math.abs(e.Y)>c.ra/3||5<Math.abs(d.Y))&&g)){if(0<e.Y){if(b.style.top=c.ra+"px",!c.cp())return b.style.top="0px",!1}else if(b.style.top=-c.ra+"px",!c.bp())return b.style.top="0px",!1;return!0}return!1},TO:function(a,b){var c=this.Od.Aj(b);this.Bz(a,b);this.qp(4098,c,a.Ca())},MI:function(a,b,c){if(a===V.Vc){c=this.ya.rB(b);if(null===c&&!this.vy(b.type()))return!0;
b.Ae=c;Bg.Ll(b.type())&&this.$n(b,c)}else if(null!==c||this.vy(b.type()))Bg.Ll(b.type())?this.$n(b,c):(a===V.df||a===V.ze)&&this.$n(b,c);return!1},$n:function(a,b){b=a.data().createEvent(this.g.A.la,b,this.Ab);null!==a.Ca()&&b.$d(a.Ca());this.xx(b)},xx:function(a){this.Ab.rd(a)},Bz:function(a,b){var c=a.data().createEvent(this.g.A.la,b,this.Ab);c.iD(b.za);null!==a.Ca()&&c.$d(a.Ca());this.xx(c)},TL:function(a){a.info().zoom().wp(1);a.info().scroll().Jg(new I(0,0));this.g.N.Pi||this.Od.st(this.g.U(),
a.za)},Jx:function(a,b,c){Y.wj(a,Y.VE)&&this.PH(a,b,c);Y.$(a,Y.oq)&&(c.info().zoom().wp(c.info().zoom().Sa().Bc),this.oG(b,c));Y.$(a,Y.nq)&&c.info().zoom().wp(c.info().zoom().Sa().Ac)},oG:function(a,b){this.Ty(Y.Zh|Y.$h,b)},PH:function(a,b,c){b.type()===V.Sg?this.Ty(a,c):b.type()===V.Yc&&this.aK(a,c)},Ty:function(a,b){var c=b.gB(),d=b.info().zoom();if(Y.$(a,Y.Wj))d.Jj(new I(d.nf.X+c.u,d.bd.Y));else if(Y.$(a,Y.Zh)){var e=d.nf.X-(1-d.Yf)*d.nf.X;d.Jj(new I(e,d.bd.Y));b.info().scroll().Jg(new I(d.bd.X-
d.nf.X,b.info().scroll().ab.Y))}Y.$(a,Y.Xj)?d.Jj(new I(d.bd.X,d.nf.Y+c.v)):Y.$(a,Y.$h)&&(e=d.nf.Y-(1-d.Yf)*d.nf.Y,d.Jj(new I(d.bd.X,e)),b.info().scroll().Jg(new I(b.info().scroll().ab.X,d.bd.Y-d.nf.Y)))},aK:function(a,b){b.oC(a)},Cn:function(a){var b=Bg.hB(a);a=this.uB(b,a,!0);return!!(a.Ip||a.jm||a.Vj||a.um)},Ge:function(a){var b=this.g.getConfiguration();null!==b&&this.g.N.Ar&&b.TouchHandlingActive&&(b.DebugOnlyPrintRawTouches&&this.eI(a),this.XG(a),null===this.Od&&(this.Od=this.Ab.Jo(!1)),this.g.N.ws?
(this.g.Le.buffer().JC(a,!0),this.Ms()):this.g.Le.Sl(a,this)&&(this.g.N.ws&&this.g.Le.buffer().JC(a,!0),this.g.Le.buffer().empty()||this.Ms()))},XG:function(a){Bg.lj(a,V.Wc)?this.g.On.eD(!0):Bg.lj(a,V.Xc)&&this.g.On.eD(!1)},Ms:function(){if(-1===this.Ds){var a=this;this.Ds=window.setTimeout(function(){a.DK()},25)}},DK:function(){this.Ds=-1;this.g.N.ep()?this.Ms():(this.g.Le.buffer().YP(this.g.Le,this),N.h("Replayed gestures and queue empty -> record := false"),this.g.N.Ku(!1))},eI:function(a){var b;
var c=J.h("Touches ({0}): ",a.touches().length);for(b=0;b<a.touches().length;++b){var d=a.touches()[b];var e="";null!==d.Ca()&&(e=" ("+d.Ca().toString()+")");var f="D";var g="";d.$(V.Be)?f="M":d.$(V.Xc)&&(f="U");d.$(V.Cm)&&(g="P");c+=J.h("[{0}{1}{2} ({3}/{4}){5}] ",g,f,d.id(),d.location().current().X,d.location().current().Y,e)}N.h(c)},UG:function(a){a.$(Uc.Jp)&&this.vk.cL()},ZG:function(){this.vk.$G()}};var Dg;Dg=function(a){this.nb=-1;this.jc=this.Zf=this.Od=this.gb=this.xh=null;this.Fy=a};
Dg.prototype={start:function(a,b,c,d,e){this.gb=a;this.xh=b;this.Od=c;this.Zf=d.clone();this.jc=e;var f=this;this.nb=window.setInterval(function(){f.Ge()},60);return-1!==this.nb},stop:function(){-1!==this.nb&&(window.clearInterval(this.nb),this.jc.TO(this.Zf,this.xh),this.nb=-1,this.Zf=this.Od=this.gb=this.xh=null)},active:function(){return-1!==this.nb},Ut:function(){return this.Fy.Ut()},So:function(){return this.Fy.So()},Ge:function(){var a=this.xh.info().scroll();1>Math.abs(a.Ve().X)&&1>Math.abs(a.Ve().Y)?
this.stop():(a.Ve().Yl(1-this.So()),a.Ve().X=J.sB(a.Ve().X),a.Ve().Y=J.sB(a.Ve().Y),a.ab.offset(a.Ve()),a=this.xh.ut(),this.xh.oC(a),Y.$(a,Y.rv)||Y.$(a,Y.WE)&&Y.$(a,Y.XE)?this.stop():this.Od.Kh(this.gb,this.xh))}};var oc;oc=function(){this.$z=0;this.ox=1;this.Sz=!0};oc.prototype={VR:function(a){this.$z=a},Ut:function(){return this.$z},NQ:function(a){this.ox=a},So:function(){return this.ox},SR:function(a){this.Sz=a},Zo:function(){return this.Sz}};var sc;
sc=function(){this.ws=this.Ar=!1;this.Br=0;this.Pi=!1};sc.prototype={dD:function(a){this.Ar=a},Ku:function(a){this.ws=a},tO:function(){this.Br++},xN:function(){this.Br--},ep:function(){return 0<this.Br},xp:function(a){this.Pi=a}};var Y;Y={Xh:0,oq:1,nq:2};Y.RS=Y.oq|Y.nq;Y.Wj=4;Y.Xj=8;Y.Zh=16;Y.$h=32;Y.VE=Y.Wj|Y.Xj|Y.Zh|Y.$h;Y.WE=Y.Wj|Y.Zh;Y.XE=Y.Xj|Y.$h;Y.rv=65536;Y.kv=131072;Y.lv=262144;Y.hv=524288;Y.jv=1048576;Y.nv=2097152;Y.mv=4194304;Y.fv=Y.kv|Y.hv;Y.gv=Y.lv|Y.jv;Y.Kp=Y.fv|Y.gv;Y.ED=Y.nv|Y.mv;
Y.ev=Y.ED|Y.Kp;Y.Ye=function(a,b){return a|b};Y.TP=function(a){return a&~Y.Kp};Y.$=function(a,b){return(a&b)===b};Y.wj=function(a,b){return 0!==(a&b)};var rc;rc=function(a){this.g=a};rc.prototype={At:function(a,b){b=this.kH(a,b,this);null!==a.Ca()&&b.$d(a.Ca());return b},kH:function(a,b){return new zg(J.Mf(a.tb),a.aj,a.Fz,b,a.Ld)},Jo:function(a){return this.g.pa?new Eg:new Fg(this.Hh(),a)},Hh:function(){return this.g.U().xg().canvas},rd:function(a){this.g.rd(a)}};var Tc;
Tc=function(a,b,c){rc.call(this,a);this.pc=b;this.lK=c};Tc.prototype=Object.create(rc.prototype);Tc.prototype.constructor=Tc;Tc.prototype.Jo=function(){return this.pc};Tc.prototype.Hh=function(){return this.lK};var pc;pc=function(a){var b;this.ma=new yg;this.il=[];this.il[0]=new Gg;for(b=1;b<V.cq;++b)this.il[b]=new Hg;this.Fs();this.Os=new Ig(a);this.N=new Jg;this.Ai=new Kg;this.Kk=null;this.cI=a.DebugOnlyPrintGestures};
pc.prototype={Sl:function(a,b){return 1>a.touches().length||a.touches().length>V.cq?!1:this.QH(a,b)},hQ:function(){this.N.wu();this.Fs()},RJ:function(a){return!this.Ai.Ji.Vj&&Bg.lj(a,V.Wc)},Ay:function(a,b){return!b.SO()&&!this.Ai.Ji.Vj&&Bg.lj(a,V.Xc)},QH:function(a,b){var c=new sg,d=!1;var e=this.QG(a,b);this.fG(a);this.vI(a);e&&(this.RJ(a)&&this.mJ(a,b),this.N.Pa.state()!==V.Vc&&this.N.Pa.state()!==V.ak||this.DI(a,b),this.N.wu(),this.Fs(),this.Ai.Ji.Ip&&this.N.Pa.ue().Ap(V.Ce));if(this.N.Pa.ue().type()!==
V.Ce&&(e=a.touches().length-1,e=this.il[e].Sl(this,a,c),e===V.Zj||e>=V.$j)){if(e>=V.$j)return null!==this.Kk?(this.Ay(a,b)&&b.qp(4098,a.touches()[0].location().Yi,a.touches()[0].Ca()),this.gl(this.Kk.state(),this.Kk.ue(),a,b),this.Kk=null,this.gl(e,c,a,b)):(this.gl(e,c,a,b),this.Ay(a,b)&&b.qp(4098,a.touches()[0].location().Yi,a.touches()[0].Ca())),!0;this.N.Pa.assign(e,c);this.N.Pa.EA(a);d=!0}if(!d)return this.Ai.Ji.Mp||(e=this.FH(c,a),this.gl(e,c,a,b)),!0;this.dr(V.zd,c);return!1},mJ:function(a,
b){var c=a.touches()[0].Ca();b.uD();null!==a.Pe&&a.rz&&(c=a.Pe.Ca());b.qp(4097,a.touches()[0].location().Yi,c)},buffer:function(){return this.ma},uO:function(a){var b=new sg(V.ee);a=a.clone();a.update(V.Wc|V.Cm);b.data().Bh(a);this.Kk=new Lg(b)},gl:function(a,b,c,d){if(this.N.Pa.state()!==V.ze){var e=this.N.Pa.ue().Ae;this.TG(a,b);this.dr(a,b);this.N.Pa.assign(a,b.clone());b.Ae=e;e={delay:!1,callback:function(){d.Pt(V.ze,b)}};d.Pt(a,b,e)&&(this.dr(V.ze,b),e.delay||d.Pt(V.ze,b),this.N.Pa.yp(V.ze));
this.N.Pa.ue().Ae=b.Ae;a!==V.df&&this.N.Pa.EA(c)}a===V.df&&this.N.wu()},TG:function(a,b){var c;if(a===V.Vc&&b.type()===V.ee){a=!1;for(c=0;c<b.data().touches().length;++c)if(b.data().touches()[c].$(V.Cm)){a=!0;break}if(!a)for(c=0;c<b.data().touches().length;++c)if(b.data().touches()[c].$(V.Wc)){this.N.Pa.cR(b.data().touches()[c].id());break}}if(this.N.Pa.Ux)for(c=0;c<b.data().touches().length;++c)if(b.data().touches()[c].id()===this.N.Pa.Aw){b.data().touches()[c].kj(V.lw);break}},FH:function(a,b){var c=
Bg.lj(b,V.Xc);var d=this.N.Pa.ue().type()===V.Ce?V.Ce:V.ee;a.Ap(d);Bg.Ot(a,b);return c?V.df:this.N.Pa.state()===V.Vc||this.N.Pa.state()===V.ak?V.ak:V.Vc},Fs:function(){var a;for(a=0;a<this.il.length;++a)this.il[a].yp(V.zd)},vI:function(a){var b;for(b=0;b<a.touches().length;++b){var c=a.touches()[b];this.N.xS(c)||this.N.MM(c)||N.error("Could not store touch information; probably a touch release/up was missing")}},fG:function(a){var b;if(null!==a.event().currentTarget&&null!==a.Pe&&a.Pe instanceof Kc&&
a.event().currentTarget!=a.Pe.Z&&null!==a.Pe.Va){var c=J.QB(a.Pe.Va,a.event().currentTarget);for(b=0;b<a.touches().length;++b){var d=a.touches()[b];var e=d.location().current();e.X+=c.X;e.Y+=c.Y;d.oR(e);d.OQ(c)}}},QG:function(a,b){return this.LJ(a)?(this.Ai.qR(b.uB(Bg.hB(a),a)),!0):!1},DI:function(a,b){Bg.Ll(this.N.Pa.ue().type())&&Bg.Ot(this.N.Pa.ue(),a);this.gl(V.df,this.N.Pa.ue(),a,b)},LJ:function(a){if(this.N.Pa.state()===V.zd)return!0;if(Bg.Ll(this.N.Pa.ue().type()))return Bg.lj(a,V.Wc);if(this.N.Pa.rl.length!==
a.touches().length)return!0;var b;for(b=0;b<a.touches().length;++b)if(!this.N.Pa.DO(a.touches()[b].id()))return!0;return!1},dr:function(a,b){if(this.cI){var c="";switch(a){case V.zd:N.m("No gesture");return;case V.Zj:c="Gesture (candidate); ";break;case V.Vc:c="Gesture (new); ";break;case V.df:c="Gesture (finished); ";break;case V.ak:return;case V.ze:c="Gesture (cancelled); "}c+=b.data().Lo();null!==b.Ca()&&(c+=" IdStack: "+b.Ca().toString());N.m(c)}}};var Mg;
Mg=function(){this.fa=V.zd;this.Zf=new sg;this.rl=[];this.Ux=!1;this.Aw=-1};Mg.prototype={state:function(){return this.fa},yp:function(a){this.fa=a},ue:function(){return this.Zf},cR:function(a){this.Ux=!0;this.Aw=a},assign:function(a,b){this.fa=a;this.Zf=b},EA:function(a){var b;this.rl=[];for(b=0;b<a.touches().length;++b)this.rl.push(a.touches()[b].id())},DO:function(a){var b;for(b=0;b<this.rl.length;++b)if(this.rl[b]===a)return!0;return!1}};var Kg;Kg=function(){this.Ji=null};
Kg.prototype={qR:function(a){this.Ji=a}};var Lg;Lg=function(a){this.fa=V.Vc;this.Zf=a};Lg.prototype={state:function(){return this.fa},ue:function(){return this.Zf}};var Jg;Jg=function(){this.mh=[];this.Pa=new Mg};
Jg.prototype={xS:function(a){var b;for(b=0;b<this.mh.length;++b)if(this.mh[b].id===a.id())return a.location().fD(this.mh[b].Pl),a.$(V.Xc)?this.mh.splice(b,1):this.mh[b].Pl=a.location().Pl(),!0;return!1},MM:function(a){if(!a.$(V.Wc))return!0;if(this.mh.length===V.cq)return!1;this.mh.push({id:a.id(),Pl:a.location().current()});return!0},wu:function(){this.Pa=new Mg}};var Ig;Ig=function(a){this.HI=a.GesturesFlickPanThresholdPxPerSecond;this.OK=a.GesturesPanFlickTimeThresholdMs;this.NK=a.GesturesPanClickThresholdDistSquare};
Ig.prototype={};var tg;tg=function(a){void 0===a&&(a=new I(0,0));this.qc=a;this.Df=void 0;this.Cc=new I(0,0);this.ij=0};
tg.prototype={type:function(){return V.ef},clone:function(){var a=new tg(this.qc);a.Cl(this);return a},Lo:function(){return J.h("Flick: start({0}), overall move({1}), velocity {2}",J.Uc(this.qc),J.Uc(this.Cc),this.ij)},createEvent:function(a,b){a=new Fa(2051,a,b.id(),0);b=Ga.D(12);var c=Ac.D(b,!0);c.K(this.qc.rc());c.K(this.Cc.rc());c.K(this.ij);a.Nb(b);return a},Cl:function(a){this.qc=a.qc;this.Df=a.Df;this.Cc=a.Cc;this.ij=a.ij},start:function(){return this.qc},Nu:function(a){this.Df=a},Ru:function(){return this.Df},
setVelocity:function(a){this.ij=a},lu:function(){return this.Cc},Zu:function(a){this.Cc=a.Mg(this.qc)}};var wg;wg=function(a){this.sl=a;this.Ua=[]};
wg.prototype={type:function(){return this.sl?V.ee:V.Ce},touches:function(){return this.Ua},iN:function(){this.Ua=[]},Bh:function(a){this.Ua.push(a)},clone:function(){var a=new wg(this.sl);a.Ua=this.Ua.slice(0);return a},Lo:function(){var a="",b;var c=this.sl?"TouchToMouse":"IEC-Touches";for(b=0;b<this.Ua.length;++b)if(2>b)a+=J.h("[{0}, {1}]({2}) ",b,this.Ua[b].flags(),J.Uc(this.Ua[b].location().current()));else{a+="...";break}return J.h("{0} ({1}): {2}",c,this.Ua.length,a)},createEvent:function(a,
b,c){var d=0,e,f=!0;var g=c.g.pa?12:0;var k=null;this.sl||(d=b.id());var l=this.Ua.length;b=this.sl?2054:2052;g=Ga.D((8+g)*this.Ua.length);var G=Ac.D(g,!0);for(e=0;e<this.Ua.length;++e){var u=this.Ua[e].location().Yi;G.K(u.rc());u=255&this.eK(this.Ua[e]);this.Ua[e].$(V.Be)||(f=!1);if(this.Ua[e].$(V.Cm)||this.Ua[e].$(V.lw))u|=256;u|=(this.Ua[e].id()&65535)<<16>>>0;G.K(u)}if(c.g.pa){for(e=0;e<this.Ua.length;++e)if(u=this.Ua[e].Ca(),null!==u){if(null===k||k!==u)k=u;G.K(u.Fb);G.K(u.cc)}else G.K(0),G.K(0);
for(e=0;e<this.Ua.length;++e)G.K(this.Ua[e].Ld.rc())}f&&b++;a=new Fa(b,a,d,l);a.Nb(g);!c.g.pa||2052!==b&&2053!==b||null!==k&&a.$d(k);return a},eK:function(a){return a.$(V.Be)?2:a.$(V.Xc)?3:a.$(V.Wc)?1:0}};var ug;ug=function(a){void 0===a&&(a=new I(0,0));this.qc=a;this.Df=void 0;this.Cc=new I(0,0);this.pf=new I(0,0);this.Sy=0;this.Uz=!1};
ug.prototype={nQ:function(a){this.Uz=a},type:function(){return V.Yc},clone:function(){var a=new ug(this.qc);a.Cl(this);return a},Cl:function(a){this.qc=a.qc;this.Df=a.Df;this.Cc=a.Cc;this.pf=a.pf},FA:function(a,b,c){var d=a.info().scroll(),e=this.qc.Mb(this.Cc);b===V.Vc&&d.MQ(this.qc);b=this.$J(this.pf,c,a);var f=a.da&&a.da.We()&&a.da.ik;c.Zo()||a.za.SA(e.X)||f?(d.KQ(this.Cc.X),d.YC(b.X)):d.YC(0);c.Zo()||a.za.TA(e.Y)||f?(d.LQ(this.Cc.Y),d.ZC(b.Y)):d.ZC(0);return a.ut()},$J:function(a,b,c){c=c.za.size().scale(b.dO());
b=new I(c.L*b.GB(),c.aa*b.GB());return new I(Math.max(-b.X,Math.min(b.X,a.X)),Math.max(-b.Y,Math.min(b.Y,a.Y)))},Lo:function(){return J.h("Pan: start({0}), overall move({1})",J.Uc(this.qc),J.Uc(this.Cc))},createEvent:function(a,b){if(this.Uz){a=new Fa(2051,a,b.id(),0);var c=Ga.D(12);var d=Ac.D(c,!0);d.K(b.info().scroll().vi.rc());d.K(b.info().scroll().ab.rc());d.K(2E3)}else a=new Fa(2050,a,b.id(),0),c=Ga.D(8),d=Ac.D(c,!0),d.K(b.info().scroll().vi.rc()),d.K(b.info().scroll().ab.rc());a.Nb(c);return a},
start:function(){return this.qc},Nu:function(a){this.Df=a},Ru:function(){return this.Df},lu:function(){return this.Cc},Zu:function(a){this.Cc=a.Mg(this.qc)},Ve:function(){return this.pf},wS:function(a,b){var c=b-this.Sy;1E-6>c&&(c=1);this.Sy=b;this.pf=a.jQ(60/c)}};var vg;vg=function(){this.Qs=new I(0,0);this.Kw=new I(0,0);this.IK=1;this.Xn=this.mo=0};
vg.prototype={type:function(){return V.Sg},clone:function(){},Lo:function(){return"SpreadPinch: "},FA:function(a,b){var c=a.info().zoom(),d=a.info().scroll();b===V.Vc&&c.Jj(this.Qs);c.Jj(this.Kw);c.wp(this.IK);c.WR(this.mo);c.setOrientation(this.Xn);d.Jg(this.Kw.Mg(this.Qs));b=a.ut();Y.wj(b,Y.Kp)&&this.QJ(a)&&(b=Y.TP(b));return b},createEvent:function(a,b){a=new Fa(2049,a,b.id(),0);var c=b.info().zoom();b=Ga.D(16);var d=Ac.D(b,!0);d.K(c.bd.rc());d.K(c.nf.rc());d.K(65536*c.Yf);var e=c.mo/2/Math.PI*
65536;c=c.orientation()/2/Math.PI*65536;d.K(e|c<<16);a.Nb(b);return a},QJ:function(a){return 400>a.info().scroll().wN.Kt(new I(0,0))}};var Hg;Hg=function(){};Hg.prototype={Sl:function(){return V.zd},state:function(){return V.zd},yp:function(){}};var Gg;Gg=function(){this.fa=V.zd;this.Ss=0;this.Db=this.ad=this.nh=this.oh=null;this.Xf=-1};
Gg.prototype={Sl:function(a,b,c){var d=a.Ai.Ji;if(Bg.TM(b,V.Xc))this.fa===V.Zj&&(this.ad=V.Rg,this.Xf=V.ee,this.EJ(a,b)),this.fa=this.KG();else{var e=b.touches()[0].location();switch(this.fa){case V.zd:if(d.Mp)return V.zd;d.Vj?(this.ad=V.Rg,this.Xf=V.ee,this.fa=V.Vc):d.um||d.jm?(this.ad=V.Rg,d.um&&(this.ad|=V.Bm),d.jm&&(this.ad|=V.Am),this.fa=V.Zj):(this.ad=V.Rg,this.Xf=V.ee,this.fa=V.Vc);this.zJ(b);break;case V.Zj:e=e.current().Kt(e.Pl())>a.Os.NK;b.AR(e);if(e)if(this.ad===V.Bm)this.Jn(b,V.Yc);else if(this.ad===
V.Am)this.Jn(b,V.ef);else if(e=b.timeStamp()-this.Ss>a.Os.OK)this.bt(b),this.nh.ij<a.Os.HI?this.Jn(b,V.Yc):this.Jn(b,V.ef);break;default:this.bt(b),this.fa=V.ak}}if(this.fa>=V.$j)switch(c.Ap(this.Xf),this.Xf){case V.Yc:c.data().Cl(this.oh);c.$d(this.Db);break;case V.ef:c.data().Cl(this.nh);c.$d(this.Db);break;case V.Ce:case V.ee:Bg.Ot(c,b);break;default:throw Error("unexpected");}return this.fa},state:function(){return this.fa},yp:function(a){this.fa=a},zJ:function(a){var b=a.touches()[0],c=b.location().current(),
d=b.Ld;this.Ss=J.m();this.nh=new tg(c);this.nh.Nu(d);this.oh=new ug(c);this.oh.Nu(d);this.Db=b.Ca();null!==a.Pe&&(this.Db=a.Pe.Ca())},Jn:function(a,b){this.bt(a);this.ad=V.Rg;this.Xf=b;this.fa=V.Vc},EJ:function(a,b){a.uO(b.touches()[0])},bt:function(a){var b=a.touches()[0].location().current();if(this.Xf===V.Yc||this.ad!==V.Rg){var c=b.Mg(this.oh.start().Mb(this.oh.lu()));this.oh.wS(c,a.timeStamp());this.oh.Zu(b)}if(this.Xf===V.ef||this.ad!==V.Rg)c=this.nh.start().FN(b),a=a.timeStamp()-this.Ss,1E-6>
a&&(a=10),this.nh.setVelocity(c/a*1E3),this.nh.Zu(b)},KG:function(){return this.fa===V.zd?V.zd:V.df}};var mf;mf=function(a,b,c){this.ta=a;this.za=b;this.mb=c;this.tf=new Ng;this.Gq=this.da=null};
mf.prototype={FQ:function(a){var b=a.uc().size();this.da=a;0>=this.za.ca&&0>=this.za.V&&(this.za.V=b.L,this.za.ca=b.aa)},id:function(){return this.ta},VC:function(a){this.Gq=a},flags:function(){return this.mb},kj:function(a){this.mb|=a},$:function(a){return(this.mb&a)===a},info:function(){return this.tf},zt:function(a){return a.X>=this.za.u&&a.X<=this.za.V&&a.Y>=this.za.v&&a.Y<=this.za.ca},eo:function(a,b,c,d){if(!Y.wj(d,Y.ev)){var e=Math.abs(b.X-c.X);b=Math.abs(b.Y-c.Y);if(Y.wj(a,Y.fv)&&e>b||Y.wj(a,
Y.gv)&&b>e)d=Y.Ye(d,a)}return d},ut:function(){var a=Y.Xh,b=this.tf.zoom(),c=this.tf.scroll(),d=b.Yf,e=c.ab,f=this.gB();d<b.Sa().Bc&&(a=Y.Ye(a,Y.oq),a=Y.Ye(a,Y.nv));d>b.Sa().Ac&&(a=Y.Ye(a,Y.nq),a=Y.Ye(a,Y.mv));e.X<f.u&&(a=Y.Ye(a,Y.Wj),a=this.eo(Y.kv,e,c.Sa().Bc,a));e.Y<f.v&&(a=Y.Ye(a,Y.Xj),a=this.eo(Y.lv,e,c.Sa().Bc,a));e.X>f.V&&(a=Y.Ye(a,Y.Zh),a=this.eo(Y.hv,e,c.Sa().Ac,a));e.Y>f.ca&&(a=Y.Ye(a,Y.$h),a=this.eo(Y.jv,e,c.Sa().Ac,a));return a},oC:function(a){var b=this.info().scroll(),c=b.Sa();Y.$(a,
Y.Wj)&&b.Jg(new I(c.Bc.X,b.ab.Y));Y.$(a,Y.Xj)&&b.Jg(new I(b.ab.X,c.Bc.Y));Y.$(a,Y.Zh)&&b.Jg(new I(c.Ac.X,b.ab.Y));Y.$(a,Y.$h)&&b.Jg(new I(b.ab.X,c.Ac.Y))},gB:function(){var a=this.za.xc().Mg(this.tf.scroll().Sa().Ac);var b=this.za.Ud().Mg(this.tf.scroll().Sa().Bc);b=(new Bb(a.X,a.Y,b.X,b.Y)).ZM(this.tf.zoom().bd,this.tf.zoom().Yf);a=this.za.xc().Mg(b.xc());b=this.za.Ud().Mg(b.Ud());b=new Bb(a.X,a.Y,b.X,b.Y);a=b.Ud().min(this.tf.scroll().Sa().Bc);b=b.xc().min(this.tf.scroll().Sa().Ac);return new Bb(a.X,
a.Y,b.X,b.Y)}};var Uc;Uc={Xh:0,Sv:1,VF:3,QS:4,xv:8,iw:16,ow:32,hi:64,hF:128,CD:256,US:512,Jp:1024,zm:2048};var Ng;Ng=function(){this.HM=new Og;this.yL=new Pg;new Bb(0,0,0,0);this.Cf=[]};
Ng.prototype={zoom:function(){return this.HM},scroll:function(){return this.yL},HQ:function(){},vu:function(a){return this.Cf.length>a?(a=this.Cf[a],"undefined"!==typeof a?a:null):null},mD:function(a,b){this.Cf[a]=b},yO:function(a){for(var b=0;b<this.Cf.length;++b)if("undefined"===typeof this.Cf[b]||null!==this.Cf[b]&&this.Cf[b].vn===a)this.Cf[b]=null}};var Pg;Pg=function(){this.Vr=new bd;this.vi=new I(0,0);this.ab=new I(0,0);this.pf=new I(0,0)};
Pg.prototype={Sa:function(){return this.Vr},MQ:function(a){this.vi=a},wN:function(){return this.ab},Jg:function(a){this.ab=a},KQ:function(a){this.ab.X=a},LQ:function(a){this.ab.Y=a},Ve:function(){return this.pf},YC:function(a){this.pf.X=a},ZC:function(a){this.pf.Y=a}};var Og;Og=function(){this.Vr=new Rg;this.bd=new I(0,0);this.nf=new I(0,0);this.Yf=1;this.Xn=this.mo=0};
Og.prototype={Sa:function(){return this.Vr},Jj:function(a){this.bd=a},wp:function(a){this.Yf=a},WR:function(a){this.mo=a},orientation:function(){return this.Xn},setOrientation:function(a){this.Xn=a}};var nf;nf=function(a,b,c,d){this.vn=a;this.Xr=b;this.Yr=c;this.gs=d};nf.prototype={offset:function(){return this.gs}};var Cg;Cg=function(){this.R=[]};
Cg.prototype={rB:function(a){var b;switch(a.type()){case V.Sg:var c=Uc.VF;break;case V.Yc:c=Uc.Sv;break;case V.ef:c=Uc.xv;break;case V.Ce:c=Uc.iw;break;default:c=0}for(b=0;b<this.R.length;++b)if(this.R[b].$(c)&&(a.type()===V.Sg&&this.R[b].zt(a.data().Qs)||a.type()===V.Yc&&this.$w(this.R[b],a.data().start(),a.data().Ru())||a.type()===V.ef&&this.$w(this.R[b],a.data().start(),a.data().Ru())||a.type()===V.Ce&&this.Dq(a.data().touches(),this.R[b]))){if(this.R[b].$(Uc.zm))break;return this.R[b]}return null},
PN:function(a,b,c){var d;for(d=0;d<this.R.length&&(!this.R[d].$(Uc.zm)||!this.Dq(a.touches(),this.R[d]));++d)if(this.R[d].$(Uc.iw)&&this.R[d].$(b)&&(!c||null===a.tb||null===this.R[d].da||J.jB(this.R[d].da.O(),a.tb.target))&&this.Dq(a.touches(),this.R[d]))return this.R[d];return null},SM:function(a,b){var c,d,e=[],f=!1;for(c=0;c<this.R.length;++c){for(d=0;d<a.touches().length;++d){var g=this.Tq(this.R[c],a.touches()[d]);if(!e[d]&&g){if(this.R[c].$(Uc.zm)){f=!0;break}this.R[c].$(Uc.hF)&&this.R[c].$(b)&&
(e[d]=!0)}}if(f)break}for(d=0;d<a.touches().length;++d)if(!0!==e[d])return!1;return!0},Tq:function(a,b,c){var d=a.da;var e=b.location().current();e=a.zt(e);return null!==d&&(e=J.qm(d.Z),a.VC(a.za.Mb(e.X,e.Y)),(e=a.Gq.contains(b.Ld))&&void 0!==c&&null!==c&&!J.jB(d.O(),c))?!1:e},$w:function(a,b,c){var d=a.da;b=a.zt(b);null!==d&&(d=J.qm(d.Z),a.VC(a.za.Mb(d.X,d.Y)),b=a.Gq.contains(c));return b},Dq:function(a,b){var c;for(c=0;c<a.length;++c)if(!this.Tq(b,a[c]))return!1;return!0},cN:function(a,b,c){b[0]=
!1;b[1]=!1;if(1===a.touches().length){var d=a.tb;if(void 0!==d&&null!==d)var e=d.target;for(d=0;d<this.R.length;++d)if(this.Tq(this.R[d],a.touches()[0],e)){if(this.R[d].$(Uc.zm))break;var f=!1;this.R[d].$(Uc.Sv)&&this.R[d].$(c)&&(f=b[0]=!0,a.gD(this.R[d].da));this.R[d].$(Uc.xv)&&this.R[d].$(c)&&(f=b[1]=!0,a.gD(this.R[d].da));if(!f)break}}},clear:function(){this.R=[]},mt:function(a,b){b?this.R.push(a):this.R.unshift(a)},VP:function(a){this.R=this.R.filter(function(b){return b.da!==a})},uc:function(a){return this.R.length>
a?this.R[a]:null},iO:function(a){for(var b=0;b<this.R.length;++b)if(this.R[b].id()===a)return this.R[b];return null},zO:function(a){for(var b=0;b<this.R.length;++b)this.R[b].info().yO(a)}};var bd;bd=function(){this.Bc=new I(0,0);this.Ac=new I(0,0)};bd.prototype={Qh:function(a){this.Bc=a},Ph:function(a){this.Ac=a}};var Rg;Rg=function(){this.Ac=this.Bc=0};Rg.prototype={Ju:function(a){this.Bc=a},Iu:function(a){this.Ac=a}};var Sg;Sg=function(){};
Sg.prototype={Kh:function(a,b){null!==b.da&&b.da.Kh(a,b)},np:function(){},st:function(){},Aj:function(a){null!==a.da&&a.da.Aj(a);return a.info().scroll().vi.Mb(a.info().scroll().ab)}};var Eg;Eg=function(){Sg.call(this)};Eg.prototype=Object.create(Sg.prototype);Eg.prototype.constructor=Eg;var Fg;Fg=function(a,b){Sg.call(this);b||(this.Js=this.hx(a.width,a.height),this.QK=this.uH())};Fg.prototype=Object.create(Sg.prototype);r=Fg.prototype;r.constructor=Fg;
r.Kh=function(a,b){var c=a.xg();c.save();a.g.qa.g.N.Pi?null!==b.info().vu(0)&&this.np(a,b):(this.LK(c,b),this.MK(c,b));c.restore()};r.LK=function(a,b){var c=b.za.u,d=b.za.v,e=b.za.C()+1;b=b.za.B()+1;a.fillStyle=this.QK;a.fillRect(c,d,e,b)};r.MK=function(a,b){var c=b.za.u,d=b.za.v,e=b.za.C()+1,f=b.za.B()+1;a.beginPath();a.rect(c,d,e,f);a.clip();this.kA(a,b,null);a.drawImage(this.Js,c,d,e,f,c,d,e,f)};
r.np=function(a,b){var c=a.xg();var d=b.za.u;var e=b.za.v;var f=b.za.C()+1;var g=b.za.B()+1;c.beginPath();c.rect(d,e,f,g);c.clip();for(e=0;e<b.info().Cf.length;++e)d=b.info().vu(e),null!==d&&(f=a.pe.sp(d.vn),f=f.Sm.canvas,c.save(),this.kA(c,b,d),c.drawImage(f,0,0),c.restore())};
r.kA=function(a,b,c){a.translate(b.info().zoom().bd.X,b.info().zoom().bd.Y);a.scale(b.info().zoom().Yf,b.info().zoom().Yf);a.translate(-b.info().zoom().bd.X,-b.info().zoom().bd.Y);a.translate(null!==c&&c.Xr?0:b.info().scroll().ab.X,null!==c&&c.Yr?0:b.info().scroll().ab.Y);null!==c&&a.translate(b.za.u-c.offset().X,b.za.v-c.offset().Y)};
r.st=function(a,b){var c=this.Js.getContext("2d");c.drawImage(a.La.canvas,b.u,b.v,b.C(),b.B(),b.u,b.v,b.C(),b.B());c.drawImage(a.Hl().canvas,b.u,b.v,b.C(),b.B(),b.u,b.v,b.C(),b.B())};r.hx=function(a,b){var c=window.document.createElement("canvas");c.width=a;c.height=b;return c};
r.uH=function(){var a=this.hx(8,8),b=a.getContext("2d");b.fillStyle="#fff";b.fillRect(0,0,a.width,a.height);b.CT="#000";b.lineWidth=1;b.beginPath();b.moveTo(b.lineWidth/2,a.height);b.lineTo(b.lineWidth/2,b.lineWidth/2);b.lineTo(a.width,b.lineWidth/2);b.stroke();b.closePath();return this.Js.getContext("2d").createPattern(a,"repeat")};r.Aj=function(a){return a.info().scroll().vi.Mb(a.info().scroll().ab)};var bc,Tg;Tg=function(){this.no=-1;this.Zb=!1};
bc=function(a){this.g=a;this.dl=this.Zb=this.Qi=!1;this.Oy=this.Sr=this.My=this.Qr=0;this.Re=null;this.Nn=!1;this.az=0;this.dn=this.Hr=!1;this.qe=[];this.Py=[];this.VJ=5;this.Rr=0;this.vf=null};
bc.prototype={fS:function(a){this.Qi||this.CJ();this.Zb&&(1>a||a>ra.Lv?N.warn("Cannot benchmark with invalid type: "+a):(this.Sr=J.Sj(),this.qe[a].Zb=!0,this.qe[a].no=this.Sr))},LN:function(a,b){if(this.Zb&&!a){a=J.Sj();var c=!1;b==ra.bq&&(this.Oy=a-this.My,this.My=a,this.Py[this.Rr]=(a-this.Sr)/1E3,this.Rr=(this.Rr+1)%this.VJ);this.Nn&&(this.Qr=a-this.qe[ra.Og].no,this.Nn=this.qe[ra.Og].Zb=!1,c=!0);this.dl&&(c&&this.Az(this.Qr,ra.Og),c=this.qe[b],c.Zb&&this.Az(a-c.no,b))}},uC:function(a){this.Zb&&
this.Mi(D.ci(a),a.currentTarget)},Mi:function(a,b){this.az=J.Sj();this.Hr?this.qe[ra.Og].Zb=!1:(this.vf=b,this.dn||(this.Re=a),this.bA())},vC:function(a){this.Zb&&this.Ni(D.ci(a),a.currentTarget)},Ni:function(a,b){this.dn&&3E6<J.Sj()-this.az&&(this.Re=a);this.Hr&&(this.vf=b,this.dn||(this.Re=a),this.bA())},tC:function(){return null===this.Re?new I(-1,-1):this.Re},cP:function(a){this.Zb&&this.Mi(D.ci(a),a.currentTarget)},dP:function(a){this.Zb&&this.Ni(D.ci(a),a.currentTarget)},qS:function(a,b){this.Zb&&
this.Mi(a,b.currentTarget)},pS:function(a,b){this.Zb&&this.Ni(a,b.currentTarget)},Tl:function(a){this.Zb&&(this.g.pa?(a=this.g.ba().wa(),null!==a&&null!==this.vf&&null!==a.Z&&void 0!==a.Z&&null!==this.vf.firstChild&&void 0!==this.vf.firstChild&&null!==a.Z.firstChild&&void 0!==a.Z.firstChild&&null!==this.vf.firstChild.id&&void 0!==this.vf.firstChild.id&&a.Z.firstChild.id===this.vf.firstChild.id&&(this.vf=null,this.Nn=!0)):null===this.Re||null===a||this.Re.X<a.u||this.Re.X>a.V||this.Re.Y<a.v||this.Re.Y>
a.ca||!this.qe[ra.Og].Zb||(this.Nn=!0))},eN:function(){this.Tl(null)},VO:function(){return Math.round(this.Qr/1E3)},WO:function(){return Math.round(this.Oy/1E3)},Az:function(a,b){a=new Fa(2097152,this.g.A.la,b,a&4294967295);a.UR();this.g.rd(a)},CJ:function(){var a=this.g.getConfiguration();this.Zb=a.Benchmarking||a.DebugOnlyDiagnosisDisplay;this.dl=a.Benchmarking;this.Hr=a.DebugOnlyInputReactionOnUp;this.dn=a.DebugOnlyInputReactionExplCoord;this.qe.push(null);for(a=1;a<=ra.Lv;a++)this.qe.push(new Tg);
this.Qi=!0},bA:function(){this.qe[ra.Og].Zb=!0;this.qe[ra.Og].no=J.Sj()}};var za;
(function(){function a(b){if(0>b)throw"Only non negative values supported";if(4294967296<=b)throw"Only values occupiing less than 32-Bit supported";}za=function(b){if(void 0!==b)if("number"==typeof b)a(b),this.Fb=b,this.cc=0;else if(b instanceof za)this.Fb=b.Fb,this.cc=b.cc;else throw"Unexpected initial value";else this.cc=this.Fb=0};za.prototype={Zp:function(b){if(0>b||64<=b)throw"Unexpected shift amount";if(32<b)this.Zp(32),this.Zp(b-32);else if(32===b)this.cc=this.Fb,this.Fb=0;else{var c=this.rH(b);
var d=(c&this.Fb)>>>0;this.cc=this.cc<<b>>>0;this.cc=(this.cc|d>>>32-b)>>>0;this.Fb&=~c;this.Fb=this.Fb<<b>>>0}},Mv:function(b){if("number"==typeof b)a(b),this.Mv(new za(b));else if(b instanceof za)this.Fb=(this.Fb|b.Fb)>>>0,this.cc=(this.cc|b.cc)>>>0;else throw"Unexpected argument";},eE:function(b){return b instanceof za?this.Fb===b.Fb&&this.cc===b.cc:!1},rH:function(b){var c,d=0;if(0===b)return 0;for(c=0;c<b-1;++c)d=(d|2147483648)>>>0,d>>>=1;return(d|2147483648)>>>0},toString:function(){return this.cc+
" "+this.Fb}}})();var sb;sb=function(){this.clear()};sb.prototype={clear:function(){this.R=[]},mt:function(a){this.R.push(a)},DA:function(a){a.beginPath();for(var b=0;b<this.R.length;++b)a.rect(this.R[b].u,this.R[b].v,this.R[b].C(),this.R[b].B());a.clip()}};var sd;
sd=function(a,b){this.J=a;this.h=b;this.Ew=[];this.px=[];b=this.xa(this.J);for(a=0;a<this.h;++a){var c=Math.floor(b.Na+(a+1)*(128-Math.floor(b.Na/2))/this.h);this.Ew[this.h-a-1]=this.m(b.Ec,b.vd,c,b.a);c=Math.floor(Math.floor(b.Na/3)+Math.floor(2*a*b.Na/(3*this.h)));this.px[a]=this.m(b.Ec,b.vd,c,b.a)}};
sd.prototype={TN:function(a){return this.Ew[a]},yB:function(a){return this.px[a]},xa:function(a){var b={};var c=((a&16711680)>>16)/255;var d=((a&65280)>>8)/255;var e=(a&255)/255;var f=Math.min(c,Math.min(d,e));var g=Math.max(c,Math.max(d,e));var k=g-f;b.Na=(f+g)/2;if(0===k)b.Ec=b.vd=0;else{b.vd=.5>b.Na?k/(g+f):k/(2-g-f);f=((g-c)/6+k/2)/k;var l=((g-d)/6+k/2)/k;k=((g-e)/6+k/2)/k;c===g?b.Ec=k-l:d===g?b.Ec=1/3+f-k:e===g&&(b.Ec=2/3+l-f);0>b.Ec&&(b.Ec+=1);1<b.Ec&&--b.Ec}b.Ec=Math.round(255*b.Ec);b.vd=Math.round(255*
b.vd);b.Na=Math.round(255*b.Na);b.a=Math.round(((a&4278190080)>>24)/255*255);return b},m:function(a,b,c,d){var e;if(0===b)c=e=a=c;else{a/=255;b/=255;c/=255;b=.5>c?c*(1+b):c+b-c*b;var f=2*c-b;c=Math.round(255*this.yr(f,b,a+1/3));e=Math.round(255*this.yr(f,b,a));a=Math.round(255*this.yr(f,b,a-1/3))}return(d<<24)+(c<<16)+(e<<8)+a},yr:function(a,b,c){0>c&&(c+=1);1<c&&--c;return 1>6*c?a+6*(b-a)*c:1>2*c?b:2>3*c?a+(b-a)*(2/3-c)*6:a}};var nc;
nc=function(a){this.g=a;this.Jt=function(b){b.preventDefault()};a=this.g.getConfiguration();this.Bn=!0;a.ContextMenuDisabled?(J.Za().addEventListener("contextmenu",this.Jt),this.Bn=!1):a.TouchContextMenuEnabled&&(this.Bn=!1)};
nc.prototype={Mo:function(){var a=this;this.Nw();this.nb=window.setTimeout(function(){a.Lt()},500)},Ko:function(){this.Bn&&(this.Lt(),J.Za().addEventListener("contextmenu",this.Jt))},Nw:function(){-1!==this.nb&&(window.clearTimeout(this.nb),this.nb=-1)},Lt:function(){this.Bn&&(this.Nw(),J.Za().removeEventListener("contextmenu",this.Jt))}};var Gb;Gb=function(){};
Gb.prototype={xA:function(a,b){this.JL(a,b,90)},UB:function(a){return""!==this.$o(a)},$o:function(a){return this.SI(a)},JL:function(a,b,c){var d=new Date;d.setTime(d.getTime()+864E5*c);document.cookie=a+"="+b+"; expires="+d.toUTCString()},SI:function(a){a+="=";var b,c;var d=document.cookie.split(";");for(b=0;b<d.length;b++){for(c=d[b];" "==c.charAt(0);)c=c.substring(1);if(-1!==c.indexOf(a))return c.substring(a.length,c.length)}return""}};var ad;ad=function(){};
ad.J=function(a){a=window.atob(a.substring(a.indexOf("-----BEGIN PUBLIC KEY-----")+26,a.indexOf("-----END PUBLIC KEY-----")));a=J.oS(a);return this.Tp().subtle.importKey("spki",a,{name:"RSA-OAEP",hash:"SHA-256"},!0,["encrypt"])};ad.m=function(a,b){return this.Tp().subtle.encrypt({name:"RSA-OAEP",hash:{name:"SHA-256"}},a,b)};ad.h=function(){var a=new Uint8Array(16);a=this.Tp().getRandomValues(a);return J.mC(a.buffer)};
ad.Tp=function(){if(void 0!==window.crypto&&void 0!==window.crypto.subtle)return window.crypto;if(void 0!==window.msrCrypto&&void 0!==window.msrCrypto.subtle)return window.msrCrypto};var fc;fc=function(a){this.yb=a.yg();this.zi=a.td()};fc.prototype={};var Ab;Ab=function(a){this.g=a;this.ac=[]};
Ab.prototype={mj:function(){if(null!==this.g.getConfiguration()&&this.g.getConfiguration().DebugOnlyDiagnosisDisplay){var a=13*this.ac.length+3;var b=document.getElementById("diag");null===b&&(b=J.lm(175,150),b.id="diag",b.style.zIndex=8,b.style.position="absolute",J.Za().parentNode.appendChild(b));b=this.Bk(b);this.pG();b.save();b.strokeStyle="rgb(0,0,0)";b.fillStyle="rgb(220,220,220)";b.font="10px Arial";b.beginPath();b.rect(10,10,150,a);b.clip();b.fillRect(10,10,150,a);b.strokeRect(10,10,150,a);
b.fillStyle="rgb(0,0,0)";b.textAlign="left";b.textBaseline="top";for(a=0;a<this.ac.length;++a){var c=J.h("{0}: {1}",this.ac[a].title,this.ac[a].Lf());b.fillText(c,13,13+13*a)}b.restore()}},pG:function(){if(0===this.ac.length){var a=this.g.oc,b=this.g.U(),c=this;this.ac.push({title:"DPR",Lf:function(){return b.Wt()?J.h("{0} (Changed)",D.af()):D.af()}});this.ac.push({title:"Canvas-Size",Lf:function(){return J.h("{0}/{1}",b.Jf().C(),b.Jf().B())}});this.ac.push({title:"Resize-Count",Lf:function(){return null!==
a?a.ez:"---"}});this.ac.push({title:"Window-Size",Lf:function(){return J.h("{0}/{1}",window.innerWidth,window.innerHeight)}});this.ac.push({title:"DocElem-Size",Lf:function(){return J.h("{0}/{1}",document.documentElement.clientWidth,document.documentElement.clientHeight)}});this.ac.push({title:"Last Input Reaction (*)",Lf:function(){return J.h("{0}",c.g.rb.VO())}});this.g.getConfiguration().DebugOnlyInputReactionExplCoord&&this.ac.push({title:"Input check coords",Lf:function(){return J.h("{0}/{1}",
c.g.rb.tC().X,c.g.rb.tC().Y)}});this.ac.push({title:"FPS (*)",Lf:function(){return(1E3/c.g.rb.WO()).toFixed(1)}});this.ac.push({title:"PTs (*)",Lf:function(){return c.g.rb.Py.map(function(d){return d.toFixed(0)}).join(", ")}})}},Bk:function(a){a=a.getContext("2d");if(null===a)throw Error("Creating graphics context failed");return a}};var Sb;Sb=function(a){this.g=a;this.o=null;this.Sq=this.wl=!1;this.kk=this.lc=null;this.fb=[]};
Sb.prototype={Ho:function(a){(J.qq(a)||J.Uj(a)&&"touch"===a.pointerType||J.xq(a))&&this.$t()&&(this.xt(this.g.getConfiguration().CommitEditcontrolOnClickOut),this.Ig())},Ig:function(){null!==this.g.oc&&this.g.oc.Ig()},$t:function(){return null!==this.o},open:function(a,b,c){this.o="editcontrol-inputform"===a.id?a.children[1]:a;this.wl=b;this.YF();c.g.pa?(this.kk=c.g.ba().wa(),this.kk.$C(a)):(this.lc=c.La.canvas.parentNode,this.Mm=a,this.lc.appendChild(this.Mm))},close:function(){this.Ig();null!==
this.o&&(null!==this.lc&&null!==this.Mm&&this.lc.removeChild(this.Mm),null!==this.kk&&this.kk.$C(null),this.kl());this.kk=this.Mm=this.lc=this.o=null},lN:function(a){for(var b=0;b<a.length;b++)if(255<a.charCodeAt(b))return!1;return!0},xt:function(a){if(!this.Sq){var b=J.Hp(this.o);if(this.wl||this.g.getConfiguration().vq||this.lN(this.o.value))var c=new Cc(this.o.value,this.wl,this.g.getConfiguration().td());else{if(a)return;c=new Cc("",!1,this.g.getConfiguration().td())}var d=c.length()+1;this.wl&&
(d*=2);d=Ga.D(d);Ac.D(d,this.g.A.Fa,this.g.getConfiguration().td()).hc(c);c=new Fa(512,this.g.A.la,a?this.wl?3:1:2,0);c.Nb(d);c.iD(b.$B(4));this.g.Bb.push(c);a?this.Sq=!0:this.close()}},$P:function(){this.Sq=!1},Vb:function(){return this.o},hI:function(a){null!==this.o&&(a.stopPropagation(),27===a.keyCode?(a.preventDefault(),this.xt(!1)):13===a.keyCode&&this.xt(!0))},gI:function(a){a.stopPropagation()},jI:function(a){a.stopPropagation()},iI:function(a){a.stopPropagation()},yi:function(a){a.stopPropagation()},
YF:function(){var a=this,b;this.fb.push({e:"keydown",Na:function(c){a.hI(c)}});this.fb.push({e:"keyup",Na:function(c){a.jI(c)}});this.fb.push({e:"focus",Na:function(c){a.gI(c)}});this.fb.push({e:"keypress",Na:function(c){a.iI(c)}});D.Qb()?(this.fb.push({e:"pointerup",Na:function(c){a.yi(c)}}),this.fb.push({e:"pointerdown",Na:function(c){a.yi(c)}})):(this.fb.push({e:"mouseup",Na:function(c){a.yi(c)}}),this.fb.push({e:"mousedown",Na:function(c){a.yi(c)}}),this.fb.push({e:"touchstart",Na:function(c){a.yi(c)}}),
this.fb.push({e:"touchend",Na:function(c){a.yi(c)}}));for(b=0;b<this.fb.length;++b)this.o.addEventListener(this.fb[b].e,this.fb[b].Na)},kl:function(){var a;for(a=0;a<this.fb.length;++a)this.o.removeEventListener(this.fb[a].e,this.fb[a].Na);this.fb=[]}};var Cc;Cc=function(a,b,c){c=new Ug(c);this.Tm=null;this.nG=b;if(null!==a)if(b){b=Array(a.length);for(c=0;c<a.length;c++)b[c]=a.charCodeAt(c);this.Tm=b}else this.Tm=c.hb(a)};
Cc.prototype={length:function(){return this.Tm.length},data:function(){return this.Tm},unicode:function(){return this.nG}};var Ug;Ug=function(a){void 0===a&&(a=null);this.Un=a};Ug.prototype={qG:function(){if(null===this.Un)try{this.Un=(new Configuration).td()}catch(a){this.Un={encode:function(){return 63}}}},hb:function(a){this.qG();return this.Un.encode(a)}};var vc;vc=function(a,b){this.ri=a;this.xH=J.m();this.fK=null!==b?b.ConnectionInfoValidTimeMsForLeaveAfterError:1E3};
vc.prototype={iS:function(){return J.m()-this.xH<this.fK}};var Wg;Wg=function(){this.Cb=[]};Wg.prototype={gF:function(a){this.Cb.push(a)},FD:function(){this.Cb.splice(0,this.Cb.length)},zv:function(a){this.Cb.forEach(a)},rF:function(a){0<=a&&this.Cb.splice(a,1)},Size:function(){return this.Cb.length},RF:function(a){this.zv(function(b){b.update&&b.update(a)})},HD:function(a){a.Bh&&this.zv(function(b){a.Bh(b)})}};var Sa;
Sa=function(a){try{this.h(a)}catch(b){throw Error("Parsing the fontstring '"+a+"' failed for the following reason: "+b);}};
Sa.prototype={h:function(a){var b=null,c=null,d,e=!1,f=a.split(/\s+/);for(d=0;d<f.length;++d){var g=f[d];switch(g){case "normal":break;case "italic":case "oblique":break;case "small-caps":break;case "bold":case "bolder":case "lighter":case "100":case "200":case "300":case "400":case "500":case "600":case "700":case "800":case "900":break;default:null===c?(g=g.split("/"),g=J.Sh(g[0]),"p"===g.charAt(g.length-2)&&"x"===g.charAt(g.length-1)&&(c=parseInt(g.substr(0,g.length-2),10))):(b=g,d<f.length-1&&
(b+=" "+f.slice(d+1).join(" ")),e=!0)}if(e)break}if(null===b)throw Error("Font Family/Name missing");if(null===c||isNaN(c))throw Error("Invalid or unsupported font Size");this.hE=c;this.Sp=a}};var Wb;Wb=function(){Wg.call(this)};Wb.prototype=Object.create(Wg.prototype);r=Wb.prototype;r.constructor=Wb;r.im=function(a){for(var b=0;b<this.Cb.length;b++)if(this.Cb[b].id()===a)return b;return-1};
r.WF=function(a,b){a=this.im(a);if(0<=a){var c=this.Cb[a];this.Cb[a]=b;b.location().fD(c.location().current());b.Cu(c.Nk);null!==c.qk&&null===b.qk&&b.Yu(c.qk)}};r.Bv=function(a){a=this.im(a);return 0<=a?this.Cb[a]:null};r.SF=function(a){null!==a&&a.id&&this.WF(a.id(),a)};r.sF=function(a){a=this.im(a);this.rF(a)};r.Rv=function(a){null!==a&&a.id&&this.sF(a.id())};var I;I=function(a,b){this.X=a;this.Y=b};
I.prototype={Tc:function(a){this.X-=a.X;this.Y-=a.Y;return this},Mg:function(a){return this.clone().Tc(a)},min:function(a){return new I(Math.min(this.X,a.X),Math.min(this.Y,a.Y))},max:function(a){return new I(Math.max(this.X,a.X),Math.max(this.Y,a.Y))},offset:function(a){this.X+=a.X;this.Y+=a.Y;return this},Mb:function(a){return this.clone().offset(a)},mP:function(a){this.X+=a.L;this.Y+=a.aa;return this},zC:function(a){return this.clone().mP(a)},rc:function(){return(this.Y>>>0&65535|this.X>>>0<<16)>>>
0},FN:function(a){return Math.sqrt(this.Kt(a))},Kt:function(a){return(this.X-a.X)*(this.X-a.X)+(this.Y-a.Y)*(this.Y-a.Y)},clone:function(){return new I(this.X,this.Y)},Yl:function(a){this.X*=a;this.Y*=a;return this},jQ:function(a){return this.clone().Yl(a)},rotate:function(a,b){if(0===a%360)return this;var c=a*Math.PI/180;a=Math.cos(c);c=Math.sin(c);var d=this.X,e=this.Y;if(b){var f=b.X;b=b.Y}else f=b=0;this.X=d*a-e*c+f*(1-a)+b*c;this.Y=d*c+e*a+b*(1-a)-f*c;return this}};var Bb;
Bb=function(a,b,c,d,e){this.u=a;this.v=b;this.V=c;this.ca=d;this.yd=void 0!==e?e:null};
Bb.prototype={C:function(){return this.V-this.u},B:function(){return this.ca-this.v},Gl:function(){return new I((this.u+this.V)/2,(this.v+this.ca)/2)},clone:function(){return new Bb(this.u,this.v,this.V,this.ca,this.yd)},xc:function(){return new I(this.u,this.v)},Ud:function(){return new I(this.V,this.ca)},ZM:function(a,b){var c=this.size().scale(b),d=this.xc().Tc(a);b=(new Ja(d.X,d.Y)).scale(b);a=a.zC(b);c=a.zC(c);return new Bb(a.X,a.Y,c.X,c.Y)},size:function(){return new Ja(this.C(),this.B())},
Mb:function(a,b){return new Bb(this.u+a,this.v+b,this.V+a,this.ca+b,this.yd)},$B:function(a){return new Bb(this.u-a,this.v-a,this.V+a,this.ca+a,this.yd)},No:function(a){return this.u===a.u&&this.v===a.v&&this.V===a.V&&this.ca===a.ca},normalize:function(){if(this.u>this.V){var a=this.V;this.V=this.u;this.u=a}this.v>this.ca&&(a=this.ca,this.ca=this.v,this.v=a)},gP:function(){var a=this.clone();a.normalize();return a},SA:function(a){return a>=this.u&&a<=this.V},TA:function(a){return a>=this.v&&a<=this.ca},
contains:function(a){return this.SA(a.X)&&this.TA(a.Y)}};var tc;tc=function(a){this.g=a;this.fk=null;this.Ax=!1;this.ez=0;this.gz=D.af();this.md=new Yf(this.g)};
tc.prototype={Bl:function(){var a=this;this.md.Ig();this.md.bf();this.fk=function(){a.Bq()};window.addEventListener("resize",this.fk,!1)},detach:function(){null!==this.fk&&(window.removeEventListener("resize",this.fk,!1),this.fk=null)},bf:function(){this.md.bf()},mq:function(){this.md.mq()},Ig:function(){this.md.Ig()},TR:function(a){this.md.RR(a)},ns:function(){var a=D.af(),b=this.Ax?a:1;this.md.tv()&&(a!==this.gz&&(this.Ax=!0,this.gz=b=a,this.g.U().jP()),this.ez++,this.g.U().Mt(b),this.md.Ig(),null!==
this.g.A&&null!==this.g.getConfiguration()&&(a=Fa.xa(this.g.A.la,this.g.getConfiguration().BestFit,this.g.getConfiguration().BestFitForDialogs,this.g.getConfiguration().ScaleTypeIsotropic,this.g.U().Jf(),this.g.U().ar,this.g.getConfiguration().FillBackground),this.g.RQ(a)));this.md.bf()},Bq:function(){var a=this;setTimeout(function(){a.ns()},50)}};var Ja;Ja=function(a,b){this.L=a;this.aa=b};Ja.prototype={scale:function(a){return new Ja(this.L*a,this.aa*a)}};var Yf;
Yf=function(a){this.g=a;this.Iy=this.Jy=this.Or=this.Pr=this.Qy=this.Ry=0};
Yf.prototype={bf:function(){this.Ry=window.screen.width;this.Qy=window.screen.height;this.Pr=document.documentElement.clientWidth;this.Or=document.documentElement.clientHeight},mq:function(){D.Gv()&&(this.Jy=document.scrollingElement.scrollTop,this.Iy=document.scrollingElement.scrollLeft)},tv:function(){var a=!1;var b=this.g.getConfiguration();if(null!==b){var c=b.MaxResizePixel;this.Qy===window.screen.width&&this.Ry===window.screen.height&&(a=!0);0<c&&(this.Pr!==document.documentElement.clientWidth&&
this.Or!==document.documentElement.clientHeight?a=!0:(b=Math.abs(this.Pr-document.documentElement.clientWidth),0<b&&b<c&&(a=!0),b=Math.abs(this.Or-document.documentElement.clientHeight),0<b&&b<c&&(a=!0)));return a}},RR:function(a){this.wM=a},Ig:function(){D.Gv()&&this.wM&&(document.scrollingElement.scrollTop=this.Jy,document.scrollingElement.scrollLeft=this.Iy)}};var kc;
kc=function(a,b,c,d){this.ka=a;this.Nd=b;this.nx=window.getComputedStyle(document.body,null).backgroundColor;this.Nd.clear(this.nx);this.WJ=J.m();this.SL=J.m();this.BH=d;this.Ke=null;if(c)this.h();else{var e=this,f=function(){e.m();e.nb=window.requestAnimationFrame(f)};this.nb=window.requestAnimationFrame(f)}};
kc.prototype={close:function(){this.Nd.clear(this.nx);window.cancelAnimationFrame(this.nb)},m:function(){if(!(J.m()-this.SL<this.BH)){var a=this.Nd.xg(),b=this.Nd.Jf(),c=2*Math.PI/6,d=(2*Math.PI-5*c)/5,e=250/3,f=10+e,g=2*Math.PI*(J.m()-this.WJ)/5E3,k=1;a.save();if(250>b.C()||250>b.B())k=.9*Math.min(b.C()/250,b.B()/250);a.scale(k,k);a.translate(Math.max(5,(b.C()-250)/2),Math.max(5,(b.B()-250)/2));a.strokeStyle="#a90018";a.lineWidth=4;a.strokeRect(0,0,250,250);a.fillStyle="#f4f4f4";a.fillRect(0,0,250,
250);for(b=0;5>b;++b)a.save(),a.translate(125,f),a.rotate(g+b*(c+d)),this.aI(a,c,e,"#cd001c"),a.restore();null===this.Ke&&this.EH(a,250);a.font=this.Ke;a.textAlign="center";a.textBaseline="bottom";a.fillStyle="#000000";a.fillText(this.ka,125,2750/12);a.restore()}},EH:function(a,b){var c=40;for(a.font=this.Xx(c);2<c&&a.measureText(this.ka).width>=.95*b;)c-=2,a.font=this.Xx(c);this.Ke=a.font},Xx:function(a){return"italic "+a+"px Arial"},aI:function(a,b,c,d){var e=.9*c;a.beginPath();a.moveTo(0,-c);a.arc(0,
0,c,-Math.PI/2,b-Math.PI/2,!1);a.lineTo(Math.sin(b)*e,-(Math.cos(b)*e));a.arc(0,0,e,b-Math.PI/2,-Math.PI/2,!0);a.lineTo(0,-c);a.closePath();a.strokeStyle=d;a.fillStyle=a.strokeStyle;a.stroke();a.fill()},h:function(){var a=this.Nd.Hl();a.font="1em Arial";a.textAlign="left";a.textBaseline="top";a.fillStyle="#000";a.fillText(this.ka,20,20)}};var gc;
(function(){var a={},b={},c={},d={};var e=function(g,k,l){this.Iw=g;this.FG=k;this.ec=l;this.Hw=1;this.si=0};e.prototype={LA:function(g){this.Hw=this.ec/g;this.si=0},nS:function(g){this.si=g.si},call:function(g){0===g%this.Hw&&this.FG(this.Iw,this.si++)}};var f=function(g){this.ec=g;this.gx=0;this.Wg=[];this.Ir=0};f.prototype={GO:function(g){return this.Ix(g)!==d},kN:function(g){return 0<=this.Ox(g)},Bl:function(g,k,l){var G=this.Ix(l),u=new e(g,k,l);if(G===b)u.LA(this.ec);else if(G===c){var ka=this;
this.ec=l;this.nn(function(ja){ja.LA(ka.ec)});this.stop();this.start()}this.nn(function(ja){return ja.ec===l?(u.nS(ja),!0):!1});this.Wg.push(u)},detach:function(g){g=this.Ox(g);return 0<=g&&(this.Wg.splice(g,1),0===this.Wg.length)?(this.stop(),!0):!1},start:function(){var g=this;this.Ir=setInterval(function(){g.Ge()},this.ec)},stop:function(){clearInterval(this.Ir);this.Ir=0},Ge:function(){var g=this;this.gx++;this.nn(function(k){k.call(g.gx)})},Ox:function(g){for(var k=0;k<this.Wg.length;++k)if(this.Wg[k].Iw===
g)return k;return-1},nn:function(g){for(var k=0;k<this.Wg.length&&!g(this.Wg[k]);++k);},Ix:function(g){if(this.ec===g)return a;if(g/this.ec===Math.floor(g/this.ec)&&8>=g/this.ec)return b;if(this.ec/g===Math.floor(this.ec/g)&&8>=this.ec/g){var k=0;this.nn(function(l){k=Math.max(k,l.ec/g)});return 8<k?d:c}return d}};gc=function(){this.Ff=[]};gc.prototype={gS:function(g,k,l){var G=this.CI(l);null===G&&(G=new f(l),G.start(),this.Ff.push(G));G.Bl(g,k,l)},kS:function(g){var k=this.BI(g);null!==k&&k.detach(g)&&
this.fL(k)},CI:function(g){for(var k=0;k<this.Ff.length;++k)if(this.Ff[k].GO(g))return this.Ff[k];return null},BI:function(g){for(var k=0;k<this.Ff.length;++k)if(this.Ff[k].kN(g))return this.Ff[k];return null},fL:function(g){g=this.Ff.indexOf(g);0<=g&&this.Ff.splice(g,1)}}})();var yb;yb=function(a){this.Nd=a;this.ol=[]};
yb.prototype={clear:function(){this.ol=[]},count:function(){return this.ol.length},C:function(a){return this.ol[a].X},B:function(a){return this.ol[a].Y},wA:function(a,b,c){a=R.TE(this.Nd,a,b,c);this.ol.push(a)}};var zb;zb=function(a){this.Nd=a;this.Vi=[]};
zb.prototype={clear:function(){this.Vi=[]},count:function(){return this.Vi.length},$o:function(a){return this.Vi[a]},NM:function(a){this.Vi.push(a.length+1);var b;for(b=1;b<=a.length;b++){var c=R.Pg(this.Nd.getContext(),a.substring(0,b),!0);this.Vi.push(c)}a=J.Pb(this.Nd);this.Vi.push(a)}};var kf;kf=function(){this.Vy=this.Wy=this.Xy=this.Yy=this.Cx=this.Dx=this.jb=null};kf.h=function(a,b,c,d,e,f){var g=new kf;g.Vy=a;g.Wy=b;g.Xy=c;g.Yy=d;g.Cx=e;g.Dx=f;return g};
kf.prototype={Do:function(a,b){null!==this.jb?this.sL(a,b):this.mG(a)},sL:function(a,b){a.translate(b.u,b.v);a.rotate(this.jb);a.translate(-b.u,-b.v)},mG:function(a){a.transform(this.Vy,this.Wy,this.Xy,this.Yy,this.Cx,this.Dx)}};var Ka;
Ka={Ta:function(a){if(null!==a){if("false"===a.toLowerCase())return!1;if("true"===a.toLowerCase())return!0}return null},uF:function(){var a={};location.search.substr(1).split("&").forEach(function(b){b=b.split("=");a[b[0]]=b[1]});return a},pm:function(a,b){return void 0===a[b]?null:a[b]},SE:function(a){a=(new RegExp("[\\?&]"+a+"=([^&#]*)")).exec(window.location.href);return null===a?null:a[1]},Kv:function(a){var b=window.WebvisuInst;return void 0===b?Ka.SE(a):Ka.pm(b.sg,a)},Tj:function(a,b,c){return null!==
Ka.pm(a,b)?Ka.Ta(a[b]):c},kE:function(a,b){a=Ka.Kv(a);return null!==a?Ka.Ta(a):b},lE:function(a){a=Ka.Kv(a);return null!==a?parseInt(a,10):null}};var J;J=function(){};J.tS=function(){var a=window.performance||{};a.now=function(){return a.now||a.webkitNow||a.m||a.J||a.h||function(){return(new Date).getTime()}}();return a.now()};
J.iq=function(a){var b=window.location;var c=b.pathname.lastIndexOf("/");-1!==c&&(a=b.pathname.substr(0,c+1)+a,"/"===a[0]&&(a=a.substr(1)));return b.protocol+"//"+b.host+"/"+a};J.uq=function(a,b,c){var d=3,e=5;void 0===a&&(a="");void 0===d&&(d=0);void 0===e&&(e=0);void 0===b&&(b=0);void 0===c&&(c=0);a=a.split(".");b=[d,e,b,c];e=d=0;if(4!==a.length)return!1;var f=1E9;for(c=0;3>=c;c++){var g=parseInt(a[c],10);if(isNaN(g))return!1;d+=g*f;e+=b[c]*f;f/=1E3}return d>=e};J.m=function(){return(new Date).getTime()};
J.oS=function(a){if(null===a||void 0===a)return new ArrayBuffer(0);var b=new ArrayBuffer(a.length),c=new Uint8Array(b),d;var e=0;for(d=a.length;e<d;e++)c[e]=a.charCodeAt(e);return b};J.Sj=function(){return 1E3*J.tS()};J.PO=function(a,b){var c=a;var d=a.indexOf("px");-1!==d&&(c=a.slice(0,d),d=c.lastIndexOf(" "),d=-1!==d?c.slice(d+1,c.length):c,c=a.replace(d,b));return c};J.Pb=function(a){return J.Nf(a.getState().Gi)};J.Nf=function(a){return 1.15*a};J.BP=function(a){return.15*a.getState().Gi};
J.Hp=function(a){var b=0,c=0,d=a;do b+=d.offsetLeft,c+=d.offsetTop;while(null!==(d=d.offsetParent));return new Bb(b,c,b+a.offsetWidth,c+a.offsetHeight)};J.Ya=function(a,b){var c=b instanceof Bb?new I(b.u,b.v):b;a.style.position="absolute";a.style.left=Math.floor(c.X)+"px";a.style.top=Math.floor(c.Y)+"px";b instanceof Bb&&(a.style.width=Math.floor(b.C())+"px",a.style.height=Math.floor(b.B())+"px")};
J.h=function(a){var b=arguments;if(0===b.length)return"";var c=b[0];for(b=1;b<arguments.length;b++){var d=new RegExp("\\{"+(b-1)+"\\}","gi");c=c.replace(d,arguments[b])}return c};J.J=function(a){return a.cd instanceof uc};J.gQ=function(a){return J.h("{0}/{1} {2}/{3}",a.u,a.v,a.V,a.ca)};J.Uc=function(a){return J.h("{0}/{1}",a.X,a.Y)};J.qP=function(a){var b=0,c;for(c in a)a.hasOwnProperty(c)&&b++;return b};J.Sh=function(a){return a.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};
J.lm=function(a,b){var c=window.document.createElement("canvas");c.width=a;c.height=b;return c};J.eP=function(a,b,c){b=J.lm(b,c);b.style.width="100%";b.style.height="100%";b.style.left="0px";b.style.top="0px";b.style.position="absolute";b.style.margin=0;b.style.padding=0;b.id=a;return b};J.sB=function(a){return 0<a?Math.floor(a):Math.ceil(a)};J.wq=function(a){return 3<=a.length&&"SVG"===a.substring(a.length-3).toUpperCase()};
J.sm=function(a){var b=a.pageX;a=a.pageY;var c=J.qm(J.Za());return new I(b-c.X,a-c.Y)};J.qm=function(a){var b=a.getBoundingClientRect();a=void 0!==window.pageXOffset?window.pageXOffset:(document.documentElement||document.body.parentNode||document.body).scrollLeft;var c=void 0!==window.pageYOffset?window.pageYOffset:(document.documentElement||document.body.parentNode||document.body).scrollTop;b=new I(b.left,b.top);D.Vh()&&b.Yl(D.Up());return new I(b.X+a,b.Y+c)};
J.QB=function(a,b){a=a.getBoundingClientRect();if(b===document)return new I(a.left,a.top);b=b.getBoundingClientRect();return new I(b.left-a.left,b.top-a.top)};J.mC=function(a){var b="";a=new Uint8Array(a);var c=a.byteLength,d;for(d=0;d<c;d++)b+=String.fromCharCode(a[d]);return window.btoa(b)};J.KA=function(a){var b=Ga.D(4),c=Ac.D(b,!0);c.Dc(a.X);c.Dc(a.Y);return b};J.jB=function(a,b){for(b=b.parentNode;void 0!==b&&null!==b;){if(a===b)return!0;b=b.parentNode}return!1};
J.Rj=function(a,b){var c=0,d=0;null!==a&&(""!==a.style.paddingLeft&&(c=parseInt(a.style.paddingLeft,10)),""!==a.style.paddingTop&&(d=parseInt(a.style.paddingTop,10)));for(;null!==a&&a!==b;){var e=0;void 0!==a.style&&""!==a.style.borderWidth&&(e=parseInt(a.style.borderWidth,10));a.offsetLeft&&(c+=a.offsetLeft+e);a.offsetTop&&(d+=a.offsetTop+e);a=a.parentNode}return new I(c,d)};
J.$O=function(a,b){var c=0,d=0;null!==a&&a.style&&(""!==a.style.paddingLeft&&(c=parseInt(a.style.paddingLeft,10)),""!==a.style.paddingTop&&(d=parseInt(a.style.paddingTop,10)));return new I(b.X-c,b.Y-d)};J.Za=function(){return document.getElementById("cdsRoot")};J.UO=function(a,b){a.g.pa&&(a.g.Nm.Vl(),a.g.ed.Vl(),a.g.ed.Dh(b))};J.Mf=function(a){if(J.pB(a))return a.identifier;if(J.Uj(a))return a.pointerId;if(J.CP(a))return 1;throw Error("IllegalArgument!");};
J.pB=function(a){return"undefined"!==typeof Touch&&a instanceof Touch};J.qq=function(a){return 1===a.which};J.xq=function(a){return"undefined"!==typeof TouchEvent&&a instanceof TouchEvent};J.Uj=function(a){return"undefined"!==typeof PointerEvent&&a instanceof PointerEvent};J.CP=function(a){return"undefined"!==typeof MouseEvent&&a instanceof MouseEvent};J.mm=function(a,b){b=b.split("_").slice(1);try{for(var c in b){var d=a.Me(parseInt(b[c],10));a=d.ba()}}catch(e){return null}return void 0!==d?d:null};
J.XB=function(a,b){var c=[],d;for(d=0;d<=b-1;d++)c.push(a.getInt16());return c};J.gq=function(a){return a(0,0,0,[],null,!0).Ca()};J.fq=function(a,b,c){c.vr?(a.u+=Math.floor(a.C()/2)-Math.floor(b.L/2),a.V=a.u+b.L):c.Hs?a.u=a.V-b.L:a.V=a.u+b.L;c.ft?(a.v+=Math.floor(a.B()/2)-Math.floor(b.aa/2),a.ca=a.v+b.aa):c.Lq?a.v=a.ca-b.aa:a.ca=a.v+b.aa;return a};
J.GA=function(a,b,c){a.C()<b.C()&&(c.vr?a=a.Mb(Math.floor(b.C()/2)-Math.floor(a.C()/2),0):c.Hs&&(a=a.Mb(b.C()-a.C(),0)));a.B()<b.B()&&(c.ft?a=a.Mb(0,Math.floor(b.B()/2)-Math.floor(a.B()/2)):c.Lq&&(a=a.Mb(0,b.B()-a.B())));return a};J.kq=function(a){return"cdsRoot"===a.id};J.$A=function(a){return a&&"[object Date]"===Object.prototype.toString.call(a)&&!isNaN(a)};J.nm=function(a){return"object"===typeof a&&!(a instanceof Array)&&null!==a};
J.kP=function(a){var b,c="";for(b=0;b<a.length;b++)c=0===b?c+('"'+a[b]+'"'):c+(',"'+a[b]+'"');return c};J.kt=function(a,b){for(;a.lastElementChild&&!a.lastElementChild.id.startsWith(b);)a.removeChild(a.lastElementChild)};J.xa=function(a,b){return a.querySelector("#"+b)};var N,ic;N=function(){this.level=ic.km};N.m=function(a){this.level>=ic.Np&&console.info("--DEBUG--"+JSON.stringify(a))};N.info=function(a){this.level>=ic.km&&console.info("--INFO--"+JSON.stringify(a))};
N.warn=function(a){this.level>=ic.nw&&console.warn(a)};N.h=function(a){this.level>=ic.rq&&console.info("--TRACE--"+JSON.stringify(a))};N.error=function(a){this.level>=ic.uv&&console.error(a)};N.J=function(a){this.level=a};ic={PS:0,fE:1,uv:2,nw:3,km:4,Np:5,rq:6};
